#ifndef KEYBINDINGS_H
#define KEYBINDINGS_H

#include "ViewBase.h"
#include "svector.h"

struct keybindingst {
 string displayname;
 svector<unsigned int> keys;
 svector<unsigned int> coms;
 //bits 0 to 12 SDL_Key, macros store InterfaceKey values, event number when flagged
 //bit 13 event flag in keys, macro flag in coms
 //not permitted to be user bindable, see InterfaceEvents in enabler.h
 //bit 14 shift
 //bit 15 ctrl
 //bit 16 alt
 //bit 17 meta, SDL doesn't define these 2 as modifier keys but we do
 //bit 18 super
 //MACRODELAY indicates Delay in macro
 //bits 19-30 repeat count or delay value for macros, limit 1000
 //bit 31 reserved
 keybindingst(unsigned int key=0);
 ~keybindingst();
};

struct macrostackst {
 unsigned int binding; //number for the macro binding
 unsigned int position; //current position in the macro
 unsigned int repeat; //current repeat counter for repeated presses
 unsigned int nextproc; //GetTick based time to next character
 unsigned int overflow; //indicates if the nextproc overflowed

 macrostackst(unsigned int bind);
};

class interfacekeyst {
 public:
 svector<keybindingst*> bindings;
 svector<keybindingst*> macros;
 svector<macrostackst*> macrostack;
 unsigned int currentBinding;
 unsigned int currentKey;
 unsigned int altKey;
 void* currentInput;
 //uses a cast to enabler_inputst* in the code to break the circular dependency

 //when next() is called it sets the current* values
 //currentInput is set when the source of an input is a new event in the enabler
 //curentKey is the key value to be tested against bindings
 //currentBinding becomes set by the first match found with pressed()
 //once matched that is the only binding that will match until done() is called
 //macros cause currentBinding to be set in next(), a check is done for the macro_break
 //binding at that time

 interfacekeyst();
 ~interfacekeyst();

// Work functions
 int keynext();
 //returns 0 when there is no key to be processed
 int keypress(int Binding);
 //checks the keystroke for match, sets current when a match is found
 //returns value set to current
 int pressedList(const int* BindingList, int ListSize);
 //checks all keys in the list for a match returning the matched binding or 0
 void keydone();
 //clears the current key stroke and updates the processing time for repeat

//Load/Save/Display functions
 void Load(const char* filename);
 void Save(const char* filename);
 char* ConvertKeyToDisplay(char* Str, int Key);
 //sets Str to display string for an SDL_Key with mods, returns pointer to end of string
 char* ConvertKeyToSave(char* Str, int Key);
 //sets Str to save string for an SDL_Key with mods, returns pointer to end of string
 int ConvertSaveToKey(char* Str);
 //returns the key value result
 char* GetBindingDisplayName(int binding, char* Name);
 char* GetMacroDisplayName(int macro, char* Name);
 //sets Name to display text for the binding/macro returns pointer to Name
 int GetBindingKeyDisplay(int binding, char* Display, int Limit=3);
 int GetMacroKeyDisplay(int binding, char* Display, int Limit=3);
 //sets Display to , seperated list of keys, returns length of string
 //Limit 0 produces only the first key, >0 causes ... to be appeneded when there
 //are more keys than the the Limit value
 int AddMacro(char* DisplayName=0);
 //creates a new macro, defaults the name to macro %i, return new macro number
 char* ChangeBindingName(int binding, char* DisplayName);
 char* ChangeMacroName(int macro, char* DisplayName);
 //sets the name for the binding/macro to DisplayName, returns pointer to DisplayName

 //group returns count for list
 int GetBindingKeys(int binding);
 //returns count of keys, excluding events
 int GetMacroKeys(int macro);
 //returns count of keys
 int GetMacroComs(int macro);
 //returns count of commands
 int AddKeyToBinding(int binding, int key);
 //puts the key into the binding key list, maintaining events at the end of the list
 //returns count of keys, excluding events
 int AddKeyToMacro(int macro, int key);
 //puts the key into the macro binding key list
 //returns count of keys
 int AddCommandToMacro(int macro, int com);
 //puts the com into the macro coms list, com should be a binding number with repeat value
 //INTERFACEKEY_EVENTFLAG indicates macro
 int RemoveCommandFromMacro(int macro, int pos);
 //removes the com at pos from the macro coms list
 int RemoveKeyFromBinding(int binding, int key);
 int RemoveKeyFromMacro(int macro, int key);
 //scans the binding/macro key list for matching key and removes it
 int RemoveKeyPosFromBinding(int binding, int pos);
 int RemoveKeyPosFromMacro(int macro, int pos);
 //removes the key at pos from binding/macro key list
 int AdjustMacroRepeat(int macro, int pos, int Add);

 int MatchBindingName(const char* Name);
 int MatchMacroName(const char* Name);
 //returns binding number for that token or 0/INTERFACEBIND on no match

/* File format
null DISPLAYNAME indicates use default
[BIND:TOKENNAME:DISPLAYNAME]
if the binding is a macro, token name must be MACRO###

 [KEY:keydata]
 [MACRO:TOKENNAME:count]
count may be left out and defaults to 1
 [MACRO:DELAY:ms]
delay time ms is required, line is skipped when it is missing
*/
};

class viewscreen_keybindingsst : viewscreenst, ListItemCB {
 public:
  static viewscreen_keybindingsst *create(char pushtype,viewscreenst *scr=NULL);
  virtual void input();
  virtual void render();
  virtual char is_legacy_screen(){return 0;}
  virtual char is_option_screen(){return 1;}
  virtual const char* ListItem(int Index, void* Param, char* Store);

 protected:
  TabBarWidget* Tabs;
  ScrollListWidget *Bindings, *Keys, *Commands;
  void SetScrollKeys(ScrollListWidget* List);
  int DoBind;
  char Mode;
  viewscreen_keybindingsst();
  ~viewscreen_keybindingsst();
};

enum InterfaceKey {
 INTERFACEKEY_NONE=0,
 INTERFACEKEY_SELECT,
 INTERFACEKEY_DESELECT,
 INTERFACEKEY_SELECT_ALL,
 INTERFACEKEY_DESELECT_ALL,
 INTERFACEKEY_LEAVESCREEN,
 INTERFACEKEY_LEAVESCREEN_TEXT,
 INTERFACEKEY_LEAVESCREEN_ALL,
 INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT,
 INTERFACEKEY_OPTIONS,
 INTERFACEKEY_OPTION_EXPORT,
 INTERFACEKEY_HELP,
 INTERFACEKEY_TOGGLE_FULLSCREEN,
 INTERFACEKEY_MOVIES,
 INTERFACEKEY_MOVIE_RECORD,
 INTERFACEKEY_MOVIE_PLAY,
 INTERFACEKEY_MOVIE_SAVE,
 INTERFACEKEY_MOVIE_LOAD,
 INTERFACEKEY_CHANGETAB,
 INTERFACEKEY_REVERSETAB,
 INTERFACEKEY_STANDARDSCROLL_UP,    //make sure to keep the scrolling group together
 INTERFACEKEY_STANDARDSCROLL_DOWN,  //they are checked as a group for repeat timing
 INTERFACEKEY_STANDARDSCROLL_LEFT,
 INTERFACEKEY_STANDARDSCROLL_RIGHT,
 INTERFACEKEY_STANDARDSCROLL_PAGEUP,
 INTERFACEKEY_STANDARDSCROLL_PAGEDOWN,
 INTERFACEKEY_SECONDSCROLL_UP,
 INTERFACEKEY_SECONDSCROLL_DOWN,
 INTERFACEKEY_SECONDSCROLL_PAGEUP,
 INTERFACEKEY_SECONDSCROLL_PAGEDOWN,
 INTERFACEKEY_CURSOR_UP,
 INTERFACEKEY_CURSOR_DOWN,
 INTERFACEKEY_CURSOR_LEFT,
 INTERFACEKEY_CURSOR_RIGHT,
 INTERFACEKEY_CURSOR_UPLEFT,
 INTERFACEKEY_CURSOR_UPRIGHT,
 INTERFACEKEY_CURSOR_DOWNLEFT,
 INTERFACEKEY_CURSOR_DOWNRIGHT,
 INTERFACEKEY_CURSOR_UP_FAST,
 INTERFACEKEY_CURSOR_DOWN_FAST,
 INTERFACEKEY_CURSOR_LEFT_FAST,
 INTERFACEKEY_CURSOR_RIGHT_FAST,
 INTERFACEKEY_CURSOR_UPLEFT_FAST,
 INTERFACEKEY_CURSOR_UPRIGHT_FAST,
 INTERFACEKEY_CURSOR_DOWNLEFT_FAST,
 INTERFACEKEY_CURSOR_DOWNRIGHT_FAST,
 INTERFACEKEY_CURSOR_UP_Z,
 INTERFACEKEY_CURSOR_DOWN_Z,
 INTERFACEKEY_CURSOR_UP_Z_AUX,
 INTERFACEKEY_CURSOR_DOWN_Z_AUX,
 INTERFACEKEY_MENU_CONFIRM,
 INTERFACEKEY_SAVE_BINDINGS,
 INTERFACEKEY_LOAD_BINDINGS,
 INTERFACEKEY_MACRO_BREAK,

 WORLDKEY_START,
 INTERFACEKEY_WORLD_PARAM_TITLE=WORLDKEY_START,
 INTERFACEKEY_WORLD_PARAM_ADD,
 INTERFACEKEY_WORLD_PARAM_COPY,
 INTERFACEKEY_WORLD_PARAM_DELETE,
 INTERFACEKEY_WORLD_PARAM_NAME_RANDOM,
 INTERFACEKEY_WORLD_PARAM_NAME_ENTER,
 INTERFACEKEY_WORLD_PARAM_SEED_RANDOM,
 INTERFACEKEY_WORLD_PARAM_SEED_ENTER,
 INTERFACEKEY_WORLD_PARAM_LOAD,
 INTERFACEKEY_WORLD_PARAM_SAVE,
 INTERFACEKEY_WORLD_PARAM_DIM_X_UP,
 INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN,
 INTERFACEKEY_WORLD_PARAM_DIM_Y_UP,
 INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN,
 INTERFACEKEY_WORLD_PARAM_SET,
 INTERFACEKEY_WORLD_PARAM_INCREASE,
 INTERFACEKEY_WORLD_PARAM_DECREASE,
 INTERFACEKEY_WORLD_PARAM_ENTER_VALUE,
 INTERFACEKEY_WORLD_PARAM_NULLIFY,
 INTERFACEKEY_WORLD_PARAM_PRESET,
 INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE,
 INTERFACEKEY_WORLD_PARAM_REJECT_ABORT,
 INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS,
 INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL,
 INTERFACEKEY_WORLD_GEN_CONTINUE,
 INTERFACEKEY_WORLD_GEN_USE,
 INTERFACEKEY_WORLD_GEN_ABORT,
 INTERFACEKEY_WORLDGEN_EXPORT_MAP,
 INTERFACEKEY_LEGENDS_EXPORT_MAP,
 INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP,
 INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE,
 INTERFACEKEY_LEGENDS_STRING_FILTER,

 ADVENTURERKEY_START,
 INTERFACEKEY_A_MOVE_N=ADVENTURERKEY_START,
 INTERFACEKEY_A_MOVE_S,
 INTERFACEKEY_A_MOVE_E,
 INTERFACEKEY_A_MOVE_W,
 INTERFACEKEY_A_MOVE_NW,
 INTERFACEKEY_A_MOVE_NE,
 INTERFACEKEY_A_MOVE_SW,
 INTERFACEKEY_A_MOVE_SE,
 INTERFACEKEY_A_MOVE_WAIT,
 INTERFACEKEY_A_CARE_MOVE_N,
 INTERFACEKEY_A_CARE_MOVE_S,
 INTERFACEKEY_A_CARE_MOVE_E,
 INTERFACEKEY_A_CARE_MOVE_W,
 INTERFACEKEY_A_CARE_MOVE_NW,
 INTERFACEKEY_A_CARE_MOVE_NE,
 INTERFACEKEY_A_CARE_MOVE_SW,
 INTERFACEKEY_A_CARE_MOVE_SE,
 INTERFACEKEY_A_CARE_MOVE_UPDOWN,
 INTERFACEKEY_A_MOVE_N_UP,
 INTERFACEKEY_A_MOVE_S_UP,
 INTERFACEKEY_A_MOVE_E_UP,
 INTERFACEKEY_A_MOVE_W_UP,
 INTERFACEKEY_A_MOVE_NW_UP,
 INTERFACEKEY_A_MOVE_NE_UP,
 INTERFACEKEY_A_MOVE_SW_UP,
 INTERFACEKEY_A_MOVE_SE_UP,
 INTERFACEKEY_A_MOVE_UP,
 INTERFACEKEY_A_MOVE_N_DOWN,
 INTERFACEKEY_A_MOVE_S_DOWN,
 INTERFACEKEY_A_MOVE_E_DOWN,
 INTERFACEKEY_A_MOVE_W_DOWN,
 INTERFACEKEY_A_MOVE_NW_DOWN,
 INTERFACEKEY_A_MOVE_NE_DOWN,
 INTERFACEKEY_A_MOVE_SW_DOWN,
 INTERFACEKEY_A_MOVE_SE_DOWN,
 INTERFACEKEY_A_MOVE_DOWN,
 INTERFACEKEY_A_MOVE_UP_AUX,
 INTERFACEKEY_A_MOVE_DOWN_AUX,
 INTERFACEKEY_A_COMBAT_ATTACK,
 INTERFACEKEY_A_COMBAT_DODGE,
 INTERFACEKEY_A_COMBAT_CHARGEDEF,
 INTERFACEKEY_A_STATUS,
 INTERFACEKEY_A_STATUS_WRESTLE,
 INTERFACEKEY_A_STATUS_CUSTOMIZE,
 INTERFACEKEY_A_STATUS_KILLS,
 INTERFACEKEY_A_SLEEP,
 INTERFACEKEY_A_WAIT,
 INTERFACEKEY_A_ATTACK,
 INTERFACEKEY_A_LOOK,
 INTERFACEKEY_A_SEARCH,
 INTERFACEKEY_A_TALK,
 INTERFACEKEY_A_INTERACT,
 INTERFACEKEY_A_INV_LOOK,
 INTERFACEKEY_A_INV_REMOVE,
 INTERFACEKEY_A_INV_WEAR,
 INTERFACEKEY_A_INV_EATDRINK,
 INTERFACEKEY_A_INV_PUTIN,
 INTERFACEKEY_A_INV_DROP,
 INTERFACEKEY_A_GROUND,
 INTERFACEKEY_A_THROW,
 INTERFACEKEY_A_SHOOT,
 INTERFACEKEY_A_ANNOUNCEMENTS,
 INTERFACEKEY_A_COMBAT,
 INTERFACEKEY_A_MOVEMENT,
 INTERFACEKEY_A_MOVEMENT_SWIM,
 INTERFACEKEY_A_SNEAK,
 INTERFACEKEY_A_CENTER,
 INTERFACEKEY_A_BUILDING,
 INTERFACEKEY_A_TRAVEL,
 INTERFACEKEY_A_DATE,
 INTERFACEKEY_A_WEATHER,
 INTERFACEKEY_A_TEMPERATURE,
 INTERFACEKEY_A_STANCE,
 INTERFACEKEY_A_OPTION1,
 INTERFACEKEY_A_OPTION2,
 INTERFACEKEY_A_OPTION3,
 INTERFACEKEY_A_OPTION4,
 INTERFACEKEY_A_OPTION5,
 INTERFACEKEY_A_OPTION6,
 INTERFACEKEY_A_OPTION7,
 INTERFACEKEY_A_OPTION8,
 INTERFACEKEY_A_OPTION9,
 INTERFACEKEY_A_OPTION10,
 INTERFACEKEY_A_OPTION11,
 INTERFACEKEY_A_OPTION12,
 INTERFACEKEY_A_OPTION13,
 INTERFACEKEY_A_OPTION14,
 INTERFACEKEY_A_OPTION15,
 INTERFACEKEY_A_OPTION16,
 INTERFACEKEY_A_OPTION17,
 INTERFACEKEY_A_OPTION18,
 INTERFACEKEY_A_OPTION19,
 INTERFACEKEY_A_OPTION20,
 INTERFACEKEY_A_ENTER_NAME,
 INTERFACEKEY_A_CUST_NAME,
 INTERFACEKEY_A_RANDOM_NAME,
 INTERFACEKEY_A_CHANGE_GENDER,
 INTERFACEKEY_A_END_TRAVEL,
 INTERFACEKEY_A_TRAVEL_CLOUDS,
 INTERFACEKEY_A_LOG,
 INTERFACEKEY_A_TRAVEL_LOG,
 INTERFACEKEY_A_LOG_TASKS,
 INTERFACEKEY_A_LOG_ENTITIES,
 INTERFACEKEY_A_LOG_SITES,
 INTERFACEKEY_A_LOG_SUBREGIONS,
 INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION,
 INTERFACEKEY_A_LOG_ZOOM_SELECTED,
 INTERFACEKEY_A_LOG_LINE,
 INTERFACEKEY_A_LOG_MAP,
 INTERFACEKEY_A_BARTER_VIEW,
 INTERFACEKEY_A_BARTER_CURRENCY_1,
 INTERFACEKEY_A_BARTER_CURRENCY_2,
 INTERFACEKEY_A_BARTER_CURRENCY_3,
 INTERFACEKEY_A_BARTER_CURRENCY_4,
 INTERFACEKEY_A_BARTER_CURRENCY_5,
 INTERFACEKEY_A_BARTER_CURRENCY_6,
 INTERFACEKEY_A_BARTER_CURRENCY_7,
 INTERFACEKEY_A_BARTER_CURRENCY_8,
 INTERFACEKEY_A_BARTER_CURRENCY_9,
 INTERFACEKEY_A_BARTER_TRADE,

 EMBARKKEY_START,
 INTERFACEKEY_SETUP_EMBARK=EMBARKKEY_START,
 INTERFACEKEY_SETUP_NAME_FORT,
 INTERFACEKEY_SETUP_NAME_GROUP,
 INTERFACEKEY_SETUP_RECLAIM,
 INTERFACEKEY_SETUP_FIND,
 INTERFACEKEY_SETUP_NOTES,
 INTERFACEKEY_SETUP_NOTES_TAKE_NOTES,
 INTERFACEKEY_SETUP_NOTES_DELETE_NOTE,
 INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION,
 INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL,
 INTERFACEKEY_SETUP_LOCAL_Y_UP,
 INTERFACEKEY_SETUP_LOCAL_Y_DOWN,
 INTERFACEKEY_SETUP_LOCAL_X_UP,
 INTERFACEKEY_SETUP_LOCAL_X_DOWN,
 INTERFACEKEY_SETUP_LOCAL_Y_MUP,
 INTERFACEKEY_SETUP_LOCAL_Y_MDOWN,
 INTERFACEKEY_SETUP_LOCAL_X_MUP,
 INTERFACEKEY_SETUP_LOCAL_X_MDOWN,
 INTERFACEKEY_SETUP_BIOME_1,
 INTERFACEKEY_SETUP_BIOME_2,
 INTERFACEKEY_SETUP_BIOME_3,
 INTERFACEKEY_SETUP_BIOME_4,
 INTERFACEKEY_SETUP_BIOME_5,
 INTERFACEKEY_SETUP_BIOME_6,
 INTERFACEKEY_SETUP_BIOME_7,
 INTERFACEKEY_SETUP_BIOME_8,
 INTERFACEKEY_SETUP_BIOME_9,
 INTERFACEKEY_CHOOSE_NAME_RANDOM,
 INTERFACEKEY_CHOOSE_NAME_CLEAR,
 INTERFACEKEY_CHOOSE_NAME_TYPE,
 INTERFACEKEY_SETUPGAME_NEW,
 INTERFACEKEY_SETUPGAME_VIEW,
 INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT,
 INTERFACEKEY_SETUPGAME_SAVE_PROFILE,
 INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT,
 INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO,
 INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS,

 BUILDINGKEY_START,
 INTERFACEKEY_BUILDJOB_ADD=BUILDINGKEY_START,
 INTERFACEKEY_BUILDJOB_CANCEL,
 INTERFACEKEY_BUILDJOB_PROMOTE,
 INTERFACEKEY_BUILDJOB_REPEAT,
 INTERFACEKEY_BUILDJOB_SUSPEND,
 INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE,
 INTERFACEKEY_BUILDJOB_WELL_FREE,
 INTERFACEKEY_BUILDJOB_WELL_SIZE,
 INTERFACEKEY_BUILDJOB_TARGET_FREE,
 INTERFACEKEY_BUILDJOB_TARGET_SIZE,
 INTERFACEKEY_BUILDJOB_TARGET_DOWN,
 INTERFACEKEY_BUILDJOB_TARGET_UP,
 INTERFACEKEY_BUILDJOB_TARGET_RIGHT,
 INTERFACEKEY_BUILDJOB_TARGET_LEFT,
 INTERFACEKEY_BUILDJOB_STATUE_ASSIGN,
 INTERFACEKEY_BUILDJOB_STATUE_FREE,
 INTERFACEKEY_BUILDJOB_STATUE_SIZE,
 INTERFACEKEY_BUILDJOB_CAGE_JUSTICE,
 INTERFACEKEY_BUILDJOB_CAGE_FREE,
 INTERFACEKEY_BUILDJOB_CAGE_SIZE,
 INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC,
 INTERFACEKEY_BUILDJOB_CAGE_WATER,
 INTERFACEKEY_BUILDJOB_CAGE_ASSIGN,
 INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC,
 INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE,
 INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN,
 INTERFACEKEY_BUILDJOB_CHAIN_FREE,
 INTERFACEKEY_BUILDJOB_CHAIN_SIZE,
 INTERFACEKEY_BUILDJOB_SIEGE_FIRING,
 INTERFACEKEY_BUILDJOB_SIEGE_ORIENT,
 INTERFACEKEY_BUILDJOB_DOOR_INTERNAL,
 INTERFACEKEY_BUILDJOB_DOOR_LOCK,
 INTERFACEKEY_BUILDJOB_DOOR_AJAR,
 INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN,
 INTERFACEKEY_BUILDJOB_COFFIN_FREE,
 INTERFACEKEY_BUILDJOB_COFFIN_SIZE,
 INTERFACEKEY_BUILDJOB_COFFIN_BURIAL,
 INTERFACEKEY_BUILDJOB_COFFIN_CIV,
 INTERFACEKEY_BUILDJOB_COFFIN_PET,
 INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN,
 INTERFACEKEY_BUILDJOB_CHAIR_FREE,
 INTERFACEKEY_BUILDJOB_CHAIR_SIZE,
 INTERFACEKEY_BUILDJOB_TABLE_ASSIGN,
 INTERFACEKEY_BUILDJOB_TABLE_HALL,
 INTERFACEKEY_BUILDJOB_TABLE_FREE,
 INTERFACEKEY_BUILDJOB_TABLE_SIZE,
 INTERFACEKEY_BUILDJOB_BED_ASSIGN,
 INTERFACEKEY_BUILDJOB_BED_FREE,
 INTERFACEKEY_BUILDJOB_BED_BARRACKS,
 INTERFACEKEY_BUILDJOB_BED_RENT,
 INTERFACEKEY_BUILDJOB_BED_SIZE,
 INTERFACEKEY_BUILDJOB_DEPOT_BRING,
 INTERFACEKEY_BUILDJOB_DEPOT_TRADE,
 INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER,
 INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY,
 INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE,
 INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT,
 INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH,
 INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM,
 INTERFACEKEY_BUILDJOB_FARM_FALLOW,
 INTERFACEKEY_BUILDJOB_FARM_FERTILIZE,
 INTERFACEKEY_BUILDJOB_FARM_SEASFERT,
 INTERFACEKEY_BUILDJOB_FARM_SPRING,
 INTERFACEKEY_BUILDJOB_FARM_SUMMER,
 INTERFACEKEY_BUILDJOB_FARM_AUTUMN,
 INTERFACEKEY_BUILDJOB_FARM_WINTER,
 INTERFACEKEY_BUILDJOB_RACK_MAT_BONE,
 INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE,
 INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER,
 INTERFACEKEY_BUILDJOB_RACK_MAT_IRON,
 INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL,
 INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD,
 INTERFACEKEY_BUILDJOB_RACK_MAT_METAL,
 INTERFACEKEY_BUILDJOB_STAND_MAT_BONE,
 INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER,
 INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER,
 INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE,
 INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL,
 INTERFACEKEY_BUILDJOB_STAND_MAT_IRON,
 INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD,
 INTERFACEKEY_BUILDJOB_STAND_MAT_METAL,
 INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN,
 INTERFACEKEY_BUILDJOB_RACKSTAND_FREE,
 INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE,
 INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM,
 INTERFACEKEY_BUILDJOB_RACKSTAND_MAT,
 INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1,
 INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1,
 INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2,
 INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2,
 INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND,
 INTERFACEKEY_HOTKEY_BUILDING_BED,
 INTERFACEKEY_HOTKEY_BUILDING_CHAIR,
 INTERFACEKEY_HOTKEY_BUILDING_COFFIN,
 INTERFACEKEY_HOTKEY_BUILDING_DOOR,
 INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE,
 INTERFACEKEY_HOTKEY_BUILDING_HATCH,
 INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL,
 INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR,
 INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL,
 INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR,
 INTERFACEKEY_HOTKEY_BUILDING_CABINET,
 INTERFACEKEY_HOTKEY_BUILDING_BOX,
 INTERFACEKEY_HOTKEY_BUILDING_KENNEL,
 INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT,
 INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK,
 INTERFACEKEY_HOTKEY_BUILDING_STATUE,
 INTERFACEKEY_HOTKEY_BUILDING_TABLE,
 INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT,
 INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED,
 INTERFACEKEY_HOTKEY_BUILDING_BRIDGE,
 INTERFACEKEY_HOTKEY_BUILDING_WELL,
 INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE,
 INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS,
 INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM,
 INTERFACEKEY_HOTKEY_BUILDING_SHOP,
 INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP,
 INTERFACEKEY_HOTKEY_BUILDING_CHAIN,
 INTERFACEKEY_HOTKEY_BUILDING_CAGE,
 INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE,
 INTERFACEKEY_HOTKEY_BUILDING_SUPPORT,
 INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL,
 INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL,
 INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA,
 INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE,
 INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN,
 INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAB,
 INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA,
 INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA,
 INTERFACEKEY_BUILDING_DIM_Y_UP,
 INTERFACEKEY_BUILDING_DIM_Y_DOWN,
 INTERFACEKEY_BUILDING_DIM_X_UP,
 INTERFACEKEY_BUILDING_DIM_X_DOWN,
 INTERFACEKEY_BUILDING_ORIENT_UP,
 INTERFACEKEY_BUILDING_ORIENT_LEFT,
 INTERFACEKEY_BUILDING_ORIENT_RIGHT,
 INTERFACEKEY_BUILDING_ORIENT_DOWN,
 INTERFACEKEY_BUILDING_ORIENT_NONE,
 INTERFACEKEY_BUILDING_VIEW_ITEM,
 INTERFACEKEY_BUILDING_ADVANCE_STAGE,
 INTERFACEKEY_BUILDING_EXPAND_CONTRACT,
 INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER,
 INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP,
 INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN,
 INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP,
 INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN,
 INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA,
 INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP,
 INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN,
 INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP,
 INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN,
 INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE,
 INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS,
 INTERFACEKEY_BUILDING_TRIGGER_RESETS,
 INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP,
 INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN,
 INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP,
 INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN,
 INTERFACEKEY_DESTROYBUILDING,
 INTERFACEKEY_SUSPENDBUILDING,
 INTERFACEKEY_BUILDINGLIST_ZOOM_T,
 INTERFACEKEY_BUILDINGLIST_ZOOM_Q,

 WORKSHOPKEY_START,
 INTERFACEKEY_HOTKEY_MAKE_ASH=WORKSHOPKEY_START,
 INTERFACEKEY_HOTKEY_MAKE_CHARCOAL,
 INTERFACEKEY_HOTKEY_MELT_OBJECT,
 INTERFACEKEY_HOTKEY_GLASS_GREEN,
 INTERFACEKEY_HOTKEY_GLASS_CLEAR,
 INTERFACEKEY_HOTKEY_GLASS_CRYSTAL,
 INTERFACEKEY_HOTKEY_COLLECT_SAND,
 INTERFACEKEY_HOTKEY_GLASS_ROUGH,
 INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND,
 INTERFACEKEY_HOTKEY_GLASS_BOX,
 INTERFACEKEY_HOTKEY_GLASS_CABINET,
 INTERFACEKEY_HOTKEY_GLASS_COFFIN,
 INTERFACEKEY_HOTKEY_GLASS_FLOODGATE,
 INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER,
 INTERFACEKEY_HOTKEY_GLASS_GRATE,
 INTERFACEKEY_HOTKEY_GLASS_GOBLET,
 INTERFACEKEY_HOTKEY_GLASS_TOY,
 INTERFACEKEY_HOTKEY_GLASS_INSTRUMENT,
 INTERFACEKEY_HOTKEY_GLASS_DOOR,
 INTERFACEKEY_HOTKEY_GLASS_STATUE,
 INTERFACEKEY_HOTKEY_GLASS_TABLE,
 INTERFACEKEY_HOTKEY_GLASS_CAGE,
 INTERFACEKEY_HOTKEY_GLASS_CHAIR,
 INTERFACEKEY_HOTKEY_GLASS_BLOCKS,
 INTERFACEKEY_HOTKEY_GLASS_FLASK,
 INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK,
 INTERFACEKEY_HOTKEY_GLASS_WINDOW,
 INTERFACEKEY_HOTKEY_MAKE_PEARLASH,
 INTERFACEKEY_HOTKEY_ASHERY_LYE,
 INTERFACEKEY_HOTKEY_ASHERY_POTASH,
 INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT,
 INTERFACEKEY_HOTKEY_CARPENTER_BARREL,
 INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS,
 INTERFACEKEY_HOTKEY_CARPENTER_BUCKET,
 INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL,
 INTERFACEKEY_HOTKEY_CARPENTER_CAGE,
 INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND,
 INTERFACEKEY_HOTKEY_CARPENTER_BED,
 INTERFACEKEY_HOTKEY_CARPENTER_CHAIR,
 INTERFACEKEY_HOTKEY_CARPENTER_COFFIN,
 INTERFACEKEY_HOTKEY_CARPENTER_DOOR,
 INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE,
 INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER,
 INTERFACEKEY_HOTKEY_CARPENTER_GRATE,
 INTERFACEKEY_HOTKEY_CARPENTER_CABINET,
 INTERFACEKEY_HOTKEY_CARPENTER_BIN,
 INTERFACEKEY_HOTKEY_CARPENTER_BOX,
 INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK,
 INTERFACEKEY_HOTKEY_CARPENTER_TABLE,
 INTERFACEKEY_HOTKEY_SIEGE_BALLISTA,
 INTERFACEKEY_HOTKEY_SIEGE_CATAPULT,
 INTERFACEKEY_HOTKEY_LEATHER_BOX,
 INTERFACEKEY_HOTKEY_LEATHER_FLASK,
 INTERFACEKEY_HOTKEY_LEATHER_SHIRT,
 INTERFACEKEY_HOTKEY_LEATHER_CLOAK,
 INTERFACEKEY_HOTKEY_LEATHER_BACKPACK,
 INTERFACEKEY_HOTKEY_LEATHER_QUIVER,
 INTERFACEKEY_HOTKEY_LEATHER_IMAGE,
 INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT,
 INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK,
 INTERFACEKEY_HOTKEY_CLOTHES_SHIRT,
 INTERFACEKEY_HOTKEY_CLOTHES_CLOAK,
 INTERFACEKEY_HOTKEY_CLOTHES_BOX,
 INTERFACEKEY_HOTKEY_CLOTHES_CHAIN,
 INTERFACEKEY_HOTKEY_CLOTHES_IMAGE,
 INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE,
 INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD,
 INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE,
 INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL,
 INTERFACEKEY_HOTKEY_CRAFTS_TOTEM,
 INTERFACEKEY_HOTKEY_CRAFTS_CLOTH,
 INTERFACEKEY_HOTKEY_CRAFTS_SILK,
 INTERFACEKEY_HOTKEY_CRAFTS_SHELL,
 INTERFACEKEY_HOTKEY_CRAFTS_BONE,
 INTERFACEKEY_HOTKEY_CRAFTS_LEATHER,
 INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS,
 INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET,
 INTERFACEKEY_HOTKEY_CRAFTS_MAT_INSTRUMENT,
 INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY,
 INTERFACEKEY_HOTKEY_SMITH_WEAPON,
 INTERFACEKEY_HOTKEY_SMITH_ARMOR,
 INTERFACEKEY_HOTKEY_SMITH_FURNITURE,
 INTERFACEKEY_HOTKEY_SMITH_SIEGE,
 INTERFACEKEY_HOTKEY_SMITH_TRAP,
 INTERFACEKEY_HOTKEY_SMITH_OTHER,
 INTERFACEKEY_HOTKEY_SMITH_METAL,
 INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP,
 INTERFACEKEY_HOTKEY_STILL_BREW,
 INTERFACEKEY_HOTKEY_STILL_EXTRACT,
 INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK,
 INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH,
 INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK,
 INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL,
 INTERFACEKEY_HOTKEY_KITCHEN_COOK_2,
 INTERFACEKEY_HOTKEY_KITCHEN_COOK_3,
 INTERFACEKEY_HOTKEY_KITCHEN_COOK_4,
 INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT,
 INTERFACEKEY_HOTKEY_FARMER_PROCESS,
 INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL,
 INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG,
 INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL,
 INTERFACEKEY_HOTKEY_FARMER_CHEESE,
 INTERFACEKEY_HOTKEY_FARMER_MILK,
 INTERFACEKEY_HOTKEY_MILL_MILL,
 INTERFACEKEY_HOTKEY_KENNEL_TRAIN_HUNT,
 INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN,
 INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN,
 INTERFACEKEY_HOTKEY_KENNEL_TAME_UNIT,
 INTERFACEKEY_HOTKEY_KENNEL_TRAIN_WAR,
 INTERFACEKEY_HOTKEY_FISHERY_PROCESS,
 INTERFACEKEY_HOTKEY_FISHERY_EXTRACT,
 INTERFACEKEY_HOTKEY_FISHERY_CATCH,
 INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER,
 INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT,
 INTERFACEKEY_HOTKEY_BUTCHER_CATCH,
 INTERFACEKEY_HOTKEY_TANNER_TAN,
 INTERFACEKEY_HOTKEY_DYER_THREAD,
 INTERFACEKEY_HOTKEY_DYER_CLOTH,
 INTERFACEKEY_HOTKEY_JEWELER_FURNITURE,
 INTERFACEKEY_HOTKEY_JEWELER_FINISHED,
 INTERFACEKEY_HOTKEY_JEWELER_AMMO,
 INTERFACEKEY_HOTKEY_JEWELER_CUT,
 INTERFACEKEY_HOTKEY_JEWELER_ENCRUST,
 INTERFACEKEY_HOTKEY_MECHANIC_PARTS,
 INTERFACEKEY_HOTKEY_MASON_ARMORSTAND,
 INTERFACEKEY_HOTKEY_MASON_BLOCKS,
 INTERFACEKEY_HOTKEY_MASON_CHAIR,
 INTERFACEKEY_HOTKEY_MASON_COFFIN,
 INTERFACEKEY_HOTKEY_MASON_DOOR,
 INTERFACEKEY_HOTKEY_MASON_FLOODGATE,
 INTERFACEKEY_HOTKEY_MASON_HATCH_COVER,
 INTERFACEKEY_HOTKEY_MASON_GRATE,
 INTERFACEKEY_HOTKEY_MASON_CABINET,
 INTERFACEKEY_HOTKEY_MASON_BOX,
 INTERFACEKEY_HOTKEY_MASON_STATUE,
 INTERFACEKEY_HOTKEY_MASON_TABLE,
 INTERFACEKEY_HOTKEY_MASON_WEAPONRACK,
 INTERFACEKEY_HOTKEY_MASON_QUERN,
 INTERFACEKEY_HOTKEY_MASON_MILLSTONE,
 INTERFACEKEY_HOTKEY_TRAP_BRIDGE,
 INTERFACEKEY_HOTKEY_TRAP_DOOR,
 INTERFACEKEY_HOTKEY_TRAP_FLOODGATE,
 INTERFACEKEY_HOTKEY_TRAP_SPIKE,
 INTERFACEKEY_HOTKEY_TRAP_HATCH,
 INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL,
 INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR,
 INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL,
 INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR,
 INTERFACEKEY_HOTKEY_TRAP_SUPPORT,
 INTERFACEKEY_HOTKEY_TRAP_CHAIN,
 INTERFACEKEY_HOTKEY_TRAP_CAGE,
 INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY,
 INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER,

 PILEZONEKEY_START,
 INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER=PILEZONEKEY_START,
 INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD,
 INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO,
 INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX,
 INTERFACEKEY_STOCKPILE_ANIMAL,
 INTERFACEKEY_STOCKPILE_FOOD,
 INTERFACEKEY_STOCKPILE_WEAPON,
 INTERFACEKEY_STOCKPILE_ARMOR,
 INTERFACEKEY_STOCKPILE_CUSTOM,
 INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS,
 INTERFACEKEY_STOCKPILE_FURNITURE,
 INTERFACEKEY_STOCKPILE_GRAVEYARD,
 INTERFACEKEY_STOCKPILE_REFUSE,
 INTERFACEKEY_STOCKPILE_WOOD,
 INTERFACEKEY_STOCKPILE_STONE,
 INTERFACEKEY_STOCKPILE_GEM,
 INTERFACEKEY_STOCKPILE_BARBLOCK,
 INTERFACEKEY_STOCKPILE_CLOTH,
 INTERFACEKEY_STOCKPILE_LEATHER,
 INTERFACEKEY_STOCKPILE_AMMO,
 INTERFACEKEY_STOCKPILE_COINS,
 INTERFACEKEY_STOCKPILE_FINISHED,
 INTERFACEKEY_STOCKPILE_NONE,
 INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE,
 INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE,
 INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL,
 INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL,
 INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB,
 INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB,
 INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1,
 INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2,
 INTERFACEKEY_CIVZONE_REMOVE,
 INTERFACEKEY_CIVZONE_WATER_SOURCE,
 INTERFACEKEY_CIVZONE_FISH,
 INTERFACEKEY_CIVZONE_DUMP,
 INTERFACEKEY_CIVZONE_POND,
 INTERFACEKEY_CIVZONE_SAND_COLLECT,
 INTERFACEKEY_CIVZONE_ACTIVE,
 INTERFACEKEY_CIVZONE_MEETING,
 INTERFACEKEY_CIVZONE_POND_OPTIONS,
 INTERFACEKEY_CIVZONE_POND_WATER,

 STOCKORDERKEY_START,
 INTERFACEKEY_STORES_VIEW=STOCKORDERKEY_START,
 INTERFACEKEY_STORES_ZOOM,
 INTERFACEKEY_STORES_FORBID,
 INTERFACEKEY_STORES_MELT,
 INTERFACEKEY_STORES_DUMP,
 INTERFACEKEY_STORES_HIDE,
 INTERFACEKEY_PET_BUTCHER,
 INTERFACEKEY_KITCHEN_COOK,
 INTERFACEKEY_KITCHEN_BREW,
 INTERFACEKEY_ORDERS_AUTOFORBID,
 INTERFACEKEY_ORDERS_FORBID_PROJECTILE,
 INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE,
 INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS,
 INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE,
 INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS,
 INTERFACEKEY_ORDERS_REFUSE_GATHER,
 INTERFACEKEY_ORDERS_REFUSE_OUTSIDE,
 INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE,
 INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL,
 INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE,
 INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL,
 INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN,
 INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER,
 INTERFACEKEY_ORDERS_GATHER_FURNITURE,
 INTERFACEKEY_ORDERS_GATHER_ANIMALS,
 INTERFACEKEY_ORDERS_GATHER_FOOD,
 INTERFACEKEY_ORDERS_GATHER_BODIES,
 INTERFACEKEY_ORDERS_REFUSE,
 INTERFACEKEY_ORDERS_GATHER_STONE,
 INTERFACEKEY_ORDERS_GATHER_WOOD,
 INTERFACEKEY_ORDERS_ALL_HARVEST,
 INTERFACEKEY_ORDERS_INDOORS,
 INTERFACEKEY_ORDERS_SAMEPILE,
 INTERFACEKEY_ORDERS_MIXFOODS,
 INTERFACEKEY_ORDERS_LOOM,
 INTERFACEKEY_ORDERS_DYED_CLOTH,
 INTERFACEKEY_ORDERS_EXCEPTIONS,
 INTERFACEKEY_ORDERS_WORKSHOP,
 INTERFACEKEY_ORDERS_COLLECT_WEB,
 INTERFACEKEY_ORDERS_SLAUGHTER,
 INTERFACEKEY_ORDERS_BUTCHER,
 INTERFACEKEY_ORDERS_TAN,
 INTERFACEKEY_ORDERS_ZONE,
 INTERFACEKEY_ORDERS_ZONE_DRINKING,
 INTERFACEKEY_ORDERS_ZONE_FISHING,

 DWARFMAINKEY_START,
 INTERFACEKEY_D_ONESTEP=DWARFMAINKEY_START,
 INTERFACEKEY_D_PAUSE,
 INTERFACEKEY_D_DEPOT,
 INTERFACEKEY_D_HOT_KEYS,
 INTERFACEKEY_D_HOTKEY1,
 INTERFACEKEY_D_HOTKEY2,
 INTERFACEKEY_D_HOTKEY3,
 INTERFACEKEY_D_HOTKEY4,
 INTERFACEKEY_D_HOTKEY5,
 INTERFACEKEY_D_HOTKEY6,
 INTERFACEKEY_D_HOTKEY7,
 INTERFACEKEY_D_HOTKEY8,
 INTERFACEKEY_D_HOTKEY9,
 INTERFACEKEY_D_HOTKEY10,
 INTERFACEKEY_D_HOTKEY11,
 INTERFACEKEY_D_HOTKEY12,
 INTERFACEKEY_D_HOTKEY13,
 INTERFACEKEY_D_HOTKEY14,
 INTERFACEKEY_D_HOTKEY15,
 INTERFACEKEY_D_HOTKEY16,
 INTERFACEKEY_D_HOTKEY_CHANGE_NAME,
 INTERFACEKEY_D_HOTKEY_ZOOM,
 INTERFACEKEY_D_ANNOUNCE,
 INTERFACEKEY_D_BUILDING,
 INTERFACEKEY_D_CIVLIST,
 INTERFACEKEY_D_DESIGNATE,
 INTERFACEKEY_D_ARTLIST,
 INTERFACEKEY_D_NOBLES,
 INTERFACEKEY_D_ORDERS,
 INTERFACEKEY_D_MILITARY,
 INTERFACEKEY_D_ROOMS,
 INTERFACEKEY_D_SQUADS,
 INTERFACEKEY_D_STOCKPILES,
 INTERFACEKEY_D_CIVZONE,
 INTERFACEKEY_D_VIEWUNIT,
 INTERFACEKEY_D_JOBLIST,
 INTERFACEKEY_D_UNITLIST,
 INTERFACEKEY_D_LOOK,
 INTERFACEKEY_D_NOTE,
 INTERFACEKEY_D_NOTE_PLACE,
 INTERFACEKEY_D_NOTE_DELETE,
 INTERFACEKEY_D_NOTE_ENTER,
 INTERFACEKEY_D_NOTE_ADOPT_SYMBOL,
 INTERFACEKEY_D_NOTE_CHANGE_SELECTION,
 INTERFACEKEY_D_BUILDJOB,
 INTERFACEKEY_D_STATUS,
 INTERFACEKEY_D_BUILDITEM,
 INTERFACEKEY_D_VISUALIZE,
 INTERFACEKEY_D_BITEM_FORBID,
 INTERFACEKEY_D_BITEM_DUMP,
 INTERFACEKEY_D_BITEM_MELT,
 INTERFACEKEY_D_BITEM_HIDE,
 INTERFACEKEY_D_LOOK_FORBID,
 INTERFACEKEY_D_LOOK_DUMP,
 INTERFACEKEY_D_LOOK_MELT,
 INTERFACEKEY_D_LOOK_HIDE,
 INTERFACEKEY_ASSIGNTRADE_VIEW,
 INTERFACEKEY_ASSIGNTRADE_STRING,
 INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED,
 INTERFACEKEY_ASSIGNTRADE_PENDING,
 INTERFACEKEY_ASSIGNTRADE_SORT,
 INTERFACEKEY_TRADE_VIEW,
 INTERFACEKEY_TRADE_TRADE,
 INTERFACEKEY_TRADE_OFFER,
 INTERFACEKEY_TRADE_SEIZE,
 INTERFACEKEY_UNITJOB_REMOVE_CRE,
 INTERFACEKEY_UNITJOB_ZOOM_CRE,
 INTERFACEKEY_UNITJOB_ZOOM_BUILD,
 INTERFACEKEY_UNITJOB_VIEW,
 INTERFACEKEY_UNITJOB_MANAGER,
 INTERFACEKEY_MANAGER_NEW_ORDER,
 INTERFACEKEY_MANAGER_REMOVE,
 INTERFACEKEY_MANAGER_PROMOTE,
 INTERFACEKEY_MANAGER_MAX,
 INTERFACEKEY_MANAGER_WAGES,
 INTERFACEKEY_NOBLELIST_REPLACE,
 INTERFACEKEY_NOBLELIST_SETTINGS,
 INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE,
 INTERFACEKEY_DESIGNATE_BITEM,
 INTERFACEKEY_DESIGNATE_CLAIM,
 INTERFACEKEY_DESIGNATE_UNCLAIM,
 INTERFACEKEY_DESIGNATE_MELT,
 INTERFACEKEY_DESIGNATE_NO_MELT,
 INTERFACEKEY_DESIGNATE_DUMP,
 INTERFACEKEY_DESIGNATE_NO_DUMP,
 INTERFACEKEY_DESIGNATE_HIDE,
 INTERFACEKEY_DESIGNATE_NO_HIDE,
 INTERFACEKEY_DESIGNATE_DIG,
 INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS,
 INTERFACEKEY_DESIGNATE_TRAFFIC,
 INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH,
 INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL,
 INTERFACEKEY_DESIGNATE_TRAFFIC_LOW,
 INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED,
 INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT,
 INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT,
 INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE,
 INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE,
 INTERFACEKEY_DESIGNATE_STAIR_UP,
 INTERFACEKEY_DESIGNATE_STAIR_DOWN,
 INTERFACEKEY_DESIGNATE_STAIR_UPDOWN,
 INTERFACEKEY_DESIGNATE_RAMP,
 INTERFACEKEY_DESIGNATE_CHANNEL,
 INTERFACEKEY_DESIGNATE_CHOP,
 INTERFACEKEY_DESIGNATE_PLANTS,
 INTERFACEKEY_DESIGNATE_SMOOTH,
 INTERFACEKEY_DESIGNATE_ENGRAVE,
 INTERFACEKEY_DESIGNATE_FORTIFY,
 INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING,
 INTERFACEKEY_DESIGNATE_UNDO,
 INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION,
 INTERFACEKEY_ITEM_DESCRIPTION,
 INTERFACEKEY_ITEM_FORBID,
 INTERFACEKEY_ITEM_MELT,
 INTERFACEKEY_ITEM_DUMP,
 INTERFACEKEY_ITEM_HIDE,
 INTERFACEKEY_UNITVIEW_GEN,
 INTERFACEKEY_UNITVIEW_INV,
 INTERFACEKEY_UNITVIEW_PRF,
 INTERFACEKEY_UNITVIEW_WND,
 INTERFACEKEY_UNITVIEW_NEXT,
 INTERFACEKEY_UNITVIEW_SLAUGHTER,
 INTERFACEKEY_UNITVIEW_PRF_PROF,
 INTERFACEKEY_UNITVIEW_PRF_PET,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER,
 INTERFACEKEY_UNITVIEW_PRF_CASTLE,
 INTERFACEKEY_UNITVIEW_PRF_ROYAL,
 INTERFACEKEY_UNITVIEW_PRF_TOGGLESQUAD,
 INTERFACEKEY_UNITVIEW_PRF_PET_HUNT,
 INTERFACEKEY_UNITVIEW_PRF_PET_WAR,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_UNARMED,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_AXE,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_CROSSBOW,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_HAMMER,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_MACE,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_SPEAR,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_SWORD,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_WEAPONNUM,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_ARMOR,
 INTERFACEKEY_UNITVIEW_PRF_SOLDIER_SHIELD,
 INTERFACEKEY_UNITVIEW_PRF_VIEW,
 INTERFACEKEY_UNITVIEW_CUSTOMIZE,
 INTERFACEKEY_UNITVIEW_RELATIONSHIPS,
 INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM,
 INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW,
 INTERFACEKEY_UNITVIEW_KILLS,
 INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME,
 INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME,

 MILITIAKEY_START,
 INTERFACEKEY_SQUAD_LOCK=MILITIAKEY_START,
 INTERFACEKEY_SQUAD_STATION,
 INTERFACEKEY_SQUAD_CLEAR_PATROL,
 INTERFACEKEY_SQUAD_PATROL,
 INTERFACEKEY_SQUAD_ZOOM,
 INTERFACEKEY_MILITARY_ACTIVATE,
 INTERFACEKEY_MILITARY_VIEW,
 INTERFACEKEY_MILITARY_WEAPON,
 INTERFACEKEY_MILITARY_ZOOM,
 INTERFACEKEY_SQUADINFO_FOOD,
 INTERFACEKEY_SQUADINFO_SLEEP,
 INTERFACEKEY_SQUADINFO_WATER,
 INTERFACEKEY_SQUADINFO_STAYCLOSE,
 INTERFACEKEY_SQUADINFO_ATTACKWILDS,
 INTERFACEKEY_SQUADINFO_STANDDOWN,
 INTERFACEKEY_SQUADINFO_ZOOM,

//TEXTENTRY
 INTERFACEKEY_STRING_A000,
 INTERFACEKEY_STRING_A001,
 INTERFACEKEY_STRING_A002,
 INTERFACEKEY_STRING_A003,
 INTERFACEKEY_STRING_A004,
 INTERFACEKEY_STRING_A005,
 INTERFACEKEY_STRING_A006,
 INTERFACEKEY_STRING_A007,
 INTERFACEKEY_STRING_A008,
 INTERFACEKEY_STRING_A009,
 INTERFACEKEY_STRING_A010,
 INTERFACEKEY_STRING_A011,
 INTERFACEKEY_STRING_A012,
 INTERFACEKEY_STRING_A013,
 INTERFACEKEY_STRING_A014,
 INTERFACEKEY_STRING_A015,
 INTERFACEKEY_STRING_A016,
 INTERFACEKEY_STRING_A017,
 INTERFACEKEY_STRING_A018,
 INTERFACEKEY_STRING_A019,
 INTERFACEKEY_STRING_A020,
 INTERFACEKEY_STRING_A021,
 INTERFACEKEY_STRING_A022,
 INTERFACEKEY_STRING_A023,
 INTERFACEKEY_STRING_A024,
 INTERFACEKEY_STRING_A025,
 INTERFACEKEY_STRING_A026,
 INTERFACEKEY_STRING_A027,
 INTERFACEKEY_STRING_A028,
 INTERFACEKEY_STRING_A029,
 INTERFACEKEY_STRING_A030,
 INTERFACEKEY_STRING_A031,
 INTERFACEKEY_STRING_A032,
 INTERFACEKEY_STRING_A033,
 INTERFACEKEY_STRING_A034,
 INTERFACEKEY_STRING_A035,
 INTERFACEKEY_STRING_A036,
 INTERFACEKEY_STRING_A037,
 INTERFACEKEY_STRING_A038,
 INTERFACEKEY_STRING_A039,
 INTERFACEKEY_STRING_A040,
 INTERFACEKEY_STRING_A041,
 INTERFACEKEY_STRING_A042,
 INTERFACEKEY_STRING_A043,
 INTERFACEKEY_STRING_A044,
 INTERFACEKEY_STRING_A045,
 INTERFACEKEY_STRING_A046,
 INTERFACEKEY_STRING_A047,
 INTERFACEKEY_STRING_A048,
 INTERFACEKEY_STRING_A049,
 INTERFACEKEY_STRING_A050,
 INTERFACEKEY_STRING_A051,
 INTERFACEKEY_STRING_A052,
 INTERFACEKEY_STRING_A053,
 INTERFACEKEY_STRING_A054,
 INTERFACEKEY_STRING_A055,
 INTERFACEKEY_STRING_A056,
 INTERFACEKEY_STRING_A057,
 INTERFACEKEY_STRING_A058,
 INTERFACEKEY_STRING_A059,
 INTERFACEKEY_STRING_A060,
 INTERFACEKEY_STRING_A061,
 INTERFACEKEY_STRING_A062,
 INTERFACEKEY_STRING_A063,
 INTERFACEKEY_STRING_A064,
 INTERFACEKEY_STRING_A065,
 INTERFACEKEY_STRING_A066,
 INTERFACEKEY_STRING_A067,
 INTERFACEKEY_STRING_A068,
 INTERFACEKEY_STRING_A069,
 INTERFACEKEY_STRING_A070,
 INTERFACEKEY_STRING_A071,
 INTERFACEKEY_STRING_A072,
 INTERFACEKEY_STRING_A073,
 INTERFACEKEY_STRING_A074,
 INTERFACEKEY_STRING_A075,
 INTERFACEKEY_STRING_A076,
 INTERFACEKEY_STRING_A077,
 INTERFACEKEY_STRING_A078,
 INTERFACEKEY_STRING_A079,
 INTERFACEKEY_STRING_A080,
 INTERFACEKEY_STRING_A081,
 INTERFACEKEY_STRING_A082,
 INTERFACEKEY_STRING_A083,
 INTERFACEKEY_STRING_A084,
 INTERFACEKEY_STRING_A085,
 INTERFACEKEY_STRING_A086,
 INTERFACEKEY_STRING_A087,
 INTERFACEKEY_STRING_A088,
 INTERFACEKEY_STRING_A089,
 INTERFACEKEY_STRING_A090,
 INTERFACEKEY_STRING_A091,
 INTERFACEKEY_STRING_A092,
 INTERFACEKEY_STRING_A093,
 INTERFACEKEY_STRING_A094,
 INTERFACEKEY_STRING_A095,
 INTERFACEKEY_STRING_A096,
 INTERFACEKEY_STRING_A097,
 INTERFACEKEY_STRING_A098,
 INTERFACEKEY_STRING_A099,
 INTERFACEKEY_STRING_A100,
 INTERFACEKEY_STRING_A101,
 INTERFACEKEY_STRING_A102,
 INTERFACEKEY_STRING_A103,
 INTERFACEKEY_STRING_A104,
 INTERFACEKEY_STRING_A105,
 INTERFACEKEY_STRING_A106,
 INTERFACEKEY_STRING_A107,
 INTERFACEKEY_STRING_A108,
 INTERFACEKEY_STRING_A109,
 INTERFACEKEY_STRING_A110,
 INTERFACEKEY_STRING_A111,
 INTERFACEKEY_STRING_A112,
 INTERFACEKEY_STRING_A113,
 INTERFACEKEY_STRING_A114,
 INTERFACEKEY_STRING_A115,
 INTERFACEKEY_STRING_A116,
 INTERFACEKEY_STRING_A117,
 INTERFACEKEY_STRING_A118,
 INTERFACEKEY_STRING_A119,
 INTERFACEKEY_STRING_A120,
 INTERFACEKEY_STRING_A121,
 INTERFACEKEY_STRING_A122,
 INTERFACEKEY_STRING_A123,
 INTERFACEKEY_STRING_A124,
 INTERFACEKEY_STRING_A125,
 INTERFACEKEY_STRING_A126,
 INTERFACEKEY_STRING_A127,
 INTERFACEKEY_STRING_A128,
 INTERFACEKEY_STRING_A129,
 INTERFACEKEY_STRING_A130,
 INTERFACEKEY_STRING_A131,
 INTERFACEKEY_STRING_A132,
 INTERFACEKEY_STRING_A133,
 INTERFACEKEY_STRING_A134,
 INTERFACEKEY_STRING_A135,
 INTERFACEKEY_STRING_A136,
 INTERFACEKEY_STRING_A137,
 INTERFACEKEY_STRING_A138,
 INTERFACEKEY_STRING_A139,
 INTERFACEKEY_STRING_A140,
 INTERFACEKEY_STRING_A141,
 INTERFACEKEY_STRING_A142,
 INTERFACEKEY_STRING_A143,
 INTERFACEKEY_STRING_A144,
 INTERFACEKEY_STRING_A145,
 INTERFACEKEY_STRING_A146,
 INTERFACEKEY_STRING_A147,
 INTERFACEKEY_STRING_A148,
 INTERFACEKEY_STRING_A149,
 INTERFACEKEY_STRING_A150,
 INTERFACEKEY_STRING_A151,
 INTERFACEKEY_STRING_A152,
 INTERFACEKEY_STRING_A153,
 INTERFACEKEY_STRING_A154,
 INTERFACEKEY_STRING_A155,
 INTERFACEKEY_STRING_A156,
 INTERFACEKEY_STRING_A157,
 INTERFACEKEY_STRING_A158,
 INTERFACEKEY_STRING_A159,
 INTERFACEKEY_STRING_A160,
 INTERFACEKEY_STRING_A161,
 INTERFACEKEY_STRING_A162,
 INTERFACEKEY_STRING_A163,
 INTERFACEKEY_STRING_A164,
 INTERFACEKEY_STRING_A165,
 INTERFACEKEY_STRING_A166,
 INTERFACEKEY_STRING_A167,
 INTERFACEKEY_STRING_A168,
 INTERFACEKEY_STRING_A169,
 INTERFACEKEY_STRING_A170,
 INTERFACEKEY_STRING_A171,
 INTERFACEKEY_STRING_A172,
 INTERFACEKEY_STRING_A173,
 INTERFACEKEY_STRING_A174,
 INTERFACEKEY_STRING_A175,
 INTERFACEKEY_STRING_A176,
 INTERFACEKEY_STRING_A177,
 INTERFACEKEY_STRING_A178,
 INTERFACEKEY_STRING_A179,
 INTERFACEKEY_STRING_A180,
 INTERFACEKEY_STRING_A181,
 INTERFACEKEY_STRING_A182,
 INTERFACEKEY_STRING_A183,
 INTERFACEKEY_STRING_A184,
 INTERFACEKEY_STRING_A185,
 INTERFACEKEY_STRING_A186,
 INTERFACEKEY_STRING_A187,
 INTERFACEKEY_STRING_A188,
 INTERFACEKEY_STRING_A189,
 INTERFACEKEY_STRING_A190,
 INTERFACEKEY_STRING_A191,
 INTERFACEKEY_STRING_A192,
 INTERFACEKEY_STRING_A193,
 INTERFACEKEY_STRING_A194,
 INTERFACEKEY_STRING_A195,
 INTERFACEKEY_STRING_A196,
 INTERFACEKEY_STRING_A197,
 INTERFACEKEY_STRING_A198,
 INTERFACEKEY_STRING_A199,
 INTERFACEKEY_STRING_A200,
 INTERFACEKEY_STRING_A201,
 INTERFACEKEY_STRING_A202,
 INTERFACEKEY_STRING_A203,
 INTERFACEKEY_STRING_A204,
 INTERFACEKEY_STRING_A205,
 INTERFACEKEY_STRING_A206,
 INTERFACEKEY_STRING_A207,
 INTERFACEKEY_STRING_A208,
 INTERFACEKEY_STRING_A209,
 INTERFACEKEY_STRING_A210,
 INTERFACEKEY_STRING_A211,
 INTERFACEKEY_STRING_A212,
 INTERFACEKEY_STRING_A213,
 INTERFACEKEY_STRING_A214,
 INTERFACEKEY_STRING_A215,
 INTERFACEKEY_STRING_A216,
 INTERFACEKEY_STRING_A217,
 INTERFACEKEY_STRING_A218,
 INTERFACEKEY_STRING_A219,
 INTERFACEKEY_STRING_A220,
 INTERFACEKEY_STRING_A221,
 INTERFACEKEY_STRING_A222,
 INTERFACEKEY_STRING_A223,
 INTERFACEKEY_STRING_A224,
 INTERFACEKEY_STRING_A225,
 INTERFACEKEY_STRING_A226,
 INTERFACEKEY_STRING_A227,
 INTERFACEKEY_STRING_A228,
 INTERFACEKEY_STRING_A229,
 INTERFACEKEY_STRING_A230,
 INTERFACEKEY_STRING_A231,
 INTERFACEKEY_STRING_A232,
 INTERFACEKEY_STRING_A233,
 INTERFACEKEY_STRING_A234,
 INTERFACEKEY_STRING_A235,
 INTERFACEKEY_STRING_A236,
 INTERFACEKEY_STRING_A237,
 INTERFACEKEY_STRING_A238,
 INTERFACEKEY_STRING_A239,
 INTERFACEKEY_STRING_A240,
 INTERFACEKEY_STRING_A241,
 INTERFACEKEY_STRING_A242,
 INTERFACEKEY_STRING_A243,
 INTERFACEKEY_STRING_A244,
 INTERFACEKEY_STRING_A245,
 INTERFACEKEY_STRING_A246,
 INTERFACEKEY_STRING_A247,
 INTERFACEKEY_STRING_A248,
 INTERFACEKEY_STRING_A249,
 INTERFACEKEY_STRING_A250,
 INTERFACEKEY_STRING_A251,
 INTERFACEKEY_STRING_A252,
 INTERFACEKEY_STRING_A253,
 INTERFACEKEY_STRING_A254,
 INTERFACEKEY_STRING_A255,
 INTERFACEKEYNUM
};
#endif
