#include "keybindings.h"

#include <SDL/SDL.h>

using namespace std;

bimap<InterfaceKey,std::string> bindingNames;
bimap<SDLKey,std::string> sdlNames;


void keybinding_init() {
  bindingNames.insert(INTERFACEKEY_NONE, "NONE");
  bindingNames.insert(INTERFACEKEY_SELECT, "SELECT");
  bindingNames.insert(INTERFACEKEY_DESELECT, "DESELECT");
  bindingNames.insert(INTERFACEKEY_SELECT_ALL, "SELECT_ALL");
  bindingNames.insert(INTERFACEKEY_DESELECT_ALL, "DESELECT_ALL");
  bindingNames.insert(INTERFACEKEY_LEAVESCREEN, "LEAVESCREEN");
  bindingNames.insert(INTERFACEKEY_LEAVESCREEN_TEXT, "LEAVESCREEN_TEXT");
  bindingNames.insert(INTERFACEKEY_LEAVESCREEN_ALL, "LEAVESCREEN_ALL");
  bindingNames.insert(INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT, "CLOSE_MEGA_ANNOUNCEMENT");
  bindingNames.insert(INTERFACEKEY_OPTION_EXPORT, "OPTION_EXPORT");
  bindingNames.insert(INTERFACEKEY_OPTION_EXPORT_RAW_INFO, "OPTION_EXPORT_RAW_INFO");
  bindingNames.insert(INTERFACEKEY_OPTIONS, "OPTIONS");
  bindingNames.insert(INTERFACEKEY_HELP, "HELP");
  bindingNames.insert(INTERFACEKEY_TOGGLE_FULLSCREEN, "TOGGLE_FULLSCREEN");
  bindingNames.insert(INTERFACEKEY_MOVIES, "MOVIES");
  bindingNames.insert(INTERFACEKEY_ZOOM_IN, "ZOOM_IN");
  bindingNames.insert(INTERFACEKEY_ZOOM_OUT, "ZOOM_OUT");
  bindingNames.insert(INTERFACEKEY_ZOOM_TOGGLE, "ZOOM_TOGGLE");
  bindingNames.insert(INTERFACEKEY_ZOOM_RESET, "ZOOM_RESET");
  bindingNames.insert(INTERFACEKEY_MOVIE_RECORD, "MOVIE_RECORD");
  bindingNames.insert(INTERFACEKEY_MOVIE_PLAY, "MOVIE_PLAY");
  bindingNames.insert(INTERFACEKEY_MOVIE_SAVE, "MOVIE_SAVE");
  bindingNames.insert(INTERFACEKEY_MOVIE_LOAD, "MOVIE_LOAD");
  bindingNames.insert(INTERFACEKEY_CHANGETAB, "CHANGETAB");
  bindingNames.insert(INTERFACEKEY_REVERSETAB, "REVERSETAB");
  bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_UP, "STANDARDSCROLL_UP");
  bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_DOWN, "STANDARDSCROLL_DOWN");
  bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_LEFT, "STANDARDSCROLL_LEFT");
  bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_RIGHT, "STANDARDSCROLL_RIGHT");
  bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_PAGEUP, "STANDARDSCROLL_PAGEUP");
  bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_PAGEDOWN, "STANDARDSCROLL_PAGEDOWN");
  bindingNames.insert(INTERFACEKEY_SECONDSCROLL_UP, "SECONDSCROLL_UP");
  bindingNames.insert(INTERFACEKEY_SECONDSCROLL_DOWN, "SECONDSCROLL_DOWN");
  bindingNames.insert(INTERFACEKEY_SECONDSCROLL_PAGEUP, "SECONDSCROLL_PAGEUP");
  bindingNames.insert(INTERFACEKEY_SECONDSCROLL_PAGEDOWN, "SECONDSCROLL_PAGEDOWN");
  bindingNames.insert(INTERFACEKEY_CURSOR_UP, "CURSOR_UP");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWN, "CURSOR_DOWN");
  bindingNames.insert(INTERFACEKEY_CURSOR_LEFT, "CURSOR_LEFT");
  bindingNames.insert(INTERFACEKEY_CURSOR_RIGHT, "CURSOR_RIGHT");
  bindingNames.insert(INTERFACEKEY_CURSOR_UPLEFT, "CURSOR_UPLEFT");
  bindingNames.insert(INTERFACEKEY_CURSOR_UPRIGHT, "CURSOR_UPRIGHT");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWNLEFT, "CURSOR_DOWNLEFT");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWNRIGHT, "CURSOR_DOWNRIGHT");
  bindingNames.insert(INTERFACEKEY_CURSOR_UP_FAST, "CURSOR_UP_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWN_FAST, "CURSOR_DOWN_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_LEFT_FAST, "CURSOR_LEFT_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_RIGHT_FAST, "CURSOR_RIGHT_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_UPLEFT_FAST, "CURSOR_UPLEFT_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_UPRIGHT_FAST, "CURSOR_UPRIGHT_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWNLEFT_FAST, "CURSOR_DOWNLEFT_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWNRIGHT_FAST, "CURSOR_DOWNRIGHT_FAST");
  bindingNames.insert(INTERFACEKEY_CURSOR_UP_Z, "CURSOR_UP_Z");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWN_Z, "CURSOR_DOWN_Z");
  bindingNames.insert(INTERFACEKEY_CURSOR_UP_Z_AUX, "CURSOR_UP_Z_AUX");
  bindingNames.insert(INTERFACEKEY_CURSOR_DOWN_Z_AUX, "CURSOR_DOWN_Z_AUX");
  bindingNames.insert(INTERFACEKEY_MENU_CONFIRM, "MENU_CONFIRM");
  bindingNames.insert(INTERFACEKEY_SAVE_BINDINGS, "SAVE_BINDINGS");
  bindingNames.insert(INTERFACEKEY_LOAD_BINDINGS, "LOAD_BINDINGS");
  bindingNames.insert(INTERFACEKEY_MACRO_BREAK, "MACRO_BREAK");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_TITLE, "WORLD_PARAM_TITLE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_ADD, "WORLD_PARAM_ADD");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_COPY, "WORLD_PARAM_COPY");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DELETE, "WORLD_PARAM_DELETE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_NAME_RANDOM, "WORLD_PARAM_NAME_RANDOM");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_NAME_ENTER, "WORLD_PARAM_NAME_ENTER");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SEED_RANDOM, "WORLD_PARAM_SEED_RANDOM");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SEED_ENTER, "WORLD_PARAM_SEED_ENTER");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_LOAD, "WORLD_PARAM_LOAD");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SAVE, "WORLD_PARAM_SAVE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_X_UP, "WORLD_PARAM_DIM_X_UP");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN, "WORLD_PARAM_DIM_X_DOWN");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_Y_UP, "WORLD_PARAM_DIM_Y_UP");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN, "WORLD_PARAM_DIM_Y_DOWN");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SET, "WORLD_PARAM_SET");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_INCREASE, "WORLD_PARAM_INCREASE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DECREASE, "WORLD_PARAM_DECREASE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_ENTER_VALUE, "WORLD_PARAM_ENTER_VALUE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_NULLIFY, "WORLD_PARAM_NULLIFY");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_PRESET, "WORLD_PARAM_PRESET");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE, "WORLD_PARAM_REJECT_CONTINUE");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ABORT, "WORLD_PARAM_REJECT_ABORT");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS, "WORLD_PARAM_REJECT_ALLOW_THIS");
  bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL, "WORLD_PARAM_REJECT_ALLOW_ALL");
  bindingNames.insert(INTERFACEKEY_WORLD_GEN_CONTINUE, "WORLD_GEN_CONTINUE");
  bindingNames.insert(INTERFACEKEY_WORLD_GEN_USE, "WORLD_GEN_USE");
  bindingNames.insert(INTERFACEKEY_WORLD_GEN_ABORT, "WORLD_GEN_ABORT");
  bindingNames.insert(INTERFACEKEY_WORLDGEN_EXPORT_MAP, "WORLDGEN_EXPORT_MAP");
  bindingNames.insert(INTERFACEKEY_LEGENDS_EXPORT_MAP, "LEGENDS_EXPORT_MAP");
  bindingNames.insert(INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP, "LEGENDS_EXPORT_DETAILED_MAP");
  bindingNames.insert(INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE, "LEGENDS_TOGGLE_CIVSITE");
  bindingNames.insert(INTERFACEKEY_LEGENDS_STRING_FILTER, "LEGENDS_STRING_FILTER");
  bindingNames.insert(INTERFACEKEY_A_MOVE_N, "A_MOVE_N");
  bindingNames.insert(INTERFACEKEY_A_MOVE_S, "A_MOVE_S");
  bindingNames.insert(INTERFACEKEY_A_MOVE_E, "A_MOVE_E");
  bindingNames.insert(INTERFACEKEY_A_MOVE_W, "A_MOVE_W");
  bindingNames.insert(INTERFACEKEY_A_MOVE_NW, "A_MOVE_NW");
  bindingNames.insert(INTERFACEKEY_A_MOVE_NE, "A_MOVE_NE");
  bindingNames.insert(INTERFACEKEY_A_MOVE_SW, "A_MOVE_SW");
  bindingNames.insert(INTERFACEKEY_A_MOVE_SE, "A_MOVE_SE");
  bindingNames.insert(INTERFACEKEY_A_MOVE_WAIT, "A_MOVE_WAIT");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_N, "A_CARE_MOVE_N");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_S, "A_CARE_MOVE_S");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_E, "A_CARE_MOVE_E");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_W, "A_CARE_MOVE_W");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_NW, "A_CARE_MOVE_NW");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_NE, "A_CARE_MOVE_NE");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_SW, "A_CARE_MOVE_SW");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_SE, "A_CARE_MOVE_SE");
  bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_UPDOWN, "A_CARE_MOVE_UPDOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_N_UP, "A_MOVE_N_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_S_UP, "A_MOVE_S_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_E_UP, "A_MOVE_E_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_W_UP, "A_MOVE_W_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_NW_UP, "A_MOVE_NW_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_NE_UP, "A_MOVE_NE_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_SW_UP, "A_MOVE_SW_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_SE_UP, "A_MOVE_SE_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_UP, "A_MOVE_UP");
  bindingNames.insert(INTERFACEKEY_A_MOVE_N_DOWN, "A_MOVE_N_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_S_DOWN, "A_MOVE_S_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_E_DOWN, "A_MOVE_E_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_W_DOWN, "A_MOVE_W_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_NW_DOWN, "A_MOVE_NW_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_NE_DOWN, "A_MOVE_NE_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_SW_DOWN, "A_MOVE_SW_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_SE_DOWN, "A_MOVE_SE_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_DOWN, "A_MOVE_DOWN");
  bindingNames.insert(INTERFACEKEY_A_MOVE_UP_AUX, "A_MOVE_UP_AUX");
  bindingNames.insert(INTERFACEKEY_A_MOVE_DOWN_AUX, "A_MOVE_DOWN_AUX");
  bindingNames.insert(INTERFACEKEY_A_COMBAT_ATTACK, "A_COMBAT_ATTACK");
  bindingNames.insert(INTERFACEKEY_A_COMBAT_DODGE, "A_COMBAT_DODGE");
  bindingNames.insert(INTERFACEKEY_A_COMBAT_CHARGEDEF, "A_COMBAT_CHARGEDEF");
  bindingNames.insert(INTERFACEKEY_A_STATUS, "A_STATUS");
  bindingNames.insert(INTERFACEKEY_A_STATUS_WRESTLE, "A_STATUS_WRESTLE");
  bindingNames.insert(INTERFACEKEY_A_STATUS_CUSTOMIZE, "A_STATUS_CUSTOMIZE");
  bindingNames.insert(INTERFACEKEY_A_STATUS_KILLS, "A_STATUS_KILLS");
  bindingNames.insert(INTERFACEKEY_A_SLEEP, "A_SLEEP");
  bindingNames.insert(INTERFACEKEY_A_WAIT, "A_WAIT");
  bindingNames.insert(INTERFACEKEY_A_ATTACK, "A_ATTACK");
  bindingNames.insert(INTERFACEKEY_A_LOOK, "A_LOOK");
  bindingNames.insert(INTERFACEKEY_A_SEARCH, "A_SEARCH");
  bindingNames.insert(INTERFACEKEY_A_TALK, "A_TALK");
  bindingNames.insert(INTERFACEKEY_A_INTERACT, "A_INTERACT");
  bindingNames.insert(INTERFACEKEY_A_INV_LOOK, "A_INV_LOOK");
  bindingNames.insert(INTERFACEKEY_A_INV_REMOVE, "A_INV_REMOVE");
  bindingNames.insert(INTERFACEKEY_A_INV_WEAR, "A_INV_WEAR");
  bindingNames.insert(INTERFACEKEY_A_INV_EATDRINK, "A_INV_EATDRINK");
  bindingNames.insert(INTERFACEKEY_A_INV_PUTIN, "A_INV_PUTIN");
  bindingNames.insert(INTERFACEKEY_A_INV_DROP, "A_INV_DROP");
  bindingNames.insert(INTERFACEKEY_A_GROUND, "A_GROUND");
  bindingNames.insert(INTERFACEKEY_A_THROW, "A_THROW");
  bindingNames.insert(INTERFACEKEY_A_SHOOT, "A_SHOOT");
  bindingNames.insert(INTERFACEKEY_A_ANNOUNCEMENTS, "A_ANNOUNCEMENTS");
  bindingNames.insert(INTERFACEKEY_A_COMBAT, "A_COMBAT");
  bindingNames.insert(INTERFACEKEY_A_MOVEMENT, "A_MOVEMENT");
  bindingNames.insert(INTERFACEKEY_A_MOVEMENT_SWIM, "A_MOVEMENT_SWIM");
  bindingNames.insert(INTERFACEKEY_A_SNEAK, "A_SNEAK");
  bindingNames.insert(INTERFACEKEY_A_CENTER, "A_CENTER");
  bindingNames.insert(INTERFACEKEY_A_BUILDING, "A_BUILDING");
  bindingNames.insert(INTERFACEKEY_A_TRAVEL, "A_TRAVEL");
  bindingNames.insert(INTERFACEKEY_A_DATE, "A_DATE");
  bindingNames.insert(INTERFACEKEY_A_WEATHER, "A_WEATHER");
  bindingNames.insert(INTERFACEKEY_A_TEMPERATURE, "A_TEMPERATURE");
  bindingNames.insert(INTERFACEKEY_A_STANCE, "A_STANCE");
  bindingNames.insert(INTERFACEKEY_A_OPTION1, "A_OPTION1");
  bindingNames.insert(INTERFACEKEY_A_OPTION2, "A_OPTION2");
  bindingNames.insert(INTERFACEKEY_A_OPTION3, "A_OPTION3");
  bindingNames.insert(INTERFACEKEY_A_OPTION4, "A_OPTION4");
  bindingNames.insert(INTERFACEKEY_A_OPTION5, "A_OPTION5");
  bindingNames.insert(INTERFACEKEY_A_OPTION6, "A_OPTION6");
  bindingNames.insert(INTERFACEKEY_A_OPTION7, "A_OPTION7");
  bindingNames.insert(INTERFACEKEY_A_OPTION8, "A_OPTION8");
  bindingNames.insert(INTERFACEKEY_A_OPTION9, "A_OPTION9");
  bindingNames.insert(INTERFACEKEY_A_OPTION10, "A_OPTION10");
  bindingNames.insert(INTERFACEKEY_A_OPTION11, "A_OPTION11");
  bindingNames.insert(INTERFACEKEY_A_OPTION12, "A_OPTION12");
  bindingNames.insert(INTERFACEKEY_A_OPTION13, "A_OPTION13");
  bindingNames.insert(INTERFACEKEY_A_OPTION14, "A_OPTION14");
  bindingNames.insert(INTERFACEKEY_A_OPTION15, "A_OPTION15");
  bindingNames.insert(INTERFACEKEY_A_OPTION16, "A_OPTION16");
  bindingNames.insert(INTERFACEKEY_A_OPTION17, "A_OPTION17");
  bindingNames.insert(INTERFACEKEY_A_OPTION18, "A_OPTION18");
  bindingNames.insert(INTERFACEKEY_A_OPTION19, "A_OPTION19");
  bindingNames.insert(INTERFACEKEY_A_OPTION20, "A_OPTION20");
  bindingNames.insert(INTERFACEKEY_A_ENTER_NAME, "A_ENTER_NAME");
  bindingNames.insert(INTERFACEKEY_A_CUST_NAME, "A_CUST_NAME");
  bindingNames.insert(INTERFACEKEY_A_RANDOM_NAME, "A_RANDOM_NAME");
  bindingNames.insert(INTERFACEKEY_A_CHANGE_GENDER, "A_CHANGE_GENDER");
  bindingNames.insert(INTERFACEKEY_A_END_TRAVEL, "A_END_TRAVEL");
  bindingNames.insert(INTERFACEKEY_A_TRAVEL_CLOUDS, "A_TRAVEL_CLOUDS");
  bindingNames.insert(INTERFACEKEY_A_LOG, "A_LOG");
  bindingNames.insert(INTERFACEKEY_A_TRAVEL_LOG, "A_TRAVEL_LOG");
  bindingNames.insert(INTERFACEKEY_A_LOG_TASKS, "A_LOG_TASKS");
  bindingNames.insert(INTERFACEKEY_A_LOG_ENTITIES, "A_LOG_ENTITIES");
  bindingNames.insert(INTERFACEKEY_A_LOG_SITES, "A_LOG_SITES");
  bindingNames.insert(INTERFACEKEY_A_LOG_SUBREGIONS, "A_LOG_SUBREGIONS");
  bindingNames.insert(INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION, "A_LOG_ZOOM_CURRENT_LOCATION");
  bindingNames.insert(INTERFACEKEY_A_LOG_ZOOM_SELECTED, "A_LOG_ZOOM_SELECTED");
  bindingNames.insert(INTERFACEKEY_A_LOG_LINE, "A_LOG_LINE");
  bindingNames.insert(INTERFACEKEY_A_LOG_MAP, "A_LOG_MAP");
  bindingNames.insert(INTERFACEKEY_A_BARTER_VIEW, "A_BARTER_VIEW");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_1, "A_BARTER_CURRENCY_1");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_2, "A_BARTER_CURRENCY_2");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_3, "A_BARTER_CURRENCY_3");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_4, "A_BARTER_CURRENCY_4");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_5, "A_BARTER_CURRENCY_5");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_6, "A_BARTER_CURRENCY_6");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_7, "A_BARTER_CURRENCY_7");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_8, "A_BARTER_CURRENCY_8");
  bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_9, "A_BARTER_CURRENCY_9");
  bindingNames.insert(INTERFACEKEY_A_BARTER_TRADE, "A_BARTER_TRADE");
  bindingNames.insert(INTERFACEKEY_SETUP_EMBARK, "SETUP_EMBARK");
  bindingNames.insert(INTERFACEKEY_SETUP_NAME_FORT, "SETUP_NAME_FORT");
  bindingNames.insert(INTERFACEKEY_SETUP_NAME_GROUP, "SETUP_NAME_GROUP");
  bindingNames.insert(INTERFACEKEY_SETUP_RECLAIM, "SETUP_RECLAIM");
  bindingNames.insert(INTERFACEKEY_SETUP_FIND, "SETUP_FIND");
  bindingNames.insert(INTERFACEKEY_SETUP_NOTES, "SETUP_NOTES");
  bindingNames.insert(INTERFACEKEY_SETUP_NOTES_TAKE_NOTES, "SETUP_NOTES_TAKE_NOTES");
  bindingNames.insert(INTERFACEKEY_SETUP_NOTES_DELETE_NOTE, "SETUP_NOTES_DELETE_NOTE");
  bindingNames.insert(INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION, "SETUP_NOTES_CHANGE_SYMBOL_SELECTION");
  bindingNames.insert(INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL, "SETUP_NOTES_ADOPT_SYMBOL");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_UP, "SETUP_LOCAL_Y_UP");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_DOWN, "SETUP_LOCAL_Y_DOWN");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_UP, "SETUP_LOCAL_X_UP");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_DOWN, "SETUP_LOCAL_X_DOWN");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_MUP, "SETUP_LOCAL_Y_MUP");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_MDOWN, "SETUP_LOCAL_Y_MDOWN");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_MUP, "SETUP_LOCAL_X_MUP");
  bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_MDOWN, "SETUP_LOCAL_X_MDOWN");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_1, "SETUP_BIOME_1");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_2, "SETUP_BIOME_2");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_3, "SETUP_BIOME_3");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_4, "SETUP_BIOME_4");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_5, "SETUP_BIOME_5");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_6, "SETUP_BIOME_6");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_7, "SETUP_BIOME_7");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_8, "SETUP_BIOME_8");
  bindingNames.insert(INTERFACEKEY_SETUP_BIOME_9, "SETUP_BIOME_9");
  bindingNames.insert(INTERFACEKEY_CHOOSE_NAME_RANDOM, "CHOOSE_NAME_RANDOM");
  bindingNames.insert(INTERFACEKEY_CHOOSE_NAME_CLEAR, "CHOOSE_NAME_CLEAR");
  bindingNames.insert(INTERFACEKEY_CHOOSE_NAME_TYPE, "CHOOSE_NAME_TYPE");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_NEW, "SETUPGAME_NEW");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_VIEW, "SETUPGAME_VIEW");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT, "SETUPGAME_CUSTOMIZE_UNIT");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE, "SETUPGAME_SAVE_PROFILE");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT, "SETUPGAME_SAVE_PROFILE_ABORT");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO, "SETUPGAME_SAVE_PROFILE_GO");
  bindingNames.insert(INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS, "SETUPGAME_VIEW_PROFILE_PROBLEMS");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_ADD, "BUILDJOB_ADD");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CANCEL, "BUILDJOB_CANCEL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_PROMOTE, "BUILDJOB_PROMOTE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_REPEAT, "BUILDJOB_REPEAT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_SUSPEND, "BUILDJOB_SUSPEND");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE, "BUILDJOB_WORKSHOP_PROFILE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_WELL_FREE, "BUILDJOB_WELL_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_WELL_SIZE, "BUILDJOB_WELL_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_FREE, "BUILDJOB_TARGET_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_SIZE, "BUILDJOB_TARGET_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_DOWN, "BUILDJOB_TARGET_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_UP, "BUILDJOB_TARGET_UP");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_RIGHT, "BUILDJOB_TARGET_RIGHT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_LEFT, "BUILDJOB_TARGET_LEFT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STATUE_ASSIGN, "BUILDJOB_STATUE_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STATUE_FREE, "BUILDJOB_STATUE_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STATUE_SIZE, "BUILDJOB_STATUE_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_JUSTICE, "BUILDJOB_CAGE_JUSTICE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_FREE, "BUILDJOB_CAGE_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_SIZE, "BUILDJOB_CAGE_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC, "BUILDJOB_CAGE_ASSIGN_OCC");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_WATER, "BUILDJOB_CAGE_WATER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_ASSIGN, "BUILDJOB_CAGE_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC, "BUILDJOB_CHAIN_ASSIGN_OCC");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE, "BUILDJOB_CHAIN_JUSTICE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN, "BUILDJOB_CHAIN_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_FREE, "BUILDJOB_CHAIN_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_SIZE, "BUILDJOB_CHAIN_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_SIEGE_FIRING, "BUILDJOB_SIEGE_FIRING");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_SIEGE_ORIENT, "BUILDJOB_SIEGE_ORIENT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DOOR_INTERNAL, "BUILDJOB_DOOR_INTERNAL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DOOR_LOCK, "BUILDJOB_DOOR_LOCK");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DOOR_AJAR, "BUILDJOB_DOOR_AJAR");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN, "BUILDJOB_COFFIN_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_FREE, "BUILDJOB_COFFIN_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_SIZE, "BUILDJOB_COFFIN_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_BURIAL, "BUILDJOB_COFFIN_BURIAL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_CIV, "BUILDJOB_COFFIN_CIV");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_PET, "BUILDJOB_COFFIN_PET");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN, "BUILDJOB_CHAIR_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_FREE, "BUILDJOB_CHAIR_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_SIZE, "BUILDJOB_CHAIR_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_ASSIGN, "BUILDJOB_TABLE_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_HALL, "BUILDJOB_TABLE_HALL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_FREE, "BUILDJOB_TABLE_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_SIZE, "BUILDJOB_TABLE_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_ASSIGN, "BUILDJOB_BED_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_FREE, "BUILDJOB_BED_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_BARRACKS, "BUILDJOB_BED_BARRACKS");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_RENT, "BUILDJOB_BED_RENT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_SIZE, "BUILDJOB_BED_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_BRING, "BUILDJOB_DEPOT_BRING");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_TRADE, "BUILDJOB_DEPOT_TRADE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER, "BUILDJOB_DEPOT_REQUEST_TRADER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY, "BUILDJOB_DEPOT_BROKER_ONLY");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE, "BUILDJOB_ANIMALTRAP_BAIT_NONE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT, "BUILDJOB_ANIMALTRAP_BAIT_MEAT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH, "BUILDJOB_ANIMALTRAP_BAIT_FISH");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM, "BUILDJOB_ANIMALTRAP_BAIT_GEM");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_FALLOW, "BUILDJOB_FARM_FALLOW");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_FERTILIZE, "BUILDJOB_FARM_FERTILIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_SEASFERT, "BUILDJOB_FARM_SEASFERT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_SPRING, "BUILDJOB_FARM_SPRING");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_SUMMER, "BUILDJOB_FARM_SUMMER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_AUTUMN, "BUILDJOB_FARM_AUTUMN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_WINTER, "BUILDJOB_FARM_WINTER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_BONE, "BUILDJOB_RACK_MAT_BONE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE, "BUILDJOB_RACK_MAT_BRONZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER, "BUILDJOB_RACK_MAT_COPPER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_IRON, "BUILDJOB_RACK_MAT_IRON");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL, "BUILDJOB_RACK_MAT_STEEL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD, "BUILDJOB_RACK_MAT_WOOD");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_METAL, "BUILDJOB_RACK_MAT_METAL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_BONE, "BUILDJOB_STAND_MAT_BONE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER, "BUILDJOB_STAND_MAT_LEATHER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER, "BUILDJOB_STAND_MAT_COPPER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE, "BUILDJOB_STAND_MAT_BRONZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL, "BUILDJOB_STAND_MAT_STEEL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_IRON, "BUILDJOB_STAND_MAT_IRON");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD, "BUILDJOB_STAND_MAT_WOOD");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_METAL, "BUILDJOB_STAND_MAT_METAL");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN, "BUILDJOB_RACKSTAND_ASSIGN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_FREE, "BUILDJOB_RACKSTAND_FREE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE, "BUILDJOB_RACKSTAND_SIZE");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM, "BUILDJOB_RACKSTAND_ITEM");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_MAT, "BUILDJOB_RACKSTAND_MAT");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1, "BUILDJOB_RACKSTAND_DEFAULTS1");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1, "BUILDJOB_RACKSTAND_KILL1");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2, "BUILDJOB_RACKSTAND_DEFAULTS2");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2, "BUILDJOB_RACKSTAND_KILL2");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND, "HOTKEY_BUILDING_ARMORSTAND");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BED, "HOTKEY_BUILDING_BED");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CHAIR, "HOTKEY_BUILDING_CHAIR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_COFFIN, "HOTKEY_BUILDING_COFFIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_DOOR, "HOTKEY_BUILDING_DOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE, "HOTKEY_BUILDING_FLOODGATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_HATCH, "HOTKEY_BUILDING_HATCH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL, "HOTKEY_BUILDING_GRATE_WALL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR, "HOTKEY_BUILDING_GRATE_FLOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL, "HOTKEY_BUILDING_BARS_VERTICAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR, "HOTKEY_BUILDING_BARS_FLOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CABINET, "HOTKEY_BUILDING_CABINET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BOX, "HOTKEY_BUILDING_BOX");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_KENNEL, "HOTKEY_BUILDING_KENNEL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT, "HOTKEY_BUILDING_FARMPLOT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK, "HOTKEY_BUILDING_WEAPONRACK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_STATUE, "HOTKEY_BUILDING_STATUE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TABLE, "HOTKEY_BUILDING_TABLE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT, "HOTKEY_BUILDING_ROAD_DIRT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED, "HOTKEY_BUILDING_ROAD_PAVED");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BRIDGE, "HOTKEY_BUILDING_BRIDGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WELL, "HOTKEY_BUILDING_WELL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE, "HOTKEY_BUILDING_SIEGEENGINE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP, "HOTKEY_BUILDING_WORKSHOP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE, "HOTKEY_BUILDING_FURNACE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS, "HOTKEY_BUILDING_WINDOW_GLASS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM, "HOTKEY_BUILDING_WINDOW_GEM");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SHOP, "HOTKEY_BUILDING_SHOP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP, "HOTKEY_BUILDING_ANIMALTRAP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CHAIN, "HOTKEY_BUILDING_CHAIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CAGE, "HOTKEY_BUILDING_CAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT, "HOTKEY_BUILDING_TRADEDEPOT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP, "HOTKEY_BUILDING_TRAP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE, "HOTKEY_BUILDING_MACHINE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SUPPORT, "HOTKEY_BUILDING_SUPPORT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET, "HOTKEY_BUILDING_ARCHERYTARGET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP, "HOTKEY_BUILDING_MACHINE_SCREW_PUMP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL, "HOTKEY_BUILDING_MACHINE_WATER_WHEEL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL, "HOTKEY_BUILDING_MACHINE_WINDMILL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY, "HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL, "HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL, "HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA, "HOTKEY_BUILDING_SIEGEENGINE_BALLISTA");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT, "HOTKEY_BUILDING_SIEGEENGINE_CATAPULT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE, "HOTKEY_BUILDING_TRAP_STONE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON, "HOTKEY_BUILDING_TRAP_WEAPON");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER, "HOTKEY_BUILDING_TRAP_LEVER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER, "HOTKEY_BUILDING_TRAP_TRIGGER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE, "HOTKEY_BUILDING_TRAP_CAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE, "HOTKEY_BUILDING_TRAP_SPIKE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION, "HOTKEY_BUILDING_CONSTRUCTION");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL, "HOTKEY_BUILDING_CONSTRUCTION_WALL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR, "HOTKEY_BUILDING_CONSTRUCTION_FLOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP, "HOTKEY_BUILDING_CONSTRUCTION_RAMP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION, "HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER, "HOTKEY_BUILDING_WORKSHOP_LEATHER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN, "HOTKEY_BUILDING_WORKSHOP_QUERN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE, "HOTKEY_BUILDING_WORKSHOP_MILLSTONE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM, "HOTKEY_BUILDING_WORKSHOP_LOOM");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES, "HOTKEY_BUILDING_WORKSHOP_CLOTHES");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER, "HOTKEY_BUILDING_WORKSHOP_BOWYER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER, "HOTKEY_BUILDING_WORKSHOP_CARPENTER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH, "HOTKEY_BUILDING_WORKSHOP_METALSMITH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL, "HOTKEY_BUILDING_WORKSHOP_LAVAMILL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER, "HOTKEY_BUILDING_WORKSHOP_JEWELER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON, "HOTKEY_BUILDING_WORKSHOP_MASON");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER, "HOTKEY_BUILDING_WORKSHOP_BUTCHER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER, "HOTKEY_BUILDING_WORKSHOP_TANNER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER, "HOTKEY_BUILDING_WORKSHOP_DYER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN, "HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE, "HOTKEY_BUILDING_WORKSHOP_SIEGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC, "HOTKEY_BUILDING_WORKSHOP_MECHANIC");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL, "HOTKEY_BUILDING_WORKSHOP_STILL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER, "HOTKEY_BUILDING_WORKSHOP_FARMER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN, "HOTKEY_BUILDING_WORKSHOP_KITCHEN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY, "HOTKEY_BUILDING_WORKSHOP_FISHERY");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAB, "HOTKEY_BUILDING_WORKSHOP_LAB");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY, "HOTKEY_BUILDING_WORKSHOP_ASHERY");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD, "HOTKEY_BUILDING_FURNACE_WOOD");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER, "HOTKEY_BUILDING_FURNACE_SMELTER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS, "HOTKEY_BUILDING_FURNACE_GLASS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN, "HOTKEY_BUILDING_FURNACE_KILN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA, "HOTKEY_BUILDING_FURNACE_SMELTER_LAVA");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA, "HOTKEY_BUILDING_FURNACE_GLASS_LAVA");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA, "HOTKEY_BUILDING_FURNACE_KILN_LAVA");
  bindingNames.insert(INTERFACEKEY_BUILDING_DIM_Y_UP, "BUILDING_DIM_Y_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_DIM_Y_DOWN, "BUILDING_DIM_Y_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_DIM_X_UP, "BUILDING_DIM_X_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_DIM_X_DOWN, "BUILDING_DIM_X_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_UP, "BUILDING_ORIENT_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_LEFT, "BUILDING_ORIENT_LEFT");
  bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_RIGHT, "BUILDING_ORIENT_RIGHT");
  bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_DOWN, "BUILDING_ORIENT_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_NONE, "BUILDING_ORIENT_NONE");
  bindingNames.insert(INTERFACEKEY_BUILDING_VIEW_ITEM, "BUILDING_VIEW_ITEM");
  bindingNames.insert(INTERFACEKEY_BUILDING_ADVANCE_STAGE, "BUILDING_ADVANCE_STAGE");
  bindingNames.insert(INTERFACEKEY_BUILDING_EXPAND_CONTRACT, "BUILDING_EXPAND_CONTRACT");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER, "BUILDING_TRIGGER_ENABLE_WATER");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP, "BUILDING_TRIGGER_MIN_WATER_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN, "BUILDING_TRIGGER_MIN_WATER_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP, "BUILDING_TRIGGER_MAX_WATER_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN, "BUILDING_TRIGGER_MAX_WATER_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA, "BUILDING_TRIGGER_ENABLE_MAGMA");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP, "BUILDING_TRIGGER_MIN_MAGMA_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN, "BUILDING_TRIGGER_MIN_MAGMA_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP, "BUILDING_TRIGGER_MAX_MAGMA_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN, "BUILDING_TRIGGER_MAX_MAGMA_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE, "BUILDING_TRIGGER_ENABLE_CREATURE");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS, "BUILDING_TRIGGER_ENABLE_LOCALS");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_RESETS, "BUILDING_TRIGGER_RESETS");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP, "BUILDING_TRIGGER_MIN_SIZE_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN, "BUILDING_TRIGGER_MIN_SIZE_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP, "BUILDING_TRIGGER_MAX_SIZE_UP");
  bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN, "BUILDING_TRIGGER_MAX_SIZE_DOWN");
  bindingNames.insert(INTERFACEKEY_DESTROYBUILDING, "DESTROYBUILDING");
  bindingNames.insert(INTERFACEKEY_SUSPENDBUILDING, "SUSPENDBUILDING");
  bindingNames.insert(INTERFACEKEY_BUILDINGLIST_ZOOM_T, "BUILDINGLIST_ZOOM_T");
  bindingNames.insert(INTERFACEKEY_BUILDINGLIST_ZOOM_Q, "BUILDINGLIST_ZOOM_Q");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MAKE_ASH, "HOTKEY_MAKE_ASH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MAKE_CHARCOAL, "HOTKEY_MAKE_CHARCOAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MELT_OBJECT, "HOTKEY_MELT_OBJECT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_GREEN, "HOTKEY_GLASS_GREEN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CLEAR, "HOTKEY_GLASS_CLEAR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CRYSTAL, "HOTKEY_GLASS_CRYSTAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_COLLECT_SAND, "HOTKEY_COLLECT_SAND");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_ROUGH, "HOTKEY_GLASS_ROUGH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND, "HOTKEY_GLASS_ARMORSTAND");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_BOX, "HOTKEY_GLASS_BOX");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CABINET, "HOTKEY_GLASS_CABINET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_COFFIN, "HOTKEY_GLASS_COFFIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_FLOODGATE, "HOTKEY_GLASS_FLOODGATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER, "HOTKEY_GLASS_HATCH_COVER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_GRATE, "HOTKEY_GLASS_GRATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_GOBLET, "HOTKEY_GLASS_GOBLET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_TOY, "HOTKEY_GLASS_TOY");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_INSTRUMENT, "HOTKEY_GLASS_INSTRUMENT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_DOOR, "HOTKEY_GLASS_DOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_STATUE, "HOTKEY_GLASS_STATUE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_TABLE, "HOTKEY_GLASS_TABLE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CAGE, "HOTKEY_GLASS_CAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CHAIR, "HOTKEY_GLASS_CHAIR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_BLOCKS, "HOTKEY_GLASS_BLOCKS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_FLASK, "HOTKEY_GLASS_FLASK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK, "HOTKEY_GLASS_WEAPONRACK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_WINDOW, "HOTKEY_GLASS_WINDOW");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MAKE_PEARLASH, "HOTKEY_MAKE_PEARLASH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_ASHERY_LYE, "HOTKEY_ASHERY_LYE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_ASHERY_POTASH, "HOTKEY_ASHERY_POTASH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT, "HOTKEY_ASHERY_POTASH_DIRECT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BARREL, "HOTKEY_CARPENTER_BARREL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS, "HOTKEY_CARPENTER_BLOCKS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BUCKET, "HOTKEY_CARPENTER_BUCKET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL, "HOTKEY_CARPENTER_TRAP_ANIMAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CAGE, "HOTKEY_CARPENTER_CAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND, "HOTKEY_CARPENTER_ARMORSTAND");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BED, "HOTKEY_CARPENTER_BED");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CHAIR, "HOTKEY_CARPENTER_CHAIR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_COFFIN, "HOTKEY_CARPENTER_COFFIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_DOOR, "HOTKEY_CARPENTER_DOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE, "HOTKEY_CARPENTER_FLOODGATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER, "HOTKEY_CARPENTER_HATCH_COVER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_GRATE, "HOTKEY_CARPENTER_GRATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CABINET, "HOTKEY_CARPENTER_CABINET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BIN, "HOTKEY_CARPENTER_BIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BOX, "HOTKEY_CARPENTER_BOX");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK, "HOTKEY_CARPENTER_WEAPONRACK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_TABLE, "HOTKEY_CARPENTER_TABLE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SIEGE_BALLISTA, "HOTKEY_SIEGE_BALLISTA");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SIEGE_CATAPULT, "HOTKEY_SIEGE_CATAPULT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_BOX, "HOTKEY_LEATHER_BOX");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_FLASK, "HOTKEY_LEATHER_FLASK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_SHIRT, "HOTKEY_LEATHER_SHIRT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_CLOAK, "HOTKEY_LEATHER_CLOAK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_BACKPACK, "HOTKEY_LEATHER_BACKPACK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_QUIVER, "HOTKEY_LEATHER_QUIVER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_IMAGE, "HOTKEY_LEATHER_IMAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT, "HOTKEY_CLOTHES_MAT_PLANT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK, "HOTKEY_CLOTHES_MAT_SILK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_SHIRT, "HOTKEY_CLOTHES_SHIRT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_CLOAK, "HOTKEY_CLOTHES_CLOAK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_BOX, "HOTKEY_CLOTHES_BOX");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_CHAIN, "HOTKEY_CLOTHES_CHAIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_IMAGE, "HOTKEY_CLOTHES_IMAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE, "HOTKEY_CRAFTS_MAT_STONE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD, "HOTKEY_CRAFTS_MAT_WOOD");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE, "HOTKEY_CRAFTS_DEC_BONE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL, "HOTKEY_CRAFTS_DEC_SHELL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_TOTEM, "HOTKEY_CRAFTS_TOTEM");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_CLOTH, "HOTKEY_CRAFTS_CLOTH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SILK, "HOTKEY_CRAFTS_SILK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SHELL, "HOTKEY_CRAFTS_SHELL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_BONE, "HOTKEY_CRAFTS_BONE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_LEATHER, "HOTKEY_CRAFTS_LEATHER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS, "HOTKEY_CRAFTS_MAT_CRAFTS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET, "HOTKEY_CRAFTS_MAT_GOBLET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_INSTRUMENT, "HOTKEY_CRAFTS_MAT_INSTRUMENT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY, "HOTKEY_CRAFTS_MAT_TOY");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_WEAPON, "HOTKEY_SMITH_WEAPON");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_ARMOR, "HOTKEY_SMITH_ARMOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_FURNITURE, "HOTKEY_SMITH_FURNITURE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_SIEGE, "HOTKEY_SMITH_SIEGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_TRAP, "HOTKEY_SMITH_TRAP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_OTHER, "HOTKEY_SMITH_OTHER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_METAL, "HOTKEY_SMITH_METAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP, "HOTKEY_ALCHEMIST_SOAP");
  bindingNames.insert(INTERFACEKEY_HOTKEY_STILL_BREW, "HOTKEY_STILL_BREW");
  bindingNames.insert(INTERFACEKEY_HOTKEY_STILL_EXTRACT, "HOTKEY_STILL_EXTRACT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK, "HOTKEY_LOOM_COLLECT_SILK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH, "HOTKEY_LOOM_WEAVE_CLOTH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK, "HOTKEY_LOOM_WEAVE_SILK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL, "HOTKEY_LOOM_WEAVE_METAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_2, "HOTKEY_KITCHEN_COOK_2");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_3, "HOTKEY_KITCHEN_COOK_3");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_4, "HOTKEY_KITCHEN_COOK_4");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT, "HOTKEY_KITCHEN_RENDER_FAT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS, "HOTKEY_FARMER_PROCESS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL, "HOTKEY_FARMER_PROCESS_VIAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG, "HOTKEY_FARMER_PROCESS_BAG");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL, "HOTKEY_FARMER_PROCESS_BARREL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_CHEESE, "HOTKEY_FARMER_CHEESE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_MILK, "HOTKEY_FARMER_MILK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MILL_MILL, "HOTKEY_MILL_MILL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_TRAIN_HUNT, "HOTKEY_KENNEL_TRAIN_HUNT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN, "HOTKEY_KENNEL_CATCH_VERMIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN, "HOTKEY_KENNEL_TAME_VERMIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_TAME_UNIT, "HOTKEY_KENNEL_TAME_UNIT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_TRAIN_WAR, "HOTKEY_KENNEL_TRAIN_WAR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FISHERY_PROCESS, "HOTKEY_FISHERY_PROCESS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FISHERY_EXTRACT, "HOTKEY_FISHERY_EXTRACT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_FISHERY_CATCH, "HOTKEY_FISHERY_CATCH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER, "HOTKEY_BUTCHER_BUTCHER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT, "HOTKEY_BUTCHER_EXTRACT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_CATCH, "HOTKEY_BUTCHER_CATCH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TANNER_TAN, "HOTKEY_TANNER_TAN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_DYER_THREAD, "HOTKEY_DYER_THREAD");
  bindingNames.insert(INTERFACEKEY_HOTKEY_DYER_CLOTH, "HOTKEY_DYER_CLOTH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_FURNITURE, "HOTKEY_JEWELER_FURNITURE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_FINISHED, "HOTKEY_JEWELER_FINISHED");
  bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_AMMO, "HOTKEY_JEWELER_AMMO");
  bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_CUT, "HOTKEY_JEWELER_CUT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_ENCRUST, "HOTKEY_JEWELER_ENCRUST");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MECHANIC_PARTS, "HOTKEY_MECHANIC_PARTS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_ARMORSTAND, "HOTKEY_MASON_ARMORSTAND");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_BLOCKS, "HOTKEY_MASON_BLOCKS");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_CHAIR, "HOTKEY_MASON_CHAIR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_COFFIN, "HOTKEY_MASON_COFFIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_DOOR, "HOTKEY_MASON_DOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_FLOODGATE, "HOTKEY_MASON_FLOODGATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_HATCH_COVER, "HOTKEY_MASON_HATCH_COVER");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_GRATE, "HOTKEY_MASON_GRATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_CABINET, "HOTKEY_MASON_CABINET");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_BOX, "HOTKEY_MASON_BOX");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_STATUE, "HOTKEY_MASON_STATUE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_TABLE, "HOTKEY_MASON_TABLE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_WEAPONRACK, "HOTKEY_MASON_WEAPONRACK");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_QUERN, "HOTKEY_MASON_QUERN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_MILLSTONE, "HOTKEY_MASON_MILLSTONE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_BRIDGE, "HOTKEY_TRAP_BRIDGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_DOOR, "HOTKEY_TRAP_DOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_FLOODGATE, "HOTKEY_TRAP_FLOODGATE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_SPIKE, "HOTKEY_TRAP_SPIKE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_HATCH, "HOTKEY_TRAP_HATCH");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL, "HOTKEY_TRAP_GRATE_WALL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR, "HOTKEY_TRAP_GRATE_FLOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL, "HOTKEY_TRAP_BARS_VERTICAL");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR, "HOTKEY_TRAP_BARS_FLOOR");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_SUPPORT, "HOTKEY_TRAP_SUPPORT");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_CHAIN, "HOTKEY_TRAP_CHAIN");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_CAGE, "HOTKEY_TRAP_CAGE");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY, "HOTKEY_TRAP_GEAR_ASSEMBLY");
  bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER, "HOTKEY_TRAP_PULL_LEVER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER, "BUILDJOB_STOCKPILE_MASTER");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD, "BUILDJOB_STOCKPILE_DELETE_CHILD");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS, "BUILDJOB_STOCKPILE_SETTINGS");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP, "BUILDJOB_STOCKPILE_BARREL_UP");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN, "BUILDJOB_STOCKPILE_BARREL_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO, "BUILDJOB_STOCKPILE_BARREL_ZERO");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX, "BUILDJOB_STOCKPILE_BARREL_MAX");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP, "BUILDJOB_STOCKPILE_BIN_UP");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN, "BUILDJOB_STOCKPILE_BIN_DOWN");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO, "BUILDJOB_STOCKPILE_BIN_ZERO");
  bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX, "BUILDJOB_STOCKPILE_BIN_MAX");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_ANIMAL, "STOCKPILE_ANIMAL");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_FOOD, "STOCKPILE_FOOD");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_WEAPON, "STOCKPILE_WEAPON");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_ARMOR, "STOCKPILE_ARMOR");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_CUSTOM, "STOCKPILE_CUSTOM");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS, "STOCKPILE_CUSTOM_SETTINGS");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_FURNITURE, "STOCKPILE_FURNITURE");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_GRAVEYARD, "STOCKPILE_GRAVEYARD");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_REFUSE, "STOCKPILE_REFUSE");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_WOOD, "STOCKPILE_WOOD");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_STONE, "STOCKPILE_STONE");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_GEM, "STOCKPILE_GEM");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_BARBLOCK, "STOCKPILE_BARBLOCK");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_CLOTH, "STOCKPILE_CLOTH");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_LEATHER, "STOCKPILE_LEATHER");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_AMMO, "STOCKPILE_AMMO");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_COINS, "STOCKPILE_COINS");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_FINISHED, "STOCKPILE_FINISHED");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_NONE, "STOCKPILE_NONE");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE, "STOCKPILE_SETTINGS_ENABLE");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE, "STOCKPILE_SETTINGS_DISABLE");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL, "STOCKPILE_SETTINGS_PERMIT_ALL");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL, "STOCKPILE_SETTINGS_FORBID_ALL");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB, "STOCKPILE_SETTINGS_PERMIT_SUB");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB, "STOCKPILE_SETTINGS_FORBID_SUB");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1, "STOCKPILE_SETTINGS_SPECIFIC1");
  bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2, "STOCKPILE_SETTINGS_SPECIFIC2");
  bindingNames.insert(INTERFACEKEY_CIVZONE_REMOVE, "CIVZONE_REMOVE");
  bindingNames.insert(INTERFACEKEY_CIVZONE_WATER_SOURCE, "CIVZONE_WATER_SOURCE");
  bindingNames.insert(INTERFACEKEY_CIVZONE_FISH, "CIVZONE_FISH");
  bindingNames.insert(INTERFACEKEY_CIVZONE_DUMP, "CIVZONE_DUMP");
  bindingNames.insert(INTERFACEKEY_CIVZONE_POND, "CIVZONE_POND");
  bindingNames.insert(INTERFACEKEY_CIVZONE_SAND_COLLECT, "CIVZONE_SAND_COLLECT");
  bindingNames.insert(INTERFACEKEY_CIVZONE_ACTIVE, "CIVZONE_ACTIVE");
  bindingNames.insert(INTERFACEKEY_CIVZONE_MEETING, "CIVZONE_MEETING");
  bindingNames.insert(INTERFACEKEY_CIVZONE_POND_OPTIONS, "CIVZONE_POND_OPTIONS");
  bindingNames.insert(INTERFACEKEY_CIVZONE_POND_WATER, "CIVZONE_POND_WATER");
  bindingNames.insert(INTERFACEKEY_STORES_VIEW, "STORES_VIEW");
  bindingNames.insert(INTERFACEKEY_STORES_ZOOM, "STORES_ZOOM");
  bindingNames.insert(INTERFACEKEY_STORES_FORBID, "STORES_FORBID");
  bindingNames.insert(INTERFACEKEY_STORES_MELT, "STORES_MELT");
  bindingNames.insert(INTERFACEKEY_STORES_DUMP, "STORES_DUMP");
  bindingNames.insert(INTERFACEKEY_STORES_HIDE, "STORES_HIDE");
  bindingNames.insert(INTERFACEKEY_PET_BUTCHER, "PET_BUTCHER");
  bindingNames.insert(INTERFACEKEY_KITCHEN_COOK, "KITCHEN_COOK");
  bindingNames.insert(INTERFACEKEY_KITCHEN_BREW, "KITCHEN_BREW");
  bindingNames.insert(INTERFACEKEY_ORDERS_AUTOFORBID, "ORDERS_AUTOFORBID");
  bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_PROJECTILE, "ORDERS_FORBID_PROJECTILE");
  bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE, "ORDERS_FORBID_YOUR_CORPSE");
  bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS, "ORDERS_FORBID_YOUR_ITEMS");
  bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE, "ORDERS_FORBID_OTHER_CORPSE");
  bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS, "ORDERS_FORBID_OTHER_ITEMS");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_GATHER, "ORDERS_REFUSE_GATHER");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_OUTSIDE, "ORDERS_REFUSE_OUTSIDE");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE, "ORDERS_REFUSE_DUMP_CORPSE");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL, "ORDERS_REFUSE_DUMP_SKULL");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE, "ORDERS_REFUSE_DUMP_BONE");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL, "ORDERS_REFUSE_DUMP_SHELL");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN, "ORDERS_REFUSE_DUMP_SKIN");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER, "ORDERS_REFUSE_DUMP_OTHER");
  bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_FURNITURE, "ORDERS_GATHER_FURNITURE");
  bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_ANIMALS, "ORDERS_GATHER_ANIMALS");
  bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_FOOD, "ORDERS_GATHER_FOOD");
  bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_BODIES, "ORDERS_GATHER_BODIES");
  bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE, "ORDERS_REFUSE");
  bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_STONE, "ORDERS_GATHER_STONE");
  bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_WOOD, "ORDERS_GATHER_WOOD");
  bindingNames.insert(INTERFACEKEY_ORDERS_ALL_HARVEST, "ORDERS_ALL_HARVEST");
  bindingNames.insert(INTERFACEKEY_ORDERS_INDOORS, "ORDERS_INDOORS");
  bindingNames.insert(INTERFACEKEY_ORDERS_SAMEPILE, "ORDERS_SAMEPILE");
  bindingNames.insert(INTERFACEKEY_ORDERS_MIXFOODS, "ORDERS_MIXFOODS");
  bindingNames.insert(INTERFACEKEY_ORDERS_LOOM, "ORDERS_LOOM");
  bindingNames.insert(INTERFACEKEY_ORDERS_DYED_CLOTH, "ORDERS_DYED_CLOTH");
  bindingNames.insert(INTERFACEKEY_ORDERS_EXCEPTIONS, "ORDERS_EXCEPTIONS");
  bindingNames.insert(INTERFACEKEY_ORDERS_WORKSHOP, "ORDERS_WORKSHOP");
  bindingNames.insert(INTERFACEKEY_ORDERS_COLLECT_WEB, "ORDERS_COLLECT_WEB");
  bindingNames.insert(INTERFACEKEY_ORDERS_SLAUGHTER, "ORDERS_SLAUGHTER");
  bindingNames.insert(INTERFACEKEY_ORDERS_BUTCHER, "ORDERS_BUTCHER");
  bindingNames.insert(INTERFACEKEY_ORDERS_TAN, "ORDERS_TAN");
  bindingNames.insert(INTERFACEKEY_ORDERS_ZONE, "ORDERS_ZONE");
  bindingNames.insert(INTERFACEKEY_ORDERS_ZONE_DRINKING, "ORDERS_ZONE_DRINKING");
  bindingNames.insert(INTERFACEKEY_ORDERS_ZONE_FISHING, "ORDERS_ZONE_FISHING");
  bindingNames.insert(INTERFACEKEY_D_ONESTEP, "D_ONESTEP");
  bindingNames.insert(INTERFACEKEY_D_PAUSE, "D_PAUSE");
  bindingNames.insert(INTERFACEKEY_D_DEPOT, "D_DEPOT");
  bindingNames.insert(INTERFACEKEY_D_HOT_KEYS, "D_HOT_KEYS");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY1, "D_HOTKEY1");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY2, "D_HOTKEY2");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY3, "D_HOTKEY3");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY4, "D_HOTKEY4");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY5, "D_HOTKEY5");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY6, "D_HOTKEY6");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY7, "D_HOTKEY7");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY8, "D_HOTKEY8");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY9, "D_HOTKEY9");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY10, "D_HOTKEY10");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY11, "D_HOTKEY11");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY12, "D_HOTKEY12");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY13, "D_HOTKEY13");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY14, "D_HOTKEY14");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY15, "D_HOTKEY15");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY16, "D_HOTKEY16");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY_CHANGE_NAME, "D_HOTKEY_CHANGE_NAME");
  bindingNames.insert(INTERFACEKEY_D_HOTKEY_ZOOM, "D_HOTKEY_ZOOM");
  bindingNames.insert(INTERFACEKEY_D_ANNOUNCE, "D_ANNOUNCE");
  bindingNames.insert(INTERFACEKEY_D_BUILDING, "D_BUILDING");
  bindingNames.insert(INTERFACEKEY_D_CIVLIST, "D_CIVLIST");
  bindingNames.insert(INTERFACEKEY_D_DESIGNATE, "D_DESIGNATE");
  bindingNames.insert(INTERFACEKEY_D_ARTLIST, "D_ARTLIST");
  bindingNames.insert(INTERFACEKEY_D_NOBLES, "D_NOBLES");
  bindingNames.insert(INTERFACEKEY_D_ORDERS, "D_ORDERS");
  bindingNames.insert(INTERFACEKEY_D_MILITARY, "D_MILITARY");
  bindingNames.insert(INTERFACEKEY_D_ROOMS, "D_ROOMS");
  bindingNames.insert(INTERFACEKEY_D_SQUADS, "D_SQUADS");
  bindingNames.insert(INTERFACEKEY_D_STOCKPILES, "D_STOCKPILES");
  bindingNames.insert(INTERFACEKEY_D_CIVZONE, "D_CIVZONE");
  bindingNames.insert(INTERFACEKEY_D_VIEWUNIT, "D_VIEWUNIT");
  bindingNames.insert(INTERFACEKEY_D_JOBLIST, "D_JOBLIST");
  bindingNames.insert(INTERFACEKEY_D_UNITLIST, "D_UNITLIST");
  bindingNames.insert(INTERFACEKEY_D_LOOK, "D_LOOK");
  bindingNames.insert(INTERFACEKEY_D_NOTE, "D_NOTE");
  bindingNames.insert(INTERFACEKEY_D_NOTE_PLACE, "D_NOTE_PLACE");
  bindingNames.insert(INTERFACEKEY_D_NOTE_DELETE, "D_NOTE_DELETE");
  bindingNames.insert(INTERFACEKEY_D_NOTE_ENTER, "D_NOTE_ENTER");
  bindingNames.insert(INTERFACEKEY_D_NOTE_ADOPT_SYMBOL, "D_NOTE_ADOPT_SYMBOL");
  bindingNames.insert(INTERFACEKEY_D_NOTE_CHANGE_SELECTION, "D_NOTE_CHANGE_SELECTION");
  bindingNames.insert(INTERFACEKEY_D_BUILDJOB, "D_BUILDJOB");
  bindingNames.insert(INTERFACEKEY_D_STATUS, "D_STATUS");
  bindingNames.insert(INTERFACEKEY_D_BUILDITEM, "D_BUILDITEM");
  bindingNames.insert(INTERFACEKEY_D_VISUALIZE, "D_VISUALIZE");
  bindingNames.insert(INTERFACEKEY_D_BITEM_FORBID, "D_BITEM_FORBID");
  bindingNames.insert(INTERFACEKEY_D_BITEM_DUMP, "D_BITEM_DUMP");
  bindingNames.insert(INTERFACEKEY_D_BITEM_MELT, "D_BITEM_MELT");
  bindingNames.insert(INTERFACEKEY_D_BITEM_HIDE, "D_BITEM_HIDE");
  bindingNames.insert(INTERFACEKEY_D_LOOK_FORBID, "D_LOOK_FORBID");
  bindingNames.insert(INTERFACEKEY_D_LOOK_DUMP, "D_LOOK_DUMP");
  bindingNames.insert(INTERFACEKEY_D_LOOK_MELT, "D_LOOK_MELT");
  bindingNames.insert(INTERFACEKEY_D_LOOK_HIDE, "D_LOOK_HIDE");
  bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_VIEW, "ASSIGNTRADE_VIEW");
  bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_STRING, "ASSIGNTRADE_STRING");
  bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED, "ASSIGNTRADE_EXCLUDE_PROHIBITED");
  bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_PENDING, "ASSIGNTRADE_PENDING");
  bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_SORT, "ASSIGNTRADE_SORT");
  bindingNames.insert(INTERFACEKEY_TRADE_VIEW, "TRADE_VIEW");
  bindingNames.insert(INTERFACEKEY_TRADE_TRADE, "TRADE_TRADE");
  bindingNames.insert(INTERFACEKEY_TRADE_OFFER, "TRADE_OFFER");
  bindingNames.insert(INTERFACEKEY_TRADE_SEIZE, "TRADE_SEIZE");
  bindingNames.insert(INTERFACEKEY_UNITJOB_REMOVE_CRE, "UNITJOB_REMOVE_CRE");
  bindingNames.insert(INTERFACEKEY_UNITJOB_ZOOM_CRE, "UNITJOB_ZOOM_CRE");
  bindingNames.insert(INTERFACEKEY_UNITJOB_ZOOM_BUILD, "UNITJOB_ZOOM_BUILD");
  bindingNames.insert(INTERFACEKEY_UNITJOB_VIEW, "UNITJOB_VIEW");
  bindingNames.insert(INTERFACEKEY_UNITJOB_MANAGER, "UNITJOB_MANAGER");
  bindingNames.insert(INTERFACEKEY_MANAGER_NEW_ORDER, "MANAGER_NEW_ORDER");
  bindingNames.insert(INTERFACEKEY_MANAGER_REMOVE, "MANAGER_REMOVE");
  bindingNames.insert(INTERFACEKEY_MANAGER_PROMOTE, "MANAGER_PROMOTE");
  bindingNames.insert(INTERFACEKEY_MANAGER_MAX, "MANAGER_MAX");
  bindingNames.insert(INTERFACEKEY_MANAGER_WAGES, "MANAGER_WAGES");
  bindingNames.insert(INTERFACEKEY_NOBLELIST_REPLACE, "NOBLELIST_REPLACE");
  bindingNames.insert(INTERFACEKEY_NOBLELIST_SETTINGS, "NOBLELIST_SETTINGS");
  bindingNames.insert(INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE, "NOBLELIST_VIEW_CANDIDATE");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_BITEM, "DESIGNATE_BITEM");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_CLAIM, "DESIGNATE_CLAIM");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_UNCLAIM, "DESIGNATE_UNCLAIM");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_MELT, "DESIGNATE_MELT");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_NO_MELT, "DESIGNATE_NO_MELT");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_DUMP, "DESIGNATE_DUMP");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_NO_DUMP, "DESIGNATE_NO_DUMP");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_HIDE, "DESIGNATE_HIDE");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_NO_HIDE, "DESIGNATE_NO_HIDE");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_DIG, "DESIGNATE_DIG");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS, "DESIGNATE_DIG_REMOVE_STAIRS_RAMPS");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC, "DESIGNATE_TRAFFIC");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH, "DESIGNATE_TRAFFIC_HIGH");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL, "DESIGNATE_TRAFFIC_NORMAL");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_LOW, "DESIGNATE_TRAFFIC_LOW");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED, "DESIGNATE_TRAFFIC_RESTRICTED");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT, "DESIGNATE_TRAFFIC_INCREASE_WEIGHT");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT, "DESIGNATE_TRAFFIC_DECREASE_WEIGHT");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE, "DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE, "DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_STAIR_UP, "DESIGNATE_STAIR_UP");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_STAIR_DOWN, "DESIGNATE_STAIR_DOWN");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_STAIR_UPDOWN, "DESIGNATE_STAIR_UPDOWN");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_RAMP, "DESIGNATE_RAMP");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_CHANNEL, "DESIGNATE_CHANNEL");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_CHOP, "DESIGNATE_CHOP");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_PLANTS, "DESIGNATE_PLANTS");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_SMOOTH, "DESIGNATE_SMOOTH");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_ENGRAVE, "DESIGNATE_ENGRAVE");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_FORTIFY, "DESIGNATE_FORTIFY");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING, "DESIGNATE_TOGGLE_ENGRAVING");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_UNDO, "DESIGNATE_UNDO");
  bindingNames.insert(INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION, "DESIGNATE_REMOVE_CONSTRUCTION");
  bindingNames.insert(INTERFACEKEY_ITEM_DESCRIPTION, "ITEM_DESCRIPTION");
  bindingNames.insert(INTERFACEKEY_ITEM_FORBID, "ITEM_FORBID");
  bindingNames.insert(INTERFACEKEY_ITEM_MELT, "ITEM_MELT");
  bindingNames.insert(INTERFACEKEY_ITEM_DUMP, "ITEM_DUMP");
  bindingNames.insert(INTERFACEKEY_ITEM_HIDE, "ITEM_HIDE");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_GEN, "UNITVIEW_GEN");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_INV, "UNITVIEW_INV");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF, "UNITVIEW_PRF");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_WND, "UNITVIEW_WND");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_NEXT, "UNITVIEW_NEXT");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_SLAUGHTER, "UNITVIEW_SLAUGHTER");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_PROF, "UNITVIEW_PRF_PROF");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_PET, "UNITVIEW_PRF_PET");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER, "UNITVIEW_PRF_SOLDIER");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_CASTLE, "UNITVIEW_PRF_CASTLE");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_ROYAL, "UNITVIEW_PRF_ROYAL");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_TOGGLESQUAD, "UNITVIEW_PRF_TOGGLESQUAD");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_PET_HUNT, "UNITVIEW_PRF_PET_HUNT");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_PET_WAR, "UNITVIEW_PRF_PET_WAR");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_UNARMED, "UNITVIEW_PRF_SOLDIER_UNARMED");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_AXE, "UNITVIEW_PRF_SOLDIER_AXE");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_CROSSBOW, "UNITVIEW_PRF_SOLDIER_CROSSBOW");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_HAMMER, "UNITVIEW_PRF_SOLDIER_HAMMER");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_MACE, "UNITVIEW_PRF_SOLDIER_MACE");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_SPEAR, "UNITVIEW_PRF_SOLDIER_SPEAR");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_SWORD, "UNITVIEW_PRF_SOLDIER_SWORD");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_WEAPONNUM, "UNITVIEW_PRF_SOLDIER_WEAPONNUM");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_ARMOR, "UNITVIEW_PRF_SOLDIER_ARMOR");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_SOLDIER_SHIELD, "UNITVIEW_PRF_SOLDIER_SHIELD");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_VIEW, "UNITVIEW_PRF_VIEW");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_CUSTOMIZE, "UNITVIEW_CUSTOMIZE");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS, "UNITVIEW_RELATIONSHIPS");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM, "UNITVIEW_RELATIONSHIPS_ZOOM");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW, "UNITVIEW_RELATIONSHIPS_VIEW");
  bindingNames.insert(INTERFACEKEY_UNITVIEW_KILLS, "UNITVIEW_KILLS");
  bindingNames.insert(INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME, "CUSTOMIZE_UNIT_NICKNAME");
  bindingNames.insert(INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME, "CUSTOMIZE_UNIT_PROFNAME");
  bindingNames.insert(INTERFACEKEY_SQUAD_LOCK, "SQUAD_LOCK");
  bindingNames.insert(INTERFACEKEY_SQUAD_STATION, "SQUAD_STATION");
  bindingNames.insert(INTERFACEKEY_SQUAD_CLEAR_PATROL, "SQUAD_CLEAR_PATROL");
  bindingNames.insert(INTERFACEKEY_SQUAD_PATROL, "SQUAD_PATROL");
  bindingNames.insert(INTERFACEKEY_SQUAD_ZOOM, "SQUAD_ZOOM");
  bindingNames.insert(INTERFACEKEY_MILITARY_ACTIVATE, "MILITARY_ACTIVATE");
  bindingNames.insert(INTERFACEKEY_MILITARY_VIEW, "MILITARY_VIEW");
  bindingNames.insert(INTERFACEKEY_MILITARY_WEAPON, "MILITARY_WEAPON");
  bindingNames.insert(INTERFACEKEY_MILITARY_ZOOM, "MILITARY_ZOOM");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_FOOD, "SQUADINFO_FOOD");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_SLEEP, "SQUADINFO_SLEEP");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_WATER, "SQUADINFO_WATER");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_STAYCLOSE, "SQUADINFO_STAYCLOSE");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_ATTACKWILDS, "SQUADINFO_ATTACKWILDS");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_STANDDOWN, "SQUADINFO_STANDDOWN");
  bindingNames.insert(INTERFACEKEY_SQUADINFO_ZOOM, "SQUADINFO_ZOOM");
  bindingNames.insert(INTERFACEKEY_STRING_A000, "STRING_A000");
  bindingNames.insert(INTERFACEKEY_STRING_A001, "STRING_A001");
  bindingNames.insert(INTERFACEKEY_STRING_A002, "STRING_A002");
  bindingNames.insert(INTERFACEKEY_STRING_A003, "STRING_A003");
  bindingNames.insert(INTERFACEKEY_STRING_A004, "STRING_A004");
  bindingNames.insert(INTERFACEKEY_STRING_A005, "STRING_A005");
  bindingNames.insert(INTERFACEKEY_STRING_A006, "STRING_A006");
  bindingNames.insert(INTERFACEKEY_STRING_A007, "STRING_A007");
  bindingNames.insert(INTERFACEKEY_STRING_A008, "STRING_A008");
  bindingNames.insert(INTERFACEKEY_STRING_A009, "STRING_A009");
  bindingNames.insert(INTERFACEKEY_STRING_A010, "STRING_A010");
  bindingNames.insert(INTERFACEKEY_STRING_A011, "STRING_A011");
  bindingNames.insert(INTERFACEKEY_STRING_A012, "STRING_A012");
  bindingNames.insert(INTERFACEKEY_STRING_A013, "STRING_A013");
  bindingNames.insert(INTERFACEKEY_STRING_A014, "STRING_A014");
  bindingNames.insert(INTERFACEKEY_STRING_A015, "STRING_A015");
  bindingNames.insert(INTERFACEKEY_STRING_A016, "STRING_A016");
  bindingNames.insert(INTERFACEKEY_STRING_A017, "STRING_A017");
  bindingNames.insert(INTERFACEKEY_STRING_A018, "STRING_A018");
  bindingNames.insert(INTERFACEKEY_STRING_A019, "STRING_A019");
  bindingNames.insert(INTERFACEKEY_STRING_A020, "STRING_A020");
  bindingNames.insert(INTERFACEKEY_STRING_A021, "STRING_A021");
  bindingNames.insert(INTERFACEKEY_STRING_A022, "STRING_A022");
  bindingNames.insert(INTERFACEKEY_STRING_A023, "STRING_A023");
  bindingNames.insert(INTERFACEKEY_STRING_A024, "STRING_A024");
  bindingNames.insert(INTERFACEKEY_STRING_A025, "STRING_A025");
  bindingNames.insert(INTERFACEKEY_STRING_A026, "STRING_A026");
  bindingNames.insert(INTERFACEKEY_STRING_A027, "STRING_A027");
  bindingNames.insert(INTERFACEKEY_STRING_A028, "STRING_A028");
  bindingNames.insert(INTERFACEKEY_STRING_A029, "STRING_A029");
  bindingNames.insert(INTERFACEKEY_STRING_A030, "STRING_A030");
  bindingNames.insert(INTERFACEKEY_STRING_A031, "STRING_A031");
  bindingNames.insert(INTERFACEKEY_STRING_A032, "STRING_A032");
  bindingNames.insert(INTERFACEKEY_STRING_A033, "STRING_A033");
  bindingNames.insert(INTERFACEKEY_STRING_A034, "STRING_A034");
  bindingNames.insert(INTERFACEKEY_STRING_A035, "STRING_A035");
  bindingNames.insert(INTERFACEKEY_STRING_A036, "STRING_A036");
  bindingNames.insert(INTERFACEKEY_STRING_A037, "STRING_A037");
  bindingNames.insert(INTERFACEKEY_STRING_A038, "STRING_A038");
  bindingNames.insert(INTERFACEKEY_STRING_A039, "STRING_A039");
  bindingNames.insert(INTERFACEKEY_STRING_A040, "STRING_A040");
  bindingNames.insert(INTERFACEKEY_STRING_A041, "STRING_A041");
  bindingNames.insert(INTERFACEKEY_STRING_A042, "STRING_A042");
  bindingNames.insert(INTERFACEKEY_STRING_A043, "STRING_A043");
  bindingNames.insert(INTERFACEKEY_STRING_A044, "STRING_A044");
  bindingNames.insert(INTERFACEKEY_STRING_A045, "STRING_A045");
  bindingNames.insert(INTERFACEKEY_STRING_A046, "STRING_A046");
  bindingNames.insert(INTERFACEKEY_STRING_A047, "STRING_A047");
  bindingNames.insert(INTERFACEKEY_STRING_A048, "STRING_A048");
  bindingNames.insert(INTERFACEKEY_STRING_A049, "STRING_A049");
  bindingNames.insert(INTERFACEKEY_STRING_A050, "STRING_A050");
  bindingNames.insert(INTERFACEKEY_STRING_A051, "STRING_A051");
  bindingNames.insert(INTERFACEKEY_STRING_A052, "STRING_A052");
  bindingNames.insert(INTERFACEKEY_STRING_A053, "STRING_A053");
  bindingNames.insert(INTERFACEKEY_STRING_A054, "STRING_A054");
  bindingNames.insert(INTERFACEKEY_STRING_A055, "STRING_A055");
  bindingNames.insert(INTERFACEKEY_STRING_A056, "STRING_A056");
  bindingNames.insert(INTERFACEKEY_STRING_A057, "STRING_A057");
  bindingNames.insert(INTERFACEKEY_STRING_A058, "STRING_A058");
  bindingNames.insert(INTERFACEKEY_STRING_A059, "STRING_A059");
  bindingNames.insert(INTERFACEKEY_STRING_A060, "STRING_A060");
  bindingNames.insert(INTERFACEKEY_STRING_A061, "STRING_A061");
  bindingNames.insert(INTERFACEKEY_STRING_A062, "STRING_A062");
  bindingNames.insert(INTERFACEKEY_STRING_A063, "STRING_A063");
  bindingNames.insert(INTERFACEKEY_STRING_A064, "STRING_A064");
  bindingNames.insert(INTERFACEKEY_STRING_A065, "STRING_A065");
  bindingNames.insert(INTERFACEKEY_STRING_A066, "STRING_A066");
  bindingNames.insert(INTERFACEKEY_STRING_A067, "STRING_A067");
  bindingNames.insert(INTERFACEKEY_STRING_A068, "STRING_A068");
  bindingNames.insert(INTERFACEKEY_STRING_A069, "STRING_A069");
  bindingNames.insert(INTERFACEKEY_STRING_A070, "STRING_A070");
  bindingNames.insert(INTERFACEKEY_STRING_A071, "STRING_A071");
  bindingNames.insert(INTERFACEKEY_STRING_A072, "STRING_A072");
  bindingNames.insert(INTERFACEKEY_STRING_A073, "STRING_A073");
  bindingNames.insert(INTERFACEKEY_STRING_A074, "STRING_A074");
  bindingNames.insert(INTERFACEKEY_STRING_A075, "STRING_A075");
  bindingNames.insert(INTERFACEKEY_STRING_A076, "STRING_A076");
  bindingNames.insert(INTERFACEKEY_STRING_A077, "STRING_A077");
  bindingNames.insert(INTERFACEKEY_STRING_A078, "STRING_A078");
  bindingNames.insert(INTERFACEKEY_STRING_A079, "STRING_A079");
  bindingNames.insert(INTERFACEKEY_STRING_A080, "STRING_A080");
  bindingNames.insert(INTERFACEKEY_STRING_A081, "STRING_A081");
  bindingNames.insert(INTERFACEKEY_STRING_A082, "STRING_A082");
  bindingNames.insert(INTERFACEKEY_STRING_A083, "STRING_A083");
  bindingNames.insert(INTERFACEKEY_STRING_A084, "STRING_A084");
  bindingNames.insert(INTERFACEKEY_STRING_A085, "STRING_A085");
  bindingNames.insert(INTERFACEKEY_STRING_A086, "STRING_A086");
  bindingNames.insert(INTERFACEKEY_STRING_A087, "STRING_A087");
  bindingNames.insert(INTERFACEKEY_STRING_A088, "STRING_A088");
  bindingNames.insert(INTERFACEKEY_STRING_A089, "STRING_A089");
  bindingNames.insert(INTERFACEKEY_STRING_A090, "STRING_A090");
  bindingNames.insert(INTERFACEKEY_STRING_A091, "STRING_A091");
  bindingNames.insert(INTERFACEKEY_STRING_A092, "STRING_A092");
  bindingNames.insert(INTERFACEKEY_STRING_A093, "STRING_A093");
  bindingNames.insert(INTERFACEKEY_STRING_A094, "STRING_A094");
  bindingNames.insert(INTERFACEKEY_STRING_A095, "STRING_A095");
  bindingNames.insert(INTERFACEKEY_STRING_A096, "STRING_A096");
  bindingNames.insert(INTERFACEKEY_STRING_A097, "STRING_A097");
  bindingNames.insert(INTERFACEKEY_STRING_A098, "STRING_A098");
  bindingNames.insert(INTERFACEKEY_STRING_A099, "STRING_A099");
  bindingNames.insert(INTERFACEKEY_STRING_A100, "STRING_A100");
  bindingNames.insert(INTERFACEKEY_STRING_A101, "STRING_A101");
  bindingNames.insert(INTERFACEKEY_STRING_A102, "STRING_A102");
  bindingNames.insert(INTERFACEKEY_STRING_A103, "STRING_A103");
  bindingNames.insert(INTERFACEKEY_STRING_A104, "STRING_A104");
  bindingNames.insert(INTERFACEKEY_STRING_A105, "STRING_A105");
  bindingNames.insert(INTERFACEKEY_STRING_A106, "STRING_A106");
  bindingNames.insert(INTERFACEKEY_STRING_A107, "STRING_A107");
  bindingNames.insert(INTERFACEKEY_STRING_A108, "STRING_A108");
  bindingNames.insert(INTERFACEKEY_STRING_A109, "STRING_A109");
  bindingNames.insert(INTERFACEKEY_STRING_A110, "STRING_A110");
  bindingNames.insert(INTERFACEKEY_STRING_A111, "STRING_A111");
  bindingNames.insert(INTERFACEKEY_STRING_A112, "STRING_A112");
  bindingNames.insert(INTERFACEKEY_STRING_A113, "STRING_A113");
  bindingNames.insert(INTERFACEKEY_STRING_A114, "STRING_A114");
  bindingNames.insert(INTERFACEKEY_STRING_A115, "STRING_A115");
  bindingNames.insert(INTERFACEKEY_STRING_A116, "STRING_A116");
  bindingNames.insert(INTERFACEKEY_STRING_A117, "STRING_A117");
  bindingNames.insert(INTERFACEKEY_STRING_A118, "STRING_A118");
  bindingNames.insert(INTERFACEKEY_STRING_A119, "STRING_A119");
  bindingNames.insert(INTERFACEKEY_STRING_A120, "STRING_A120");
  bindingNames.insert(INTERFACEKEY_STRING_A121, "STRING_A121");
  bindingNames.insert(INTERFACEKEY_STRING_A122, "STRING_A122");
  bindingNames.insert(INTERFACEKEY_STRING_A123, "STRING_A123");
  bindingNames.insert(INTERFACEKEY_STRING_A124, "STRING_A124");
  bindingNames.insert(INTERFACEKEY_STRING_A125, "STRING_A125");
  bindingNames.insert(INTERFACEKEY_STRING_A126, "STRING_A126");
  bindingNames.insert(INTERFACEKEY_STRING_A127, "STRING_A127");
  bindingNames.insert(INTERFACEKEY_STRING_A128, "STRING_A128");
  bindingNames.insert(INTERFACEKEY_STRING_A129, "STRING_A129");
  bindingNames.insert(INTERFACEKEY_STRING_A130, "STRING_A130");
  bindingNames.insert(INTERFACEKEY_STRING_A131, "STRING_A131");
  bindingNames.insert(INTERFACEKEY_STRING_A132, "STRING_A132");
  bindingNames.insert(INTERFACEKEY_STRING_A133, "STRING_A133");
  bindingNames.insert(INTERFACEKEY_STRING_A134, "STRING_A134");
  bindingNames.insert(INTERFACEKEY_STRING_A135, "STRING_A135");
  bindingNames.insert(INTERFACEKEY_STRING_A136, "STRING_A136");
  bindingNames.insert(INTERFACEKEY_STRING_A137, "STRING_A137");
  bindingNames.insert(INTERFACEKEY_STRING_A138, "STRING_A138");
  bindingNames.insert(INTERFACEKEY_STRING_A139, "STRING_A139");
  bindingNames.insert(INTERFACEKEY_STRING_A140, "STRING_A140");
  bindingNames.insert(INTERFACEKEY_STRING_A141, "STRING_A141");
  bindingNames.insert(INTERFACEKEY_STRING_A142, "STRING_A142");
  bindingNames.insert(INTERFACEKEY_STRING_A143, "STRING_A143");
  bindingNames.insert(INTERFACEKEY_STRING_A144, "STRING_A144");
  bindingNames.insert(INTERFACEKEY_STRING_A145, "STRING_A145");
  bindingNames.insert(INTERFACEKEY_STRING_A146, "STRING_A146");
  bindingNames.insert(INTERFACEKEY_STRING_A147, "STRING_A147");
  bindingNames.insert(INTERFACEKEY_STRING_A148, "STRING_A148");
  bindingNames.insert(INTERFACEKEY_STRING_A149, "STRING_A149");
  bindingNames.insert(INTERFACEKEY_STRING_A150, "STRING_A150");
  bindingNames.insert(INTERFACEKEY_STRING_A151, "STRING_A151");
  bindingNames.insert(INTERFACEKEY_STRING_A152, "STRING_A152");
  bindingNames.insert(INTERFACEKEY_STRING_A153, "STRING_A153");
  bindingNames.insert(INTERFACEKEY_STRING_A154, "STRING_A154");
  bindingNames.insert(INTERFACEKEY_STRING_A155, "STRING_A155");
  bindingNames.insert(INTERFACEKEY_STRING_A156, "STRING_A156");
  bindingNames.insert(INTERFACEKEY_STRING_A157, "STRING_A157");
  bindingNames.insert(INTERFACEKEY_STRING_A158, "STRING_A158");
  bindingNames.insert(INTERFACEKEY_STRING_A159, "STRING_A159");
  bindingNames.insert(INTERFACEKEY_STRING_A160, "STRING_A160");
  bindingNames.insert(INTERFACEKEY_STRING_A161, "STRING_A161");
  bindingNames.insert(INTERFACEKEY_STRING_A162, "STRING_A162");
  bindingNames.insert(INTERFACEKEY_STRING_A163, "STRING_A163");
  bindingNames.insert(INTERFACEKEY_STRING_A164, "STRING_A164");
  bindingNames.insert(INTERFACEKEY_STRING_A165, "STRING_A165");
  bindingNames.insert(INTERFACEKEY_STRING_A166, "STRING_A166");
  bindingNames.insert(INTERFACEKEY_STRING_A167, "STRING_A167");
  bindingNames.insert(INTERFACEKEY_STRING_A168, "STRING_A168");
  bindingNames.insert(INTERFACEKEY_STRING_A169, "STRING_A169");
  bindingNames.insert(INTERFACEKEY_STRING_A170, "STRING_A170");
  bindingNames.insert(INTERFACEKEY_STRING_A171, "STRING_A171");
  bindingNames.insert(INTERFACEKEY_STRING_A172, "STRING_A172");
  bindingNames.insert(INTERFACEKEY_STRING_A173, "STRING_A173");
  bindingNames.insert(INTERFACEKEY_STRING_A174, "STRING_A174");
  bindingNames.insert(INTERFACEKEY_STRING_A175, "STRING_A175");
  bindingNames.insert(INTERFACEKEY_STRING_A176, "STRING_A176");
  bindingNames.insert(INTERFACEKEY_STRING_A177, "STRING_A177");
  bindingNames.insert(INTERFACEKEY_STRING_A178, "STRING_A178");
  bindingNames.insert(INTERFACEKEY_STRING_A179, "STRING_A179");
  bindingNames.insert(INTERFACEKEY_STRING_A180, "STRING_A180");
  bindingNames.insert(INTERFACEKEY_STRING_A181, "STRING_A181");
  bindingNames.insert(INTERFACEKEY_STRING_A182, "STRING_A182");
  bindingNames.insert(INTERFACEKEY_STRING_A183, "STRING_A183");
  bindingNames.insert(INTERFACEKEY_STRING_A184, "STRING_A184");
  bindingNames.insert(INTERFACEKEY_STRING_A185, "STRING_A185");
  bindingNames.insert(INTERFACEKEY_STRING_A186, "STRING_A186");
  bindingNames.insert(INTERFACEKEY_STRING_A187, "STRING_A187");
  bindingNames.insert(INTERFACEKEY_STRING_A188, "STRING_A188");
  bindingNames.insert(INTERFACEKEY_STRING_A189, "STRING_A189");
  bindingNames.insert(INTERFACEKEY_STRING_A190, "STRING_A190");
  bindingNames.insert(INTERFACEKEY_STRING_A191, "STRING_A191");
  bindingNames.insert(INTERFACEKEY_STRING_A192, "STRING_A192");
  bindingNames.insert(INTERFACEKEY_STRING_A193, "STRING_A193");
  bindingNames.insert(INTERFACEKEY_STRING_A194, "STRING_A194");
  bindingNames.insert(INTERFACEKEY_STRING_A195, "STRING_A195");
  bindingNames.insert(INTERFACEKEY_STRING_A196, "STRING_A196");
  bindingNames.insert(INTERFACEKEY_STRING_A197, "STRING_A197");
  bindingNames.insert(INTERFACEKEY_STRING_A198, "STRING_A198");
  bindingNames.insert(INTERFACEKEY_STRING_A199, "STRING_A199");
  bindingNames.insert(INTERFACEKEY_STRING_A200, "STRING_A200");
  bindingNames.insert(INTERFACEKEY_STRING_A201, "STRING_A201");
  bindingNames.insert(INTERFACEKEY_STRING_A202, "STRING_A202");
  bindingNames.insert(INTERFACEKEY_STRING_A203, "STRING_A203");
  bindingNames.insert(INTERFACEKEY_STRING_A204, "STRING_A204");
  bindingNames.insert(INTERFACEKEY_STRING_A205, "STRING_A205");
  bindingNames.insert(INTERFACEKEY_STRING_A206, "STRING_A206");
  bindingNames.insert(INTERFACEKEY_STRING_A207, "STRING_A207");
  bindingNames.insert(INTERFACEKEY_STRING_A208, "STRING_A208");
  bindingNames.insert(INTERFACEKEY_STRING_A209, "STRING_A209");
  bindingNames.insert(INTERFACEKEY_STRING_A210, "STRING_A210");
  bindingNames.insert(INTERFACEKEY_STRING_A211, "STRING_A211");
  bindingNames.insert(INTERFACEKEY_STRING_A212, "STRING_A212");
  bindingNames.insert(INTERFACEKEY_STRING_A213, "STRING_A213");
  bindingNames.insert(INTERFACEKEY_STRING_A214, "STRING_A214");
  bindingNames.insert(INTERFACEKEY_STRING_A215, "STRING_A215");
  bindingNames.insert(INTERFACEKEY_STRING_A216, "STRING_A216");
  bindingNames.insert(INTERFACEKEY_STRING_A217, "STRING_A217");
  bindingNames.insert(INTERFACEKEY_STRING_A218, "STRING_A218");
  bindingNames.insert(INTERFACEKEY_STRING_A219, "STRING_A219");
  bindingNames.insert(INTERFACEKEY_STRING_A220, "STRING_A220");
  bindingNames.insert(INTERFACEKEY_STRING_A221, "STRING_A221");
  bindingNames.insert(INTERFACEKEY_STRING_A222, "STRING_A222");
  bindingNames.insert(INTERFACEKEY_STRING_A223, "STRING_A223");
  bindingNames.insert(INTERFACEKEY_STRING_A224, "STRING_A224");
  bindingNames.insert(INTERFACEKEY_STRING_A225, "STRING_A225");
  bindingNames.insert(INTERFACEKEY_STRING_A226, "STRING_A226");
  bindingNames.insert(INTERFACEKEY_STRING_A227, "STRING_A227");
  bindingNames.insert(INTERFACEKEY_STRING_A228, "STRING_A228");
  bindingNames.insert(INTERFACEKEY_STRING_A229, "STRING_A229");
  bindingNames.insert(INTERFACEKEY_STRING_A230, "STRING_A230");
  bindingNames.insert(INTERFACEKEY_STRING_A231, "STRING_A231");
  bindingNames.insert(INTERFACEKEY_STRING_A232, "STRING_A232");
  bindingNames.insert(INTERFACEKEY_STRING_A233, "STRING_A233");
  bindingNames.insert(INTERFACEKEY_STRING_A234, "STRING_A234");
  bindingNames.insert(INTERFACEKEY_STRING_A235, "STRING_A235");
  bindingNames.insert(INTERFACEKEY_STRING_A236, "STRING_A236");
  bindingNames.insert(INTERFACEKEY_STRING_A237, "STRING_A237");
  bindingNames.insert(INTERFACEKEY_STRING_A238, "STRING_A238");
  bindingNames.insert(INTERFACEKEY_STRING_A239, "STRING_A239");
  bindingNames.insert(INTERFACEKEY_STRING_A240, "STRING_A240");
  bindingNames.insert(INTERFACEKEY_STRING_A241, "STRING_A241");
  bindingNames.insert(INTERFACEKEY_STRING_A242, "STRING_A242");
  bindingNames.insert(INTERFACEKEY_STRING_A243, "STRING_A243");
  bindingNames.insert(INTERFACEKEY_STRING_A244, "STRING_A244");
  bindingNames.insert(INTERFACEKEY_STRING_A245, "STRING_A245");
  bindingNames.insert(INTERFACEKEY_STRING_A246, "STRING_A246");
  bindingNames.insert(INTERFACEKEY_STRING_A247, "STRING_A247");
  bindingNames.insert(INTERFACEKEY_STRING_A248, "STRING_A248");
  bindingNames.insert(INTERFACEKEY_STRING_A249, "STRING_A249");
  bindingNames.insert(INTERFACEKEY_STRING_A250, "STRING_A250");
  bindingNames.insert(INTERFACEKEY_STRING_A251, "STRING_A251");
  bindingNames.insert(INTERFACEKEY_STRING_A252, "STRING_A252");
  bindingNames.insert(INTERFACEKEY_STRING_A253, "STRING_A253");
  bindingNames.insert(INTERFACEKEY_STRING_A254, "STRING_A254");
  bindingNames.insert(INTERFACEKEY_STRING_A255, "STRING_A255");

  bindingNames.insert(INTERFACEKEY_RECORD_MACRO, "RECORD_MACRO");
  bindingNames.insert(INTERFACEKEY_PLAY_MACRO, "PLAY_MACRO");
  bindingNames.insert(INTERFACEKEY_SAVE_MACRO, "SAVE_MACRO");
  bindingNames.insert(INTERFACEKEY_LOAD_MACRO, "LOAD_MACRO");

  sdlNames.insert(SDLK_BACKSPACE, "Backspace");
  sdlNames.insert(SDLK_TAB, "Tab");
  sdlNames.insert(SDLK_CLEAR, "Clear");
  sdlNames.insert(SDLK_RETURN, "Enter");
  sdlNames.insert(SDLK_PAUSE, "Pause");
  sdlNames.insert(SDLK_ESCAPE, "Escape");
  sdlNames.insert(SDLK_SPACE, "Space");
  sdlNames.insert(SDLK_EXCLAIM, "Exclaim");
  sdlNames.insert(SDLK_QUOTEDBL, "Quotedbl");
  sdlNames.insert(SDLK_HASH, "Hash");
  sdlNames.insert(SDLK_DOLLAR, "Dollar");
  sdlNames.insert(SDLK_AMPERSAND, "Ampersand");
  sdlNames.insert(SDLK_QUOTE, "Quote");
  sdlNames.insert(SDLK_LEFTPAREN, "Leftparen");
  sdlNames.insert(SDLK_RIGHTPAREN, "Rightparen");
  sdlNames.insert(SDLK_ASTERISK, "Asterisk");
  sdlNames.insert(SDLK_PLUS, "Plus");
  sdlNames.insert(SDLK_COMMA, "Comma");
  sdlNames.insert(SDLK_MINUS, "Minus");
  sdlNames.insert(SDLK_PERIOD, "Period");
  sdlNames.insert(SDLK_SLASH, "Slash");
  sdlNames.insert(SDLK_0, "0");
  sdlNames.insert(SDLK_1, "1");
  sdlNames.insert(SDLK_2, "2");
  sdlNames.insert(SDLK_3, "3");
  sdlNames.insert(SDLK_4, "4");
  sdlNames.insert(SDLK_5, "5");
  sdlNames.insert(SDLK_6, "6");
  sdlNames.insert(SDLK_7, "7");
  sdlNames.insert(SDLK_8, "8");
  sdlNames.insert(SDLK_9, "9");
  sdlNames.insert(SDLK_COLON, "Colon");
  sdlNames.insert(SDLK_SEMICOLON, "Semicolon");
  sdlNames.insert(SDLK_LESS, "Less");
  sdlNames.insert(SDLK_EQUALS, "Equals");
  sdlNames.insert(SDLK_GREATER, "Greater");
  sdlNames.insert(SDLK_QUESTION, "Question");
  sdlNames.insert(SDLK_AT, "At");
  sdlNames.insert(SDLK_LEFTBRACKET, "Leftbracket");
  sdlNames.insert(SDLK_BACKSLASH, "Backslash");
  sdlNames.insert(SDLK_RIGHTBRACKET, "Rightbracket");
  sdlNames.insert(SDLK_CARET, "Caret");
  sdlNames.insert(SDLK_UNDERSCORE, "Underscore");
  sdlNames.insert(SDLK_BACKQUOTE, "Backquote");
  sdlNames.insert(SDLK_a, "a");
  sdlNames.insert(SDLK_b, "b");
  sdlNames.insert(SDLK_c, "c");
  sdlNames.insert(SDLK_d, "d");
  sdlNames.insert(SDLK_e, "e");
  sdlNames.insert(SDLK_f, "f");
  sdlNames.insert(SDLK_g, "g");
  sdlNames.insert(SDLK_h, "h");
  sdlNames.insert(SDLK_i, "i");
  sdlNames.insert(SDLK_j, "j");
  sdlNames.insert(SDLK_k, "k");
  sdlNames.insert(SDLK_l, "l");
  sdlNames.insert(SDLK_m, "m");
  sdlNames.insert(SDLK_n, "n");
  sdlNames.insert(SDLK_o, "o");
  sdlNames.insert(SDLK_p, "p");
  sdlNames.insert(SDLK_q, "q");
  sdlNames.insert(SDLK_r, "r");
  sdlNames.insert(SDLK_s, "s");
  sdlNames.insert(SDLK_t, "t");
  sdlNames.insert(SDLK_u, "u");
  sdlNames.insert(SDLK_v, "v");
  sdlNames.insert(SDLK_w, "w");
  sdlNames.insert(SDLK_x, "x");
  sdlNames.insert(SDLK_y, "y");
  sdlNames.insert(SDLK_z, "z");
  sdlNames.insert(SDLK_DELETE, "Delete");
  sdlNames.insert(SDLK_KP0, "Numpad 0");
  sdlNames.insert(SDLK_KP1, "Numpad 1");
  sdlNames.insert(SDLK_KP2, "Numpad 2");
  sdlNames.insert(SDLK_KP3, "Numpad 3");
  sdlNames.insert(SDLK_KP4, "Numpad 4");
  sdlNames.insert(SDLK_KP5, "Numpad 5");
  sdlNames.insert(SDLK_KP6, "Numpad 6");
  sdlNames.insert(SDLK_KP7, "Numpad 7");
  sdlNames.insert(SDLK_KP8, "Numpad 8");
  sdlNames.insert(SDLK_KP9, "Numpad 9");
  sdlNames.insert(SDLK_KP_PERIOD, "Numpad Period");
  sdlNames.insert(SDLK_KP_DIVIDE, "Numpad Divide");
  sdlNames.insert(SDLK_KP_MULTIPLY, "Numpad Multiply");
  sdlNames.insert(SDLK_KP_PLUS, "Numpad Plus");
  sdlNames.insert(SDLK_KP_MINUS, "Numpad Minus");
  sdlNames.insert(SDLK_KP_ENTER, "Numpad Enter");
  sdlNames.insert(SDLK_KP_EQUALS, "Numpad Equals");
  sdlNames.insert(SDLK_UP, "Up");
  sdlNames.insert(SDLK_DOWN, "Down");
  sdlNames.insert(SDLK_RIGHT, "Right");
  sdlNames.insert(SDLK_LEFT, "Left");
  sdlNames.insert(SDLK_INSERT, "Insert");
  sdlNames.insert(SDLK_HOME, "Home");
  sdlNames.insert(SDLK_END, "End");
  sdlNames.insert(SDLK_PAGEUP, "Page Up");
  sdlNames.insert(SDLK_PAGEDOWN, "Page Down");
  sdlNames.insert(SDLK_F1, "F1");
  sdlNames.insert(SDLK_F2, "F2");
  sdlNames.insert(SDLK_F3, "F3");
  sdlNames.insert(SDLK_F4, "F4");
  sdlNames.insert(SDLK_F5, "F5");
  sdlNames.insert(SDLK_F6, "F6");
  sdlNames.insert(SDLK_F7, "F7");
  sdlNames.insert(SDLK_F8, "F8");
  sdlNames.insert(SDLK_F9, "F9");
  sdlNames.insert(SDLK_F10, "F10");
  sdlNames.insert(SDLK_F11, "F11");
  sdlNames.insert(SDLK_F12, "F12");
  sdlNames.insert(SDLK_F13, "F13");
  sdlNames.insert(SDLK_F14, "F14");
  sdlNames.insert(SDLK_F15, "F15");
  sdlNames.insert(SDLK_NUMLOCK, "Numlock");
  sdlNames.insert(SDLK_CAPSLOCK, "Capslock");
  sdlNames.insert(SDLK_SCROLLOCK, "Scrollock");
  sdlNames.insert(SDLK_RSHIFT, "Rshift");
  sdlNames.insert(SDLK_LSHIFT, "Lshift");
  sdlNames.insert(SDLK_RCTRL, "Rctrl");
  sdlNames.insert(SDLK_LCTRL, "Lctrl");
  sdlNames.insert(SDLK_RALT, "Ralt");
  sdlNames.insert(SDLK_LALT, "Lalt");
  sdlNames.insert(SDLK_RMETA, "Rmeta");
  sdlNames.insert(SDLK_LMETA, "Lmeta");
  sdlNames.insert(SDLK_LSUPER, "Lsuper");
  sdlNames.insert(SDLK_RSUPER, "Rsuper");
  sdlNames.insert(SDLK_MODE, "Mode");
  sdlNames.insert(SDLK_COMPOSE, "Compose");
  sdlNames.insert(SDLK_HELP, "Help");
  sdlNames.insert(SDLK_PRINT, "Print");
  sdlNames.insert(SDLK_SYSREQ, "Sysreq");
  sdlNames.insert(SDLK_BREAK, "Break");
  sdlNames.insert(SDLK_MENU, "Menu");
  sdlNames.insert(SDLK_POWER, "Power");
  sdlNames.insert(SDLK_EURO, "Euro");
  sdlNames.insert(SDLK_UNDO, "Undo");
}

