--time for horror

-- C++ pushes random_creature_types before this runs; it's a table, maps name -> weight

-- there is nothing stopping you from adding new ones

water_based_random_creature={
    INSECT_DRAGONFLY=true,
    INSECT_DAMSELFLY=true,
    CRUSTACEAN_SHRIMP=true,
    CRUSTACEAN_LOBSTER=true,
    CRUSTACEAN_CRAB=true,
    AMPHIBIAN_TOAD=true,
    AMPHIBIAN_FROG=true,
    AMPHIBIAN_SALAMANDER=true,
    AMPHIBIAN_NEWT=true,
    CROCODILIAN_ALLIGATOR=true,
    CROCODILIAN_CROCODILE=true,
    REPTILE_ANACONDA=true,
    REPTILE_TURTLE=true,
    BIRD_DUCK=true,
    BIRD_GOOSE=true,
    BIRD_SWAN=true,
    BIRD_GULL=true,
    BIRD_LOON=true,
    BIRD_GREBE=true,
    BIRD_ALBATROSS=true,
    BIRD_PETREL=true,
    BIRD_PENGUIN=true,
    BIRD_PELICAN=true,
    BIRD_STORK=true,
    BIRD_FLAMINGO=true,
    BIRD_CRANE=true,
    BIRD_KINGFISHER=true,
    MAMMAL_OTTER=true,
    MAMMAL_WALRUS=true,
    MAMMAL_HIPPOPOTAMUS=true,
}

humanoidable_random_creature={
    AMPHIBIAN_TOAD=true,
    AMPHIBIAN_FROG=true,
    AMPHIBIAN_SALAMANDER=true,
    AMPHIBIAN_NEWT=true,
    CROCODILIAN_ALLIGATOR=true,
    CROCODILIAN_CROCODILE=true,
    REPTILE_LIZARD=true,
    REPTILE_CHAMELEON=true,
    REPTILE_IGUANA=true,
    REPTILE_GECKO=true,
    REPTILE_SKINK=true,
    REPTILE_GILA_MONSTER=true,
    REPTILE_MONITOR=true,
    --REPTILE_SERPENT=true,
    --REPTILE_VIPER=true,
    --REPTILE_RATTLESNAKE=true,
    --REPTILE_COBRA=true,
    --REPTILE_PYTHON=true,
    --REPTILE_ANACONDA=true,
    REPTILE_TURTLE=true,
    REPTILE_TORTOISE=true,
    MAMMAL_OPOSSUM=true,
    MAMMAL_KOALA=true,
    MAMMAL_WOMBAT=true,
    MAMMAL_KANGAROO=true,
    MAMMAL_SLOTH=true,
    MAMMAL_ANTEATER=true,
    MAMMAL_ARMADILLO=true,			
    MAMMAL_SQUIRREL=true,
    MAMMAL_MARMOT=true,
    MAMMAL_BEAVER=true,
    MAMMAL_GOPHER=true,
    MAMMAL_RAT=true,
    MAMMAL_MOUSE=true,
    MAMMAL_PORCUPINE=true,
    MAMMAL_CHINCHILLA=true,
    MAMMAL_CAVY=true,
    MAMMAL_CAPYBARA=true,
    MAMMAL_RABBIT=true,
    MAMMAL_HARE=true,
    MAMMAL_LEMUR=true,
    MAMMAL_LORIS=true,
    MAMMAL_MONKEY=true,
    MAMMAL_APE=true,
    MAMMAL_HEDGEHOG=true,
    MAMMAL_SHREW=true,
    MAMMAL_MOLE=true,
    --MAMMAL_FRUIT_BAT=true,
    --MAMMAL_BAT=true,
    MAMMAL_WOLF=true,
    MAMMAL_COYOTE=true,
    MAMMAL_FOX=true,
    MAMMAL_JACKAL=true,
    MAMMAL_RACCOON=true,
    MAMMAL_COATI=true,
    MAMMAL_WEASEL=true,
    MAMMAL_OTTER=true,
    MAMMAL_BADGER=true,
    MAMMAL_SKUNK=true,
    MAMMAL_BEAR=true,
    MAMMAL_PANDA=true,
    MAMMAL_CAT=true,
    MAMMAL_PANTHER=true,
    MAMMAL_MONGOOSE=true,
    MAMMAL_HYENA=true,
    MAMMAL_CIVET=true,
    MAMMAL_WALRUS=true,
    MAMMAL_PANGOLIN=true,
    MAMMAL_ELEPHANT=true,
    MAMMAL_MAMMOTH=true,
    MAMMAL_HORSE=true,
    MAMMAL_DONKEY=true,
    MAMMAL_ZEBRA=true,
    MAMMAL_TAPIR=true,
    MAMMAL_RHINOCEROS=true,
    MAMMAL_PIG=true,
    MAMMAL_WARTHOG=true,
    MAMMAL_HIPPOPOTAMUS=true,
    MAMMAL_CAMEL=true,
    MAMMAL_LLAMA=true,
    MAMMAL_GIRAFFE=true,
    MAMMAL_DEER=true,
    MAMMAL_ELK=true,
    MAMMAL_MOOSE=true,
    MAMMAL_ANTELOPE=true,
    MAMMAL_SHEEP=true,
    MAMMAL_GOAT=true,
    MAMMAL_BISON=true,
    MAMMAL_BUFFALO=true,
    MAMMAL_BULL=true,
}

cannot_be_good_random_creature={
    GENERAL_BLOB=true,
    INSECT_SILVERFISH=true,
    INSECT_COCKROACH=true,
    INSECT_LOUSE=true,
    INSECT_ASSASSIN_BUG=true,
    INSECT_WEEVIL=true,
    INSECT_DUNG_BEETLE=true,
    INSECT_FLY=true,
    INSECT_MOSQUITO=true,
    INSECT_FLEA=true,
    INSECT_MAGGOT=true,
    ARACHNID_SPIDER=true,
    ARACHNID_TARANTULA=true,
    ARACHNID_SCORPION=true,
    ARACHNID_TICK=true,
    ARACHNID_MITE=true,
    NEMATODE=true,
    MOLLUSC_SNAIL=true,
    MOLLUSC_SLUG=true,
    EARTHWORM=true,
    LEECH=true,
    BRISTLEWORM=true,
    RIBBON_WORM=true,
    FLAT_WORM=true,
    REPTILE_VIPER=true,
    REPTILE_RATTLESNAKE=true,
    REPTILE_COBRA=true,
    REPTILE_PYTHON=true,
    REPTILE_ANACONDA=true,
    BIRD_VULTURE=true,
    BIRD_BUZZARD=true,
}

not_beast_random_creature={
    GENERAL_BLOB=true,
    GENERAL_HUMANOID=true,
    GENERAL_QUADRUPED=true,
}

function is_valid_random_creature(creature, do_water, humanoid_only, is_good, beast_only)
	local l3=get_debug_logger(3)
    if not do_water and water_based_random_creature[creature] then 
		l3("Water failure")
		return false
	end
    if humanoid_only and not humanoidable_random_creature[creature] then 
		l3("Humanoid failure")
		return false
	 end
    if is_good and cannot_be_good_random_creature[creature] then 
		l3("Good failure")
		return false 
	end
    if beast_only and not_beast_random_creature[creature] then 
		l3("Beast failure")
		return false 
	end
	get_debug_logger(5)("Success")
    return true
end

random_creature_types_finalized=false -- global on purpose, users should be able to set this to false

random_creature_types_presorted={} -- Also global on purpose, in case modders find some horrible way to use this too

function finalize_random_creature_types()
    if random_creature_types_finalized then return end
    random_creature_types_finalized=true
    for k,v in pairs(random_creature_types) do
        v.type=k
        if v.front_digits then
            v.front_digits=math.min(v.front_digits,5)
            v.front_digits=math.max(v.front_digits,2)
            v.front_digits=math.floor(v.front_digits)
        end
        if v.rear_digits then
            v.rear_digits=math.min(v.rear_digits,5)
            v.rear_digits=math.max(v.rear_digits,2)
            v.rear_digits=math.floor(v.rear_digits)
        end
        if humanoidable_random_creature[k] then v.humanoidable=true end
        random_creature_types_presorted[#random_creature_types_presorted+1]={k,v}
    end
    table.sort(random_creature_types_presorted,function(a,b) return a[1]<b[1] end)
end

function get_random_creature_profile(options,blacklist)
    local l3=get_debug_logger(3)
    local l5=get_debug_logger(4)
    finalize_random_creature_types()
    local candidates={}
    for i,tbl in ipairs(random_creature_types_presorted) do
        local k=tbl[1]
        local v=tbl[2]
        if (not blacklist or not blacklist[k]) and is_valid_random_creature(k,options.do_water,options.humanoid_only,options.is_good,options.beast_only) then
            candidates[#candidates+1]=v
            l5("Succeeded!",k)
        else
            l3("Failed! ",k,(not blacklist or not blacklist[k]))
        end
    end
    return pick_weighted_from_table(candidates) or random_creature_types.GENERAL_BLOB
end

local function quadruped_function_curry(is_grasp) -- thank you lua (or maybe don't?)
	local first_leg,front_leg,walk_var
	if is_grasp then
		first_leg="RCP_FIRST_SIMPLE_LEGS_GRASP"
		front_leg="RCP_SIMPLE_FRONT_LEGS_GRASP"
		walk_var="STANDARD_WALKING_GAITS"
	else
		first_leg="RCP_FIRST_SIMPLE_LEGS"
		front_leg="RCP_SIMPLE_FRONT_LEGS"
		walk_var="STANDARD_QUADRUPED_GAITS"
	end
	return function(rcp,options)
		local bp={"RCP_UPPER_BODY","RCP_LOWER_BODY","RCP_NECK","RCP_HEAD"}
		if not options.btc and not rcp.cannot_have_get_more_legs and one_in(20) then
			if one_in(2) then
				options.btc="EIGHT_LEGGED"
				table_merge(bp,{first_leg,"RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_FOURTH_SIMPLE_LEGS"})
			else
				options.btc="SIX_LEGGED"
				table_merge(bp,{first_leg,"RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS"})
			end
		else
			table_merge(bp,{front_leg,"RCP_SIMPLE_REAR_LEGS"})
		end
		if rcp.must_have_mantis_arms then
			options.pcg_layering_base="BEAST_INSECT"
		elseif rcp.cannot_have_get_more_legs and not rcp.slinky_quadruped then
			options.pcg_layering_base=pick_random({"BEAST_QUADRUPED_SLINKY","BEAST_QUADRUPED_BULKY"})
		elseif is_grasp then
			options.pcg_layering_base="BEAST_FRONT_GRASP"
		elseif rcp.slinky_quadruped then
			options.pcg_layering_base="BEAST_QUADRUPED_SLINKY"
		else
			options.pcg_layering_base="BEAST_QUADRUPED_BULKY"
		end
		options.walk_var=walk_var
		options.walk_speed=900
		return bp
	end
end

-- You can add more of these too
body_base_fun=body_base_fun or {
	AMORPHOUS=function(rcp,options)
		options.pcg_layering_base="BEAST_AMORPHOUS"
		options.walk_speed=2900
		options.walk_var="STANDARD_WALK_CRAWL_GAITS"
		return {"RCP_BASIC_BODY_STANCE_WITH_HEAD_FLAG"}
	end,
	INSECT=function(rcp,options)
		options.pcg_layering_base="BEAST_INSECT"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_THORAX","RCP_ABDOMEN","RCP_NECK","RCP_HEAD","RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS"}
	end,
	INSECT_LARVA=function(rcp,options)
		options.pcg_layering_base="BEAST_WORM_SHORT"
		options.walk_var="STANDARD_WALK_CRAWL_GAITS"
		options.walk_speed=2900
		return {"RCP_BASIC_BODY","RCP_NECK","RCP_HEAD","RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS"}
	end,
	SPIDER=function(rcp,options)
		options.pcg_layering_base="BEAST_SPIDER"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_CEPHALOTHORAX","RCP_ABDOMEN","RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_FOURTH_SIMPLE_LEGS"}
	end,
	SCORPION=function(rcp,options)
		options.pcg_layering_base="BEAST_SCORPION"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_CEPHALOTHORAX","RCP_ABDOMEN","RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_PINCERS"}
	end,
	TEN_LEGGED=function(rcp,options)
		options.pcg_layering_base="BEAST_SPIDER"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_BASIC_BODY","RCP_NECK","RCP_HEAD",
		"RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_FOURTH_SIMPLE_LEGS","RCP_FIFTH_SIMPLE_LEGS"}
	end,
	EIGHT_LEGGED=function(rcp,options)
		options.pcg_layering_base="BEAST_SPIDER"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_BASIC_BODY","RCP_NECK","RCP_HEAD","RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_FOURTH_SIMPLE_LEGS"}
	end,
	TEN_LEGGED_LOBSTERFORM=function(rcp,options)
		options.pcg_layering_base="BEAST_SCORPION"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_BASIC_BODY","RCP_NECK","RCP_HEAD",
		"RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_FOURTH_SIMPLE_LEGS","RCP_FIFTH_SIMPLE_LEGS"}
	end,
	EIGHT_LEGGED_LOBSTERFORM=function(rcp,options)
		options.pcg_layering_base="BEAST_SCORPION"
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_BASIC_BODY","RCP_NECK","RCP_HEAD","RCP_FIRST_SIMPLE_LEGS","RCP_SECOND_SIMPLE_LEGS","RCP_THIRD_SIMPLE_LEGS","RCP_FOURTH_SIMPLE_LEGS"}
	end,
	WORM=function(rcp,options)
		options.pcg_layering_base="BEAST_WORM_LONG"
		options.walk_var="STANDARD_WALK_CRAWL_GAITS"
		options.walk_speed=2900
		return {"RCP_BASIC_BODY_STANCE_WITH_HEAD_FLAG"}
	end,
	NO_LIMB=function(rcp,options)
		options.pcg_layering_base="BEAST_WALRUS"
		options.walk_var="STANDARD_WALK_CRAWL_GAITS"
		options.walk_speed=2900
		return {"RCP_UPPER_BODY","RCP_LOWER_BODY","RCP_NECK","RCP_HEAD"}
	end,
	QUADRUPED=quadruped_function_curry(false),
	QUADRUPED_FRONT_GRASP=quadruped_function_curry(true),
	SNAKE=function(rcp,options)
		options.tail_count=1
		options.pcg_layering_base="BEAST_SNAKE"
		options.walk_var="STANDARD_WALK_CRAWL_GAITS"
		options.walk_speed=900
		return {"RCP_BASIC_BODY_STANCE","RCP_NECK","RCP_HEAD","RCP_TAIL"}
	end,
	BIPEDAL_DINOSAUR=function(rcp,options)
		options.pcg_layering_base="BEAST_BIPEDAL_DINOSAUR"
		options.walk_var="STANDARD_BIPED_GAITS"
		options.walk_speed=900
		return {"RCP_UPPER_BODY","RCP_LOWER_BODY","RCP_NECK","RCP_HEAD","RCP_TWO_PART_ARMS","RCP_TWO_PART_LEGS"}
	end,
	HUMANOID=function(rcp,options)
		options.pcg_layering_base="BEAST_HUMANOID"
		options.walk_var="STANDARD_BIPED_GAITS"
		options.walk_speed=900
		return {"RCP_UPPER_BODY","RCP_LOWER_BODY","RCP_NECK","RCP_HEAD","RCP_TWO_PART_ARMS","RCP_TWO_PART_LEGS"}
	end,
	TWO_LEGS_NO_ARMS=function(rcp,options)
		options.pcg_layering_base="BEAST_BIPEDAL_DINOSAUR"
		options.use_armless_base=true
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_UPPER_BODY","RCP_LOWER_BODY","RCP_NECK","RCP_HEAD","RCP_TWO_PART_LEGS"}
	end,
	TWO_LEGS_NO_ARMS_HUMANOID=function(rcp,options)
		options.pcg_layering_base="BEAST_HUMANOID"
		options.use_armless_base=true
		options.walk_var="STANDARD_WALKING_GAITS"
		options.walk_speed=900
		return {"RCP_UPPER_BODY","RCP_LOWER_BODY","RCP_NECK","RCP_HEAD","RCP_TWO_PART_LEGS"}
	end
}

pcg_layering_base_info={
	BEAST_AMORPHOUS={shell_pos="BACK"},
	BEAST_SNAKE={shell_pos="BACK",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_WORM_LONG={shell_pos="BACK",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_WORM_SHORT={shell_pos="BACK",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_INSECT={shell_pos="FRONT",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_SPIDER={shell_pos="FRONT",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_SCORPION={tail=true,shell_pos="FRONT",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_BIPEDAL_DINOSAUR={tail=true,shell_pos="FRONT",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_HUMANOID={tail=true,shell_pos="BACK",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_FRONT_GRASP={tail=true,shell_pos="BACK",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_QUADRUPED_BULKY={tail=true,shell_pos="FRONT",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_QUADRUPED_SLINKY={tail=true,shell_pos="FRONT",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
	BEAST_WALRUS={tail=true,shell_pos="BACK",lacy_wings={"BACK","FRONT"},feathered_wings={"BACK","FRONT"},bat_wings={"BACK","FRONT"}},
}

random_creature_types=random_creature_types or {
	--1 OF EACH OF THESE
	GENERAL_BLOB={
		name_string="blob",
		tile='B',
		body_base="AMORPHOUS",
		c_class="UNIFORM",
		requires_flexible_material=true,
		min_size=70000,
		weight=1000
		},
	GENERAL_QUADRUPED={
		name_string="quadruped",
		tile='Q',
		body_base="QUADRUPED",
		c_class="UNIFORM",
		cannot_have_get_more_legs=true,
		min_size=70000,
		weight=1000
		},
	GENERAL_HUMANOID={
		name_string="humanoid",
		tile='H',
		body_base="HUMANOID",
		c_class="UNIFORM",
		min_size=70000,
		weight=1000
		},
	--44 OF THESE -- IN GENERAL, WE WANT THE POINTS DISTRIBUTED TO EACH LARGE GROUP TO EQUAL 1000
	INSECT_SILVERFISH={
		name_string="silverfish",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_MAYFLY={
		name_string="mayfly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_DRAGONFLY={
		name_string="dragonfly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_DAMSELFLY={
		name_string="damselfly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_STONEFLY={
		name_string="stonefly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_EARWIG={
		name_string="earwig",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_GRASSHOPPER={
		name_string="grasshopper",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_CRICKET={
		name_string="cricket",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_STICK_INSECT={
		name_string="stick insect",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_COCKROACH={
		name_string="cockroach",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_TERMITE={
		name_string="termite",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_MANTIS={
		name_string="mantis",
		tile='I',
		body_base="QUADRUPED",
		c_class="CHITIN_EXO",
		must_have_mantis_arms=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		cannot_have_get_more_legs=true,
		min_size=70000,
		weight=22},
	INSECT_LOUSE={
		name_string="louse",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_THRIPS={
		name_string="thrips",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_APHID={
		name_string="aphid",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_CICADA={
		name_string="cicada",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_ASSASSIN_BUG={
		name_string="assassin bug",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_WASP={
		name_string="wasp",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_insect_stinger=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_BEE={
		name_string="bee",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_insect_stinger=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_HORNET={
		name_string="hornet",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_insect_stinger=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_ANT={
		name_string="ant",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_TIGER_BEETLE={
		name_string="tiger beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_LADYBUG={
		name_string="ladybug",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_WEEVIL={
		name_string="weevil",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_DARKLING_BEETLE={
		name_string="darkling beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_CLICK_BEETLE={
		name_string="click beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_FIREFLY={
		name_string="firefly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_SCARAB_BEETLE={
		name_string="scarab beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_STAG_BEETLE={
		name_string="stag beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_giant_mandibles=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_DUNG_BEETLE={
		name_string="dung beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_RHINOCEROS_BEETLE={
		name_string="rhinoceros beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_one_head_horn=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_ROVE_BEETLE={
		name_string="rove beetle",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_SNAKEFLY={
		name_string="snakefly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_LACEWING={
		name_string="lacewing",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_ANTLION={
		name_string="antlion larva",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_FLY={
		name_string="fly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_MOSQUITO={
		name_string="mosquito",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_suck_blood_through_proboscis=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_FLEA={
		name_string="flea",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_SCORPIONFLY={
		name_string="scorpionfly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_CADDISFLY={
		name_string="caddisfly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_BUTTERFLY={
		name_string="butterfly",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_MOTH={
		name_string="moth",
		tile='I',
		body_base="INSECT",
		c_class="CHITIN_EXO",
		must_have_insect_wings=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_CATERPILLAR={
		name_string="caterpillar",
		tile='I',
		body_base="INSECT_LARVA",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=22},
	INSECT_MAGGOT={
		name_string="maggot",
		tile='I',
		body_base="INSECT_LARVA",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=22
		},
	-- 5 OF THESE
	ARACHNID_SPIDER={
		name_string="spider",
		tile='S',
		body_base="SPIDER",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		must_have_poison_bite=true,
		must_have_webs=true,
		min_size=70000,
		weight=200,
		},
	ARACHNID_TARANTULA={
		name_string="tarantula",
		tile='S',
		body_base="SPIDER",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		must_have_poison_bite=true,
		min_size=70000,
		weight=200,
		},
	ARACHNID_SCORPION={
		name_string="scorpion",
		tile='S',
		body_base="SCORPION",
		c_class="CHITIN_EXO",
		must_have_pincers=true,
		must_have_scorpion_tail=true,
		min_size=70000,
		weight=200,
		},
	ARACHNID_TICK={
		name_string="tick",
		tile='T',
		body_base="TEN_LEGGED",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=200,
		},
	ARACHNID_MITE={
		name_string="mite",
		tile='M',
		body_base="TEN_LEGGED",
		c_class="CHITIN_EXO",
		cannot_have_tail=true,
		min_size=70000,
		weight=200,
		},
	-- 3 OF THESE
	CRUSTACEAN_SHRIMP={
		name_string="shrimp",
		tile='S',
		body_base="TEN_LEGGED_LOBSTERFORM",
		c_class="CHITIN_EXO",
		must_have_antennae=true,
		must_have_crustacean_tail=true,
		min_size=70000,
		weight=250
		},
	CRUSTACEAN_LOBSTER={
		name_string="lobster",
		tile=157,
		body_base="EIGHT_LEGGED_LOBSTERFORM",
		c_class="CHITIN_EXO",
		must_have_grabbing_claws=true,
		must_have_crustacean_tail=true,
		min_size=70000,
		weight=250
		},
	CRUSTACEAN_CRAB={
		name_string="crab",
		tile='C',
		body_base="EIGHT_LEGGED",
		c_class="CHITIN_EXO",
		must_have_pincers=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=500
		},
	--8 OF THESE
	NEMATODE={
		name_string="nematode",
		tile='N',
		body_base="WORM",
		c_class="FLESHY",
		cannot_have_tail=true,
		min_size=70000,
		weight=75
		},
	MOLLUSC_SNAIL={
		name_string="snail",
		tile='S',
		body_base="WORM",
		c_class="FLESHY",
		must_have_shell=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=175
		},
	MOLLUSC_SLUG={
		name_string="slug",
		tile='S',
		body_base="WORM",
		c_class="FLESHY",
		cannot_have_shell=true,
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=175
		},
	EARTHWORM={
		name_string="earthworm",
		tile='W',
		body_base="WORM",
		c_class="FLESHY",
		cannot_have_tail=true,
		min_size=70000,
		weight=175
		},
	LEECH={
		name_string="leech",
		tile='L',
		body_base="WORM",
		c_class="FLESHY",
		must_suck_blood_through_mouth=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=175
		},
	BRISTLEWORM={
		name_string="bristleworm",
		tile='W',
		body_base="WORM",
		c_class="FLESHY",
		must_have_antennae=true,
		cannot_have_tail=true,
		min_size=70000,
		weight=75
		},
	RIBBON_WORM={
		name_string="ribbon worm",
		tile='W',
		body_base="WORM",
		c_class="FLESHY",
		cannot_have_tail=true,
		min_size=70000,
		weight=75
		},
	FLAT_WORM={
		name_string="flat worm",
		tile='W',
		body_base="WORM",
		c_class="FLESHY",
		cannot_have_tail=true,
		min_size=70000,
		weight=75
		},
	--4 OF THESE
	AMPHIBIAN_TOAD={
		name_string="toad",
		tile='T',
		body_base="QUADRUPED",
		c_class="AMPHIBIAN",
		cannot_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		weight=250
		},
	AMPHIBIAN_FROG={
		name_string="frog",
		tile='F',
		body_base="QUADRUPED",
		c_class="AMPHIBIAN",
		cannot_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		slinky_quadruped=true,
		weight=250
		},
	AMPHIBIAN_SALAMANDER={
		name_string="salamander",
		tile='S',
		body_base="QUADRUPED",
		c_class="AMPHIBIAN",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		slinky_quadruped=true,
		weight=250
		},
	AMPHIBIAN_NEWT={
		name_string="newt",
		tile='N',
		body_base="QUADRUPED",
		c_class="AMPHIBIAN",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		slinky_quadruped=true,
		weight=250
		},
	--2 of THESE
	CROCODILIAN_ALLIGATOR={
		name_string="alligator",
		tile='A',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=400000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=500
		},
	CROCODILIAN_CROCODILE={
		name_string="crocodile",
		tile='C',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=400000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=500
		},
	--15 OF THESE
	REPTILE_LIZARD={
		name_string="lizard",
		tile='L',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=198
		},
	REPTILE_CHAMELEON={
		name_string="chameleon",
		tile='C',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=44
		},
	REPTILE_IGUANA={
		name_string="iguana",
		tile='I',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=44
		},
	REPTILE_GECKO={
		name_string="gecko",
		tile='G',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		slinky_quadruped=true,
		weight=44
		},
	REPTILE_SKINK={
		name_string="skink",
		tile='S',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=44
		},
	REPTILE_GILA_MONSTER={
		name_string="gila monster",
		tile='G',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		must_have_poison_bite=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=44
		},
	REPTILE_MONITOR={
		name_string="monitor",
		tile='M',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=44
		},
	REPTILE_SERPENT={
		name_string="serpent",
		tile='S',
		body_base="SNAKE",
		c_class="REPTILE",
		cannot_have_tail=true,
		min_size=70000,
		weight=198
		},
	REPTILE_VIPER={
		name_string="viper",
		tile='V',
		body_base="SNAKE",
		c_class="REPTILE",
		cannot_have_tail=true,
		must_have_poison_bite=true,
		min_size=70000,
		weight=44
		},
	REPTILE_RATTLESNAKE={
		name_string="rattlesnake",
		tile='R',
		body_base="SNAKE",
		c_class="REPTILE",
		cannot_have_tail=true,
		must_have_poison_bite=true,
		min_size=70000,
		weight=33
		},
	REPTILE_COBRA={
		name_string="cobra",
		tile='C',
		body_base="SNAKE",
		c_class="REPTILE",
		cannot_have_tail=true,
		must_have_poison_bite=true,
		min_size=70000,
		weight=44
		},
	REPTILE_PYTHON={
		name_string="python",
		tile='P',
		body_base="SNAKE",
		c_class="REPTILE",
		cannot_have_tail=true,
		min_size=70000,
		weight=44
		},
	REPTILE_ANACONDA={
		name_string="anaconda",
		tile='A',
		body_base="SNAKE",
		c_class="REPTILE",
		cannot_have_tail=true,
		min_size=300000,
		weight=33
		},
	REPTILE_TURTLE={
		name_string="turtle",
		tile='T',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_shell=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		weight=66
		},
	REPTILE_TORTOISE={
		name_string="tortoise",
		tile='T',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_shell=true,
		min_size=70000,
		weight=66
		},
	--9 OF THESE, BUT GIVEN 1500 POINTS
	DINOSAUR_PTEROSAUR={--not actually dinosaur
		name_string="pterosaur",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="REPTILE",
		must_have_skin_wings=true,
		min_size=400000,
		front_digits=4,
		rear_digits=4,
		weight=250
		},
	DINOSAUR_DIMETRODON={--not actually dinosaur
		name_string="dimetrodon",
		tile='D',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		must_have_quills=true,
		must_have_plates=true,
		cannot_have_shell=true,
		min_size=500000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=250
		},
	DINOSAUR_SAUROPOD={--saurischia:X
		name_string="sauropod",
		tile='S',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=500000,
		weight=250
		},
	DINOSAUR_THEROPOD={--saurischia:X
		name_string="theropod",
		tile='T',
		body_base="BIPEDAL_DINOSAUR",
		c_class="REPTILE_FEATHERED",--theropod feathers
		must_have_tail=true,
		min_size=500000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		weight=250
		},
	DINOSAUR_IGUANODONT={--ornithischia:cerapoda:ornithopoda
		name_string="iguanodont",
		tile='I',
		body_base="BIPEDAL_DINOSAUR",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=500000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		weight=62
		},
	DINOSAUR_HADROSAURID={--ornithischia:cerapoda:ornithopoda:hadrosauroidea:X
		name_string="hadrosaurid",
		tile='H',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=500000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		weight=62
		},
	DINOSAUR_STEGOSAURID={--ornithischia:thyreophora:X
		name_string="stegosaurid",
		tile='S',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		must_have_plates=true,
		cannot_have_shell=true,
		min_size=500000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		weight=125
		},
	DINOSAUR_CERATOPSID={--ornithischia:cerapoda:ceratopsia:X
		name_string="ceratopsid",
		tile='C',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=500000,
		weight=125
		},
	DINOSAUR_ANKYLOSAURID={--ornithischia:thyreophora:ankylosauria:X
		name_string="ankylosaurid",
		tile='A',
		body_base="QUADRUPED",
		c_class="REPTILE",
		must_have_tail=true,
		min_size=500000,
		weight=125
		},
	--73 OF THESE
	BIRD_DUCK={
		name_string="duck",
		tile='D',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_GOOSE={
		name_string="goose",
		tile='G',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_SWAN={
		name_string="swan",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_TURKEY={
		name_string="turkey",
		tile='T',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_GROUSE={
		name_string="grouse",
		tile='G',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_CHICKEN={
		name_string="chicken",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_QUAIL={
		name_string="quail",
		tile='Q',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_PHEASANT={
		name_string="pheasant",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_GULL={
		name_string="gull",
		tile='G',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_LOON={
		name_string="loon",
		tile='L',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_GREBE={
		name_string="grebe",
		tile='G',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_ALBATROSS={
		name_string="albatross",
		tile='A',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_PETREL={
		name_string="petrel",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_PENGUIN={
		name_string="penguin",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		always_flightless=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_PELICAN={
		name_string="pelican",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_STORK={
		name_string="stork",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_VULTURE={
		name_string="vulture",
		tile='V',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_FLAMINGO={
		name_string="flamingo",
		tile='F',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_FALCON={
		name_string="falcon",
		tile='F',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_KESTREL={
		name_string="kestrel",
		tile='K',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_CONDOR={
		name_string="condor",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_OSPREY={
		name_string="osprey",
		tile='O',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_BUZZARD={
		name_string="buzzard",
		tile='B',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_EAGLE={
		name_string="eagle",
		tile='E',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_HARRIER={
		name_string="harrier",
		tile='H',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_HAWK={
		name_string="hawk",
		tile='H',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_KITE={
		name_string="kite",
		tile='K',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_CRANE={
		name_string="crane",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_DOVE={
		name_string="dove",
		tile='D',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_PIGEON={
		name_string="pigeon",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_PARROT={
		name_string="parrot",
		tile='P',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_COCKATOO={
		name_string="cockatoo",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_CUCKOO={
		name_string="cuckoo",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_OWL={
		name_string="owl",
		tile='O',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		default_talons=true,
		weight=13
		},
	BIRD_NIGHTJAR={
		name_string="nightjar",
		tile='N',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_SWIFT={
		name_string="swift",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_HUMMINGBIRD={
		name_string="hummingbird",
		tile='H',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_KINGFISHER={
		name_string="kingfisher",
		tile='K',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_HORNBILL={
		name_string="hornbill",
		tile='H',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_QUETZAL={
		name_string="quetzal",
		tile='Q',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_TOUCAN={
		name_string="toucan",
		tile='T',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_WOODPECKER={
		name_string="woodpecker",
		tile='W',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_LYREBIRD={
		name_string="lyrebird",
		tile='L',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_THORNBILL={
		name_string="thornbill",
		tile='T',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_HONEYEATER={
		name_string="honeyeater",
		tile='H',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_ORIOLE={
		name_string="oriole",
		tile='O',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		cannot_have_color=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_FANTAIL={
		name_string="fantail",
		tile='F',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_SHRIKE={
		name_string="shrike",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_CROW={
		name_string="crow",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_RAVEN={
		name_string="raven",
		tile='R',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_JAY={
		name_string="jay",
		tile='J',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_MAGPIE={
		name_string="magpie",
		tile='M',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_KINGLET={
		name_string="kinglet",
		tile='K',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_LARK={
		name_string="lark",
		tile='L',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_SWALLOW={
		name_string="swallow",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_MARTIN={
		name_string="martin",
		tile='M',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_BUSHTIT={
		name_string="bushtit",
		tile='B',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_WARBLER={
		name_string="warbler",
		tile='W',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_THRUSH={
		name_string="thrush",
		tile='T',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_OXPECKER={
		name_string="oxpecker",
		tile='O',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_STARLING={
		name_string="starling",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_MOCKINGBIRD={
		name_string="mockingbird",
		tile='M',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_WREN={
		name_string="wren",
		tile='W',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_NUTHATCH={
		name_string="nuthatch",
		tile='N',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_SPARROW={
		name_string="sparrow",
		tile='S',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_TANAGER={
		name_string="tanager",
		tile='T',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		cannot_have_color=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_CARDINAL={
		name_string="cardinal",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		cannot_have_color=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_BUNTING={
		name_string="bunting",
		tile='B',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_FINCH={
		name_string="finch",
		tile='F',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_TITMOUSE={
		name_string="titmouse",
		tile='T',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_CHICKADEE={
		name_string="chickadee",
		tile='C',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_WAXWING={
		name_string="waxwing",
		tile='W',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	BIRD_FLYCATCHER={
		name_string="flycatcher",
		tile='F',
		body_base="TWO_LEGS_NO_ARMS",
		c_class="AVIAN",
		must_have_feather_wings=true,
		must_have_feather_tail=true,
		min_size=70000,
		rear_digits=3,
		weight=13
		},
	--69 OF THESE
	MAMMAL_OPOSSUM={
		name_string="opossum",
		tile='O',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_KOALA={
		name_string="koala",
		tile='K',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		weight=14
		},
	MAMMAL_WOMBAT={
		name_string="wombat",
		tile='W',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_KANGAROO={
		name_string="kangaroo",
		tile='K',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=150000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_SLOTH={
		name_string="sloth",
		tile='S',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=3,
		rear_digits=3,
		default_claws=true,
		weight=14
		},
	MAMMAL_ANTEATER={
		name_string="anteater",
		tile='A',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14,
		},
	MAMMAL_ARMADILLO={
		name_string="armadillo",
		tile='A',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		weight=14
		},
	MAMMAL_SQUIRREL={
		name_string="squirrel",
		tile='S',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_MARMOT={
		name_string="marmot",
		tile='M',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_BEAVER={
		name_string="beaver",
		tile='B',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_GOPHER={
		name_string="gopher",
		tile='G',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_RAT={
		name_string="rat",
		tile='R',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_MOUSE={
		name_string="mouse",
		tile='M',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_PORCUPINE={
		name_string="porcupine",
		tile='P',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_CHINCHILLA={
		name_string="chinchilla",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_CAVY={
		name_string="cavy",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		min_size=70000,
		front_digits=4,
		rear_digits=3,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_CAPYBARA={
		name_string="capybara",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		min_size=70000,
		front_digits=4,
		rear_digits=3,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_RABBIT={
		name_string="rabbit",
		tile='R',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_HARE={
		name_string="hare",
		tile='H',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_LEMUR={
		name_string="lemur",
		tile='L',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_LORIS={
		name_string="loris",
		tile='L',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_nails=true,
		weight=14
		},
	MAMMAL_MONKEY={
		name_string="monkey",
		tile='M',
		body_base="QUADRUPED_FRONT_GRASP",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_nails=true,
		weight=14
		},
	MAMMAL_APE={
		name_string="ape",
		tile='A',
		body_base="QUADRUPED_FRONT_GRASP",
		c_class="MAMMAL",
		min_size=200000,
		front_digits=5,
		rear_digits=5,
		default_nails=true,
		weight=14
		},
	MAMMAL_HEDGEHOG={
		name_string="hedgehog",
		tile='H',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_SHREW={
		name_string="shrew",
		tile='S',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_MOLE={
		name_string="mole",
		tile='M',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_FRUIT_BAT={
		name_string="fruit bat",
		tile='F',
		body_base="TWO_LEGS_NO_ARMS_HUMANOID",
		c_class="MAMMAL",
		must_have_skin_wings=true,
		min_size=70000,
		rear_digits=5,
		default_claws=true,
		weight=14
		},
	MAMMAL_BAT={
		name_string="bat",
		tile='B',
		body_base="TWO_LEGS_NO_ARMS_HUMANOID",
		c_class="MAMMAL",
		must_have_skin_wings=true,
		min_size=70000,
		rear_digits=5,
		default_claws=true,
		weight=14
		},
	MAMMAL_WOLF={
		name_string="wolf",
		tile='W',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_COYOTE={
		name_string="coyote",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_FOX={
		name_string="fox",
		tile='F',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_JACKAL={
		name_string="jackal",
		tile='J',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_RACCOON={
		name_string="raccoon",
		tile='R',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_COATI={
		name_string="coati",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_WEASEL={
		name_string="weasel",
		tile='W',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_OTTER={
		name_string="otter",
		tile='O',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_BADGER={
		name_string="badger",
		tile='B',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		front_digits=5,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_SKUNK={
		name_string="skunk",
		tile='S',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		cannot_have_color=true,
		min_size=70000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_BEAR={
		name_string="bear",
		tile='B',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=400000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_PANDA={
		name_string="panda",
		tile='P',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=300000,
		front_digits=5,
		rear_digits=5,
		default_claws=true,
		default_paw_gloss=true,
		weight=14
		},
	MAMMAL_CAT={
		name_string="cat",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_PANTHER={
		name_string="panther",
		tile='P',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=400000,
		front_digits=5,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_MONGOOSE={
		name_string="mongoose",
		tile='M',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_HYENA={
		name_string="hyena",
		tile='H',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=300000,
		front_digits=4,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_CIVET={
		name_string="civet",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_WALRUS={
		name_string="walrus",
		tile='W',
		body_base="NO_LIMB",
		c_class="MAMMAL",
		must_have_walrus_flippers=true,
		min_size=500000,
		weight=14
		},
	MAMMAL_PANGOLIN={
		name_string="pangolin",
		tile='P',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		front_digits=5,
		rear_digits=4,
		default_claws=true,
		default_paw_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_ELEPHANT={
		name_string="elephant",
		tile='E',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		must_have_elephant_trunk=true,
		min_size=500000,
		weight=14
		},
	MAMMAL_MAMMOTH={
		name_string="mammoth",
		tile='M',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		must_have_elephant_trunk=true,
		min_size=500000,
		weight=14
		},
	MAMMAL_HORSE={
		name_string="horse",
		tile='H',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_DONKEY={
		name_string="donkey",
		tile='D',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_ZEBRA={
		name_string="zebra",
		tile='Z',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		cannot_have_color=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_TAPIR={
		name_string="tapir",
		tile='T',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=400000,
		front_digits=4,
		rear_digits=3,
		default_nails=true,
		weight=14
		},
	MAMMAL_RHINOCEROS={
		name_string="rhinoceros",
		tile='R',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		front_digits=3,
		rear_digits=3,
		default_nails=true,
		weight=14
		},
	MAMMAL_PIG={
		name_string="pig",
		tile='P',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		weight=14
		},
	MAMMAL_WARTHOG={
		name_string="warthog",
		tile='W',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=70000,
		default_hoof_gloss=true,
		weight=14
		},
	MAMMAL_HIPPOPOTAMUS={
		name_string="hippopotamus",
		tile='H',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		front_digits=4,
		rear_digits=4,
		weight=14
		},
	MAMMAL_CAMEL={
		name_string="camel",
		tile='C',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		front_digits=2,
		rear_digits=2,
		weight=14
		},
	MAMMAL_LLAMA={
		name_string="llama",
		tile='L',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		front_digits=2,
		rear_digits=2,
		weight=14
		},
	MAMMAL_GIRAFFE={
		name_string="giraffe",
		tile='G',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_DEER={
		name_string="deer",
		tile='D',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=400000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_ELK={
		name_string="elk",
		tile='E',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_MOOSE={
		name_string="moose",
		tile='M',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_ANTELOPE={
		name_string="antelope",
		tile='A',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=200000,
		default_hoof_gloss=true,
		slinky_quadruped=true,
		weight=14
		},
	MAMMAL_SHEEP={
		name_string="sheep",
		tile='S',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=200000,
		default_hoof_gloss=true,
		weight=14
		},
	MAMMAL_GOAT={
		name_string="goat",
		tile='G',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=200000,
		default_hoof_gloss=true,
		weight=14
		},
	MAMMAL_BISON={
		name_string="bison",
		tile='B',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		weight=14
		},
	MAMMAL_BUFFALO={
		name_string="buffalo",
		tile='B',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		weight=14
		},
	MAMMAL_BULL={
		name_string="bull",
		tile='B',
		body_base="QUADRUPED",
		c_class="MAMMAL",
		must_have_tail=true,
		min_size=500000,
		default_hoof_gloss=true,
		weight=14
		},
	}