//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

adventurerst::adventurerst(char for_load)
{
	if(!for_load)
		{
		global_id=game.next_adventurer_id;
		game.next_adventurer_id++;
		string blank;
		def=game.definition.get_adventurer_by_predecessor_with_xp_bound(blank,0);
		unspent_pool=0;
		random_name();
		have_announced=0;
		}

	game.adventurer.global.push_back(this);
}

adventurerst::~adventurerst()
{
	long t;
	for(t=(long)game.adventurer.global.size()-1;t>=0;t--)
		{
		if(game.adventurer.global[t]==this)
			{
			game.adventurer.global.erase(t);
			break;
			}
		}
}

void adventurerst::write_file(file_compressorst &filecomp)
{
	filecomp.write_file(name);
	filecomp.write_file(global_id);
	filecomp.write_file(trap_x);
	filecomp.write_file(trap_y);
	filecomp.write_file(death_string);
	filecomp.write_file(death_string2);
	kill_name.write_file(filecomp);
	filecomp.write_file(kill_xp);
	filecomp.write_file(kill_num);
	filecomp.write_file(unspent_pool);
	filecomp.write_file(have_announced);

	if(filecomp.save_posnull_pointer(def))
		{
		filecomp.write_file(def->token);
		}
}

void adventurerst::read_file(file_compressorst &filecomp,long loadversion)
{
	filecomp.read_file(name);
	filecomp.read_file(global_id);
	filecomp.read_file(trap_x);
	filecomp.read_file(trap_y);
	filecomp.read_file(death_string);
	filecomp.read_file(death_string2);
	kill_name.read_file(filecomp,loadversion);
	filecomp.read_file(kill_xp);
	filecomp.read_file(kill_num);
	filecomp.read_file(unspent_pool);
	filecomp.read_file(have_announced);

	if(filecomp.load_posnull_pointer())
		{
		string tok;
		filecomp.read_file(tok);
		def=game.definition.get_adventurer_by_token(tok);
		}
}

void adventurerst::add_seen_trap(short pitx,short pity)
{
	if(has_seen_trap(pitx,pity))return;

	trap_x.push_back(pitx);
	trap_y.push_back(pity);
}

char adventurerst::has_seen_trap(short pitx,short pity)
{
	long t;
	for(t=0;t<trap_x.size();t++)
		{
		if(trap_x[t]==pitx&&
			trap_y[t]==pity)return 1;
		}

	return 0;
}

void adventurerst::die(char hurled,string &c_name)
{
	game.set_sound(SOUND_ADVENTURER_DIE_1);

	death_string=" ";
	if(c_name.empty())
		{
		if(hurled)death_string+="was stung to death by a hurled bug";
		else death_string+="fell into a covered pit";
		}
	else
		{
		if(hurled)death_string+="was stung to death by a hurled ";
		else death_string+="fell into a pit and was stung by a ";
		death_string+=c_name;
		}

	death_string2="while exploring ";
	death_string2+=game.cave.name;
}

void adventurerst::give_kill(string &name,long xp)
{
	long add=xp;
	while(add>0)
		{
		unspent_pool+=trandom(100)+1;
		add--;
		}

	add_to_kill_list(name,xp);

	//IN CASE THE KOBOLD ITSELF PUSHES THE ADVENTURER OVER, YOU CAN SEE ADVANCEMENT IN-GAME
	advance_level();
}

void adventurerst::add_to_kill_list(string &name,long xp)
{
	long k;
	for(k=0;k<kill_name.str.size();k++)
		{
		//OLD KILL
		if(kill_name.str[k]->dat==name&&
			kill_xp[k]==xp)
			{
			kill_num[k]++;
			return;
			}
		//GOT TO THE LOWER STUFF
		if(kill_xp[k]<xp)
			{
			kill_name.insert_string(k,name);
			kill_xp.insert(k,xp);
			kill_num.insert(k,1);
			return;
			}
		}

	//IN CASE YOU ARE LOWEST
	kill_name.add_string(name);
	kill_xp.push_back(xp);
	kill_num.push_back(1);
}

void adventurerst::kill_monster_def(monster_definitionst *mdef)
{
	monster_definitionst *subdef;

	add_to_kill_list(mdef->name,mdef->xp_level);

	svector<monster_definitionst *> sub_def;
	svector<long> sub_num;

	long s;
	for(s=0;s<mdef->subord_chance.size();s++)
		{
		if(trandom(100)<mdef->subord_chance[s])
			{
			subdef=game.definition.get_monster_by_token(mdef->subord_token.str[s]->dat);
			if(subdef!=NULL)
				{
				long num=trandom(mdef->subord_max[s]-mdef->subord_min[s]+1)+mdef->subord_min[s];

				sub_def.push_back(subdef);
				sub_num.push_back(num);
				}
			}
		}

	while(unspent_pool>0)
		{
		//CLEAR SUB-ORDS THAT ARE OVER THE BAR
		long s;
		for(s=(long)sub_def.size()-1;s>=0;s--)
			{
			if(unspent_pool<sub_def[s]->xp_level||
				sub_num[s]<=0)
				{
				sub_def.erase(s);
				sub_num.erase(s);
				}
			}

		if(sub_def.size()==0)break;

		s=trandom(sub_def.size());
		subdef=sub_def[s];

		unspent_pool-=subdef->xp_level;

		kill_monster_def(subdef);

		sub_num[s]--;
		}
}

void adventurerst::spend_pool()
{
	monster_definitionst *mdef;
	while(unspent_pool>0)
		{
		mdef=game.definition.get_monster_by_max_xp(unspent_pool);
		if(mdef==NULL)break;
		unspent_pool-=mdef->xp_level;

		kill_monster_def(mdef);
		}

	advance_level();
}

long adventurerst::calc_total_xp()
{
	long xp=0;
	long t;
	for(t=0;t<kill_xp.size();t++)
		{
		xp+=kill_xp[t]*kill_num[t];
		}
	return xp;
}

void adventurerst::advance_level()
{
	if(def==NULL)return;

	long tot_xp=calc_total_xp();

	adventurer_definitionst *ndef;
	do
		{
		ndef=game.definition.get_adventurer_by_predecessor_with_xp_bound(def->token,tot_xp);
		if(ndef!=NULL)def=ndef;
		}while(ndef!=NULL);
}

void adventurerst::random_name()
{
	name.erase();

	text_infost ti;
	if(trandom(3))
		{
		enabler.text_system.get_text(TEXT_ADVNAME_OPENING,ti);
		name+=ti.get_string(0);
		}
	enabler.text_system.get_text(TEXT_ADVNAME_MIDDLE_VOWEL,ti);
	name+=ti.get_string(0);
	long syl=0;
	if(trandom(5))syl=1;
	if(!trandom(3))syl=2;
	while(syl>0)
		{
		enabler.text_system.get_text(TEXT_ADVNAME_MIDDLE_CONS,ti);
		name+=ti.get_string(0);
		enabler.text_system.get_text(TEXT_ADVNAME_MIDDLE_VOWEL,ti);
		name+=ti.get_string(0);
		syl--;
		}
	if(trandom(3))
		{
		enabler.text_system.get_text(TEXT_ADVNAME_ENDING,ti);
		name+=ti.get_string(0);
		}

	capitalize_string_first_word(name);
}