//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

class adventurerst
{
	friend class adventurer_handlerst;

	public:
		static adventurerst *create(){return new adventurerst(0);}
		static adventurerst *create_for_load(){return new adventurerst(1);}

		string name;
		long global_id;
		svector<short> trap_x;
		svector<short> trap_y;
		stringvectst kill_name;
		svector<long> kill_xp;
		svector<long> kill_num;
		string death_string,death_string2;
		long unspent_pool;
		adventurer_definitionst *def;
		char have_announced;

		void write_file(file_compressorst &filecomp);
		void read_file(file_compressorst &filecomp,long loadversion);

		void add_seen_trap(short pitx,short pity);
		char has_seen_trap(short pitx,short pity);
		void die(char hurled,string &c_name);

		void give_kill(string &name,long xp);
		void spend_pool();
		void add_to_kill_list(string &name,long xp);
		void advance_level();
		long calc_total_xp();

		void random_name();

		void kill_monster_def(monster_definitionst *mdef);

	protected:
		adventurerst(char for_load);
		~adventurerst();
};

class adventurer_handlerst
{
	public:
		svector<adventurerst *> global;

		void clean()
			{
			while(global.size()>0)remove_adventurer(global.size()-1);
			}

		void remove_adventurer(int e){delete global[e];}
		void remove_adventurer(adventurerst *ptr)
			{
			long t;
			for(t=(long)global.size()-1;t>=0;t--)
				{
				if(global[t]==ptr)
					{
					remove_adventurer(t);
					break;
					}
				}
			}

		adventurerst *get_adventurer_by_global_id(long id)
			{
			if(global.size()==0||id==-1)return NULL;

			return binary_get(0,(long)global.size()-1,id);
			}

		adventurerst *binary_get(long start,long end,long id)
			{
			if(start>end)return NULL;

			long mid=(start+end)>>1;

			if(global[mid]->global_id==id)return global[mid];
			if(start==end)return NULL;

			if(global[mid]->global_id>id)return binary_get(start,mid-1,id);
			else return binary_get(mid+1,end,id);
			}

		void add_adventurer(adventurerst *ptr)
			{
			if(ptr==NULL)return;
			long size=global.size();
			long t;
			for(t=0;t<size;t++)
				{
				if(global[t]->global_id==ptr->global_id)return;
				if(global[t]->global_id>ptr->global_id)
					{
					global.insert(t,ptr);
					break;
					}
				}
			if(t==size)global.push_back(ptr);
			}
		
		~adventurer_handlerst()
			{
			clean();
			}
};