//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

long convert_string_to_long(string &str)
{
	return atoi(str.c_str());
}

void add_long_to_string(long n,string &str)
{
	string str2;
	convert_long_to_string(n,str2);
	str+=str2;
}

void convert_long_to_string(long n,string &str)
{
	std::ostringstream o;
	o << n;
	str = o.str();
}

void errorlog_string(const char *ptr)
{
	if(ptr==NULL)return;

	//SAVE AN ERROR TO THE LOG FILE
	std::ofstream fseed("errorlog.txt", std::ios::out | std::ios::app);
	if(fseed.is_open())
		{
		fseed<<ptr<<std::endl;
		}
	fseed.close();
}

void errorlog_string(const string &str)
{
	if(str.empty())return;

	//SAVE AN ERROR TO THE LOG FILE
	std::ofstream fseed("errorlog.txt", std::ios::out | std::ios::app);
	if(fseed.is_open())
		{
		fseed<<str.c_str()<<std::endl;
		}
	fseed.close();
}

void gamelog_string(string &str)
{
	if(str.empty())return;

	//SAVE A MESSAGE TO THE LOG FILE
	std::ofstream fseed("gamelog.txt",std::ios::out | std::ios::app);
	if(fseed.is_open())
		{
		fseed<<str.c_str()<<std::endl;
		}
	fseed.close();
}

int is_in_short_vector(short a,svector<short> &v)
{
	int i;
	for(i=(int)v.size()-1;i>=0;i--)
		{
		if(v[i]==a)return i;
		}
	return -1;
}

int is_in_short_vectors(short a1,short a2,svector<short> &v1,svector<short> &v2)
{
	int i;
	for(i=(int)v1.size()-1;i>=0;i--)
		{
		if(v1[i]==a1&&
			v2[i]==a2)return i;
		}
	return -1;
}

void add_unique_short_to_vector(short nl,svector<short> &vc)
{
	long i;
	for(i=(short)vc.size()-1;i>=0;i--)
		{
		if(vc[i]==nl)return;
		}
	vc.push_back(nl);
}

void add_unique_long_to_vector(long nl,svector<long> &vc)
{
	long i;
	for(i=(long)vc.size()-1;i>=0;i--)
		{
		if(vc[i]==nl)return;
		}
	vc.push_back(nl);
}

void merge_vectors(svector<long> &master,svector<long> &merger)
{
	long i,i2;
	for(i=(long)merger.size()-1;i>=0;i--)
		{
		for(i2=(long)master.size()-1;i2>=0;i2--)
			{
			if(merger[i]==master[i2])break;
			}
		if(i2==-1)
			{
			master.push_back(merger[i]);
			}
		}
}

void cull_vectors(svector<long> &master,svector<long> &cull)
{
	long i,i2;
	for(i=(long)cull.size()-1;i>=0;i--)
		{
		for(i2=(long)master.size()-1;i2>=0;i2--)
			{
			if(cull[i]==master[i2])
				{
				master.erase(i2);
				break;
				}
			}
		}
}

void push_on_vector(svector<short> &master,svector<short> &new_stuff)
{
	long i;
	for(i=0;i<new_stuff.size();i++)master.push_back(new_stuff[i]);
}

void lower_case_string(string &str)
{
	long s;
	for(s=0;s<str.length();s++)
		{
		//CAPITALIZE
		if(str[s]>='A'&&str[s]<='Z')
			{
			str[s]-='A';
			str[s]+='a';
			}
		switch(str[s])
			{
			case (char)154:str[s]=(char)129;break;
			case (char)165:str[s]=(char)164;break;
			case (char)142:str[s]=(char)132;break;
			case (char)143:str[s]=(char)134;break;
			case (char)144:str[s]=(char)130;break;
			case (char)153:str[s]=(char)148;break;
			case (char)128:str[s]=(char)135;break;
			case (char)146:str[s]=(char)145;break;
			}
		}
}

void capitalize_string_words(string &str)
{
	char conf;
	long s;
	for(s=0;s<str.length();s++)
		{
		conf=0;
		if(s>0)
			{
			if(str[s-1]==' ')conf=1;
			}
		if(s==0||conf)
			{
			//CAPITALIZE
			if(str[s]>='a'&&str[s]<='z')
				{
				str[s]-='a';
				str[s]+='A';
				}
			switch(str[s])
				{
				case (char)129:str[s]=(char)154;break;
				case (char)164:str[s]=(char)165;break;
				case (char)132:str[s]=(char)142;break;
				case (char)134:str[s]=(char)143;break;
				case (char)130:str[s]=(char)144;break;
				case (char)148:str[s]=(char)153;break;
				case (char)135:str[s]=(char)128;break;
				case (char)145:str[s]=(char)146;break;
				}
			}
		}
}

void capitalize_string_first_word(string &str)
{
	char conf;
	long s;
	for(s=0;s<str.length();s++)
		{
		conf=0;
		if(s>0)
			{
			if(str[s-1]==' '||str[s-1]=='\"')conf=1;
			}
		if(s==0||conf)
			{
			//CAPITALIZE
			if(str[s]>='a'&&str[s]<='z')
				{
				str[s]-='a';
				str[s]+='A';
				return;
				}
			switch(str[s])
				{
				case (char)129:str[s]=(char)154;return;
				case (char)164:str[s]=(char)165;return;
				case (char)132:str[s]=(char)142;return;
				case (char)134:str[s]=(char)143;return;
				case (char)130:str[s]=(char)144;return;
				case (char)148:str[s]=(char)153;return;
				case (char)135:str[s]=(char)128;return;
				case (char)145:str[s]=(char)146;return;
				}
			if(str[s]!=' '&&str[s]!='\"')return;
			}
		}
}

void grab_token_string_pos(string &dest,string &source,long &pos,char compc)
{
	dest.erase();

	//GO UNTIL YOU HIT A compc, ], or the end
	int s;
	for(s=pos;s<source.length();s++)
		{
		if(source[s]==compc||source[s]==']')break;
		dest+=source[s];
		}
	pos+=dest.length();
}