//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

//#define NO_FMOD

#define GAME_TITLE_STRING "Kobold Quest"

#ifndef BITS

#define BITS

#define BIT1 1
#define BIT2 2
#define BIT3 4
#define BIT4 8
#define BIT5 16
#define BIT6 32
#define BIT7 64
#define BIT8 128
#define BIT9 256
#define BIT10 512
#define BIT11 1024
#define BIT12 2048
#define BIT13 4096
#define BIT14 8192
#define BIT15 16384
#define BIT16 32768
#define BIT17 65536
#define BIT18 131072
#define BIT19 262144
#define BIT20 524288
#define BIT21 1048576
#define BIT22 2097152
#define BIT23 4194304
#define BIT24 8388608
#define BIT25 16777216
#define BIT26 33554432
#define BIT27 67108864
#define BIT28 134217728
#define BIT29 268435456
#define BIT30 536870912
#define BIT31 1073741824
#define BIT32 2147483648

#endif

void gamelog_string(string &str);
void errorlog_string(const string &str);
void errorlog_string(const char *ptr);

//THIS ALLOWS US TO PUT STRINGS IN VECTORS
struct vstringst
{
	string pstring;
};

enum Song
{
	SONG_TITLE,
	SONGNUM
};

enum Sound
{
	SOUND_CLICK,
	SOUND_ADVENTURER_DIE_1,
	SOUND_ADVENTURER_DIE_2,
	SOUND_ADVENTURER_DIE_3,
	SOUND_ADVENTURER_DIE_4,
	SOUND_ADVENTURER_DIE_5,
	SOUND_ADVENTURER_TARGET_1,
	SOUND_ADVENTURER_TARGET_2,
	SOUND_ADVENTURER_TARGET_3,
	SOUND_ADVENTURER_TARGET_4,
	SOUND_ADVENTURER_TARGET_5,
	SOUND_ADVENTURER_DODGE_1,
	SOUND_ADVENTURER_DODGE_2,
	SOUND_ADVENTURER_DODGE_3,
	SOUND_ADVENTURER_DODGE_4,
	SOUND_ADVENTURER_DODGE_5,
	SOUND_ADVENTURER_KILL_1,
	SOUND_ADVENTURER_KILL_2,
	SOUND_ADVENTURER_KILL_3,
	SOUND_ADVENTURER_KILL_4,
	SOUND_ADVENTURER_KILL_5,
	SOUND_KOBOLD_COVER_1,
	SOUND_KOBOLD_COVER_2,
	SOUND_KOBOLD_COVER_3,
	SOUND_KOBOLD_COVER_4,
	SOUND_KOBOLD_COVER_5,
	SOUND_KOBOLD_DROP_1,
	SOUND_KOBOLD_DROP_2,
	SOUND_KOBOLD_DROP_3,
	SOUND_KOBOLD_DROP_4,
	SOUND_KOBOLD_DROP_5,
	SOUND_KOBOLD_PICKUP_1,
	SOUND_KOBOLD_PICKUP_2,
	SOUND_KOBOLD_PICKUP_3,
	SOUND_KOBOLD_PICKUP_4,
	SOUND_KOBOLD_PICKUP_5,
	SOUND_KOBOLD_SELECT_1,
	SOUND_KOBOLD_SELECT_2,
	SOUND_KOBOLD_SELECT_3,
	SOUND_KOBOLD_SELECT_4,
	SOUND_KOBOLD_SELECT_5,
	SOUNDNUM
};

enum Text
{
	TEXT_ADVNAME_OPENING,
	TEXT_ADVNAME_MIDDLE_VOWEL,
	TEXT_ADVNAME_MIDDLE_CONS,
	TEXT_ADVNAME_ENDING,
	TEXT_CRITTER_ADJ,
	TEXT_CRITTER_NOUN,
	TEXT_DESC_FORM1,
	TEXT_DESC_FORM2,
	TEXT_DESC_DELIVERY,
	TEXT_DESC_POISON1,
	TEXT_DESC_POISON2,
	TEXT_DESC_POISON3,
	TEXT_DESC_DEBATE1,
	TEXT_DESC_DEBATE2,
	TEXT_DESC_ORIGIN1,
	TEXT_DESC_ORIGIN2,
	TEXTNUM
};

#define MAXLINELIM 120000

long convert_string_to_long(string &str);
void add_long_to_string(long n,string &str);
void convert_long_to_string(long n,string &str);

int is_in_short_vector(short a,svector<short> &v);
int is_in_short_vectors(short a1,short a2,svector<short> &v1,svector<short> &v2);
void add_unique_short_to_vector(short nl,svector<short> &vc);
void add_unique_long_to_vector(long nl,svector<long> &vc);
void merge_vectors(svector<long> &master,svector<long> &merger);
void cull_vectors(svector<long> &master,svector<long> &cull);
void push_on_vector(svector<short> &master,svector<short> &new_stuff);

void lower_case_string(string &str);
void capitalize_string_words(string &str);
void capitalize_string_first_word(string &str);

void grab_token_string_pos(string &dest,string &source,long &pos,char compc=':');