//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

void cavest::write_file(file_compressorst &filecomp)
{
	short x,y;
	for(x=0;x<CAVE_DIM_X;x++)
		{
		for(y=0;y<CAVE_DIM_Y;y++)
			{
			map[x][y].write_file(filecomp);
			}
		}

	filecomp.write_file(trap_x);
	filecomp.write_file(trap_y);
	filecomp.write_file(trap_kobold_id);
	filecomp.write_file(trap_power);
	trap_name.write_file(filecomp);
	filecomp.write_file(entry_way_x);
	filecomp.write_file(entry_way_y);

	filecomp.write_file(name);
}

void cavest::read_file(file_compressorst &filecomp,long loadversion)
{
	short x,y;
	for(x=0;x<CAVE_DIM_X;x++)
		{
		for(y=0;y<CAVE_DIM_Y;y++)
			{
			map[x][y].read_file(filecomp,loadversion);
			}
		}

	filecomp.read_file(trap_x);
	filecomp.read_file(trap_y);
	filecomp.read_file(trap_kobold_id);
	filecomp.read_file(trap_power);
	trap_name.read_file(filecomp,loadversion);
	filecomp.read_file(entry_way_x);
	filecomp.read_file(entry_way_y);

	filecomp.read_file(name);
}

void cavest::print()
{
	short x,y;
	for(x=0;x<CAVE_DIM_X;x++)
		{
		for(y=0;y<CAVE_DIM_Y;y++)
			{
			gps.locate(y,x);

			switch(map[x][y].type)
				{
				case CAVE_SQUARE_WALL:
					if(lighting[x][y])gps.changecolor(7,0,0);
					else gps.changecolor(0,0,1);
					gps.addchar(219);
					break;
				case CAVE_SQUARE_FLOOR:
					if(lighting[x][y])
						{
						gps.changecolor(7,0,0);
						gps.addchar('.');
						}
					else
						{
						gps.changecolor(0,0,1);
						gps.addchar(250);
						}
					break;
				case CAVE_SQUARE_PIT_OPEN:
					if(lighting[x][y])gps.changecolor(7,0,0);
					else gps.changecolor(0,0,1);
					gps.addchar('o');
					break;
				case CAVE_SQUARE_PIT_COVERED:
					if(lighting[x][y])gps.changecolor(7,0,0);
					else gps.changecolor(0,0,1);
					gps.addchar('+');
					break;
				case CAVE_SQUARE_OUTSIDE:
					if(lighting[x][y])gps.changecolor(2,0,1);
					else gps.changecolor(2,0,0);
					gps.addchar('\"');
					break;
				}
			}
		}
}

void cavest::init()
{
	clean();

	short x,y;

	char rejected;
	do
		{
		entry_way_x.clear();
		entry_way_y.clear();

		//MAKE A RANDOM CAVE WITH SOME ENTRANCES
			//ALL WALLS
		for(x=0;x<CAVE_DIM_X;x++)
			{
			for(y=0;y<CAVE_DIM_Y;y++)
				{
				map[x][y].type=CAVE_SQUARE_WALL;
				path_map[x][y]=-1;
				}
			}

		//PLACE THREE ENTRANCES
		long t;
		char has_entrance[4]={1,1,1,1};
		has_entrance[trandom(4)]=0;
		svector<long> walk_point_x;
		svector<long> walk_point_y;
		long cur_point=0;
		if(has_entrance[0])
			{
			t=trandom(CAVE_DIM_Y-2)+1;
			map[0][t].type=CAVE_SQUARE_OUTSIDE;

			walk_point_x.push_back(1);
			walk_point_y.push_back(t);
			path_map[1][t]=cur_point;cur_point++;
			entry_way_x.push_back(0);
			entry_way_y.push_back(t);
			}
		if(has_entrance[1])
			{
			t=trandom(CAVE_DIM_Y-2)+1;
			map[CAVE_DIM_X-1][t].type=CAVE_SQUARE_OUTSIDE;

			walk_point_x.push_back(CAVE_DIM_X-2);
			walk_point_y.push_back(t);
			path_map[CAVE_DIM_X-2][t]=cur_point;cur_point++;
			entry_way_x.push_back(CAVE_DIM_X-1);
			entry_way_y.push_back(t);
			}
		if(has_entrance[2])
			{
			t=trandom(CAVE_DIM_X-2)+1;
			map[t][0].type=CAVE_SQUARE_OUTSIDE;

			walk_point_x.push_back(t);
			walk_point_y.push_back(1);
			path_map[t][1]=cur_point;cur_point++;
			entry_way_x.push_back(t);
			entry_way_y.push_back(0);
			}
		if(has_entrance[3])
			{
			t=trandom(CAVE_DIM_X-2)+1;
			map[t][CAVE_DIM_Y-1].type=CAVE_SQUARE_OUTSIDE;

			walk_point_x.push_back(t);
			walk_point_y.push_back(CAVE_DIM_Y-2);
			path_map[t][CAVE_DIM_Y-2]=cur_point;cur_point++;
			entry_way_x.push_back(t);
			entry_way_y.push_back(CAVE_DIM_Y-1);
			}

		walk_point_x.push_back(CAVE_DIM_X/4);
		walk_point_y.push_back(CAVE_DIM_Y/4);
		walk_point_x.push_back(CAVE_DIM_X*3/4);
		walk_point_y.push_back(CAVE_DIM_Y/4);
		walk_point_x.push_back(CAVE_DIM_X/4);
		walk_point_y.push_back(CAVE_DIM_Y*3/4);
		walk_point_x.push_back(CAVE_DIM_X*3/4);
		walk_point_y.push_back(CAVE_DIM_Y*3/4);

		//DIG AROUND UNTIL THE WALK POINTS ARE CONNECTED
		long w,px,py;
		char moved;
		do
			{
			moved=0;

			for(w=(long)walk_point_x.size()-1;w>=0;w--)
				{
				px=walk_point_x[w];
				py=walk_point_y[w];

				map[px][py].type=CAVE_SQUARE_FLOOR;

				if(path_map[px][py]!=-1&&path_map[px][py]!=w)continue;
				else
					{
					if(trandom(2))
						{
						px+=(long)trandom(2)*2-1;
						}
					else
						{
						py+=(long)trandom(2)*2-1;
						}

					if(px<1)px=1;
					if(px>CAVE_DIM_X-2)px=CAVE_DIM_X-2;
					if(py<1)py=1;
					if(py>CAVE_DIM_Y-2)py=CAVE_DIM_Y-2;

					walk_point_x[w]=px;
					walk_point_y[w]=py;
					if(path_map[px][py]==-1&&w<=2)path_map[px][py]=w;
					moved=1;
					}
				}
			}while(moved);

		rejected=0;
		long count=0;
		for(x=0;x<CAVE_DIM_X;x++)
			{
			for(y=0;y<CAVE_DIM_Y;y++)
				{
				if(map[x][y].type!=CAVE_SQUARE_WALL)count++;
				}
			}
		if(count>(CAVE_DIM_X*CAVE_DIM_Y)/3)rejected=1;

		}while(rejected);

	//PLACE OPEN PITS
	long pitnum=10,px,py;
	while(pitnum>0)
		{
		px=trandom(CAVE_DIM_X-4)+2;
		py=trandom(CAVE_DIM_Y-4)+2;
		if(map[px][py].type==CAVE_SQUARE_FLOOR&&
			((map[px-1][py].type!=CAVE_SQUARE_WALL&&
			map[px+1][py].type!=CAVE_SQUARE_WALL)||
			(map[px][py-1].type!=CAVE_SQUARE_WALL&&
			map[px][py+1].type!=CAVE_SQUARE_WALL)))
			{
			map[px][py].type=CAVE_SQUARE_PIT_OPEN;

			trap_x.push_back(px);
			trap_y.push_back(py);
			trap_kobold_id.push_back(-1);
			trap_power.push_back(0);
			string blank;
			trap_name.add_string(blank);

			pitnum--;
			}
		}
}

void cavest::do_lighting()
{
	long u;
	short x,y;
	for(x=0;x<CAVE_DIM_X;x++)
		{
		for(y=0;y<CAVE_DIM_Y;y++)
			{
			lighting[x][y]=0;

			if(!map[x][y].blocker())
				{
				for(u=0;u<game.unit.global.size();u++)
					{
					if(game.unit.global[u]->unit_type==UNIT_KOBOLD)
						{
						if(drawline(game.unit.global[u]->x,game.unit.global[u]->y,x,y,1))
							{
							lighting[x][y]=1;
							}
						}
					}
				}
			}
		}
	for(x=0;x<CAVE_DIM_X;x++)
		{
		for(y=0;y<CAVE_DIM_Y;y++)
			{
			if(map[x][y].blocker())
				{
				if(x>0)
					{
					if(lighting[x-1][y]==1){lighting[x][y]=2;continue;}
					}
				if(x<CAVE_DIM_X-1)
					{
					if(lighting[x+1][y]==1){lighting[x][y]=2;continue;}
					}
				if(y>0)
					{
					if(lighting[x][y-1]==1){lighting[x][y]=2;continue;}
					}
				if(y<CAVE_DIM_Y-1)
					{
					if(lighting[x][y+1]==1){lighting[x][y]=2;continue;}
					}
				}
			}
		}
}

char cavest::walkable(short x,short y,unitst *walker,char check_units)
{
	if(walker==NULL)return 0;
	if(x<0||x>=CAVE_DIM_X||y<0||y>=CAVE_DIM_Y)return 0;

	if(walker->unit_type==UNIT_CRITTER&&!map[x][y].blocker())return 1;

	if(walker->unit_type==UNIT_ADVENTURER&&!map[x][y].blocker())
		{
		if(check_units)
			{
			long u;
			for(u=(long)game.unit.global.size()-1;u>=0;u--)
				{
				if(game.unit.global[u]==walker)continue;
				if(game.unit.global[u]->unit_type==UNIT_ADVENTURER)
					{
					if(game.unit.global[u]->x==x&&game.unit.global[u]->y==y)return 0;
					}
				}
			}

		return 1;
		}

	if(walker->unit_type==UNIT_KOBOLD&&!map[x][y].blocker())
		{
		if(check_units)
			{
			long u;
			for(u=(long)game.unit.global.size()-1;u>=0;u--)
				{
				if(game.unit.global[u]==walker)continue;
				if(game.unit.global[u]->unit_type==UNIT_ADVENTURER||
					game.unit.global[u]->unit_type==UNIT_KOBOLD)
					{
					if(game.unit.global[u]->x==x&&game.unit.global[u]->y==y)return 0;
					}
				}
			}

		return 1;
		}

	return 0;
}

char cave_squarest::blocker()
{
	if(type==CAVE_SQUARE_WALL||type==CAVE_SQUARE_OUTSIDE)return 1;
	return 0;
}

char cavest::drawline(int sx,int sy,int ex,int ey,char blocked)
{
	int xdelta,ydelta,cycle,xstep,ystep;
	xdelta=ex-sx;
	ydelta=ey-sy;
	if(xdelta<0)
		{
		xdelta=-xdelta;
		xstep=-1;
		}
	else xstep=1;
	if(ydelta<0)
		{
		ydelta=-ydelta;
		ystep=-1;
		}
	else ystep=1;

	int *major=&sx;
	int *madelta=&xdelta;
	int *mastep=&xstep;
	int *minor=&sy;
	int *midelta=&ydelta;
	int *mistep=&ystep;

	if(ydelta>xdelta)
		{
		minor=&sx;
		midelta=&xdelta;
		mistep=&xstep;
		major=&sy;
		madelta=&ydelta;
		mastep=&ystep;
		}

	int steps=*madelta;

	linelim=0;

	//ERROR NOTE: IF DON'T ADD 1, OBSTACLES AT (1,0) AND (0,1) DON'T ACT THE SAME
		//but there are other problems with it then
			//haven't had time to think out a proper solution yet
	cycle=((*madelta)>>1)+1;
	while(steps>0)
		{
		line[0][linelim][0]=sx;
		line[0][linelim][1]=sy;
		linelim++;

		cycle+=*midelta;
		if(cycle>*madelta)
			{
			cycle-=*madelta;
			*minor+=*mistep;
			}

		*major+=*mastep;steps--;

		if(sx<0)break;
		if(sy<0)break;
		if(sx>=CAVE_DIM_X)break;
		if(sy>=CAVE_DIM_Y)break;

		if(blocked)
			{
			if(map[sx][sy].blocker())return 0;
			}
		}

	return 1;
}

char cavest::cover_trap(unitst *un)
{
	if(un==NULL)return 0;
	if(un->unit_type!=UNIT_KOBOLD)return 0;

	if(map[un->x][un->y].type==CAVE_SQUARE_PIT_OPEN)
		{
		map[un->x][un->y].type=CAVE_SQUARE_PIT_COVERED;

		stringvectst candidate;

		long power=0;
		long c;
		for(c=(long)game.unit.global.size()-1;c>=0;c--)
			{
			if(game.unit.global[c]->unit_type==UNIT_CRITTER&&
				game.unit.global[c]->x==un->x&&
				game.unit.global[c]->y==un->y)
				{
				critterst *crt=game.critter.get_critter_by_global_id(game.unit.global[c]->unit_id);
				if(crt!=NULL)candidate.add_string(crt->name);

				game.critter.remove_critter_by_global_id(game.unit.global[c]->unit_id);
				game.unit.remove_unit(c);
				power++;
				}
			}

		long t;
		for(t=0;t<trap_x.size();t++)
			{
			if(trap_x[t]==un->x&&trap_y[t]==un->y)
				{
				trap_kobold_id[t]=un->unit_id;
				trap_power[t]=power;
				if(candidate.str.size()>0)trap_name.str[t]->dat=candidate.str[trandom(candidate.str.size())]->dat;
				break;
				}
			}

		return 1;
		}

	return 0;
}

inline void cavest::buildpath_squarecheck(short x,short y,short sx,short sy,
						   long fill,short lineplace,long &curplacelim,char &placed,unitst *un)
{
	if(path_map[x][y]<path_start&&
		(walkable(x,y,un,0)||
		(x==sx&&y==sy)))
		{
		if(curplacelim<MAXLINELIM)
			{
			path_map[x][y]=fill;
			placed=1;
			line[lineplace][curplacelim][0]=x;
			line[lineplace][curplacelim][1]=y;
			curplacelim++;

			if(curplacelim==MAXLINELIM)
				{
				errorlog_string("Build Path Overflow");
				}
			}
		}
}

void cavest::buildpath(short sx,short sy,short gx,short gy,svector<short> &path_x,svector<short> &path_y,unitst *un)
{
	path_x.clear();
	path_y.clear();

	if(sx==gx&&sy==gy)
		{
		errorlog_string("BUILDPATH SAME SQUARE VIOLATION");
		return;
		}

	if(path_start>=2000000000)path_clear=1;

	if(path_clear)
		{
		clear_path_map();
		path_start=1;
		path_clear=0;
		}
	else path_start+=5000;//Z-BUFFERING

	path_map[gx][gy]=path_start;

	char placed;
	int pass=1;
	int l,x,y;

	short linecheck=0;
	short lineplace=1;
	long curchecklim=1,curplacelim;
	line[linecheck][0][0]=gx;
	line[linecheck][0][1]=gy;
	long fill=path_start+1;
	long maxpass=2000;

	do
		{
		placed=0;
		curplacelim=0;

		for(l=0;l<curchecklim;l++)
			{
			x=line[linecheck][l][0];
			y=line[linecheck][l][1];

			if(x>0)
				{
				buildpath_squarecheck(x-1,y,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(x<CAVE_DIM_X-1)
				{
				buildpath_squarecheck(x+1,y,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(y>0)
				{
				buildpath_squarecheck(x,y-1,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(y<CAVE_DIM_Y-1)
				{
				buildpath_squarecheck(x,y+1,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(x>0&&y>0)
				{
				buildpath_squarecheck(x-1,y-1,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(x<CAVE_DIM_X-1&&y>0)
				{
				buildpath_squarecheck(x+1,y-1,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(x>0&&y<CAVE_DIM_Y-1)
				{
				buildpath_squarecheck(x-1,y+1,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			if(x<CAVE_DIM_X-1&&y<CAVE_DIM_Y-1)
				{
				buildpath_squarecheck(x+1,y+1,sx,sy,fill,lineplace,curplacelim,placed,un);
				}
			}

		if(path_map[sx][sy]>=path_start)break;

		fill++;
		pass++;
		if(pass>maxpass)break;

		linecheck=1-linecheck;
		lineplace=1-lineplace;
		curchecklim=curplacelim;

		}while(placed);

	//IF START GOT TOUCHED, FOLLOW THE PATH BACK TO GOAL
	if(path_map[sx][sy]>=path_start)
		{
		int px=sx,py=sy;
		char moved;
		while(1)
			{
			moved=0;

			switch(trandom(8))
				{
				case 0:
					if(px>0&&!moved)
						{
						if(!moved&&path_map[px-1][py]<path_map[px][py]&&
								path_map[px-1][py]>=path_start){px--;moved=1;}
						}
					break;
				case 1:
					if(py>0&&!moved)
						{
						if(!moved&&path_map[px][py-1]<path_map[px][py]&&
							path_map[px][py-1]>=path_start){py--;moved=1;}
						}
					break;
				case 2:
					if(px<CAVE_DIM_X-1&&!moved)
						{
						if(!moved&&path_map[px+1][py]<path_map[px][py]&&
							path_map[px+1][py]>=path_start){px++;moved=1;}
						}
					break;
				case 3:
					if(py<CAVE_DIM_Y-1&&!moved)
						{
						if(!moved&&path_map[px][py+1]<path_map[px][py]&&
							path_map[px][py+1]>=path_start){py++;moved=1;}
						}
					break;
				case 4:
					if(px>0&&py>0&&!moved)
						{
						if(!moved&&path_map[px-1][py-1]<path_map[px][py]&&
								path_map[px-1][py-1]>=path_start){px--;py--;moved=1;}
						}
					break;
				case 5:
					if(px<CAVE_DIM_X-1&&py>0&&!moved)
						{
						if(!moved&&path_map[px+1][py-1]<path_map[px][py]&&
							path_map[px+1][py-1]>=path_start){px++;py--;moved=1;}
						}
					break;
				case 6:
					if(px>0&&py<CAVE_DIM_Y-1&&!moved)
						{
						if(!moved&&path_map[px-1][py+1]<path_map[px][py]&&
							path_map[px-1][py+1]>=path_start){px--;py++;moved=1;}
						}
					break;
				case 7:
					if(px<CAVE_DIM_X-1&&py<CAVE_DIM_Y-1&&!moved)
						{
						if(!moved&&path_map[px+1][py+1]<path_map[px][py]&&
							path_map[px+1][py+1]>=path_start){px++;py++;moved=1;}
						}
					break;
				}

			if(moved)
				{
				path_x.push_back(px);
				path_y.push_back(py);

				if(px==gx&&py==gy)break;
				}
			}
		}
}

long cavest::set_off_trap(short x,short y,long &id,string &c_name)
{
	id=-1;
	long ret=0;

	long t;
	for(t=0;t<trap_x.size();t++)
		{
		if(trap_x[t]==x&&trap_y[t]==y)
			{
			id=trap_kobold_id[t];

			trap_kobold_id[t]=-1;
			ret=trap_power[t];
			c_name=trap_name.str[t]->dat;
			}
		}

	map[x][y].type=CAVE_SQUARE_PIT_OPEN;

	return ret;
}

//1.02
char cavest::have_lit_adventurer()
{
	long u;
	for(u=0;u<game.unit.global.size();u++)
		{
		if(game.unit.global[u]->unit_type!=UNIT_ADVENTURER)continue;
		if(lighting[game.unit.global[u]->x][game.unit.global[u]->y])return 1;
		}
	return 0;
}