//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#define CAVE_DIM_X 80
#define CAVE_DIM_Y 23

enum CaveSquare
{
	CAVE_SQUARE_WALL,
	CAVE_SQUARE_FLOOR,
	CAVE_SQUARE_PIT_OPEN,
	CAVE_SQUARE_PIT_COVERED,
	CAVE_SQUARE_OUTSIDE,
	CAVE_SQUARENUM
};

class cave_squarest
{
	public:
		short type;

		char blocker();

		void write_file(file_compressorst &filecomp)
			{
			filecomp.write_file(type);
			}
		void read_file(file_compressorst &filecomp,long loadversion)
			{
			filecomp.read_file(type);
			}
};

class cavest
{
	public:
		//SAVED
		cave_squarest map[CAVE_DIM_X][CAVE_DIM_Y];

		svector<short> trap_x;
		svector<short> trap_y;
		svector<long> trap_kobold_id;
		svector<long> trap_power;
		stringvectst trap_name;

		svector<short> entry_way_x;
		svector<short> entry_way_y;

		string name;

		//NOT SAVED
		char lighting[CAVE_DIM_X][CAVE_DIM_Y];
		char path_clear;
		long path_start;
		long path_map[CAVE_DIM_X][CAVE_DIM_Y];
		long line[2][MAXLINELIM][2];
		long linelim;


		cavest()
			{
			clean();
			}

		void clean()
			{
			trap_x.clear();
			trap_y.clear();
			trap_kobold_id.clear();
			trap_power.clear();
			trap_name.clean();
			path_clear=1;
			name.erase();//1.02
			}

		void write_file(file_compressorst &filecomp);
		void read_file(file_compressorst &filecomp,long loadversion);

		void print();

		void init();
		void do_lighting();

		char walkable(short x,short y,unitst *walker,char check_units);

		char drawline(int sx,int sy,int ex,int ey,char blocked);

		char cover_trap(unitst *un);

		inline void buildpath_squarecheck(short x,short y,short sx,short sy,
								   long fill,short lineplace,long &curplacelim,char &placed,unitst *un);
		void buildpath(short sx,short sy,short gx,short gy,svector<short> &path_x,svector<short> &path_y,unitst *un);

		void clear_path_map()
			{
			memset(path_map,0,sizeof(long)*CAVE_DIM_X*CAVE_DIM_Y);
			}

		long set_off_trap(short x,short y,long &id,string &c_name);

		char have_lit_adventurer();//1.02
};