//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

critterst::critterst(char for_load)
{
	if(!for_load)
		{
		global_id=game.next_critter_id;
		game.next_critter_id++;
		do
			{
			color[0]=trandom(8);
			color[1]=0;
			color[2]=trandom(2);
			}while(color[0]==0&&color[2]==0);
		random_name();
		random_description();
		}

	game.critter.global.push_back(this);
}

critterst::~critterst()
{
	long t;
	for(t=(long)game.critter.global.size()-1;t>=0;t--)
		{
		if(game.critter.global[t]==this)
			{
			game.critter.global.erase(t);
			break;
			}
		}
}

void critterst::write_file(file_compressorst &filecomp)
{
	filecomp.write_file(global_id);

	filecomp.write_file(name);
	description.write_file(filecomp);

	filecomp.write_file(color,sizeof(short)*3);
}

void critterst::read_file(file_compressorst &filecomp,long loadversion)
{
	filecomp.read_file(global_id);

	filecomp.read_file(name);
	description.read_file(filecomp,loadversion);

	filecomp.read_file(color,sizeof(short)*3);
}

void critterst::random_name()
{
	name.erase();

	text_infost ti;
	enabler.text_system.get_text(TEXT_CRITTER_ADJ,ti);
	name+=ti.get_string(0);
	name+=" ";
	enabler.text_system.get_text(TEXT_CRITTER_NOUN,ti);
	name+=ti.get_string(0);
	capitalize_string_words(name);
}

void critterst::random_description()
{
	description.clean();

	string story;

	text_infost ti;

	story+="The ";
	story+=name;
	story+=" ";
	enabler.text_system.get_text(TEXT_DESC_FORM1,ti);
	story+=ti.get_string(0);
	story+=" and ";
	enabler.text_system.get_text(TEXT_DESC_FORM2,ti);
	story+=ti.get_string(0);
	story+=". From ";
	enabler.text_system.get_text(TEXT_DESC_DELIVERY,ti);
	story+=ti.get_string(0);
	story+=" ";
	enabler.text_system.get_text(TEXT_DESC_POISON1,ti);
	story+=ti.get_string(0);
	story+=" a ";
	enabler.text_system.get_text(TEXT_DESC_POISON2,ti);
	story+=ti.get_string(0);
	story+=" ";
	enabler.text_system.get_text(TEXT_DESC_POISON3,ti);
	story+=ti.get_string(0);
	story+=". ";
	enabler.text_system.get_text(TEXT_DESC_DEBATE1,ti);
	story+=ti.get_string(0);
	story+=", but ";
	enabler.text_system.get_text(TEXT_DESC_DEBATE2,ti);
	story+=ti.get_string(0);
	story+=" that the ";
	story+=name;
	story+=", ";
	enabler.text_system.get_text(TEXT_DESC_ORIGIN1,ti);
	story+=ti.get_string(0);
	story+=", ";
	enabler.text_system.get_text(TEXT_DESC_ORIGIN2,ti);
	story+=ti.get_string(0);
	story+=".";

	description.add_paragraph(story,58);
}