//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#define MAX_CRITTER 20

class critterst
{
	friend class critter_handlerst;

	public:
		static critterst *create(){return new critterst(0);}
		static critterst *create_for_load(){return new critterst(1);}

		long global_id;
		short color[3];
		string name;
		curses_text_boxst description;

		void write_file(file_compressorst &filecomp);
		void read_file(file_compressorst &filecomp,long loadversion);

		void random_name();
		void random_description();

	protected:
		critterst(char for_load);
		~critterst();
};

class critter_handlerst
{
	public:
		svector<critterst *> global;

		void clean()
			{
			while(global.size()>0)remove_critter(global.size()-1);
			}

		void remove_critter(int e){delete global[e];}
		void remove_critter(critterst *ptr)
			{
			long t;
			for(t=(long)global.size()-1;t>=0;t--)
				{
				if(global[t]==ptr)
					{
					remove_critter(t);
					break;
					}
				}
			}
		void remove_critter_by_global_id(long id)
			{
			long t;
			for(t=(long)global.size()-1;t>=0;t--)
				{
				if(global[t]->global_id==id)
					{
					remove_critter(t);
					break;
					}
				}
			}

		critterst *get_critter_by_global_id(long id)
			{
			if(global.size()==0||id==-1)return NULL;

			return binary_get(0,(long)global.size()-1,id);
			}

		critterst *binary_get(long start,long end,long id)
			{
			if(start>end)return NULL;

			long mid=(start+end)>>1;

			if(global[mid]->global_id==id)return global[mid];
			if(start==end)return NULL;

			if(global[mid]->global_id>id)return binary_get(start,mid-1,id);
			else return binary_get(mid+1,end,id);
			}

		void add_critter(critterst *ptr)
			{
			if(ptr==NULL)return;
			long size=global.size();
			long t;
			for(t=0;t<size;t++)
				{
				if(global[t]->global_id==ptr->global_id)return;
				if(global[t]->global_id>ptr->global_id)
					{
					global.insert(t,ptr);
					break;
					}
				}
			if(t==size)global.push_back(ptr);
			}
		
		~critter_handlerst()
			{
			clean();
			}
};