//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

void textlinesst::load_raw_to_lines(const string &filename)
{
	text.clean();

	//LOAD THE FILE
	std::ifstream fseed(filename.c_str());
	if(fseed.is_open())
		{
		int count=0;
		string str;

		while(std::getline(fseed,str)&&count<10000)
			{
			if(str.length()>0)
				{
				text.add_string(str);
				}

			count++;
			}
		}
	fseed.close();
}

definitionst::definitionst()
{
	game.definition.global.push_back(this);
}

definitionst::~definitionst()
{
	long t;
	for(t=(long)game.definition.global.size()-1;t>=0;t--)
		{
		if(game.definition.global[t]==this)
			{
			game.definition.global.erase(t);
			break;
			}
		}
}

kobold_definitionst::kobold_definitionst()
{
	game.definition.kobold.push_back(this);
}

kobold_definitionst::~kobold_definitionst()
{
	long t;
	for(t=(long)game.definition.kobold.size()-1;t>=0;t--)
		{
		if(game.definition.kobold[t]==this)
			{
			game.definition.kobold.erase(t);
			break;
			}
		}
}

void kobold_definitionst::adopt_file(textlinesst &lines)
{
	long t,pos;
	string curstr;

	kobold_definitionst *def=NULL;

	for(t=0;t<lines.text.str.size();t++)
		{
		curstr=lines.text.str[t]->dat;

		for(pos=0;pos<curstr.length();pos++)
			{
			//SEE IF YOU ARE AT THE NEXT TOKEN
			if(curstr[pos]=='[')
				{
				string token;
				pos++;grab_token_string_pos(token,curstr,pos);

				if(token=="KOBOLD")
					{
					pos++;grab_token_string_pos(token,curstr,pos);
					def=kobold_definitionst::create();
						def->token=token;
					}
				else if(def!=NULL)
					{
					if(token=="NAME")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->name=token;
						continue;
						}
					if(token=="PREDECESSOR")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->predecessor=token;
						continue;
						}
					if(token=="XP")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->xp_level=convert_string_to_long(token);
						continue;
						}
					if(token=="C")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->color[0]=convert_string_to_long(token);
						pos++;grab_token_string_pos(token,curstr,pos);
						def->color[1]=convert_string_to_long(token);
						pos++;grab_token_string_pos(token,curstr,pos);
						def->color[2]=convert_string_to_long(token);
						continue;
						}

					string str="Unrecognized Kobold Token: ";
					str+=token;
					errorlog_string(str);
					}
				}
			}
		}
}

adventurer_definitionst::adventurer_definitionst()
{
	game.definition.adventurer.push_back(this);
}

adventurer_definitionst::~adventurer_definitionst()
{
	long t;
	for(t=(long)game.definition.adventurer.size()-1;t>=0;t--)
		{
		if(game.definition.adventurer[t]==this)
			{
			game.definition.adventurer.erase(t);
			break;
			}
		}
}

void adventurer_definitionst::adopt_file(textlinesst &lines)
{
	long t,pos;
	string curstr;

	adventurer_definitionst *def=NULL;

	for(t=0;t<lines.text.str.size();t++)
		{
		curstr=lines.text.str[t]->dat;

		for(pos=0;pos<curstr.length();pos++)
			{
			//SEE IF YOU ARE AT THE NEXT TOKEN
			if(curstr[pos]=='[')
				{
				string token;
				pos++;grab_token_string_pos(token,curstr,pos);

				if(token=="ADVENTURER")
					{
					pos++;grab_token_string_pos(token,curstr,pos);
					def=adventurer_definitionst::create();
						def->token=token;
					}
				else if(def!=NULL)
					{
					if(token=="NAME")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->name=token;
						continue;
						}
					if(token=="PREDECESSOR")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->predecessor=token;
						continue;
						}
					if(token=="XP")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->xp_level=convert_string_to_long(token);
						continue;
						}
					if(token=="TITLE")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->title=token;
						continue;
						}
					if(token=="C")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->color[0]=convert_string_to_long(token);
						pos++;grab_token_string_pos(token,curstr,pos);
						def->color[1]=convert_string_to_long(token);
						pos++;grab_token_string_pos(token,curstr,pos);
						def->color[2]=convert_string_to_long(token);
						continue;
						}
					if(token=="CHAR")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->tile=convert_string_to_long(token);
						if(token.size()>0)
							{
							if(!(token[0]>='0'&&token[0]<='9'))def->tile=token[0];
							}
						continue;
						}

					string str="Unrecognized Adventurer Token: ";
					str+=token;
					errorlog_string(str);
					}
				}
			}
		}
}

monster_definitionst::monster_definitionst()
{
	subordinate_only=0;

	game.definition.monster.push_back(this);
}

monster_definitionst::~monster_definitionst()
{
	long t;
	for(t=(long)game.definition.monster.size()-1;t>=0;t--)
		{
		if(game.definition.monster[t]==this)
			{
			game.definition.monster.erase(t);
			break;
			}
		}
}

void monster_definitionst::adopt_file(textlinesst &lines)
{
	long t,pos;
	string curstr;

	monster_definitionst *def=NULL;

	for(t=0;t<lines.text.str.size();t++)
		{
		curstr=lines.text.str[t]->dat;

		for(pos=0;pos<curstr.length();pos++)
			{
			//SEE IF YOU ARE AT THE NEXT TOKEN
			if(curstr[pos]=='[')
				{
				string token;
				pos++;grab_token_string_pos(token,curstr,pos);

				if(token=="MONSTER")
					{
					pos++;grab_token_string_pos(token,curstr,pos);
					def=monster_definitionst::create();
						def->token=token;
					}
				else if(def!=NULL)
					{
					if(token=="NAME")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->name=token;
						continue;
						}
					if(token=="XP")
						{
						pos++;grab_token_string_pos(token,curstr,pos);
						def->xp_level=convert_string_to_long(token);
						continue;
						}
					if(token=="SUBORDINATE_ONLY")
						{
						def->subordinate_only=1;
						continue;
						}
					if(token=="SUBORDINATE")
						{
						long chance;
						string subord_tok;
						long min,max;

						pos++;grab_token_string_pos(token,curstr,pos);
						chance=convert_string_to_long(token);
						pos++;grab_token_string_pos(subord_tok,curstr,pos);
						pos++;grab_token_string_pos(token,curstr,pos);
						min=convert_string_to_long(token);
						pos++;grab_token_string_pos(token,curstr,pos);
						max=convert_string_to_long(token);

						def->subord_token.add_string(subord_tok);
						def->subord_chance.push_back(chance);
						def->subord_min.push_back(min);
						def->subord_max.push_back(max);
						continue;
						}

					string str="Unrecognized Monster Token: ";
					str+=token;
					errorlog_string(str);
					}
				}
			}
		}
}

void definition_handlerst::process_file(textlinesst &lines)
{
	long t,pos;
	string curstr;

	for(t=0;t<lines.text.str.size();t++)
		{
		curstr=lines.text.str[t]->dat;

		for(pos=0;pos<curstr.length();pos++)
			{
			//SEE IF YOU ARE AT THE NEXT TOKEN
			if(curstr[pos]=='[')
				{
				string token;
				pos++;grab_token_string_pos(token,curstr,pos);

				if(token=="OBJECT")
					{
					pos++;grab_token_string_pos(token,curstr,pos);

					if(token=="KOBOLD")
						{
						kobold_definitionst::adopt_file(lines);
						return;
						}
					if(token=="ADVENTURER")
						{
						adventurer_definitionst::adopt_file(lines);
						return;
						}
					if(token=="MONSTER")
						{
						monster_definitionst::adopt_file(lines);
						return;
						}
					}
				}
			}
		}
}

void definition_handlerst::load_files()
{
	//HANDLE FILES
	svector<char *> processfilename;
	int f;
	textlinesst setuplines;

	find_files_by_pattern("data/objects/*.*", processfilename);
	
	//LOAD THE OBJECT FILES UP INTO MEMORY
		//MUST INSURE THAT THEY ARE LOADED IN THE PROPER ORDER, IN CASE THEY REFER TO EACH OTHER

	char str[200];
	for(f=0;f<processfilename.size();f++)
		{
		strcpy(str,"data/objects/");
		strcat(str,processfilename[f]);

		setuplines.load_raw_to_lines(str);
		process_file(setuplines);

		delete[] processfilename[f];
		}
	processfilename.clear();

	//FINALIZE DEFS
	long d;
	for(d=0;d<global.size();d++)
		{
		global[d]->finalize();
		}
}