//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

struct textlinesst
{
	stringvectst text;

	char get_line(long &startpos,long &endpos,char *buffer,long buflen);

	void load_raw_to_lines(const string &filename);
};

class definitionst
{
	friend class definition_handlerst;

	public:
		string token;
		virtual void finalize(){}

	protected:
		definitionst();
		virtual ~definitionst();
};

class kobold_definitionst : public definitionst
{
	friend class definition_handlerst;

	public:
		static kobold_definitionst *create(){return new kobold_definitionst;}

		string name;
		long xp_level;
		string predecessor;
		short color[3];

		static void adopt_file(textlinesst &lines);

	protected:
		kobold_definitionst();
		virtual ~kobold_definitionst();
};

class adventurer_definitionst : public definitionst
{
	friend class definition_handlerst;

	public:
		static adventurer_definitionst *create(){return new adventurer_definitionst;}

		string name;
		long xp_level;
		string predecessor;
		string title;
		short color[3];
		unsigned char tile;

		static void adopt_file(textlinesst &lines);

	protected:
		adventurer_definitionst();
		virtual ~adventurer_definitionst();
};

class monster_definitionst : public definitionst
{
	friend class definition_handlerst;

	public:
		static monster_definitionst *create(){return new monster_definitionst;}

		string name;
		long xp_level;
		stringvectst subord_token;
		svector<long> subord_chance;
		svector<long> subord_min;
		svector<long> subord_max;
		char subordinate_only;

		static void adopt_file(textlinesst &lines);

	protected:
		monster_definitionst();
		virtual ~monster_definitionst();
};

class definition_handlerst
{
	public:
		svector<definitionst *> global;
			svector<kobold_definitionst *> kobold;
			svector<adventurer_definitionst *> adventurer;
			svector<monster_definitionst *> monster;

		~definition_handlerst()
			{
			clean();
			}

		void clean()
			{
			while(global.size())delete global[(long)global.size()-1];
			}

		void load_files();
		void process_file(textlinesst &lines);

		kobold_definitionst *get_kobold_by_token(string &tok)
			{
			long d;
			for(d=0;d<kobold.size();d++)
				{
				if(kobold[d]->token==tok)return kobold[d];
				}
			return NULL;
			}
		kobold_definitionst *get_kobold_by_predecessor(string &tok)
			{
			svector<kobold_definitionst *> candidate;
			long d;
			for(d=0;d<kobold.size();d++)
				{
				if(kobold[d]->predecessor==tok)candidate.push_back(kobold[d]);
				}

			if(candidate.size()>0)return candidate[trandom(candidate.size())];
			else return NULL;
			}

		adventurer_definitionst *get_adventurer_by_token(string &tok)
			{
			long d;
			for(d=0;d<adventurer.size();d++)
				{
				if(adventurer[d]->token==tok)return adventurer[d];
				}
			return NULL;
			}
		adventurer_definitionst *get_adventurer_by_predecessor_with_xp_bound(string &tok,long max_xp)
			{
			svector<adventurer_definitionst *> candidate;
			long d;
			for(d=0;d<adventurer.size();d++)
				{
				if(adventurer[d]->predecessor==tok&&
					adventurer[d]->xp_level<=max_xp)candidate.push_back(adventurer[d]);
				}

			if(candidate.size()>0)return candidate[trandom(candidate.size())];
			else return NULL;
			}

		monster_definitionst *get_monster_by_token(string &tok)
			{
			long d;
			for(d=0;d<monster.size();d++)
				{
				if(monster[d]->token==tok)return monster[d];
				}
			return NULL;
			}
		monster_definitionst *get_monster_by_max_xp(long max_xp)
			{
			svector<monster_definitionst *> candidate;
			long d;
			for(d=0;d<monster.size();d++)
				{
				if(monster[d]->xp_level<=max_xp&&!monster[d]->subordinate_only)candidate.push_back(monster[d]);
				}

			if(candidate.size()>0)return candidate[trandom(candidate.size())];
			else return NULL;
			}
};