#include "platform.h"
#include "svector.h"
#include "find_files.h"

#include <glob.h>
#include <string.h>

void find_files_by_pattern(const char* pattern, svector<char *>& filenames)
{
	glob_t g;
	if (!glob(pattern, 0, NULL, &g))
	{
		for (int i = 0; i < g.gl_pathc; ++i)
		{
			// don't include the path
			char* src = strrchr(g.gl_pathv[i], '/');
			if (src)
			{
				int len = strlen(++src);
				char* c = new char[len + 1];	// caller will free this
				strcpy(c, src);
				filenames.push_back(c);
			}
		}
	}
	globfree(&g);
}

