/************************************************************************************************
Copyright (c) 2006, Tarn Adams
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
		conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list
		of conditions and the following disclaimer in the documentation and/or other
		materials provided with the distribution.
    * The names of Tarn Adams, Zach Adams and Bay 12 Games may not be used to endorse
		or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*************************************************************************************************/


#include "game_g.h"
#include "game_v.h"

void gamest::end_game()
{
	if(kobold.global.size()==0)
		{
		if(adventurer.global.size()>0)
			{
			//SPEND ALL EXPERIENCE AND LEVEL UP BEFORE SAVING, IF YOU ARE ALIVE TO DO IT
			long a;
			for(a=0;a<adventurer.global.size();a++)
				{
				if(adventurer.global[a]->death_string.empty())adventurer.global[a]->spend_pool();
				}

			save_score_list();
			}
		}
	else
		{
		save_active_game();
		}

	clean();
}

void gamest::clean()
{
	main_interface.clean();

	unit.clean();
	critter.clean();
	kobold.clean();
	cave.clean();
	adventurer.clean();
}

char mainloop(void)
{
	if(gview.loop())return 1;

	return 0;
}

void endroutine(void)
{
}

char beginroutine(void)
{
	version=10001;
	min_load_version=10001;

	string st="*** STARTING NEW GAME ***";
	gamelog_string(st);

	if(!enabler.command_line.empty())
		{
		string anstr="Command Line: ";
		anstr+=enabler.command_line;
		gamelog_string(anstr);

		game.command_line.init(enabler.command_line);
		}

	string small_font="data/art/curses.bmp";
	string large_font="data/art/curses.bmp";
	std::ifstream fseed("data/init/init.txt");
	if(fseed.is_open())
		{
		string str;

		while(std::getline(fseed,str))
			{
			if(str.length()>1)
				{
				string token;
				string token2;

				long pos=1;
				grab_token_string_pos(token,str,pos);
				pos++;grab_token_string_pos(token2,str,pos);

				if(!token.compare("FONT"))
					{
					small_font="data/art/";
					small_font+=token2;
					}
				if(!token.compare("FULLFONT"))
					{
					large_font="data/art/";
					large_font+=token2;
					}
				if(!token.compare("WINDOWEDX"))
					{
					enabler.desired_windowed_width=convert_string_to_long(token2);
					}
				if(!token.compare("WINDOWEDY"))
					{
					enabler.desired_windowed_height=convert_string_to_long(token2);
					}
				if(!token.compare("FULLSCREENX"))
					{
					enabler.desired_fullscreen_width=convert_string_to_long(token2);
					}
				if(!token.compare("FULLSCREENY"))
					{
					enabler.desired_fullscreen_height=convert_string_to_long(token2);
					}
				if(token=="MOUSE_PICTURE")
					{
					if(token2=="YES")
						{
						init.input.flag.add_flag(INIT_INPUT_FLAG_MOUSE_PICTURE);
						}
					}
				if(token=="WINDOWED")
					{
					if(token2=="YES")
						{
						init.display.windowed=INIT_DISPLAY_WINDOW_TRUE;
						}
					if(token2=="NO")
						{
						init.display.windowed=INIT_DISPLAY_WINDOW_FALSE;
						}
					if(token2=="PROMPT")
						{
						init.display.windowed=INIT_DISPLAY_WINDOW_PROMPT;
						}
					}
				if(!token.compare("BLACK_R"))
					{
					enabler.ccolor[0][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BLACK_G"))
					{
					enabler.ccolor[0][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BLACK_B"))
					{
					enabler.ccolor[0][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BLUE_R"))
					{
					enabler.ccolor[1][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BLUE_G"))
					{
					enabler.ccolor[1][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BLUE_B"))
					{
					enabler.ccolor[1][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("GREEN_R"))
					{
					enabler.ccolor[2][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("GREEN_G"))
					{
					enabler.ccolor[2][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("GREEN_B"))
					{
					enabler.ccolor[2][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("CYAN_R"))
					{
					enabler.ccolor[3][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("CYAN_G"))
					{
					enabler.ccolor[3][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("CYAN_B"))
					{
					enabler.ccolor[3][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("RED_R"))
					{
					enabler.ccolor[4][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("RED_G"))
					{
					enabler.ccolor[4][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("RED_B"))
					{
					enabler.ccolor[4][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("MAGENTA_R"))
					{
					enabler.ccolor[5][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("MAGENTA_G"))
					{
					enabler.ccolor[5][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("MAGENTA_B"))
					{
					enabler.ccolor[5][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BROWN_R"))
					{
					enabler.ccolor[6][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BROWN_G"))
					{
					enabler.ccolor[6][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("BROWN_B"))
					{
					enabler.ccolor[6][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LGRAY_R"))
					{
					enabler.ccolor[7][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LGRAY_G"))
					{
					enabler.ccolor[7][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LGRAY_B"))
					{
					enabler.ccolor[7][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("DGRAY_R"))
					{
					enabler.ccolor[8][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("DGRAY_G"))
					{
					enabler.ccolor[8][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("DGRAY_B"))
					{
					enabler.ccolor[8][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LBLUE_R"))
					{
					enabler.ccolor[9][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LBLUE_G"))
					{
					enabler.ccolor[9][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LBLUE_B"))
					{
					enabler.ccolor[9][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LGREEN_R"))
					{
					enabler.ccolor[10][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LGREEN_G"))
					{
					enabler.ccolor[10][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LGREEN_B"))
					{
					enabler.ccolor[10][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LCYAN_R"))
					{
					enabler.ccolor[11][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LCYAN_G"))
					{
					enabler.ccolor[11][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LCYAN_B"))
					{
					enabler.ccolor[11][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LRED_R"))
					{
					enabler.ccolor[12][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LRED_G"))
					{
					enabler.ccolor[12][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LRED_B"))
					{
					enabler.ccolor[12][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LMAGENTA_R"))
					{
					enabler.ccolor[13][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LMAGENTA_G"))
					{
					enabler.ccolor[13][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("LMAGENTA_B"))
					{
					enabler.ccolor[13][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("YELLOW_R"))
					{
					enabler.ccolor[14][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("YELLOW_G"))
					{
					enabler.ccolor[14][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("YELLOW_B"))
					{
					enabler.ccolor[14][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("WHITE_R"))
					{
					enabler.ccolor[15][0]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("WHITE_G"))
					{
					enabler.ccolor[15][1]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("WHITE_B"))
					{
					enabler.ccolor[15][2]=(float)convert_string_to_long(token2)/255.0f;
					}
				if(!token.compare("SOUND"))
					{
					if(token2!="ON")
						{
						init.media.flag.add_flag(INIT_MEDIA_FLAG_SOUND_OFF);
						}
					}
				if(!token.compare("KEY_HOLD_MS"))
					{
					init.input.hold_time=convert_string_to_long(token2);

					if(init.input.hold_time<100)init.input.hold_time=100;
					}
				}
			}
		}
	fseed.close();

	game.load_option_files();

	//FULL SCREEN QUERY, UNLESS IT'S ALREADY SET IN INIT
	if(enabler.command_line.empty())
		{
		if(init.display.windowed==INIT_DISPLAY_WINDOW_TRUE)
			{
			enabler.window.init.isFullScreen = FALSE;
			}
		else if(init.display.windowed==INIT_DISPLAY_WINDOW_FALSE)
			{
			enabler.window.init.isFullScreen = TRUE;
			}
		else
			{
			if (MessageBox (HWND_DESKTOP, "Run in Fullscreen Mode?  You can set your preferences in data\\init\\init.txt.\rUnless you've changed your bindings, you can press F11 to toggle this setting any time.", "Start FullScreen?", MB_YESNO | MB_ICONQUESTION) == IDNO)
				{
				enabler.window.init.isFullScreen = FALSE;
				}
			}
		}
	else enabler.window.init.isFullScreen = FALSE;

	enabler.create_full_screen = enabler.window.init.isFullScreen;
	enabler.inactive_mode=0;

	//LOAD DEFINITIONS
	game.definition.load_files();

	init.font.small_font_id=enabler.font_create(small_font,16,16);
	init.font.large_font_id=enabler.font_create(large_font,16,16);

	if(!enabler.create_full_screen)rect_id=enabler.cursesrect_create(init.font.small_font_id,0,0,80,25);
	else rect_id=enabler.cursesrect_create(init.font.large_font_id,0,0,80,25);

	//SET UP SOUNDS
#ifndef NO_FMOD
	if(!init.media.flag.has_flag(INIT_MEDIA_FLAG_SOUND_OFF))
		{
		musicsound.initsound();

		string ms_file;

		ms_file="data/sound/song_title.ogg";
		musicsound.set_song(ms_file,SONG_TITLE);

		ms_file="data/sound/click.ogg";
		musicsound.set_sound(ms_file,SOUND_CLICK,FSOUND_STEREOPAN,0);

		ms_file="data/sound/adv_die_1.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DIE_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_die_2.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DIE_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_die_3.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DIE_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_die_4.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DIE_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_die_5.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DIE_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_target_1.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_TARGET_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_target_2.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_TARGET_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_target_3.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_TARGET_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_target_4.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_TARGET_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_target_5.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_TARGET_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_dodge_1.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DODGE_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_dodge_2.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DODGE_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_dodge_3.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DODGE_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_dodge_4.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DODGE_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_dodge_5.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_DODGE_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_kill_1.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_KILL_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_kill_2.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_KILL_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_kill_3.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_KILL_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_kill_4.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_KILL_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/adv_kill_5.ogg";
		musicsound.set_sound(ms_file,SOUND_ADVENTURER_KILL_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_cover_1.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_COVER_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_cover_2.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_COVER_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_cover_3.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_COVER_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_cover_4.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_COVER_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_cover_5.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_COVER_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_drop_1.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_DROP_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_drop_2.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_DROP_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_drop_3.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_DROP_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_drop_4.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_DROP_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_drop_5.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_DROP_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_pickup_1.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_PICKUP_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_pickup_2.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_PICKUP_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_pickup_3.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_PICKUP_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_pickup_4.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_PICKUP_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_pickup_5.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_PICKUP_5,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_select_1.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_SELECT_1,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_select_2.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_SELECT_2,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_select_3.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_SELECT_3,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_select_4.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_SELECT_4,FSOUND_STEREOPAN,0);
		ms_file="data/sound/kobold_select_5.ogg";
		musicsound.set_sound(ms_file,SOUND_KOBOLD_SELECT_5,FSOUND_STEREOPAN,0);
		}
#endif

	gps.setclipping(0,79,0,24);

	basic_seed=GetTickCount();
	mt_init();

	//HANDLE GRAPHICS
	string tex;
		
	tex="data/art/mouse.bmp";
	gps.tex_pos[TEXTURE_MOUSE]=enabler.texture_create(tex,1,1);
	tex="data/art/title.bmp";
	gps.tex_pos[TEXTURE_TITLE]=enabler.texture_create(tex,1,1);

	//MAKE SURE THE ROOT AND OTHERS ARE THERE
	CreateDirectory("data",NULL);
	CreateDirectory("data/save",NULL);

	//TITLE SCREEN
	viewscreen_titlest::create(INTERFACE_PUSH_AT_BACK);

	//SET UP THE TEXT SYSTEM
	string file_name;
	file_name="data/text/advname_opening.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_ADVNAME_OPENING,'@',0);
	file_name="data/text/advname_middle_vowel.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_ADVNAME_MIDDLE_VOWEL,'@',0);
	file_name="data/text/advname_middle_cons.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_ADVNAME_MIDDLE_CONS,'@',0);
	file_name="data/text/advname_ending.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_ADVNAME_ENDING,'@',0);
	file_name="data/text/critter_adj.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_CRITTER_ADJ,'@',0);
	file_name="data/text/critter_noun.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_CRITTER_NOUN,'@',0);
	file_name="data/text/desc_form1.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_FORM1,'@',0);
	file_name="data/text/desc_form2.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_FORM2,'@',0);
	file_name="data/text/desc_delivery.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_DELIVERY,'@',0);
	file_name="data/text/desc_poison1.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_POISON1,'@',0);
	file_name="data/text/desc_poison2.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_POISON2,'@',0);
	file_name="data/text/desc_poison3.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_POISON3,'@',0);
	file_name="data/text/desc_debate1.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_DEBATE1,'@',0);
	file_name="data/text/desc_debate2.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_DEBATE2,'@',0);
	file_name="data/text/desc_origin1.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_ORIGIN1,'@',0);
	file_name="data/text/desc_origin2.txt";
	enabler.text_system.register_file_fixed(file_name,TEXT_DESC_ORIGIN2,'@',0);

	enabler.text_system.initialize_system();

	return 1;
}

void gamest::load_option_files()
{
	//LOAD THE FILE
	std::ifstream fseed("data/init/interface.txt");
	if(fseed.is_open())
		{
		string str;

		while(std::getline(fseed,str))
			{
			long pos;
			for(pos=0;pos<str.length();pos++)
				{
				//SEE IF YOU ARE AT THE NEXT TOKEN
				if(str[pos]=='[')
					{
					string temptoken;
					string temptoken2;
					string temptoken3;

					pos++;grab_token_string_pos(temptoken,str,pos);
					pos++;grab_token_string_pos(temptoken2,str,pos);
					if(temptoken=="DISPLAY_STRING")
						{
						pos++;grab_token_string_pos(temptoken3,str,pos);

						interfacekeyst key;
						gview.convertstring_interfacechar_save(temptoken2,key);

						if(key.binding!=0)
							{
							if(key.shift)gview.display_string[key.binding][1]=temptoken3;
							else gview.display_string[key.binding][0]=temptoken3;
							}

						continue;
						}

					interfacekeyst key;
					gview.convertstring_interfacechar_save(temptoken2,key);
				
					int i;
					for(i=0;i<INTERFACEKEYNUM;i++)
						{
						if(gview.interfacekey[i].tokenname==temptoken)
							{
							gview.interfacekey[i].binding=key.binding;
							gview.interfacekey[i].shift=key.shift;
							break;
							}
						}

					if(i==INTERFACEKEYNUM)
						{
						string str="Unknown Interface Token: ";
						str+=temptoken;
						errorlog_string(str);
						}
					}
				}
			}
		}
	fseed.close();
}

void gamest::print()
{
	gps.erasescreen();

	cave.print();

	//PRINT CRITTERS
	long u;
	for(u=0;u<unit.global.size();u++)
		{
		if(unit.global[u]->unit_type==UNIT_CRITTER)
			{
			if(cave.lighting[unit.global[u]->x][unit.global[u]->y])
				{
				critterst *crt=critter.get_critter_by_global_id(unit.global[u]->unit_id);

				gps.locate(unit.global[u]->y,unit.global[u]->x);
				if(crt!=NULL)gps.changecolor(crt->color[0],crt->color[1],crt->color[2]);
				else gps.changecolor(2,0,1);
				gps.addchar('*');
				}
			}
		}

	long sk=-1,k;
	for(k=0;k<kobold.global.size();k++)
		{
		if(kobold.global[k]->global_id==selected_kobold)
			{
			sk=k;
			break;
			}
		}
	unitst *un=NULL;
	if(sk!=-1)un=unit.get_unit_by_type_and_id(UNIT_KOBOLD,kobold.global[sk]->global_id);

	long targ_id=-1;

	if(main_interface.naming_cave){}
	else if(main_interface.viewing_critter!=-1){}
	else if(main_interface.throwing)
		{
		unitst *targ=main_interface.target_unit[main_interface.selected_target];
		targ_id=targ->global_id;

		if(un!=NULL)
			{
			cave.drawline(un->x,un->y,targ->x,targ->y,1);
			gps.changecolor(4,0,0);
			long l;
			for(l=0;l<cave.linelim;l++)
				{
				gps.locate(cave.line[0][l][1],cave.line[0][l][0]);
				gps.addchar('x');
				}
			}
		}

	//PRINT KOBS AND ADV
	for(u=0;u<unit.global.size();u++)
		{
		if(unit.global[u]->unit_type==UNIT_KOBOLD)
			{
			gps.locate(unit.global[u]->y,unit.global[u]->x);

			koboldst *kob=kobold.get_kobold_by_global_id(unit.global[u]->unit_id);
			if(kob!=NULL)
				{
				if(kob->carried_critter_id!=-1&&GetTickCount()%666<333)
					{
					critterst *crt=critter.get_critter_by_global_id(kob->carried_critter_id);

					if(crt!=NULL)gps.changecolor(crt->color[0],crt->color[1],crt->color[2]);
					else gps.changecolor(2,0,1);
					gps.addchar('*');
					continue;
					}

				short color[3]={6,0,0};
				if(kob->def!=NULL)
					{
					color[0]=kob->def->color[0];
					color[1]=kob->def->color[1];
					color[2]=kob->def->color[2];
					}

				if(unit.global[u]->unit_id==selected_kobold&&GetTickCount()%500<100)color[2]=1-color[2];
				gps.changecolor(color[0],color[1],color[2]);
				gps.addchar('k');
				}
			}
		if(unit.global[u]->unit_type==UNIT_ADVENTURER)
			{
			if(cave.lighting[unit.global[u]->x][unit.global[u]->y])
				{
				adventurerst *adv=adventurer.get_adventurer_by_global_id(unit.global[u]->unit_id);

				short color[3]={6,0,0};
				if(adv->def!=NULL)
					{
					color[0]=adv->def->color[0];
					color[1]=adv->def->color[1];
					color[2]=adv->def->color[2];
					}

				gps.locate(unit.global[u]->y,unit.global[u]->x);
				if(targ_id==unit.global[u]->global_id&&!trandom(2))gps.changecolor(4,0,1);
				else gps.changecolor(color[0],color[1],color[2]);
				if(adv->def!=NULL)
					{
					gps.addchar(adv->def->tile);
					}
				else gps.addchar('@');
				}
			}
		}

	if(main_interface.naming_cave)
		{
		gps.changecolor(7,0,1);
		gps.locate(23,0);
		gps.addst("Name your cave:");
		gps.locate(24,0);
		gps.addst("\"My kobolds live in ");
		gps.addst(cave.name);
		if(GetTickCount()%666<333)gps.addst("_");
		else gps.addst(" ");
		gps.addst(".\"");
		}
	else if(main_interface.throwing)
		{
		unitst *targ=main_interface.target_unit[main_interface.selected_target];
		adventurerst *adv=adventurer.get_adventurer_by_global_id(targ->unit_id);

		if(adv!=NULL)
			{
			gps.changecolor(7,0,1);
			gps.locate(23,0);
			gps.addst("Hurling at ");
			if(adv->def!=NULL)
				{
				if(!adv->def->title.empty())
					{
					gps.addst(adv->def->title);
					gps.addst(" ");
					}
				}
			gps.addst(adv->name);
			if(adv->def!=NULL)
				{
				gps.addst(", ");
				gps.addst(adv->def->name);
				}
			}
		}
	else
		{
		short mx,my;
		gview.get_mouse_hover(mx,my);

		short look_x=-1,look_y;

		koboldst *look_kob=NULL;
		adventurerst *look_adv=NULL;

		if(un!=NULL)
			{
			look_kob=kobold.global[sk];
			look_x=un->x;
			look_y=un->y;
			}
		if(mx!=-1&&my<23)
			{
			long u;
			for(u=0;u<unit.global.size();u++)
				{
				if(!cave.lighting[unit.global[u]->x][unit.global[u]->y])continue;//1.02

				if(unit.global[u]->unit_type==UNIT_ADVENTURER&&
					unit.global[u]->x==mx&&
					unit.global[u]->y==my)
					{
					look_adv=adventurer.get_adventurer_by_global_id(unit.global[u]->unit_id);
					look_x=-1;
					look_y=-1;
					}
				if(unit.global[u]->unit_type==UNIT_KOBOLD&&
					unit.global[u]->x==mx&&
					unit.global[u]->y==my)
					{
					look_kob=kobold.get_kobold_by_global_id(unit.global[u]->unit_id);
					look_x=mx;
					look_y=my;
					}
				}
			}

		if(look_adv!=NULL)
			{
			gps.changecolor(7,0,1);
			gps.locate(23,0);
			gps.addst("Looking at ");
			if(look_adv->def!=NULL)
				{
				if(!look_adv->def->title.empty())
					{
					gps.addst(look_adv->def->title);
					gps.addst(" ");
					}
				}
			gps.addst(look_adv->name);
			if(look_adv->def!=NULL)
				{
				gps.addst(", ");
				gps.addst(look_adv->def->name);
				}
			}
		else if(look_kob!=NULL)
			{
			gps.changecolor(7,0,1);
			gps.locate(23,0);
			if(sk!=-1)
				{
				if(look_kob!=kobold.global[sk])gps.addst("Looking at ");
				}
			else gps.addst("Looking at ");
			if(look_kob->def!=NULL)gps.addst(look_kob->def->name);
			gps.addst(", ");
			string str;
			if(look_kob->def!=NULL)convert_long_to_string(look_kob->def->xp_level,str);
			gps.addst(str);
			gps.addst(" XP");

			if(look_kob->carried_critter_id!=-1)
				{
				critterst *crt=critter.get_critter_by_global_id(look_kob->carried_critter_id);

				if(crt!=NULL)gps.changecolor(crt->color[0],crt->color[1],crt->color[2]);
				else gps.changecolor(2,0,1);
				gps.locate(23,40);
				gps.addst("Carrying ");
				critterst *crit=critter.get_critter_by_global_id(look_kob->carried_critter_id);
				if(crit!=NULL)gps.addst(crit->name);
				else gps.addst("Critter");
				}
			}
		else
			{
			gps.changecolor(7,0,0);
			gps.locate(23,0);
			gps.addst("No Kobold Selected");
			}

		if(look_x!=-1)
			{
			string str;

			long critter_count=0;
			long u;
			for(u=0;u<unit.global.size();u++)
				{
				if(unit.global[u]->unit_type==UNIT_CRITTER&&
					unit.global[u]->x==look_x&&
					unit.global[u]->y==look_y)critter_count++;
				}
			if(critter_count>0)
				{
				gps.changecolor(2,0,1);
				gps.locate(24,40);
				convert_long_to_string(critter_count,str);
				gps.addst(str);
				gps.addst(" Critter");
				if(critter_count>1)gps.addst("s");
				gps.addst(" On Ground");
				}
			
			if(cave.map[look_x][look_y].type==CAVE_SQUARE_PIT_COVERED)
				{
				gps.changecolor(4,0,1);
				gps.locate(24,0);
				gps.addst("Covered Pit");
				long power=0;
				long t;
				for(t=0;t<cave.trap_x.size();t++)
					{
					if(cave.trap_x[t]==look_x&&
						cave.trap_y[t]==look_y)
						{
						power=cave.trap_power[t];
						break;
						}
					}
				if(power>0)
					{
					gps.addst(" with ");
					convert_long_to_string(power,str);
					gps.addst(str);
					gps.addst(" Critter");
					if(power>1)gps.addst("s");
					}
				}
			else if(cave.map[look_x][look_y].type==CAVE_SQUARE_PIT_OPEN)
				{
				gps.changecolor(6,0,1);
				gps.locate(24,0);
				gps.addst("Open Pit");
				}
			}

		if(main_interface.viewing_critter!=-1)
			{
			critterst *crt=critter.get_critter_by_global_id(main_interface.viewing_critter);

			if(crt!=NULL)
				{
				gps.setclipping(10,69,1,21);
				gps.erasescreen_clip();
				gps.changecolor(crt->color[0],crt->color[1],crt->color[2]);
				gps.locate(2,11);
				gps.addst(crt->name);
				gps.changecolor(7,0,1);
				long y=4;
				long t;
				for(t=0;t<crt->description.text.str.size();t++)
					{
					gps.locate(y,11);
					gps.addst(crt->description.text.str[t]->dat);
					y++;
					}
				gps.setclipping(0,79,0,24);
				}
			}
		}

	gps.renewscreen();
}

void gamest::load_score_list()
{
	file_compressorst filecomp;

	string filename="data/save/score.dat";
	if(filecomp.open_file(filename,1))
		{
		long loadversion,dummy;
		filecomp.read_file(loadversion);

		filecomp.read_file(dummy);
		while(dummy>0)
			{
			adventurerst *newa=adventurerst::create_for_load();
				newa->read_file(filecomp,loadversion);
				//WE ADJUST THE NEXT ADVENTURER ID NUMBER SO THERE AREN'T ANY CONFLICTS
				if(next_adventurer_id<=newa->global_id)next_adventurer_id=newa->global_id+1;

			dummy--;
			}

		filecomp.close_file();
		}
}

void gamest::save_score_list()
{
	file_compressorst filecomp;

	string filename="data/save/score.dat";
	if(filecomp.open_file(filename,0))
		{
		filecomp.write_file(version);

		long dummy=adventurer.global.size();
		filecomp.write_file(dummy);
		long m;
		for(m=0;m<adventurer.global.size();m++)
			{
			adventurer.global[m]->trap_x.clear();
			adventurer.global[m]->trap_y.clear();
			adventurer.global[m]->have_announced=0;

			adventurer.global[m]->write_file(filecomp);
			}

		filecomp.flush_in_buffer();
		filecomp.close_file();
		}
}

void gamest::create_initial_kobolds()
{
	koboldst *newk;
	unitst *newu;

	long initial_number=10;
	while(initial_number>0)
		{
		newk=koboldst::create();
			selected_kobold=newk->global_id;
		newu=unitst::create();
			newu->unit_type=UNIT_KOBOLD;
			newu->unit_id=newk->global_id;
			newu->random_placement();
		initial_number--;
		}
}

void gamest::turn()
{
	if(critter.global.size()<MAX_CRITTER&&!trandom(5))
		{
		critterst *newc=critterst::create();
		unitst *newu=unitst::create();
			newu->unit_type=UNIT_CRITTER;
			newu->unit_id=newc->global_id;
			newu->random_placement();
		}

	if(reprieve_time>0)reprieve_time--;
	else create_adventurer_wave();

	move_critters();

	move_adventurers();

	cave.do_lighting();

	//1.02
	if(adventurer_wait)
		{
		if(cave.have_lit_adventurer())
			{
			pass_turn=0;
			adventurer_wait=0;
			}
		}
	else pass_turn=0;

	//1.02: CURRENTLY WILL DUMP A TON OF SOUND WHEN YOU WAIT FOR ADVENTURERS, MIGHT BE OKAY
	if(cur_sound!=-1)
		{
		play_sound(cur_sound);
		cur_sound=-1;
		}
}

void gamest::create_adventurer_wave()
{
	long total_xp=0;
	long k;
	for(k=0;k<kobold.global.size();k++)
		{
		if(kobold.global[k]->def==NULL)continue;
		total_xp+=kobold.global[k]->def->xp_level;
		}

	long num=1;
	if(total_xp>=2000)num=6;
	else if(total_xp>=1000)num=5;
	else if(total_xp>=500)num=4;
	else if(total_xp>=200)num=3;
	else if(total_xp>=100)num=2;

	svector<adventurerst *> candidate;
	long a;
	for(a=0;a<adventurer.global.size();a++)
		{
		if(unit.get_unit_by_type_and_id(UNIT_ADVENTURER,adventurer.global[a]->global_id))continue;
		if(!adventurer.global[a]->death_string.empty())continue;

		//ONE-THIRD OF THE OLD ADVENTURERS CONSIDER COMING, MOSTLY WITHIN THE XP RANGE OF YOUR GROUP
		if((adventurer.global[a]->calc_total_xp()<total_xp*50 || !trandom(10))&&!trandom(3))
			{
			candidate.push_back(adventurer.global[a]);
			}
		}

	while(num>0)
		{
		adventurerst *newa;
		if(candidate.size()>0)
			{
			//1.02 -- changed this around so that candidates are removed after they are used
			long c=trandom(candidate.size());
			newa=candidate[c];
			candidate.erase(c);
			}
		else newa=adventurerst::create();

		unitst *newu=unitst::create();
			newu->unit_type=UNIT_ADVENTURER;
			newu->unit_id=newa->global_id;
			newu->entry_way_placement();

		num--;
		}


	reprieve_time=200;
}

void gamest::move_critters()
{
	//CRITTERS JUST MOVE AROUND RANDOMLY, OCCASIONALLY
	long u;
	for(u=0;u<unit.global.size();u++)
		{
		if(unit.global[u]->unit_type==UNIT_CRITTER&&!trandom(10))unit.global[u]->move_randomly();
		}
}

void gamest::move_adventurers()
{
	svector<long> deleted_kobs;

	long u,t,tx,ty,best_dist,u2,pitx,pity;
	for(u=(long)unit.global.size()-1;u>=0;u--)
		{
		if(unit.global[u]->unit_type==UNIT_ADVENTURER)
			{
			adventurerst *adv=adventurer.get_adventurer_by_global_id(unit.global[u]->unit_id);

			tx=-1,best_dist=-1;

			//CHECK FOR TARGET
			for(u2=(long)unit.global.size()-1;u2>=0;u2--)
				{
				if(unit.global[u2]->unit_type==UNIT_KOBOLD)
					{
					if(cave.drawline(unit.global[u]->x,unit.global[u]->y,unit.global[u2]->x,unit.global[u2]->y,1))
						{
						if(cave.linelim<best_dist||best_dist==-1)
							{
							tx=unit.global[u2]->x;
							ty=unit.global[u2]->y;

							best_dist=cave.linelim;
							}
						}
					}
				}

			//MOVE
			if(tx!=-1)
				{
				if(adv!=NULL)
					{
					if(!adv->have_announced)
						{
						set_sound(SOUND_ADVENTURER_TARGET_1);
						adv->have_announced=1;
						}
					}

				unit.global[u]->move_toward(tx,ty);
				}
			else unit.global[u]->move_randomly();

			//CHECK FOR TRAP
			if(cave.map[unit.global[u]->x][unit.global[u]->y].type==CAVE_SQUARE_PIT_COVERED)
				{
				char skipped=0;
				if(adv!=NULL)
					{
					if(adv->has_seen_trap(unit.global[u]->x,unit.global[u]->y))skipped=1;
					}

				if(!skipped)
					{
					//DESTROY TRAP AND CREDIT KOBOLD SETTER
					string c_name;
					long kob_id;
					long power=cave.set_off_trap(unit.global[u]->x,unit.global[u]->y,kob_id,c_name);

					//TRY TO KILL ADVENTURER
					char dead=0;
					if(power==0)
						{
						if(!trandom(3))dead=1;
						}
					else if(power>0)
						{
						if(trandom(power+1))dead=1;
						}

					if(dead)
						{
						koboldst *kob=kobold.get_kobold_by_global_id(kob_id);
						if(kob!=NULL)kob->gain_level();

						if(adv!=NULL)adv->die(0,c_name);

						unit.remove_unit(u);
						continue;
						}
					}
				}

			//LOOK AROUND FOR FAR AWAY TRAPS
			for(t=(long)cave.trap_x.size()-1;t>=0;t--)
				{
				pitx=cave.trap_x[t];
				pity=cave.trap_y[t];
				if(cave.map[pitx][pity].type==CAVE_SQUARE_PIT_OPEN)
					{
					if(cave.drawline(unit.global[u]->x,unit.global[u]->y,pitx,pity,1))
						{
						if(adv!=NULL)adv->add_seen_trap(pitx,pity);
						}
					}
				}

			//CHECK FOR KOBOLD
			for(u2=(long)unit.global.size()-1;u2>=0;u2--)
				{
				if(unit.global[u2]->unit_type==UNIT_KOBOLD&&
					unit.global[u2]->x==unit.global[u]->x&&
					unit.global[u2]->y==unit.global[u]->y)
					{
					koboldst *kob=kobold.get_kobold_by_global_id(unit.global[u2]->unit_id);

					if(adv!=NULL&&kob!=NULL)
						{
						if(kob->def!=NULL)adv->give_kill(kob->def->name,kob->def->xp_level);
						}

					set_sound(SOUND_ADVENTURER_KILL_1);

					kobold.remove_kobold_by_global_id(unit.global[u2]->unit_id);
					deleted_kobs.push_back(unit.global[u2]->unit_id);
					}
				}
			}
		}

	//MUST SAVE THE IDs HERE AND DELETE NOW OR ELSE ADVENTURER LOOP WOULD BE TRASHED
	if(deleted_kobs.size()>0)
		{
		long k;
		for(k=0;k<deleted_kobs.size();k++)
			{
			for(u2=(long)unit.global.size()-1;u2>=0;u2--)
				{
				if(unit.global[u2]->unit_type==UNIT_KOBOLD&&
					unit.global[u2]->unit_id==deleted_kobs[k])
					{
					unit.remove_unit(u2);
					}
				}
			}
		}
}

void gamest::input()
{
	long sk=-1,k;
	unitst *un=NULL;
	for(k=0;k<kobold.global.size();k++)
		{
		if(kobold.global[k]->global_id==selected_kobold)
			{
			sk=k;
			break;
			}
		}
	if(sk!=-1)un=unit.get_unit_by_type_and_id(UNIT_KOBOLD,kobold.global[sk]->global_id);

	if(main_interface.naming_cave)
		{
		gview.standardstringentry(cave.name,50,0);
		
		if(gview.keypress(INTERFACEKEY_SELECT))main_interface.naming_cave=0;
		}
	else if(main_interface.viewing_critter!=-1)
		{
		if(gview.keypress(INTERFACEKEY_LEAVESCREEN))main_interface.viewing_critter=-1;
		}
	else if(main_interface.throwing)
		{
		short mx,my;
		gview.get_mouse_hover(mx,my);

		if(gview.mouse_lbut())
			{
			long u;
			for(u=0;u<main_interface.target_unit.size();u++)
				{
				if(main_interface.target_unit[u]->x==mx&&
					main_interface.target_unit[u]->y==my)
					{
					main_interface.selected_target=u;
					break;
					}
				}
			}

		if(gview.keypress(INTERFACEKEY_SELECT))
			{
			unitst *targ=main_interface.target_unit[main_interface.selected_target];

			unitst *newu=unitst::create();
				newu->unit_type=UNIT_CRITTER;
				newu->unit_id=kobold.global[sk]->carried_critter_id;
				newu->x=targ->x;
				newu->y=targ->y;

			if(!trandom(3))
				{
				string c_name;
				critterst *crt=critter.get_critter_by_global_id(kobold.global[sk]->carried_critter_id);
				if(crt!=NULL)c_name=crt->name;

				adventurerst *adv=adventurer.get_adventurer_by_global_id(targ->unit_id);
				unit.remove_unit(targ);
				if(adv!=NULL)adv->die(1,c_name);

				kobold.global[sk]->gain_level();
				}
			else set_sound(SOUND_ADVENTURER_DODGE_1);

			kobold.global[sk]->carried_critter_id=-1;
			main_interface.throwing=0;
			pass_turn=1;
			}

		if(gview.keypress(INTERFACEKEY_LEAVESCREEN))
			{
			main_interface.throwing=0;
			}

		if(gview.keypress(INTERFACEKEY_SELECT_KOBOLD_UP))
			{
			main_interface.selected_target=(main_interface.selected_target+1)%main_interface.target_unit.size();
			}

		if(gview.keypress(INTERFACEKEY_SELECT_KOBOLD_DOWN))
			{
			main_interface.selected_target=(main_interface.selected_target+(long)main_interface.target_unit.size()-1)%main_interface.target_unit.size();
			}
		}
	else
		{
		short mx,my;
		gview.get_mouse_hover(mx,my);

		if(gview.mouse_lbut())
			{
			long u;
			for(u=0;u<unit.global.size();u++)
				{
				if(unit.global[u]->unit_type==UNIT_KOBOLD&&
					unit.global[u]->x==mx&&
					unit.global[u]->y==my)
					{
					if(unit.global[u]->unit_id!=selected_kobold)
						{
						selected_kobold=unit.global[u]->unit_id;
						set_sound(SOUND_KOBOLD_SELECT_1);
						}
					break;
					}
				}
			}

		//MOVE YOUR SELECTED KOBOLD AROUND
		if(gview.keypress(INTERFACEKEY_SELECT_KOBOLD_UP))
			{
			selected_kobold=-1;
			if(sk+1<kobold.global.size())selected_kobold=kobold.global[sk+1]->global_id;
			else if(kobold.global.size()>0)selected_kobold=kobold.global[0]->global_id;
			if(selected_kobold!=-1)set_sound(SOUND_KOBOLD_SELECT_1);
			}
		if(gview.keypress(INTERFACEKEY_SELECT_KOBOLD_DOWN))
			{
			selected_kobold=-1;
			if(sk-1>=0)selected_kobold=kobold.global[sk-1]->global_id;
			else if(kobold.global.size()>0)selected_kobold=kobold.global[(long)kobold.global.size()-1]->global_id;
			if(selected_kobold!=-1)set_sound(SOUND_KOBOLD_SELECT_1);
			}

		//1.02
		if(gview.keypress(INTERFACEKEY_WAIT_FOR_ADVENTURER))
			{
			pass_turn=1;
			if(!cave.have_lit_adventurer())adventurer_wait=1;
			}
		if(gview.keypress(INTERFACEKEY_LEAVESCREEN)&&adventurer_wait)adventurer_wait=0;

		if(un!=NULL)
			{
			if(gview.keypress(INTERFACEKEY_COVER_TRAP))
				{
				if(cave.cover_trap(un))
					{
					set_sound(SOUND_KOBOLD_COVER_1);
					pass_turn=1;
					}
				}
			if(gview.keypress(INTERFACEKEY_PICK_UP_CRITTER)&&
				kobold.global[sk]->carried_critter_id==-1)
				{
				svector<long> candidate_u;

				//JUST PICK UP A RANDOM BUG
				long c;
				for(c=0;c<unit.global.size();c++)
					{
					if(unit.global[c]->unit_type==UNIT_CRITTER&&
						unit.global[c]->x==un->x&&
						unit.global[c]->y==un->y)
						{
						candidate_u.push_back(c);
						}
					}
				if(candidate_u.size()>0)
					{
					c=candidate_u[trandom(candidate_u.size())];
					kobold.global[sk]->carried_critter_id=unit.global[c]->unit_id;
					unit.remove_unit(c);

					set_sound(SOUND_KOBOLD_PICKUP_1);

					pass_turn=1;
					}
				}
			if(gview.keypress(INTERFACEKEY_DROP_CRITTER)&&
				kobold.global[sk]->carried_critter_id!=-1)
				{
				unitst *newu=unitst::create();
					newu->unit_type=UNIT_CRITTER;
					newu->unit_id=kobold.global[sk]->carried_critter_id;
					newu->x=un->x;
					newu->y=un->y;
				kobold.global[sk]->carried_critter_id=-1;

				set_sound(SOUND_KOBOLD_DROP_1);

				pass_turn=1;
				}
			if(gview.keypress(INTERFACEKEY_DESCRIBE_HELD_CRITTER)&&
				kobold.global[sk]->carried_critter_id!=-1)
				{
				main_interface.viewing_critter=kobold.global[sk]->carried_critter_id;
				}
			if(gview.keypress(INTERFACEKEY_THROW_CRITTER)&&
				kobold.global[sk]->carried_critter_id!=-1)
				{
				main_interface.target_unit.clear();
				
				long u;
				for(u=0;u<unit.global.size();u++)
					{
					if(unit.global[u]->unit_type==UNIT_ADVENTURER)
						{
						if(cave.drawline(un->x,un->y,unit.global[u]->x,unit.global[u]->y,1))
							{
							main_interface.target_unit.push_back(unit.global[u]);
							}
						}
					}

				if(main_interface.target_unit.size()>0)
					{
					main_interface.throwing=1;
					main_interface.selected_target=0;
					}
				}
			if(gview.keypress(INTERFACEKEY_WAIT))
				{
				pass_turn=1;
				}
			}

		if(sk!=-1)
			{
			short sx,sy;
			gview.get_cursor_vars(sx,sy);

			if(sx!=0||sy!=0)
				{
				if(un!=NULL)
					{
					short px=un->x+sx;
					short py=un->y+sy;

					if(cave.walkable(px,py,un,1))
						{
						un->x+=sx;
						un->y+=sy;

						pass_turn=1;
						}
					}
				}
			}
		}
}

void gamest::save_active_game()
{
	file_compressorst filecomp;

	string filename="data/save/save.dat";
	if(filecomp.open_file(filename,0))
		{
		filecomp.write_file(version);

		//ADVENTURERS
		long dummy=adventurer.global.size();
		filecomp.write_file(dummy);
		long m;
		for(m=0;m<adventurer.global.size();m++)
			{
			adventurer.global[m]->write_file(filecomp);
			}

		//KOBOLDS
		dummy=kobold.global.size();
		filecomp.write_file(dummy);
		for(m=0;m<kobold.global.size();m++)
			{
			kobold.global[m]->write_file(filecomp);
			}

		//CRITTERS
		dummy=critter.global.size();
		filecomp.write_file(dummy);
		for(m=0;m<critter.global.size();m++)
			{
			critter.global[m]->write_file(filecomp);
			}

		//UNITS
		dummy=unit.global.size();
		filecomp.write_file(dummy);
		for(m=0;m<unit.global.size();m++)
			{
			unit.global[m]->write_file(filecomp);
			}

		//CAVE
		cave.write_file(filecomp);

		//GAME
		write_file(filecomp);

		filecomp.flush_in_buffer();
		filecomp.close_file();
		}
}

char gamest::load_active_game()
{
	file_compressorst filecomp;

	string filename="data/save/save.dat";
	if(filecomp.open_file(filename,1))
		{
		long loadversion,dummy;
		filecomp.read_file(loadversion);

		//ADVENTURERS
		filecomp.read_file(dummy);
		while(dummy>0)
			{
			adventurerst *newa=adventurerst::create_for_load();
				newa->read_file(filecomp,loadversion);

			dummy--;
			}

		//KOBOLDS
		filecomp.read_file(dummy);
		while(dummy>0)
			{
			koboldst *newa=koboldst::create_for_load();
				newa->read_file(filecomp,loadversion);

			dummy--;
			}

		//CRITTERS
		filecomp.read_file(dummy);
		while(dummy>0)
			{
			critterst *newa=critterst::create_for_load();
				newa->read_file(filecomp,loadversion);

			dummy--;
			}

		//UNITS
		filecomp.read_file(dummy);
		while(dummy>0)
			{
			unitst *newa=unitst::create_for_load();
				newa->read_file(filecomp,loadversion);

			dummy--;
			}

		//CAVE
		cave.read_file(filecomp,loadversion);

		//GAME
		read_file(filecomp,loadversion);

		filecomp.close_file();

		return 1;
		}
	else return 0;
}

void gamest::write_file(file_compressorst &filecomp)
{
	filecomp.write_file(main_interface.naming_cave);
	filecomp.write_file(next_unit_id);
	filecomp.write_file(next_kobold_id);
	filecomp.write_file(next_adventurer_id);
	filecomp.write_file(next_critter_id);
	filecomp.write_file(selected_kobold);
	filecomp.write_file(reprieve_time);
}

void gamest::read_file(file_compressorst &filecomp,long loadversion)
{
	filecomp.read_file(main_interface.naming_cave);
	filecomp.read_file(next_unit_id);
	filecomp.read_file(next_kobold_id);
	filecomp.read_file(next_adventurer_id);
	filecomp.read_file(next_critter_id);
	filecomp.read_file(selected_kobold);
	filecomp.read_file(reprieve_time);
}

void gamest::set_sound(long s)
{
	//PLAY SOUNDS THAT AREN'T TURN BASED IMMEDIATELY
	switch(s)
		{
		case SOUND_CLICK:
		case SOUND_KOBOLD_SELECT_1:
			play_sound(s);
			return;
		}

	long priority=0;

	//NOT GOING TO DO MULTIPLE CHANNELS -- INSTEAD, JUST PLAY THE MOST IMPORTANT SOUND OF THE TURN
	if(cur_sound!=-1)
		{
		switch(s)
			{
			case SOUND_ADVENTURER_DIE_1:priority=2;break;
			case SOUND_ADVENTURER_DODGE_1:priority=1;break;
			case SOUND_ADVENTURER_KILL_1:priority=4;break;
			case SOUND_ADVENTURER_TARGET_1:priority=3;break;
			}

		if(priority<cur_sound_priority)return;
		}

	cur_sound=s;
	cur_sound_priority=priority;
}

void gamest::play_sound(long s)
{
	switch(s)
		{
		case SOUND_ADVENTURER_DIE_1:
			s+=trandom(5);
			break;
		case SOUND_ADVENTURER_TARGET_1:
			s+=trandom(5);
			break;
		case SOUND_ADVENTURER_DODGE_1:
			s+=trandom(5);
			break;
		case SOUND_ADVENTURER_KILL_1:
			s+=trandom(5);
			break;
		case SOUND_KOBOLD_COVER_1:
			s+=trandom(5);
			break;
		case SOUND_KOBOLD_DROP_1:
			s+=trandom(5);
			break;
		case SOUND_KOBOLD_PICKUP_1:
			s+=trandom(5);
			break;
		case SOUND_KOBOLD_SELECT_1:
			s+=trandom(5);
			break;
		}

#ifndef NO_FMOD
	musicsound.playsound(s,1,15,-1);
#endif
}