//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#if defined(__APPLE__)
#include "platform.h"
#else
#include <windows.h>
#endif
#include <string.h>
#include <math.h>
#include <iosfwd>
#include <iostream>
#include <ios>
#include <streambuf>
#include <istream>
#include <ostream>
#include <iomanip>
#include <sstream>
#include <cstdlib>
#include <fstream>
#if defined(__APPLE__)
#include <zlib.h>
#else
#include "zlib/zlib.h"
#endif

#include "svector.h"
using std::string;

#include "random.h"

#include "endian.h"

#include "files.h"
#include "find_files.h"

#include "enabler.h"

//#pragma warning( 3 : 4189 )

#include "graphics.h"

#include "music_and_sound_g.h"

#include "basics.h"

#include "definition.h"

#include "critter.h"

#include "kobold.h"

#include "adventurer.h"

#include "unit.h"

#include "cave.h"

#include "interface.h"

#include "init.h"

#include "command_line.h"

inline void CHECK_ERR(int err, const char* msg)
{
	if (err != Z_OK)
		{
		MessageBox(NULL, "One of the compressed files on disk has errors in it.  Restore from backup if you are able.", 0, 0);
		exit(1);
		}
}

class gamest
{
	public:
		definition_handlerst definition;
		command_linest command_line;
		main_interfacest main_interface;

		long next_text_id;

		cavest cave;

		unit_handlerst unit;
		long next_unit_id;

		kobold_handlerst kobold;
		long next_kobold_id;

		adventurer_handlerst adventurer;
		long next_adventurer_id;

		critter_handlerst critter;
		long next_critter_id;

		long selected_kobold;
		
		char pass_turn;
		char adventurer_wait;//1.02
		long reprieve_time;
		long cur_sound;
		long cur_sound_priority;

		gamest()
			{
			next_text_id=TEXTNUM;
			}

		void end_game();
		void clean();
		void load_option_files();
		void print();
		void load_score_list();
		void save_score_list();
		void create_initial_kobolds();
		void turn();
		void create_adventurer_wave();
		void move_critters();
		void move_adventurers();
		void input();
		void save_active_game();
		char load_active_game();
		void write_file(file_compressorst &filecomp);
		void read_file(file_compressorst &filecomp,long loadversion);
		void set_sound(long s);
		void play_sound(long s);
};