//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

void graphicst::locate(long y,long x)
{
	if(x<0||x>=80||y<0||y>=25)
		{
		screenx=40;
		screeny=12;
		return;
		}

	screenx=x;
	screeny=y;
}

void graphicst::changecolor(short f,short b,char bright)
{
	screenf=f;
	screenb=b;
	screenbright=bright;
}

void graphicst::addchar(unsigned char c)
{
	if(screenx>=clipx[0]&&screenx<=clipx[1]&&
		screeny>=clipy[0]&&screeny<=clipy[1])
		{
		screen[screenx][screeny][0]=c;
		screen[screenx][screeny][1]=screenf;
		screen[screenx][screeny][2]=screenb;
		screen[screenx][screeny][3]=screenbright;
		}
	screenx++;
}

void graphicst::addst(const string &str)
{
	int s;
	for(s=0;s<str.length()&&screenx<80;s++)
		{
		if(screenx<0)
			{
			s-=screenx;
			screenx=0;
			if(s>=str.length())break;
			}

		addchar(str[s]);
		}
}

void graphicst::addst(const char *str)
{
	int s;
	for(s=0;s<strlen(str)&&screenx<80;s++)
		{
		if(screenx<0)
			{
			s-=screenx;
			screenx=0;
			if(s>=strlen(str))break;
			}

		addchar(str[s]);
		}
}

void graphicst::erasescreen_clip(void)
{
	int x2,y2;
	for(x2=clipx[0];x2<=clipx[1];x2++)
		{
		for(y2=clipy[0];y2<=clipy[1];y2++)
			{
			screen[x2][y2][0]=' ';
			screen[x2][y2][1]=0;
			screen[x2][y2][2]=0;
			screen[x2][y2][3]=0;
			}
		}
}

void graphicst::erasescreen(void)
{
	int x2,y2;
	for(x2=0;x2<80;x2++)
		{
		for(y2=0;y2<25;y2++)
			{
			screen[x2][y2][0]=' ';
			screen[x2][y2][1]=0;
			screen[x2][y2][2]=0;
			screen[x2][y2][3]=0;
			}
		}
}

void graphicst::renewscreen(void)
{
	enabler.cursesrect_usebuffer(rect_id,(char *)screen,8000);
	enabler.flag|=ENABLERFLAG_RENDER;
}

void graphicst::setclipping(long x1,long x2,long y1,long y2)
{
	if(x1<0)x1=0;
	if(x2>79)x2=79;
	if(y1<0)y1=0;
	if(y2>24)y2=24;

	clipx[0]=x1;
	clipx[1]=x2;
	clipy[0]=y1;
	clipy[1]=y2;
}

void graphicst::drawborder(const string &pstr)
{
	//DRAW BORDER
	erasescreen();

	if(pstr.length())
		{
		string astr=pstr;
		if(astr.length()>78)
			{
			astr.resize(78);
			//MAKE SOME OF THE SPACES EVEN
			if(astr[0]==' ')astr[77]=' ';
			if(astr[1]==' ')astr[76]=' ';
			}

		locate(0,39-((astr.length()-1)>>1));
		changecolor(COLOR_WHITE,COLOR_BLACK,1);
		addst(astr);
		}
}