//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

interfacest::interfacest()
{
	c=0;
	caps=0;
	shift=0;
	flag=0;

	interfacekey[INTERFACEKEY_SAVE_BINDINGS].name="Save Key Bindings";
	interfacekey[INTERFACEKEY_CHANGE_BINDINGS].name="Change Key Bindings";
	interfacekey[INTERFACEKEY_SELECT].name="Select";
	interfacekey[INTERFACEKEY_LEAVESCREEN].name="Leave Screen";
	interfacekey[INTERFACEKEY_TOGGLE_FULLSCREEN].name="Toggle Fullscreen";
	interfacekey[INTERFACEKEY_OPTIONS].name="Main menu";
	interfacekey[INTERFACEKEY_SELECT_KOBOLD_UP].name="Select Kobold (Up)";
	interfacekey[INTERFACEKEY_SELECT_KOBOLD_DOWN].name="Select Kobold (Down)";
	interfacekey[INTERFACEKEY_COVER_TRAP].name="Cover Trap";
	interfacekey[INTERFACEKEY_PICK_UP_CRITTER].name="Pick Up Critter";
	interfacekey[INTERFACEKEY_DROP_CRITTER].name="Drop Critter";
	interfacekey[INTERFACEKEY_THROW_CRITTER].name="Throw Held Critter";
	interfacekey[INTERFACEKEY_DESCRIBE_HELD_CRITTER].name="Describe Held Critter";
	interfacekey[INTERFACEKEY_WAIT].name="Wait";
	interfacekey[INTERFACEKEY_WAIT_FOR_ADVENTURER].name="Wait for Adventurer";//1.02
	interfacekey[INTERFACEKEY_STANDARDSCROLL_UP].name="Move selector up";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_DOWN].name="Move selector down";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_LEFT].name="Move selector left";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_RIGHT].name="Move selector right";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_PAGEUP].name="Page selector up";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_PAGEDOWN].name="Page selector down";
	interfacekey[INTERFACEKEY_CURSOR_UP].name="Move view/cursor up";
	interfacekey[INTERFACEKEY_CURSOR_DOWN].name="Move view/cursor down";
	interfacekey[INTERFACEKEY_CURSOR_LEFT].name="Move view/cursor left";
	interfacekey[INTERFACEKEY_CURSOR_RIGHT].name="Move view/cursor right";
	interfacekey[INTERFACEKEY_CURSOR_UPLEFT].name="Move view/cursor up and left";
	interfacekey[INTERFACEKEY_CURSOR_UPRIGHT].name="Move view/cursor up and right";
	interfacekey[INTERFACEKEY_CURSOR_DOWNLEFT].name="Move view/cursor down and left";
	interfacekey[INTERFACEKEY_CURSOR_DOWNRIGHT].name="Move view/cursor down and right";
	interfacekey[INTERFACEKEY_STRING_A].name="String: a";
	interfacekey[INTERFACEKEY_STRING_B].name="String: b";
	interfacekey[INTERFACEKEY_STRING_C].name="String: c";
	interfacekey[INTERFACEKEY_STRING_D].name="String: d";
	interfacekey[INTERFACEKEY_STRING_E].name="String: e";
	interfacekey[INTERFACEKEY_STRING_F].name="String: f";
	interfacekey[INTERFACEKEY_STRING_G].name="String: g";
	interfacekey[INTERFACEKEY_STRING_H].name="String: h";
	interfacekey[INTERFACEKEY_STRING_I].name="String: i";
	interfacekey[INTERFACEKEY_STRING_J].name="String: j";
	interfacekey[INTERFACEKEY_STRING_K].name="String: k";
	interfacekey[INTERFACEKEY_STRING_L].name="String: l";
	interfacekey[INTERFACEKEY_STRING_M].name="String: m";
	interfacekey[INTERFACEKEY_STRING_N].name="String: n";
	interfacekey[INTERFACEKEY_STRING_O].name="String: o";
	interfacekey[INTERFACEKEY_STRING_P].name="String: p";
	interfacekey[INTERFACEKEY_STRING_Q].name="String: q";
	interfacekey[INTERFACEKEY_STRING_R].name="String: r";
	interfacekey[INTERFACEKEY_STRING_S].name="String: s";
	interfacekey[INTERFACEKEY_STRING_T].name="String: t";
	interfacekey[INTERFACEKEY_STRING_U].name="String: u";
	interfacekey[INTERFACEKEY_STRING_V].name="String: v";
	interfacekey[INTERFACEKEY_STRING_W].name="String: w";
	interfacekey[INTERFACEKEY_STRING_X].name="String: x";
	interfacekey[INTERFACEKEY_STRING_Y].name="String: y";
	interfacekey[INTERFACEKEY_STRING_Z].name="String: z";
	interfacekey[INTERFACEKEY_STRING_A_CAP].name="String: A";
	interfacekey[INTERFACEKEY_STRING_B_CAP].name="String: B";
	interfacekey[INTERFACEKEY_STRING_C_CAP].name="String: C";
	interfacekey[INTERFACEKEY_STRING_D_CAP].name="String: D";
	interfacekey[INTERFACEKEY_STRING_E_CAP].name="String: E";
	interfacekey[INTERFACEKEY_STRING_F_CAP].name="String: F";
	interfacekey[INTERFACEKEY_STRING_G_CAP].name="String: G";
	interfacekey[INTERFACEKEY_STRING_H_CAP].name="String: H";
	interfacekey[INTERFACEKEY_STRING_I_CAP].name="String: I";
	interfacekey[INTERFACEKEY_STRING_J_CAP].name="String: J";
	interfacekey[INTERFACEKEY_STRING_K_CAP].name="String: K";
	interfacekey[INTERFACEKEY_STRING_L_CAP].name="String: L";
	interfacekey[INTERFACEKEY_STRING_M_CAP].name="String: M";
	interfacekey[INTERFACEKEY_STRING_N_CAP].name="String: N";
	interfacekey[INTERFACEKEY_STRING_O_CAP].name="String: O";
	interfacekey[INTERFACEKEY_STRING_P_CAP].name="String: P";
	interfacekey[INTERFACEKEY_STRING_Q_CAP].name="String: Q";
	interfacekey[INTERFACEKEY_STRING_R_CAP].name="String: R";
	interfacekey[INTERFACEKEY_STRING_S_CAP].name="String: S";
	interfacekey[INTERFACEKEY_STRING_T_CAP].name="String: T";
	interfacekey[INTERFACEKEY_STRING_U_CAP].name="String: U";
	interfacekey[INTERFACEKEY_STRING_V_CAP].name="String: V";
	interfacekey[INTERFACEKEY_STRING_W_CAP].name="String: W";
	interfacekey[INTERFACEKEY_STRING_X_CAP].name="String: X";
	interfacekey[INTERFACEKEY_STRING_Y_CAP].name="String: Y";
	interfacekey[INTERFACEKEY_STRING_Z_CAP].name="String: Z";
	interfacekey[INTERFACEKEY_STRING_SPACE].name="String: Space";
	interfacekey[INTERFACEKEY_STRING_BACKSPACE].name="String: Backspace";

	interfacekey[INTERFACEKEY_SAVE_BINDINGS].tokenname="SAVE_BINDINGS";
	interfacekey[INTERFACEKEY_CHANGE_BINDINGS].tokenname="CHANGE_BINDINGS";
	interfacekey[INTERFACEKEY_SELECT].tokenname="SELECT";
	interfacekey[INTERFACEKEY_LEAVESCREEN].tokenname="LEAVESCREEN";
	interfacekey[INTERFACEKEY_TOGGLE_FULLSCREEN].tokenname="TOGGLE_FULLSCREEN";
	interfacekey[INTERFACEKEY_OPTIONS].tokenname="OPTIONS";
	interfacekey[INTERFACEKEY_SELECT_KOBOLD_UP].tokenname="SELECT_KOBOLD_UP";
	interfacekey[INTERFACEKEY_SELECT_KOBOLD_DOWN].tokenname="SELECT_KOBOLD_DOWN";
	interfacekey[INTERFACEKEY_COVER_TRAP].tokenname="COVER_TRAP";
	interfacekey[INTERFACEKEY_PICK_UP_CRITTER].tokenname="PICK_UP_CRITTER";
	interfacekey[INTERFACEKEY_DROP_CRITTER].tokenname="DROP_CRITTER";
	interfacekey[INTERFACEKEY_THROW_CRITTER].tokenname="THROW_CRITTER";
	interfacekey[INTERFACEKEY_DESCRIBE_HELD_CRITTER].tokenname="DESCRIBE_HELD_CRITTER";
	interfacekey[INTERFACEKEY_WAIT].tokenname="WAIT";
	interfacekey[INTERFACEKEY_WAIT_FOR_ADVENTURER].tokenname="WAIT_FOR_ADVENTURER";//1.02
	interfacekey[INTERFACEKEY_STANDARDSCROLL_LEFT].tokenname="STANDARDSCROLL_LEFT";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_RIGHT].tokenname="STANDARDSCROLL_RIGHT";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_UP].tokenname="STANDARDSCROLL_UP";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_DOWN].tokenname="STANDARDSCROLL_DOWN";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_PAGEUP].tokenname="STANDARDSCROLL_PAGEUP";
	interfacekey[INTERFACEKEY_STANDARDSCROLL_PAGEDOWN].tokenname="STANDARDSCROLL_PAGEDOWN";
	interfacekey[INTERFACEKEY_CURSOR_UP].tokenname="CURSOR_UP";
	interfacekey[INTERFACEKEY_CURSOR_DOWN].tokenname="CURSOR_DOWN";
	interfacekey[INTERFACEKEY_CURSOR_LEFT].tokenname="CURSOR_LEFT";
	interfacekey[INTERFACEKEY_CURSOR_RIGHT].tokenname="CURSOR_RIGHT";
	interfacekey[INTERFACEKEY_CURSOR_UPLEFT].tokenname="CURSOR_UPLEFT";
	interfacekey[INTERFACEKEY_CURSOR_UPRIGHT].tokenname="CURSOR_UPRIGHT";
	interfacekey[INTERFACEKEY_CURSOR_DOWNLEFT].tokenname="CURSOR_DOWNLEFT";
	interfacekey[INTERFACEKEY_CURSOR_DOWNRIGHT].tokenname="CURSOR_DOWNRIGHT";
	interfacekey[INTERFACEKEY_STRING_A].tokenname="STRING_A";
	interfacekey[INTERFACEKEY_STRING_B].tokenname="STRING_B";
	interfacekey[INTERFACEKEY_STRING_C].tokenname="STRING_C";
	interfacekey[INTERFACEKEY_STRING_D].tokenname="STRING_D";
	interfacekey[INTERFACEKEY_STRING_E].tokenname="STRING_E";
	interfacekey[INTERFACEKEY_STRING_F].tokenname="STRING_F";
	interfacekey[INTERFACEKEY_STRING_G].tokenname="STRING_G";
	interfacekey[INTERFACEKEY_STRING_H].tokenname="STRING_H";
	interfacekey[INTERFACEKEY_STRING_I].tokenname="STRING_I";
	interfacekey[INTERFACEKEY_STRING_J].tokenname="STRING_J";
	interfacekey[INTERFACEKEY_STRING_K].tokenname="STRING_K";
	interfacekey[INTERFACEKEY_STRING_L].tokenname="STRING_L";
	interfacekey[INTERFACEKEY_STRING_M].tokenname="STRING_M";
	interfacekey[INTERFACEKEY_STRING_N].tokenname="STRING_N";
	interfacekey[INTERFACEKEY_STRING_O].tokenname="STRING_O";
	interfacekey[INTERFACEKEY_STRING_P].tokenname="STRING_P";
	interfacekey[INTERFACEKEY_STRING_Q].tokenname="STRING_Q";
	interfacekey[INTERFACEKEY_STRING_R].tokenname="STRING_R";
	interfacekey[INTERFACEKEY_STRING_S].tokenname="STRING_S";
	interfacekey[INTERFACEKEY_STRING_T].tokenname="STRING_T";
	interfacekey[INTERFACEKEY_STRING_U].tokenname="STRING_U";
	interfacekey[INTERFACEKEY_STRING_V].tokenname="STRING_V";
	interfacekey[INTERFACEKEY_STRING_W].tokenname="STRING_W";
	interfacekey[INTERFACEKEY_STRING_X].tokenname="STRING_X";
	interfacekey[INTERFACEKEY_STRING_Y].tokenname="STRING_Y";
	interfacekey[INTERFACEKEY_STRING_Z].tokenname="STRING_Z";
	interfacekey[INTERFACEKEY_STRING_A_CAP].tokenname="STRING_A_CAP";
	interfacekey[INTERFACEKEY_STRING_B_CAP].tokenname="STRING_B_CAP";
	interfacekey[INTERFACEKEY_STRING_C_CAP].tokenname="STRING_C_CAP";
	interfacekey[INTERFACEKEY_STRING_D_CAP].tokenname="STRING_D_CAP";
	interfacekey[INTERFACEKEY_STRING_E_CAP].tokenname="STRING_E_CAP";
	interfacekey[INTERFACEKEY_STRING_F_CAP].tokenname="STRING_F_CAP";
	interfacekey[INTERFACEKEY_STRING_G_CAP].tokenname="STRING_G_CAP";
	interfacekey[INTERFACEKEY_STRING_H_CAP].tokenname="STRING_H_CAP";
	interfacekey[INTERFACEKEY_STRING_I_CAP].tokenname="STRING_I_CAP";
	interfacekey[INTERFACEKEY_STRING_J_CAP].tokenname="STRING_J_CAP";
	interfacekey[INTERFACEKEY_STRING_K_CAP].tokenname="STRING_K_CAP";
	interfacekey[INTERFACEKEY_STRING_L_CAP].tokenname="STRING_L_CAP";
	interfacekey[INTERFACEKEY_STRING_M_CAP].tokenname="STRING_M_CAP";
	interfacekey[INTERFACEKEY_STRING_N_CAP].tokenname="STRING_N_CAP";
	interfacekey[INTERFACEKEY_STRING_O_CAP].tokenname="STRING_O_CAP";
	interfacekey[INTERFACEKEY_STRING_P_CAP].tokenname="STRING_P_CAP";
	interfacekey[INTERFACEKEY_STRING_Q_CAP].tokenname="STRING_Q_CAP";
	interfacekey[INTERFACEKEY_STRING_R_CAP].tokenname="STRING_R_CAP";
	interfacekey[INTERFACEKEY_STRING_S_CAP].tokenname="STRING_S_CAP";
	interfacekey[INTERFACEKEY_STRING_T_CAP].tokenname="STRING_T_CAP";
	interfacekey[INTERFACEKEY_STRING_U_CAP].tokenname="STRING_U_CAP";
	interfacekey[INTERFACEKEY_STRING_V_CAP].tokenname="STRING_V_CAP";
	interfacekey[INTERFACEKEY_STRING_W_CAP].tokenname="STRING_W_CAP";
	interfacekey[INTERFACEKEY_STRING_X_CAP].tokenname="STRING_X_CAP";
	interfacekey[INTERFACEKEY_STRING_Y_CAP].tokenname="STRING_Y_CAP";
	interfacekey[INTERFACEKEY_STRING_Z_CAP].tokenname="STRING_Z_CAP";
	interfacekey[INTERFACEKEY_STRING_SPACE].tokenname="STRING_SPACE";
	interfacekey[INTERFACEKEY_STRING_BACKSPACE].tokenname="STRING_BACKSPACE";
}

interfacest::~interfacest()
{
	//GO AHEAD
	while(view.child!=NULL)
		{
		removescreen(view.child);
		}
}

char interfacest::keypress(short key)
{
	if(key<0||key>=INTERFACEKEYNUM)return 0;

	if(c>='A'&&c<='Z'&&caps)
		{
		if(interfacekey[key].binding==c&&interfacekey[key].shift==1-shift)return 1;
		}
	else if(interfacekey[key].binding==c&&interfacekey[key].shift==shift)return 1;

	return 0;
}

void getstring_interfacechar(string &str,interfacekeyst &key)
{
	if(!gview.valid_held_key(key.binding))
		{
		str="Not Supported";
		return;
		}

	if(!gview.display_string[key.binding][key.shift].empty())
		{
		str=gview.display_string[key.binding][key.shift];
		return;
		}

	str.erase();

	if(key.shift)str+="Shift + ";
	switch(key.binding)
		{
		case VK_BACK:str+="Backspace";break;
		case VK_TAB:str+="Tab";break;
		case VK_CLEAR:str+="Clear";break;
		case VK_RETURN:str+="Enter";break;
		case VK_SHIFT:str+="Shift";break;
		case VK_CONTROL:str+="Ctrl";break;
		case VK_MENU:str+="Alt";break;
		case VK_PAUSE:str+="Pause";break;
		case VK_CAPITAL:str+="Caps";break;
		case VK_ESCAPE:str+="Escape";break;
		case VK_SPACE:str+="Space";break;
		case VK_PRIOR:str+="Page Up";break;
		case VK_NEXT:str+="Page Down";break;
		case VK_END:str+="End";break;
		case VK_HOME:str+="Home";break;
		case VK_LEFT:str+="Left";break;
		case VK_UP:str+="Up";break;
		case VK_RIGHT:str+="Right";break;
		case VK_DOWN:str+="Down";break;
		case VK_SELECT:str+="Select";break;
		case VK_PRINT:str+="Print";break;
		case VK_EXECUTE:str+="Execute";break;
		case VK_SNAPSHOT:str+="Print Screen";break;
		case VK_INSERT:str+="Insert";break;
		case VK_DELETE:str+="Delete";break;
		case VK_HELP:str+="Help";break;
		case 0x30://0
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39://9
			str+=key.binding;
			break;
		case 0x41://A
		case 0x42:
		case 0x43:
		case 0x44:
		case 0x45:
		case 0x46://F
		case 0x47:
		case 0x48:
		case 0x49:
		case 0x4A:
		case 0x4B://K
		case 0x4C:
		case 0x4D:
		case 0x4E:
		case 0x4F:
		case 0x50://P
		case 0x51:
		case 0x52:
		case 0x53:
		case 0x54:
		case 0x55://U
		case 0x56:
		case 0x57:
		case 0x58:
		case 0x59:
		case 0x5A://Z
			str+=(key.binding-'A')+'a';
			break;
		case VK_NUMPAD0:str+="Numpad 0";break;
		case VK_NUMPAD1:str+="Numpad 1";break;
		case VK_NUMPAD2:str+="Numpad 2";break;
		case VK_NUMPAD3:str+="Numpad 3";break;
		case VK_NUMPAD4:str+="Numpad 4";break;
		case VK_NUMPAD5:str+="Numpad 5";break;
		case VK_NUMPAD6:str+="Numpad 6";break;
		case VK_NUMPAD7:str+="Numpad 7";break;
		case VK_NUMPAD8:str+="Numpad 8";break;
		case VK_NUMPAD9:str+="Numpad 9";break;
		case VK_SEPARATOR:str+="Separator";break;
		case VK_SUBTRACT:str+="Subtract";break;
		case VK_ADD:str+="Add";break;
		case VK_MULTIPLY:str+="Multiply";break;
		case VK_DECIMAL:str+="Decimal";break;
		case VK_DIVIDE:str+="Divide";break;
		case VK_F1:str+="F1";break;
		case VK_F2:str+="F2";break;
		case VK_F3:str+="F3";break;
		case VK_F4:str+="F4";break;
		case VK_F5:str+="F5";break;
		case VK_F6:str+="F6";break;
		case VK_F7:str+="F7";break;
		case VK_F8:str+="F8";break;
		case VK_F9:str+="F9";break;
		case VK_F10:str+="F10";break;
		case VK_F11:str+="F11";break;
		case VK_F12:str+="F12";break;
		case VK_F13:str+="F13";break;
		case VK_F14:str+="F14";break;
		case VK_F15:str+="F15";break;
		case VK_F16:str+="F16";break;
		case VK_F17:str+="F17";break;
		case VK_F18:str+="F18";break;
		case VK_F19:str+="F19";break;
		case VK_F20:str+="F20";break;
		case VK_F21:str+="F21";break;
		case VK_F22:str+="F22";break;
		case VK_F23:str+="F23";break;
		case VK_F24:str+="F24";break;
		case VK_NUMLOCK:str+="Numlock";break;
		case VK_SCROLL:str+="Scroll";break;
		case VK_LSHIFT:str+="L Shift";break;
		case VK_RSHIFT:str+="R Shift";break;
		case VK_LCONTROL:str+="L Control";break;
		case VK_RCONTROL:str+="R Control";break;
		case VK_LMENU:str+="L Menu";break;
		case VK_RMENU:str+="R Menu";break;
		case 0xBA:str+="Key BA";break;
		case 0xBB:str+="Plus";break;
		case 0xBC:str+="Comma";break;
		case 0xBD:str+="Minus";break;
		case 0xBE:str+="Period";break;
		case 0xBF:str+="Key BF";break;
		case 0xC0:str+="Key C0";break;
		case 0xDB:str+="Key DB";break;
		case 0xDC:str+="Key DC";break;
		case 0xDD:str+="Key DD";break;
		case 0xDE:str+="Key DE";break;
		case 0xDF:str+="Key DF";break;
		case 0xE1:str+="Key E1";break;
		case 0xE2:str+="Key E2";break;
		case 0xE3:str+="Key E3";break;
		case 0xE4:str+="Key E4";break;
		case 0xE9:str+="Key E9";break;
		case 0xEA:str+="Key EA";break;
		case 0xEB:str+="Key EB";break;
		case 0xEC:str+="Key EC";break;
		case 0xED:str+="Key ED";break;
		case 0xEE:str+="Key EE";break;
		case 0xEF:str+="Key EF";break;
		case 0xF1:str+="Key F1";break;
		case 0xF2:str+="Key F2";break;
		case 0xF3:str+="Key F3";break;
		case 0xF4:str+="Key F4";break;
		case 0xF5:str+="Key F5";break;
		case 0x15:str+="Key Hangul/Kana";break;
		case 0x17:str+="Key Junja";break;
		case 0x18:str+="Key Final";break;
		case 0x19:str+="Key Hanja/Kanji";break;
		case 0x1C:str+="Key Convert";break;
		case 0x1D:str+="Key Nonconvert";break;
		case 0x1E:str+="Key Accept";break;
		case 0x1F:str+="Key Mode Change";break;
		case 0x92:str+="Key 92";break;
		case 0x93:str+="Key 93";break;
		case 0x94:str+="Key 94";break;
		case 0x95:str+="Key 95";break;
		case 0x96:str+="Key 96";break;
		default:str="Not Supported";break;
		}
}

void getstring_interfacechar_save(string &str,interfacekeyst &key)
{
	if(!gview.valid_held_key(key.binding))
		{
		str="NOT_SUPPORTED";
		return;
		}

	str.erase();

	if(key.shift)str+="SHIFT+";
	switch(key.binding)
		{
		case VK_BACK:str+="BACKSPACE";break;
		case VK_TAB:str+="TAB";break;
		case VK_CLEAR:str+="CLEAR";break;
		case VK_RETURN:str+="ENTER";break;
		case VK_SHIFT:str+="SHIFT";break;
		case VK_CONTROL:str+="CTRL";break;
		case VK_MENU:str+="ALT";break;
		case VK_PAUSE:str+="PAUSE";break;
		case VK_CAPITAL:str+="CAPS";break;
		case VK_ESCAPE:str+="ESCAPE";break;
		case VK_SPACE:str+="SPACE";break;
		case VK_PRIOR:str+="PAGEUP";break;
		case VK_NEXT:str+="PAGEDOWN";break;
		case VK_END:str+="END";break;
		case VK_HOME:str+="HOME";break;
		case VK_LEFT:str+="LEFT";break;
		case VK_UP:str+="UP";break;
		case VK_RIGHT:str+="RIGHT";break;
		case VK_DOWN:str+="DOWN";break;
		case VK_SELECT:str+="SELECT";break;
		case VK_PRINT:str+="PRINT";break;
		case VK_EXECUTE:str+="EXECUTE";break;
		case VK_SNAPSHOT:str+="PRINTSCREEN";break;
		case VK_INSERT:str+="INSERT";break;
		case VK_DELETE:str+="DELETE";break;
		case VK_HELP:str+="HELP";break;
		case 0x30://0
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39://9
		case 0x41://A
		case 0x42:
		case 0x43:
		case 0x44:
		case 0x45:
		case 0x46://F
		case 0x47:
		case 0x48:
		case 0x49:
		case 0x4A:
		case 0x4B://K
		case 0x4C:
		case 0x4D:
		case 0x4E:
		case 0x4F:
		case 0x50://P
		case 0x51:
		case 0x52:
		case 0x53:
		case 0x54:
		case 0x55://U
		case 0x56:
		case 0x57:
		case 0x58:
		case 0x59:
		case 0x5A://Z
			str+=key.binding;
			break;
		case VK_NUMPAD0:str+="NUMPAD0";break;
		case VK_NUMPAD1:str+="NUMPAD1";break;
		case VK_NUMPAD2:str+="NUMPAD2";break;
		case VK_NUMPAD3:str+="NUMPAD3";break;
		case VK_NUMPAD4:str+="NUMPAD4";break;
		case VK_NUMPAD5:str+="NUMPAD5";break;
		case VK_NUMPAD6:str+="NUMPAD6";break;
		case VK_NUMPAD7:str+="NUMPAD7";break;
		case VK_NUMPAD8:str+="NUMPAD8";break;
		case VK_NUMPAD9:str+="NUMPAD9";break;
		case VK_SEPARATOR:str+="SEPARATOR";break;
		case VK_SUBTRACT:str+="SUBTRACT";break;
		case VK_ADD:str+="ADD";break;
		case VK_MULTIPLY:str+="MULTIPLY";break;
		case VK_DECIMAL:str+="DECIMAL";break;
		case VK_DIVIDE:str+="DIVIDE";break;
		case VK_F1:str+="F1";break;
		case VK_F2:str+="F2";break;
		case VK_F3:str+="F3";break;
		case VK_F4:str+="F4";break;
		case VK_F5:str+="F5";break;
		case VK_F6:str+="F6";break;
		case VK_F7:str+="F7";break;
		case VK_F8:str+="F8";break;
		case VK_F9:str+="F9";break;
		case VK_F10:str+="F10";break;
		case VK_F11:str+="F11";break;
		case VK_F12:str+="F12";break;
		case VK_F13:str+="F13";break;
		case VK_F14:str+="F14";break;
		case VK_F15:str+="F15";break;
		case VK_F16:str+="F16";break;
		case VK_F17:str+="F17";break;
		case VK_F18:str+="F18";break;
		case VK_F19:str+="F19";break;
		case VK_F20:str+="F20";break;
		case VK_F21:str+="F21";break;
		case VK_F22:str+="F22";break;
		case VK_F23:str+="F23";break;
		case VK_F24:str+="F24";break;
		case VK_NUMLOCK:str+="NUMLOCK";break;
		case VK_SCROLL:str+="SCROLL";break;
		case VK_LSHIFT:str+="LSHIFT";break;
		case VK_RSHIFT:str+="RSHIFT";break;
		case VK_LCONTROL:str+="LCTRL";break;
		case VK_RCONTROL:str+="RCTRL";break;
		case VK_LMENU:str+="LMENU";break;
		case VK_RMENU:str+="RMENU";break;
		case 0xBA:str+="KEYBA";break;
		case 0xBB:str+="PLUS";break;
		case 0xBC:str+="COMMA";break;
		case 0xBD:str+="MINUS";break;
		case 0xBE:str+="PERIOD";break;
		case 0xBF:str+="KEYBF";break;
		case 0xC0:str+="KEYC0";break;
		case 0xDB:str+="KEYDB";break;
		case 0xDC:str+="KEYDC";break;
		case 0xDD:str+="KEYDD";break;
		case 0xDE:str+="KEYDE";break;
		case 0xDF:str+="KEYDF";break;
		case 0xE1:str+="KEYE1";break;
		case 0xE2:str+="KEYE2";break;
		case 0xE3:str+="KEYE3";break;
		case 0xE4:str+="KEYE4";break;
		case 0xE9:str+="KEYE9";break;
		case 0xEA:str+="KEYEA";break;
		case 0xEB:str+="KEYEB";break;
		case 0xEC:str+="KEYEC";break;
		case 0xED:str+="KEYED";break;
		case 0xEE:str+="KEYEE";break;
		case 0xEF:str+="KEYEF";break;
		case 0xF1:str+="KEYF1";break;
		case 0xF2:str+="KEYF2";break;
		case 0xF3:str+="KEYF3";break;
		case 0xF4:str+="KEYF4";break;
		case 0xF5:str+="KEYF5";break;
		case 0x15:str+="KEYHANGULKANA";break;
		case 0x17:str+="KEYJUNJA";break;
		case 0x18:str+="KEYFINAL";break;
		case 0x19:str+="KEYHANJAKANJI";break;
		case 0x1C:str+="KEYCONVERT";break;
		case 0x1D:str+="KEYNONCONVERT";break;
		case 0x1E:str+="KEYACCEPT";break;
		case 0x1F:str+="KEYMODECHANGE";break;
		case 0x92:str+="KEY92";break;
		case 0x93:str+="KEY93";break;
		case 0x94:str+="KEY94";break;
		case 0x95:str+="KEY95";break;
		case 0x96:str+="KEY96";break;
		default:str="NONE";break;
		}
}

void convertstring_interfacechar_save(string &str,interfacekeyst &key)
{
	if(str.length()==0)return;

	key.binding=27;
	key.shift=0;

	string::size_type wpos;
	string sr;

	sr="SHIFT+";
	while ((wpos = str.find(sr)) != string::npos)
		{
		string str2="";
		str.replace(wpos,sr.size(),str2);
		key.shift=1;
		}

	if(!str.compare("BACKSPACE")){key.binding=VK_BACK;return;}
	if(!str.compare("TAB")){key.binding=VK_TAB;return;}
	if(!str.compare("CLEAR")){key.binding=VK_CLEAR;return;}
	if(!str.compare("ENTER")){key.binding=VK_RETURN;return;}
	if(!str.compare("SHIFT")){key.binding=VK_SHIFT;return;}
	if(!str.compare("CTRL")){key.binding=VK_CONTROL;return;}
	if(!str.compare("ALT")){key.binding=VK_MENU;return;}
	if(!str.compare("PAUSE")){key.binding=VK_PAUSE;return;}
	if(!str.compare("CAPS")){key.binding=VK_CAPITAL;return;}
	if(!str.compare("ESCAPE")){key.binding=VK_ESCAPE;return;}
	if(!str.compare("SPACE")){key.binding=VK_SPACE;return;}
	if(!str.compare("PAGEUP")){key.binding=VK_PRIOR;return;}
	if(!str.compare("PAGEDOWN")){key.binding=VK_NEXT;return;}
	if(!str.compare("END")){key.binding=VK_END;return;}
	if(!str.compare("HOME")){key.binding=VK_HOME;return;}
	if(!str.compare("LEFT")){key.binding=VK_LEFT;return;}
	if(!str.compare("UP")){key.binding=VK_UP;return;}
	if(!str.compare("RIGHT")){key.binding=VK_RIGHT;return;}
	if(!str.compare("DOWN")){key.binding=VK_DOWN;return;}
	if(!str.compare("SELECT")){key.binding=VK_SELECT;return;}
	if(!str.compare("PRINT")){key.binding=VK_PRINT;return;}
	if(!str.compare("EXECUTE")){key.binding=VK_EXECUTE;return;}
	if(!str.compare("PRINTSCREEN")){key.binding=VK_SNAPSHOT;return;}
	if(!str.compare("INSERT")){key.binding=VK_INSERT;return;}
	if(!str.compare("DELETE")){key.binding=VK_DELETE;return;}
	if(!str.compare("HELP")){key.binding=VK_HELP;return;}
	if(!str.compare("NUMPAD0")){key.binding=VK_NUMPAD0;return;}
	if(!str.compare("NUMPAD1")){key.binding=VK_NUMPAD1;return;}
	if(!str.compare("NUMPAD2")){key.binding=VK_NUMPAD2;return;}
	if(!str.compare("NUMPAD3")){key.binding=VK_NUMPAD3;return;}
	if(!str.compare("NUMPAD4")){key.binding=VK_NUMPAD4;return;}
	if(!str.compare("NUMPAD5")){key.binding=VK_NUMPAD5;return;}
	if(!str.compare("NUMPAD6")){key.binding=VK_NUMPAD6;return;}
	if(!str.compare("NUMPAD7")){key.binding=VK_NUMPAD7;return;}
	if(!str.compare("NUMPAD8")){key.binding=VK_NUMPAD8;return;}
	if(!str.compare("NUMPAD9")){key.binding=VK_NUMPAD9;return;}
	if(!str.compare("SEPARATOR")){key.binding=VK_SEPARATOR;return;}
	if(!str.compare("SUBTRACT")){key.binding=VK_SUBTRACT;return;}
	if(!str.compare("ADD")){key.binding=VK_ADD;return;}
	if(!str.compare("MULTIPLY")){key.binding=VK_MULTIPLY;return;}
	if(!str.compare("DECIMAL")){key.binding=VK_DECIMAL;return;}
	if(!str.compare("DIVIDE")){key.binding=VK_DIVIDE;return;}
	if(!str.compare("F1")){key.binding=VK_F1;return;}
	if(!str.compare("F2")){key.binding=VK_F2;return;}
	if(!str.compare("F3")){key.binding=VK_F3;return;}
	if(!str.compare("F4")){key.binding=VK_F4;return;}
	if(!str.compare("F5")){key.binding=VK_F5;return;}
	if(!str.compare("F6")){key.binding=VK_F6;return;}
	if(!str.compare("F7")){key.binding=VK_F7;return;}
	if(!str.compare("F8")){key.binding=VK_F8;return;}
	if(!str.compare("F9")){key.binding=VK_F9;return;}
	if(!str.compare("F10")){key.binding=VK_F10;return;}
	if(!str.compare("F11")){key.binding=VK_F11;return;}
	if(!str.compare("F12")){key.binding=VK_F12;return;}
	if(!str.compare("F13")){key.binding=VK_F13;return;}
	if(!str.compare("F14")){key.binding=VK_F14;return;}
	if(!str.compare("F15")){key.binding=VK_F15;return;}
	if(!str.compare("F16")){key.binding=VK_F16;return;}
	if(!str.compare("F17")){key.binding=VK_F17;return;}
	if(!str.compare("F18")){key.binding=VK_F18;return;}
	if(!str.compare("F19")){key.binding=VK_F19;return;}
	if(!str.compare("F20")){key.binding=VK_F20;return;}
	if(!str.compare("F21")){key.binding=VK_F21;return;}
	if(!str.compare("F22")){key.binding=VK_F22;return;}
	if(!str.compare("F23")){key.binding=VK_F23;return;}
	if(!str.compare("F24")){key.binding=VK_F24;return;}
	if(!str.compare("NUMLOCK")){key.binding=VK_NUMLOCK;return;}
	if(!str.compare("SCROLL")){key.binding=VK_SCROLL;return;}
	if(!str.compare("LSHIFT")){key.binding=VK_LSHIFT;return;}
	if(!str.compare("RSHIFT")){key.binding=VK_RSHIFT;return;}
	if(!str.compare("LCTRL")){key.binding=VK_LCONTROL;return;}
	if(!str.compare("RCTRL")){key.binding=VK_RCONTROL;return;}
	if(!str.compare("LMENU")){key.binding=VK_LMENU;return;}
	if(!str.compare("RMENU")){key.binding=VK_RMENU;return;}
	if(!str.compare("KEYBA")){key.binding=0xBA;return;}
	if(!str.compare("PLUS")){key.binding=0xBB;return;}
	if(!str.compare("COMMA")){key.binding=0xBC;return;}
	if(!str.compare("MINUS")){key.binding=0xBD;return;}
	if(!str.compare("PERIOD")){key.binding=0xBE;return;}
	if(!str.compare("KEYBF")){key.binding=0xBF;return;}
	if(!str.compare("KEYC0")){key.binding=0xC0;return;}
	if(!str.compare("KEYDB")){key.binding=0xDB;return;}
	if(!str.compare("KEYDC")){key.binding=0xDC;return;}
	if(!str.compare("KEYDD")){key.binding=0xDD;return;}
	if(!str.compare("KEYDE")){key.binding=0xDE;return;}
	if(!str.compare("KEYDF")){key.binding=0xDF;return;}
	if(!str.compare("KEYE1")){key.binding=0xE1;return;}
	if(!str.compare("KEYE2")){key.binding=0xE2;return;}
	if(!str.compare("KEYE3")){key.binding=0xE3;return;}
	if(!str.compare("KEYE4")){key.binding=0xE4;return;}
	if(!str.compare("KEYE9")){key.binding=0xE9;return;}
	if(!str.compare("KEYEA")){key.binding=0xEA;return;}
	if(!str.compare("KEYEB")){key.binding=0xEB;return;}
	if(!str.compare("KEYEC")){key.binding=0xEC;return;}
	if(!str.compare("KEYED")){key.binding=0xED;return;}
	if(!str.compare("KEYEE")){key.binding=0xEE;return;}
	if(!str.compare("KEYEF")){key.binding=0xEF;return;}
	if(!str.compare("KEYF1")){key.binding=0xF1;return;}
	if(!str.compare("KEYF2")){key.binding=0xF2;return;}
	if(!str.compare("KEYF3")){key.binding=0xF3;return;}
	if(!str.compare("KEYF4")){key.binding=0xF4;return;}
	if(!str.compare("KEYF5")){key.binding=0xF5;return;}
	if(!str.compare("KEYHANGULKANA")){key.binding=0x15;return;}
	if(!str.compare("KEYJUNJA")){key.binding=0x17;return;}
	if(!str.compare("KEYFINAL")){key.binding=0x18;return;}
	if(!str.compare("KEYHANJAKANJI")){key.binding=0x19;return;}
	if(!str.compare("KEYCONVERT")){key.binding=0x1C;return;}
	if(!str.compare("KEYNONCONVERT")){key.binding=0x1D;return;}
	if(!str.compare("KEYACCEPT")){key.binding=0x1E;return;}
	if(!str.compare("KEYMODECHANGE")){key.binding=0x1F;return;}
	if(!str.compare("KEY92")){key.binding=0x92;return;}
	if(!str.compare("KEY93")){key.binding=0x93;return;}
	if(!str.compare("KEY94")){key.binding=0x94;return;}
	if(!str.compare("KEY95")){key.binding=0x95;return;}
	if(!str.compare("KEY96")){key.binding=0x96;return;}

	if(str.compare("NONE")&&str.compare("NOT_SUPPORTED"))
		{
		if(str[0]>='0'&&str[0]<='9')key.binding=str[0];
		if(str[0]>='A'&&str[0]<='Z')key.binding=str[0];
		return;
		}
}

viewscreen_optionst *viewscreen_optionst::create(char pushtype,viewscreenst *scr)
{
	viewscreen_optionst *newv=new viewscreen_optionst();
	gview.addscreen(newv,pushtype,scr);

	return newv;
}

viewscreen_optionst::viewscreen_optionst()
{
	selected=0;
}

void viewscreen_optionst::view(void)
{
	enabler.flag&=~ENABLERFLAG_MAXFPS;

#ifndef NO_FMOD
	musicsound.stopbackgroundmusic();
#endif

	gps.drawborder("  Options  ");

	int i;
	for(i=0;i<MAINMENU_OPTIONNUM;i++)
		{
		if(i==selected)gps.changecolor(7,0,1);
		else gps.changecolor(7,0,0);

		gps.locate(i+2,30);

		switch(i)
			{
			case MAINMENU_OPTION_RETURN:
				gps.addst("Return to Game");
				break;
			case MAINMENU_OPTION_KEYBINDINGS:
				gps.addst("Key Bindings");
				break;
			case MAINMENU_OPTION_SAVE:
				gps.addst("Save/Quit");
				break;
			}
		}

	gps.renewscreen();

	if(gview.keypress(INTERFACEKEY_SELECT))
		{
		switch(selected)
			{
			case MAINMENU_OPTION_RETURN:
				breakdownlevel=INTERFACE_BREAKDOWN_STOPSCREEN;
				break;
			case MAINMENU_OPTION_KEYBINDINGS:
				viewscreen_keybindingsst::create(INTERFACE_PUSH_AT_BACK);
				break;
			case MAINMENU_OPTION_SAVE:
				game.end_game();
				breakdownlevel=INTERFACE_BREAKDOWN_TOFIRST;
				gview.c=0;
				break;
			}

		return;
		}

	gview.standardscrolling(selected,0,MAINMENU_OPTIONNUM-1,21);

	if(gview.keypress(INTERFACEKEY_LEAVESCREEN))
		{
		breakdownlevel=INTERFACE_BREAKDOWN_STOPSCREEN;
		return;
		}
}

viewscreen_keybindingsst *viewscreen_keybindingsst::create(char pushtype,viewscreenst *scr)
{
	viewscreen_keybindingsst *newv=new viewscreen_keybindingsst();
	gview.addscreen(newv,pushtype,scr);

	return newv;
}

viewscreen_keybindingsst::viewscreen_keybindingsst()
{
	selected=0;
	binding=0;

	allowed_key.push_back(INTERFACEKEY_SELECT);
	allowed_key.push_back(INTERFACEKEY_LEAVESCREEN);
	allowed_key.push_back(INTERFACEKEY_OPTIONS);
	allowed_key.push_back(INTERFACEKEY_SELECT_KOBOLD_UP);
	allowed_key.push_back(INTERFACEKEY_SELECT_KOBOLD_DOWN);
	allowed_key.push_back(INTERFACEKEY_COVER_TRAP);
	allowed_key.push_back(INTERFACEKEY_PICK_UP_CRITTER);
	allowed_key.push_back(INTERFACEKEY_DROP_CRITTER);
	allowed_key.push_back(INTERFACEKEY_DESCRIBE_HELD_CRITTER);
	allowed_key.push_back(INTERFACEKEY_THROW_CRITTER);
	allowed_key.push_back(INTERFACEKEY_WAIT);
	allowed_key.push_back(INTERFACEKEY_WAIT_FOR_ADVENTURER);//1.02
	allowed_key.push_back(INTERFACEKEY_TOGGLE_FULLSCREEN);
	allowed_key.push_back(INTERFACEKEY_SAVE_BINDINGS);
	allowed_key.push_back(INTERFACEKEY_CHANGE_BINDINGS);
	allowed_key.push_back(INTERFACEKEY_STANDARDSCROLL_UP);
	allowed_key.push_back(INTERFACEKEY_STANDARDSCROLL_DOWN);
	allowed_key.push_back(INTERFACEKEY_STANDARDSCROLL_LEFT);
	allowed_key.push_back(INTERFACEKEY_STANDARDSCROLL_RIGHT);
	allowed_key.push_back(INTERFACEKEY_STANDARDSCROLL_PAGEUP);
	allowed_key.push_back(INTERFACEKEY_STANDARDSCROLL_PAGEDOWN);
	allowed_key.push_back(INTERFACEKEY_CURSOR_UP);
	allowed_key.push_back(INTERFACEKEY_CURSOR_DOWN);
	allowed_key.push_back(INTERFACEKEY_CURSOR_LEFT);
	allowed_key.push_back(INTERFACEKEY_CURSOR_RIGHT);
	allowed_key.push_back(INTERFACEKEY_CURSOR_UPLEFT);
	allowed_key.push_back(INTERFACEKEY_CURSOR_UPRIGHT);
	allowed_key.push_back(INTERFACEKEY_CURSOR_DOWNLEFT);
	allowed_key.push_back(INTERFACEKEY_CURSOR_DOWNRIGHT);
	allowed_key.push_back(INTERFACEKEY_STRING_A);
	allowed_key.push_back(INTERFACEKEY_STRING_B);
	allowed_key.push_back(INTERFACEKEY_STRING_C);
	allowed_key.push_back(INTERFACEKEY_STRING_D);
	allowed_key.push_back(INTERFACEKEY_STRING_E);
	allowed_key.push_back(INTERFACEKEY_STRING_F);
	allowed_key.push_back(INTERFACEKEY_STRING_G);
	allowed_key.push_back(INTERFACEKEY_STRING_H);
	allowed_key.push_back(INTERFACEKEY_STRING_I);
	allowed_key.push_back(INTERFACEKEY_STRING_J);
	allowed_key.push_back(INTERFACEKEY_STRING_K);
	allowed_key.push_back(INTERFACEKEY_STRING_L);
	allowed_key.push_back(INTERFACEKEY_STRING_M);
	allowed_key.push_back(INTERFACEKEY_STRING_N);
	allowed_key.push_back(INTERFACEKEY_STRING_O);
	allowed_key.push_back(INTERFACEKEY_STRING_P);
	allowed_key.push_back(INTERFACEKEY_STRING_Q);
	allowed_key.push_back(INTERFACEKEY_STRING_R);
	allowed_key.push_back(INTERFACEKEY_STRING_S);
	allowed_key.push_back(INTERFACEKEY_STRING_T);
	allowed_key.push_back(INTERFACEKEY_STRING_U);
	allowed_key.push_back(INTERFACEKEY_STRING_V);
	allowed_key.push_back(INTERFACEKEY_STRING_W);
	allowed_key.push_back(INTERFACEKEY_STRING_X);
	allowed_key.push_back(INTERFACEKEY_STRING_Y);
	allowed_key.push_back(INTERFACEKEY_STRING_Z);
	allowed_key.push_back(INTERFACEKEY_STRING_A_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_B_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_C_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_D_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_E_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_F_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_G_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_H_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_I_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_J_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_K_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_L_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_M_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_N_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_O_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_P_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_Q_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_R_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_S_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_T_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_U_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_V_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_W_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_X_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_Y_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_Z_CAP);
	allowed_key.push_back(INTERFACEKEY_STRING_SPACE);
	allowed_key.push_back(INTERFACEKEY_STRING_BACKSPACE);
}

void merge_binding(unsigned char &c)
{
	switch(c)
		{
		case VK_UP:c='8';break;
		case VK_DOWN:c='2';break;
		case VK_LEFT:c='4';break;
		case VK_RIGHT:c='6';break;
		case VK_CLEAR:c='5';break;
		case VK_PRIOR:c='9';break;
		case VK_NEXT:c='3';break;
		case VK_END:c='1';break;
		case VK_HOME:c='7';break;
		case VK_NUMPAD0:c='0';break;
		case VK_NUMPAD1:c='1';break;
		case VK_NUMPAD2:c='2';break;
		case VK_NUMPAD3:c='3';break;
		case VK_NUMPAD4:c='4';break;
		case VK_NUMPAD5:c='5';break;
		case VK_NUMPAD6:c='6';break;
		case VK_NUMPAD7:c='7';break;
		case VK_NUMPAD8:c='8';break;
		case VK_NUMPAD9:c='9';break;
		}
}

void viewscreen_keybindingsst::view()
{
	enabler.flag&=~ENABLERFLAG_MAXFPS;

#ifndef NO_FMOD
	musicsound.stopbackgroundmusic();
#endif

	gps.drawborder("  Options: Key Bindings  ");

	string ikey;
	int scroll=(selected/21)*21;
	int i;
	for(i=scroll;i<allowed_key.size()&&i<scroll+21;i++)
		{
		if(i==selected&&binding)gps.changecolor(3,0,1);
		else if(i==selected)gps.changecolor(7,0,1);
		else gps.changecolor(7,0,0);

		gps.locate(i-scroll+2,2);
		gps.addst(gview.interfacekey[allowed_key[i]].name);

		gps.locate(i-scroll+2,40);
		getstring_interfacechar(ikey,gview.interfacekey[allowed_key[i]]);
		gps.addst(ikey);
		}

	gps.changecolor(7,0,1);
	gps.locate(2,55);
	gview.print_interface_token(INTERFACEKEY_SAVE_BINDINGS);
	gps.addst(" - Export to txt");

	gps.changecolor(7,0,1);
	gps.locate(4,55);
	gps.addst("Press ");
	gview.print_interface_token(INTERFACEKEY_CHANGE_BINDINGS);
	gps.addst(" and a key");
	gps.locate(5,55);
	gps.addst("to change a key binding.");

	gps.renewscreen();

	if(binding&&gview.c!=0)
		{
		gview.interfacekey[allowed_key[selected]].binding=gview.c;
		if(gview.c>='A'&&gview.c<='Z'&&gview.caps)gview.interfacekey[allowed_key[selected]].shift=1-gview.shift;
		else gview.interfacekey[allowed_key[selected]].shift=gview.shift;
		binding=0;
		gview.c=0;
		}
	else
		{
		if(gview.keypress(INTERFACEKEY_CHANGE_BINDINGS))
			{
			//START THE BINDING PROCESS
			binding=1;
			}

		gview.standardscrolling(selected,0,allowed_key.size()-1,21);

		if(gview.keypress(INTERFACEKEY_SAVE_BINDINGS))
			{
			//SAVE THE INTERFACE
			std::ofstream fseed("data/init/interface.txt");
			if(fseed.is_open())
				{
				string str;

				interfacekeyst key;
				long i;
				for(i=1;i<256;i++)
					{
					if(!gview.display_string[i][0].empty())
						{
						key.binding=i;
						key.shift=0;

						getstring_interfacechar_save(str,key);

						if(str!="NOT_SUPPORTED")
							{
							fseed<<"[DISPLAY_STRING:"<<str.c_str()<<':'<<gview.display_string[i][0].c_str()<<']'<<std::endl;
							}
						}
					if(!gview.display_string[i][1].empty())
						{
						key.binding=i;
						key.shift=1;

						getstring_interfacechar_save(str,key);

						if(str!="NOT_SUPPORTED")
							{
							fseed<<"[DISPLAY_STRING:"<<str.c_str()<<':'<<gview.display_string[i][1].c_str()<<']'<<std::endl;
							}
						}
					}

				fseed<<std::endl;

				for(i=0;i<INTERFACEKEYNUM;i++)
					{
					getstring_interfacechar_save(str,gview.interfacekey[i]);
					fseed<<'['<<gview.interfacekey[i].tokenname.data()<<':'<<str.c_str()<<']'<<std::endl;
					}
				}
			fseed.close();
			gview.c=0;
			}

		if(gview.keypress(INTERFACEKEY_LEAVESCREEN))
			{
			breakdownlevel=INTERFACE_BREAKDOWN_STOPSCREEN;
			return;
			}
		}
}

void interfacest::addscreen(viewscreenst *scr,char pushtype,viewscreenst *relate)
{
	switch(pushtype)
		{
		case INTERFACE_PUSH_AS_PARENT:insertscreen_as_parent(scr,relate);break;
		case INTERFACE_PUSH_AS_CHILD:insertscreen_as_child(scr,relate);break;
		case INTERFACE_PUSH_AT_FRONT:insertscreen_at_front(scr);break;
		default:insertscreen_at_back(scr);break;
		}
}

void interfacest::insertscreen_as_parent(viewscreenst *scr,viewscreenst *child)
{
	if(child==NULL)
		{
		insertscreen_at_back(scr);
		return;
		}

	scr->child=child;
	scr->parent=child->parent;

	if(scr->parent!=NULL)scr->parent->child=scr;
	child->parent=scr;
}

void interfacest::insertscreen_as_child(viewscreenst *scr,viewscreenst *parent)
{
	if(parent==NULL)
		{
		insertscreen_at_back(scr);
		return;
		}

	scr->child=parent->child;
	scr->parent=parent;

	if(scr->child!=NULL)scr->child->parent=scr;
	parent->child=scr;
}

void interfacest::insertscreen_at_back(viewscreenst *scr)
{
	//GRAB CURRENT SCREEN AT THE END OF THE LIST
	viewscreenst *currentscreen=&view;
	while(currentscreen->child!=NULL)currentscreen=currentscreen->child;

	//PUT IT ON TO THE BACK SCREEN
	insertscreen_as_child(scr,currentscreen);
}

void interfacest::insertscreen_at_front(viewscreenst *scr)
{
	//PUT IT ON TO THE BASE
	insertscreen_as_child(scr,&view);
}

char interfacest::valid_held_key(unsigned char c)
{
	switch(c)
		{
		case VK_BACK:
		case VK_TAB:
		case VK_CLEAR:
		case VK_RETURN:
		//case VK_SHIFT:
		//case VK_CONTROL:
		//case VK_MENU:
		case VK_PAUSE:
		//case VK_CAPITAL:
		case VK_ESCAPE:
		case VK_SPACE:
		case VK_PRIOR:
		case VK_NEXT:
		case VK_END:
		case VK_HOME:
		case VK_LEFT:
		case VK_UP:
		case VK_RIGHT:
		case VK_DOWN:
		case VK_SELECT:
		case VK_PRINT:
		case VK_EXECUTE:
		case VK_SNAPSHOT:
		case VK_INSERT:
		case VK_DELETE:
		case VK_HELP:
		case 0x30://0
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39://9
		case 0x41://A
		case 0x42:
		case 0x43:
		case 0x44:
		case 0x45:
		case 0x46://F
		case 0x47:
		case 0x48:
		case 0x49:
		case 0x4A:
		case 0x4B://K
		case 0x4C:
		case 0x4D:
		case 0x4E:
		case 0x4F:
		case 0x50://P
		case 0x51:
		case 0x52:
		case 0x53:
		case 0x54:
		case 0x55://U
		case 0x56:
		case 0x57:
		case 0x58:
		case 0x59:
		case 0x5A://Z
		case VK_NUMPAD0:
		case VK_NUMPAD1:
		case VK_NUMPAD2:
		case VK_NUMPAD3:
		case VK_NUMPAD4:
		case VK_NUMPAD5:
		case VK_NUMPAD6:
		case VK_NUMPAD7:
		case VK_NUMPAD8:
		case VK_NUMPAD9:
		case VK_SEPARATOR:
		case VK_SUBTRACT:
		case VK_ADD:
		case VK_MULTIPLY:
		case VK_DECIMAL:
		case VK_DIVIDE:
		case VK_F1:
		case VK_F2:
		case VK_F3:
		case VK_F4:
		case VK_F5:
		case VK_F6:
		case VK_F7:
		case VK_F8:
		case VK_F9:
		case VK_F10:
		case VK_F11:
		case VK_F12:
		case VK_F13:
		case VK_F14:
		case VK_F15:
		case VK_F16:
		case VK_F17:
		case VK_F18:
		case VK_F19:
		case VK_F20:
		case VK_F21:
		case VK_F22:
		case VK_F23:
		case VK_F24:
		case VK_NUMLOCK:
		case VK_SCROLL:
		//case VK_LSHIFT:
		//case VK_RSHIFT:
		//case VK_LCONTROL:
		//case VK_RCONTROL:
		//case VK_LMENU:
		//case VK_RMENU:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF:
		case 0xC0:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4:
		case 0xF5:
		case 0x15:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
			return 1;
		}

	return 0;
}

char interfacest::loop(void)
{
	//SET THE HELD STATE OF THE INTERFACE KEYS
	char didkey[256];
	memset(didkey,0,sizeof(char)*256);
	long i;
	long i2;
	for(i2=0;i2<INTERFACEKEYNUM;i2++)interfacekey[i2].held=2;
	unsigned char heldc;
#if defined(__APPLE__)
	// GetKeyState returns a short, casting to a char loses upper bits?
	// I don't understand the original code, but it seems as if c_shift
	// and c_caps are acting as bools, so this seems to work here.
	char c_shift=!!(GetKeyState(VK_SHIFT)>>1);
	char c_caps=!!GetKeyState(VK_CAPITAL);
#else	
	char c_shift=GetKeyState(VK_SHIFT)>>1;
	char c_caps=GetKeyState(VK_CAPITAL);
#endif
	for(i=1;i<256;i++)
		{
		if(!valid_held_key(i))continue;
		if(!(enabler.keys.keyDown[i]))continue;
		//DO A STUCK KEY CHECK
		if(!(GetKeyState(i)>>1))
			{
			enabler.keys.keyDown[i]=FALSE;
			continue;
			}

		heldc=i;
		merge_binding(heldc);

		for(i2=0;i2<INTERFACEKEYNUM;i2++)
			{
			switch(i2)
				{
				case INTERFACEKEY_STANDARDSCROLL_UP:
				case INTERFACEKEY_STANDARDSCROLL_DOWN:
				case INTERFACEKEY_STANDARDSCROLL_LEFT:
				case INTERFACEKEY_STANDARDSCROLL_RIGHT:
				case INTERFACEKEY_STANDARDSCROLL_PAGEUP:
				case INTERFACEKEY_STANDARDSCROLL_PAGEDOWN:
				case INTERFACEKEY_CURSOR_UP:
				case INTERFACEKEY_CURSOR_DOWN:
				case INTERFACEKEY_CURSOR_LEFT:
				case INTERFACEKEY_CURSOR_RIGHT:
				case INTERFACEKEY_CURSOR_UPLEFT:
				case INTERFACEKEY_CURSOR_UPRIGHT:
				case INTERFACEKEY_CURSOR_DOWNLEFT:
				case INTERFACEKEY_CURSOR_DOWNRIGHT:
					if(interfacekey[i2].binding==heldc)
						{
						if(!(heldc>='A'&&heldc<='Z')||(!caps&&interfacekey[i2].shift==c_shift)||(caps&&interfacekey[i2].shift==c_shift))
							{
							interfacekey[i2].held=1;
							if(GetTickCount()-interfacekey[i2].last_used_for_held>=init.input.hold_time||
								interfacekey[i2].last_used_for_held>GetTickCount())
								{
								//IF THE KEY HAS BEEN HELD FOR A WHILE,
									//SEND OFF SOME MORE INPUT TO gview
								if(inputbuffer.size()<100&&!didkey[heldc])
									{
									inputbuffer.push_back(heldc);
									if(c_caps)c_caps=1;
									if(c_shift)c_shift=1;
									inputbuffer_caps.push_back(c_caps);
									inputbuffer_shift.push_back(c_shift);
									didkey[heldc]=1;
									}

								//RESET COUNTER
								interfacekey[i2].last_used_for_held=GetTickCount();
								}
							}
						}
					break;
				}
			}
		}
	//THESE ARE NOT FRESHLY HELD
	for(i2=0;i2<INTERFACEKEYNUM;i2++)
		{
		if(interfacekey[i2].held==2)
			{
			interfacekey[i2].held=0;
			interfacekey[i2].last_used_for_held=GetTickCount();
			}
		}

	//GRAB CURRENT SCREEN AT THE END OF THE LIST
	viewscreenst *currentscreen=&view;
	while(currentscreen->child!=NULL)currentscreen=currentscreen->child;

	//NO INTERFACE LEFT, QUIT
	if(currentscreen==&view)return 1;

	//MOVE SCREENS BACK
	switch(currentscreen->breakdownlevel)
		{
		case INTERFACE_BREAKDOWN_NONE:
			{
			//GATHER INPUT
			enabler_inputst input;
			do
				{
				input=enabler.getinput();

				if(input.key!=0&&inputbuffer.size()<100)
					{
					if(valid_held_key(input.key))
						{
						inputbuffer.push_back(input.key);
						inputbuffer_caps.push_back(input.caps);
						inputbuffer_shift.push_back(input.shift);
						}
					input.key=0;
					}
				}while(input.key!=0);

			if(inputbuffer.size()>0)
				{
				if(c==0||!(flag & INTERFACEFLAG_RETAIN_NONZERO_INPUT))
					{
					c=inputbuffer[0];
					merge_binding(c);

					caps=inputbuffer_caps[0];
					shift=inputbuffer_shift[0];
					if(shift)shift=1;
					inputbuffer.erase(0);
					inputbuffer_caps.erase(0);
					inputbuffer_shift.erase(0);
					}
				}
			else if(!(flag & INTERFACEFLAG_RETAIN_NONZERO_INPUT))c=0;
			flag&=~INTERFACEFLAG_RETAIN_NONZERO_INPUT;

			//TOGGLE SCREEN
			if(gview.keypress(INTERFACEKEY_TOGGLE_FULLSCREEN))
				{
				if(!enabler.create_full_screen)enabler.cursesrect_set_font_id(rect_id,init.font.large_font_id);
				else enabler.cursesrect_set_font_id(rect_id,init.font.small_font_id);

				enabler.toggle_fullscreen();
				gview.c=0;
				}

			//GAME OPTIONS
			if(gview.keypress(INTERFACEKEY_OPTIONS))
				{
				//PEEL BACK ALL SCREENS TO THE CURRENT OPTION SCREEN IF THERE IS ONE
					//UNLESS THERE IS A BLOCKING SCREEN LIKE THE REGION MAKER
				viewscreenst *opscreen=&view;
				while(opscreen!=NULL)
					{
					if(opscreen->is_option_screen())
						{
						opscreen->option_key_pressed=1;
						while(opscreen->child!=NULL)
							{
							if(opscreen->child->is_option_screen()==2)
								{
								opscreen->child->option_key_pressed=1;
								opscreen->option_key_pressed=0;
								break;
								}
							removescreen(opscreen->child);
							}
						break;
						}

					opscreen=opscreen->child;
					}

				//NEED A NEW OPTIONS SCREEN?
				if(opscreen==NULL)viewscreen_optionst::create(INTERFACE_PUSH_AT_BACK);

				//REFRESH CURRENT SCREEN
					//GRAB CURRENT SCREEN AT THE END OF THE LIST
				currentscreen=&view;
				while(currentscreen->child!=NULL)currentscreen=currentscreen->child;

					//NO INTERFACE LEFT, QUIT
				if(currentscreen==&view)return 1;

				c=0;
				}
			else currentscreen->view();

			//PRINT THE MOUSE
			if(game.main_interface.mouse_zone)
				{
				if(enabler.tracking_on)
					{
					if(init.input.flag.has_flag(INIT_INPUT_FLAG_MOUSE_PICTURE))
						{
						enabler.set_color(1,1,1);
						enabler.locate(enabler.mouse_x,enabler.mouse_y);
						enabler.add_tile(gps.tex_pos[TEXTURE_MOUSE]);
						while(ShowCursor(FALSE)>0);
						}
					else while(ShowCursor(TRUE)<=0);
					}
				else while(ShowCursor(TRUE)<=0);
				}
			else if(enabler.create_full_screen)
				{
				while(ShowCursor(FALSE)>0);
				}
			else while(ShowCursor(TRUE)<=0);

			break;
			}
		case INTERFACE_BREAKDOWN_QUIT:
			{
			return 1;
			}
		case INTERFACE_BREAKDOWN_STOPSCREEN:
			removescreen(currentscreen);
			break;
		case INTERFACE_BREAKDOWN_TOFIRST:
			remove_to_first();
			break;
		}

	return 0;
}

void interfacest::remove_to_first(void)
{
	//GRAB LAST SCREEN AT THE END OF THE LIST
	viewscreenst *lastscreen=&view;
	while(lastscreen->child!=NULL)lastscreen=lastscreen->child;

	//NO INTERFACE LEFT
	if(lastscreen==&view)return;

	//GO AHEAD
	while(lastscreen->parent!=&view)
		{
		viewscreenst *par=lastscreen->parent;
		removescreen(lastscreen);
		lastscreen=par;
		}
}

void interfacest::removescreen(viewscreenst *scr)
{
	//FIX LINKS
	if(scr->parent!=NULL)scr->parent->child=scr->child;
	if(scr->child!=NULL)scr->child->parent=scr->parent;

	//WASTE SCREEN
	delete scr;
}

char interfacest::standardscrolling(long &selection,long min,long max,long jump,unsigned long flag)
{
	short osel=selection;

	//NOTE: THIS CAN HANDLE max = -1, min = 0
	char littlekey=0;
	if(gview.keypress(INTERFACEKEY_STANDARDSCROLL_UP)){selection--;littlekey=1;}
	if(gview.keypress(INTERFACEKEY_STANDARDSCROLL_DOWN)){selection++;littlekey=1;}
	if(gview.keypress(INTERFACEKEY_STANDARDSCROLL_PAGEUP))selection-=jump;
	if(gview.keypress(INTERFACEKEY_STANDARDSCROLL_PAGEDOWN))selection+=jump;

	finishscrolling(selection,min,max,jump,flag,littlekey);

	if(osel!=selection)return 1;
	else return 0;
}

void interfacest::finishscrolling(long &selection,long min,long max,long jump,unsigned long flag,char littlekey)
{
	if(flag & SCROLLING_NOSELECT)
		{
		if(selection>max-jump+1)selection=max-jump+1;
		if(selection<min)selection=min;
		}
	else
		{
		//WRAP ONLY IF YOU USED LITTLE KEYS OR IF YOU WERE AT THE END
		if(littlekey||selection==min-jump||selection==max+jump)
			{
			if(selection>max)selection=min;
			if(selection<min)selection=max;
			}
		//OTHERWISE JUST CLUNK AT THE BOTTOM
		else
			{
			if(selection>max)selection=max;
			if(selection<min)selection=min;
			}
		}
}

void interfacest::getstring_interfacechar(string &str,interfacekeyst &key)
{
	if(!gview.valid_held_key(key.binding))
		{
		str="Not Supported";
		return;
		}

	if(!gview.display_string[key.binding][key.shift].empty())
		{
		str=gview.display_string[key.binding][key.shift];
		return;
		}

	str.erase();

	if(key.shift)str+="Shift + ";
	switch(key.binding)
		{
		case VK_BACK:str+="Backspace";break;
		case VK_TAB:str+="Tab";break;
		case VK_CLEAR:str+="Clear";break;
		case VK_RETURN:str+="Enter";break;
		case VK_SHIFT:str+="Shift";break;
		case VK_CONTROL:str+="Ctrl";break;
		case VK_MENU:str+="Alt";break;
		case VK_PAUSE:str+="Pause";break;
		case VK_CAPITAL:str+="Caps";break;
		case VK_ESCAPE:str+="Escape";break;
		case VK_SPACE:str+="Space";break;
		case VK_PRIOR:str+="Page Up";break;
		case VK_NEXT:str+="Page Down";break;
		case VK_END:str+="End";break;
		case VK_HOME:str+="Home";break;
		case VK_LEFT:str+="Left";break;
		case VK_UP:str+="Up";break;
		case VK_RIGHT:str+="Right";break;
		case VK_DOWN:str+="Down";break;
		case VK_SELECT:str+="Select";break;
		case VK_PRINT:str+="Print";break;
		case VK_EXECUTE:str+="Execute";break;
		case VK_SNAPSHOT:str+="Print Screen";break;
		case VK_INSERT:str+="Insert";break;
		case VK_DELETE:str+="Delete";break;
		case VK_HELP:str+="Help";break;
		case 0x30://0
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39://9
			str+=key.binding;
			break;
		case 0x41://A
		case 0x42:
		case 0x43:
		case 0x44:
		case 0x45:
		case 0x46://F
		case 0x47:
		case 0x48:
		case 0x49:
		case 0x4A:
		case 0x4B://K
		case 0x4C:
		case 0x4D:
		case 0x4E:
		case 0x4F:
		case 0x50://P
		case 0x51:
		case 0x52:
		case 0x53:
		case 0x54:
		case 0x55://U
		case 0x56:
		case 0x57:
		case 0x58:
		case 0x59:
		case 0x5A://Z
			str+=(key.binding-'A')+'a';
			break;
		case VK_NUMPAD0:str+="Numpad 0";break;
		case VK_NUMPAD1:str+="Numpad 1";break;
		case VK_NUMPAD2:str+="Numpad 2";break;
		case VK_NUMPAD3:str+="Numpad 3";break;
		case VK_NUMPAD4:str+="Numpad 4";break;
		case VK_NUMPAD5:str+="Numpad 5";break;
		case VK_NUMPAD6:str+="Numpad 6";break;
		case VK_NUMPAD7:str+="Numpad 7";break;
		case VK_NUMPAD8:str+="Numpad 8";break;
		case VK_NUMPAD9:str+="Numpad 9";break;
		case VK_SEPARATOR:str+="Separator";break;
		case VK_SUBTRACT:str+="Subtract";break;
		case VK_ADD:str+="Add";break;
		case VK_MULTIPLY:str+="Multiply";break;
		case VK_DECIMAL:str+="Decimal";break;
		case VK_DIVIDE:str+="Divide";break;
		case VK_F1:str+="F1";break;
		case VK_F2:str+="F2";break;
		case VK_F3:str+="F3";break;
		case VK_F4:str+="F4";break;
		case VK_F5:str+="F5";break;
		case VK_F6:str+="F6";break;
		case VK_F7:str+="F7";break;
		case VK_F8:str+="F8";break;
		case VK_F9:str+="F9";break;
		case VK_F10:str+="F10";break;
		case VK_F11:str+="F11";break;
		case VK_F12:str+="F12";break;
		case VK_F13:str+="F13";break;
		case VK_F14:str+="F14";break;
		case VK_F15:str+="F15";break;
		case VK_F16:str+="F16";break;
		case VK_F17:str+="F17";break;
		case VK_F18:str+="F18";break;
		case VK_F19:str+="F19";break;
		case VK_F20:str+="F20";break;
		case VK_F21:str+="F21";break;
		case VK_F22:str+="F22";break;
		case VK_F23:str+="F23";break;
		case VK_F24:str+="F24";break;
		case VK_NUMLOCK:str+="Numlock";break;
		case VK_SCROLL:str+="Scroll";break;
		case VK_LSHIFT:str+="L Shift";break;
		case VK_RSHIFT:str+="R Shift";break;
		case VK_LCONTROL:str+="L Control";break;
		case VK_RCONTROL:str+="R Control";break;
		case VK_LMENU:str+="L Menu";break;
		case VK_RMENU:str+="R Menu";break;
		case 0xBA:str+="Key BA";break;
		case 0xBB:str+="Plus";break;
		case 0xBC:str+="Comma";break;
		case 0xBD:str+="Minus";break;
		case 0xBE:str+="Period";break;
		case 0xBF:str+="Key BF";break;
		case 0xC0:str+="Key C0";break;
		case 0xDB:str+="Key DB";break;
		case 0xDC:str+="Key DC";break;
		case 0xDD:str+="Key DD";break;
		case 0xDE:str+="Key DE";break;
		case 0xDF:str+="Key DF";break;
		case 0xE1:str+="Key E1";break;
		case 0xE2:str+="Key E2";break;
		case 0xE3:str+="Key E3";break;
		case 0xE4:str+="Key E4";break;
		case 0xE9:str+="Key E9";break;
		case 0xEA:str+="Key EA";break;
		case 0xEB:str+="Key EB";break;
		case 0xEC:str+="Key EC";break;
		case 0xED:str+="Key ED";break;
		case 0xEE:str+="Key EE";break;
		case 0xEF:str+="Key EF";break;
		case 0xF1:str+="Key F1";break;
		case 0xF2:str+="Key F2";break;
		case 0xF3:str+="Key F3";break;
		case 0xF4:str+="Key F4";break;
		case 0xF5:str+="Key F5";break;
		case 0x15:str+="Key Hangul/Kana";break;
		case 0x17:str+="Key Junja";break;
		case 0x18:str+="Key Final";break;
		case 0x19:str+="Key Hanja/Kanji";break;
		case 0x1C:str+="Key Convert";break;
		case 0x1D:str+="Key Nonconvert";break;
		case 0x1E:str+="Key Accept";break;
		case 0x1F:str+="Key Mode Change";break;
		case 0x92:str+="Key 92";break;
		case 0x93:str+="Key 93";break;
		case 0x94:str+="Key 94";break;
		case 0x95:str+="Key 95";break;
		case 0x96:str+="Key 96";break;
		default:str="Not Supported";break;
		}
}

void interfacest::getstring_interfacechar_save(string &str,interfacekeyst &key)
{
	if(!gview.valid_held_key(key.binding))
		{
		str="NOT_SUPPORTED";
		return;
		}

	str.erase();

	if(key.shift)str+="SHIFT+";
	switch(key.binding)
		{
		case VK_BACK:str+="BACKSPACE";break;
		case VK_TAB:str+="TAB";break;
		case VK_CLEAR:str+="CLEAR";break;
		case VK_RETURN:str+="ENTER";break;
		case VK_SHIFT:str+="SHIFT";break;
		case VK_CONTROL:str+="CTRL";break;
		case VK_MENU:str+="ALT";break;
		case VK_PAUSE:str+="PAUSE";break;
		case VK_CAPITAL:str+="CAPS";break;
		case VK_ESCAPE:str+="ESCAPE";break;
		case VK_SPACE:str+="SPACE";break;
		case VK_PRIOR:str+="PAGEUP";break;
		case VK_NEXT:str+="PAGEDOWN";break;
		case VK_END:str+="END";break;
		case VK_HOME:str+="HOME";break;
		case VK_LEFT:str+="LEFT";break;
		case VK_UP:str+="UP";break;
		case VK_RIGHT:str+="RIGHT";break;
		case VK_DOWN:str+="DOWN";break;
		case VK_SELECT:str+="SELECT";break;
		case VK_PRINT:str+="PRINT";break;
		case VK_EXECUTE:str+="EXECUTE";break;
		case VK_SNAPSHOT:str+="PRINTSCREEN";break;
		case VK_INSERT:str+="INSERT";break;
		case VK_DELETE:str+="DELETE";break;
		case VK_HELP:str+="HELP";break;
		case 0x30://0
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39://9
		case 0x41://A
		case 0x42:
		case 0x43:
		case 0x44:
		case 0x45:
		case 0x46://F
		case 0x47:
		case 0x48:
		case 0x49:
		case 0x4A:
		case 0x4B://K
		case 0x4C:
		case 0x4D:
		case 0x4E:
		case 0x4F:
		case 0x50://P
		case 0x51:
		case 0x52:
		case 0x53:
		case 0x54:
		case 0x55://U
		case 0x56:
		case 0x57:
		case 0x58:
		case 0x59:
		case 0x5A://Z
			str+=key.binding;
			break;
		case VK_NUMPAD0:str+="NUMPAD0";break;
		case VK_NUMPAD1:str+="NUMPAD1";break;
		case VK_NUMPAD2:str+="NUMPAD2";break;
		case VK_NUMPAD3:str+="NUMPAD3";break;
		case VK_NUMPAD4:str+="NUMPAD4";break;
		case VK_NUMPAD5:str+="NUMPAD5";break;
		case VK_NUMPAD6:str+="NUMPAD6";break;
		case VK_NUMPAD7:str+="NUMPAD7";break;
		case VK_NUMPAD8:str+="NUMPAD8";break;
		case VK_NUMPAD9:str+="NUMPAD9";break;
		case VK_SEPARATOR:str+="SEPARATOR";break;
		case VK_SUBTRACT:str+="SUBTRACT";break;
		case VK_ADD:str+="ADD";break;
		case VK_MULTIPLY:str+="MULTIPLY";break;
		case VK_DECIMAL:str+="DECIMAL";break;
		case VK_DIVIDE:str+="DIVIDE";break;
		case VK_F1:str+="F1";break;
		case VK_F2:str+="F2";break;
		case VK_F3:str+="F3";break;
		case VK_F4:str+="F4";break;
		case VK_F5:str+="F5";break;
		case VK_F6:str+="F6";break;
		case VK_F7:str+="F7";break;
		case VK_F8:str+="F8";break;
		case VK_F9:str+="F9";break;
		case VK_F10:str+="F10";break;
		case VK_F11:str+="F11";break;
		case VK_F12:str+="F12";break;
		case VK_F13:str+="F13";break;
		case VK_F14:str+="F14";break;
		case VK_F15:str+="F15";break;
		case VK_F16:str+="F16";break;
		case VK_F17:str+="F17";break;
		case VK_F18:str+="F18";break;
		case VK_F19:str+="F19";break;
		case VK_F20:str+="F20";break;
		case VK_F21:str+="F21";break;
		case VK_F22:str+="F22";break;
		case VK_F23:str+="F23";break;
		case VK_F24:str+="F24";break;
		case VK_NUMLOCK:str+="NUMLOCK";break;
		case VK_SCROLL:str+="SCROLL";break;
		case VK_LSHIFT:str+="LSHIFT";break;
		case VK_RSHIFT:str+="RSHIFT";break;
		case VK_LCONTROL:str+="LCTRL";break;
		case VK_RCONTROL:str+="RCTRL";break;
		case VK_LMENU:str+="LMENU";break;
		case VK_RMENU:str+="RMENU";break;
		case 0xBA:str+="KEYBA";break;
		case 0xBB:str+="PLUS";break;
		case 0xBC:str+="COMMA";break;
		case 0xBD:str+="MINUS";break;
		case 0xBE:str+="PERIOD";break;
		case 0xBF:str+="KEYBF";break;
		case 0xC0:str+="KEYC0";break;
		case 0xDB:str+="KEYDB";break;
		case 0xDC:str+="KEYDC";break;
		case 0xDD:str+="KEYDD";break;
		case 0xDE:str+="KEYDE";break;
		case 0xDF:str+="KEYDF";break;
		case 0xE1:str+="KEYE1";break;
		case 0xE2:str+="KEYE2";break;
		case 0xE3:str+="KEYE3";break;
		case 0xE4:str+="KEYE4";break;
		case 0xE9:str+="KEYE9";break;
		case 0xEA:str+="KEYEA";break;
		case 0xEB:str+="KEYEB";break;
		case 0xEC:str+="KEYEC";break;
		case 0xED:str+="KEYED";break;
		case 0xEE:str+="KEYEE";break;
		case 0xEF:str+="KEYEF";break;
		case 0xF1:str+="KEYF1";break;
		case 0xF2:str+="KEYF2";break;
		case 0xF3:str+="KEYF3";break;
		case 0xF4:str+="KEYF4";break;
		case 0xF5:str+="KEYF5";break;
		case 0x15:str+="KEYHANGULKANA";break;
		case 0x17:str+="KEYJUNJA";break;
		case 0x18:str+="KEYFINAL";break;
		case 0x19:str+="KEYHANJAKANJI";break;
		case 0x1C:str+="KEYCONVERT";break;
		case 0x1D:str+="KEYNONCONVERT";break;
		case 0x1E:str+="KEYACCEPT";break;
		case 0x1F:str+="KEYMODECHANGE";break;
		case 0x92:str+="KEY92";break;
		case 0x93:str+="KEY93";break;
		case 0x94:str+="KEY94";break;
		case 0x95:str+="KEY95";break;
		case 0x96:str+="KEY96";break;
		default:str="NONE";break;
		}
}

void interfacest::convertstring_interfacechar_save(string &str,interfacekeyst &key)
{
	if(str.length()==0)return;

	key.binding=27;
	key.shift=0;

	string::size_type wpos;
	string sr;

	sr="SHIFT+";
	while ((wpos = str.find(sr)) != string::npos)
		{
		string str2="";
		str.replace(wpos,sr.size(),str2);
		key.shift=1;
		}

	if(!str.compare("BACKSPACE")){key.binding=VK_BACK;return;}
	if(!str.compare("TAB")){key.binding=VK_TAB;return;}
	if(!str.compare("CLEAR")){key.binding=VK_CLEAR;return;}
	if(!str.compare("ENTER")){key.binding=VK_RETURN;return;}
	if(!str.compare("SHIFT")){key.binding=VK_SHIFT;return;}
	if(!str.compare("CTRL")){key.binding=VK_CONTROL;return;}
	if(!str.compare("ALT")){key.binding=VK_MENU;return;}
	if(!str.compare("PAUSE")){key.binding=VK_PAUSE;return;}
	if(!str.compare("CAPS")){key.binding=VK_CAPITAL;return;}
	if(!str.compare("ESCAPE")){key.binding=VK_ESCAPE;return;}
	if(!str.compare("SPACE")){key.binding=VK_SPACE;return;}
	if(!str.compare("PAGEUP")){key.binding=VK_PRIOR;return;}
	if(!str.compare("PAGEDOWN")){key.binding=VK_NEXT;return;}
	if(!str.compare("END")){key.binding=VK_END;return;}
	if(!str.compare("HOME")){key.binding=VK_HOME;return;}
	if(!str.compare("LEFT")){key.binding=VK_LEFT;return;}
	if(!str.compare("UP")){key.binding=VK_UP;return;}
	if(!str.compare("RIGHT")){key.binding=VK_RIGHT;return;}
	if(!str.compare("DOWN")){key.binding=VK_DOWN;return;}
	if(!str.compare("SELECT")){key.binding=VK_SELECT;return;}
	if(!str.compare("PRINT")){key.binding=VK_PRINT;return;}
	if(!str.compare("EXECUTE")){key.binding=VK_EXECUTE;return;}
	if(!str.compare("PRINTSCREEN")){key.binding=VK_SNAPSHOT;return;}
	if(!str.compare("INSERT")){key.binding=VK_INSERT;return;}
	if(!str.compare("DELETE")){key.binding=VK_DELETE;return;}
	if(!str.compare("HELP")){key.binding=VK_HELP;return;}
	if(!str.compare("NUMPAD0")){key.binding=VK_NUMPAD0;return;}
	if(!str.compare("NUMPAD1")){key.binding=VK_NUMPAD1;return;}
	if(!str.compare("NUMPAD2")){key.binding=VK_NUMPAD2;return;}
	if(!str.compare("NUMPAD3")){key.binding=VK_NUMPAD3;return;}
	if(!str.compare("NUMPAD4")){key.binding=VK_NUMPAD4;return;}
	if(!str.compare("NUMPAD5")){key.binding=VK_NUMPAD5;return;}
	if(!str.compare("NUMPAD6")){key.binding=VK_NUMPAD6;return;}
	if(!str.compare("NUMPAD7")){key.binding=VK_NUMPAD7;return;}
	if(!str.compare("NUMPAD8")){key.binding=VK_NUMPAD8;return;}
	if(!str.compare("NUMPAD9")){key.binding=VK_NUMPAD9;return;}
	if(!str.compare("SEPARATOR")){key.binding=VK_SEPARATOR;return;}
	if(!str.compare("SUBTRACT")){key.binding=VK_SUBTRACT;return;}
	if(!str.compare("ADD")){key.binding=VK_ADD;return;}
	if(!str.compare("MULTIPLY")){key.binding=VK_MULTIPLY;return;}
	if(!str.compare("DECIMAL")){key.binding=VK_DECIMAL;return;}
	if(!str.compare("DIVIDE")){key.binding=VK_DIVIDE;return;}
	if(!str.compare("F1")){key.binding=VK_F1;return;}
	if(!str.compare("F2")){key.binding=VK_F2;return;}
	if(!str.compare("F3")){key.binding=VK_F3;return;}
	if(!str.compare("F4")){key.binding=VK_F4;return;}
	if(!str.compare("F5")){key.binding=VK_F5;return;}
	if(!str.compare("F6")){key.binding=VK_F6;return;}
	if(!str.compare("F7")){key.binding=VK_F7;return;}
	if(!str.compare("F8")){key.binding=VK_F8;return;}
	if(!str.compare("F9")){key.binding=VK_F9;return;}
	if(!str.compare("F10")){key.binding=VK_F10;return;}
	if(!str.compare("F11")){key.binding=VK_F11;return;}
	if(!str.compare("F12")){key.binding=VK_F12;return;}
	if(!str.compare("F13")){key.binding=VK_F13;return;}
	if(!str.compare("F14")){key.binding=VK_F14;return;}
	if(!str.compare("F15")){key.binding=VK_F15;return;}
	if(!str.compare("F16")){key.binding=VK_F16;return;}
	if(!str.compare("F17")){key.binding=VK_F17;return;}
	if(!str.compare("F18")){key.binding=VK_F18;return;}
	if(!str.compare("F19")){key.binding=VK_F19;return;}
	if(!str.compare("F20")){key.binding=VK_F20;return;}
	if(!str.compare("F21")){key.binding=VK_F21;return;}
	if(!str.compare("F22")){key.binding=VK_F22;return;}
	if(!str.compare("F23")){key.binding=VK_F23;return;}
	if(!str.compare("F24")){key.binding=VK_F24;return;}
	if(!str.compare("NUMLOCK")){key.binding=VK_NUMLOCK;return;}
	if(!str.compare("SCROLL")){key.binding=VK_SCROLL;return;}
	if(!str.compare("LSHIFT")){key.binding=VK_LSHIFT;return;}
	if(!str.compare("RSHIFT")){key.binding=VK_RSHIFT;return;}
	if(!str.compare("LCTRL")){key.binding=VK_LCONTROL;return;}
	if(!str.compare("RCTRL")){key.binding=VK_RCONTROL;return;}
	if(!str.compare("LMENU")){key.binding=VK_LMENU;return;}
	if(!str.compare("RMENU")){key.binding=VK_RMENU;return;}
	if(!str.compare("KEYBA")){key.binding=0xBA;return;}
	if(!str.compare("PLUS")){key.binding=0xBB;return;}
	if(!str.compare("COMMA")){key.binding=0xBC;return;}
	if(!str.compare("MINUS")){key.binding=0xBD;return;}
	if(!str.compare("PERIOD")){key.binding=0xBE;return;}
	if(!str.compare("KEYBF")){key.binding=0xBF;return;}
	if(!str.compare("KEYC0")){key.binding=0xC0;return;}
	if(!str.compare("KEYDB")){key.binding=0xDB;return;}
	if(!str.compare("KEYDC")){key.binding=0xDC;return;}
	if(!str.compare("KEYDD")){key.binding=0xDD;return;}
	if(!str.compare("KEYDE")){key.binding=0xDE;return;}
	if(!str.compare("KEYDF")){key.binding=0xDF;return;}
	if(!str.compare("KEYE1")){key.binding=0xE1;return;}
	if(!str.compare("KEYE2")){key.binding=0xE2;return;}
	if(!str.compare("KEYE3")){key.binding=0xE3;return;}
	if(!str.compare("KEYE4")){key.binding=0xE4;return;}
	if(!str.compare("KEYE9")){key.binding=0xE9;return;}
	if(!str.compare("KEYEA")){key.binding=0xEA;return;}
	if(!str.compare("KEYEB")){key.binding=0xEB;return;}
	if(!str.compare("KEYEC")){key.binding=0xEC;return;}
	if(!str.compare("KEYED")){key.binding=0xED;return;}
	if(!str.compare("KEYEE")){key.binding=0xEE;return;}
	if(!str.compare("KEYEF")){key.binding=0xEF;return;}
	if(!str.compare("KEYF1")){key.binding=0xF1;return;}
	if(!str.compare("KEYF2")){key.binding=0xF2;return;}
	if(!str.compare("KEYF3")){key.binding=0xF3;return;}
	if(!str.compare("KEYF4")){key.binding=0xF4;return;}
	if(!str.compare("KEYF5")){key.binding=0xF5;return;}
	if(!str.compare("KEYHANGULKANA")){key.binding=0x15;return;}
	if(!str.compare("KEYJUNJA")){key.binding=0x17;return;}
	if(!str.compare("KEYFINAL")){key.binding=0x18;return;}
	if(!str.compare("KEYHANJAKANJI")){key.binding=0x19;return;}
	if(!str.compare("KEYCONVERT")){key.binding=0x1C;return;}
	if(!str.compare("KEYNONCONVERT")){key.binding=0x1D;return;}
	if(!str.compare("KEYACCEPT")){key.binding=0x1E;return;}
	if(!str.compare("KEYMODECHANGE")){key.binding=0x1F;return;}
	if(!str.compare("KEY92")){key.binding=0x92;return;}
	if(!str.compare("KEY93")){key.binding=0x93;return;}
	if(!str.compare("KEY94")){key.binding=0x94;return;}
	if(!str.compare("KEY95")){key.binding=0x95;return;}
	if(!str.compare("KEY96")){key.binding=0x96;return;}

	if(str.compare("NONE")&&str.compare("NOT_SUPPORTED"))
		{
		if(str[0]>='0'&&str[0]<='9')key.binding=str[0];
		if(str[0]>='A'&&str[0]<='Z')key.binding=str[0];
		return;
		}
}

void interfacest::print_interface_token(InterfaceKey key)
{
	short o_screenf=gps.screenf,o_screenb=gps.screenb,o_screenbright=gps.screenbright;
	gps.changecolor(2,0,1);
	string tok;
	getstring_interfacechar(tok,gview.interfacekey[key]);
	gps.addst(tok);
	gps.changecolor(o_screenf,o_screenb,o_screenbright);
}

viewscreen_titlest *viewscreen_titlest::create(char pushtype,viewscreenst *scr)
{
	viewscreen_titlest *newv=new viewscreen_titlest;
	gview.addscreen(newv,pushtype,scr);

	return newv;
}

viewscreen_titlest::viewscreen_titlest()
{
}

void viewscreen_titlest::view(void)
{
	enabler.flag&=~ENABLERFLAG_MAXFPS;

#ifndef NO_FMOD
	musicsound.startbackgroundmusic(SONG_TITLE);
#endif

	gps.erasescreen();

	short mx,my;
	gview.get_mouse_hover(mx,my);

	gps.changecolor(0,0,1);
	gps.locate(24,0);
	gps.addst("Version 1.06");

	if(my==18)gps.changecolor(7,0,1);
	else gps.changecolor(7,0,0);
	gps.locate(18,38);
	gps.addst("Play");
	if(my==20)gps.changecolor(7,0,1);
	else gps.changecolor(7,0,0);
	gps.locate(20,32);
	gps.addst("View High Scores");
	if(my==22)gps.changecolor(7,0,1);
	else gps.changecolor(7,0,0);
	gps.locate(22,38);
	gps.addst("Quit");

	enabler.locate(enabler.window_width/2-128,0);
	enabler.add_tile(gps.tex_pos[TEXTURE_TITLE]);

	gps.renewscreen();

	if(gview.mouse_lbut())
		{
		if(my==18)
			{
			game.set_sound(SOUND_CLICK);
			viewscreen_main_gamest::create(INTERFACE_PUSH_AT_BACK);
			}
		if(my==20)
			{
			game.set_sound(SOUND_CLICK);
			viewscreen_highscoresst::create(INTERFACE_PUSH_AT_BACK);
			}
		if(my==22)
			{
			game.set_sound(SOUND_CLICK);
			breakdownlevel=INTERFACE_BREAKDOWN_QUIT;
			}
		}

	if(gview.keypress(INTERFACEKEY_LEAVESCREEN))
		{
		game.set_sound(SOUND_CLICK);
		breakdownlevel=INTERFACE_BREAKDOWN_QUIT;
		}
}

char interfacest::standardstringentry(string &str,int maxlen,char force_caps)
{
	unsigned char entry=255;

	if(gview.keypress(INTERFACEKEY_STRING_A))entry='a';
	if(gview.keypress(INTERFACEKEY_STRING_B))entry='b';
	if(gview.keypress(INTERFACEKEY_STRING_C))entry='c';
	if(gview.keypress(INTERFACEKEY_STRING_D))entry='d';
	if(gview.keypress(INTERFACEKEY_STRING_E))entry='e';
	if(gview.keypress(INTERFACEKEY_STRING_F))entry='f';
	if(gview.keypress(INTERFACEKEY_STRING_G))entry='g';
	if(gview.keypress(INTERFACEKEY_STRING_H))entry='h';
	if(gview.keypress(INTERFACEKEY_STRING_I))entry='i';
	if(gview.keypress(INTERFACEKEY_STRING_J))entry='j';
	if(gview.keypress(INTERFACEKEY_STRING_K))entry='k';
	if(gview.keypress(INTERFACEKEY_STRING_L))entry='l';
	if(gview.keypress(INTERFACEKEY_STRING_M))entry='m';
	if(gview.keypress(INTERFACEKEY_STRING_N))entry='n';
	if(gview.keypress(INTERFACEKEY_STRING_O))entry='o';
	if(gview.keypress(INTERFACEKEY_STRING_P))entry='p';
	if(gview.keypress(INTERFACEKEY_STRING_Q))entry='q';
	if(gview.keypress(INTERFACEKEY_STRING_R))entry='r';
	if(gview.keypress(INTERFACEKEY_STRING_S))entry='s';
	if(gview.keypress(INTERFACEKEY_STRING_T))entry='t';
	if(gview.keypress(INTERFACEKEY_STRING_U))entry='u';
	if(gview.keypress(INTERFACEKEY_STRING_V))entry='v';
	if(gview.keypress(INTERFACEKEY_STRING_W))entry='w';
	if(gview.keypress(INTERFACEKEY_STRING_X))entry='x';
	if(gview.keypress(INTERFACEKEY_STRING_Y))entry='y';
	if(gview.keypress(INTERFACEKEY_STRING_Z))entry='z';
	if(gview.keypress(INTERFACEKEY_STRING_A_CAP))entry='A';
	if(gview.keypress(INTERFACEKEY_STRING_B_CAP))entry='B';
	if(gview.keypress(INTERFACEKEY_STRING_C_CAP))entry='C';
	if(gview.keypress(INTERFACEKEY_STRING_D_CAP))entry='D';
	if(gview.keypress(INTERFACEKEY_STRING_E_CAP))entry='E';
	if(gview.keypress(INTERFACEKEY_STRING_F_CAP))entry='F';
	if(gview.keypress(INTERFACEKEY_STRING_G_CAP))entry='G';
	if(gview.keypress(INTERFACEKEY_STRING_H_CAP))entry='H';
	if(gview.keypress(INTERFACEKEY_STRING_I_CAP))entry='I';
	if(gview.keypress(INTERFACEKEY_STRING_J_CAP))entry='J';
	if(gview.keypress(INTERFACEKEY_STRING_K_CAP))entry='K';
	if(gview.keypress(INTERFACEKEY_STRING_L_CAP))entry='L';
	if(gview.keypress(INTERFACEKEY_STRING_M_CAP))entry='M';
	if(gview.keypress(INTERFACEKEY_STRING_N_CAP))entry='N';
	if(gview.keypress(INTERFACEKEY_STRING_O_CAP))entry='O';
	if(gview.keypress(INTERFACEKEY_STRING_P_CAP))entry='P';
	if(gview.keypress(INTERFACEKEY_STRING_Q_CAP))entry='Q';
	if(gview.keypress(INTERFACEKEY_STRING_R_CAP))entry='R';
	if(gview.keypress(INTERFACEKEY_STRING_S_CAP))entry='S';
	if(gview.keypress(INTERFACEKEY_STRING_T_CAP))entry='T';
	if(gview.keypress(INTERFACEKEY_STRING_U_CAP))entry='U';
	if(gview.keypress(INTERFACEKEY_STRING_V_CAP))entry='V';
	if(gview.keypress(INTERFACEKEY_STRING_W_CAP))entry='W';
	if(gview.keypress(INTERFACEKEY_STRING_X_CAP))entry='X';
	if(gview.keypress(INTERFACEKEY_STRING_Y_CAP))entry='Y';
	if(gview.keypress(INTERFACEKEY_STRING_Z_CAP))entry='Z';
	if(gview.keypress(INTERFACEKEY_STRING_SPACE))entry=' ';
	if(gview.keypress(INTERFACEKEY_STRING_BACKSPACE))entry='\x0';

	if(entry!=255)
		{
		if(entry=='\x0')
			{
			if(str.length()>0)str.resize(str.length()-1);
			}
		else
			{
			int cursor=str.length();
			if(cursor>=maxlen)cursor=maxlen-1;
			if(cursor<0)cursor=0;

			if(str.length()<cursor+1)str.resize(cursor+1);

			if(entry>='a'&&entry<='z'&&force_caps)str[cursor]=entry+'A'-'a';
			else str[cursor]=entry;
			}

		gview.c=0;

		return 1;
		}

	return 0;
}

viewscreen_main_gamest *viewscreen_main_gamest::create(char pushtype,viewscreenst *scr)
{
	viewscreen_main_gamest *newv=new viewscreen_main_gamest;
	gview.addscreen(newv,pushtype,scr);

	return newv;
}

viewscreen_main_gamest::viewscreen_main_gamest()
{
	game.clean();

	//FIRST, CHECK FOR A SAVED GAME AND JUST LOAD THAT IF POSSIBLE
	if(!game.load_active_game())
		{
		//OTHERWISE, CREATE A NEW GAME
		game.cave.init();

		game.next_unit_id=0;
		game.next_kobold_id=0;
		game.next_adventurer_id=0;
		game.next_critter_id=0;

		game.load_score_list();

		game.create_initial_kobolds();

		game.reprieve_time=200;
		game.main_interface.naming_cave=1;
		}

	game.cave.do_lighting();
	game.pass_turn=0;
	game.adventurer_wait=0;//1.02
	game.cur_sound=-1;
}

void viewscreen_main_gamest::view(void)
{
	enabler.flag&=~ENABLERFLAG_MAXFPS;

#ifndef NO_FMOD
	musicsound.stopbackgroundmusic();
#endif

	if(game.kobold.global.size()==0)
		{
		DeleteFile("data/save/save.dat");

		game.end_game();

		breakdownlevel=INTERFACE_BREAKDOWN_TOFIRST;
		return;
		}

	game.print();

	game.input();

	if(game.pass_turn)
		{
		game.turn();
		}
}

void interfacest::get_cursor_vars(short &sx,short &sy)
{
	sx=0;sy=0;

	char arrowch=0;
	if(gview.keypress(INTERFACEKEY_CURSOR_LEFT))arrowch='4';
	if(gview.keypress(INTERFACEKEY_CURSOR_RIGHT))arrowch='6';
	if(gview.keypress(INTERFACEKEY_CURSOR_UP))arrowch='8';
	if(gview.keypress(INTERFACEKEY_CURSOR_DOWN))arrowch='2';
	if(gview.keypress(INTERFACEKEY_CURSOR_UPLEFT))arrowch='7';
	if(gview.keypress(INTERFACEKEY_CURSOR_UPRIGHT))arrowch='9';
	if(gview.keypress(INTERFACEKEY_CURSOR_DOWNLEFT))arrowch='1';
	if(gview.keypress(INTERFACEKEY_CURSOR_DOWNRIGHT))arrowch='3';
	if(arrowch=='4'||arrowch=='7'||arrowch=='1')sx=-1;
	if(arrowch=='9'||arrowch=='6'||arrowch=='3')sx=1;
	if(arrowch=='7'||arrowch=='8'||arrowch=='9')sy=-1;
	if(arrowch=='1'||arrowch=='2'||arrowch=='3')sy=1;
}

void interfacest::get_mouse_hover(short &mx,short &my)
{
	mx=-1;

	if(enabler.tracking_on)
		{
		mx=enabler.mouse_x*80/enabler.window_width;
		my=enabler.mouse_y*25/enabler.window_height;
		}
}

char interfacest::mouse_lbut()
{
	if(enabler.tracking_on)return enabler.mouse_lbut;
	return 0;
}

char interfacest::mouse_rbut()
{
	if(enabler.tracking_on)return enabler.mouse_rbut;
	return 0;
}

void interfacest::clear_mouse_lbut()
{
	enabler.mouse_lbut=0;
}

void interfacest::clear_mouse_rbut()
{
	enabler.mouse_rbut=0;
}

viewscreen_highscoresst *viewscreen_highscoresst::create(char pushtype,viewscreenst *scr)
{
	viewscreen_highscoresst *newv=new viewscreen_highscoresst;
	gview.addscreen(newv,pushtype,scr);

	return newv;
}

viewscreen_highscoresst::viewscreen_highscoresst()
{
	game.clean();

	game.load_score_list();

	selected=0;
	detail=-1;

	long a,a2,xp;
	for(a=0;a<game.adventurer.global.size();a++)
		{
		xp=game.adventurer.global[a]->calc_total_xp();
		for(a2=0;a2<a_list.size();a2++)
			{
			if(a_list[a2]->calc_total_xp()<xp)
				{
				a_list.insert(a2,game.adventurer.global[a]);
				break;
				}
			}
		if(a2==a_list.size())a_list.push_back(game.adventurer.global[a]);
		}
}

void viewscreen_highscoresst::view(void)
{
	enabler.flag&=~ENABLERFLAG_MAXFPS;

#ifndef NO_FMOD
	musicsound.startbackgroundmusic(SONG_TITLE);
#endif

	gps.erasescreen();

	if(detail!=-1)
		{
		gps.changecolor(7,0,1);
		gps.locate(0,0);
		gps.addst("High Scores: ");
		if(a_list[detail]->def!=NULL)
			{
			if(!a_list[detail]->def->title.empty())
				{
				gps.addst(a_list[detail]->def->title);
				gps.addst(" ");
				}
			}
		gps.addst(a_list[detail]->name);
		if(a_list[detail]->def!=NULL)
			{
			gps.addst(", ");
			gps.addst(a_list[detail]->def->name);
			gps.addst(", ");
			}
		string num;
		convert_long_to_string(a_list[detail]->calc_total_xp(),num);
		gps.addst(num);
		gps.addst(" XP");
		if(!a_list[detail]->death_string.empty())gps.addst(", Deceased");

		if(a_list[detail]->kill_xp.size()==0)
			{
			gps.locate(2,0);
			gps.addst("No kills");
			}

		long scroll=detail_selected,y=2;
		long a;
		for(a=scroll;a<scroll+20&&a<a_list[detail]->kill_xp.size();a++)
			{
			gps.changecolor(7,0,1);
			gps.locate(y,0);
			gps.addst(a_list[detail]->kill_name.str[a]->dat);
			gps.addst(", ");
			convert_long_to_string(a_list[detail]->kill_xp[a],num);
			gps.addst(num);
			gps.addst(" XP");
			if(a_list[detail]->kill_num[a]>1)
				{
				gps.addst(" x ");
				convert_long_to_string(a_list[detail]->kill_num[a],num);
				gps.addst(num);
				}
			y++;
			}
		}
	else
		{
		gps.changecolor(7,0,1);
		gps.locate(0,0);
		gps.addst("High Scores");

		if(a_list.size()==0)
			{
			gps.locate(2,0);
			gps.addst("None yet");
			}

		long scroll=(selected/10)*10,y=2;
		long a;
		for(a=scroll;a<scroll+10&&a<a_list.size();a++)
			{
			if(selected==a)gps.changecolor(7,0,1);
			else gps.changecolor(7,0,0);

			gps.locate(y,0);
			if(a_list[a]->def!=NULL)
				{
				if(!a_list[a]->def->title.empty())
					{
					gps.addst(a_list[a]->def->title);
					gps.addst(" ");
					}
				}
			gps.addst(a_list[a]->name);
			if(a_list[a]->def!=NULL)
				{
				gps.addst(", ");
				gps.addst(a_list[a]->def->name);
				gps.addst(",");
				}
			if(a_list[a]->death_string.empty())gps.addst(" still adventuring");
			else
				{
				gps.addst(a_list[a]->death_string);
				gps.locate(y+1,1);
				gps.addst(a_list[a]->death_string2);
				}
			gps.addst(", ");
			string num;
			convert_long_to_string(a_list[a]->calc_total_xp(),num);
			gps.addst(num);
			gps.addst(" XP.");

			y+=2;
			}
		}

	gps.renewscreen();

	if(detail!=-1)
		{
		gview.standardscrolling(detail_selected,0,(long)a_list[detail]->kill_xp.size()-1,20,SCROLLING_NOSELECT);

		if(gview.keypress(INTERFACEKEY_LEAVESCREEN))
			{
			game.set_sound(SOUND_CLICK);
			detail=-1;
			}
		}
	else
		{
		gview.standardscrolling(selected,0,(long)a_list.size()-1,10);

		if(gview.keypress(INTERFACEKEY_SELECT)&&a_list.size()>0)
			{
			game.set_sound(SOUND_CLICK);
			detail=selected;
			detail_selected=0;
			return;
			}

		if(gview.keypress(INTERFACEKEY_LEAVESCREEN))
			{
			game.set_sound(SOUND_CLICK);
			breakdownlevel=INTERFACE_BREAKDOWN_STOPSCREEN;
			}
		}
}