//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#define SCROLLING_NOSELECT BIT1

enum InterfaceKey
{
	INTERFACEKEY_SELECT,
	INTERFACEKEY_LEAVESCREEN,
	INTERFACEKEY_OPTIONS,
	INTERFACEKEY_SELECT_KOBOLD_UP,
	INTERFACEKEY_SELECT_KOBOLD_DOWN,
	INTERFACEKEY_COVER_TRAP,
	INTERFACEKEY_PICK_UP_CRITTER,
	INTERFACEKEY_DROP_CRITTER,
	INTERFACEKEY_DESCRIBE_HELD_CRITTER,
	INTERFACEKEY_THROW_CRITTER,
	INTERFACEKEY_WAIT,
	INTERFACEKEY_WAIT_FOR_ADVENTURER,//1.02
	INTERFACEKEY_TOGGLE_FULLSCREEN,
	INTERFACEKEY_SAVE_BINDINGS,
	INTERFACEKEY_CHANGE_BINDINGS,
	INTERFACEKEY_STANDARDSCROLL_UP,
	INTERFACEKEY_STANDARDSCROLL_DOWN,
	INTERFACEKEY_STANDARDSCROLL_LEFT,
	INTERFACEKEY_STANDARDSCROLL_RIGHT,
	INTERFACEKEY_STANDARDSCROLL_PAGEUP,
	INTERFACEKEY_STANDARDSCROLL_PAGEDOWN,
	INTERFACEKEY_CURSOR_UP,
	INTERFACEKEY_CURSOR_DOWN,
	INTERFACEKEY_CURSOR_LEFT,
	INTERFACEKEY_CURSOR_RIGHT,
	INTERFACEKEY_CURSOR_UPLEFT,
	INTERFACEKEY_CURSOR_UPRIGHT,
	INTERFACEKEY_CURSOR_DOWNLEFT,
	INTERFACEKEY_CURSOR_DOWNRIGHT,
	INTERFACEKEY_STRING_A,
	INTERFACEKEY_STRING_B,
	INTERFACEKEY_STRING_C,
	INTERFACEKEY_STRING_D,
	INTERFACEKEY_STRING_E,
	INTERFACEKEY_STRING_F,
	INTERFACEKEY_STRING_G,
	INTERFACEKEY_STRING_H,
	INTERFACEKEY_STRING_I,
	INTERFACEKEY_STRING_J,
	INTERFACEKEY_STRING_K,
	INTERFACEKEY_STRING_L,
	INTERFACEKEY_STRING_M,
	INTERFACEKEY_STRING_N,
	INTERFACEKEY_STRING_O,
	INTERFACEKEY_STRING_P,
	INTERFACEKEY_STRING_Q,
	INTERFACEKEY_STRING_R,
	INTERFACEKEY_STRING_S,
	INTERFACEKEY_STRING_T,
	INTERFACEKEY_STRING_U,
	INTERFACEKEY_STRING_V,
	INTERFACEKEY_STRING_W,
	INTERFACEKEY_STRING_X,
	INTERFACEKEY_STRING_Y,
	INTERFACEKEY_STRING_Z,
	INTERFACEKEY_STRING_A_CAP,
	INTERFACEKEY_STRING_B_CAP,
	INTERFACEKEY_STRING_C_CAP,
	INTERFACEKEY_STRING_D_CAP,
	INTERFACEKEY_STRING_E_CAP,
	INTERFACEKEY_STRING_F_CAP,
	INTERFACEKEY_STRING_G_CAP,
	INTERFACEKEY_STRING_H_CAP,
	INTERFACEKEY_STRING_I_CAP,
	INTERFACEKEY_STRING_J_CAP,
	INTERFACEKEY_STRING_K_CAP,
	INTERFACEKEY_STRING_L_CAP,
	INTERFACEKEY_STRING_M_CAP,
	INTERFACEKEY_STRING_N_CAP,
	INTERFACEKEY_STRING_O_CAP,
	INTERFACEKEY_STRING_P_CAP,
	INTERFACEKEY_STRING_Q_CAP,
	INTERFACEKEY_STRING_R_CAP,
	INTERFACEKEY_STRING_S_CAP,
	INTERFACEKEY_STRING_T_CAP,
	INTERFACEKEY_STRING_U_CAP,
	INTERFACEKEY_STRING_V_CAP,
	INTERFACEKEY_STRING_W_CAP,
	INTERFACEKEY_STRING_X_CAP,
	INTERFACEKEY_STRING_Y_CAP,
	INTERFACEKEY_STRING_Z_CAP,
	INTERFACEKEY_STRING_SPACE,
	INTERFACEKEY_STRING_BACKSPACE,
	INTERFACEKEYNUM,
	INTERFACEKEY_NONE=-1
};

enum InterfaceBreakdownTypes
{
	INTERFACE_BREAKDOWN_NONE,
	INTERFACE_BREAKDOWN_QUIT,
	INTERFACE_BREAKDOWN_STOPSCREEN,
	INTERFACE_BREAKDOWN_TOFIRST,
	INTERFACE_BREAKDOWNNUM
};

class viewscreenst
{
	public:
		viewscreenst *child;
		viewscreenst *parent;
		char breakdownlevel;

		char option_key_pressed;

		virtual void view(void){};
		virtual char is_option_screen(void){return 0;}
		virtual char is_save_screen(void){return 0;}

		viewscreenst()
			{
			child=NULL;
			parent=NULL;
			breakdownlevel=INTERFACE_BREAKDOWN_NONE;
			option_key_pressed=0;
			}
		virtual ~viewscreenst(){}
};

enum MainMenuOption
{
	MAINMENU_OPTION_RETURN,
	MAINMENU_OPTION_KEYBINDINGS,
	MAINMENU_OPTION_SAVE,
	MAINMENU_OPTIONNUM
};

class viewscreen_optionst : viewscreenst
{
	public:
		static viewscreen_optionst *create(char pushtype,viewscreenst *scr=NULL);
		virtual void view(void);
		virtual char is_option_screen(void){return 1;}

	private:
		char quit_confirm;
		long selected;

		viewscreen_optionst();
};

class viewscreen_titlest : viewscreenst
{
	public:
		static viewscreen_titlest *create(char pushtype,viewscreenst *scr=NULL);
		virtual void view(void);

	private:
		viewscreen_titlest();
};

class viewscreen_highscoresst : viewscreenst
{
	public:
		static viewscreen_highscoresst *create(char pushtype,viewscreenst *scr=NULL);
		virtual void view(void);

		svector<adventurerst *> a_list;
		long selected;
		long detail;
		long detail_selected;

	private:
		viewscreen_highscoresst();
};

class viewscreen_keybindingsst : viewscreenst
{
	public:
		static viewscreen_keybindingsst *create(char pushtype,viewscreenst *scr=NULL);
		virtual void view(void);

	private:
		svector<long> allowed_key;

		long selected;
		char binding;
		viewscreen_keybindingsst();
};

class viewscreen_main_gamest : viewscreenst
{
	public:
		static viewscreen_main_gamest *create(char pushtype,viewscreenst *scr=NULL);
		virtual void view(void);

	private:
		viewscreen_main_gamest();
};

enum InterfacePushType
{
	INTERFACE_PUSH_AS_PARENT,
	INTERFACE_PUSH_AS_CHILD,
	INTERFACE_PUSH_AT_BACK,
	INTERFACE_PUSH_AT_FRONT,
	INTERFACE_PUSHNUM
};

struct interfacekeyst
{
	string name;
	string tokenname;
	unsigned char binding;
	long last_used_for_held;//IN WINDOWS TICKS
	char held;
	char shift;
	
	interfacekeyst()
		{
		//SET THEM ALL TO SHIFT + F10 IN CASE LOAD IS CIRCUMVENTED
		binding=VK_F10;
		last_used_for_held=0;
		held=0;
		shift=1;
		}
};

#define INTERFACEFLAG_RETAIN_NONZERO_INPUT BIT1

class interfacest
{
	public:
		unsigned char c;
		char shift,caps;

		string display_string[256][2];
		

		viewscreenst view;
		unsigned long time;
		svector<unsigned char> inputbuffer;
		svector<char> inputbuffer_shift;
		svector<char> inputbuffer_caps;
		unsigned long flag;
		interfacekeyst interfacekey[INTERFACEKEYNUM];

		char loop(void);
		void remove_to_first(void);
		void removescreen(viewscreenst *scr);
		void addscreen(viewscreenst *scr,char pushtype,viewscreenst *relate);
		char keypress(short key);
		char valid_held_key(unsigned char c);
	
		char standardscrolling(long &selection,long min,long max,long jump,unsigned long flag=0);
		void finishscrolling(long &selection,long min,long max,long jump,unsigned long flag,char littlekey);

		void getstring_interfacechar(string &str,interfacekeyst &key);
		void getstring_interfacechar_save(string &str,interfacekeyst &key);
		void convertstring_interfacechar_save(string &str,interfacekeyst &key);
		void print_interface_token(InterfaceKey key);

		char standardstringentry(string &str,int maxlen,char force_caps);

		void get_cursor_vars(short &sx,short &sy);

		void get_mouse_hover(short &mx,short &my);

		char mouse_lbut();
		char mouse_rbut();
		void clear_mouse_lbut();
		void clear_mouse_rbut();

		interfacest();
		~interfacest();

	private:
		unsigned char keyboardstate[256];

		void insertscreen_as_parent(viewscreenst *scr,viewscreenst *child);
		void insertscreen_as_child(viewscreenst *scr,viewscreenst *parent);
		void insertscreen_at_back(viewscreenst *scr);
		void insertscreen_at_front(viewscreenst *scr);
};

class main_interfacest
{
	public:
		char mouse_zone;
		char throwing;
		char naming_cave;
		svector<unitst *> target_unit;
		long selected_target;
		long viewing_critter;

		void clean()
			{
			mouse_zone=1;
			throwing=0;
			naming_cave=0;
			viewing_critter=-1;
			}

		main_interfacest()
			{
			clean();
			}
};