//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

koboldst::koboldst(char for_load)
{
	if(!for_load)
		{
		global_id=game.next_kobold_id;
		carried_critter_id=-1;
		game.next_kobold_id++;
		string blank;
		def=game.definition.get_kobold_by_predecessor(blank);
		}

	game.kobold.global.push_back(this);
}

koboldst::~koboldst()
{
	long t;
	for(t=(long)game.kobold.global.size()-1;t>=0;t--)
		{
		if(game.kobold.global[t]==this)
			{
			game.kobold.global.erase(t);
			break;
			}
		}
}

void koboldst::write_file(file_compressorst &filecomp)
{
	filecomp.write_file(global_id);

	filecomp.write_file(carried_critter_id);

	if(filecomp.save_posnull_pointer(def))
		{
		filecomp.write_file(def->token);
		}
}

void koboldst::read_file(file_compressorst &filecomp,long loadversion)
{
	filecomp.read_file(global_id);

	filecomp.read_file(carried_critter_id);

	if(filecomp.load_posnull_pointer())
		{
		string tok;
		filecomp.read_file(tok);
		def=game.definition.get_kobold_by_token(tok);
		}
}

void koboldst::gain_level()
{
	kobold_definitionst *ndef=game.definition.get_kobold_by_predecessor(def->token);
	if(ndef!=NULL)def=ndef;
}