//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

class koboldst
{
	friend class kobold_handlerst;

	public:
		static koboldst *create(){return new koboldst(0);}
		static koboldst *create_for_load(){return new koboldst(1);}

		long global_id;

		long carried_critter_id;

		kobold_definitionst *def;

		void write_file(file_compressorst &filecomp);
		void read_file(file_compressorst &filecomp,long loadversion);

		void gain_level();

	protected:
		koboldst(char for_load);
		~koboldst();
};

class kobold_handlerst
{
	public:
		svector<koboldst *> global;

		void clean()
			{
			while(global.size()>0)remove_kobold(global.size()-1);
			}

		void remove_kobold(int e){delete global[e];}
		void remove_kobold(koboldst *ptr)
			{
			long t;
			for(t=(long)global.size()-1;t>=0;t--)
				{
				if(global[t]==ptr)
					{
					remove_kobold(t);
					break;
					}
				}
			}
		void remove_kobold_by_global_id(long id)
			{
			long t;
			for(t=(long)global.size()-1;t>=0;t--)
				{
				if(global[t]->global_id==id)
					{
					remove_kobold(t);
					break;
					}
				}
			}

		koboldst *get_kobold_by_global_id(long id)
			{
			if(global.size()==0||id==-1)return NULL;

			return binary_get(0,(long)global.size()-1,id);
			}

		koboldst *binary_get(long start,long end,long id)
			{
			if(start>end)return NULL;

			long mid=(start+end)>>1;

			if(global[mid]->global_id==id)return global[mid];
			if(start==end)return NULL;

			if(global[mid]->global_id>id)return binary_get(start,mid-1,id);
			else return binary_get(mid+1,end,id);
			}

		void add_kobold(koboldst *ptr)
			{
			if(ptr==NULL)return;
			long size=global.size();
			long t;
			for(t=0;t<size;t++)
				{
				if(global[t]->global_id==ptr->global_id)return;
				if(global[t]->global_id>ptr->global_id)
					{
					global.insert(t,ptr);
					break;
					}
				}
			if(t==size)global.push_back(ptr);
			}
		
		~kobold_handlerst()
			{
			clean();
			}
};