//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

//public domain RNG stuff by Michael Brundage

void mt_init()
{
    int i;
    for (i = 0; i < MT_LEN; i++)
        mt_buffer[i] = rand()*GetTickCount();
    mt_index = MT_LEN*sizeof(unsigned long);
}

#define MT_IA           397
#define MT_IB           (MT_LEN - MT_IA)
#define UPPER_MASK      0x80000000
#define LOWER_MASK      0x7FFFFFFF
#define MATRIX_A        0x9908B0DF
#define TWIST(b,i,j)    ((b)[i] & UPPER_MASK) | ((b)[j] & LOWER_MASK)
#define MAGIC(s)        (((s)&1)*MATRIX_A)

unsigned long mt_trandom()
{
    unsigned long * b = mt_buffer;
    int idx = mt_index;
    unsigned long s;
    int i;
	
    if (idx == MT_LEN*sizeof(unsigned long))
    {
        idx = 0;
        i = 0;
        for (; i < MT_IB; i++) {
            s = TWIST(b, i, i+1);
            b[i] = b[i + MT_IA] ^ (s >> 1) ^ MAGIC(s);
        }
        for (; i < MT_LEN-1; i++) {
            s = TWIST(b, i, i+1);
            b[i] = b[i - MT_IB] ^ (s >> 1) ^ MAGIC(s);
        }
        
        s = TWIST(b, MT_LEN-1, 0);
        b[MT_LEN-1] = b[MT_IA-1] ^ (s >> 1) ^ MAGIC(s);
    }
    mt_index = idx + sizeof(unsigned long);
     return *(unsigned long *)((unsigned char *)b + idx);
}

//back to my crap - tarn

//picks a random number from 0 to max-1
long loadtrandom(unsigned long max)
{
	unsigned long seed=mt_trandom();
	seed=seed%max;

	return((long)seed);
}

long trandom(unsigned long max)
{
	if(max<=1)return 0;
	unsigned long seed=mt_trandom();
	seed=seed%2147483647LU;
	seed=seed/((2147483647LU/max)+1);

	return((long)seed);
}

void seedst::set_seed()
{
	memmove(mt_buffer,buffer,sizeof(unsigned long)*MT_LEN);
	mt_index=index;
}

seedst::seedst()
{
	grab_seed();
}

void seedst::grab_seed()
{
	memmove(buffer,mt_buffer,sizeof(unsigned long)*MT_LEN);
	index=mt_index;
}

//picks a random number from 0 to max-1
long basic_random(long max)
{
	r_num();

	return (basic_seed/((2147483647L/max)+1));
}

//sets seed to a random number from 0 to 2 billion
void r_num(void)
{
	basic_seed=(basic_seed*907725L+99979777L)%2147483647L;	// was 2147483648
}