//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

#include "game_g.h"
#include "game_extv.h"

unitst::unitst(char for_load)
{
	if(!for_load)
		{
		global_id=game.next_unit_id;
		game.next_unit_id++;
		gx=-1;
		}

	game.unit.global.push_back(this);
}

unitst::~unitst()
{
	long t;
	for(t=(long)game.unit.global.size()-1;t>=0;t--)
		{
		if(game.unit.global[t]==this)
			{
			game.unit.global.erase(t);
			break;
			}
		}
}

void unitst::write_file(file_compressorst &filecomp)
{
	filecomp.write_file(global_id);
	filecomp.write_file(unit_type);
	filecomp.write_file(unit_id);
	filecomp.write_file(x);
	filecomp.write_file(y);
}

void unitst::read_file(file_compressorst &filecomp,long loadversion)
{
	filecomp.read_file(global_id);
	filecomp.read_file(unit_type);
	filecomp.read_file(unit_id);
	filecomp.read_file(x);
	filecomp.read_file(y);
}

void unitst::random_placement()
{
	do
		{
		x=trandom(CAVE_DIM_X-2)+1;
		y=trandom(CAVE_DIM_Y-2)+1;

		if(game.cave.walkable(x,y,this,1))break;

		}while(1);
}

void unitst::entry_way_placement()
{
	if(game.cave.entry_way_x.size()>0)
		{
		long t=trandom(game.cave.entry_way_x.size());
		x=game.cave.entry_way_x[t];
		y=game.cave.entry_way_y[t];
		}
	else random_placement();
}

void unitst::move_randomly()
{
	//IF YOU ALREADY HAVE A PATH, KEEP FOLLOWING IT
	if(path_x.size()>0)
		{
		if(game.cave.walkable(path_x[0],path_y[0],this,1))
			{
			x=path_x[0];
			y=path_y[0];

			path_x.erase(0);
			path_y.erase(0);

			return;
			}
		}

	//OTHERWISE MOVE RANDOMLY
	short sx=0;
	short sy=0;
	if(trandom(2))sx=trandom(2)*2-1;
	else sy=trandom(2)*2-1;

	if(game.cave.walkable(x+sx,y+sy,this,1))
		{
		x=x+sx;
		y=y+sy;
		}
}

void unitst::move_toward(short fgx,short fgy)
{
	if(gx!=fgx||gy!=fgy)
		{
		gx=fgx;
		gy=fgy;
		game.cave.buildpath(x,y,gx,gy,path_x,path_y,this);
		}

	if(path_x.size()>0)
		{
		if(game.cave.walkable(path_x[0],path_y[0],this,1))
			{
			x=path_x[0];
			y=path_y[0];

			path_x.erase(0);
			path_y.erase(0);
			}
		}
}