//Copyright (c) 2006, Tarn Adams
//All rights reserved.  See game.cpp or license.txt for more information.

enum Unit
{
	UNIT_ADVENTURER,
	UNIT_CRITTER,
	UNIT_KOBOLD,
	UNITNUM
};

class unitst
{
	friend class unit_handlerst;

	public:
		static unitst *create(){return new unitst(0);}
		static unitst *create_for_load(){return new unitst(1);}

		long global_id;
		long unit_type;
		long unit_id;

		short x,y;

		svector<short> path_x;
		svector<short> path_y;
		short gx,gy;

		void write_file(file_compressorst &filecomp);
		void read_file(file_compressorst &filecomp,long loadversion);
		
		void random_placement();
		void entry_way_placement();
		void move_randomly();
		void move_toward(short fgx,short fgy);

	protected:
		unitst(char for_load);
		~unitst();
};

class unit_handlerst
{
	public:
		svector<unitst *> global;

		void clean()
			{
			while(global.size()>0)remove_unit(global.size()-1);
			}

		void remove_unit(int e){delete global[e];}
		void remove_unit(unitst *ptr)
			{
			long t;
			for(t=(long)global.size()-1;t>=0;t--)
				{
				if(global[t]==ptr)
					{
					remove_unit(t);
					break;
					}
				}
			}

		unitst *get_unit_by_global_id(long id)
			{
			if(global.size()==0||id==-1)return NULL;

			return binary_get(0,(long)global.size()-1,id);
			}

		unitst *binary_get(long start,long end,long id)
			{
			if(start>end)return NULL;

			long mid=(start+end)>>1;

			if(global[mid]->global_id==id)return global[mid];
			if(start==end)return NULL;

			if(global[mid]->global_id>id)return binary_get(start,mid-1,id);
			else return binary_get(mid+1,end,id);
			}

		void add_unit(unitst *ptr)
			{
			if(ptr==NULL)return;
			long size=global.size();
			long t;
			for(t=0;t<size;t++)
				{
				if(global[t]->global_id==ptr->global_id)return;
				if(global[t]->global_id>ptr->global_id)
					{
					global.insert(t,ptr);
					break;
					}
				}
			if(t==size)global.push_back(ptr);
			}

		unitst *get_unit_by_type_and_id(short type,long id)
			{
			if(global.size()==0||id==-1)return NULL;

			long u;
			for(u=0;u<global.size();u++)
				{
				if(global[u]->unit_type==type&&
					global[u]->unit_id==id)return global[u];
				}
			return NULL;
			}
		
		~unit_handlerst()
			{
			clean();
			}
};