#ifndef GRAPHICS_H
#define GRAPHICS_H

#include <string>
#include <map>
#include <cassert>
#include <variant>
#include <cstring>
#include <filesystem>
using std::string;

#include "g_basics.h"
#include "platform.h"
#include "basics.h"

#define GAME_LOOP_ANIMATION_MAXIMUM 10

#define PALETTE_COLORNUM 18

struct palettest
{
	uint8_t color[PALETTE_COLORNUM*3];

	palettest()
		{
		int32_t c;
		for(c=0;c<PALETTE_COLORNUM*3;++c)color[c]=128;
		}
	void copy_from(palettest &src)
		{
		std::memmove(color,src.color,sizeof(uint8_t)*PALETTE_COLORNUM*3);
		}
};

enum TextureBodypartSkinSurfaceType
{
	TEXTURE_BODYPART_SKIN_SURFACE_HAIR,
	TEXTURE_BODYPART_SKIN_SURFACE_SKIN,
	TEXTURE_BODYPART_SKIN_SURFACE_SCALES,
	TEXTURE_BODYPART_SKIN_SURFACE_FEATHERS,
	TEXTURE_BODYPART_SKIN_SURFACENUM,
	TEXTURE_BODYPART_SKIN_SURFACE_NONE=-1
};
typedef int32_t TextureBodypartSkinSurface;

enum SphereType
{
	SPHERE_AGRICULTURE,
	SPHERE_ANIMALS,
	SPHERE_ART,
	SPHERE_BALANCE,
	SPHERE_BEAUTY,
	SPHERE_BIRTH,
	SPHERE_BLIGHT,
	SPHERE_BOUNDARIES,
	SPHERE_CAVERNS,
	SPHERE_CHAOS,
	SPHERE_CHARITY,
	SPHERE_CHILDREN,
	SPHERE_COASTS,
	SPHERE_CONSOLATION,
	SPHERE_COURAGE,
	SPHERE_CRAFTS,
	SPHERE_CREATION,
	SPHERE_DANCE,
	SPHERE_DARKNESS,
	SPHERE_DAWN,
	SPHERE_DAY,
	SPHERE_DEATH,
	SPHERE_DEFORMITY,
	SPHERE_DEPRAVITY,
	SPHERE_DISCIPLINE,
	SPHERE_DISEASE,
	SPHERE_DREAMS,
	SPHERE_DUSK,
	SPHERE_DUTY,
	SPHERE_EARTH,
	SPHERE_FAMILY,
	SPHERE_FAME,
	SPHERE_FATE,
	SPHERE_FERTILITY,
	SPHERE_FESTIVALS,
	SPHERE_FIRE,
	SPHERE_FISH,
	SPHERE_FISHING,
	SPHERE_FOOD,
	SPHERE_FORGIVENESS,
	SPHERE_FORTRESSES,
	SPHERE_FREEDOM,
	SPHERE_GAMBLING,
	SPHERE_GAMES,
	SPHERE_GENEROSITY,
	SPHERE_HAPPINESS,
	SPHERE_HEALING,
	SPHERE_HOSPITALITY,
	SPHERE_HUNTING,
	SPHERE_INSPIRATION,
	SPHERE_JEALOUSY,
	SPHERE_JEWELS,
	SPHERE_JUSTICE,
	SPHERE_LABOR,
	SPHERE_LAKES,
	SPHERE_LAWS,
	SPHERE_LIES,
	SPHERE_LIGHT,
	SPHERE_LIGHTNING,
	SPHERE_LONGEVITY,
	SPHERE_LOVE,
	SPHERE_LOYALTY,
	SPHERE_LUCK,
	SPHERE_LUST,
	SPHERE_MARRIAGE,
	SPHERE_MERCY,
	SPHERE_METALS,
	SPHERE_MINERALS,
	SPHERE_MISERY,
	SPHERE_MIST,
	SPHERE_MOON,
	SPHERE_MOUNTAINS,
	SPHERE_MUCK,
	SPHERE_MURDER,
	SPHERE_MUSIC,
	SPHERE_NATURE,
	SPHERE_NIGHT,
	SPHERE_NIGHTMARES,
	SPHERE_OATHS,
	SPHERE_OCEANS,
	SPHERE_ORDER,
	SPHERE_PAINTING,
	SPHERE_PEACE,
	SPHERE_PERSUASION,
	SPHERE_PLANTS,
	SPHERE_POETRY,
	SPHERE_PREGNANCY,
	SPHERE_RAIN,
	SPHERE_RAINBOWS,
	SPHERE_REBIRTH,
	SPHERE_REVELRY,
	SPHERE_REVENGE,
	SPHERE_RIVERS,
	SPHERE_RULERSHIP,
	SPHERE_RUMORS,
	SPHERE_SACRIFICE,
	SPHERE_SALT,
	SPHERE_SCHOLARSHIP,
	SPHERE_SEASONS,
	SPHERE_SILENCE,
	SPHERE_SKY,
	SPHERE_SONG,
	SPHERE_SPEECH,
	SPHERE_STARS,
	SPHERE_STORMS,
	SPHERE_STRENGTH,
	SPHERE_SUICIDE,
	SPHERE_SUN,
	SPHERE_THEFT,
	SPHERE_THRALLDOM,
	SPHERE_THUNDER,
	SPHERE_TORTURE,
	SPHERE_TRADE,
	SPHERE_TRAVELERS,
	SPHERE_TREACHERY,
	SPHERE_TREES,
	SPHERE_TRICKERY,
	SPHERE_TRUTH,
	SPHERE_TWILIGHT,
	SPHERE_VALOR,
	SPHERE_VICTORY,
	SPHERE_VOLCANOS,
	SPHERE_WAR,
	SPHERE_WATER,
	SPHERE_WEALTH,
	SPHERE_WEATHER,
	SPHERE_WIND,
	SPHERE_WISDOM,
	SPHERE_WRITING,
	SPHERE_YOUTH,
	SPHERENUM,
	SPHERE_NONE=-1
};
typedef int16_t Sphere;

extern const unordered_bimap<string,Sphere> SPHERESTRINGS; // hopefully we never need gods of strings

enum RamHeadType
{
	RAM_HEAD_TREE,
	RAM_HEAD_BULL,
	RAM_HEAD_RHINO,
	RAM_HEAD_DRAGON,
	RAM_HEAD_HORNS,
	RAM_HEAD_GRID,
	RAM_HEADNUM,
	RAM_HEAD_NONE=-1
};
typedef int32_t RamHead;

enum EngravingIntentType
{
	ENGRAVING_INTENT_MEMORIAL,
	ENGRAVING_INTENT_UNUSED_01,//
	ENGRAVING_INTENT_UNUSED_02,//
	ENGRAVING_INTENT_UNUSED_03,//
	ENGRAVING_INTENT_UNUSED_04,//
	ENGRAVING_INTENT_UNUSED_05,//
	ENGRAVING_INTENT_SECRET,
	ENGRAVING_INTENT_SRB_SHOP_IMPORT_FOOD,
	ENGRAVING_INTENT_SRB_SHOP_IMPORT_CLOTHING,
	ENGRAVING_INTENT_SRB_SHOP_IMPORT_GENERAL,
	ENGRAVING_INTENT_SRB_SHOP_CLOTH,
	ENGRAVING_INTENT_SRB_SHOP_TANNING,
	ENGRAVING_INTENT_SRB_SHOP_CLOTHING_CLOTH,
	ENGRAVING_INTENT_SRB_SHOP_CLOTHING_LEATHER,
	ENGRAVING_INTENT_SRB_SHOP_CRAFTS_BONE_CARVER,
	ENGRAVING_INTENT_SRB_SHOP_GEM_CUTTER,
	ENGRAVING_INTENT_SRB_SHOP_METAL_WEAPON_SMITH,
	ENGRAVING_INTENT_SRB_SHOP_WOOD_WEAPON_SMITH,
	ENGRAVING_INTENT_SRB_SHOP_BLACK_SMITH,
	ENGRAVING_INTENT_SRB_SHOP_METAL_ARMOR_SMITH,
	ENGRAVING_INTENT_SRB_SHOP_METAL_CRAFTER,
	ENGRAVING_INTENT_SRB_SHOP_LEATHER_ACCESSORIES,
	ENGRAVING_INTENT_SRB_SHOP_FURNITURE_WOOD,
	ENGRAVING_INTENT_SRB_SHOP_FURNITURE_STONE,
	ENGRAVING_INTENT_SRB_SHOP_FURNITURE_METAL,
	ENGRAVING_INTENT_AB_TAVERN,
	ENGRAVING_INTENT_TRUE_NAME,
	ENGRAVING_INTENTNUM,
	ENGRAVING_INTENT_NONE=-1
};
typedef int16_t EngravingIntent;

enum CombatAnimationSwishType
{
	COMBAT_ANIMATION_SWISH_HIT,
	COMBAT_ANIMATION_SWISH_MISS,
	COMBAT_ANIMATION_SWISH_BLOCK,
	COMBAT_ANIMATION_SWISH_PARRY,
	COMBAT_ANIMATION_SWISH_DIG,
	COMBAT_ANIMATION_SWISHNUM,
	COMBAT_ANIMATION_SWISH_NONE=-1
};
typedef int32_t CombatAnimationSwish;

enum CombatAnimationSwishDirectionType
{
	COMBAT_ANIMATION_SWISH_DIRECTION_N,
	COMBAT_ANIMATION_SWISH_DIRECTION_S,
	COMBAT_ANIMATION_SWISH_DIRECTION_W,
	COMBAT_ANIMATION_SWISH_DIRECTION_E,
	COMBAT_ANIMATION_SWISH_DIRECTION_NW,
	COMBAT_ANIMATION_SWISH_DIRECTION_NE,
	COMBAT_ANIMATION_SWISH_DIRECTION_SW,
	COMBAT_ANIMATION_SWISH_DIRECTION_SE,
	COMBAT_ANIMATION_SWISH_DIRECTIONNUM,
	COMBAT_ANIMATION_SWISH_DIRECTION_NONE=-1
};
typedef int32_t CombatAnimationSwishDirection;

#define COMBAT_ANIMATION_SWISH_FRAME_COUNT 4
#define COMBAT_ANIMATION_SWISH_FRAME_LENGTH_MS 100

enum CombatAnimationRamDirectionType
{
	COMBAT_ANIMATION_RAM_DIRECTION_N,
	COMBAT_ANIMATION_RAM_DIRECTION_E,
	COMBAT_ANIMATION_RAM_DIRECTION_S,
	COMBAT_ANIMATION_RAM_DIRECTION_W,
	COMBAT_ANIMATION_RAM_DIRECTIONNUM,
	COMBAT_ANIMATION_RAM_DIRECTION_NONE=-1
};
typedef int32_t CombatAnimationRamDirection;

#define COMBAT_ANIMATION_RAM_FRAME_COUNT 4
#define COMBAT_ANIMATION_RAM_FRAME_LENGTH_MS 100

enum GraphicsTrackingSymbolWeightType
{
	GRAPHICS_TRACKING_SYMBOL_WEIGHT_HEAVY,
	GRAPHICS_TRACKING_SYMBOL_WEIGHT_MID,
	GRAPHICS_TRACKING_SYMBOL_WEIGHT_LIGHT,
	GRAPHICS_TRACKING_SYMBOL_WEIGHT_VAGUE,
	GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM,
	GRAPHICS_TRACKING_SYMBOL_WEIGHT_NONE=-1
};
typedef int32_t GraphicsTrackingSymbolWeight;

enum GraphicsTrackingSymbolDirType
{
	GRAPHICS_TRACKING_SYMBOL_DIR_N,
	GRAPHICS_TRACKING_SYMBOL_DIR_S,
	GRAPHICS_TRACKING_SYMBOL_DIR_W,
	GRAPHICS_TRACKING_SYMBOL_DIR_E,
	GRAPHICS_TRACKING_SYMBOL_DIR_NW,
	GRAPHICS_TRACKING_SYMBOL_DIR_NE,
	GRAPHICS_TRACKING_SYMBOL_DIR_SW,
	GRAPHICS_TRACKING_SYMBOL_DIR_SE,
	GRAPHICS_TRACKING_SYMBOL_DIRNUM,
	GRAPHICS_TRACKING_SYMBOL_DIR_NONE=-1
};
typedef int32_t GraphicsTrackingSymbolDir;

enum MoveIndicatorType
{
	MOVE_INDICATOR_MOVE,
	MOVE_INDICATOR_ATTACK,
	MOVE_INDICATOR_DODGE_AWAY,
	MOVE_INDICATORNUM,
	MOVE_INDICATOR_NONE=-1
};
typedef int32_t MoveIndicator;

enum MoveIndicatorDirectionType
{
	MOVE_INDICATOR_DIRECTION_N,
	MOVE_INDICATOR_DIRECTION_S,
	MOVE_INDICATOR_DIRECTION_W,
	MOVE_INDICATOR_DIRECTION_E,
	MOVE_INDICATOR_DIRECTION_NW,
	MOVE_INDICATOR_DIRECTION_NE,
	MOVE_INDICATOR_DIRECTION_SW,
	MOVE_INDICATOR_DIRECTION_SE,
	MOVE_INDICATOR_DIRECTIONNUM,
	MOVE_INDICATOR_DIRECTION_NONE=-1
};
typedef int32_t MoveIndicatorDirection;

#define MOVE_INDICATOR_FRAME_COUNT 4

enum GraphicsSoundIndicatorType
{
	GRAPHICS_SOUND_INDICATOR_MOVEMENT_SMALL,
	GRAPHICS_SOUND_INDICATOR_MOVEMENT_LARGE,
	GRAPHICS_SOUND_INDICATOR_COMBAT_SMALL,
	GRAPHICS_SOUND_INDICATOR_COMBAT_LARGE,
	GRAPHICS_SOUND_INDICATOR_VOCALIZATION_SMALL,
	GRAPHICS_SOUND_INDICATOR_VOCALIZATION_LARGE,
	GRAPHICS_SOUND_INDICATOR_GRINDING_MECHANISM_SMALL,
	GRAPHICS_SOUND_INDICATOR_GRINDING_MECHANISM_LARGE,
	GRAPHICS_SOUND_INDICATOR_STORYTELLING,
	GRAPHICS_SOUND_INDICATOR_POEM_RECITATION,
	GRAPHICS_SOUND_INDICATOR_MUSICAL_VOICE,
	GRAPHICS_SOUND_INDICATOR_DANCING,
	GRAPHICS_SOUND_INDICATOR_PREACHING,
	GRAPHICS_SOUND_INDICATOR_MOVEMENT_SMALL_OLD,
	GRAPHICS_SOUND_INDICATOR_MOVEMENT_LARGE_OLD,
	GRAPHICS_SOUND_INDICATOR_COMBAT_SMALL_OLD,
	GRAPHICS_SOUND_INDICATOR_COMBAT_LARGE_OLD,
	GRAPHICS_SOUND_INDICATOR_VOCALIZATION_SMALL_OLD,
	GRAPHICS_SOUND_INDICATOR_VOCALIZATION_LARGE_OLD,
	GRAPHICS_SOUND_INDICATOR_GRINDING_MECHANISM_SMALL_OLD,
	GRAPHICS_SOUND_INDICATOR_GRINDING_MECHANISM_LARGE_OLD,
	GRAPHICS_SOUND_INDICATOR_STORYTELLING_OLD,
	GRAPHICS_SOUND_INDICATOR_POEM_RECITATION_OLD,
	GRAPHICS_SOUND_INDICATOR_MUSICAL_VOICE_OLD,
	GRAPHICS_SOUND_INDICATOR_DANCING_OLD,
	GRAPHICS_SOUND_INDICATOR_PREACHING_OLD,
	GRAPHICS_SOUND_INDICATORNUM,
	GRAPHICS_SOUND_INDICATOR_NONE=-1
};
typedef int32_t GraphicsSoundIndicator;

enum PCGLayeringType
{
	PCG_LAYERING_BEAST_AMORPHOUS,
	PCG_LAYERING_BEAST_AMORPHOUS_SHELL_BACK,

	PCG_LAYERING_BEAST_SNAKE,
	PCG_LAYERING_BEAST_SNAKE_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_SNAKE_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_SNAKE_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SNAKE_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SNAKE_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SNAKE_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SNAKE_EYE_ONE,
	PCG_LAYERING_BEAST_SNAKE_EYE_TWO,
	PCG_LAYERING_BEAST_SNAKE_EYE_THREE,
	PCG_LAYERING_BEAST_SNAKE_SHELL_BACK,
	PCG_LAYERING_BEAST_SNAKE_TRUNK,
	PCG_LAYERING_BEAST_SNAKE_ANTENNAE,

	PCG_LAYERING_BEAST_WORM_LONG,
	PCG_LAYERING_BEAST_WORM_LONG_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_WORM_LONG_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_WORM_LONG_EYE_ONE,
	PCG_LAYERING_BEAST_WORM_LONG_EYE_TWO,
	PCG_LAYERING_BEAST_WORM_LONG_EYE_THREE,
	PCG_LAYERING_BEAST_WORM_LONG_SHELL_BACK,
	PCG_LAYERING_BEAST_WORM_LONG_TRUNK,
	PCG_LAYERING_BEAST_WORM_LONG_ANTENNAE,

	PCG_LAYERING_BEAST_WORM_SHORT,
	PCG_LAYERING_BEAST_WORM_SHORT_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_WORM_SHORT_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_WORM_SHORT_EYE_ONE,
	PCG_LAYERING_BEAST_WORM_SHORT_EYE_TWO,
	PCG_LAYERING_BEAST_WORM_SHORT_EYE_THREE,
	PCG_LAYERING_BEAST_WORM_SHORT_SHELL_BACK,
	PCG_LAYERING_BEAST_WORM_SHORT_TRUNK,
	PCG_LAYERING_BEAST_WORM_SHORT_ANTENNAE,

	PCG_LAYERING_BEAST_INSECT,
	PCG_LAYERING_BEAST_INSECT_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_INSECT_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_INSECT_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_INSECT_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_INSECT_EYE_ONE,
	PCG_LAYERING_BEAST_INSECT_EYE_TWO,
	PCG_LAYERING_BEAST_INSECT_EYE_THREE,
	PCG_LAYERING_BEAST_INSECT_PROBOSCIS,
	PCG_LAYERING_BEAST_INSECT_SHELL_FRONT,
	PCG_LAYERING_BEAST_INSECT_TRUNK,
	PCG_LAYERING_BEAST_INSECT_ANTENNAE,

	PCG_LAYERING_BEAST_SPIDER,
	PCG_LAYERING_BEAST_SPIDER_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_SPIDER_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_SPIDER_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SPIDER_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SPIDER_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SPIDER_EYE_ONE,
	PCG_LAYERING_BEAST_SPIDER_EYE_TWO,
	PCG_LAYERING_BEAST_SPIDER_EYE_THREE,
	PCG_LAYERING_BEAST_SPIDER_SHELL_FRONT,
	PCG_LAYERING_BEAST_SPIDER_TRUNK,
	PCG_LAYERING_BEAST_SPIDER_ANTENNAE,

	PCG_LAYERING_BEAST_SCORPION,
	PCG_LAYERING_BEAST_SCORPION_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_SCORPION_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_SCORPION_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SCORPION_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SCORPION_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SCORPION_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SCORPION_EYE_ONE,
	PCG_LAYERING_BEAST_SCORPION_EYE_TWO,
	PCG_LAYERING_BEAST_SCORPION_EYE_THREE,
	PCG_LAYERING_BEAST_SCORPION_TAIL_ONE,
	PCG_LAYERING_BEAST_SCORPION_TAIL_TWO,
	PCG_LAYERING_BEAST_SCORPION_TAIL_THREE,
	PCG_LAYERING_BEAST_SCORPION_SHELL_FRONT,
	PCG_LAYERING_BEAST_SCORPION_TRUNK,
	PCG_LAYERING_BEAST_SCORPION_ANTENNAE,

	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_EYE_ONE,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_EYE_TWO,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_EYE_THREE,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_TAIL_ONE,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_TAIL_TWO,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_TAIL_THREE,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_SHELL_FRONT,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_TRUNK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_ANTENNAE,

	PCG_LAYERING_BEAST_HUMANOID,
	PCG_LAYERING_BEAST_HUMANOID_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_HUMANOID_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_HUMANOID_EYE_ONE,
	PCG_LAYERING_BEAST_HUMANOID_EYE_TWO,
	PCG_LAYERING_BEAST_HUMANOID_EYE_THREE,
	PCG_LAYERING_BEAST_HUMANOID_TAIL_ONE,
	PCG_LAYERING_BEAST_HUMANOID_TAIL_TWO,
	PCG_LAYERING_BEAST_HUMANOID_TAIL_THREE,
	PCG_LAYERING_BEAST_HUMANOID_SHELL_BACK,
	PCG_LAYERING_BEAST_HUMANOID_TRUNK,
	PCG_LAYERING_BEAST_HUMANOID_ANTENNAE,

	PCG_LAYERING_BEAST_FRONT_GRASP,
	PCG_LAYERING_BEAST_FRONT_GRASP_HEX,
	PCG_LAYERING_BEAST_FRONT_GRASP_OCT,
	PCG_LAYERING_BEAST_FRONT_GRASP_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_FRONT_GRASP_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_FRONT_GRASP_EYE_ONE,
	PCG_LAYERING_BEAST_FRONT_GRASP_EYE_TWO,
	PCG_LAYERING_BEAST_FRONT_GRASP_EYE_THREE,
	PCG_LAYERING_BEAST_FRONT_GRASP_TAIL_ONE,
	PCG_LAYERING_BEAST_FRONT_GRASP_TAIL_TWO,
	PCG_LAYERING_BEAST_FRONT_GRASP_TAIL_THREE,
	PCG_LAYERING_BEAST_FRONT_GRASP_SHELL_BACK,
	PCG_LAYERING_BEAST_FRONT_GRASP_TRUNK,
	PCG_LAYERING_BEAST_FRONT_GRASP_ANTENNAE,

	PCG_LAYERING_BEAST_QUADRUPED_BULKY,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_HEX,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_OCT,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_EYE_ONE,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_EYE_TWO,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_EYE_THREE,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_TAIL_ONE,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_TAIL_TWO,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_TAIL_THREE,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_SHELL_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_TRUNK,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_ANTENNAE,

	PCG_LAYERING_BEAST_QUADRUPED_SLINKY,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_HEX,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_OCT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_EYE_ONE,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_EYE_TWO,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_EYE_THREE,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_TAIL_ONE,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_TAIL_TWO,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_TAIL_THREE,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_SHELL_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_TRUNK,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_ANTENNAE,

	PCG_LAYERING_BEAST_WALRUS,
	PCG_LAYERING_BEAST_WALRUS_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_WALRUS_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_WALRUS_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_WALRUS_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_WALRUS_EYE_ONE,
	PCG_LAYERING_BEAST_WALRUS_EYE_TWO,
	PCG_LAYERING_BEAST_WALRUS_EYE_THREE,
	PCG_LAYERING_BEAST_WALRUS_TAIL_ONE,
	PCG_LAYERING_BEAST_WALRUS_TAIL_TWO,
	PCG_LAYERING_BEAST_WALRUS_TAIL_THREE,
	PCG_LAYERING_BEAST_WALRUS_SHELL_BACK,
	PCG_LAYERING_BEAST_WALRUS_TRUNK,
	PCG_LAYERING_BEAST_WALRUS_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_AMORPHOUS,
	PCG_LAYERING_BEAST_SMALL_AMORPHOUS_SHELL_BACK,

	PCG_LAYERING_BEAST_SMALL_SNAKE,
	PCG_LAYERING_BEAST_SMALL_SNAKE_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_SNAKE_HORNS,
	PCG_LAYERING_BEAST_SMALL_SNAKE_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_SNAKE_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_SNAKE_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_SNAKE_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_SNAKE_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_SNAKE_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_SNAKE_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_SNAKE_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_SNAKE_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_SNAKE_SHELL_BACK,
	PCG_LAYERING_BEAST_SMALL_SNAKE_TRUNK,
	PCG_LAYERING_BEAST_SMALL_SNAKE_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_WORM_LONG,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_HORNS,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_SHELL_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_TRUNK,
	PCG_LAYERING_BEAST_SMALL_WORM_LONG_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_WORM_SHORT,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_HORNS,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_SHELL_BACK,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_TRUNK,
	PCG_LAYERING_BEAST_SMALL_WORM_SHORT_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_INSECT,
	PCG_LAYERING_BEAST_SMALL_INSECT_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_INSECT_HORNS,
	PCG_LAYERING_BEAST_SMALL_INSECT_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_INSECT_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_INSECT_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_INSECT_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_INSECT_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_INSECT_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_INSECT_PROBOSCIS,
	PCG_LAYERING_BEAST_SMALL_INSECT_SHELL_FRONT,
	PCG_LAYERING_BEAST_SMALL_INSECT_TRUNK,
	PCG_LAYERING_BEAST_SMALL_INSECT_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_SPIDER,
	PCG_LAYERING_BEAST_SMALL_SPIDER_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_SPIDER_HORNS,
	PCG_LAYERING_BEAST_SMALL_SPIDER_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_SPIDER_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_SPIDER_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_SPIDER_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_SPIDER_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_SPIDER_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_SPIDER_SHELL_FRONT,
	PCG_LAYERING_BEAST_SMALL_SPIDER_TRUNK,
	PCG_LAYERING_BEAST_SMALL_SPIDER_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_SCORPION,
	PCG_LAYERING_BEAST_SMALL_SCORPION_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_SCORPION_HORNS,
	PCG_LAYERING_BEAST_SMALL_SCORPION_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_SCORPION_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_SCORPION_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_SCORPION_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_SCORPION_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_SCORPION_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_SCORPION_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_SCORPION_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_SCORPION_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_SCORPION_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_SCORPION_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_SCORPION_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_SCORPION_SHELL_FRONT,
	PCG_LAYERING_BEAST_SMALL_SCORPION_TRUNK,
	PCG_LAYERING_BEAST_SMALL_SCORPION_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_HORNS,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_SHELL_FRONT,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_TRUNK,
	PCG_LAYERING_BEAST_SMALL_BIPEDAL_DINOSAUR_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_HUMANOID,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_HORNS,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_SHELL_BACK,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_TRUNK,
	PCG_LAYERING_BEAST_SMALL_HUMANOID_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_HEX,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_OCT,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_HORNS,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_SHELL_BACK,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_TRUNK,
	PCG_LAYERING_BEAST_SMALL_FRONT_GRASP_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_HEX,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_OCT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_HORNS,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_SHELL_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_TRUNK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_BULKY_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_HEX,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_OCT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_HORNS,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_SHELL_FRONT,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_TRUNK,
	PCG_LAYERING_BEAST_SMALL_QUADRUPED_SLINKY_ANTENNAE,

	PCG_LAYERING_BEAST_SMALL_WALRUS,
	PCG_LAYERING_BEAST_SMALL_WALRUS_MANDIBLES,
	PCG_LAYERING_BEAST_SMALL_WALRUS_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SMALL_WALRUS_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_SMALL_WALRUS_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SMALL_WALRUS_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_SMALL_WALRUS_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SMALL_WALRUS_EYE_ONE,
	PCG_LAYERING_BEAST_SMALL_WALRUS_EYE_TWO,
	PCG_LAYERING_BEAST_SMALL_WALRUS_EYE_THREE,
	PCG_LAYERING_BEAST_SMALL_WALRUS_TAIL_ONE,
	PCG_LAYERING_BEAST_SMALL_WALRUS_TAIL_TWO,
	PCG_LAYERING_BEAST_SMALL_WALRUS_TAIL_THREE,
	PCG_LAYERING_BEAST_SMALL_WALRUS_SHELL_BACK,
	PCG_LAYERING_BEAST_SMALL_WALRUS_TRUNK,
	PCG_LAYERING_BEAST_SMALL_WALRUS_ANTENNAE,

	/*
	PCG_LAYERING_NIGHT_TROLL_BODY_EYELESS,
	PCG_LAYERING_NIGHT_TROLL_BODY_ONE_EYE,
	PCG_LAYERING_NIGHT_TROLL_BODY_TWO_EYES,
	PCG_LAYERING_NIGHT_TROLL_BODY_THREE_EYES,
	PCG_LAYERING_NIGHT_TROLL_BODY_HAIRY,
	PCG_LAYERING_NIGHT_TROLL_BODY_SCALY,
	PCG_LAYERING_NIGHT_TROLL_BODY_SKINLESS,
	PCG_LAYERING_NIGHT_TROLL_BODY_FEATHERED,
	PCG_LAYERING_NIGHT_TROLL_TAIL_THIN_1,
	PCG_LAYERING_NIGHT_TROLL_TAIL_THIN_2,
	PCG_LAYERING_NIGHT_TROLL_TAIL_THIN_3,
	PCG_LAYERING_NIGHT_TROLL_TAIL_THICK_1,
	PCG_LAYERING_NIGHT_TROLL_TAIL_THICK_2,
	PCG_LAYERING_NIGHT_TROLL_TAIL_THICK_3,
	PCG_LAYERING_NIGHT_TROLL_WINGS_FEATHERED,
	PCG_LAYERING_NIGHT_TROLL_WINGS_SKIN,
	PCG_LAYERING_NIGHT_TROLL_HORN_SHORT_1,
	PCG_LAYERING_NIGHT_TROLL_HORN_SHORT_2,
	PCG_LAYERING_NIGHT_TROLL_HORN_SHORT_3,
	PCG_LAYERING_NIGHT_TROLL_HORN_SHORT_4,
	PCG_LAYERING_NIGHT_TROLL_HORN_SPIRAL_1,
	PCG_LAYERING_NIGHT_TROLL_HORN_SPIRAL_2,
	PCG_LAYERING_NIGHT_TROLL_HORN_SPIRAL_3,
	PCG_LAYERING_NIGHT_TROLL_HORN_SPIRAL_4,
	PCG_LAYERING_NIGHT_TROLL_HORN_LONG_1,
	PCG_LAYERING_NIGHT_TROLL_HORN_LONG_2,
	PCG_LAYERING_NIGHT_TROLL_HORN_LONG_3,
	PCG_LAYERING_NIGHT_TROLL_HORN_LONG_4,
	PCG_LAYERING_NIGHT_TROLL_HORN_CURVED_1,
	PCG_LAYERING_NIGHT_TROLL_HORN_CURVED_2,
	PCG_LAYERING_NIGHT_TROLL_HORN_CURVED_3,
	PCG_LAYERING_NIGHT_TROLL_HORN_CURVED_4,
	PCG_LAYERING_NIGHT_TROLL_TRUNK_LONG,
	PCG_LAYERING_NIGHT_TROLL_TRUNK_SHORT,
	*/

	PCG_LAYERING_WEREBEAST_ANTEATER,
	PCG_LAYERING_WEREBEAST_ANTELOPE,
	PCG_LAYERING_WEREBEAST_APE,
	PCG_LAYERING_WEREBEAST_ARMADILLO,
	PCG_LAYERING_WEREBEAST_BADGER,
	PCG_LAYERING_WEREBEAST_BEAR,
	PCG_LAYERING_WEREBEAST_BEAVER,
	PCG_LAYERING_WEREBEAST_BISON,
	PCG_LAYERING_WEREBEAST_BUFFALO,
	PCG_LAYERING_WEREBEAST_BULL,
	PCG_LAYERING_WEREBEAST_CAPYBARA,
	PCG_LAYERING_WEREBEAST_CAMEL,
	PCG_LAYERING_WEREBEAST_CAT,
	PCG_LAYERING_WEREBEAST_CAVY,
	PCG_LAYERING_WEREBEAST_CHAMELEON,
	PCG_LAYERING_WEREBEAST_CHINCHILLA,
	PCG_LAYERING_WEREBEAST_CIVET,
	PCG_LAYERING_WEREBEAST_COATI,
	PCG_LAYERING_WEREBEAST_COYOTE,
	PCG_LAYERING_WEREBEAST_DEER,
	PCG_LAYERING_WEREBEAST_DONKEY,
	PCG_LAYERING_WEREBEAST_ELEPHANT,
	PCG_LAYERING_WEREBEAST_ELK,
	PCG_LAYERING_WEREBEAST_FOX,
	PCG_LAYERING_WEREBEAST_GECKO,
	PCG_LAYERING_WEREBEAST_GILA_MONSTER,
	PCG_LAYERING_WEREBEAST_GIRAFFE,
	PCG_LAYERING_WEREBEAST_GOAT,
	PCG_LAYERING_WEREBEAST_GOPHER,
	PCG_LAYERING_WEREBEAST_HARE,
	PCG_LAYERING_WEREBEAST_HEDGEHOG,
	PCG_LAYERING_WEREBEAST_HORSE,
	PCG_LAYERING_WEREBEAST_HYENA,
	PCG_LAYERING_WEREBEAST_IGUANA,
	PCG_LAYERING_WEREBEAST_JACKAL,
	PCG_LAYERING_WEREBEAST_KANGAROO,
	PCG_LAYERING_WEREBEAST_KOALA,
	PCG_LAYERING_WEREBEAST_LEMUR,
	PCG_LAYERING_WEREBEAST_LIZARD,
	PCG_LAYERING_WEREBEAST_LLAMA,
	PCG_LAYERING_WEREBEAST_LORIS,
	PCG_LAYERING_WEREBEAST_MAMMOTH,
	PCG_LAYERING_WEREBEAST_MARMOT,
	PCG_LAYERING_WEREBEAST_MOLE,
	PCG_LAYERING_WEREBEAST_MONGOOSE,
	PCG_LAYERING_WEREBEAST_MONITOR_LIZARD,
	PCG_LAYERING_WEREBEAST_MOOSE,
	PCG_LAYERING_WEREBEAST_MONKEY,
	PCG_LAYERING_WEREBEAST_MOUSE,
	PCG_LAYERING_WEREBEAST_OPOSSUM,
	PCG_LAYERING_WEREBEAST_PANDA,
	PCG_LAYERING_WEREBEAST_PANGOLIN,
	PCG_LAYERING_WEREBEAST_PANTHER,
	PCG_LAYERING_WEREBEAST_PIG,
	PCG_LAYERING_WEREBEAST_PORCUPINE,
	PCG_LAYERING_WEREBEAST_RABBIT,
	PCG_LAYERING_WEREBEAST_RACCOON,
	PCG_LAYERING_WEREBEAST_RAT,
	PCG_LAYERING_WEREBEAST_RHINOCEROS,
	PCG_LAYERING_WEREBEAST_SHEEP,
	PCG_LAYERING_WEREBEAST_SHREW,
	PCG_LAYERING_WEREBEAST_SKINK,
	PCG_LAYERING_WEREBEAST_SKUNK,
	PCG_LAYERING_WEREBEAST_SLOTH,
	PCG_LAYERING_WEREBEAST_SQUIRREL,
	PCG_LAYERING_WEREBEAST_TAPIR,
	PCG_LAYERING_WEREBEAST_TORTOISE,
	PCG_LAYERING_WEREBEAST_WARTHOG,
	PCG_LAYERING_WEREBEAST_WEASEL,
	PCG_LAYERING_WEREBEAST_WOLF,
	PCG_LAYERING_WEREBEAST_WOMBAT,
	PCG_LAYERING_WEREBEAST_ZEBRA,

	PCG_LAYERING_EXPERIMENT_HUMANOID_SHADOW,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HEAD_SKIN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HEAD_SCALES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HEAD_FEATHERS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HEAD_FUR,
	PCG_LAYERING_EXPERIMENT_HUMANOID_MOUTH,
	PCG_LAYERING_EXPERIMENT_HUMANOID_MANDIBLES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_TRUNK,
	PCG_LAYERING_EXPERIMENT_HUMANOID_ANTENNAE,
	PCG_LAYERING_EXPERIMENT_HUMANOID_EYE_ONE,
	PCG_LAYERING_EXPERIMENT_HUMANOID_EYE_TWO,
	PCG_LAYERING_EXPERIMENT_HUMANOID_EYE_THREE,
	PCG_LAYERING_EXPERIMENT_HUMANOID_TORSO_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_TORSO_SKIN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_TORSO_SCALES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_TORSO_FEATHERS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_TORSO_FUR,
	PCG_LAYERING_EXPERIMENT_HUMANOID_EXTERNAL_RIBS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_FOOT_LEFT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_FOOT_RIGHT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HAND_LEFT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HAND_RIGHT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_LEG_LEFT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_LEG_RIGHT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_ARM_LEFT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_ARM_RIGHT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_SPIRAL_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_CURVING_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_SHORT_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_STUBBY_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_BROAD_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_STRAIGHT_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_SPIRAL_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_CURVING_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_SHORT_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_STUBBY_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_BROAD_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_STRAIGHT_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_SPIRAL_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_CURVING_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_SHORT_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_STUBBY_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_BROAD_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_STRAIGHT_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_SPIRAL_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_CURVING_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_SHORT_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_STUBBY_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_BROAD_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_STRAIGHT_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_SPIRAL_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_CURVING_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_SHORT_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_STUBBY_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_BROAD_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_HORN_LONG_STRAIGHT_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_WINGS_LACY,
	PCG_LAYERING_EXPERIMENT_HUMANOID_WINGS_FEATHERED,
	PCG_LAYERING_EXPERIMENT_HUMANOID_WINGS_BAT,

	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TORSO_FUR,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TORSO_FEATHERS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TORSO_SCALES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TORSO_SKIN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TORSO_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_EXTERNAL_RIBS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_LEFT_FUR,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_LEFT_FEATHERS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_LEFT_SCALES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_LEFT_SKIN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_LEFT_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_RIGHT_FUR,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_RIGHT_FEATHERS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_RIGHT_SCALES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_RIGHT_SKIN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ARM_RIGHT_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_FUR,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_FEATHERS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_SCALES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_SKIN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_MOUTH,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_MOUTH_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_MANDIBLES,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_MANDIBLES_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_EYE_ONE,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_EYE_ONE_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_EYE_TWO,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_EYE_TWO_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_EYE_THREE,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HEAD_EYE_THREE_SKINLESS,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TRUNK_LONG,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TRUNK_SHORT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TRUNK_FAT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TRUNK_TWISTING,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TRUNK_CURLING,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_TRUNK_KNOBBY,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_LEFT_LONG,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_LEFT_FAN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_LEFT_SPINDLY,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_LEFT_SQUAT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_LEFT_BRANCHING,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_LEFT_KNOBBING,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_RIGHT_LONG,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_RIGHT_FAN,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_RIGHT_SPINDLY,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_RIGHT_SQUAT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_RIGHT_BRANCHING,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_ANTENNA_RIGHT_KNOBBING,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_WING_LEFT_LACY,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_WING_LEFT_FEATHERED,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_WING_LEFT_BAT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_WING_RIGHT_LACY,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_WING_RIGHT_FEATHERED,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_WING_RIGHT_BAT,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_SPIRAL_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_CURVING_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_SHORT_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_STUBBY_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_BROAD_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_STRAIGHT_1,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_SPIRAL_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_CURVING_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_SHORT_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_STUBBY_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_BROAD_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_STRAIGHT_2,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_SPIRAL_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_CURVING_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_SHORT_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_STUBBY_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_BROAD_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_STRAIGHT_3,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_SPIRAL_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_CURVING_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_SHORT_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_STUBBY_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_BROAD_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_STRAIGHT_4,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_SPIRAL_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_CURVING_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_SHORT_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_STUBBY_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_BROAD_5,
	PCG_LAYERING_EXPERIMENT_HUMANOID_PORTRAIT_HORN_LONG_STRAIGHT_5,

	PCG_LAYERING_BEAST_ORGANIC_AMORPHOUS,
	PCG_LAYERING_BEAST_ORGANIC_AMORPHOUS_SHELL_BACK,

	PCG_LAYERING_BEAST_ORGANIC_SNAKE,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_SHELL_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_SHELL_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_SHELL_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_INSECT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_PROBOSCIS,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_SHELL_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_SPIDER,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_SHELL_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_SCORPION,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_SHELL_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_SHELL_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_HUMANOID,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_SHELL_BACK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_HEX,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_OCT,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_SHELL_BACK,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_HEX,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_OCT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_SHELL_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_HEX,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_OCT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_SHELL_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_ANTENNAE,

	PCG_LAYERING_BEAST_ORGANIC_WALRUS,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_MANDIBLES_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_EYE_ONE,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_EYE_TWO,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_EYE_THREE,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_TAIL_ONE,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_TAIL_TWO,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_TAIL_THREE,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_SHELL_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_TRUNK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_ANTENNAE,

	PCG_LAYERING_BEAST_AMORPHOUS_DECORATION_1,
	PCG_LAYERING_BEAST_AMORPHOUS_DECORATION_2,
	PCG_LAYERING_BEAST_AMORPHOUS_DECORATION_3,
	PCG_LAYERING_BEAST_AMORPHOUS_DECORATION_4,
	PCG_LAYERING_BEAST_AMORPHOUS_DECORATION_5,

	PCG_LAYERING_BEAST_SNAKE_DECORATION_1,
	PCG_LAYERING_BEAST_SNAKE_DECORATION_2,
	PCG_LAYERING_BEAST_SNAKE_DECORATION_3,
	PCG_LAYERING_BEAST_SNAKE_DECORATION_4,
	PCG_LAYERING_BEAST_SNAKE_DECORATION_5,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_SNAKE_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_WORM_LONG_DECORATION_1,
	PCG_LAYERING_BEAST_WORM_LONG_DECORATION_2,
	PCG_LAYERING_BEAST_WORM_LONG_DECORATION_3,
	PCG_LAYERING_BEAST_WORM_LONG_DECORATION_4,
	PCG_LAYERING_BEAST_WORM_LONG_DECORATION_5,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_WORM_LONG_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_WORM_SHORT_DECORATION_1,
	PCG_LAYERING_BEAST_WORM_SHORT_DECORATION_2,
	PCG_LAYERING_BEAST_WORM_SHORT_DECORATION_3,
	PCG_LAYERING_BEAST_WORM_SHORT_DECORATION_4,
	PCG_LAYERING_BEAST_WORM_SHORT_DECORATION_5,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_INSECT_DECORATION_1,
	PCG_LAYERING_BEAST_INSECT_DECORATION_2,
	PCG_LAYERING_BEAST_INSECT_DECORATION_3,
	PCG_LAYERING_BEAST_INSECT_DECORATION_4,
	PCG_LAYERING_BEAST_INSECT_DECORATION_5,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_SPIDER_DECORATION_1,
	PCG_LAYERING_BEAST_SPIDER_DECORATION_2,
	PCG_LAYERING_BEAST_SPIDER_DECORATION_3,
	PCG_LAYERING_BEAST_SPIDER_DECORATION_4,
	PCG_LAYERING_BEAST_SPIDER_DECORATION_5,
	PCG_LAYERING_BEAST_SPIDER_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_SPIDER_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_SPIDER_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_SCORPION_DECORATION_1,
	PCG_LAYERING_BEAST_SCORPION_DECORATION_2,
	PCG_LAYERING_BEAST_SCORPION_DECORATION_3,
	PCG_LAYERING_BEAST_SCORPION_DECORATION_4,
	PCG_LAYERING_BEAST_SCORPION_DECORATION_5,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_SCORPION_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_DECORATION_1,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_DECORATION_2,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_DECORATION_3,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_DECORATION_4,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_DECORATION_5,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_HUMANOID_DECORATION_1,
	PCG_LAYERING_BEAST_HUMANOID_DECORATION_2,
	PCG_LAYERING_BEAST_HUMANOID_DECORATION_3,
	PCG_LAYERING_BEAST_HUMANOID_DECORATION_4,
	PCG_LAYERING_BEAST_HUMANOID_DECORATION_5,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_FRONT_GRASP_DECORATION_1,
	PCG_LAYERING_BEAST_FRONT_GRASP_DECORATION_2,
	PCG_LAYERING_BEAST_FRONT_GRASP_QUAD_DECORATION_1,
	PCG_LAYERING_BEAST_FRONT_GRASP_HEX_DECORATION_1,
	PCG_LAYERING_BEAST_FRONT_GRASP_OCT_DECORATION_1,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_QUADRUPED_BULKY_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_DECORATION_2,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_QUAD_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_HEX_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_OCT_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_DECORATION_2,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_QUAD_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_HEX_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_OCT_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_WALRUS_DECORATION_1,
	PCG_LAYERING_BEAST_WALRUS_DECORATION_2,
	PCG_LAYERING_BEAST_WALRUS_DECORATION_3,
	PCG_LAYERING_BEAST_WALRUS_DECORATION_4,
	PCG_LAYERING_BEAST_WALRUS_DECORATION_5,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_BACK_DECORATION_1,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_BACK_DECORATION_2,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_BACK_DECORATION_3,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_FRONT_DECORATION_1,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_FRONT_DECORATION_2,
	PCG_LAYERING_BEAST_WALRUS_WINGS_FEATHERED_FRONT_DECORATION_3,

	PCG_LAYERING_BEAST_WORM_SHORT_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_INSECT_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_INSECT_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_INSECT_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_SPIDER_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_SPIDER_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_SPIDER_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_HUMANOID_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_FRONT_GRASP_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_WALRUS_WINGS_BAT_FRONT,

	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_WINGS_LACY_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_WINGS_FEATHERED_BACK,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_WINGS_BAT_BACK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_WINGS_FEATHERED_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_WINGS_BAT_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_WINGS_LACY_BACK,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_WINGS_BAT_FRONT,

	PCG_LAYERING_BEAST_WALRUS_MANDIBLES_FRONT,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_MANDIBLES_FRONT,

	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_ARMLESS,
	PCG_LAYERING_BEAST_HUMANOID_ARMLESS,
	PCG_LAYERING_BEAST_SNAKE_BEAK,
	PCG_LAYERING_BEAST_HUMANOID_BEAK,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_BEAK,
	PCG_LAYERING_BEAST_SNAKE_QUILLS,
	PCG_LAYERING_BEAST_WORM_LONG_QUILLS,
	PCG_LAYERING_BEAST_WORM_SHORT_QUILLS,
	PCG_LAYERING_BEAST_INSECT_QUILLS,
	PCG_LAYERING_BEAST_SPIDER_QUILLS,
	PCG_LAYERING_BEAST_SCORPION_QUILLS,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_QUILLS,
	PCG_LAYERING_BEAST_HUMANOID_QUILLS,
	PCG_LAYERING_BEAST_FRONT_GRASP_QUILLS,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_QUILLS,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_QUILLS,
	PCG_LAYERING_BEAST_WALRUS_QUILLS,
	PCG_LAYERING_BEAST_SNAKE_PLATES,
	PCG_LAYERING_BEAST_WORM_LONG_PLATES,
	PCG_LAYERING_BEAST_WORM_SHORT_PLATES,
	PCG_LAYERING_BEAST_INSECT_PLATES,
	PCG_LAYERING_BEAST_SPIDER_PLATES,
	PCG_LAYERING_BEAST_SCORPION_PLATES,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_PLATES,
	PCG_LAYERING_BEAST_HUMANOID_PLATES,
	PCG_LAYERING_BEAST_FRONT_GRASP_PLATES,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_PLATES,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_PLATES,
	PCG_LAYERING_BEAST_WALRUS_PLATES,
	PCG_LAYERING_BEAST_SNAKE_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_WORM_LONG_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_WORM_SHORT_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_INSECT_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_SPIDER_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_SCORPION_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_HUMANOID_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_FRONT_GRASP_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_WALRUS_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_SNAKE_HORN,
	PCG_LAYERING_BEAST_WORM_LONG_HORN,
	PCG_LAYERING_BEAST_WORM_SHORT_HORN,
	PCG_LAYERING_BEAST_INSECT_HORN,
	PCG_LAYERING_BEAST_SPIDER_HORN,
	PCG_LAYERING_BEAST_SCORPION_HORN,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_HORN,
	PCG_LAYERING_BEAST_HUMANOID_HORN,
	PCG_LAYERING_BEAST_FRONT_GRASP_HORN,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_HORN,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_HORN,
	PCG_LAYERING_BEAST_WALRUS_HORN,
	PCG_LAYERING_BEAST_SNAKE_HORNS1,
	PCG_LAYERING_BEAST_WORM_LONG_HORNS1,
	PCG_LAYERING_BEAST_WORM_SHORT_HORNS1,
	PCG_LAYERING_BEAST_INSECT_HORNS1,
	PCG_LAYERING_BEAST_SPIDER_HORNS1,
	PCG_LAYERING_BEAST_SCORPION_HORNS1,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_HORNS1,
	PCG_LAYERING_BEAST_HUMANOID_HORNS1,
	PCG_LAYERING_BEAST_FRONT_GRASP_HORNS1,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_HORNS1,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_HORNS1,
	PCG_LAYERING_BEAST_WALRUS_HORNS1,
	PCG_LAYERING_BEAST_SNAKE_HORNS2,
	PCG_LAYERING_BEAST_WORM_LONG_HORNS2,
	PCG_LAYERING_BEAST_WORM_SHORT_HORNS2,
	PCG_LAYERING_BEAST_INSECT_HORNS2,
	PCG_LAYERING_BEAST_SPIDER_HORNS2,
	PCG_LAYERING_BEAST_SCORPION_HORNS2,
	PCG_LAYERING_BEAST_BIPEDAL_DINOSAUR_HORNS2,
	PCG_LAYERING_BEAST_HUMANOID_HORNS2,
	PCG_LAYERING_BEAST_FRONT_GRASP_HORNS2,
	PCG_LAYERING_BEAST_QUADRUPED_BULKY_HORNS2,
	PCG_LAYERING_BEAST_QUADRUPED_SLINKY_HORNS2,
	PCG_LAYERING_BEAST_WALRUS_HORNS2,

	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_ARMLESS,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_ARMLESS,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_BEAK,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_BEAK,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_BEAK,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_QUILLS,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_PLATES,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_EXTERNAL_RIBS,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_HORN,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_HORN,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_HORN,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_HORN,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_HORN,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_HORN,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_HORN,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_HORN,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_HORN,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_HORN,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_HORN,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_HORN,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_HORNS1,
	PCG_LAYERING_BEAST_ORGANIC_SNAKE_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_WORM_LONG_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_WORM_SHORT_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_INSECT_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_SPIDER_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_SCORPION_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_BIPEDAL_DINOSAUR_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_HUMANOID_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_FRONT_GRASP_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_BULKY_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_QUADRUPED_SLINKY_HORNS2,
	PCG_LAYERING_BEAST_ORGANIC_WALRUS_HORNS2,

	PCG_LAYERING_BEAST_SCORPION_CRUSTACEAN_TAIL,

	PCG_LAYERINGNUM,
	PCG_LAYERING_NONE=-1
};
typedef int32_t PCGLayering;

//extern const unordered_bimap<string,PCGLayering> PCG_LAYERINGSTRINGS;

enum PCGLayeringModifierType
{
	PCG_LAYERING_MODIFIER_HORN_COUNT_1,
	PCG_LAYERING_MODIFIER_HORN_COUNT_2,
	PCG_LAYERING_MODIFIER_HORN_COUNT_3,
	PCG_LAYERING_MODIFIER_HORN_COUNT_4,

	PCG_LAYERING_MODIFIER_HORN_LONG_SPIRAL,
	PCG_LAYERING_MODIFIER_HORN_LONG_CURVING,
	PCG_LAYERING_MODIFIER_HORN_SHORT,
	PCG_LAYERING_MODIFIER_HORN_STUBBY,
	PCG_LAYERING_MODIFIER_HORN_BROAD,
	PCG_LAYERING_MODIFIER_HORN_LONG_STRAIGHT,

	PCG_LAYERING_MODIFIER_ANTENNA_LONG,
	PCG_LAYERING_MODIFIER_ANTENNA_FAN,
	PCG_LAYERING_MODIFIER_ANTENNA_SPINDLY,
	PCG_LAYERING_MODIFIER_ANTENNA_SQUAT,
	PCG_LAYERING_MODIFIER_ANTENNA_BRANCHING,
	PCG_LAYERING_MODIFIER_ANTENNA_KNOBBING,

	PCG_LAYERING_MODIFIER_TRUNK_LONG,
	PCG_LAYERING_MODIFIER_TRUNK_SHORT,
	PCG_LAYERING_MODIFIER_TRUNK_FAT,
	PCG_LAYERING_MODIFIER_TRUNK_TWISTING,
	PCG_LAYERING_MODIFIER_TRUNK_CURLING,
	PCG_LAYERING_MODIFIER_TRUNK_KNOBBY,

	PCG_LAYERING_MODIFIER_SURFACE_FUR,
	PCG_LAYERING_MODIFIER_SURFACE_FEATHERS,
	PCG_LAYERING_MODIFIER_SURFACE_SCALES,
	PCG_LAYERING_MODIFIER_SURFACE_SKIN,
	PCG_LAYERING_MODIFIER_SURFACE_SKINLESS,

	PCG_LAYERING_MODIFIER_EXTERNAL_RIBS,

	PCG_LAYERING_MODIFIERNUM,
	PCG_LAYERING_MODIFIERNONE=-1
};
typedef int32_t PCGLayeringModifier;

//extern const unordered_bimap<string,PCGLayeringModifier> PCG_LAYERING_MODIFIERSTRINGS;

enum UnitStatusType
{
	UNIT_STATUS_MIGRANT,
	UNIT_STATUS_NO_JOB,
	UNIT_STATUS_NO_DESTINATION,
	UNIT_STATUS_HUNGRY,
	UNIT_STATUS_THIRSTY,
	UNIT_STATUS_DROWSY,
	UNIT_STATUS_STRESSED,
	UNIT_STATUS_DISTRACTED,
	UNIT_STATUS_SLEEPING,
	UNIT_STATUS_FEY_MOOD,
	UNIT_STATUS_POSSESSED,
	UNIT_STATUS_SECRETIVE_MOOD,
	UNIT_STATUS_FELL_MOOD,
	UNIT_STATUS_MACABRE_MOOD,
	UNIT_STATUS_TANTRUM,
	UNIT_STATUS_OBLIVIOUS,
	UNIT_STATUS_DEPRESSION,
	UNIT_STATUS_MADNESS,
	UNIT_STATUS_MELANCHOLY,
	UNIT_STATUS_BERSERK,
	UNIT_STATUS_ENRAGED,
	UNIT_STATUS_MARTIAL_TRANCE,
	UNIT_STATUS_TERRIFIED,
	UNIT_STATUS_WRESTLING,
	UNIT_STATUS_MINOR_INJURY,
	UNIT_STATUS_MAJOR_INJURY,
	UNIT_STATUS_PARALYZED,
	UNIT_STATUS_STUNNED,
	UNIT_STATUS_NAUSEA,
	UNIT_STATUS_WINDED,
	UNIT_STATUS_UNCONSCIOUS,
	UNIT_STATUS_FEVERED,
	UNIT_STATUS_YIELDING,
	UNIT_STATUS_PLAYING_MAKE_BELIEVE,
	UNIT_STATUS_TELLING_A_STORY,
	UNIT_STATUS_RECITING_POETRY,
	UNIT_STATUS_PERFORMING,
	UNIT_STATUS_PROJECTILE,
	UNIT_STATUS_GROUNDED,
	UNIT_STATUS_WEBBED,
	UNIT_STATUS_CLIMBING,
	UNIT_STATUSNUM,
	UNIT_STATUS_NONE=-1
};
typedef int32_t UnitStatus;

enum SideIndicatorType
{
	SIDE_INDICATOR_YOU,
	SIDE_INDICATOR_BRAWL,
	SIDE_INDICATOR_NON_LETHAL,
	SIDE_INDICATOR_LETHAL,
	SIDE_INDICATOR_ALLY,
	SIDE_INDICATORNUM,
	SIDE_INDICATOR_NONE=-1
};
typedef int32_t SideIndicator;

enum TreeWoodTileType
{
	TREE_WOOD_TILE_TREE_TRUNK_PILLAR,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_nswe,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_nsw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_nse,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_nwe,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_swe,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_ns,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_nw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_sw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_ne,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_se,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_we,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_s,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_w,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_swe,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_sw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_se,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_we,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_s,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_w,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_N_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_nwe,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_nw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_ne,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_we,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_w,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_S_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_nse,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_ns,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_ne,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_se,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_s,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_W_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_nsw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_ns,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_nw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_sw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_s,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_E_w,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NS,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NS_we,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NS_w,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NS_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_WE,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_WE_ns,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_WE_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_WE_s,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NW,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NW_se,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NW_s,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NW_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NE,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NE_sw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NE_s,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NE_w,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SW,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SW_ne,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SW_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SW_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SE,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SE_nw,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SE_n,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SE_w,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NSE,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NSE_w,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NSW,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NSW_e,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NWE,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NWE_s,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SWE,
		TREE_WOOD_TILE_TREE_HEAVY_BRANCH_SWE_n,
	TREE_WOOD_TILE_TREE_HEAVY_BRANCH_NSWE,
	TREE_WOOD_TILE_TREE_BRANCH_NSWE,
	TREE_WOOD_TILE_TREE_BRANCH_SWE,
	TREE_WOOD_TILE_TREE_BRANCH_NWE,
	TREE_WOOD_TILE_TREE_BRANCH_NSE,
	TREE_WOOD_TILE_TREE_BRANCH_NSW,
	TREE_WOOD_TILE_TREE_BRANCH_NS,
	TREE_WOOD_TILE_TREE_BRANCH_NW,
	TREE_WOOD_TILE_TREE_BRANCH_NE,
	TREE_WOOD_TILE_TREE_BRANCH_SW,
	TREE_WOOD_TILE_TREE_BRANCH_SE,
	TREE_WOOD_TILE_TREE_BRANCH_WE,
	TREE_WOOD_TILE_TREE_BRANCH_N,
	TREE_WOOD_TILE_TREE_BRANCH_S,
	TREE_WOOD_TILE_TREE_BRANCH_W,
	TREE_WOOD_TILE_TREE_BRANCH_E,
	TREE_WOOD_TILE_TREE_BRANCH,
	TREE_WOOD_TILE_TRUNK_THICK_N,
	TREE_WOOD_TILE_TRUNK_THICK_S,
	TREE_WOOD_TILE_TRUNK_THICK_E,
	TREE_WOOD_TILE_TRUNK_THICK_W,
	TREE_WOOD_TILE_TRUNK_THICK_NW,
	TREE_WOOD_TILE_TRUNK_THICK_NE,
	TREE_WOOD_TILE_TRUNK_THICK_SW,
	TREE_WOOD_TILE_TRUNK_THICK_SE,
	TREE_WOOD_TILE_TRUNK_NSE,
		TREE_WOOD_TILE_TRUNK_NSE_w,
	TREE_WOOD_TILE_TRUNK_NSW,
		TREE_WOOD_TILE_TRUNK_NSW_e,
	TREE_WOOD_TILE_TRUNK_NWE,
		TREE_WOOD_TILE_TRUNK_NWE_s,
	TREE_WOOD_TILE_TRUNK_SWE,
		TREE_WOOD_TILE_TRUNK_SWE_n,
	TREE_WOOD_TILE_TRUNK_SE,
		TREE_WOOD_TILE_TRUNK_SE_nw,
		TREE_WOOD_TILE_TRUNK_SE_n,
		TREE_WOOD_TILE_TRUNK_SE_w,
	TREE_WOOD_TILE_TRUNK_SW,
		TREE_WOOD_TILE_TRUNK_SW_ne,
		TREE_WOOD_TILE_TRUNK_SW_n,
		TREE_WOOD_TILE_TRUNK_SW_e,
	TREE_WOOD_TILE_TRUNK_NE,
		TREE_WOOD_TILE_TRUNK_NE_sw,
		TREE_WOOD_TILE_TRUNK_NE_s,
		TREE_WOOD_TILE_TRUNK_NE_w,
	TREE_WOOD_TILE_TRUNK_NW,
		TREE_WOOD_TILE_TRUNK_NW_se,
		TREE_WOOD_TILE_TRUNK_NW_s,
		TREE_WOOD_TILE_TRUNK_NW_e,
	TREE_WOOD_TILE_TRUNK_NS,
		TREE_WOOD_TILE_TRUNK_NS_we,
		TREE_WOOD_TILE_TRUNK_NS_w,
		TREE_WOOD_TILE_TRUNK_NS_e,
	TREE_WOOD_TILE_TRUNK_WE,
		TREE_WOOD_TILE_TRUNK_WE_ns,
		TREE_WOOD_TILE_TRUNK_WE_n,
		TREE_WOOD_TILE_TRUNK_WE_s,
	TREE_WOOD_TILE_TRUNK_N,
		TREE_WOOD_TILE_TRUNK_N_swe,
		TREE_WOOD_TILE_TRUNK_N_sw,
		TREE_WOOD_TILE_TRUNK_N_se,
		TREE_WOOD_TILE_TRUNK_N_we,
		TREE_WOOD_TILE_TRUNK_N_s,
		TREE_WOOD_TILE_TRUNK_N_w,
		TREE_WOOD_TILE_TRUNK_N_e,
	TREE_WOOD_TILE_TRUNK_S,
		TREE_WOOD_TILE_TRUNK_S_nwe,
		TREE_WOOD_TILE_TRUNK_S_nw,
		TREE_WOOD_TILE_TRUNK_S_ne,
		TREE_WOOD_TILE_TRUNK_S_we,
		TREE_WOOD_TILE_TRUNK_S_n,
		TREE_WOOD_TILE_TRUNK_S_w,
		TREE_WOOD_TILE_TRUNK_S_e,
	TREE_WOOD_TILE_TRUNK_W,
		TREE_WOOD_TILE_TRUNK_W_nse,
		TREE_WOOD_TILE_TRUNK_W_ns,
		TREE_WOOD_TILE_TRUNK_W_ne,
		TREE_WOOD_TILE_TRUNK_W_se,
		TREE_WOOD_TILE_TRUNK_W_n,
		TREE_WOOD_TILE_TRUNK_W_s,
		TREE_WOOD_TILE_TRUNK_W_e,
	TREE_WOOD_TILE_TRUNK_E,
		TREE_WOOD_TILE_TRUNK_E_nsw,
		TREE_WOOD_TILE_TRUNK_E_ns,
		TREE_WOOD_TILE_TRUNK_E_nw,
		TREE_WOOD_TILE_TRUNK_E_sw,
		TREE_WOOD_TILE_TRUNK_E_n,
		TREE_WOOD_TILE_TRUNK_E_s,
		TREE_WOOD_TILE_TRUNK_E_w,
	TREE_WOOD_TILE_TRUNK_NSWE,
	TREE_WOOD_TILE_TRUNK_THICK_INTERIOR,
	TREE_WOOD_TILE_SLOPE_TO_N,
	TREE_WOOD_TILE_SLOPE_TO_S,
	TREE_WOOD_TILE_SLOPE_TO_W,
	TREE_WOOD_TILE_SLOPE_TO_E,
	TREE_WOOD_TILE_SLOPE_NSWE,
	TREE_WOOD_TILE_SLOPE_NSW,
	TREE_WOOD_TILE_SLOPE_NSE,
	TREE_WOOD_TILE_SLOPE_NWE,
	TREE_WOOD_TILE_SLOPE_SWE,
	TREE_WOOD_TILE_SLOPE_NS,
	TREE_WOOD_TILE_SLOPE_NW,
	TREE_WOOD_TILE_SLOPE_SW,
	TREE_WOOD_TILE_SLOPE_NE,
	TREE_WOOD_TILE_SLOPE_SE,
	TREE_WOOD_TILE_SLOPE_WE,
	TREE_WOOD_TILE_SLOPE_N,
	TREE_WOOD_TILE_SLOPE_S,
	TREE_WOOD_TILE_SLOPE_W,
	TREE_WOOD_TILE_SLOPE_E,
	TREE_WOOD_TILE_SLOPE_TOP,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_N,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_S,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_W,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_E,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_NW,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_NE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_SW,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_FULL_SE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NSWE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_SWE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NWE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NSE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NSW,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NS,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NW,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_NE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_SW,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_SE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_WE,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_N,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_S,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_W,
	TREE_WOOD_TILE_LEAFLESS_TWIGS_E,
	TREE_WOOD_TILE_LEAFLESS_TWIGS,
	TREE_WOOD_TILENUM,
	TREE_WOOD_TILE_NONE=-1
};
typedef int32_t TreeWoodTile;

enum Texture
{
	TEXTURE_MOUSE,
	TEXTURE_PUBLISHER,
	TEXTURE_PUBLISHER_SMALL,
	TEXTURE_PUBLISHER_TINY,
	TEXTURE_TITLE,
	TEXTURE_TITLE_BACKGROUND,
	TEXTURE_TITLE_ADV,
	TEXTURE_DEVELOPER,
	TEXTURE_DEVELOPER_SMALL,
	TEXTURE_DEVELOPER_TINY,
	TEXTURE_SOUND_SYSTEM,
	TEXTURE_TITLE_SIEGE,
	TEXTURENUM,
	TEXTURE_NONE=-1
};

/* screen array layout
 *
 *
 * X*Y tiles of 4 bytes each in column-major order (FIXME: This is inefficient! It should be row-major!)
 * For each tile, byte 0 is the character, 1 is foreground color, 2 is bacground, and 3 denotes bold.
 *
 * As there are only 8 different colors and bold is a boolean, this leaves a lot of free space. Therefore,
 * without involving the graphics arrays, out-of-gamut values can be used for designating TTF objects.
 *
 * This means setting the bold byte to all 1s (0xff), and then using the other three bytes as a designator.
 *
 * Time will tell whether this was a good idea or not.
 */

// So yeah, we store "type" in the previously bold byte. This means we have quite a lot of free types yet.
#define GRAPHICSTYPE_TTF 0xff
// This type denotes a tile that is covered by truetype, but is not the tile it starts on.
#define GRAPHICSTYPE_TTFCONT 0xfe

#define SCREENTEXPOS_FLAG_GRAYSCALE BIT1
#define SCREENTEXPOS_FLAG_ADDCOLOR BIT2
#define SCREENTEXPOS_FLAG_ANCHOR_SUBORDINATE BIT3
#define SCREENTEXPOS_FLAG_TOP_OF_TEXT BIT4
#define SCREENTEXPOS_FLAG_BOTTOM_OF_TEXT BIT5
#define SCREENTEXPOS_FLAG_ANCHOR_USE_SCREEN_COLOR BIT6
#define SCREENTEXPOS_FLAG_ANCHOR_X_COORD (BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
	#define SCREENTEXPOS_FLAG_ANCHOR_X_COORD_SHIFT 6
#define SCREENTEXPOS_FLAG_ANCHOR_Y_COORD (BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
	#define SCREENTEXPOS_FLAG_ANCHOR_Y_COORD_SHIFT 12


enum RectangleCursorType
{
	RECTANGLE_CURSOR_GOOD,
	RECTANGLE_CURSOR_GOOD_UNPASSABLE,
	RECTANGLE_CURSOR_GOOD_WATER,
	RECTANGLE_CURSOR_FAILURE,
	RECTANGLE_CURSOR_FAILURE_UNPASSABLE,
	RECTANGLE_CURSOR_FAILURE_WATER,
	RECTANGLE_CURSOR_BAD,
	RECTANGLE_CURSOR_KEYBOARD,
	RECTANGLE_CURSORNUM,
	RECTANGLE_CURSOR_NONE=-1
};
typedef int32_t RectangleCursor;

#define MAP_PORT_CLOUD_BITS_STRATUS (BIT1|BIT2)
	#define MAP_PORT_CLOUD_BITS_STRATUS_SHIFT 0
	#define MAP_PORT_CLOUD_BITS_STRATUS_NIMBUS (BIT1|BIT2)
	#define MAP_PORT_CLOUD_BITS_STRATUS_PROPER BIT2
	#define MAP_PORT_CLOUD_BITS_STRATUS_ALTO BIT1
#define MAP_PORT_CLOUD_BITS_CUMULUS (BIT3|BIT4)
	#define MAP_PORT_CLOUD_BITS_CUMULUS_SHIFT 2
	#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS (BIT3|BIT4)
	#define MAP_PORT_CLOUD_BITS_CUMULUS_MULTI BIT4
	#define MAP_PORT_CLOUD_BITS_CUMULUS_MED BIT3
#define MAP_PORT_CLOUD_BITS_CIRRUS BIT5
#define MAP_PORT_CLOUD_BITS_STRATUS_N (BIT6|BIT7)
	#define MAP_PORT_CLOUD_BITS_STRATUS_N_NIMBUS (BIT6|BIT7)
	#define MAP_PORT_CLOUD_BITS_STRATUS_N_PROPER BIT7
	#define MAP_PORT_CLOUD_BITS_STRATUS_N_ALTO BIT6
#define MAP_PORT_CLOUD_BITS_STRATUS_S (BIT8|BIT9)
	#define MAP_PORT_CLOUD_BITS_STRATUS_S_NIMBUS (BIT8|BIT9)
	#define MAP_PORT_CLOUD_BITS_STRATUS_S_PROPER BIT9
	#define MAP_PORT_CLOUD_BITS_STRATUS_S_ALTO BIT8
#define MAP_PORT_CLOUD_BITS_STRATUS_W (BIT10|BIT11)
	#define MAP_PORT_CLOUD_BITS_STRATUS_W_NIMBUS (BIT10|BIT11)
	#define MAP_PORT_CLOUD_BITS_STRATUS_W_PROPER BIT11
	#define MAP_PORT_CLOUD_BITS_STRATUS_W_ALTO BIT10
#define MAP_PORT_CLOUD_BITS_STRATUS_E (BIT12|BIT13)
	#define MAP_PORT_CLOUD_BITS_STRATUS_E_NIMBUS (BIT12|BIT13)
	#define MAP_PORT_CLOUD_BITS_STRATUS_E_PROPER BIT13
	#define MAP_PORT_CLOUD_BITS_STRATUS_E_ALTO BIT12
#define MAP_PORT_CLOUD_BITS_STRATUS_NW (BIT14|BIT15)
	#define MAP_PORT_CLOUD_BITS_STRATUS_NW_NIMBUS (BIT14|BIT15)
	#define MAP_PORT_CLOUD_BITS_STRATUS_NW_PROPER BIT15
	#define MAP_PORT_CLOUD_BITS_STRATUS_NW_ALTO BIT14
#define MAP_PORT_CLOUD_BITS_STRATUS_NE (BIT16|BIT17)
	#define MAP_PORT_CLOUD_BITS_STRATUS_NE_NIMBUS (BIT16|BIT17)
	#define MAP_PORT_CLOUD_BITS_STRATUS_NE_PROPER BIT17
	#define MAP_PORT_CLOUD_BITS_STRATUS_NE_ALTO BIT16
#define MAP_PORT_CLOUD_BITS_STRATUS_SW (BIT18|BIT19)
	#define MAP_PORT_CLOUD_BITS_STRATUS_SW_NIMBUS (BIT18|BIT19)
	#define MAP_PORT_CLOUD_BITS_STRATUS_SW_PROPER BIT19
	#define MAP_PORT_CLOUD_BITS_STRATUS_SW_ALTO BIT18
#define MAP_PORT_CLOUD_BITS_STRATUS_SE (BIT20|BIT21)
	#define MAP_PORT_CLOUD_BITS_STRATUS_SE_NIMBUS (BIT20|BIT21)
	#define MAP_PORT_CLOUD_BITS_STRATUS_SE_PROPER BIT21
	#define MAP_PORT_CLOUD_BITS_STRATUS_SE_ALTO BIT20
#define MAP_PORT_CLOUD_BITS_FOG (BIT22|BIT23)
	#define MAP_PORT_CLOUD_BITS_FOG_THICK (BIT22|BIT23)
	#define MAP_PORT_CLOUD_BITS_FOG_NORMAL BIT23
	#define MAP_PORT_CLOUD_BITS_FOG_MIST BIT22
#define MAP_PORT_CLOUD_BITS_CIRRUS_N BIT24
#define MAP_PORT_CLOUD_BITS_CIRRUS_S BIT25
#define MAP_PORT_CLOUD_BITS_CIRRUS_W BIT26
#define MAP_PORT_CLOUD_BITS_CIRRUS_E BIT27
#define MAP_PORT_CLOUD_BITS_CIRRUS_NW BIT28
#define MAP_PORT_CLOUD_BITS_CIRRUS_NE BIT29
#define MAP_PORT_CLOUD_BITS_CIRRUS_SW BIT30
#define MAP_PORT_CLOUD_BITS_CIRRUS_SE BIT31
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_N BIT32
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_S BIT33
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_W BIT34
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_E BIT35
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_NW BIT36
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_NE BIT37
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_SW BIT38
#define MAP_PORT_CLOUD_BITS_CUMULUS_NIMBUS_SE BIT39

#define GRAPHIC_MAP_PORT_FLAG_ACTIVE BIT1

struct graphic_map_portst
{
	uint32_t flag;

	int32_t dim_x,dim_y;
	int32_t clipx[2],clipy[2];
	int32_t screen_x,screen_y;

	int32_t top_left_corner_x;
	int32_t top_left_corner_y;
	int32_t pixel_perc_x;
	int32_t pixel_perc_y;

	int32_t *screentexpos_base;
	int32_t *screentexpos_edge[8];
	int32_t *screentexpos_edge2[8];
	int32_t *screentexpos_detail;
	int32_t *screentexpos_tunnel;
	int32_t *screentexpos_river;
	int32_t *screentexpos_road;
	int32_t *screentexpos_site;
	int32_t *screentexpos_army;
	int32_t *screentexpos_interface;
	int32_t *screentexpos_detail_to_n;
	int32_t *screentexpos_detail_to_s;
	int32_t *screentexpos_detail_to_w;
	int32_t *screentexpos_detail_to_e;
	int32_t *screentexpos_detail_to_nw;
	int32_t *screentexpos_detail_to_ne;
	int32_t *screentexpos_detail_to_sw;
	int32_t *screentexpos_detail_to_se;
	int32_t *screentexpos_site_to_s;
	uint64_t *screentexpos_cloud_bits;

	int32_t *screentexpos_base_old;
	int32_t *screentexpos_edge_old[8];
	int32_t *screentexpos_edge2_old[8];
	int32_t *screentexpos_detail_old;
	int32_t *screentexpos_tunnel_old;
	int32_t *screentexpos_river_old;
	int32_t *screentexpos_road_old;
	int32_t *screentexpos_site_old;
	int32_t *screentexpos_army_old;
	int32_t *screentexpos_interface_old;
	int32_t *screentexpos_detail_to_n_old;
	int32_t *screentexpos_detail_to_s_old;
	int32_t *screentexpos_detail_to_w_old;
	int32_t *screentexpos_detail_to_e_old;
	int32_t *screentexpos_detail_to_nw_old;
	int32_t *screentexpos_detail_to_ne_old;
	int32_t *screentexpos_detail_to_sw_old;
	int32_t *screentexpos_detail_to_se_old;
	int32_t *screentexpos_site_to_s_old;
	uint64_t *screentexpos_cloud_bits_old;

	int32_t *edge_biome_data;
	int32_t *edge_type_n;
	int32_t *edge_type_s;
	int32_t *edge_type_w;
	int32_t *edge_type_e;
	int32_t *edge_type_nw;
	int32_t *edge_type_ne;
	int32_t *edge_type_sw;
	int32_t *edge_type_se;
	int32_t *edge_biome_n;
	int32_t *edge_biome_s;
	int32_t *edge_biome_w;
	int32_t *edge_biome_e;
	int32_t *edge_biome_nw;
	int32_t *edge_biome_ne;
	int32_t *edge_biome_sw;
	int32_t *edge_biome_se;

	//*************************** VIEWPORT OFFSETS
		//view port needs to understand an offset from 0 to tiledimx-1 for shifting purposes
			//and it also has an underlying grid then that is updated according to some coordinate system
				//the map rectangle on the outside handles those offsets and that kind of information, as well as understanding what the offsetx/y camera means


	graphic_map_portst()
		{
		flag=0;

		top_left_corner_x=0;
		top_left_corner_y=0;
		pixel_perc_x=100;
		pixel_perc_y=100;

		screentexpos_base=NULL;
		int32_t ei;
		for(ei=0;ei<8;++ei)
			{
			screentexpos_edge[ei]=NULL;
			screentexpos_edge2[ei]=NULL;
			}
		screentexpos_detail=NULL;
		screentexpos_tunnel=NULL;
		screentexpos_river=NULL;
		screentexpos_road=NULL;
		screentexpos_site=NULL;
		screentexpos_army=NULL;
		screentexpos_interface=NULL;
		screentexpos_detail_to_n=NULL;
		screentexpos_detail_to_s=NULL;
		screentexpos_detail_to_w=NULL;
		screentexpos_detail_to_e=NULL;
		screentexpos_detail_to_nw=NULL;
		screentexpos_detail_to_ne=NULL;
		screentexpos_detail_to_sw=NULL;
		screentexpos_detail_to_se=NULL;
		screentexpos_site_to_s=NULL;
		screentexpos_cloud_bits=NULL;

		screentexpos_base_old=NULL;
		for(ei=0;ei<8;++ei)
			{
			screentexpos_edge_old[ei]=NULL;
			screentexpos_edge2_old[ei]=NULL;
			}
		screentexpos_detail_old=NULL;
		screentexpos_tunnel_old=NULL;
		screentexpos_river_old=NULL;
		screentexpos_road_old=NULL;
		screentexpos_site_old=NULL;
		screentexpos_army_old=NULL;
		screentexpos_interface_old=NULL;
		screentexpos_detail_to_n_old=NULL;
		screentexpos_detail_to_s_old=NULL;
		screentexpos_detail_to_w_old=NULL;
		screentexpos_detail_to_e_old=NULL;
		screentexpos_detail_to_nw_old=NULL;
		screentexpos_detail_to_ne_old=NULL;
		screentexpos_detail_to_sw_old=NULL;
		screentexpos_detail_to_se_old=NULL;
		screentexpos_site_to_s_old=NULL;
		screentexpos_cloud_bits_old=NULL;
		
		edge_biome_data=NULL;
		edge_type_n=NULL;
		edge_type_s=NULL;
		edge_type_w=NULL;
		edge_type_e=NULL;
		edge_type_nw=NULL;
		edge_type_ne=NULL;
		edge_type_sw=NULL;
		edge_type_se=NULL;
		edge_biome_n=NULL;
		edge_biome_s=NULL;
		edge_biome_w=NULL;
		edge_biome_e=NULL;
		edge_biome_nw=NULL;
		edge_biome_ne=NULL;
		edge_biome_sw=NULL;
		edge_biome_se=NULL;
		}

	~graphic_map_portst()
		{
		clean_arrays();
		}

	void locate(long y,long x)
		{
		// No point in clamping here, addchar clamps too.
		screen_x=x;
		screen_y=y;
		}

	void set_dims_and_allocate(int32_t ndx,int32_t ndy);

	void clear_screen();

	void set_clipping(int32_t min_x,int32_t max_x,int32_t min_y,int32_t max_y)
		{
		clipx[0]=min_x;
		clipx[1]=max_x;
		clipy[0]=min_y;
		clipy[1]=max_y;
		}

	void clean_arrays()
		{
		if(screentexpos_base!=NULL)delete[] screentexpos_base;
		int32_t ei;
		for(ei=0;ei<8;++ei)
			{
			if(screentexpos_edge[ei]!=NULL)delete[] screentexpos_edge[ei];
			if(screentexpos_edge2[ei]!=NULL)delete[] screentexpos_edge2[ei];
			}
		if(screentexpos_detail!=NULL)delete[] screentexpos_detail;
		if(screentexpos_tunnel!=NULL)delete[] screentexpos_tunnel;
		if(screentexpos_river!=NULL)delete[] screentexpos_river;
		if(screentexpos_road!=NULL)delete[] screentexpos_road;
		if(screentexpos_site!=NULL)delete[] screentexpos_site;
		if(screentexpos_army!=NULL)delete[] screentexpos_army;
		if(screentexpos_interface!=NULL)delete[] screentexpos_interface;
		if(screentexpos_detail_to_n!=NULL)delete[] screentexpos_detail_to_n;
		if(screentexpos_detail_to_s!=NULL)delete[] screentexpos_detail_to_s;
		if(screentexpos_detail_to_w!=NULL)delete[] screentexpos_detail_to_w;
		if(screentexpos_detail_to_e!=NULL)delete[] screentexpos_detail_to_e;
		if(screentexpos_detail_to_nw!=NULL)delete[] screentexpos_detail_to_nw;
		if(screentexpos_detail_to_ne!=NULL)delete[] screentexpos_detail_to_ne;
		if(screentexpos_detail_to_sw!=NULL)delete[] screentexpos_detail_to_sw;
		if(screentexpos_detail_to_se!=NULL)delete[] screentexpos_detail_to_se;
		if(screentexpos_site_to_s!=NULL)delete[] screentexpos_site_to_s;
		if(screentexpos_cloud_bits!=NULL)delete[] screentexpos_cloud_bits;

		if(screentexpos_base_old!=NULL)delete[] screentexpos_base_old;
		for(ei=0;ei<8;++ei)
			{
			if(screentexpos_edge_old[ei]!=NULL)delete[] screentexpos_edge_old[ei];
			if(screentexpos_edge2_old[ei]!=NULL)delete[] screentexpos_edge2_old[ei];
			}
		if(screentexpos_detail_old!=NULL)delete[] screentexpos_detail_old;
		if(screentexpos_tunnel_old!=NULL)delete[] screentexpos_tunnel_old;
		if(screentexpos_river_old!=NULL)delete[] screentexpos_river_old;
		if(screentexpos_road_old!=NULL)delete[] screentexpos_road_old;
		if(screentexpos_site_old!=NULL)delete[] screentexpos_site_old;
		if(screentexpos_army_old!=NULL)delete[] screentexpos_army_old;
		if(screentexpos_interface_old!=NULL)delete[] screentexpos_interface_old;
		if(screentexpos_detail_to_n_old!=NULL)delete[] screentexpos_detail_to_n_old;
		if(screentexpos_detail_to_s_old!=NULL)delete[] screentexpos_detail_to_s_old;
		if(screentexpos_detail_to_w_old!=NULL)delete[] screentexpos_detail_to_w_old;
		if(screentexpos_detail_to_e_old!=NULL)delete[] screentexpos_detail_to_e_old;
		if(screentexpos_detail_to_nw_old!=NULL)delete[] screentexpos_detail_to_nw_old;
		if(screentexpos_detail_to_ne_old!=NULL)delete[] screentexpos_detail_to_ne_old;
		if(screentexpos_detail_to_sw_old!=NULL)delete[] screentexpos_detail_to_sw_old;
		if(screentexpos_detail_to_se_old!=NULL)delete[] screentexpos_detail_to_se_old;
		if(screentexpos_site_to_s_old!=NULL)delete[] screentexpos_site_to_s_old;
		if(screentexpos_cloud_bits_old!=NULL)delete[] screentexpos_cloud_bits_old;

		screentexpos_base=NULL;
		for(ei=0;ei<8;++ei)
			{
			screentexpos_edge[ei]=NULL;
			screentexpos_edge2[ei]=NULL;
			}
		screentexpos_detail=NULL;
		screentexpos_tunnel=NULL;
		screentexpos_river=NULL;
		screentexpos_road=NULL;
		screentexpos_site=NULL;
		screentexpos_army=NULL;
		screentexpos_interface=NULL;
		screentexpos_detail_to_n=NULL;
		screentexpos_detail_to_s=NULL;
		screentexpos_detail_to_w=NULL;
		screentexpos_detail_to_e=NULL;
		screentexpos_detail_to_nw=NULL;
		screentexpos_detail_to_ne=NULL;
		screentexpos_detail_to_sw=NULL;
		screentexpos_detail_to_se=NULL;
		screentexpos_site_to_s=NULL;
		screentexpos_cloud_bits=NULL;

		screentexpos_base_old=NULL;
		for(ei=0;ei<8;++ei)
			{
			screentexpos_edge_old[ei]=NULL;
			screentexpos_edge2_old[ei]=NULL;
			}
		screentexpos_detail_old=NULL;
		screentexpos_tunnel_old=NULL;
		screentexpos_river_old=NULL;
		screentexpos_road_old=NULL;
		screentexpos_site_old=NULL;
		screentexpos_army_old=NULL;
		screentexpos_interface_old=NULL;
		screentexpos_detail_to_n_old=NULL;
		screentexpos_detail_to_s_old=NULL;
		screentexpos_detail_to_w_old=NULL;
		screentexpos_detail_to_e_old=NULL;
		screentexpos_detail_to_nw_old=NULL;
		screentexpos_detail_to_ne_old=NULL;
		screentexpos_detail_to_sw_old=NULL;
		screentexpos_detail_to_se_old=NULL;
		screentexpos_site_to_s_old=NULL;
		screentexpos_cloud_bits_old=NULL;

		if(edge_biome_data!=NULL)delete[] edge_biome_data;
		if(edge_type_n!=NULL)delete[] edge_type_n;
		if(edge_type_s!=NULL)delete[] edge_type_s;
		if(edge_type_w!=NULL)delete[] edge_type_w;
		if(edge_type_e!=NULL)delete[] edge_type_e;
		if(edge_type_nw!=NULL)delete[] edge_type_nw;
		if(edge_type_ne!=NULL)delete[] edge_type_ne;
		if(edge_type_sw!=NULL)delete[] edge_type_sw;
		if(edge_type_se!=NULL)delete[] edge_type_se;
		if(edge_biome_n!=NULL)delete[] edge_biome_n;
		if(edge_biome_s!=NULL)delete[] edge_biome_s;
		if(edge_biome_w!=NULL)delete[] edge_biome_w;
		if(edge_biome_e!=NULL)delete[] edge_biome_e;
		if(edge_biome_nw!=NULL)delete[] edge_biome_nw;
		if(edge_biome_ne!=NULL)delete[] edge_biome_ne;
		if(edge_biome_sw!=NULL)delete[] edge_biome_sw;
		if(edge_biome_se!=NULL)delete[] edge_biome_se;

		edge_biome_data=NULL;
		edge_type_n=NULL;
		edge_type_s=NULL;
		edge_type_w=NULL;
		edge_type_e=NULL;
		edge_type_nw=NULL;
		edge_type_ne=NULL;
		edge_type_sw=NULL;
		edge_type_se=NULL;
		edge_biome_n=NULL;
		edge_biome_s=NULL;
		edge_biome_w=NULL;
		edge_biome_e=NULL;
		edge_biome_nw=NULL;
		edge_biome_ne=NULL;
		edge_biome_sw=NULL;
		edge_biome_se=NULL;
		}

	void shape_map_port_according_by_pixel_size(int32_t px,int32_t py);

	void add_base_tile(long texp);
	void add_edge_tile(int32_t i,long texp);
	void add_edge2_tile(int32_t i,long texp);
	void add_detail_tile(long texp);
	void add_tunnel_tile(long texp);
	void add_river_tile(long texp);
	void add_road_tile(long texp);
	void add_site_tile(long texp);
	void add_army_tile(long texp);
	void add_interface_tile(long texp);
	void add_detail_to_n_tile(long texp);
	void add_detail_to_s_tile(long texp);
	void add_detail_to_w_tile(long texp);
	void add_detail_to_e_tile(long texp);
	void add_detail_to_nw_tile(long texp);
	void add_detail_to_ne_tile(long texp);
	void add_detail_to_sw_tile(long texp);
	void add_detail_to_se_tile(long texp);
	void add_edge_biome_data(int32_t dt);
	void add_site_to_s_tile(long texp);
	void add_cloud_bits(uint64_t cloud_bits);
	void add_drawn_tile(int32_t drawn_type,int32_t ax,int32_t ay);
};

enum EdgingType
{
	EDGING_NONE,//0, must be here because of bit shift stuff
	EDGING_GRASS,
	EDGING_SOIL,
	EDGING_SOIL_SAND,
	EDGING_SOIL_SAND_YELLOW,
	EDGING_SOIL_SAND_WHITE,
	EDGING_SOIL_SAND_BLACK,
	EDGING_SOIL_SAND_RED,
	EDGING_PEBBLES,
	EDGING_STONE,
	EDGING_CUSTOM_GRASS_1,
	EDGING_CUSTOM_GRASS_2,
	EDGING_CUSTOM_GRASS_3,
	EDGING_CUSTOM_GRASS_4,
	EDGING_CUSTOM_GRASS_5,
	EDGING_CUSTOM_GRASS_6,
	EDGING_CUSTOM_GRASS_7,
	EDGING_CUSTOM_GRASS_8,
	EDGING_CUSTOM_GRASS_9,
	EDGING_CUSTOM_GRASS_10,
	EDGING_CUSTOM_GRASS_11,
	EDGING_CUSTOM_GRASS_12,
	EDGING_CUSTOM_GRASS_13,
	EDGING_CUSTOM_GRASS_14,
	EDGING_CUSTOM_GRASS_15,
	EDGING_CUSTOM_GRASS_16,
	EDGING_CUSTOM_GRASS_17,
	EDGING_CUSTOM_GRASS_18,
	EDGING_CUSTOM_GRASS_19,
	EDGING_CUSTOM_GRASS_20,
	EDGING_CUSTOM_GRASS_21,
	EDGING_CUSTOM_GRASS_22,
	EDGING_CUSTOM_GRASS_23,
	EDGING_CUSTOM_GRASS_24,
	EDGING_CUSTOM_GRASS_25,
	EDGING_CUSTOM_GRASS_26,
	EDGING_CUSTOM_GRASS_27,
	EDGING_CUSTOM_GRASS_28,
	EDGING_CUSTOM_GRASS_29,
	EDGING_CUSTOM_GRASS_30,
	EDGING_CUSTOM_GRASS_31,
	EDGING_CUSTOM_GRASS_32,
	EDGING_SHODDY_CONSTRUCTION_WOOD,
	EDGING_SHODDY_CONSTRUCTION_STONE,
	EDGING_UNUSED_44//max=255
};
typedef uint32_t Edging;

#define VIEWPORT_FLOOR_FLAG_S_EDGING (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
	#define VIEWPORT_FLOOR_FLAG_S_EDGING_SHIFT 0
#define VIEWPORT_FLOOR_FLAG_W_EDGING (BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16)
	#define VIEWPORT_FLOOR_FLAG_W_EDGING_SHIFT 8
#define VIEWPORT_FLOOR_FLAG_E_EDGING (BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24)
	#define VIEWPORT_FLOOR_FLAG_E_EDGING_SHIFT 16
#define VIEWPORT_FLOOR_FLAG_N_EDGING (BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31|BIT32)
	#define VIEWPORT_FLOOR_FLAG_N_EDGING_SHIFT 24
#define VIEWPORT_FLOOR_FLAG_SPECIAL_TEXTURE (BIT33|BIT34|BIT35)
	#define VIEWPORT_FLOOR_FLAG_SOIL_BACKGROUND_1 BIT33
	#define VIEWPORT_FLOOR_FLAG_SOIL_BACKGROUND_2 BIT33|BIT34
	#define VIEWPORT_FLOOR_FLAG_SOIL_BACKGROUND_3 BIT33|BIT35
	#define VIEWPORT_FLOOR_FLAG_SOIL_BACKGROUND_4 BIT33|BIT34|BIT35

#define VIEWPORT_WALL_FLAG_OPEN_NW BIT1
#define VIEWPORT_WALL_FLAG_OPEN_N BIT2
#define VIEWPORT_WALL_FLAG_OPEN_NE BIT3
#define VIEWPORT_WALL_FLAG_OPEN_W BIT4
#define VIEWPORT_WALL_FLAG_OPEN_E BIT5
#define VIEWPORT_WALL_FLAG_OPEN_SW BIT6
#define VIEWPORT_WALL_FLAG_OPEN_S BIT7
#define VIEWPORT_WALL_FLAG_OPEN_SE BIT8
#define VIEWPORT_WALL_FLAG_TYPE_BITS (BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
	#define VIEWPORT_WALL_FLAG_TYPE_SHIFT 8
	#define VIEWPORT_WALL_FLAG_TYPE_SOIL (1<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_SAND (2<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_SAND_Y (3<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_SAND_R (4<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_SAND_W (5<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_SAND_B (6<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_STONE (7<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_STONE_SMOOTH (8<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_STONE_DETAILED (9<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_ORE_VEIN (10<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_GEM_A (11<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_GEM_B (12<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_GEM_C (13<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_GEM_D (14<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_ROCK_BLOCK (15<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_WOODEN (16<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_METAL_BAR (17<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_ICE (18<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_ROOT (19<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_MOSS (20<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_MAGMA (21<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_WORN_STONE_1 (22<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_WORN_STONE_2 (23<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_WORN_STONE_3 (24<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_ICE_SMOOTH (25<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_REINFORCED_METAL_BAR (26<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_REINFORCED_ROCK_BLOCK (27<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
	#define VIEWPORT_WALL_FLAG_TYPE_REINFORCED_WOODEN (28<<VIEWPORT_WALL_FLAG_TYPE_SHIFT)
#define VIEWPORT_WALL_FLAG_VARIANT_BITS (BIT21|BIT22)
	#define VIEWPORT_WALL_FLAG_VARIANT_SHIFT 20
	#define VIEWPORT_WALL_FLAG_VARIANT_1 0
	#define VIEWPORT_WALL_FLAG_VARIANT_2 BIT21
	#define VIEWPORT_WALL_FLAG_VARIANT_3 BIT22
	#define VIEWPORT_WALL_FLAG_VARIANT_4 (BIT21|BIT22)
#define VIEWPORT_WALL_FLAG_FORE_COLOR_INDEX_BITS (BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30)
	#define VIEWPORT_WALL_FLAG_FORE_COLOR_INDEX_SHIFT 22
#define VIEWPORT_WALL_FLAG_BACK_COLOR_INDEX_BITS (BIT31|BIT32|BIT33|BIT34|BIT35|BIT36|BIT37|BIT38)
	#define VIEWPORT_WALL_FLAG_BACK_COLOR_INDEX_SHIFT 30

enum GraphicsRampType
{
	GRAPHICS_RAMP_NOTHING,//must put 0 here so ramp_flag==0 does cause trouble in derive
	GRAPHICS_RAMP_GRASS,
	GRAPHICS_RAMP_SOIL,
	GRAPHICS_RAMP_SAND_BEIGE,
	GRAPHICS_RAMP_SAND_BLACK,
	GRAPHICS_RAMP_SAND_RED,
	GRAPHICS_RAMP_SAND_TAN,
	GRAPHICS_RAMP_SAND_WHITE,
	GRAPHICS_RAMP_SAND_YELLOW,
	GRAPHICS_RAMP_STONE,
	GRAPHICS_RAMP_FROZEN,
	GRAPHICS_RAMP_CONSTRUCTED_WOODEN,
	GRAPHICS_RAMP_CONSTRUCTED_STONE,
	GRAPHICS_RAMP_CONSTRUCTED_METAL,
	GRAPHICS_RAMP_CUSTOM_GRASS_1,
	GRAPHICS_RAMP_CUSTOM_GRASS_2,
	GRAPHICS_RAMP_CUSTOM_GRASS_3,
	GRAPHICS_RAMP_CUSTOM_GRASS_4,
	GRAPHICS_RAMP_CUSTOM_GRASS_5,
	GRAPHICS_RAMP_CUSTOM_GRASS_6,
	GRAPHICS_RAMP_CUSTOM_GRASS_7,
	GRAPHICS_RAMP_CUSTOM_GRASS_8,
	GRAPHICS_RAMP_CUSTOM_GRASS_9,
	GRAPHICS_RAMP_CUSTOM_GRASS_10,
	GRAPHICS_RAMP_CUSTOM_GRASS_11,
	GRAPHICS_RAMP_CUSTOM_GRASS_12,
	GRAPHICS_RAMP_CUSTOM_GRASS_13,
	GRAPHICS_RAMP_CUSTOM_GRASS_14,
	GRAPHICS_RAMP_CUSTOM_GRASS_15,
	GRAPHICS_RAMP_CUSTOM_GRASS_16,
	GRAPHICS_RAMP_CUSTOM_GRASS_17,
	GRAPHICS_RAMP_CUSTOM_GRASS_18,
	GRAPHICS_RAMP_CUSTOM_GRASS_19,
	GRAPHICS_RAMP_CUSTOM_GRASS_20,
	GRAPHICS_RAMP_CUSTOM_GRASS_21,
	GRAPHICS_RAMP_CUSTOM_GRASS_22,
	GRAPHICS_RAMP_CUSTOM_GRASS_23,
	GRAPHICS_RAMP_CUSTOM_GRASS_24,
	GRAPHICS_RAMP_CUSTOM_GRASS_25,
	GRAPHICS_RAMP_CUSTOM_GRASS_26,
	GRAPHICS_RAMP_CUSTOM_GRASS_27,
	GRAPHICS_RAMP_CUSTOM_GRASS_28,
	GRAPHICS_RAMP_CUSTOM_GRASS_29,
	GRAPHICS_RAMP_CUSTOM_GRASS_30,
	GRAPHICS_RAMP_CUSTOM_GRASS_31,
	GRAPHICS_RAMP_CUSTOM_GRASS_32,
	GRAPHICS_UNUSED_46	//max 255
};

#define VIEWPORT_RAMP_FLAG_TYPE (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
#define VIEWPORT_RAMP_FLAG_WALL_N BIT9
#define VIEWPORT_RAMP_FLAG_WALL_W BIT10
#define VIEWPORT_RAMP_FLAG_WALL_E BIT11
#define VIEWPORT_RAMP_FLAG_WALL_S BIT12
#define VIEWPORT_RAMP_FLAG_WALL_NW BIT13
#define VIEWPORT_RAMP_FLAG_WALL_NE BIT14
#define VIEWPORT_RAMP_FLAG_WALL_SW BIT15
#define VIEWPORT_RAMP_FLAG_WALL_SE BIT16
#define VIEWPORT_RAMP_FLAG_N_IS_DARK_CORNER BIT17
#define VIEWPORT_RAMP_FLAG_S_IS_DARK_CORNER BIT18
#define VIEWPORT_RAMP_FLAG_W_IS_DARK_CORNER BIT19
#define VIEWPORT_RAMP_FLAG_E_IS_DARK_CORNER BIT20
#define VIEWPORT_RAMP_FLAG_N_IS_OPEN_AIR BIT21
#define VIEWPORT_RAMP_FLAG_S_IS_OPEN_AIR BIT22
#define VIEWPORT_RAMP_FLAG_W_IS_OPEN_AIR BIT23
#define VIEWPORT_RAMP_FLAG_E_IS_OPEN_AIR BIT24
#define VIEWPORT_RAMP_FLAG_SHOW_UP_ARROW BIT25
#define VIEWPORT_RAMP_FLAG_SHOW_DOWN_ARROW BIT26
#define VIEWPORT_RAMP_FLAG_COLOR_INDEX_BITS (BIT27|BIT28|BIT29|BIT30|BIT31|BIT32|BIT33|BIT34)
	#define VIEWPORT_RAMP_FLAG_COLOR_INDEX_SHIFT 26

#define VIEWPORT_SHADOW_FLAG_ACCEPTS_SHADOW BIT1
#define VIEWPORT_SHADOW_FLAG_IS_SHADOW_WALL BIT2
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_N BIT3
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_S BIT4
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_W BIT5
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_E BIT6
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_NW BIT7
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_NE BIT8
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_SW BIT9
#define VIEWPORT_SHADOW_FLAG_SHADOW_WALL_TO_SE BIT10
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_NW_OF_CORNER_SE BIT11
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_N_OF_CORNER_SE BIT12
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_N_OF_S BIT13
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_N_OF_CORNER_SW BIT14
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_NE_OF_CORNER_SW BIT15
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_W_OF_CORNER_SE BIT16
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_E_OF_CORNER_SW BIT17
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_W_OF_E BIT18
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_E_OF_W BIT19
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_W_OF_CORNER_NE BIT20
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_E_OF_CORNER_NW BIT21
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_SW_OF_CORNER_NE BIT22
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_S_OF_CORNER_NE BIT23
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_S_OF_N BIT24
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_S_OF_CORNER_NW BIT25
#define VIEWPORT_RAMP_SHADOW_ON_FLOOR_SE_OF_CORNER_NW BIT26

#define GRAPHIC_VIEWPORT_FLAG_ACTIVE BIT1
#define GRAPHIC_VIEWPORT_FLAG_SHOW_LIQUID_NUMBERS BIT2

struct graphic_viewportst
{
	uint32_t flag;

	int32_t dim_x,dim_y;
	int32_t clipx[2],clipy[2];
	int32_t screen_x,screen_y;

	int32_t *screentexpos_background;//floor
	uint64_t *screentexpos_floor_flag;
	int32_t *screentexpos_background_two;//boulder,plant,etc.
	uint32_t *screentexpos_liquid_flag;
	uint32_t *screentexpos_spatter_flag;
	int32_t *screentexpos_spatter;
	uint64_t *screentexpos_ramp_flag;
	uint32_t *screentexpos_shadow_flag;
	int32_t *screentexpos_building_one;//floor
	int32_t *screentexpos_item;//ground stuff
	int32_t *screentexpos_vehicle;//vehicle
	int32_t *screentexpos_vermin;
	int32_t *screentexpos_left_creature;
	int32_t *screentexpos;//creature etc.
	int32_t *screentexpos_right_creature;
	int32_t *screentexpos_building_two;//high furniture/interior signposting
	int32_t *screentexpos_projectile;
	int32_t *screentexpos_high_flow;
	int32_t *screentexpos_top_shadow;
	int32_t *screentexpos_signpost;//stuff that sticks up from below
	int32_t *screentexpos_upleft_creature;
	int32_t *screentexpos_up_creature;
	int32_t *screentexpos_upright_creature;
	int32_t *screentexpos_designation;
	int32_t *screentexpos_interface;//cursors etc.

	int32_t *screentexpos_background_old;
	uint64_t *screentexpos_floor_flag_old;
	int32_t *screentexpos_background_two_old;
	uint32_t *screentexpos_liquid_flag_old;
	uint32_t *screentexpos_spatter_flag_old;
	int32_t *screentexpos_spatter_old;
	uint64_t *screentexpos_ramp_flag_old;
	uint32_t *screentexpos_shadow_flag_old;
	int32_t *screentexpos_building_one_old;
	int32_t *screentexpos_item_old;
	int32_t *screentexpos_vehicle_old;
	int32_t *screentexpos_vermin_old;
	int32_t *screentexpos_left_creature_old;
	int32_t *screentexpos_old;
	int32_t *screentexpos_right_creature_old;
	int32_t *screentexpos_building_two_old;
	int32_t *screentexpos_projectile_old;
	int32_t *screentexpos_high_flow_old;
	int32_t *screentexpos_top_shadow_old;
	int32_t *screentexpos_signpost_old;
	int32_t *screentexpos_upleft_creature_old;
	int32_t *screentexpos_up_creature_old;
	int32_t *screentexpos_upright_creature_old;
	int32_t *screentexpos_designation_old;
	int32_t *screentexpos_interface_old;

	//*************************** VIEWPORT OFFSETS
		//view port needs to understand an offset from 0 to tiledimx-1 for shifting purposes
			//and it also has an underlying grid then that is updated according to some coordinate system
				//the map rectangle on the outside handles those offsets and that kind of information, as well as understanding what the offsetx/y camera means

	//helper arrays that aren't used directly but are viewport sized
	int16_t *core_tree_species_plus_one;
	int16_t *shadow_tree_species_plus_one;


	graphic_viewportst()
		{
		flag=0;
		screentexpos=NULL;
		screentexpos_background=NULL;
		screentexpos_background_two=NULL;
		screentexpos_floor_flag=NULL;
		screentexpos_liquid_flag=NULL;
		screentexpos_spatter_flag=NULL;
		screentexpos_spatter=NULL;
		screentexpos_ramp_flag=NULL;
		screentexpos_shadow_flag=NULL;
		screentexpos_building_one=NULL;
		screentexpos_building_two=NULL;
		screentexpos_top_shadow=NULL;
		screentexpos_item=NULL;
		screentexpos_vehicle=NULL;
		screentexpos_projectile=NULL;
		screentexpos_high_flow=NULL;
		screentexpos_vermin=NULL;
		screentexpos_signpost=NULL;
		screentexpos_designation=NULL;
		screentexpos_interface=NULL;
		screentexpos_left_creature=NULL;
		screentexpos_right_creature=NULL;
		screentexpos_upleft_creature=NULL;
		screentexpos_up_creature=NULL;
		screentexpos_upright_creature=NULL;

		screentexpos_background_old=NULL;
		screentexpos_background_two_old=NULL;
		screentexpos_floor_flag_old=NULL;
		screentexpos_liquid_flag_old=NULL;
		screentexpos_spatter_flag_old=NULL;
		screentexpos_spatter_old=NULL;
		screentexpos_ramp_flag_old=NULL;
		screentexpos_shadow_flag_old=NULL;
		screentexpos_building_one_old=NULL;
		screentexpos_building_two_old=NULL;
		screentexpos_top_shadow_old=NULL;
		screentexpos_item_old=NULL;
		screentexpos_vehicle_old=NULL;
		screentexpos_projectile_old=NULL;
		screentexpos_high_flow_old=NULL;
		screentexpos_vermin_old=NULL;
		screentexpos_left_creature_old=NULL;
		screentexpos_old=NULL;
		screentexpos_right_creature_old=NULL;
		screentexpos_signpost_old=NULL;
		screentexpos_upleft_creature_old=NULL;
		screentexpos_up_creature_old=NULL;
		screentexpos_upright_creature_old=NULL;
		screentexpos_designation_old=NULL;
		screentexpos_interface_old=NULL;

		core_tree_species_plus_one=NULL;
		shadow_tree_species_plus_one=NULL;
		}

	~graphic_viewportst()
		{
		clean_arrays();
		}

	void locate(long y,long x)
		{
		// No point in clamping here, addchar clamps too.
		screen_x=x;
		screen_y=y;
		}

	void set_dims_and_allocate(int32_t ndx,int32_t ndy);

	void clear_screen();

	void set_clipping(int32_t min_x,int32_t max_x,int32_t min_y,int32_t max_y)
		{
		clipx[0]=min_x;
		clipx[1]=max_x;
		clipy[0]=min_y;
		clipy[1]=max_y;
		}

	void clean_arrays()
		{
		if(screentexpos!=NULL)delete[] screentexpos;
		if(screentexpos_background!=NULL)delete[] screentexpos_background;
		if(screentexpos_background_two!=NULL)delete[] screentexpos_background_two;
		if(screentexpos_floor_flag!=NULL)delete[] screentexpos_floor_flag;
		if(screentexpos_liquid_flag!=NULL)delete[] screentexpos_liquid_flag;
		if(screentexpos_spatter_flag!=NULL)delete[] screentexpos_spatter_flag;
		if(screentexpos_spatter!=NULL)delete[] screentexpos_spatter;
		if(screentexpos_ramp_flag!=NULL)delete[] screentexpos_ramp_flag;
		if(screentexpos_shadow_flag!=NULL)delete[] screentexpos_shadow_flag;
		if(screentexpos_building_one!=NULL)delete[] screentexpos_building_one;
		if(screentexpos_building_two!=NULL)delete[] screentexpos_building_two;
		if(screentexpos_top_shadow!=NULL)delete[] screentexpos_top_shadow;
		if(screentexpos_item!=NULL)delete[] screentexpos_item;
		if(screentexpos_vehicle!=NULL)delete[] screentexpos_vehicle;
		if(screentexpos_projectile!=NULL)delete[] screentexpos_projectile;
		if(screentexpos_high_flow!=NULL)delete[] screentexpos_high_flow;
		if(screentexpos_vermin!=NULL)delete[] screentexpos_vermin;
		if(screentexpos_signpost!=NULL)delete[] screentexpos_signpost;
		if(screentexpos_left_creature!=NULL)delete[] screentexpos_left_creature;
		if(screentexpos_right_creature!=NULL)delete[] screentexpos_right_creature;
		if(screentexpos_upleft_creature!=NULL)delete[] screentexpos_upleft_creature;
		if(screentexpos_up_creature!=NULL)delete[] screentexpos_up_creature;
		if(screentexpos_upright_creature!=NULL)delete[] screentexpos_upright_creature;
		if(screentexpos_designation!=NULL)delete[] screentexpos_designation;
		if(screentexpos_interface!=NULL)delete[] screentexpos_interface;

		if(screentexpos_old!=NULL)delete[] screentexpos_old;
		if(screentexpos_background_old!=NULL)delete[] screentexpos_background_old;
		if(screentexpos_background_two_old!=NULL)delete[] screentexpos_background_two_old;
		if(screentexpos_floor_flag_old!=NULL)delete[] screentexpos_floor_flag_old;
		if(screentexpos_liquid_flag_old!=NULL)delete[] screentexpos_liquid_flag_old;
		if(screentexpos_spatter_flag_old!=NULL)delete[] screentexpos_spatter_flag_old;
		if(screentexpos_spatter_old!=NULL)delete[] screentexpos_spatter_old;
		if(screentexpos_ramp_flag_old!=NULL)delete[] screentexpos_ramp_flag_old;
		if(screentexpos_shadow_flag_old!=NULL)delete[] screentexpos_shadow_flag_old;
		if(screentexpos_building_one_old!=NULL)delete[] screentexpos_building_one_old;
		if(screentexpos_building_two_old!=NULL)delete[] screentexpos_building_two_old;
		if(screentexpos_top_shadow_old!=NULL)delete[] screentexpos_top_shadow_old;
		if(screentexpos_item_old!=NULL)delete[] screentexpos_item_old;
		if(screentexpos_vehicle_old!=NULL)delete[] screentexpos_vehicle_old;
		if(screentexpos_projectile_old!=NULL)delete[] screentexpos_projectile_old;
		if(screentexpos_high_flow_old!=NULL)delete[] screentexpos_high_flow_old;
		if(screentexpos_vermin_old!=NULL)delete[] screentexpos_vermin_old;
		if(screentexpos_signpost_old!=NULL)delete[] screentexpos_signpost_old;
		if(screentexpos_left_creature_old!=NULL)delete[] screentexpos_left_creature_old;
		if(screentexpos_right_creature_old!=NULL)delete[] screentexpos_right_creature_old;
		if(screentexpos_upleft_creature_old!=NULL)delete[] screentexpos_upleft_creature_old;
		if(screentexpos_up_creature_old!=NULL)delete[] screentexpos_up_creature_old;
		if(screentexpos_upright_creature_old!=NULL)delete[] screentexpos_upright_creature_old;
		if(screentexpos_designation_old!=NULL)delete[] screentexpos_designation_old;
		if(screentexpos_interface_old!=NULL)delete[] screentexpos_interface_old;

		if(core_tree_species_plus_one!=NULL)delete[] core_tree_species_plus_one;
		if(shadow_tree_species_plus_one!=NULL)delete[] shadow_tree_species_plus_one;

		screentexpos=NULL;
		screentexpos_background=NULL;
		screentexpos_background_two=NULL;
		screentexpos_floor_flag=NULL;
		screentexpos_liquid_flag=NULL;
		screentexpos_spatter_flag=NULL;
		screentexpos_spatter=NULL;
		screentexpos_ramp_flag=NULL;
		screentexpos_shadow_flag=NULL;
		screentexpos_building_one=NULL;
		screentexpos_building_two=NULL;
		screentexpos_top_shadow=NULL;
		screentexpos_item=NULL;
		screentexpos_vehicle=NULL;
		screentexpos_projectile=NULL;
		screentexpos_high_flow=NULL;
		screentexpos_vermin=NULL;
		screentexpos_signpost=NULL;
		screentexpos_left_creature=NULL;
		screentexpos_right_creature=NULL;
		screentexpos_upleft_creature=NULL;
		screentexpos_up_creature=NULL;
		screentexpos_upright_creature=NULL;
		screentexpos_designation=NULL;
		screentexpos_interface=NULL;

		screentexpos_old=NULL;
		screentexpos_background_old=NULL;
		screentexpos_background_two_old=NULL;
		screentexpos_floor_flag_old=NULL;
		screentexpos_liquid_flag_old=NULL;
		screentexpos_spatter_flag_old=NULL;
		screentexpos_spatter_old=NULL;
		screentexpos_ramp_flag_old=NULL;
		screentexpos_shadow_flag_old=NULL;
		screentexpos_building_one_old=NULL;
		screentexpos_building_two_old=NULL;
		screentexpos_top_shadow_old=NULL;
		screentexpos_item_old=NULL;
		screentexpos_vehicle_old=NULL;
		screentexpos_projectile_old=NULL;
		screentexpos_high_flow_old=NULL;
		screentexpos_vermin_old=NULL;
		screentexpos_signpost_old=NULL;
		screentexpos_left_creature_old=NULL;
		screentexpos_right_creature_old=NULL;
		screentexpos_upleft_creature_old=NULL;
		screentexpos_up_creature_old=NULL;
		screentexpos_upright_creature_old=NULL;
		screentexpos_designation_old=NULL;
		screentexpos_interface_old=NULL;

		core_tree_species_plus_one=NULL;
		shadow_tree_species_plus_one=NULL;
		}

	void shape_viewport_according_by_pixel_size(int32_t px,int32_t py,int32_t zoom_factor);

	void add_tile(long texp);
	void add_background_tile(long texp);
	void add_background_two_tile(long texp);
	void add_building_one_tile(long texp);
	void add_building_two_tile(long texp);
	void add_top_shadow_tile(long texp);
	void add_signpost_tile(long texp);
	void add_left_creature_tile(long texp);
	void add_right_creature_tile(long texp);
	void add_upleft_creature_tile(long texp);
	void add_up_creature_tile(long texp);
	void add_upright_creature_tile(long texp);
	void add_item_tile(long texp);
	void add_vehicle_tile(long texp);
	void add_vermin_tile(long texp);
	void add_floor_flag(uint64_t nfloor_flag);
	void add_liquid_flag(uint32_t nliquid_flag);
	void add_spatter_flag(uint32_t nspatter_flag);
	void add_spatter_flag_fire(uint32_t nspatter_flag);
	void add_spatter_tile(long texp);
	void add_ramp_flag(uint64_t nramp_flag);
	void add_shadow_flag(uint32_t nshadow_flag);
	void add_projectile_tile(long texp);
	void add_high_flow_tile(long texp);
	void add_designation_tile(long texp);
	void add_interface_tile(long texp);
};

enum InterfaceButtonMainType
{
	INTERFACE_BUTTON_MAIN_DIG,
	INTERFACE_BUTTON_MAIN_LOWER_MENU,
	INTERFACE_BUTTON_MAIN_DIG_DIG_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_DIG_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_STAIRS_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_STAIRS_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_RAMP_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_RAMP_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_CHANNEL_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_CHANNEL_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_REMOVE_STAIRS_RAMPS_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_REMOVE_STAIRS_RAMPS_INACTIVE,
	INTERFACE_BUTTON_MAIN_FREE_PAINT_ACTIVE,
	INTERFACE_BUTTON_MAIN_FREE_PAINT_INACTIVE,
	INTERFACE_BUTTON_MAIN_PAINT_RECTANGLE_ACTIVE,
	INTERFACE_BUTTON_MAIN_PAINT_RECTANGLE_INACTIVE,
	INTERFACE_BUTTON_MAIN_CLICK_ACTIVE,
	INTERFACE_BUTTON_MAIN_CLICK_INACTIVE,
	INTERFACE_BUTTON_MAIN_FREE_PAINT_BORDER_ACTIVE,
	INTERFACE_BUTTON_MAIN_FREE_PAINT_BORDER_INACTIVE,
	INTERFACE_BUTTON_MAIN_PAINT_RECTANGLE_BORDER_ACTIVE,
	INTERFACE_BUTTON_MAIN_PAINT_RECTANGLE_BORDER_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_ALL_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_ALL_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_AUTO_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_AUTO_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_ONLY_ORE_GEM_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_ONLY_ORE_GEM_INACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_ONLY_GEM_ACTIVE,
	INTERFACE_BUTTON_MAIN_DIG_MODE_ONLY_GEM_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_1_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_1_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_2_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_2_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_3_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_3_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_4_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_4_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_5_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_5_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_6_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_6_INACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_7_ACTIVE,
	INTERFACE_BUTTON_MAIN_PRIORITY_7_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_BLUEPRINT_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_BLUEPRINT_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_FROM_BLUEPRINT_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_FROM_BLUEPRINT_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TO_BLUEPRINT_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TO_BLUEPRINT_INACTIVE,
	INTERFACE_BUTTON_MAIN_OPEN_RIGHT,
	INTERFACE_BUTTON_MAIN_CLOSE_LEFT,
	INTERFACE_BUTTON_MAIN_DES_CHOP_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_CHOP_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_GATHER_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_GATHER_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_SMOOTH_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_SMOOTH_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_ENGRAVE_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_ENGRAVE_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_TRACK_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_TRACK_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_FORTIFY_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_SMOOTH_FORTIFY_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_ITEM_BUILDING,
	INTERFACE_BUTTON_MAIN_DES_CLAIM_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_CLAIM_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_FORBID_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_FORBID_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_DUMP_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_DUMP_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_UNDUMP_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_UNDUMP_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_MELT_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_MELT_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_UNMELT_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_UNMELT_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_UNHIDE_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_UNHIDE_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_HIDE_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_HIDE_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_HIGH_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_HIGH_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_NORMAL_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_NORMAL_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_LOW_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_LOW_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_RESTRICTED_ACTIVE,
	INTERFACE_BUTTON_MAIN_DES_TRAFFIC_RESTRICTED_INACTIVE,
	INTERFACE_BUTTON_MAIN_DES_ERASE,
	INTERFACE_BUTTON_MAIN_INFO_CREATURES,
	INTERFACE_BUTTON_MAIN_INFO_TASKS,
	INTERFACE_BUTTON_MAIN_INFO_PLACES,
	INTERFACE_BUTTON_MAIN_INFO_LABOR,
	INTERFACE_BUTTON_MAIN_INFO_WORK_ORDERS,
	INTERFACE_BUTTON_MAIN_INFO_NOBLES,
	INTERFACE_BUTTON_MAIN_INFO_OBJECTS,
	INTERFACE_BUTTON_MAIN_INFO_JUSTICE,
	INTERFACE_BUTTON_MAIN_INFO_CREATURES_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_TASKS_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_PLACES_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_LABOR_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_WORK_ORDERS_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_NOBLES_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_OBJECTS_ACTIVE,
	INTERFACE_BUTTON_MAIN_INFO_JUSTICE_ACTIVE,
	INTERFACE_BUTTON_MAIN_SQUADS,
	INTERFACE_BUTTON_MAIN_WORLD,
	INTERFACE_BUTTON_MAIN_BUILDING_INACTIVE,
	INTERFACE_BUTTON_MAIN_BUILDING_ACTIVE,
	INTERFACE_BUTTON_MAIN_UNUSED_113,//
	INTERFACE_BUTTON_MAIN_STOCKPILE_INACTIVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_ACTIVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_NEW,
	INTERFACE_BUTTON_MAIN_STOCKPILE_REMOVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_REPAINT,
	INTERFACE_BUTTON_MAIN_STOCKPILE_ERASE_INACTIVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_ERASE_ACTIVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_REMOVE_EXISTING,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TYPE_INACTIVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TYPE_ACTIVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TAKE_FROM_ANYWHERE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TAKE_FROM_LINKS_ONLY,
	INTERFACE_BUTTON_MAIN_STOCKPILE_SET_CONNECTIONS,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_REMOVE,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_ADD_GIVE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_ADD_TAKE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_GIVE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_TAKE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_WORKSHOP_ADD_GIVE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_WORKSHOP_ADD_TAKE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_WORKSHOP_GIVE_LINK,
	INTERFACE_BUTTON_MAIN_STOCKPILE_CONNECTIONS_WORKSHOP_TAKE_LINK,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_ORGANIC_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_ORGANIC_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_INORGANIC_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_INORGANIC_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_EMPTY_CAGE_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_EMPTY_CAGE_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_EMPTY_ANIMAL_TRAP_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_EMPTY_ANIMAL_TRAP_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_PREPARED_FOOD_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_PREPARED_FOOD_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_USABLE_ARMOR_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_USABLE_ARMOR_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_USABLE_WEAPON_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_USABLE_WEAPON_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_UNUSABLE_ARMOR_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_UNUSABLE_ARMOR_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_UNUSABLE_WEAPON_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_UNUSABLE_WEAPON_OFF,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_CORPSES_ON,
	INTERFACE_BUTTON_MAIN_CUSTOM_STOCKPILE_CORPSES_OFF,
	INTERFACE_BUTTON_MAIN_ZONE_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_REMOVE,
	INTERFACE_BUTTON_MAIN_ZONE_PREVIOUS,
	INTERFACE_BUTTON_MAIN_ZONE_NEXT,
	INTERFACE_BUTTON_MAIN_ZONE_REPAINT,
	INTERFACE_BUTTON_MAIN_ZONE_ERASE_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_ERASE_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SUSPEND_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SUSPEND,
	INTERFACE_BUTTON_MAIN_ZONE_REMOVE_EXISTING,
	INTERFACE_BUTTON_MAIN_ZONE_TYPE_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_TYPE_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_PICK_ANIMALS,
	INTERFACE_BUTTON_MAIN_ZONE_GATHER_TREE_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_GATHER_TREE_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_GATHER_SHRUB_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_GATHER_SHRUB_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_GATHER_FALLEN_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_GATHER_FALLEN_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_PIT_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_PIT_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_POND_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_POND_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_LOCATION_ASSIGN,
	INTERFACE_BUTTON_MAIN_ZONE_LOCATION_DETAILS,
	INTERFACE_BUTTON_MAIN_ZONE_ASSIGN_UNIT,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_LIST,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_LEFT_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_RIGHT_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_UP_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_DOWN_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_LEFT_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_RIGHT_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_UP_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SHOOT_DOWN_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_SLEEP_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_TRAIN_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_INDIV_EQ_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_SQUAD_EQ_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_SLEEP_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_TRAIN_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_INDIV_EQ_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_SQUAD_SQUAD_EQ_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_TOMB_CITIZEN_BURIAL_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_TOMB_CITIZEN_BURIAL_INACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_TOMB_PET_BURIAL_ACTIVE,
	INTERFACE_BUTTON_MAIN_ZONE_TOMB_PET_BURIAL_INACTIVE,
	INTERFACE_BUTTON_MAIN_BURROW_INACTIVE,
	INTERFACE_BUTTON_MAIN_BURROW_ACTIVE,
	INTERFACE_BUTTON_MAIN_HAULING_INACTIVE,
	INTERFACE_BUTTON_MAIN_HAULING_ACTIVE,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_INACTIVE_BUTTON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_ACTIVE_BUTTON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_BRIDGE_N,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_BRIDGE_S,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_BRIDGE_W,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_BRIDGE_E,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_BRIDGE_RETRACT,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_NS,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_WE,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_SCREW_PUMP_N,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_SCREW_PUMP_S,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_SCREW_PUMP_W,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_SCREW_PUMP_E,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_N,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_S,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_W,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_E,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_NE,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_SE,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_SW,
 	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_NW,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_ACTIVE_TRIGGER,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_INACTIVE_TRIGGER,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_0_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_1_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_2_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_3_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_4_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_5_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_6_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_7_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_0_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_1_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_2_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_3_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_4_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_5_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_6_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_WATER_7_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_0_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_1_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_2_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_3_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_4_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_5_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_6_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_7_ON,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_0_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_1_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_2_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_3_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_4_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_5_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_6_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_PRESSURE_PLATE_MAGMA_7_OFF,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_TRACK_STOP_NO_DUMPING,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_TRACK_STOP_FRICTION_LOWEST,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_TRACK_STOP_FRICTION_LOW,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_TRACK_STOP_FRICTION_MIDDLE,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_TRACK_STOP_FRICTION_HIGH,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_TRACK_STOP_FRICTION_HIGHEST,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_ROLLERS_SPEED_1,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_ROLLERS_SPEED_2,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_ROLLERS_SPEED_3,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_ROLLERS_SPEED_4,
	INTERFACE_BUTTON_MAIN_BUILDING_PLACEMENT_ROLLERS_SPEED_5,
	INTERFACE_BUTTON_MAIN_ASSIGN_TRADE_CULLING_MANDATES_ON,
	INTERFACE_BUTTON_MAIN_ASSIGN_TRADE_CULLING_MANDATES_OFF,
	INTERFACE_BUTTON_MAIN_ASSIGN_TRADE_SORT_BY_DISTANCE_ON,
	INTERFACE_BUTTON_MAIN_ASSIGN_TRADE_SORT_BY_DISTANCE_OFF,
	INTERFACE_BUTTON_MAIN_ASSIGN_TRADE_SORT_BY_VALUE_ON,
	INTERFACE_BUTTON_MAIN_ASSIGN_TRADE_SORT_BY_VALUE_OFF,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CREATE_NEW,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ACTIVE,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_WAITING,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CHECKING,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_READY,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_VALIDATED,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_NOT_VALIDATED,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_PRIORITY_UP,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_PRIORITY_DOWN,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CONDITIONS,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_DETAILS,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_REMOVE,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ADD_ITEM_CONDITION,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ADD_ORDER_CONDITION,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CHANGE_TYPE,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CHANGE_MAT,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CHANGE_ADJ,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ADD_SUGGESTED_CONDITION,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CHANGE_FREQUENCY,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ENTER_AMOUNT,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_INCREASE_AMOUNT,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_DECREASE_AMOUNT,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_CHANGE_ORDER_CONDITION_CHECK_TYPE,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ADJECTIVE_SELECTED,
	INTERFACE_BUTTON_MAIN_WORK_ORDERS_ADJECTIVE_NOT_SELECTED,
	INTERFACE_BUTTON_MAIN_NOBLES_ASSIGN_SYMBOL,
	INTERFACE_BUTTON_MAIN_NOBLES_BEDROOM_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_BEDROOM_MISSING,
	INTERFACE_BUTTON_MAIN_NOBLES_BEDROOM_PARTIAL,
	INTERFACE_BUTTON_MAIN_NOBLES_BEDROOM_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_OFFICE_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_OFFICE_MISSING,
	INTERFACE_BUTTON_MAIN_NOBLES_OFFICE_PARTIAL,
	INTERFACE_BUTTON_MAIN_NOBLES_OFFICE_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_DINING_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_DINING_MISSING,
	INTERFACE_BUTTON_MAIN_NOBLES_DINING_PARTIAL,
	INTERFACE_BUTTON_MAIN_NOBLES_DINING_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_TOMB_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_TOMB_MISSING,
	INTERFACE_BUTTON_MAIN_NOBLES_TOMB_PARTIAL,
	INTERFACE_BUTTON_MAIN_NOBLES_TOMB_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_ADD,
	INTERFACE_BUTTON_MAIN_NOBLES_DEMANDS_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_DEMANDS_TIME_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_DEMANDS_TIME_WARN_1,
	INTERFACE_BUTTON_MAIN_NOBLES_DEMANDS_TIME_WARN_2,
	INTERFACE_BUTTON_MAIN_NOBLES_DEMANDS_TIME_WARN_3,
	INTERFACE_BUTTON_MAIN_NOBLES_MANDATES_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_MANDATES_TIME_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_MANDATES_TIME_WARN_1,
	INTERFACE_BUTTON_MAIN_NOBLES_MANDATES_TIME_WARN_2,
	INTERFACE_BUTTON_MAIN_NOBLES_MANDATES_TIME_WARN_3,
	INTERFACE_BUTTON_MAIN_NOBLES_FURN_NA,
	INTERFACE_BUTTON_MAIN_NOBLES_FURN_MISSING,
	INTERFACE_BUTTON_MAIN_NOBLES_FURN_PARTIAL,
	INTERFACE_BUTTON_MAIN_NOBLES_FURN_GOOD,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_1_INACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_2_INACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_3_INACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_4_INACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_5_INACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_1_ACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_2_ACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_3_ACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_4_ACTIVE,
	INTERFACE_BUTTON_MAIN_NOBLES_ACCOUNTING_5_ACTIVE,
	INTERFACE_BUTTON_MAIN_LABOR_KITCHEN_COOK_CANNOT,
	INTERFACE_BUTTON_MAIN_LABOR_KITCHEN_COOK_ALLOWED,
	INTERFACE_BUTTON_MAIN_LABOR_KITCHEN_COOK_RESTRICTED,
	INTERFACE_BUTTON_MAIN_LABOR_KITCHEN_BREW_CANNOT,
	INTERFACE_BUTTON_MAIN_LABOR_KITCHEN_BREW_ALLOWED,
	INTERFACE_BUTTON_MAIN_LABOR_KITCHEN_BREW_RESTRICTED,
	INTERFACE_BUTTON_MAIN_LABOR_STONE_USE_MAGMA_SAFE,
	INTERFACE_BUTTON_MAIN_LABOR_STONE_USE_MAGMA_UNSAFE,
	INTERFACE_BUTTON_MAIN_LABOR_STONE_USE_ALLOWED,
	INTERFACE_BUTTON_MAIN_LABOR_STONE_USE_RESTRICTED,
	INTERFACE_BUTTON_MAIN_WORKER_ONLY_DO_ASSIGNED_JOBS,
	INTERFACE_BUTTON_MAIN_WORKER_DO_ANY_AVAILABLE_JOB,
	INTERFACE_BUTTON_MAIN_LABOR_WORKER_ASSIGNED,
	INTERFACE_BUTTON_MAIN_LABOR_WORKER_UNASSIGNED,
	INTERFACE_BUTTON_MAIN_LABOR_WORKER_ASSIGNED_EVERYBODY,
	INTERFACE_BUTTON_MAIN_LABOR_WORKER_ASSIGNED_NOBODY,
	INTERFACE_BUTTON_MAIN_LABOR_EDIT_WORK_DETAIL,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_MINERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_WOODCUTTERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_HUNTERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_PLANTERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_FISHERMEN,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_STONECUTTERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_ENGRAVERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_PLANT_GATHERERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_HAULERS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_ORDERLIES,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_SIEGE_OPERATORS,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_1,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_2,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_3,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_4,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_5,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_6,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_7,
	INTERFACE_BUTTON_MAIN_WORK_DETAIL_CUSTOM_8,
	INTERFACE_BUTTON_MAIN_LOCATION_RESERVED_INCREASE_AMOUNT,
	INTERFACE_BUTTON_MAIN_LOCATION_RESERVED_DECREASE_AMOUNT,
	INTERFACE_BUTTON_MAIN_LOCATION_RESERVED_ENTER_AMOUNT,
	INTERFACE_BUTTON_MAIN_LOCATION_ASSIGN_OCCUPATION,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_TAVERN_KEEPER,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_PERFORMER,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_MERCENARY,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_MONSTER_SLAYER,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_SCHOLAR,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_SCRIBE,
	//INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_MESSENGER,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_DOCTOR,
	INTERFACE_BUTTON_MAIN_LOCATION_POSITION_TEMPLE,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_ON_VISITORS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_ON_RESIDENTS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_ON_CITIZENS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_ON_MEMBERS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_OFF_VISITORS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_OFF_RESIDENTS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_OFF_CITIZENS,
	INTERFACE_BUTTON_MAIN_LOCATION_PERMISSION_OFF_MEMBERS,
	INTERFACE_BUTTON_MAIN_LOCATION_OCCUPATION_REMOVE_WORKER,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TOOL_SETTINGS,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TOOLS_ENTER_AMOUNT,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TOOLS_INCREASE_AMOUNT,
	INTERFACE_BUTTON_MAIN_STOCKPILE_TOOLS_DECREASE_AMOUNT,
	INTERFACE_BUTTON_MAIN_STOCKPILE_ON,
	INTERFACE_BUTTON_MAIN_STOCKPILE_PARTIAL,
	INTERFACE_BUTTON_MAIN_STOCKPILE_OFF,
	INTERFACE_BUTTON_MAIN_BURROW_RECENTER,
	INTERFACE_BUTTON_MAIN_BURROW_SUSPEND_ACTIVE,
	INTERFACE_BUTTON_MAIN_BURROW_SUSPEND_INACTIVE,
	INTERFACE_BUTTON_MAIN_BURROW_REPAINT,
	INTERFACE_BUTTON_MAIN_BURROW_DELETE,
	INTERFACE_BUTTON_MAIN_BURROW_ADD_UNIT,
	INTERFACE_BUTTON_MAIN_HAULING_ADD_STOP,
	INTERFACE_BUTTON_MAIN_HAULING_ADD_VEHICLE,
	INTERFACE_BUTTON_MAIN_HAULING_VEHICLE_GOOD,
	INTERFACE_BUTTON_MAIN_HAULING_VEHICLE_MOVING,
	INTERFACE_BUTTON_MAIN_HAULING_VEHICLE_TROUBLED,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_ITEMS,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS,
	INTERFACE_BUTTON_MAIN_HAULING_RENAME_ROUTE,
	INTERFACE_BUTTON_MAIN_HAULING_RENAME_STOP,
	INTERFACE_BUTTON_MAIN_HAULING_DELETE_ROUTE,
	INTERFACE_BUTTON_MAIN_HAULING_DELETE_STOP,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS_GIVE_TO_STOCKPILE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS_TAKE_FROM_STOCKPILE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS_EXCHANGE_WITH_STOCKPILE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS_ADD_GIVE_TO_STOCKPILE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS_ADD_TAKE_FROM_STOCKPILE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_LINKS_ADD_EXCHANGE_WITH_STOCKPILE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_NEW,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_INCREASE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_DECREASE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_N,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_S,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_W,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_E,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_PUSH_OFF,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_GUIDE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_RIDE,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_AT_MOST,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_AT_LEAST,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_DESIRED_ITEMS,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_ANY_ITEMS,
	INTERFACE_BUTTON_MAIN_HAULING_STOP_CONDITIONS_DELETE,
	INTERFACE_BUTTON_MAIN_UNIT_SELECTOR_ASSIGNED,
	INTERFACE_BUTTON_MAIN_UNIT_SELECTOR_UNASSIGNED,
	INTERFACE_BUTTON_MAIN_BURROW_WORKSHOPS_EVERYWHERE,
	INTERFACE_BUTTON_MAIN_BURROW_WORKSHOPS_BURROW_ONLY,
	INTERFACE_BUTTON_MAIN_SQUADS_RECENTER,
	INTERFACE_BUTTON_MAIN_SQUADS_POSITIONS,
	INTERFACE_BUTTON_MAIN_SQUADS_SELECTED,
	INTERFACE_BUTTON_MAIN_SQUADS_NOT_SELECTED,
	INTERFACE_BUTTON_MAIN_SQUADS_KILL_ORDER,
	INTERFACE_BUTTON_MAIN_SQUADS_MOVE_ORDER,
	INTERFACE_BUTTON_MAIN_SQUADS_PATROL_ORDER,
	INTERFACE_BUTTON_MAIN_SQUADS_DEFEND_BURROW_ORDER,
	INTERFACE_BUTTON_MAIN_SQUADS_TRAIN_ORDER,
	INTERFACE_BUTTON_MAIN_SQUADS_CANCEL_ORDER,
	INTERFACE_BUTTON_MAIN_SQUADS_CHANGE_ALERT,
	INTERFACE_BUTTON_MAIN_SQUADS_INSPECT,
	INTERFACE_BUTTON_MAIN_SQUADS_DISBAND,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_WEAPON_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_SHIELD_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_ARMOR_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_PANTS_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_HELMET_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_GLOVES_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_SHOES_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_QUIVER_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_AMMO_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_BACKPACK_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_FLASK_GOOD,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_WEAPON_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_SHIELD_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_ARMOR_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_PANTS_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_HELMET_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_GLOVES_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_SHOES_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_QUIVER_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_AMMO_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_BACKPACK_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_FLASK_WARNING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_WEAPON_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_SHIELD_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_ARMOR_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_PANTS_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_HELMET_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_GLOVES_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_SHOES_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_QUIVER_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_AMMO_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_BACKPACK_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_EQUIPMENT_FLASK_MISSING,
	INTERFACE_BUTTON_MAIN_SQUADS_LEFT_ACTIVE,
	INTERFACE_BUTTON_MAIN_SQUADS_RIGHT_ACTIVE,
	INTERFACE_BUTTON_MAIN_SQUADS_LEFT_INACTIVE,
	INTERFACE_BUTTON_MAIN_SQUADS_RIGHT_INACTIVE,
	INTERFACE_BUTTON_MAIN_FARM_ACTIVE_OPTION,
	INTERFACE_BUTTON_MAIN_FARM_INACTIVE_OPTION,
	INTERFACE_BUTTON_MAIN_DISPLAY_FURNITURE_ITEM_ON,
	INTERFACE_BUTTON_MAIN_DISPLAY_FURNITURE_ITEM_OFF,
	INTERFACE_BUTTON_MAIN_RECENTER_HOTKEYS,
	INTERFACE_BUTTON_MAIN_RECENTER_SURFACE,
	INTERFACE_BUTTON_MAIN_RECENTER_DEEPEST,
	INTERFACE_BUTTON_MAIN_RECENTER_RECENTER,
	INTERFACE_BUTTON_MAIN_RECENTER_SET_LOCATION,
	INTERFACE_BUTTON_MAIN_RECENTER_REMOVE_OR_CLEAR,
	INTERFACE_BUTTON_MAIN_ARENA_CREATE_CREATURE,
	INTERFACE_BUTTON_MAIN_ARENA_INCREASE_TEAM,
	INTERFACE_BUTTON_MAIN_ARENA_DECREASE_TEAM,
	INTERFACE_BUTTON_MAIN_ARENA_INCREASE_SKILL,
	INTERFACE_BUTTON_MAIN_ARENA_DECREASE_SKILL,
	INTERFACE_BUTTON_MAIN_ARENA_INCREASE_EQUIPMENT,
	INTERFACE_BUTTON_MAIN_ARENA_DECREASE_EQUIPMENT,
	INTERFACE_BUTTON_MAIN_ARENA_CONDITION_ASSIGNED,
	INTERFACE_BUTTON_MAIN_ARENA_CONDITION_UNASSIGNED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_WATER_UNSELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_WATER_SELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_MAGMA_UNSELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_MAGMA_SELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_REMOVE_UNSELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_REMOVE_SELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_SNOW_UNSELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_SNOW_SELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_MUD_UNSELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_FLUIDS_MUD_SELECTED,
	INTERFACE_BUTTON_MAIN_ARENA_WEATHER,
	INTERFACE_BUTTON_MAIN_ARENA_CREATE_TREE,
	INTERFACE_BUTTON_MAIN_ARENA_ENTER_AMOUNT,
	INTERFACE_BUTTON_MAIN_CONTRACT_LIST,
	INTERFACE_BUTTON_MAIN_EXPAND_LIST,
	INTERFACE_BUTTON_MAIN_SELECT_ALL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_SEARCH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_CRAFT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_CLIMB,
	INTERFACE_BUTTON_MAIN_ADVENTURE_JUMP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TALK,
	INTERFACE_BUTTON_MAIN_ADVENTURE_PERFORM,
	INTERFACE_BUTTON_MAIN_ADVENTURE_STRIKE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_WRESTLE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_SHOOT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_ABILITY,
	INTERFACE_BUTTON_MAIN_ADVENTURE_STATUS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_LOG,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY,
	INTERFACE_BUTTON_MAIN_ADVENTURE_MOVEMENT_OPTIONS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_OPTIONS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_SLEEP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_BUILD,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_DROP_INACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_DROP_ACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_WEAR_INACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_WEAR_ACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_REMOVE_INACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_REMOVE_ACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_PUT_INTO_INACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_PUT_INTO_ACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_EAT_DRINK_INACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_EAT_DRINK_ACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_INTERACT_INACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INVENTORY_INTERACT_ACTIVE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_WRESTLE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_GRAB,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_JOINT_LOCK,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_CHOKE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_TAKEDOWN,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_THROW,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_PINCH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_GOUGE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BREAK,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_LOOSEN,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_SHAKE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_STRANGLE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_LATCHED_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_GRASP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_STANCE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_HEAD,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_UPPERBODY,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_LOWERBODY,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_SIGHT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_LIMB_GRASP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_LIMB_STANCE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_CIRCULATION,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_BREATHE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_GUTS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_THROAT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_JOINT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_INTERNAL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_DIGIT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_SMELL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_HEAR,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_THOUGHT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_NERVOUS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_BP_FLIER,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_QUICK,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_HEAVY,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_WILD,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_PRECISE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_CHARGE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_MULTI,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_STAB,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_SLASH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_SLAP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_HACK,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_BASH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_LASH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_POMMEL_STRIKE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_PUNCH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_KICK,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_BITE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_STING,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_PINCER,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_ICON_VERB_PUSH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_STRIKE_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_WRESTLE_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_ACCORDING_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_DODGE_MOVE_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_DODGE_STAND_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_DEF_MOVE_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_DEF_STAND_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_DEF_ACCORDING_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_STRIKE_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_WRESTLE_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_ACCORDING_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_DODGE_MOVE_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_DODGE_STAND_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_DEF_MOVE_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_DEF_STAND_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMBAT_PREF_CHARGE_DEF_ACCORDING_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMPANIONS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMPANIONS_ASSUME_CONTROL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMPANIONS_FOLLOW_LEADER,
	INTERFACE_BUTTON_MAIN_ADVENTURE_COMPANIONS_MANUAL_CONTROL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_RECENTER,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_UP_STAIRS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_STAIRS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_YIELDED_YES,
	INTERFACE_BUTTON_MAIN_ADVENTURE_YIELDED_NO,
	INTERFACE_BUTTON_MAIN_ADVENTURE_WEAPONS_SHEATHED,
	INTERFACE_BUTTON_MAIN_ADVENTURE_WEAPONS_DRAWN,
	INTERFACE_BUTTON_MAIN_ADVENTURE_WEAPONS_NONE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_YOU_ARE_PROJECTILE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_YOU_ARE_RIDING,
	INTERFACE_BUTTON_MAIN_ADVENTURE_STANDING,
	INTERFACE_BUTTON_MAIN_ADVENTURE_PRONE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_GO_UP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_GO_DOWN,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_STOP_TRAVELING,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_SNEAK_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_SNEAK_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_MAP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_SLEEP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_CLOUDS_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_CLOUDS_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_TRACKS_ON,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_TRACKS_OFF,
	INTERFACE_BUTTON_MAIN_ADVENTURE_TRAVEL_LOG,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_RETRACT_INTO_BP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_UNRETRACT_FROM_BP,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_ROOT_AROUND,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_LAUNCH_ICE_BOLT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_VANISH,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_PROPEL_AWAY,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_RAISE_FOG,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_CAUSE_PAIN,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_BLISTER,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_PARALYZE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_CAUSE_BLEEDING,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SICKEN_COUGH_BLOOD,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SICKEN_VOMIT_BLOOD,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SICKEN_NAUSEA,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_ROT,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_BLIND,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SUFFOCATE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_CAUSE_DIZZINESS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_HURL_FIREBALL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPRAY_FIRE_JET,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPRAY_WEB,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPRAY_DUST,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPRAY_VAPOR,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPRAY_GAS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPIT_SOLID_GLOB,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SPIT_LIQUID_GLOB,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_EMIT_DUST,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_EMIT_VAPOR,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_EMIT_GAS,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_TRANSFORM,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_ANIMATE_CORPSE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_RAISE_INTELLIGENT_UNDEAD,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SUMMON_BOGEYMAN,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_SUMMON_NIGHTMARE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_CREATE_GHOUL,
	INTERFACE_BUTTON_MAIN_ADVENTURE_INTERACTION_ICON_LUCK_CURSE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_N,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_S,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_W,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_E,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_NW,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_NE,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_SW,
	INTERFACE_BUTTON_MAIN_ADVENTURE_GO_DOWN_RAMP_SE,

	INTERFACE_BUTTON_MAIN_CONTRACT_LIST_SMALL,
	INTERFACE_BUTTON_MAIN_EXPAND_LIST_SMALL,

	INTERFACE_BUTTON_MAINNUM,
	INTERFACE_BUTTON_MAIN_NONE=-1
};
typedef int32_t InterfaceButtonMain;

enum InterfaceButtonSmallType
{
	INTERFACE_BUTTON_SMALL_SETTINGS,
	INTERFACE_BUTTON_SMALL_HELP,
	INTERFACE_BUTTON_SMALL_PAUSE_ACTIVE,
	INTERFACE_BUTTON_SMALL_PAUSE_INACTIVE,
	INTERFACE_BUTTON_SMALL_PLAY_ACTIVE,
	INTERFACE_BUTTON_SMALL_PLAY_INACTIVE,
	INTERFACE_BUTTON_SMALL_STRESS_0,
	INTERFACE_BUTTON_SMALL_STRESS_1,
	INTERFACE_BUTTON_SMALL_STRESS_2,
	INTERFACE_BUTTON_SMALL_STRESS_3,
	INTERFACE_BUTTON_SMALL_STRESS_4,
	INTERFACE_BUTTON_SMALL_STRESS_5,
	INTERFACE_BUTTON_SMALL_STRESS_6,
	INTERFACE_BUTTON_SMALLNUM,
	INTERFACE_BUTTON_SMALL_NONE=-1
};
typedef int32_t InterfaceButtonSmall;

enum InterfaceButtonAssignTradeType
{
	INTERFACE_BUTTON_ASSIGN_TRADE_SELECTED,
	INTERFACE_BUTTON_ASSIGN_TRADE_NOT_SELECTED,
	INTERFACE_BUTTON_ASSIGN_TRADE_IN_DEPOT,
	INTERFACE_BUTTON_ASSIGN_TRADE_BEING_BROUGHT,
	INTERFACE_BUTTON_ASSIGN_TRADE_PROHIBITED,
	INTERFACE_BUTTON_ASSIGN_TRADENUM,
	INTERFACE_BUTTON_ASSIGN_TRADE_NONE=-1
};
typedef int32_t InterfaceButtonAssignTrade;

enum InterfaceButtonBuildingInfoType
{
	INTERFACE_BUTTON_BUILDING_INFO_DOOR_FORBIDDEN_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_DOOR_FORBIDDEN,
	INTERFACE_BUTTON_BUILDING_INFO_DOOR_PERMITTED_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_DOOR_PERMITTED,
	INTERFACE_BUTTON_BUILDING_INFO_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_INACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_PRACTICE_FIRE_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_PRACTICE_FIRE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_FIRE_AT_WILL_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_FIRE_AT_WILL,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_PREPARE_TO_FIRE_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_PREPARE_TO_FIRE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_KEEP_LOADED_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_KEEP_LOADED,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_NOT_IN_USE_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_SIEGE_ENGINE_NOT_IN_USE,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_MEAT_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_MEAT,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_FISH_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_FISH,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_GEM_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_GEM,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_NONE_ACTIVE,
	INTERFACE_BUTTON_BUILDING_INFO_ANIMAL_TRAP_NONE,
	INTERFACE_BUTTON_BUILDING_INFONUM,
	INTERFACE_BUTTON_BUILDING_INFO_NONE=-1
};
typedef int32_t InterfaceButtonBuildingInfo;

enum InterfaceButtonLargeUnitSheetType
{
	INTERFACE_BUTTON_UNIT_SHEET_INVENTORY_ASSIGNED_SQUAD,
	INTERFACE_BUTTON_UNIT_SHEET_INVENTORY_ASSIGNED_CLOTHING,
	INTERFACE_BUTTON_UNIT_SHEET_INVENTORY_ASSIGNED_TOOL,
	INTERFACE_BUTTON_UNIT_SHEET_INVENTORY_ASSIGNED_SYMBOL,
	INTERFACE_BUTTON_UNIT_SHEETNUM,
	INTERFACE_BUTTON_UNIT_SHEET_NONE=-1
};
typedef int32_t InterfaceButtonLargeUnitSheet;

enum InterfaceButtonPetsLivestockType
{
	INTERFACE_BUTTON_PETS_LIVESTOCK_ASSIGN_TRAINER,
	INTERFACE_BUTTON_PETS_LIVESTOCK_WAR_TRAINING_INACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_WAR_TRAINING_ACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_HUNT_TRAINING_INACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_HUNT_TRAINING_ACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_ASSIGN_WORK_ANIMAL,
	INTERFACE_BUTTON_PETS_LIVESTOCK_UNAVAILABLE_AS_PET,
	INTERFACE_BUTTON_PETS_LIVESTOCK_AVAILABLE_AS_PET,
	INTERFACE_BUTTON_PETS_LIVESTOCK_SLAUGHTER_INACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_SLAUGHTER_ACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_GELD_INACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCK_GELD_ACTIVE,
	INTERFACE_BUTTON_PETS_LIVESTOCKNUM,
	INTERFACE_BUTTON_PETS_LIVESTOCK_NONE=-1
};
typedef int32_t InterfaceButtonPetsLivestock;

enum InterfaceButtonInventoryItemType
{
	INTERFACE_BUTTON_INVENTORY_ITEM_DETAILS,
	INTERFACE_BUTTON_INVENTORY_ITEM_DROP,
	INTERFACE_BUTTON_INVENTORY_ITEM_WEAR,
	INTERFACE_BUTTON_INVENTORY_ITEM_REMOVE,
	INTERFACE_BUTTON_INVENTORY_ITEM_PUT_INTO,
	INTERFACE_BUTTON_INVENTORY_ITEM_EAT_DRINK,
	INTERFACE_BUTTON_INVENTORY_ITEM_INTERACT,
	INTERFACE_BUTTON_INVENTORY_ITEMNUM,
	INTERFACE_BUTTON_INVENTORY_ITEM_NONE=-1
};
typedef int32_t InterfaceButtonInventoryItem;

enum InterfaceButtonBuildingSheetType
{
	INTERFACE_BUTTON_BUILDING_SHEET_ASSIGN_WORKER,
	INTERFACE_BUTTON_BUILDING_SHEET_CLEAR_WORKER,
	INTERFACE_BUTTON_BUILDING_SHEET_REMOVE,
	INTERFACE_BUTTON_BUILDING_SHEETNUM,
	INTERFACE_BUTTON_BUILDING_SHEET_NONE=-1
};
typedef int32_t InterfaceButtonBuildingSheet;

enum InterfaceButtonUnitSheetType
{
	INTERFACE_BUTTON_LARGE_UNIT_SHEET_CUSTOMIZE,
	INTERFACE_BUTTON_LARGE_UNIT_SHEET_EXPEL,
	INTERFACE_BUTTON_LARGE_UNIT_SHEET_CAMERA_INACTIVE,
	INTERFACE_BUTTON_LARGE_UNIT_SHEET_CAMERA_ACTIVE,
	INTERFACE_BUTTON_LARGE_UNIT_SHEET_VIEW_REPORTS,
	INTERFACE_BUTTON_LARGE_UNIT_SHEETNUM,
	INTERFACE_BUTTON_LARGE_UNIT_SHEET_NONE=-1
};
typedef int32_t InterfaceButtonUnitSheet;

enum InterfaceAdventureTravelDirType
{
	INTERFACE_ADVENTURE_TRAVEL_DIR_NW_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_N_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_NE_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_W_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_CENTER_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_E_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_SW_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_S_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_SE_YES,
	INTERFACE_ADVENTURE_TRAVEL_DIR_NW_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_N_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_NE_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_W_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_CENTER_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_E_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_SW_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_S_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_SE_NO,
	INTERFACE_ADVENTURE_TRAVEL_DIR_UP_DOWN,
	INTERFACE_ADVENTURE_TRAVEL_DIR_UP,
	INTERFACE_ADVENTURE_TRAVEL_DIR_DOWN,
	INTERFACE_ADVENTURE_TRAVEL_DIRNUM,
	INTERFACE_ADVENTURE_TRAVEL_DIR_NONE=-1
};
typedef int32_t InterfaceAdventureTravelDir;

enum InterfaceMoonWeatherType
{
	INTERFACE_MOON_WEATHER_WAXING_CRESCENT,
	INTERFACE_MOON_WEATHER_WAXING_HALF_MOON,
	INTERFACE_MOON_WEATHER_WAXING_GIBBOUS,
	INTERFACE_MOON_WEATHER_FULL_MOON,
	INTERFACE_MOON_WEATHER_WANING_GIBBOUS,
	INTERFACE_MOON_WEATHER_WANING_HALF_MOON,
	INTERFACE_MOON_WEATHER_WANING_CRESCENT,
	INTERFACE_MOON_WEATHER_NEW_MOON,
	INTERFACE_MOON_WEATHER_SNOW,
	INTERFACE_MOON_WEATHER_RAIN,
	INTERFACE_MOON_WEATHERNUM,
	INTERFACE_MOON_WEATHER_NONE=-1
};
typedef int32_t InterfaceMoonWeather;

enum TextureMapDrawnType
{
	TEXTURE_MAP_DRAWN_BACKGROUND,
	TEXTURE_MAP_DRAWN_GRASSLAND,
	TEXTURE_MAP_DRAWN_OCEAN,
	TEXTURE_MAP_DRAWN_FOREST_CONIFER,
	TEXTURE_MAP_DRAWN_FOREST_BROADLEAF,
	TEXTURE_MAP_DRAWN_HILLS,
	TEXTURE_MAP_DRAWN_MOUNTAINS,
	TEXTURE_MAP_DRAWN_MARSH,
	TEXTURE_MAP_DRAWN_GLACIER,
	TEXTURE_MAP_DRAWN_SITE,
	TEXTURE_MAP_DRAWN_DESERT_ROCK,
	TEXTURE_MAP_DRAWN_DESERT_BADLANDS,
	TEXTURE_MAP_DRAWN_DESERT_SAND,
	TEXTURE_MAP_DRAWN_ROAD_NSWE,
	TEXTURE_MAP_DRAWN_ROAD_NSW,
	TEXTURE_MAP_DRAWN_ROAD_NSE,
	TEXTURE_MAP_DRAWN_ROAD_NWE,
	TEXTURE_MAP_DRAWN_ROAD_SWE,
	TEXTURE_MAP_DRAWN_ROAD_NS,
	TEXTURE_MAP_DRAWN_ROAD_WE,
	TEXTURE_MAP_DRAWN_ROAD_NW,
	TEXTURE_MAP_DRAWN_ROAD_NE,
	TEXTURE_MAP_DRAWN_ROAD_SW,
	TEXTURE_MAP_DRAWN_ROAD_SE,
	TEXTURE_MAP_DRAWN_ROAD_N,
	TEXTURE_MAP_DRAWN_ROAD_S,
	TEXTURE_MAP_DRAWN_ROAD_W,
	TEXTURE_MAP_DRAWN_ROAD_E,
	TEXTURE_MAP_DRAWN_RIVER_NSWE,
	TEXTURE_MAP_DRAWN_RIVER_NSW,
	TEXTURE_MAP_DRAWN_RIVER_NSE,
	TEXTURE_MAP_DRAWN_RIVER_NWE,
	TEXTURE_MAP_DRAWN_RIVER_SWE,
	TEXTURE_MAP_DRAWN_RIVER_NS,
	TEXTURE_MAP_DRAWN_RIVER_WE,
	TEXTURE_MAP_DRAWN_RIVER_NW,
	TEXTURE_MAP_DRAWN_RIVER_NE,
	TEXTURE_MAP_DRAWN_RIVER_SW,
	TEXTURE_MAP_DRAWN_RIVER_SE,
	TEXTURE_MAP_DRAWN_RIVER_N,
	TEXTURE_MAP_DRAWN_RIVER_S,
	TEXTURE_MAP_DRAWN_RIVER_W,
	TEXTURE_MAP_DRAWN_RIVER_E,
	TEXTURE_MAP_DRAWN_SITE_LABYRINTH,
	TEXTURE_MAP_DRAWN_SITE_SHRINE,
	TEXTURE_MAP_DRAWN_SITE_LAIR,
	TEXTURE_MAP_DRAWN_SITE_CAVE,
	TEXTURE_MAP_DRAWN_SITE_CAMP,
	TEXTURE_MAP_DRAWN_SITE_MOUNTAIN_HOME,
	TEXTURE_MAP_DRAWN_SITE_HILLOCKS,
	TEXTURE_MAP_DRAWN_SITE_FORTRESS,
	TEXTURE_MAP_DRAWN_SITE_MOUNTAIN_RUIN,
	TEXTURE_MAP_DRAWN_SITE_DARK_FORTRESS,
	TEXTURE_MAP_DRAWN_SITE_DARK_PITS,
	TEXTURE_MAP_DRAWN_SITE_EVIL_RUIN,
	TEXTURE_MAP_DRAWN_SITE_HOME_TREE,
	TEXTURE_MAP_DRAWN_SITE_FOREST_RETREAT,
	TEXTURE_MAP_DRAWN_SITE_FOREST_RUIN,
	TEXTURE_MAP_DRAWN_SITE_CASTLE_RUIN,
	TEXTURE_MAP_DRAWN_SITE_NECROTOWER,
	TEXTURE_MAP_DRAWN_SITE_FORT,
	TEXTURE_MAP_DRAWN_SITE_MONASTERY,
	TEXTURE_MAP_DRAWN_SITE_CASTLE,
	TEXTURE_MAP_DRAWN_SITE_VAULT,
	TEXTURE_MAP_DRAWN_SITE_TOMB,
	TEXTURE_MAP_DRAWN_SITE_CITY,
	TEXTURE_MAP_DRAWN_SITE_TOWN,
	TEXTURE_MAP_DRAWN_SITE_CITY_RUIN,
	TEXTURE_MAP_DRAWN_SITE_VILLAGE,
	TEXTURE_MAP_DRAWN_SITE_VILLAGE_RUIN,
	TEXTURE_MAP_DRAWN_SITE_MYTHICAL_PALACE,
	TEXTURE_MAP_DRAWN_SITE_MYTHICAL_DUNGEON,
	TEXTURE_MAP_DRAWN_SITE_MYTHICAL_LAIR,
	TEXTURE_MAP_DRAWNNUM,
	TEXTURE_MAP_DRAWN_NONE=-1
};
typedef int32_t TextureMapDrawn;

enum TextureBridgeType
{
	TEXTURE_BRIDGE_1x1_RAISE_E,
	TEXTURE_BRIDGE_1x1_RAISE_W,
	TEXTURE_BRIDGE_1x1_RAISE_N,
	TEXTURE_BRIDGE_1x1_RAISE_S,
	TEXTURE_BRIDGE_NS_CENTER,
	TEXTURE_BRIDGE_NS_1,
	TEXTURE_BRIDGE_NS_W,
	TEXTURE_BRIDGE_NS_E,
	TEXTURE_BRIDGE_WE_CENTER,
	TEXTURE_BRIDGE_WE_1,
	TEXTURE_BRIDGE_WE_N,
	TEXTURE_BRIDGE_WE_S,
	TEXTURE_BRIDGE_RAISE_N_CENTER,
	TEXTURE_BRIDGE_RAISE_N_1,
	TEXTURE_BRIDGE_RAISE_N_W,
	TEXTURE_BRIDGE_RAISE_N_E,
	TEXTURE_BRIDGE_RAISE_S_CENTER,
	TEXTURE_BRIDGE_RAISE_S_1,
	TEXTURE_BRIDGE_RAISE_S_W,
	TEXTURE_BRIDGE_RAISE_S_E,
	TEXTURE_BRIDGE_RAISE_W_CENTER,
	TEXTURE_BRIDGE_RAISE_W_1,
	TEXTURE_BRIDGE_RAISE_W_N,
	TEXTURE_BRIDGE_RAISE_W_S,
	TEXTURE_BRIDGE_RAISE_E_CENTER,
	TEXTURE_BRIDGE_RAISE_E_1,
	TEXTURE_BRIDGE_RAISE_E_N,
	TEXTURE_BRIDGE_RAISE_E_S,
	TEXTURE_BRIDGE_RAISE_N_END_CENTER,
	TEXTURE_BRIDGE_RAISE_N_END_1,
	TEXTURE_BRIDGE_RAISE_N_END_W,
	TEXTURE_BRIDGE_RAISE_N_END_E,
	TEXTURE_BRIDGE_RAISE_S_END_CENTER,
	TEXTURE_BRIDGE_RAISE_S_END_1,
	TEXTURE_BRIDGE_RAISE_S_END_W,
	TEXTURE_BRIDGE_RAISE_S_END_E,
	TEXTURE_BRIDGE_RAISE_W_END_CENTER,
	TEXTURE_BRIDGE_RAISE_W_END_1,
	TEXTURE_BRIDGE_RAISE_W_END_N,
	TEXTURE_BRIDGE_RAISE_W_END_S,
	TEXTURE_BRIDGE_RAISE_E_END_CENTER,
	TEXTURE_BRIDGE_RAISE_E_END_1,
	TEXTURE_BRIDGE_RAISE_E_END_N,
	TEXTURE_BRIDGE_RAISE_E_END_S,
	TEXTURE_BRIDGE_RAISED_W_CENTER,
	TEXTURE_BRIDGE_RAISED_E_CENTER,
	TEXTURE_BRIDGE_RAISED_S_CENTER,
	TEXTURE_BRIDGE_RAISED_N_CENTER,
	TEXTURE_BRIDGE_RAISED_W_N,
	TEXTURE_BRIDGE_RAISED_W_S,
	TEXTURE_BRIDGE_RAISED_E_N,
	TEXTURE_BRIDGE_RAISED_E_S,
	TEXTURE_BRIDGE_RAISED_S_W,
	TEXTURE_BRIDGE_RAISED_S_E,
	TEXTURE_BRIDGE_RAISED_N_W,
	TEXTURE_BRIDGE_RAISED_N_E,
	TEXTURE_BRIDGE_RAISED_W_1,
	TEXTURE_BRIDGE_RAISED_E_1,
	TEXTURE_BRIDGE_RAISED_S_1,
	TEXTURE_BRIDGE_RAISED_N_1,
	TEXTURE_BRIDGE_CONSTRUCTION,
	TEXTURE_BRIDGE_RETRACT_1x1,
	TEXTURE_BRIDGE_RETRACT_CENTER,
	TEXTURE_BRIDGE_RETRACT_WE,
	TEXTURE_BRIDGE_RETRACT_W,
	TEXTURE_BRIDGE_RETRACT_E,
	TEXTURE_BRIDGE_RETRACT_NS,
	TEXTURE_BRIDGE_RETRACT_N,
	TEXTURE_BRIDGE_RETRACT_S,
	TEXTURE_BRIDGE_RETRACT_NWE,
	TEXTURE_BRIDGE_RETRACT_SWE,
	TEXTURE_BRIDGE_RETRACT_NSW,
	TEXTURE_BRIDGE_RETRACT_NSE,
	TEXTURE_BRIDGE_RETRACT_NE,
	TEXTURE_BRIDGE_RETRACT_NW,
	TEXTURE_BRIDGE_RETRACT_SW,
	TEXTURE_BRIDGE_RETRACT_SE,
	TEXTURE_BRIDGENUM,
	TEXTURE_BRIDGE_NONE=-1
};
typedef int32_t TextureBridge;

#define LOWER_VIEWPORT_MAX 8
#define REGION_SQUARE_VARIANT_NUM 5
#define REGION_SQUARE_MOUNTAIN_NUM 8
#define REGION_SQUARE_FOREST_NUM 8
#define REGION_SQUARE_RIVER_NUM 5
#define BROOK_FLOW_ANIMATION_NUM 16
#define RIVER_FLOW_ANIMATION_NUM 16

//************************ GLIQUID more types
	//can't yet do different blood colors, etc., but adding a second 32 bit liquid will allow another bit or two for types
#define VIEWPORT_LIQUID_TYPE_NONE 0
#define VIEWPORT_LIQUID_TYPE_WATER 1
#define VIEWPORT_LIQUID_TYPE_MAGMA 2

#define VIEWPORT_LIQUID_FLAG_CENTER_ANIMATION (BIT1|BIT2)
#define VIEWPORT_LIQUID_FLAG_CENTER_LEVEL (BIT3|BIT4|BIT5)
	#define VIEWPORT_LIQUID_FLAG_CENTER_LEVEL_SHIFT 2
#define VIEWPORT_LIQUID_FLAG_CENTER_TYPE (BIT6|BIT7|BIT8|BIT9)
	#define VIEWPORT_LIQUID_FLAG_CENTER_SHIFT 5
#define VIEWPORT_LIQUID_FLAG_N_EDGE_TYPE (BIT10|BIT11|BIT12|BIT13)
	#define VIEWPORT_LIQUID_FLAG_N_EDGE_SHIFT 9
#define VIEWPORT_LIQUID_FLAG_S_EDGE_TYPE (BIT14|BIT15|BIT16|BIT17)
	#define VIEWPORT_LIQUID_FLAG_S_EDGE_SHIFT 13
#define VIEWPORT_LIQUID_FLAG_W_EDGE_TYPE (BIT18|BIT19|BIT20|BIT21)
	#define VIEWPORT_LIQUID_FLAG_W_EDGE_SHIFT 17
#define VIEWPORT_LIQUID_FLAG_E_EDGE_TYPE (BIT22|BIT23|BIT24|BIT25)
	#define VIEWPORT_LIQUID_FLAG_E_EDGE_SHIFT 21

#define SPATTER_SHAPE_NONE 0
#define SPATTER_SHAPE_FULL_ISOLATED 1 //all fulls must be between SPATTER_SHAPE_FULL_ISOLATED and SPATTER_SHAPE_FULL_E
#define SPATTER_SHAPE_FULL_NSWE_A 2
#define SPATTER_SHAPE_FULL_NSWE_B 3
#define SPATTER_SHAPE_FULL_NSWE_C 4
#define SPATTER_SHAPE_FULL_NSWE_D 5
#define SPATTER_SHAPE_FULL_NSWE_E 6
#define SPATTER_SHAPE_FULL_NSW 7
#define SPATTER_SHAPE_FULL_NSE 8
#define SPATTER_SHAPE_FULL_NWE 9
#define SPATTER_SHAPE_FULL_SWE 10
#define SPATTER_SHAPE_FULL_NS 11
#define SPATTER_SHAPE_FULL_WE 12
#define SPATTER_SHAPE_FULL_NW 13
#define SPATTER_SHAPE_FULL_NE 14
#define SPATTER_SHAPE_FULL_SW 15
#define SPATTER_SHAPE_FULL_SE 16
#define SPATTER_SHAPE_FULL_N 17
#define SPATTER_SHAPE_FULL_S 18
#define SPATTER_SHAPE_FULL_W 19
#define SPATTER_SHAPE_FULL_E 20 //all fulls must be between SPATTER_SHAPE_FULL_ISOLATED and SPATTER_SHAPE_FULL_E
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL1A 21
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL2A 22
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL3A 23
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL4A 24
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL1B 25
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL2B 26
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL3B 27
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL4B 28
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL1C 29
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL2C 30
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL3C 31
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL4C 32
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL1D 33
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL2D 34
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL3D 35
#define SPATTER_SHAPE_PARTIAL_SPATTER_LVL4D 36

#define SPATTER_MATERIAL_SNOW 0
#define SPATTER_MATERIAL_BLOOD_RED 1
#define SPATTER_MATERIAL_BLOOD_CYAN 2
#define SPATTER_MATERIAL_BLOOD_MAGENTA 3
#define SPATTER_MATERIAL_BLOOD_GOO 4
#define SPATTER_MATERIAL_BLOOD_ICHOR 5
#define SPATTER_MATERIAL_DUST 6
#define SPATTER_MATERIAL_FRUIT 7
#define SPATTER_MATERIAL_FRUIT_SMALL 8
#define SPATTER_MATERIAL_FRUIT_LARGE 9
#define SPATTER_MATERIAL_LEAVES 10
#define SPATTER_MATERIAL_MAGMA_SPATTER 11
#define SPATTER_MATERIAL_MUD 12
#define SPATTER_MATERIAL_VOMIT 13
#define SPATTER_MATERIAL_WATER_SPATTER 14
#define SPATTER_MATERIAL_SLIME 15
#define SPATTER_MATERIALNUM 16//can be at most 32

#define VIEWPORT_SPATTER_FLAG_DERIVED_BITS (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19)
#define VIEWPORT_SPATTER_FLAG_SHAPE_TYPE (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
	#define VIEWPORT_SPATTER_FLAG_SHAPE_SHIFT 0
#define VIEWPORT_SPATTER_FLAG_MATERIAL_TYPE (BIT7|BIT8|BIT9|BIT10|BIT11)
	#define VIEWPORT_SPATTER_FLAG_MATERIAL_SHIFT 6
#define VIEWPORT_SPATTER_FLAG_COLOR_INDEX_BITS (BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19)
	#define VIEWPORT_SPATTER_FLAG_COLOR_INDEX_SHIFT 11
/////////// BIT20 - BIT28 - add to derived_bits above if they are used in the derivation function
#define VIEWPORT_SPATTER_FLAG_FIRE_BITS (BIT29|BIT30|BIT31)
	#define VIEWPORT_SPATTER_FLAG_FIRE_FRAME_1 BIT29
	#define VIEWPORT_SPATTER_FLAG_FIRE_FRAME_2 BIT30
	#define VIEWPORT_SPATTER_FLAG_FIRE_FRAME_3 BIT31
	#define VIEWPORT_SPATTER_FLAG_FIRE_FRAME_4 (BIT29|BIT30)
#define VIEWPORT_SPATTER_FLAG_ACCEPTS_SPATTER BIT32

enum InterfaceAdvEnvTextureType
{
	INTERFACE_ADV_ENV_TEXTURE_ODOR_BLOOD,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_SMOKE,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_MUD,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_BUG_INNARDS,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_COOKED_FLESH,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_DEATH,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_FILTH,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_SOOT,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_VOMIT,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_SOIL,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_FRESHLY_BAKED_GOODS,
	INTERFACE_ADV_ENV_TEXTURE_ODOR_BRIMSTONE,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_NEUTRAL,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_FIXED,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_BURNING,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_SCORCHING,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_HOT,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_WARM,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_DEATHLY_COLD,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_FREEZING,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_COLD,
	INTERFACE_ADV_ENV_TEXTURE_TEMP_COOL,
	INTERFACE_ADV_ENV_TEXTURE_SNOW,
	INTERFACE_ADV_ENV_TEXTURE_RAIN,
	INTERFACE_ADV_ENV_TEXTURE_RAIN_BLOOD,
	INTERFACE_ADV_ENV_TEXTURE_RAIN_WEIRD,
	INTERFACE_ADV_ENV_TEXTURE_LIGHT_INSIDE_DAWN,
	INTERFACE_ADV_ENV_TEXTURE_LIGHT_INSIDE_DAY,
	INTERFACE_ADV_ENV_TEXTURE_LIGHT_INSIDE_DUSK,
	INTERFACE_ADV_ENV_TEXTURE_LIGHT_INSIDE_NIGHT,
	INTERFACE_ADV_ENV_TEXTURE_EMPTY,
	INTERFACE_ADV_ENV_TEXTURE_CLOUD_CUMULUS_DARK,
	INTERFACE_ADV_ENV_TEXTURE_CLOUD_STRATUS_DARK,
	INTERFACE_ADV_ENV_TEXTURE_CLOUD_STRATUS_LIGHT,
	INTERFACE_ADV_ENV_TEXTURE_CLOUD_CUMULUS_LIGHT,
	INTERFACE_ADV_ENV_TEXTURE_CLOUD_CIRRUS,
	INTERFACE_ADV_ENV_TEXTURE_CLOUD_CUMULUS_PUFFS,
	INTERFACE_ADV_ENV_TEXTURE_FOG_HEAVY,
	INTERFACE_ADV_ENV_TEXTURE_FOG_NORMAL,
	INTERFACE_ADV_ENV_TEXTURE_FOG_MIST,
	INTERFACE_ADV_ENV_TEXTURE_WIND_SPEED_NONE,
	INTERFACE_ADV_ENV_TEXTURE_WIND_SPEED_1,
	INTERFACE_ADV_ENV_TEXTURE_WIND_SPEED_2,
	INTERFACE_ADV_ENV_TEXTURE_WIND_SPEED_3,
	INTERFACE_ADV_ENV_TEXTURE_WIND_SPEED_4,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_N,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_NE,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_E,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_SE,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_S,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_SW,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_W,
	INTERFACE_ADV_ENV_TEXTURE_WIND_DIR_NW,
	INTERFACE_ADV_ENV_TEXTURE_SUN_DAWN,
	INTERFACE_ADV_ENV_TEXTURE_SUN_UP_1,
	INTERFACE_ADV_ENV_TEXTURE_SUN_UP_2,
	INTERFACE_ADV_ENV_TEXTURE_SUN_UP_3,
	INTERFACE_ADV_ENV_TEXTURE_SUN_NOON,
	INTERFACE_ADV_ENV_TEXTURE_SUN_DOWN_1,
	INTERFACE_ADV_ENV_TEXTURE_SUN_DOWN_2,
	INTERFACE_ADV_ENV_TEXTURE_SUN_DOWN_3,
	INTERFACE_ADV_ENV_TEXTURE_SUN_DUSK,
	INTERFACE_ADV_ENV_TEXTURE_MOON_CRESCENT_WAX,
	INTERFACE_ADV_ENV_TEXTURE_MOON_HALF_WAX,
	INTERFACE_ADV_ENV_TEXTURE_MOON_GIBBOUS_WAX,
	INTERFACE_ADV_ENV_TEXTURE_MOON_FULL,
	INTERFACE_ADV_ENV_TEXTURE_MOON_GIBBOUS_WANE,
	INTERFACE_ADV_ENV_TEXTURE_MOON_HALF_WANE,
	INTERFACE_ADV_ENV_TEXTURE_MOON_CRESCENT_WANE,
	INTERFACE_ADV_ENV_TEXTURE_MOON_NEW,
	INTERFACE_ADV_ENV_TEXTURE_STARS,
	INTERFACE_ADV_ENV_TEXTURE_LIGHT_UNDERWORLD,
	INTERFACE_ADV_ENV_TEXTURE_LIGHT_EERIE,
	INTERFACE_ADV_ENV_TEXTURE_MOON_HIDDEN_BRIGHT,
	INTERFACE_ADV_ENV_TEXTURE_MOON_HIDDEN_MID,
	INTERFACE_ADV_ENV_TEXTURE_MOON_HIDDEN_DARK,
	INTERFACE_ADV_ENV_TEXTURENUM,
	INTERFACE_ADV_ENV_TEXTURE_NONE=-1
};
typedef int32_t InterfaceAdvEnvTexture;

struct interface_setst
{
	int32_t texpos_calendar_month[12][3];
	int32_t texpos_calendar_day_past[3];
	int32_t texpos_calendar_day_current[3];
	int32_t texpos_calendar_day_future[3];

	int32_t texpos_border_top_left[4][3];
	int32_t texpos_border_top_right[4][3];
	int32_t texpos_border_bottom_left[4][3];
	int32_t texpos_border_bottom_right[4][3];
	int32_t texpos_border_top_intersection[4][2];
	int32_t texpos_border_bottom_intersection[4][2];
	int32_t texpos_border_middle_intersection[4];
	int32_t texpos_border_left_intersection[3][3];
	int32_t texpos_border_right_intersection[3][3];
	int32_t texpos_border_left[4];
	int32_t texpos_border_right[4];
	int32_t texpos_border_top[3];
	int32_t texpos_border_bottom[3];
	int32_t texpos_hover_rectangle[3][3];
	int32_t texpos_hover_rectangle_join_w_sw;
	int32_t texpos_hover_rectangle_join_w_s;
	int32_t texpos_hover_rectangle_join_e_s;
	int32_t texpos_hover_rectangle_join_e_se;
	int32_t texpos_hover_close[3][2];
	int32_t texpos_hover_tab[3][3];
	int32_t texpos_hover_tab_inactive[3];
	int32_t texpos_hover_tab_inside_corner_top;
	int32_t texpos_hover_tab_inside_corner_bottom;
	int32_t texpos_button_rectangle[3][3];
	int32_t texpos_button_rectangle_selected[3][3];
	int32_t texpos_button_rectangle_light[3][3];
	int32_t texpos_button_rectangle_dark[3][3];
	int32_t texpos_button_rectangle_divider[3];
	int32_t texpos_button_category_rectangle[3][3];
	int32_t texpos_button_category_rectangle_selected[3][3];
	int32_t texpos_button_category_rectangle_on[3][3];
	int32_t texpos_button_category_rectangle_on_selected[3][3];
	int32_t texpos_button_category_rectangle_off[3][3];
	int32_t texpos_button_category_rectangle_off_selected[3][3];
	int32_t texpos_button_filter[6][3];
	int32_t texpos_button_filter_no_mag_right[3];
	int32_t texpos_button_filter_name[4][3];
	int32_t texpos_button_picture_box[3][3];
	int32_t texpos_button_picture_box_selected[3][3];
	int32_t texpos_button_picture_box_highlighted[3][3];
	int32_t texpos_button_picture_box_sel_highlighted[3][3];
	int32_t texpos_button_picture_box_light[3][3];
	int32_t texpos_button_picture_box_dark[3][3];
	int32_t texpos_button_picture_box_divider[3];
	int32_t texpos_button_add[3][3];
	int32_t texpos_button_add_hover[3][3];
	int32_t texpos_button_add_pressed[3][3];
	int32_t texpos_button_add_invalid[3][3];
	int32_t texpos_button_subtract[3][3];
	int32_t texpos_button_subtract_hover[3][3];
	int32_t texpos_button_subtract_pressed[3][3];
	int32_t texpos_button_subtract_invalid[3][3];
	int32_t texpos_button_expander_closed[2][3];
	int32_t texpos_button_expander_open[2][3];
	int32_t texpos_scrollbar[2][3];
	int32_t texpos_scrollbar_up_hover[2];
	int32_t texpos_scrollbar_up_pressed[2];
	int32_t texpos_scrollbar_down_hover[2];
	int32_t texpos_scrollbar_down_pressed[2];
	int32_t texpos_scrollbar_small_scroller[2][2];
	int32_t texpos_scrollbar_small_scroller_hover[2][2];
	int32_t texpos_scrollbar_top_scroller[2];
	int32_t texpos_scrollbar_top_scroller_hover[2];
	int32_t texpos_scrollbar_bottom_scroller[2];
	int32_t texpos_scrollbar_bottom_scroller_hover[2];
	int32_t texpos_scrollbar_blank_scroller[2];
	int32_t texpos_scrollbar_blank_scroller_hover[2];
	int32_t texpos_scrollbar_center_scroller[2];
	int32_t texpos_scrollbar_center_scroller_hover[2];
	int32_t texpos_scrollbar_offcenter_scroller[2][2];
	int32_t texpos_scrollbar_offcenter_scroller_hover[2][2];
	int32_t texpos_scrollbar_sky[2];
	int32_t texpos_scrollbar_ground[2];
	int32_t texpos_scrollbar_underground[2];
	int32_t texpos_slider_background[3][3];
	int32_t texpos_slider[2][3];
	int32_t texpos_slider_hover[2][3];
	int32_t texpos_tab[5][3];
	int32_t texpos_tab_selected[5][3];
	int32_t texpos_short_tab[5][2];
	int32_t texpos_short_tab_selected[5][2];
	int32_t texpos_short_subtab[5][2];
	int32_t texpos_short_subtab_selected[5][2];
	int32_t texpos_short_subsubtab[5][2];
	int32_t texpos_short_subsubtab_selected[5][2];
	int32_t texpos_interface_background;
	int32_t texpos_button_main[INTERFACE_BUTTON_MAINNUM][4][3];
	int32_t texpos_button_small[INTERFACE_BUTTON_SMALLNUM][2][2];
	int32_t texpos_button_horizontal_option_left_ornament[4][3];
	int32_t texpos_button_horizontal_option_active[3][3];
	int32_t texpos_button_horizontal_option_inactive[3][3];
	int32_t texpos_button_horizontal_option_right_ornament[4][3];
	int32_t texpos_button_horizontal_option_remove[3][3];
	int32_t texpos_button_horizontal_option_confirm[3][3];
	int32_t texpos_interior_border_n_s_w_e;
	int32_t texpos_interior_border_n_w_e;
	int32_t texpos_interior_border_s_w_e;
	int32_t texpos_interior_border_w_e;
	int32_t texpos_interior_border_n_s;
	int32_t texpos_sort_ascending_active[4];
	int32_t texpos_sort_ascending_inactive[4];
	int32_t texpos_sort_descending_active[4];
	int32_t texpos_sort_descending_inactive[4];
	int32_t texpos_sort_text_active[3];
	int32_t texpos_sort_text_inactive[3];
	int32_t texpos_siege_light[3][3];
	int32_t texpos_diplomacy_light[3][3];
	int32_t texpos_petitions_light[3][3];
	int32_t texpos_grid_cell_inactive[3][3];
	int32_t texpos_grid_cell_active[3][3];
	int32_t texpos_grid_cell_button[3][3];
	int32_t texpos_type_filter_left[3];
	int32_t texpos_type_filter_right[3];
	int32_t texpos_type_filter_text[3];
	int32_t texpos_pinned[2];
	int32_t texpos_not_pinned[2];
	int32_t texpos_button_wrestle_right[3];
	int32_t texpos_button_wrestle_equal[3];
	int32_t texpos_button_wrestle_left[3];
	int32_t texpos_button_adventure_tactical_mode_on[4][2];
	int32_t texpos_button_adventure_tactical_mode_off[4][2];

	int32_t texpos_adventure_log_pinned_active[3][3];
	int32_t texpos_adventure_log_pinned_inactive[3][3];
	int32_t texpos_adventure_log_item_active[3][3];
	int32_t texpos_adventure_log_item_inactive[3][3];

	int32_t texpos_button_announcement_open_all_announcements[3][3];
	int32_t texpos_button_announcement_not_pausing_on_new_report[3*3];
	int32_t texpos_button_announcement_pausing_on_new_report[3*3];
	int32_t texpos_button_announcement_open_from_main[3][3];

	int32_t texpos_button_quality_up[3][3];
	int32_t texpos_button_quality_down[3][3];
	int32_t texpos_button_quality_up_inactive[3][3];
	int32_t texpos_button_quality_down_inactive[3][3];

	int32_t texpos_button_stocks_recenter[3][3];
	int32_t texpos_button_stocks_view_item[3][3];
	int32_t texpos_button_stocks_forbid[3][3];
	int32_t texpos_button_stocks_forbid_active[3][3];
	int32_t texpos_button_stocks_dump[3][3];
	int32_t texpos_button_stocks_dump_active[3][3];
	int32_t texpos_button_stocks_melt[3][3];
	int32_t texpos_button_stocks_melt_active[3][3];
	int32_t texpos_button_stocks_hide[3][3];
	int32_t texpos_button_stocks_hide_active[3][3];

	int32_t texpos_button_short_forbid[3][2];
	int32_t texpos_button_short_forbid_active[3][2];
	int32_t texpos_button_short_dump[3][2];
	int32_t texpos_button_short_dump_active[3][2];
	int32_t texpos_button_short_melt[3][2];
	int32_t texpos_button_short_melt_active[3][2];
	int32_t texpos_button_short_hide[3][2];
	int32_t texpos_button_short_hide_active[3][2];

	int32_t texpos_building_short_item_task[3][2];
	int32_t texpos_building_item_task[3][3];
	int32_t texpos_building_item_incorporated[3][3];
	int32_t texpos_building_item_trade[3][3];
	int32_t texpos_building_item_animal[3][3];
	int32_t texpos_building_item_bait[3][3];
	int32_t texpos_building_item_loaded[3][3];
	int32_t texpos_building_item_dead[3][3];
	int32_t texpos_building_item_other[3][3];

	int32_t texpos_building_jobs_repeat[3][3];
	int32_t texpos_building_jobs_repeat_active[3][3];
	int32_t texpos_building_jobs_do_now[3][3];
	int32_t texpos_building_jobs_do_now_active[3][3];
	int32_t texpos_building_jobs_suspended[3][3];
	int32_t texpos_building_jobs_suspended_active[3][3];
	int32_t texpos_building_jobs_priority_up[3][3];
	int32_t texpos_building_jobs_remove[3][3];
	int32_t texpos_building_jobs_active[3][3];
	int32_t texpos_building_jobs_quota[3][3];
	int32_t texpos_building_jobs_remove_worker[3][3];

	int32_t texpos_button_assign_trade[INTERFACE_BUTTON_ASSIGN_TRADENUM][3][3];
	int32_t texpos_button_building_info[INTERFACE_BUTTON_BUILDING_INFONUM][3][3];
	int32_t texpos_button_building_sheet[INTERFACE_BUTTON_BUILDING_SHEETNUM][4][3];
	int32_t texpos_button_unit_sheet[INTERFACE_BUTTON_UNIT_SHEETNUM][3][3];
	int32_t texpos_button_large_unit_sheet[INTERFACE_BUTTON_LARGE_UNIT_SHEETNUM][4][3];
	int32_t texpos_button_pets_livestock[INTERFACE_BUTTON_PETS_LIVESTOCKNUM][3][3];
	int32_t texpos_button_inventory_item[INTERFACE_BUTTON_INVENTORY_ITEMNUM][3][3];

	int32_t texpos_adventure_travel_dir[INTERFACE_ADVENTURE_TRAVEL_DIRNUM];

	int32_t texpos_skill_progress_bar_left_full;
	int32_t texpos_skill_progress_bar_mid_full;
	int32_t texpos_skill_progress_bar_right_full;
	int32_t texpos_skill_progress_bar_left_half;
	int32_t texpos_skill_progress_bar_mid_half;
	int32_t texpos_skill_progress_bar_right_half;
	int32_t texpos_skill_progress_bar_left_empty;
	int32_t texpos_skill_progress_bar_mid_empty;
	int32_t texpos_skill_progress_bar_right_empty;

	int32_t texpos_liquid_numbers_on[2][2];
	int32_t texpos_liquid_numbers_off[2][2];
	int32_t texpos_ramp_arrows_on[2][2];
	int32_t texpos_ramp_arrows_off[2][2];

	int32_t texpos_zoom_in_on[2][2];
	int32_t texpos_zoom_in_off[2][2];
	int32_t texpos_zoom_out_on[2][2];
	int32_t texpos_zoom_out_off[2][2];

	int32_t texpos_adv_liquid_numbers_on[2][2];
	int32_t texpos_adv_liquid_numbers_off[2][2];
	int32_t texpos_adv_ramp_arrows_on[2][2];
	int32_t texpos_adv_ramp_arrows_off[2][2];

	int32_t texpos_adv_zoom_in_on[2][2];
	int32_t texpos_adv_zoom_in_off[2][2];
	int32_t texpos_adv_zoom_out_on[2][2];
	int32_t texpos_adv_zoom_out_off[2][2];
	int32_t texpos_adv_tracks_on[2][2];
	int32_t texpos_adv_tracks_off[2][2];

	int32_t texpos_adv_env[INTERFACE_ADV_ENV_TEXTURENUM][4][3];

	int32_t texpos_legends_tab_page_left[3][2];
	int32_t texpos_legends_tab_page_right[3][2];
	int32_t texpos_legends_tab_close_inactive[2];
	int32_t texpos_legends_tab_close_active[2];

	int32_t texpos_help_border[3][3];
	int32_t texpos_help_corner[8][6];
	int32_t texpos_help_close[3][2];
	int32_t texpos_help_hide[3][2];
	int32_t texpos_help_reveal[3][2];

	int32_t texpos_embark_selected[4][3];
	int32_t texpos_embark_not_selected[4][3];
	int32_t texpos_embark_expand_y_active[2][3];
	int32_t texpos_embark_expand_y_inactive[2][3];
	int32_t texpos_embark_contract_y_active[2][3];
	int32_t texpos_embark_contract_y_inactive[2][3];
	int32_t texpos_embark_expand_x_active[4];
	int32_t texpos_embark_expand_x_inactive[4];
	int32_t texpos_embark_contract_x_active[4];
	int32_t texpos_embark_contract_x_inactive[4];

	int32_t texpos_adventure_burden_light[4];
	int32_t texpos_adventure_burden_heavy[4];

	int32_t texpos_bottom_button_border_nw;
	int32_t texpos_bottom_button_border_w;
	int32_t texpos_bottom_button_border_n;
	int32_t texpos_bottom_button_border_interior;
	int32_t texpos_bottom_button_border_ne;
	int32_t texpos_bottom_button_border_e;



	interface_setst()
		{
		init();
		}
	void init()
		{
		memset(texpos_border_top_left,0,sizeof(int32_t)*4*3);
		memset(texpos_border_top_right,0,sizeof(int32_t)*4*3);
		memset(texpos_border_bottom_left,0,sizeof(int32_t)*4*3);
		memset(texpos_border_bottom_right,0,sizeof(int32_t)*4*3);
		memset(texpos_border_top_intersection,0,sizeof(int32_t)*4*2);
		memset(texpos_border_bottom_intersection,0,sizeof(int32_t)*4*2);
		memset(texpos_border_middle_intersection,0,sizeof(int32_t)*4);
		memset(texpos_border_left_intersection,0,sizeof(int32_t)*3*3);
		memset(texpos_border_right_intersection,0,sizeof(int32_t)*3*3);
		memset(texpos_border_left,0,sizeof(int32_t)*4);
		memset(texpos_border_right,0,sizeof(int32_t)*4);
		memset(texpos_border_top,0,sizeof(int32_t)*3);
		memset(texpos_border_bottom,0,sizeof(int32_t)*3);

		memset(texpos_hover_rectangle,0,sizeof(int32_t)*3*3);
		texpos_hover_rectangle_join_w_sw=0;
		texpos_hover_rectangle_join_w_s=0;
		texpos_hover_rectangle_join_e_s=0;
		texpos_hover_rectangle_join_e_se=0;
		memset(texpos_hover_close,0,sizeof(int32_t)*3*2);
		memset(texpos_hover_tab,0,sizeof(int32_t)*3*3);
		memset(texpos_hover_tab_inactive,0,sizeof(int32_t)*3);
		texpos_hover_tab_inside_corner_top=0;
		texpos_hover_tab_inside_corner_bottom=0;
		memset(texpos_button_rectangle,0,sizeof(int32_t)*3*3);
		memset(texpos_button_rectangle_selected,0,sizeof(int32_t)*3*3);
		memset(texpos_button_rectangle_light,0,sizeof(int32_t)*3*3);
		memset(texpos_button_rectangle_dark,0,sizeof(int32_t)*3*3);
		memset(texpos_button_rectangle_divider,0,sizeof(int32_t)*3);
		memset(texpos_button_picture_box,0,sizeof(int32_t)*3*3);
		memset(texpos_button_picture_box_selected,0,sizeof(int32_t)*3*3);
		memset(texpos_button_picture_box_highlighted,0,sizeof(int32_t)*3*3);
		memset(texpos_button_picture_box_sel_highlighted,0,sizeof(int32_t)*3*3);
		memset(texpos_button_picture_box_light,0,sizeof(int32_t)*3*3);
		memset(texpos_button_picture_box_dark,0,sizeof(int32_t)*3*3);
		memset(texpos_button_add,0,sizeof(int32_t)*3*3);
		memset(texpos_button_add_hover,0,sizeof(int32_t)*3*3);
		memset(texpos_button_add_pressed,0,sizeof(int32_t)*3*3);
		memset(texpos_button_add_invalid,0,sizeof(int32_t)*3*3);
		memset(texpos_button_subtract,0,sizeof(int32_t)*3*3);
		memset(texpos_button_subtract_hover,0,sizeof(int32_t)*3*3);
		memset(texpos_button_subtract_pressed,0,sizeof(int32_t)*3*3);
		memset(texpos_button_subtract_invalid,0,sizeof(int32_t)*3*3);
		memset(texpos_button_expander_closed,0,sizeof(int32_t)*2*3);
		memset(texpos_button_expander_open,0,sizeof(int32_t)*2*3);
		memset(texpos_button_category_rectangle,0,sizeof(int32_t)*3*3);
		memset(texpos_button_category_rectangle_selected,0,sizeof(int32_t)*3*3);
		memset(texpos_button_category_rectangle_on,0,sizeof(int32_t)*3*3);
		memset(texpos_button_category_rectangle_on_selected,0,sizeof(int32_t)*3*3);
		memset(texpos_button_category_rectangle_off,0,sizeof(int32_t)*3*3);
		memset(texpos_button_category_rectangle_off_selected,0,sizeof(int32_t)*3*3);
		memset(texpos_button_filter,0,sizeof(int32_t)*6*3);
		memset(texpos_button_filter_no_mag_right,0,sizeof(int32_t)*3);
		memset(texpos_button_filter_name,0,sizeof(int32_t)*4*3);
		memset(texpos_button_main,0,sizeof(int32_t)*INTERFACE_BUTTON_MAINNUM*4*3);
		memset(texpos_button_small,0,sizeof(int32_t)*INTERFACE_BUTTON_SMALLNUM*2*2);

		memset(texpos_calendar_month,0,sizeof(int32_t)*12*3);
		memset(texpos_calendar_day_past,0,sizeof(int32_t)*3);
		memset(texpos_calendar_day_current,0,sizeof(int32_t)*3);
		memset(texpos_calendar_day_future,0,sizeof(int32_t)*3);

		memset(texpos_slider_background,0,sizeof(int32_t)*3*3);
		memset(texpos_slider,0,sizeof(int32_t)*2*3);
		memset(texpos_slider_hover,0,sizeof(int32_t)*2*3);

		memset(texpos_scrollbar,0,sizeof(int32_t)*2*3);
		memset(texpos_scrollbar_up_hover,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_up_pressed,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_down_hover,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_down_pressed,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_small_scroller,0,sizeof(int32_t)*2*2);
		memset(texpos_scrollbar_small_scroller_hover,0,sizeof(int32_t)*2*2);
		memset(texpos_scrollbar_top_scroller,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_top_scroller_hover,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_bottom_scroller,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_bottom_scroller_hover,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_blank_scroller,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_blank_scroller_hover,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_center_scroller,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_center_scroller_hover,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_offcenter_scroller,0,sizeof(int32_t)*2*2);
		memset(texpos_scrollbar_offcenter_scroller_hover,0,sizeof(int32_t)*2*2);
		memset(texpos_scrollbar_sky,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_ground,0,sizeof(int32_t)*2);
		memset(texpos_scrollbar_underground,0,sizeof(int32_t)*2);

		memset(texpos_sort_ascending_active,0,sizeof(int32_t)*4);
		memset(texpos_sort_ascending_inactive,0,sizeof(int32_t)*4);
		memset(texpos_sort_descending_active,0,sizeof(int32_t)*4);
		memset(texpos_sort_descending_inactive,0,sizeof(int32_t)*4);
		memset(texpos_sort_text_active,0,sizeof(int32_t)*3);
		memset(texpos_sort_text_inactive,0,sizeof(int32_t)*3);
		memset(texpos_type_filter_left,0,sizeof(int32_t)*3);
		memset(texpos_type_filter_right,0,sizeof(int32_t)*3);
		memset(texpos_type_filter_text,0,sizeof(int32_t)*3);

		memset(texpos_pinned,0,sizeof(int32_t)*2);
		memset(texpos_not_pinned,0,sizeof(int32_t)*2);

		memset(texpos_tab,0,sizeof(int32_t)*5*3);
		memset(texpos_tab_selected,0,sizeof(int32_t)*5*3);
		memset(texpos_short_tab,0,sizeof(int32_t)*5*2);
		memset(texpos_short_tab_selected,0,sizeof(int32_t)*5*2);
		memset(texpos_short_subtab,0,sizeof(int32_t)*5*2);
		memset(texpos_short_subtab_selected,0,sizeof(int32_t)*5*2);
		memset(texpos_short_subsubtab,0,sizeof(int32_t)*5*2);
		memset(texpos_short_subsubtab_selected,0,sizeof(int32_t)*5*2);
		texpos_interior_border_n_s_w_e=0;
		texpos_interior_border_n_w_e=0;
		texpos_interior_border_s_w_e=0;
		texpos_interior_border_w_e=0;
		texpos_interior_border_n_s=0;
		texpos_interface_background=0;
		memset(texpos_button_horizontal_option_left_ornament,0,sizeof(int32_t)*4*3);
		memset(texpos_button_horizontal_option_active,0,sizeof(int32_t)*3*3);
		memset(texpos_button_horizontal_option_inactive,0,sizeof(int32_t)*3*3);
		memset(texpos_button_horizontal_option_remove,0,sizeof(int32_t)*3*3);
		memset(texpos_button_horizontal_option_confirm,0,sizeof(int32_t)*3*3);
		memset(texpos_button_horizontal_option_right_ornament,0,sizeof(int32_t)*4*3);
		memset(texpos_siege_light,0,sizeof(int32_t)*3*3);
		memset(texpos_diplomacy_light,0,sizeof(int32_t)*3*3);
		memset(texpos_petitions_light,0,sizeof(int32_t)*3*3);
		memset(texpos_grid_cell_inactive,0,sizeof(int32_t)*3*3);
		memset(texpos_grid_cell_active,0,sizeof(int32_t)*3*3);
		memset(texpos_grid_cell_button,0,sizeof(int32_t)*3*3);
		memset(texpos_button_wrestle_right,0,sizeof(int32_t)*3);
		memset(texpos_button_wrestle_equal,0,sizeof(int32_t)*3);
		memset(texpos_button_wrestle_left,0,sizeof(int32_t)*3);
		memset(texpos_button_adventure_tactical_mode_on,0,sizeof(int32_t)*4*2);
		memset(texpos_button_adventure_tactical_mode_off,0,sizeof(int32_t)*4*2);

		memset(texpos_adventure_log_pinned_active,0,sizeof(int32_t)*3*3);
		memset(texpos_adventure_log_pinned_inactive,0,sizeof(int32_t)*3*3);
		memset(texpos_adventure_log_item_active,0,sizeof(int32_t)*3*3);
		memset(texpos_adventure_log_item_inactive,0,sizeof(int32_t)*3*3);

		memset(texpos_button_announcement_open_all_announcements,0,sizeof(int32_t)*3*3);
		memset(texpos_button_announcement_not_pausing_on_new_report,0,sizeof(int32_t)*3*3);
		memset(texpos_button_announcement_pausing_on_new_report,0,sizeof(int32_t)*3*3);
		memset(texpos_button_announcement_open_from_main,0,sizeof(int32_t)*3*3);

		memset(texpos_button_quality_up,0,sizeof(int32_t)*3*3);
		memset(texpos_button_quality_down,0,sizeof(int32_t)*3*3);
		memset(texpos_button_quality_up_inactive,0,sizeof(int32_t)*3*3);
		memset(texpos_button_quality_down_inactive,0,sizeof(int32_t)*3*3);

		memset(texpos_button_stocks_recenter,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_view_item,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_forbid,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_forbid_active,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_dump,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_dump_active,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_melt,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_melt_active,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_hide,0,sizeof(int32_t)*3*3);
		memset(texpos_button_stocks_hide_active,0,sizeof(int32_t)*3*3);

		memset(texpos_button_short_forbid,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_forbid_active,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_dump,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_dump_active,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_melt,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_melt_active,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_hide,0,sizeof(int32_t)*3*2);
		memset(texpos_button_short_hide_active,0,sizeof(int32_t)*3*2);

		memset(texpos_building_short_item_task,0,sizeof(int32_t)*3*2);
		memset(texpos_building_item_task,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_incorporated,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_trade,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_animal,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_bait,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_loaded,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_dead,0,sizeof(int32_t)*3*3);
		memset(texpos_building_item_other,0,sizeof(int32_t)*3*3);

		memset(texpos_building_jobs_repeat,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_repeat_active,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_do_now,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_do_now_active,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_suspended,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_suspended_active,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_priority_up,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_remove,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_active,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_quota,0,sizeof(int32_t)*3*3);
		memset(texpos_building_jobs_remove_worker,0,sizeof(int32_t)*3*3);

		memset(texpos_button_assign_trade,0,sizeof(int32_t)*3*3*INTERFACE_BUTTON_ASSIGN_TRADENUM);
		memset(texpos_button_building_info,0,sizeof(int32_t)*3*3*INTERFACE_BUTTON_BUILDING_INFONUM);
		memset(texpos_button_building_sheet,0,sizeof(int32_t)*4*3*INTERFACE_BUTTON_BUILDING_SHEETNUM);
		memset(texpos_button_unit_sheet,0,sizeof(int32_t)*3*3*INTERFACE_BUTTON_UNIT_SHEETNUM);
		memset(texpos_button_large_unit_sheet,0,sizeof(int32_t)*4*3*INTERFACE_BUTTON_LARGE_UNIT_SHEETNUM);
		memset(texpos_button_pets_livestock,0,sizeof(int32_t)*3*3*INTERFACE_BUTTON_PETS_LIVESTOCKNUM);
		memset(texpos_button_inventory_item,0,sizeof(int32_t)*3*3*INTERFACE_BUTTON_INVENTORY_ITEMNUM);

		memset(texpos_adventure_travel_dir,0,sizeof(int32_t)*INTERFACE_ADVENTURE_TRAVEL_DIRNUM);

		texpos_skill_progress_bar_left_full=0;
		texpos_skill_progress_bar_mid_full=0;
		texpos_skill_progress_bar_right_full=0;
		texpos_skill_progress_bar_left_half=0;
		texpos_skill_progress_bar_mid_half=0;
		texpos_skill_progress_bar_right_half=0;
		texpos_skill_progress_bar_left_empty=0;
		texpos_skill_progress_bar_mid_empty=0;
		texpos_skill_progress_bar_right_empty=0;

		memset(texpos_liquid_numbers_on,0,sizeof(int32_t)*2*2);
		memset(texpos_liquid_numbers_off,0,sizeof(int32_t)*2*2);
		memset(texpos_ramp_arrows_on,0,sizeof(int32_t)*2*2);
		memset(texpos_ramp_arrows_off,0,sizeof(int32_t)*2*2);

		memset(texpos_zoom_in_on,0,sizeof(int32_t)*2*2);
		memset(texpos_zoom_in_off,0,sizeof(int32_t)*2*2);
		memset(texpos_zoom_out_on,0,sizeof(int32_t)*2*2);
		memset(texpos_zoom_out_off,0,sizeof(int32_t)*2*2);

		memset(texpos_adv_liquid_numbers_on,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_liquid_numbers_off,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_ramp_arrows_on,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_ramp_arrows_off,0,sizeof(int32_t)*2*2);

		memset(texpos_adv_zoom_in_on,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_zoom_in_off,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_zoom_out_on,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_zoom_out_off,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_tracks_on,0,sizeof(int32_t)*2*2);
		memset(texpos_adv_tracks_off,0,sizeof(int32_t)*2*2);

		memset(texpos_adv_env,0,sizeof(int32_t)*INTERFACE_ADV_ENV_TEXTURENUM*4*3);

		memset(texpos_legends_tab_page_left,0,sizeof(int32_t)*3*2);
		memset(texpos_legends_tab_page_right,0,sizeof(int32_t)*3*2);
		memset(texpos_legends_tab_close_inactive,0,sizeof(int32_t)*2);
		memset(texpos_legends_tab_close_active,0,sizeof(int32_t)*2);

		memset(texpos_embark_selected,0,sizeof(int32_t)*4*3);
		memset(texpos_embark_not_selected,0,sizeof(int32_t)*4*3);
		memset(texpos_embark_expand_y_active,0,sizeof(int32_t)*2*3);
		memset(texpos_embark_expand_y_inactive,0,sizeof(int32_t)*2*3);
		memset(texpos_embark_contract_y_active,0,sizeof(int32_t)*2*3);
		memset(texpos_embark_contract_y_inactive,0,sizeof(int32_t)*2*3);
		memset(texpos_embark_expand_x_active,0,sizeof(int32_t)*4);
		memset(texpos_embark_expand_x_inactive,0,sizeof(int32_t)*4);
		memset(texpos_embark_contract_x_active,0,sizeof(int32_t)*4);
		memset(texpos_embark_contract_x_inactive,0,sizeof(int32_t)*4);

		memset(texpos_adventure_burden_light,0,sizeof(int32_t)*4);
		memset(texpos_adventure_burden_heavy,0,sizeof(int32_t)*4);

		memset(texpos_help_border,0,sizeof(int32_t)*3*3);
		memset(texpos_help_corner,0,sizeof(int32_t)*8*6);
		memset(texpos_help_close,0,sizeof(int32_t)*3*2);
		memset(texpos_help_hide,0,sizeof(int32_t)*3*2);
		memset(texpos_help_reveal,0,sizeof(int32_t)*3*2);

		texpos_bottom_button_border_nw=0;
		texpos_bottom_button_border_w=0;
		texpos_bottom_button_border_n=0;
		texpos_bottom_button_border_interior=0;
		texpos_bottom_button_border_ne=0;
		texpos_bottom_button_border_e=0;
		}
	void copy_from_main();
	void swap_with_main();
};

class cached_texturest {
	int w, h;
	std::variant<SDL_Texture*, SDL_Surface*> tex;
public:
	cached_texturest();
	cached_texturest(SDL_Surface* s);
	~cached_texturest();
	SDL_Texture* get_texture();
	void get_size(int& out_w, int& out_h) {
		out_w = w;
		out_h = h;
	}
};

struct texblitst {
	int32_t x, y;
	int8_t tex;
};

#include <array>

using override_tile_type=uint8_t;

constexpr override_tile_type OVERRIDE_CHAR=BIT1;

constexpr override_tile_type OVERRIDE_TILE=BIT2;

constexpr override_tile_type OVERRIDE_TOP_TILE=BIT3;

constexpr override_tile_type OVERRIDE_LOWER_TILE=BIT4;

constexpr override_tile_type OVERRIDE_TOP_LOWER_TILE=BIT5;

constexpr override_tile_type OVERRIDE_ANCHORED_TILE=BIT6;

constexpr override_tile_type OVERRIDE_TOP_ANCHORED_TILE=BIT7;

class graphicst
{
	public:
		//clear any new ptrs in delete_all_viewports()
		svector<graphic_viewportst *> viewport;
			graphic_viewportst *main_viewport;
			graphic_viewportst *lower_viewport[LOWER_VIEWPORT_MAX];
		svector<graphic_map_portst *> map_port;
			graphic_map_portst *main_map_port;
		//******************************* MAP CASES vars
			//need all possible cases here

		int32_t viewport_zoom_factor;

		int32_t screenx,screeny;
		char screenf,screenb;
		char screenbright;
		bool use_old_16_colors;
		unsigned char screen_color_r;
		unsigned char screen_color_g;
		unsigned char screen_color_b;
		unsigned char screen_color_br;
		unsigned char screen_color_bg;
		unsigned char screen_color_bb;

		float ccolor[16][3]; // The curses-RGB mapping used for non-curses display modes
		uint8_t uccolor[16][3];

		palettest default_palette;

		int mouse_x, mouse_y;
		int precise_mouse_x, precise_mouse_y;
		int32_t screen_pixel_x,screen_pixel_y;
		int32_t tile_pixel_x,tile_pixel_y;

		unsigned char *screen;
			// Instead of doing costly bounds-checking calculations, we cache the end
			// of the arrays..
			unsigned char *screen_limit;
		long *screentexpos;
		long *screentexpos_lower;
		long *screentexpos_anchored;
		long *screentexpos_anchored_x,*screentexpos_anchored_y;
		uint32_t *screentexpos_flag;
		//we assume top is not in use unless a flag is set, and reprint the screen when it goes away, to avoid cell by cell checks
		bool top_in_use;
			unsigned char *screen_top;
				unsigned char *screen_top_limit;
			long *screentexpos_top_lower;
			long *screentexpos_top_anchored;
			long *screentexpos_top;
			long *screentexpos_top_anchored_x,*screentexpos_top_anchored_y;
			uint32_t *screentexpos_top_flag;
		bool display_title;
		int32_t display_background;
		int32_t last_display_background;

		//should only be changed by graphics thread after allocation
			//move entirely to renderer?
		int32_t *screentexpos_refresh_buffer;
		int32_t refresh_buffer_val;

		bool main_thread_requesting_reshape;//set to true by main thread, set to false by graphics thread
			bool main_thread_requesting_reshape_activate_map_port;//set to true by main thread, set to false by graphics thread

		long clipx[2],clipy[2];
		cached_texturest tex[TEXTURENUM];
		svector<texblitst> texblits;

		long rect_id;

		LARGE_INTEGER print_time[100];
		long print_index;
		int8_t display_frames;
		int32_t frame_display_sx,frame_display_dy;

		short force_full_display_count;
		bool do_clean_tile_cache;//true by main, false by graphics
		bool do_post_init_texture_clear;//true by main, false by graphics

		char original_rect;

		int dimx, dimy;

		long black_background_texpos[1];
		int32_t multilevel_depth_texpos[LOWER_VIEWPORT_MAX];
		int32_t multilevel_ramp_with_wall_nsew;
		int32_t multilevel_ramp_with_wall_nse;
		int32_t multilevel_ramp_with_wall_nsw;
		int32_t multilevel_ramp_with_wall_nwe;
		int32_t multilevel_ramp_with_wall_swe;
		int32_t multilevel_ramp_with_wall_n_s;
		int32_t multilevel_ramp_with_wall_n_w;
		int32_t multilevel_ramp_with_wall_n_e;
		int32_t multilevel_ramp_with_wall_s_w;
		int32_t multilevel_ramp_with_wall_s_e;
		int32_t multilevel_ramp_with_wall_w_e;
		int32_t multilevel_ramp_with_wall_n;
		int32_t multilevel_ramp_with_wall_s;
		int32_t multilevel_ramp_with_wall_w;
		int32_t multilevel_ramp_with_wall_e;
		int32_t multilevel_ramp_with_wall_nw;
		int32_t multilevel_ramp_with_wall_sw;
		int32_t multilevel_ramp_with_wall_se;
		int32_t multilevel_ramp_with_wall_ne;
		int32_t multilevel_ramp_with_wall_nw_ne;
		int32_t multilevel_ramp_with_wall_sw_se;
		int32_t multilevel_ramp_with_wall_nw_sw;
		int32_t multilevel_ramp_with_wall_ne_se;
		int32_t multilevel_ramp_other;
		int32_t multilevel_ramp_with_wall_s_ne;
		int32_t multilevel_ramp_with_wall_w_se;
		int32_t multilevel_ramp_with_wall_n_sw;
		int32_t multilevel_ramp_with_wall_e_nw;
		int32_t multilevel_ramp_with_wall_e_sw;
		int32_t multilevel_ramp_with_wall_s_nw;
		int32_t multilevel_ramp_with_wall_w_ne;
		int32_t multilevel_ramp_with_wall_n_se;
		int32_t multilevel_ramp_with_wall_s_e_nw;
		int32_t multilevel_ramp_with_wall_s_w_ne;
		int32_t multilevel_ramp_with_wall_n_w_se;
		int32_t multilevel_ramp_with_wall_n_e_sw;
		int32_t multilevel_ramp_with_wall_n_sw_se;
		int32_t multilevel_ramp_with_wall_e_nw_sw;
		int32_t multilevel_ramp_with_wall_s_nw_ne;
		int32_t multilevel_ramp_with_wall_w_ne_se;
		int32_t multilevel_ramp_with_wall_nw_se;
		int32_t multilevel_ramp_with_wall_ne_sw;
		int32_t multilevel_ramp_with_wall_nw_ne_sw_se;
		int32_t multilevel_ramp_with_wall_nw_ne_sw;
		int32_t multilevel_ramp_with_wall_nw_ne_se;
		int32_t multilevel_ramp_with_wall_nw_sw_se;
		int32_t multilevel_ramp_with_wall_ne_sw_se;
		int32_t grass_stair_updown_texpos;
		int32_t grass_stair_up_texpos;
		int32_t grass_stair_down_texpos;
		int32_t stone_stair_updown_texpos;
		int32_t stone_stair_up_texpos;
		int32_t stone_stair_down_texpos;
		int32_t dirt_stair_updown_texpos;
		int32_t dirt_stair_up_texpos;
		int32_t dirt_stair_down_texpos;
		int32_t sand_stair_updown_texpos;
		int32_t sand_stair_up_texpos;
		int32_t sand_stair_down_texpos;
		int32_t sand_y_stair_updown_texpos;
		int32_t sand_y_stair_up_texpos;
		int32_t sand_y_stair_down_texpos;
		int32_t sand_w_stair_updown_texpos;
		int32_t sand_w_stair_up_texpos;
		int32_t sand_w_stair_down_texpos;
		int32_t sand_r_stair_updown_texpos;
		int32_t sand_r_stair_up_texpos;
		int32_t sand_r_stair_down_texpos;
		int32_t sand_b_stair_updown_texpos;
		int32_t sand_b_stair_up_texpos;
		int32_t sand_b_stair_down_texpos;
		int32_t palette_stair_updown_texpos;
		int32_t palette_stair_up_texpos;
		int32_t palette_stair_down_texpos;
		int32_t smooth_floor_texpos;
		int32_t workshop_floor_texpos;

		int32_t texpos_scaffold_floor_wood[4];
		int32_t texpos_scaffold_stair_updown_wood;
		int32_t texpos_scaffold_stair_up_wood;
		int32_t texpos_scaffold_stair_down_wood;
		int32_t texpos_scaffold_underside_wood;
		int32_t texpos_scaffold_floor_stone[4];
		int32_t texpos_scaffold_stair_updown_stone;
		int32_t texpos_scaffold_stair_up_stone;
		int32_t texpos_scaffold_stair_down_stone;
		int32_t texpos_scaffold_underside_stone;

		int32_t texpos_fortification;
		int32_t texpos_fortification_open_nswe;
		int32_t texpos_fortification_open_nsw;
		int32_t texpos_fortification_open_nse;
		int32_t texpos_fortification_open_nwe;
		int32_t texpos_fortification_open_swe;
		int32_t texpos_fortification_open_ns;
		int32_t texpos_fortification_open_we;
		int32_t texpos_fortification_open_nw;
		int32_t texpos_fortification_open_ne;
		int32_t texpos_fortification_open_sw;
		int32_t texpos_fortification_open_se;

		int32_t texpos_fortification_ice;
		int32_t texpos_fortification_ice_open_nswe;
		int32_t texpos_fortification_ice_open_nsw;
		int32_t texpos_fortification_ice_open_nse;
		int32_t texpos_fortification_ice_open_nwe;
		int32_t texpos_fortification_ice_open_swe;
		int32_t texpos_fortification_ice_open_ns;
		int32_t texpos_fortification_ice_open_we;
		int32_t texpos_fortification_ice_open_nw;
		int32_t texpos_fortification_ice_open_ne;
		int32_t texpos_fortification_ice_open_sw;
		int32_t texpos_fortification_ice_open_se;

		int32_t texpos_fortification_wood;
		int32_t texpos_fortification_wood_open_nswe;
		int32_t texpos_fortification_wood_open_nsw;
		int32_t texpos_fortification_wood_open_nse;
		int32_t texpos_fortification_wood_open_nwe;
		int32_t texpos_fortification_wood_open_swe;
		int32_t texpos_fortification_wood_open_ns;
		int32_t texpos_fortification_wood_open_we;
		int32_t texpos_fortification_wood_open_nw;
		int32_t texpos_fortification_wood_open_ne;
		int32_t texpos_fortification_wood_open_sw;
		int32_t texpos_fortification_wood_open_se;

		svector<int32_t> texpos_custom_symbol;

		int32_t texpos_unit_selector_pasture;
		int32_t texpos_unit_selector_pit;
		int32_t texpos_unit_selector_pond;
		int32_t texpos_creature_is_traveling;
		int32_t texpos_creature_is_dead;

		int32_t texpos_building_icon_workshops;
		int32_t texpos_building_icon_furniture;
		int32_t texpos_building_icon_doors_hatches;
		int32_t texpos_building_icon_walls_floors;
		int32_t texpos_building_icon_machines_fluids;
		int32_t texpos_building_icon_cages_restraints;
		int32_t texpos_building_icon_traps;
		int32_t texpos_building_icon_military;
		int32_t texpos_building_icon_trade_depot;
		int32_t texpos_building_icon_workshop_carpenter;
		int32_t texpos_building_icon_workshop_mason;
		int32_t texpos_building_icon_workshop_metalsmith;
		int32_t texpos_building_icon_workshops_furnaces;
		int32_t texpos_building_icon_workshop_crafts;
		int32_t texpos_building_icon_workshop_jeweler;
		int32_t texpos_building_icon_workshops_clothing;
		int32_t texpos_building_icon_workshops_farming;
		int32_t texpos_building_icon_workshop_bowyer;
		int32_t texpos_building_icon_workshop_mechanic;
		int32_t texpos_building_icon_workshop_siege;
		int32_t texpos_building_icon_workshop_ashery;
		int32_t texpos_building_icon_furnace_wood;
		int32_t texpos_building_icon_furnace_smelter;
		int32_t texpos_building_icon_furnace_glass;
		int32_t texpos_building_icon_furnace_kiln;
		int32_t texpos_building_icon_workshop_leather;
		int32_t texpos_building_icon_workshop_loom;
		int32_t texpos_building_icon_workshop_clothes;
		int32_t texpos_building_icon_workshop_dyer;
		int32_t texpos_building_icon_farm_plot;
		int32_t texpos_building_icon_workshop_still;
		int32_t texpos_building_icon_workshop_butcher;
		int32_t texpos_building_icon_workshop_tanner;
		int32_t texpos_building_icon_workshop_fishery;
		int32_t texpos_building_icon_workshop_kitchen;
		int32_t texpos_building_icon_workshop_farmer;
		int32_t texpos_building_icon_workshop_quern;
		int32_t texpos_building_icon_workshop_kennel;
		int32_t texpos_building_icon_nest_box;
		int32_t texpos_building_icon_hive;
		int32_t texpos_building_icon_bed;
		int32_t texpos_building_icon_chair;
		int32_t texpos_building_icon_table;
		int32_t texpos_building_icon_box;
		int32_t texpos_building_icon_cabinet;
		int32_t texpos_building_icon_coffin;
		int32_t texpos_building_icon_slab;
		int32_t texpos_building_icon_statue;
		int32_t texpos_building_icon_traction_bench;
		int32_t texpos_building_icon_bookcase;
		int32_t texpos_building_icon_display_furniture;
		int32_t texpos_building_icon_offering_place;
		int32_t texpos_building_icon_instrument;
		int32_t texpos_building_icon_door;
		int32_t texpos_building_icon_hatch;
		int32_t texpos_building_icon_wall;
		int32_t texpos_building_icon_reinforced_wall;
		int32_t texpos_building_icon_floor;
		int32_t texpos_building_icon_ramp;
		int32_t texpos_building_icon_stairs;
		int32_t texpos_building_icon_bridge;
		int32_t texpos_building_icon_road_paved;
		int32_t texpos_building_icon_road_dirt;
		int32_t texpos_building_icon_fortification;
		int32_t texpos_building_icon_grate_wall;
		int32_t texpos_building_icon_grate_floor;
		int32_t texpos_building_icon_bars_vertical;
		int32_t texpos_building_icon_bars_floors;
		int32_t texpos_building_icon_window_glass;
		int32_t texpos_building_icon_window_gem;
		int32_t texpos_building_icon_support;
		int32_t texpos_building_icon_track;
		int32_t texpos_building_icon_track_stop;
		int32_t texpos_building_icon_lever;
		int32_t texpos_building_icon_well;
		int32_t texpos_building_icon_floodgate;
		int32_t texpos_building_icon_screw_pump;
		int32_t texpos_building_icon_water_wheel;
		int32_t texpos_building_icon_windmill;
		int32_t texpos_building_icon_gear_assembly;
		int32_t texpos_building_icon_axle_horizontal;
		int32_t texpos_building_icon_axle_vertical;
		int32_t texpos_building_icon_workshop_millstone;
		int32_t texpos_building_icon_rollers;
		int32_t texpos_building_icon_restraint;
		int32_t texpos_building_icon_cage;
		int32_t texpos_building_icon_animal_trap;
		int32_t texpos_building_icon_pressure_plate;
		int32_t texpos_building_icon_trap_stone;
		int32_t texpos_building_icon_trap_weapon;
		int32_t texpos_building_icon_trap_cage;
		int32_t texpos_building_icon_weapon;
		int32_t texpos_building_icon_archery_target;
		int32_t texpos_building_icon_weapon_rack;
		int32_t texpos_building_icon_armor_stand;
		int32_t texpos_building_icon_ballista;
		int32_t texpos_building_icon_catapult;
		int32_t texpos_building_icon_bolt_thrower;
		int32_t texpos_building_icon_wagon;

		int32_t texpos_planned_construction[38];//same as BUILDINGTYPE_CONSTRUCTIONNUM

		int32_t texpos_zone_inactive_n_s_w_e;
		int32_t texpos_zone_inactive_n_w;
		int32_t texpos_zone_inactive_n_e;
		int32_t texpos_zone_inactive_s_e;
		int32_t texpos_zone_inactive_s_w;
		int32_t texpos_zone_inactive_n;
		int32_t texpos_zone_inactive_e;
		int32_t texpos_zone_inactive_w;
		int32_t texpos_zone_inactive_s;
		int32_t texpos_zone_inactive_n_s;
		int32_t texpos_zone_inactive_w_e;
		int32_t texpos_zone_inactive_n_w_e;
		int32_t texpos_zone_inactive_s_w_e;
		int32_t texpos_zone_inactive_n_s_w;
		int32_t texpos_zone_inactive_n_s_e;
		int32_t texpos_zone_inactive;

		int32_t texpos_zone_inactive_selected_n_s_w_e;
		int32_t texpos_zone_inactive_selected_n_w;
		int32_t texpos_zone_inactive_selected_n_e;
		int32_t texpos_zone_inactive_selected_s_e;
		int32_t texpos_zone_inactive_selected_s_w;
		int32_t texpos_zone_inactive_selected_n;
		int32_t texpos_zone_inactive_selected_e;
		int32_t texpos_zone_inactive_selected_w;
		int32_t texpos_zone_inactive_selected_s;
		int32_t texpos_zone_inactive_selected_n_s;
		int32_t texpos_zone_inactive_selected_w_e;
		int32_t texpos_zone_inactive_selected_n_w_e;
		int32_t texpos_zone_inactive_selected_s_w_e;
		int32_t texpos_zone_inactive_selected_n_s_w;
		int32_t texpos_zone_inactive_selected_n_s_e;
		int32_t texpos_zone_inactive_selected;

		int32_t texpos_zone_active_n_s_w_e;
		int32_t texpos_zone_active_n_w;
		int32_t texpos_zone_active_n_e;
		int32_t texpos_zone_active_s_e;
		int32_t texpos_zone_active_s_w;
		int32_t texpos_zone_active_n;
		int32_t texpos_zone_active_e;
		int32_t texpos_zone_active_w;
		int32_t texpos_zone_active_s;
		int32_t texpos_zone_active_n_s;
		int32_t texpos_zone_active_w_e;
		int32_t texpos_zone_active_n_w_e;
		int32_t texpos_zone_active_s_w_e;
		int32_t texpos_zone_active_n_s_w;
		int32_t texpos_zone_active_n_s_e;
		int32_t texpos_zone_active;

		int32_t texpos_zone_selected_n_s_w_e;
		int32_t texpos_zone_selected_n_w;
		int32_t texpos_zone_selected_n_e;
		int32_t texpos_zone_selected_s_e;
		int32_t texpos_zone_selected_s_w;
		int32_t texpos_zone_selected_n;
		int32_t texpos_zone_selected_e;
		int32_t texpos_zone_selected_w;
		int32_t texpos_zone_selected_s;
		int32_t texpos_zone_selected_n_s;
		int32_t texpos_zone_selected_w_e;
		int32_t texpos_zone_selected_n_w_e;
		int32_t texpos_zone_selected_s_w_e;
		int32_t texpos_zone_selected_n_s_w;
		int32_t texpos_zone_selected_n_s_e;
		int32_t texpos_zone_selected;

		int32_t texpos_zone_general_n_s_w_e;
		int32_t texpos_zone_general_n_w;
		int32_t texpos_zone_general_n_e;
		int32_t texpos_zone_general_s_e;
		int32_t texpos_zone_general_s_w;
		int32_t texpos_zone_general_n;
		int32_t texpos_zone_general_e;
		int32_t texpos_zone_general_w;
		int32_t texpos_zone_general_s;
		int32_t texpos_zone_general_n_s;
		int32_t texpos_zone_general_w_e;
		int32_t texpos_zone_general_n_w_e;
		int32_t texpos_zone_general_s_w_e;
		int32_t texpos_zone_general_n_s_w;
		int32_t texpos_zone_general_n_s_e;
		int32_t texpos_zone_general;

		int32_t texpos_zone_bedroom;
		int32_t texpos_zone_dining_hall;
		int32_t texpos_zone_office;
		int32_t texpos_zone_archery_range;
		int32_t texpos_zone_barracks;
		int32_t texpos_zone_dormitory;
		int32_t texpos_zone_dungeon;
		int32_t texpos_zone_tomb;
		int32_t texpos_zone_water_source;
		int32_t texpos_zone_fishing;
		int32_t texpos_zone_gather;
		int32_t texpos_zone_dump;
		int32_t texpos_zone_pen;
		int32_t texpos_zone_pit;
		int32_t texpos_zone_sand;
		int32_t texpos_zone_clay;
		int32_t texpos_zone_meeting;
		int32_t texpos_zone_hospital;
		int32_t texpos_zone_animal_training;
		int32_t texpos_zone_multi;
		int32_t texpos_zone_tavern;
		int32_t texpos_zone_library;
		int32_t texpos_zone_guildhall;
		int32_t texpos_zone_grand_guildhall;
		int32_t texpos_zone_shrine;
		int32_t texpos_zone_temple;
		int32_t texpos_zone_temple_complex;

		int32_t stockpile_floor_texpos;
		int32_t stockpile_n_up_texpos;
		int32_t stockpile_n_texpos;
		int32_t stockpile_s_texpos;
		int32_t stockpile_w_up_texpos;
		int32_t stockpile_w_texpos;
		int32_t stockpile_e_up_texpos;
		int32_t stockpile_e_texpos;
		int32_t stockpile_nw_up_texpos;
		int32_t stockpile_nw_texpos;
		int32_t stockpile_ne_up_texpos;
		int32_t stockpile_ne_texpos;
		int32_t stockpile_sw_texpos;
		int32_t stockpile_se_texpos;
		int32_t stockpile_ns_up_texpos;
		int32_t stockpile_ns_texpos;
		int32_t stockpile_we_texpos;
		int32_t stockpile_nsw_up_texpos;
		int32_t stockpile_nsw_texpos;
		int32_t stockpile_nse_up_texpos;
		int32_t stockpile_nse_texpos;
		int32_t stockpile_nwe_up_texpos;
		int32_t stockpile_nwe_texpos;
		int32_t stockpile_swe_texpos;
		int32_t stockpile_nswe_up_texpos;
		int32_t stockpile_nswe_texpos;

		int32_t stockpile_blank_texpos;
		int32_t stockpile_ammo_texpos;
		int32_t stockpile_animals_texpos;
		int32_t stockpile_armor_texpos;
		int32_t stockpile_bars_texpos;
		int32_t stockpile_cloth_texpos;
		int32_t stockpile_coins_texpos;
		int32_t stockpile_corpses_texpos;
		int32_t stockpile_finished_goods_texpos;
		int32_t stockpile_food_texpos;
		int32_t stockpile_furniture_texpos;
		int32_t stockpile_gems_texpos;
		int32_t stockpile_leather_texpos;
		int32_t stockpile_refuse_texpos;
		int32_t stockpile_sheets_texpos;
		int32_t stockpile_stone_texpos;
		int32_t stockpile_weapons_texpos;
		int32_t stockpile_wood_texpos;
		int32_t stockpile_custom_texpos;

		int32_t stockpile_icon_blank_texpos;
		int32_t stockpile_icon_ammo_texpos;
		int32_t stockpile_icon_animals_texpos;
		int32_t stockpile_icon_armor_texpos;
		int32_t stockpile_icon_bars_texpos;
		int32_t stockpile_icon_cloth_texpos;
		int32_t stockpile_icon_coins_texpos;
		int32_t stockpile_icon_corpses_texpos;
		int32_t stockpile_icon_finished_goods_texpos;
		int32_t stockpile_icon_food_texpos;
		int32_t stockpile_icon_furniture_texpos;
		int32_t stockpile_icon_gems_texpos;
		int32_t stockpile_icon_leather_texpos;
		int32_t stockpile_icon_refuse_texpos;
		int32_t stockpile_icon_sheets_texpos;
		int32_t stockpile_icon_stone_texpos;
		int32_t stockpile_icon_weapons_texpos;
		int32_t stockpile_icon_wood_texpos;
		int32_t stockpile_icon_custom_texpos;
		int32_t stockpile_icon_all_texpos;
		int32_t stockpile_icon_signless_blank_texpos;
		int32_t stockpile_icon_signless_ammo_texpos;
		int32_t stockpile_icon_signless_animals_texpos;
		int32_t stockpile_icon_signless_armor_texpos;
		int32_t stockpile_icon_signless_bars_texpos;
		int32_t stockpile_icon_signless_cloth_texpos;
		int32_t stockpile_icon_signless_coins_texpos;
		int32_t stockpile_icon_signless_corpses_texpos;
		int32_t stockpile_icon_signless_finished_goods_texpos;
		int32_t stockpile_icon_signless_food_texpos;
		int32_t stockpile_icon_signless_furniture_texpos;
		int32_t stockpile_icon_signless_gems_texpos;
		int32_t stockpile_icon_signless_leather_texpos;
		int32_t stockpile_icon_signless_refuse_texpos;
		int32_t stockpile_icon_signless_sheets_texpos;
		int32_t stockpile_icon_signless_stone_texpos;
		int32_t stockpile_icon_signless_weapons_texpos;
		int32_t stockpile_icon_signless_wood_texpos;
		int32_t stockpile_icon_signless_custom_texpos;
		int32_t stockpile_icon_signless_all_texpos;

		int32_t texpos_wagon_bld[3][4];
		int32_t texpos_wagon_n[3][4];
		int32_t texpos_wagon_s[3][4];
		int32_t texpos_wagon_w[4][3];
		int32_t texpos_wagon_e[4][3];
		int32_t texpos_wagon_goods_bld[3][4][4];
		int32_t texpos_wagon_goods_n[3][4][4];
		int32_t texpos_wagon_goods_s[3][4][4];
		int32_t texpos_wagon_goods_w[4][3][4];
		int32_t texpos_wagon_goods_e[4][3][4];

		int32_t texpos_ram_wood[4][3];
		int32_t texpos_ram_banded[4][3];
		int32_t texpos_ram_bands[4][3];
		int32_t texpos_ram_head[RAM_HEADNUM][4];

		int32_t texpos_calendar_month[12][3];
		int32_t texpos_calendar_day_past[3];
		int32_t texpos_calendar_day_current[3];
		int32_t texpos_calendar_day_future[3];

		int32_t texpos_border_top_left[4][3];
		int32_t texpos_border_top_right[4][3];
		int32_t texpos_border_bottom_left[4][3];
		int32_t texpos_border_bottom_right[4][3];
		int32_t texpos_border_top_intersection[4][2];
		int32_t texpos_border_bottom_intersection[4][2];
		int32_t texpos_border_middle_intersection[4];
		int32_t texpos_border_left_intersection[3][3];
		int32_t texpos_border_right_intersection[3][3];
		int32_t texpos_border_left[4];
		int32_t texpos_border_right[4];
		int32_t texpos_border_top[3];
		int32_t texpos_border_bottom[3];
		int32_t texpos_hover_rectangle[3][3];
		int32_t texpos_hover_rectangle_join_w_sw;
		int32_t texpos_hover_rectangle_join_w_s;
		int32_t texpos_hover_rectangle_join_e_s;
		int32_t texpos_hover_rectangle_join_e_se;
		int32_t texpos_hover_close[3][2];
		int32_t texpos_hover_tab[3][3];
		int32_t texpos_hover_tab_inactive[3];
		int32_t texpos_hover_tab_inside_corner_top;
		int32_t texpos_hover_tab_inside_corner_bottom;
		int32_t texpos_button_rectangle[3][3];
		int32_t texpos_button_rectangle_selected[3][3];
		int32_t texpos_button_rectangle_light[3][3];
		int32_t texpos_button_rectangle_dark[3][3];
		int32_t texpos_button_rectangle_divider[3];
		int32_t texpos_button_category_rectangle[3][3];
		int32_t texpos_button_category_rectangle_selected[3][3];
		int32_t texpos_button_category_rectangle_on[3][3];
		int32_t texpos_button_category_rectangle_on_selected[3][3];
		int32_t texpos_button_category_rectangle_off[3][3];
		int32_t texpos_button_category_rectangle_off_selected[3][3];
		int32_t texpos_button_filter[6][3];
		int32_t texpos_button_filter_no_mag_right[3];
		int32_t texpos_button_filter_name[4][3];
		int32_t texpos_button_picture_box[3][3];
		int32_t texpos_button_picture_box_selected[3][3];
		int32_t texpos_button_picture_box_highlighted[3][3];
		int32_t texpos_button_picture_box_sel_highlighted[3][3];
		int32_t texpos_button_picture_box_light[3][3];
		int32_t texpos_button_picture_box_dark[3][3];
		int32_t texpos_button_add[3][3];
		int32_t texpos_button_add_hover[3][3];
		int32_t texpos_button_add_pressed[3][3];
		int32_t texpos_button_add_invalid[3][3];
		int32_t texpos_button_subtract[3][3];
		int32_t texpos_button_subtract_hover[3][3];
		int32_t texpos_button_subtract_pressed[3][3];
		int32_t texpos_button_subtract_invalid[3][3];
		int32_t texpos_button_expander_closed[2][3];
		int32_t texpos_button_expander_open[2][3];
		int32_t texpos_scrollbar[2][3];
		int32_t texpos_scrollbar_up_hover[2];
		int32_t texpos_scrollbar_up_pressed[2];
		int32_t texpos_scrollbar_down_hover[2];
		int32_t texpos_scrollbar_down_pressed[2];
		int32_t texpos_scrollbar_small_scroller[2][2];
		int32_t texpos_scrollbar_small_scroller_hover[2][2];
		int32_t texpos_scrollbar_top_scroller[2];
		int32_t texpos_scrollbar_top_scroller_hover[2];
		int32_t texpos_scrollbar_bottom_scroller[2];
		int32_t texpos_scrollbar_bottom_scroller_hover[2];
		int32_t texpos_scrollbar_blank_scroller[2];
		int32_t texpos_scrollbar_blank_scroller_hover[2];
		int32_t texpos_scrollbar_center_scroller[2];
		int32_t texpos_scrollbar_center_scroller_hover[2];
		int32_t texpos_scrollbar_offcenter_scroller[2][2];
		int32_t texpos_scrollbar_offcenter_scroller_hover[2][2];
		int32_t texpos_scrollbar_sky[2];
		int32_t texpos_scrollbar_ground[2];
		int32_t texpos_scrollbar_underground[2];
		int32_t texpos_slider_background[3][3];
		int32_t texpos_slider[2][3];
		int32_t texpos_slider_hover[2][3];
		int32_t texpos_tab[5][3];
		int32_t texpos_tab_selected[5][3];
		array_2d<int32_t,5,2> texpos_short_tab;
		array_2d<int32_t,5,2> texpos_short_tab_selected;
		array_2d<int32_t,5,2> texpos_short_subtab;
		array_2d<int32_t,5,2> texpos_short_subtab_selected;
		array_2d<int32_t,5,2> texpos_short_subsubtab;
		array_2d<int32_t,5,2> texpos_short_subsubtab_selected;
		int32_t texpos_interface_background;
		int32_t texpos_button_main[INTERFACE_BUTTON_MAINNUM][4][3];
		int32_t texpos_button_small[INTERFACE_BUTTON_SMALLNUM][2][2];
		int32_t texpos_button_horizontal_option_left_ornament[4][3];
		int32_t texpos_button_horizontal_option_active[3][3];
		int32_t texpos_button_horizontal_option_inactive[3][3];
		int32_t texpos_button_horizontal_option_right_ornament[4][3];
		int32_t texpos_button_horizontal_option_remove[3][3];
		int32_t texpos_button_horizontal_option_confirm[3][3];
		int32_t texpos_interior_border_n_s_w_e;
		int32_t texpos_interior_border_n_w_e;
		int32_t texpos_interior_border_s_w_e;
		int32_t texpos_interior_border_w_e;
		int32_t texpos_interior_border_n_s;
		int32_t texpos_sort_ascending_active[4];
		int32_t texpos_sort_ascending_inactive[4];
		int32_t texpos_sort_descending_active[4];
		int32_t texpos_sort_descending_inactive[4];
		int32_t texpos_sort_text_active[3];
		int32_t texpos_sort_text_inactive[3];
		int32_t texpos_siege_light[3][3];
		int32_t texpos_diplomacy_light[3][3];
		int32_t texpos_petitions_light[3][3];
		int32_t texpos_grid_cell_inactive[3][3];
		int32_t texpos_grid_cell_active[3][3];
		int32_t texpos_grid_cell_button[3][3];
		int32_t texpos_type_filter_left[3];
		int32_t texpos_type_filter_right[3];
		int32_t texpos_type_filter_text[3];
		int32_t texpos_pinned[2];
		int32_t texpos_not_pinned[2];
		int32_t texpos_button_wrestle_right[3];
		int32_t texpos_button_wrestle_equal[3];
		int32_t texpos_button_wrestle_left[3];
		int32_t texpos_button_adventure_tactical_mode_on[4][2];
		int32_t texpos_button_adventure_tactical_mode_off[4][2];

		int32_t texpos_adventure_log_pinned_active[3][3];
		int32_t texpos_adventure_log_pinned_inactive[3][3];
		int32_t texpos_adventure_log_item_active[3][3];
		int32_t texpos_adventure_log_item_inactive[3][3];

		int32_t texpos_button_announcement_open_all_announcements[3][3];
		int32_t texpos_button_announcement_not_pausing_on_new_report[3*3];
		int32_t texpos_button_announcement_pausing_on_new_report[3*3];
		int32_t texpos_button_announcement_open_from_main[3][3];

		int32_t texpos_button_quality_up[3][3];
		int32_t texpos_button_quality_down[3][3];
		int32_t texpos_button_quality_up_inactive[3][3];
		int32_t texpos_button_quality_down_inactive[3][3];

		int32_t texpos_button_stocks_recenter[3][3];
		int32_t texpos_button_stocks_view_item[3][3];
		int32_t texpos_button_stocks_forbid[3][3];
		int32_t texpos_button_stocks_forbid_active[3][3];
		int32_t texpos_button_stocks_dump[3][3];
		int32_t texpos_button_stocks_dump_active[3][3];
		int32_t texpos_button_stocks_melt[3][3];
		int32_t texpos_button_stocks_melt_active[3][3];
		int32_t texpos_button_stocks_hide[3][3];
		int32_t texpos_button_stocks_hide_active[3][3];

		int32_t texpos_button_short_forbid[3][2];
		int32_t texpos_button_short_forbid_active[3][2];
		int32_t texpos_button_short_dump[3][2];
		int32_t texpos_button_short_dump_active[3][2];
		int32_t texpos_button_short_melt[3][2];
		int32_t texpos_button_short_melt_active[3][2];
		int32_t texpos_button_short_hide[3][2];
		int32_t texpos_button_short_hide_active[3][2];

		int32_t texpos_building_short_item_task[3][2];
		int32_t texpos_building_item_task[3][3];
		int32_t texpos_building_item_incorporated[3][3];
		int32_t texpos_building_item_trade[3][3];
		int32_t texpos_building_item_animal[3][3];
		int32_t texpos_building_item_bait[3][3];
		int32_t texpos_building_item_loaded[3][3];
		int32_t texpos_building_item_dead[3][3];
		int32_t texpos_building_item_other[3][3];

		int32_t texpos_building_jobs_repeat[3][3];
		int32_t texpos_building_jobs_repeat_active[3][3];
		int32_t texpos_building_jobs_do_now[3][3];
		int32_t texpos_building_jobs_do_now_active[3][3];
		int32_t texpos_building_jobs_suspended[3][3];
		int32_t texpos_building_jobs_suspended_active[3][3];
		int32_t texpos_building_jobs_priority_up[3][3];
		int32_t texpos_building_jobs_remove[3][3];
		int32_t texpos_building_jobs_active[3][3];
		int32_t texpos_building_jobs_quota[3][3];
		int32_t texpos_building_jobs_remove_worker[3][3];

		int32_t texpos_button_assign_trade[INTERFACE_BUTTON_ASSIGN_TRADENUM][3][3];
		int32_t texpos_button_building_info[INTERFACE_BUTTON_BUILDING_INFONUM][3][3];
		int32_t texpos_button_building_sheet[INTERFACE_BUTTON_BUILDING_SHEETNUM][4][3];
		int32_t texpos_button_unit_sheet[INTERFACE_BUTTON_UNIT_SHEETNUM][3][3];
		int32_t texpos_button_large_unit_sheet[INTERFACE_BUTTON_LARGE_UNIT_SHEETNUM][4][3];
		int32_t texpos_button_pets_livestock[INTERFACE_BUTTON_PETS_LIVESTOCKNUM][3][3];
		int32_t texpos_button_inventory_item[INTERFACE_BUTTON_INVENTORY_ITEMNUM][3][3];

		int32_t texpos_adventure_travel_dir[INTERFACE_ADVENTURE_TRAVEL_DIRNUM];

		int32_t texpos_skill_progress_bar_left_full;
		int32_t texpos_skill_progress_bar_mid_full;
		int32_t texpos_skill_progress_bar_right_full;
		int32_t texpos_skill_progress_bar_left_half;
		int32_t texpos_skill_progress_bar_mid_half;
		int32_t texpos_skill_progress_bar_right_half;
		int32_t texpos_skill_progress_bar_left_empty;
		int32_t texpos_skill_progress_bar_mid_empty;
		int32_t texpos_skill_progress_bar_right_empty;

		int32_t texpos_vision_shadow_n;
		int32_t texpos_vision_shadow_s;
		int32_t texpos_vision_shadow_w;
		int32_t texpos_vision_shadow_e;
		int32_t texpos_vision_shadow_n_w;
		int32_t texpos_vision_shadow_n_e;
		int32_t texpos_vision_shadow_s_w;
		int32_t texpos_vision_shadow_s_e;
		int32_t texpos_vision_shadow_n_s_w;
		int32_t texpos_vision_shadow_n_s_e;
		int32_t texpos_vision_shadow_n_w_e;
		int32_t texpos_vision_shadow_s_w_e;
		int32_t texpos_vision_shadow_n_s_w_e;
		int32_t texpos_vision_shadow_nw;
		int32_t texpos_vision_shadow_ne;
		int32_t texpos_vision_shadow_sw;
		int32_t texpos_vision_shadow_se;
			//derived
		int32_t texpos_vision_shadow_n_s;
		int32_t texpos_vision_shadow_w_e;
		int32_t texpos_vision_shadow_n_sw_se;
		int32_t texpos_vision_shadow_n_sw;
		int32_t texpos_vision_shadow_n_se;
		int32_t texpos_vision_shadow_s_nw_ne;
		int32_t texpos_vision_shadow_s_nw;
		int32_t texpos_vision_shadow_s_ne;
		int32_t texpos_vision_shadow_w_ne_se;
		int32_t texpos_vision_shadow_w_ne;
		int32_t texpos_vision_shadow_w_se;
		int32_t texpos_vision_shadow_e_nw_sw;
		int32_t texpos_vision_shadow_e_nw;
		int32_t texpos_vision_shadow_e_sw;
		int32_t texpos_vision_shadow_n_w_se;
		int32_t texpos_vision_shadow_n_e_sw;
		int32_t texpos_vision_shadow_s_w_ne;
		int32_t texpos_vision_shadow_s_e_nw;
		int32_t texpos_vision_shadow_nw_ne;
		int32_t texpos_vision_shadow_nw_sw;
		int32_t texpos_vision_shadow_nw_se;
		int32_t texpos_vision_shadow_ne_sw;
		int32_t texpos_vision_shadow_ne_se;
		int32_t texpos_vision_shadow_sw_se;
		int32_t texpos_vision_shadow_nw_ne_sw;
		int32_t texpos_vision_shadow_nw_ne_se;
		int32_t texpos_vision_shadow_nw_sw_se;
		int32_t texpos_vision_shadow_ne_sw_se;
		int32_t texpos_vision_shadow_nw_ne_sw_se;

		interface_setst graphical_interface;
		interface_setst classic_interface;
			int32_t texpos_classic_moon_weather[INTERFACE_MOON_WEATHERNUM][4][3];
			int32_t texpos_classic_announcement_alert[ANNOUNCEMENT_ALERTNUM][4][3];

		int32_t texpos_moon_weather[INTERFACE_MOON_WEATHERNUM];

		int32_t texpos_announcement_alert[ANNOUNCEMENT_ALERTNUM];

		int32_t texpos_unit_status[UNIT_STATUSNUM];

		int32_t texpos_side_indicator[SIDE_INDICATORNUM];

		int32_t texpos_default_portrait_background;
		int32_t texpos_chosen_portrait_frame;
		int32_t texpos_hero_portrait_frame;
		int32_t texpos_default_portrait_frame;
		int32_t texpos_portrait_chosen;
		int32_t texpos_portrait_hero;
		int32_t texpos_portrait_ordinary;
		int32_t texpos_portrait_chosen_selected;
		int32_t texpos_portrait_hero_selected;
		int32_t texpos_portrait_ordinary_selected;
		int32_t texpos_default_portrait_background_selected;
		int32_t texpos_portrait_left;
		int32_t texpos_portrait_right;
		int32_t texpos_portrait_add_active;
		int32_t texpos_portrait_add_inactive;
		int32_t texpos_portrait_frame_deity_bad;
		int32_t texpos_portrait_frame_deity_normal;
		int32_t texpos_portrait_frame_deity_good;

		int32_t workshop_carpenter_texpos[4][3][4];//many of these use upper row for stuff that sticks up
		int32_t workshop_farmer_texpos[4][3][4];
		int32_t workshop_mason_texpos[4][3][4];
		int32_t workshop_craftsman_texpos[4][3][4];
		int32_t workshop_jeweler_texpos[4][3][4];
		int32_t workshop_metalsmith_texpos[4][3][4];
		int32_t workshop_lavamill_texpos[4][3][4];
		int32_t workshop_bowyer_texpos[4][3][4];
		int32_t workshop_mechanic_texpos[4][3][4];
		int32_t workshop_siege_texpos[4][5][6];
		int32_t workshop_butcher_texpos[4][3][4];
		int32_t workshop_leather_texpos[4][3][4];
		int32_t workshop_tanner_texpos[4][3][4];
		int32_t workshop_clothes_texpos[4][3][4];
		int32_t workshop_fishery_texpos[4][3][4];
		int32_t workshop_still_texpos[4][3][4];
		int32_t workshop_loom_texpos[4][3][4];
		int32_t workshop_kennel_texpos[4][5][6];
		int32_t workshop_kitchen_texpos[4][3][4];
		int32_t workshop_ashery_texpos[4][3][4];
		int32_t workshop_dyer_texpos[4][3][4];
		int32_t workshop_carpenter_texpos_overlay[4][3][4];
		int32_t workshop_farmer_texpos_overlay[4][3][4];
		int32_t workshop_mason_texpos_overlay[4][3][4];
		int32_t workshop_craftsman_texpos_overlay[4][3][4];
		int32_t workshop_jeweler_texpos_overlay[4][3][4];
		int32_t workshop_metalsmith_texpos_overlay[4][3][4];
		int32_t workshop_lavamill_texpos_overlay[4][3][4];
		int32_t workshop_bowyer_texpos_overlay[4][3][4];
		int32_t workshop_mechanic_texpos_overlay[4][3][4];
		int32_t workshop_butcher_texpos_overlay[4][3][4];
		int32_t workshop_leather_texpos_overlay[4][3][4];
		int32_t workshop_tanner_texpos_overlay[4][3][4];
		int32_t workshop_clothes_texpos_overlay[4][3][4];
		int32_t workshop_fishery_texpos_overlay[4][3][4];
		int32_t workshop_still_texpos_overlay[4][3][4];
		int32_t workshop_loom_texpos_overlay[4][3][4];
		int32_t workshop_kitchen_texpos_overlay[4][3][4];
		int32_t workshop_ashery_texpos_overlay[4][3][4];
		int32_t workshop_dyer_texpos_overlay[4][3][4];
		int32_t workshop_siege_texpos_overlay[4][5][6];
		int32_t workshop_kennel_texpos_overlay[4][5][6];
		int32_t trade_depot_texpos[4][5][6];
		int32_t trade_depot_texpos_overlay[4][5][6];
		int32_t furnace_texpos[7][4][3][4];
		int32_t furnace_texpos_overlay[7][4][3][4];
		int32_t workshop_quern_texpos[2][2];
		int32_t workshop_millstone_texpos[2][2];
		int32_t workshop_millstone_turning_texpos[2];

		int32_t texpos_brook_to_nw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_ne[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_sw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_n[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_s[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_w[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_to_e[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_n[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_s[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_w[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_e[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_n_w[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_n_e[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_s_w[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_s_e[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_source[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_ne[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_sw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_se[4][BROOK_FLOW_ANIMATION_NUM];
		//derived
		int32_t texpos_brook_bed_nw_ne[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw_sw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_ne_sw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_ne_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_sw_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw_ne_sw[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw_ne_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw_sw_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_ne_sw_se[4][BROOK_FLOW_ANIMATION_NUM];
		int32_t texpos_brook_bed_nw_ne_sw_se[4][BROOK_FLOW_ANIMATION_NUM];

		int32_t texpos_river_to_nw[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_ne[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_sw[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_n[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_s[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_w[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_to_e[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_n[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_s[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_w[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_e[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_n_w[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_n_e[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_s_w[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_s_e[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_source[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_ne[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_sw[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_ne_sw[4][RIVER_FLOW_ANIMATION_NUM];
		//derived
		/*
		int32_t texpos_river_bed_nw_ne[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw_sw[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_ne_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_sw_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw_ne_sw[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw_ne_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw_sw_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_ne_sw_se[4][RIVER_FLOW_ANIMATION_NUM];
		int32_t texpos_river_bed_nw_ne_sw_se[4][RIVER_FLOW_ANIMATION_NUM];
		*/

		int32_t texpos_partial_spatter[SPATTER_MATERIALNUM][4][4];
		int32_t texpos_full_nswe_a_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nswe_b_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nswe_c_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nswe_d_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nswe_e_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nsw_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nse_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nwe_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_swe_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_ns_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_we_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_nw_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_ne_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_sw_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_se_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_n_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_s_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_w_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_e_spatter[SPATTER_MATERIALNUM];
		int32_t texpos_full_isolated_spatter[SPATTER_MATERIALNUM];
			//derived spatter ramps
		/*
		int32_t texpos_spatter_ramp_with_wall_nsew[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nse[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nsw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nwe[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_swe[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_s[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_w[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_e[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_w[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_e[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_w_e[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_w[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_e[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_ne[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_ne[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_sw_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_ne_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_other[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_ne[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_w_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_e_nw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_e_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_nw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_w_ne[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_e_nw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_w_ne[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_w_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_e_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_n_sw_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_e_nw_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_s_nw_ne[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_w_ne_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_ne_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_ne_sw_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_ne_sw[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_ne_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_nw_sw_se[SPATTER_MATERIALNUM];
		int32_t texpos_spatter_ramp_with_wall_ne_sw_se[SPATTER_MATERIALNUM];
		*/

		int32_t texpos_combat_animation_swish[COMBAT_ANIMATION_SWISHNUM][COMBAT_ANIMATION_SWISH_DIRECTIONNUM][COMBAT_ANIMATION_SWISH_FRAME_COUNT];
		int32_t texpos_combat_animation_sparks[COMBAT_ANIMATION_SWISHNUM][COMBAT_ANIMATION_SWISH_DIRECTIONNUM][COMBAT_ANIMATION_SWISH_FRAME_COUNT];
		int32_t texpos_combat_animation_ram[COMBAT_ANIMATION_RAM_DIRECTIONNUM][COMBAT_ANIMATION_RAM_FRAME_COUNT];

		int32_t texpos_move_indicator[MOVE_INDICATORNUM][MOVE_INDICATOR_DIRECTIONNUM][MOVE_INDICATOR_FRAME_COUNT];

		int32_t texpos_sound_indicator[GRAPHICS_SOUND_INDICATORNUM];
		int32_t texpos_adv_speed_box[3][2];
		int32_t texpos_vampire_sense_marker;
		int32_t texpos_stealth_vision_direct;
		int32_t texpos_stealth_vision_direct_down;
		int32_t texpos_stealth_vision_direct_up;
		int32_t texpos_stealth_vision_peripheral;
		int32_t texpos_stealth_vision_peripheral_down;
		int32_t texpos_stealth_vision_peripheral_up;
		int32_t texpos_memory_map_monster;
		int32_t texpos_memory_map_item;
		int32_t texpos_memory_map_building;
		int32_t texpos_memory_map_wall;
		int32_t texpos_memory_map_stair_up;
		int32_t texpos_memory_map_stair_down;
		int32_t texpos_memory_map_stair_updown;
		int32_t texpos_memory_map_ramp_up;
		int32_t texpos_memory_map_ramp_down;
		int32_t texpos_memory_map_floor;
		int32_t texpos_memory_map_air;

		int32_t texpos_tracking_symbol_broken_vegetation[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_humanoid_liquid_print[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_beast_liquid_print[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_footwear_liquid_print[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_humanoid_imprint[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_beast_imprint[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_footwear_imprint[GRAPHICS_TRACKING_SYMBOL_WEIGHTNUM][GRAPHICS_TRACKING_SYMBOL_DIRNUM][2];
		int32_t texpos_tracking_symbol_unintelligible_mess[2];

		int32_t texpos_guts_n[2];
		int32_t texpos_guts_s[2];
		int32_t texpos_guts_w[2];
		int32_t texpos_guts_e[2];
		int32_t texpos_guts_nw[2];
		int32_t texpos_guts_sw[2];
		int32_t texpos_guts_ne[2];
		int32_t texpos_guts_se[2];
		
		int32_t texpos_pcg[PCG_LAYERINGNUM][3][2];

		int32_t soil_wall_nswe_texpos[4];
		int32_t soil_wall_swe_texpos;
		int32_t soil_wall_nwe_texpos;
		int32_t soil_wall_nse_texpos;
		int32_t soil_wall_nsw_texpos;
		int32_t soil_wall_n_w_texpos;
		int32_t soil_wall_n_e_texpos;
		int32_t soil_wall_s_w_texpos;
		int32_t soil_wall_s_e_texpos;
		int32_t soil_wall_n_s_texpos[4];
		int32_t soil_wall_w_e_texpos[4];
		int32_t soil_wall_n_texpos[4];
		int32_t soil_wall_s_texpos[4];
		int32_t soil_wall_w_texpos[4];
		int32_t soil_wall_e_texpos[4];
		int32_t soil_wall_nw_texpos;
		int32_t soil_wall_ne_texpos;
		int32_t soil_wall_sw_texpos;
		int32_t soil_wall_se_texpos;

		int32_t worn1_stone_wall_nswe_texpos[4];
		int32_t worn1_stone_wall_swe_texpos;
		int32_t worn1_stone_wall_nwe_texpos;
		int32_t worn1_stone_wall_nse_texpos;
		int32_t worn1_stone_wall_nsw_texpos;
		int32_t worn1_stone_wall_n_w_texpos;
		int32_t worn1_stone_wall_n_e_texpos;
		int32_t worn1_stone_wall_s_w_texpos;
		int32_t worn1_stone_wall_s_e_texpos;
		int32_t worn1_stone_wall_n_s_texpos[4];
		int32_t worn1_stone_wall_w_e_texpos[4];
		int32_t worn1_stone_wall_n_texpos[4];
		int32_t worn1_stone_wall_s_texpos[4];
		int32_t worn1_stone_wall_w_texpos[4];
		int32_t worn1_stone_wall_e_texpos[4];
		int32_t worn1_stone_wall_nw_texpos;
		int32_t worn1_stone_wall_ne_texpos;
		int32_t worn1_stone_wall_sw_texpos;
		int32_t worn1_stone_wall_se_texpos;

		int32_t worn2_stone_wall_nswe_texpos[4];
		int32_t worn2_stone_wall_swe_texpos;
		int32_t worn2_stone_wall_nwe_texpos;
		int32_t worn2_stone_wall_nse_texpos;
		int32_t worn2_stone_wall_nsw_texpos;
		int32_t worn2_stone_wall_n_w_texpos;
		int32_t worn2_stone_wall_n_e_texpos;
		int32_t worn2_stone_wall_s_w_texpos;
		int32_t worn2_stone_wall_s_e_texpos;
		int32_t worn2_stone_wall_n_s_texpos[4];
		int32_t worn2_stone_wall_w_e_texpos[4];
		int32_t worn2_stone_wall_n_texpos[4];
		int32_t worn2_stone_wall_s_texpos[4];
		int32_t worn2_stone_wall_w_texpos[4];
		int32_t worn2_stone_wall_e_texpos[4];
		int32_t worn2_stone_wall_nw_texpos;
		int32_t worn2_stone_wall_ne_texpos;
		int32_t worn2_stone_wall_sw_texpos;
		int32_t worn2_stone_wall_se_texpos;

		int32_t worn3_stone_wall_nswe_texpos[4];
		int32_t worn3_stone_wall_swe_texpos;
		int32_t worn3_stone_wall_nwe_texpos;
		int32_t worn3_stone_wall_nse_texpos;
		int32_t worn3_stone_wall_nsw_texpos;
		int32_t worn3_stone_wall_n_w_texpos;
		int32_t worn3_stone_wall_n_e_texpos;
		int32_t worn3_stone_wall_s_w_texpos;
		int32_t worn3_stone_wall_s_e_texpos;
		int32_t worn3_stone_wall_n_s_texpos[4];
		int32_t worn3_stone_wall_w_e_texpos[4];
		int32_t worn3_stone_wall_n_texpos[4];
		int32_t worn3_stone_wall_s_texpos[4];
		int32_t worn3_stone_wall_w_texpos[4];
		int32_t worn3_stone_wall_e_texpos[4];
		int32_t worn3_stone_wall_nw_texpos;
		int32_t worn3_stone_wall_ne_texpos;
		int32_t worn3_stone_wall_sw_texpos;
		int32_t worn3_stone_wall_se_texpos;

		int32_t smoothed_stone_wall_nswe_texpos;
		int32_t smoothed_stone_wall_swe_texpos;
		int32_t smoothed_stone_wall_nwe_texpos;
		int32_t smoothed_stone_wall_nse_texpos;
		int32_t smoothed_stone_wall_nsw_texpos;
		int32_t smoothed_stone_wall_n_w_texpos;
		int32_t smoothed_stone_wall_n_e_texpos;
		int32_t smoothed_stone_wall_s_w_texpos;
		int32_t smoothed_stone_wall_s_e_texpos;
		int32_t smoothed_stone_wall_n_s_texpos;
		int32_t smoothed_stone_wall_w_e_texpos;
		int32_t smoothed_stone_wall_n_texpos;
		int32_t smoothed_stone_wall_s_texpos;
		int32_t smoothed_stone_wall_w_texpos;
		int32_t smoothed_stone_wall_e_texpos;
		int32_t smoothed_stone_wall_nw_texpos;
		int32_t smoothed_stone_wall_ne_texpos;
		int32_t smoothed_stone_wall_sw_texpos;
		int32_t smoothed_stone_wall_se_texpos;

		int32_t engraved_stone_wall_nswe_texpos;
		int32_t engraved_stone_wall_swe_texpos;
		int32_t engraved_stone_wall_nwe_texpos;
		int32_t engraved_stone_wall_nse_texpos;
		int32_t engraved_stone_wall_nsw_texpos;
		int32_t engraved_stone_wall_n_w_texpos;
		int32_t engraved_stone_wall_n_e_texpos;
		int32_t engraved_stone_wall_s_w_texpos;
		int32_t engraved_stone_wall_s_e_texpos;
		int32_t engraved_stone_wall_n_s_texpos;
		int32_t engraved_stone_wall_w_e_texpos;
		int32_t engraved_stone_wall_n_texpos;
		int32_t engraved_stone_wall_s_texpos;
		int32_t engraved_stone_wall_w_texpos;
		int32_t engraved_stone_wall_e_texpos;
		int32_t engraved_stone_wall_nw_texpos;
		int32_t engraved_stone_wall_ne_texpos;
		int32_t engraved_stone_wall_sw_texpos;
		int32_t engraved_stone_wall_se_texpos;

		int32_t root_wall_nswe_texpos;
		int32_t root_wall_swe_texpos;
		int32_t root_wall_nwe_texpos;
		int32_t root_wall_nse_texpos;
		int32_t root_wall_nsw_texpos;
		int32_t root_wall_n_w_texpos;
		int32_t root_wall_n_e_texpos;
		int32_t root_wall_s_w_texpos;
		int32_t root_wall_s_e_texpos;
		int32_t root_wall_n_s_texpos;
		int32_t root_wall_w_e_texpos;
		int32_t root_wall_n_texpos;
		int32_t root_wall_s_texpos;
		int32_t root_wall_w_texpos;
		int32_t root_wall_e_texpos;
		int32_t root_wall_nw_texpos;
		int32_t root_wall_ne_texpos;
		int32_t root_wall_sw_texpos;
		int32_t root_wall_se_texpos;

		int32_t moss_wall_nswe_texpos;
		int32_t moss_wall_swe_texpos;
		int32_t moss_wall_nwe_texpos;
		int32_t moss_wall_nse_texpos;
		int32_t moss_wall_nsw_texpos;
		int32_t moss_wall_n_w_texpos;
		int32_t moss_wall_n_e_texpos;
		int32_t moss_wall_s_w_texpos;
		int32_t moss_wall_s_e_texpos;
		int32_t moss_wall_n_s_texpos;
		int32_t moss_wall_w_e_texpos;
		int32_t moss_wall_n_texpos;
		int32_t moss_wall_s_texpos;
		int32_t moss_wall_w_texpos;
		int32_t moss_wall_e_texpos;
		int32_t moss_wall_nw_texpos;
		int32_t moss_wall_ne_texpos;
		int32_t moss_wall_sw_texpos;
		int32_t moss_wall_se_texpos;

		int32_t sand_wall_nswe_texpos;
		int32_t sand_wall_swe_texpos;
		int32_t sand_wall_nwe_texpos;
		int32_t sand_wall_nse_texpos;
		int32_t sand_wall_nsw_texpos;
		int32_t sand_wall_n_w_texpos;
		int32_t sand_wall_n_e_texpos;
		int32_t sand_wall_s_w_texpos;
		int32_t sand_wall_s_e_texpos;
		int32_t sand_wall_n_s_texpos;
		int32_t sand_wall_w_e_texpos;
		int32_t sand_wall_n_texpos;
		int32_t sand_wall_s_texpos;
		int32_t sand_wall_w_texpos;
		int32_t sand_wall_e_texpos;
		int32_t sand_wall_nw_texpos;
		int32_t sand_wall_ne_texpos;
		int32_t sand_wall_sw_texpos;
		int32_t sand_wall_se_texpos;

		int32_t sand_y_wall_nswe_texpos;
		int32_t sand_y_wall_swe_texpos;
		int32_t sand_y_wall_nwe_texpos;
		int32_t sand_y_wall_nse_texpos;
		int32_t sand_y_wall_nsw_texpos;
		int32_t sand_y_wall_n_w_texpos;
		int32_t sand_y_wall_n_e_texpos;
		int32_t sand_y_wall_s_w_texpos;
		int32_t sand_y_wall_s_e_texpos;
		int32_t sand_y_wall_n_s_texpos;
		int32_t sand_y_wall_w_e_texpos;
		int32_t sand_y_wall_n_texpos;
		int32_t sand_y_wall_s_texpos;
		int32_t sand_y_wall_w_texpos;
		int32_t sand_y_wall_e_texpos;
		int32_t sand_y_wall_nw_texpos;
		int32_t sand_y_wall_ne_texpos;
		int32_t sand_y_wall_sw_texpos;
		int32_t sand_y_wall_se_texpos;

		int32_t sand_w_wall_nswe_texpos;
		int32_t sand_w_wall_swe_texpos;
		int32_t sand_w_wall_nwe_texpos;
		int32_t sand_w_wall_nse_texpos;
		int32_t sand_w_wall_nsw_texpos;
		int32_t sand_w_wall_n_w_texpos;
		int32_t sand_w_wall_n_e_texpos;
		int32_t sand_w_wall_s_w_texpos;
		int32_t sand_w_wall_s_e_texpos;
		int32_t sand_w_wall_n_s_texpos;
		int32_t sand_w_wall_w_e_texpos;
		int32_t sand_w_wall_n_texpos;
		int32_t sand_w_wall_s_texpos;
		int32_t sand_w_wall_w_texpos;
		int32_t sand_w_wall_e_texpos;
		int32_t sand_w_wall_nw_texpos;
		int32_t sand_w_wall_ne_texpos;
		int32_t sand_w_wall_sw_texpos;
		int32_t sand_w_wall_se_texpos;

		int32_t sand_b_wall_nswe_texpos;
		int32_t sand_b_wall_swe_texpos;
		int32_t sand_b_wall_nwe_texpos;
		int32_t sand_b_wall_nse_texpos;
		int32_t sand_b_wall_nsw_texpos;
		int32_t sand_b_wall_n_w_texpos;
		int32_t sand_b_wall_n_e_texpos;
		int32_t sand_b_wall_s_w_texpos;
		int32_t sand_b_wall_s_e_texpos;
		int32_t sand_b_wall_n_s_texpos;
		int32_t sand_b_wall_w_e_texpos;
		int32_t sand_b_wall_n_texpos;
		int32_t sand_b_wall_s_texpos;
		int32_t sand_b_wall_w_texpos;
		int32_t sand_b_wall_e_texpos;
		int32_t sand_b_wall_nw_texpos;
		int32_t sand_b_wall_ne_texpos;
		int32_t sand_b_wall_sw_texpos;
		int32_t sand_b_wall_se_texpos;

		int32_t sand_r_wall_nswe_texpos;
		int32_t sand_r_wall_swe_texpos;
		int32_t sand_r_wall_nwe_texpos;
		int32_t sand_r_wall_nse_texpos;
		int32_t sand_r_wall_nsw_texpos;
		int32_t sand_r_wall_n_w_texpos;
		int32_t sand_r_wall_n_e_texpos;
		int32_t sand_r_wall_s_w_texpos;
		int32_t sand_r_wall_s_e_texpos;
		int32_t sand_r_wall_n_s_texpos;
		int32_t sand_r_wall_w_e_texpos;
		int32_t sand_r_wall_n_texpos;
		int32_t sand_r_wall_s_texpos;
		int32_t sand_r_wall_w_texpos;
		int32_t sand_r_wall_e_texpos;
		int32_t sand_r_wall_nw_texpos;
		int32_t sand_r_wall_ne_texpos;
		int32_t sand_r_wall_sw_texpos;
		int32_t sand_r_wall_se_texpos;

		int32_t ice_wall_nswe_texpos;
		int32_t ice_wall_swe_texpos;
		int32_t ice_wall_nwe_texpos;
		int32_t ice_wall_nse_texpos;
		int32_t ice_wall_nsw_texpos;
		int32_t ice_wall_n_w_texpos;
		int32_t ice_wall_n_e_texpos;
		int32_t ice_wall_s_w_texpos;
		int32_t ice_wall_s_e_texpos;
		int32_t ice_wall_n_s_texpos;
		int32_t ice_wall_w_e_texpos;
		int32_t ice_wall_n_texpos;
		int32_t ice_wall_s_texpos;
		int32_t ice_wall_w_texpos;
		int32_t ice_wall_e_texpos;
		int32_t ice_wall_nw_texpos;
		int32_t ice_wall_ne_texpos;
		int32_t ice_wall_sw_texpos;
		int32_t ice_wall_se_texpos;

		int32_t smoothed_ice_wall_nswe_texpos;
		int32_t smoothed_ice_wall_swe_texpos;
		int32_t smoothed_ice_wall_nwe_texpos;
		int32_t smoothed_ice_wall_nse_texpos;
		int32_t smoothed_ice_wall_nsw_texpos;
		int32_t smoothed_ice_wall_n_w_texpos;
		int32_t smoothed_ice_wall_n_e_texpos;
		int32_t smoothed_ice_wall_s_w_texpos;
		int32_t smoothed_ice_wall_s_e_texpos;
		int32_t smoothed_ice_wall_n_s_texpos;
		int32_t smoothed_ice_wall_w_e_texpos;
		int32_t smoothed_ice_wall_n_texpos;
		int32_t smoothed_ice_wall_s_texpos;
		int32_t smoothed_ice_wall_w_texpos;
		int32_t smoothed_ice_wall_e_texpos;
		int32_t smoothed_ice_wall_nw_texpos;
		int32_t smoothed_ice_wall_ne_texpos;
		int32_t smoothed_ice_wall_sw_texpos;
		int32_t smoothed_ice_wall_se_texpos;

		int32_t magma_wall_nswe_texpos;
		int32_t magma_wall_swe_texpos;
		int32_t magma_wall_nwe_texpos;
		int32_t magma_wall_nse_texpos;
		int32_t magma_wall_nsw_texpos;
		int32_t magma_wall_n_w_texpos;
		int32_t magma_wall_n_e_texpos;
		int32_t magma_wall_s_w_texpos;
		int32_t magma_wall_s_e_texpos;
		int32_t magma_wall_n_s_texpos;
		int32_t magma_wall_w_e_texpos;
		int32_t magma_wall_n_texpos;
		int32_t magma_wall_s_texpos;
		int32_t magma_wall_w_texpos;
		int32_t magma_wall_e_texpos;
		int32_t magma_wall_nw_texpos;
		int32_t magma_wall_ne_texpos;
		int32_t magma_wall_sw_texpos;
		int32_t magma_wall_se_texpos;

		int32_t gem_a_wall_nswe_texpos;
		int32_t gem_a_wall_swe_texpos;
		int32_t gem_a_wall_nwe_texpos;
		int32_t gem_a_wall_nse_texpos;
		int32_t gem_a_wall_nsw_texpos;
		int32_t gem_a_wall_n_w_texpos;
		int32_t gem_a_wall_n_e_texpos;
		int32_t gem_a_wall_s_w_texpos;
		int32_t gem_a_wall_s_e_texpos;
		int32_t gem_a_wall_n_s_texpos;
		int32_t gem_a_wall_w_e_texpos;
		int32_t gem_a_wall_n_texpos;
		int32_t gem_a_wall_s_texpos;
		int32_t gem_a_wall_w_texpos;
		int32_t gem_a_wall_e_texpos;
		int32_t gem_a_wall_nw_texpos;
		int32_t gem_a_wall_ne_texpos;
		int32_t gem_a_wall_sw_texpos;
		int32_t gem_a_wall_se_texpos;

		int32_t gem_b_wall_nswe_texpos;
		int32_t gem_b_wall_swe_texpos;
		int32_t gem_b_wall_nwe_texpos;
		int32_t gem_b_wall_nse_texpos;
		int32_t gem_b_wall_nsw_texpos;
		int32_t gem_b_wall_n_w_texpos;
		int32_t gem_b_wall_n_e_texpos;
		int32_t gem_b_wall_s_w_texpos;
		int32_t gem_b_wall_s_e_texpos;
		int32_t gem_b_wall_n_s_texpos;
		int32_t gem_b_wall_w_e_texpos;
		int32_t gem_b_wall_n_texpos;
		int32_t gem_b_wall_s_texpos;
		int32_t gem_b_wall_w_texpos;
		int32_t gem_b_wall_e_texpos;
		int32_t gem_b_wall_nw_texpos;
		int32_t gem_b_wall_ne_texpos;
		int32_t gem_b_wall_sw_texpos;
		int32_t gem_b_wall_se_texpos;

		int32_t gem_c_wall_nswe_texpos;
		int32_t gem_c_wall_swe_texpos;
		int32_t gem_c_wall_nwe_texpos;
		int32_t gem_c_wall_nse_texpos;
		int32_t gem_c_wall_nsw_texpos;
		int32_t gem_c_wall_n_w_texpos;
		int32_t gem_c_wall_n_e_texpos;
		int32_t gem_c_wall_s_w_texpos;
		int32_t gem_c_wall_s_e_texpos;
		int32_t gem_c_wall_n_s_texpos;
		int32_t gem_c_wall_w_e_texpos;
		int32_t gem_c_wall_n_texpos;
		int32_t gem_c_wall_s_texpos;
		int32_t gem_c_wall_w_texpos;
		int32_t gem_c_wall_e_texpos;
		int32_t gem_c_wall_nw_texpos;
		int32_t gem_c_wall_ne_texpos;
		int32_t gem_c_wall_sw_texpos;
		int32_t gem_c_wall_se_texpos;

		int32_t gem_d_wall_nswe_texpos;
		int32_t gem_d_wall_swe_texpos;
		int32_t gem_d_wall_nwe_texpos;
		int32_t gem_d_wall_nse_texpos;
		int32_t gem_d_wall_nsw_texpos;
		int32_t gem_d_wall_n_w_texpos;
		int32_t gem_d_wall_n_e_texpos;
		int32_t gem_d_wall_s_w_texpos;
		int32_t gem_d_wall_s_e_texpos;
		int32_t gem_d_wall_n_s_texpos;
		int32_t gem_d_wall_w_e_texpos;
		int32_t gem_d_wall_n_texpos;
		int32_t gem_d_wall_s_texpos;
		int32_t gem_d_wall_w_texpos;
		int32_t gem_d_wall_e_texpos;
		int32_t gem_d_wall_nw_texpos;
		int32_t gem_d_wall_ne_texpos;
		int32_t gem_d_wall_sw_texpos;
		int32_t gem_d_wall_se_texpos;

		int32_t metal_bars_wall_nswe_texpos;
		int32_t metal_bars_wall_swe_texpos;
		int32_t metal_bars_wall_nwe_texpos;
		int32_t metal_bars_wall_nse_texpos;
		int32_t metal_bars_wall_nsw_texpos;
		int32_t metal_bars_wall_n_w_texpos;
		int32_t metal_bars_wall_n_e_texpos;
		int32_t metal_bars_wall_s_w_texpos;
		int32_t metal_bars_wall_s_e_texpos;
		int32_t metal_bars_wall_n_s_texpos;
		int32_t metal_bars_wall_w_e_texpos;
		int32_t metal_bars_wall_n_texpos;
		int32_t metal_bars_wall_s_texpos;
		int32_t metal_bars_wall_w_texpos;
		int32_t metal_bars_wall_e_texpos;
		int32_t metal_bars_wall_nw_texpos;
		int32_t metal_bars_wall_ne_texpos;
		int32_t metal_bars_wall_sw_texpos;
		int32_t metal_bars_wall_se_texpos;

		int32_t ore_vein_wall_nswe_texpos;
		int32_t ore_vein_wall_swe_texpos;
		int32_t ore_vein_wall_nwe_texpos;
		int32_t ore_vein_wall_nse_texpos;
		int32_t ore_vein_wall_nsw_texpos;
		int32_t ore_vein_wall_n_w_texpos;
		int32_t ore_vein_wall_n_e_texpos;
		int32_t ore_vein_wall_s_w_texpos;
		int32_t ore_vein_wall_s_e_texpos;
		int32_t ore_vein_wall_n_s_texpos;
		int32_t ore_vein_wall_w_e_texpos;
		int32_t ore_vein_wall_n_texpos;
		int32_t ore_vein_wall_s_texpos;
		int32_t ore_vein_wall_w_texpos;
		int32_t ore_vein_wall_e_texpos;
		int32_t ore_vein_wall_nw_texpos;
		int32_t ore_vein_wall_ne_texpos;
		int32_t ore_vein_wall_sw_texpos;
		int32_t ore_vein_wall_se_texpos;

		int32_t wooden_wall_nswe_texpos;
		int32_t wooden_wall_swe_texpos;
		int32_t wooden_wall_nwe_texpos;
		int32_t wooden_wall_nse_texpos;
		int32_t wooden_wall_nsw_texpos;
		int32_t wooden_wall_n_w_texpos;
		int32_t wooden_wall_n_e_texpos;
		int32_t wooden_wall_s_w_texpos;
		int32_t wooden_wall_s_e_texpos;
		int32_t wooden_wall_n_s_texpos;
		int32_t wooden_wall_w_e_texpos;
		int32_t wooden_wall_n_texpos;
		int32_t wooden_wall_s_texpos;
		int32_t wooden_wall_w_texpos;
		int32_t wooden_wall_e_texpos;
		int32_t wooden_wall_nw_texpos;
		int32_t wooden_wall_ne_texpos;
		int32_t wooden_wall_sw_texpos;
		int32_t wooden_wall_se_texpos;

		int32_t rock_blocks_wall_nswe_texpos;
		int32_t rock_blocks_wall_swe_texpos;
		int32_t rock_blocks_wall_nwe_texpos;
		int32_t rock_blocks_wall_nse_texpos;
		int32_t rock_blocks_wall_nsw_texpos;
		int32_t rock_blocks_wall_n_w_texpos;
		int32_t rock_blocks_wall_n_e_texpos;
		int32_t rock_blocks_wall_s_w_texpos;
		int32_t rock_blocks_wall_s_e_texpos;
		int32_t rock_blocks_wall_n_s_texpos;
		int32_t rock_blocks_wall_w_e_texpos;
		int32_t rock_blocks_wall_n_texpos;
		int32_t rock_blocks_wall_s_texpos;
		int32_t rock_blocks_wall_w_texpos;
		int32_t rock_blocks_wall_e_texpos;
		int32_t rock_blocks_wall_nw_texpos;
		int32_t rock_blocks_wall_ne_texpos;
		int32_t rock_blocks_wall_sw_texpos;
		int32_t rock_blocks_wall_se_texpos;

		int32_t reinforced_metal_wall_nswe_texpos;
		int32_t reinforced_metal_wall_swe_texpos;
		int32_t reinforced_metal_wall_nwe_texpos;
		int32_t reinforced_metal_wall_nse_texpos;
		int32_t reinforced_metal_wall_nsw_texpos;
		int32_t reinforced_metal_wall_n_w_texpos;
		int32_t reinforced_metal_wall_n_e_texpos;
		int32_t reinforced_metal_wall_s_w_texpos;
		int32_t reinforced_metal_wall_s_e_texpos;
		int32_t reinforced_metal_wall_n_s_texpos;
		int32_t reinforced_metal_wall_w_e_texpos;
		int32_t reinforced_metal_wall_n_texpos;
		int32_t reinforced_metal_wall_s_texpos;
		int32_t reinforced_metal_wall_w_texpos;
		int32_t reinforced_metal_wall_e_texpos;
		int32_t reinforced_metal_wall_nw_texpos;
		int32_t reinforced_metal_wall_ne_texpos;
		int32_t reinforced_metal_wall_sw_texpos;
		int32_t reinforced_metal_wall_se_texpos;

		int32_t stone_wall_nswe_texpos[4];
		int32_t stone_wall_swe_texpos;
		int32_t stone_wall_nwe_texpos;
		int32_t stone_wall_nse_texpos;
		int32_t stone_wall_nsw_texpos;
		int32_t stone_wall_n_w_texpos;
		int32_t stone_wall_n_e_texpos;
		int32_t stone_wall_s_w_texpos;
		int32_t stone_wall_s_e_texpos;
		int32_t stone_wall_n_s_texpos[4];
		int32_t stone_wall_w_e_texpos[4];
		int32_t stone_wall_n_texpos[4];
		int32_t stone_wall_s_texpos[4];
		int32_t stone_wall_w_texpos[4];
		int32_t stone_wall_e_texpos[4];
		int32_t stone_wall_nw_texpos;
		int32_t stone_wall_ne_texpos;
		int32_t stone_wall_sw_texpos;
		int32_t stone_wall_se_texpos;

		int32_t texpos_hidden_rock[5];

		int32_t texpos_track_stop_stone_n;
		int32_t texpos_track_stop_stone_s;
		int32_t texpos_track_stop_stone_w;
		int32_t texpos_track_stop_stone_e;
		int32_t texpos_track_stop_stone_ns;
		int32_t texpos_track_stop_stone_nw;
		int32_t texpos_track_stop_stone_ne;
		int32_t texpos_track_stop_stone_sw;
		int32_t texpos_track_stop_stone_se;
		int32_t texpos_track_stop_stone_we;
		int32_t texpos_track_stop_stone_nsw;
		int32_t texpos_track_stop_stone_nse;
		int32_t texpos_track_stop_stone_nwe;
		int32_t texpos_track_stop_stone_swe;
		int32_t texpos_track_stop_stone_nswe;
		int32_t texpos_track_stop_wood_n;
		int32_t texpos_track_stop_wood_s;
		int32_t texpos_track_stop_wood_w;
		int32_t texpos_track_stop_wood_e;
		int32_t texpos_track_stop_wood_ns;
		int32_t texpos_track_stop_wood_nw;
		int32_t texpos_track_stop_wood_ne;
		int32_t texpos_track_stop_wood_sw;
		int32_t texpos_track_stop_wood_se;
		int32_t texpos_track_stop_wood_we;
		int32_t texpos_track_stop_wood_nsw;
		int32_t texpos_track_stop_wood_nse;
		int32_t texpos_track_stop_wood_nwe;
		int32_t texpos_track_stop_wood_swe;
		int32_t texpos_track_stop_wood_nswe;

		int32_t texpos_stone_track_n;
		int32_t texpos_stone_track_s;
		int32_t texpos_stone_track_w;
		int32_t texpos_stone_track_e;
		int32_t texpos_stone_track_ns;
		int32_t texpos_stone_track_nw;
		int32_t texpos_stone_track_ne;
		int32_t texpos_stone_track_sw;
		int32_t texpos_stone_track_se;
		int32_t texpos_stone_track_we;
		int32_t texpos_stone_track_nsw;
		int32_t texpos_stone_track_nse;
		int32_t texpos_stone_track_nwe;
		int32_t texpos_stone_track_swe;
		int32_t texpos_stone_track_nswe;
		int32_t texpos_constructed_stone_track_n;
		int32_t texpos_constructed_stone_track_s;
		int32_t texpos_constructed_stone_track_w;
		int32_t texpos_constructed_stone_track_e;
		int32_t texpos_constructed_stone_track_ns;
		int32_t texpos_constructed_stone_track_nw;
		int32_t texpos_constructed_stone_track_ne;
		int32_t texpos_constructed_stone_track_sw;
		int32_t texpos_constructed_stone_track_se;
		int32_t texpos_constructed_stone_track_we;
		int32_t texpos_constructed_stone_track_nsw;
		int32_t texpos_constructed_stone_track_nse;
		int32_t texpos_constructed_stone_track_nwe;
		int32_t texpos_constructed_stone_track_swe;
		int32_t texpos_constructed_stone_track_nswe;
		int32_t texpos_constructed_wood_track_n;
		int32_t texpos_constructed_wood_track_s;
		int32_t texpos_constructed_wood_track_w;
		int32_t texpos_constructed_wood_track_e;
		int32_t texpos_constructed_wood_track_ns;
		int32_t texpos_constructed_wood_track_nw;
		int32_t texpos_constructed_wood_track_ne;
		int32_t texpos_constructed_wood_track_sw;
		int32_t texpos_constructed_wood_track_se;
		int32_t texpos_constructed_wood_track_we;
		int32_t texpos_constructed_wood_track_nsw;
		int32_t texpos_constructed_wood_track_nse;
		int32_t texpos_constructed_wood_track_nwe;
		int32_t texpos_constructed_wood_track_swe;
		int32_t texpos_constructed_wood_track_nswe;

		int32_t texpos_rollers_stone_n[2];
		int32_t texpos_rollers_stone_s[2];
		int32_t texpos_rollers_stone_w[2];
		int32_t texpos_rollers_stone_e[2];
		int32_t texpos_rollers_stone_ns[2];
		int32_t texpos_rollers_stone_nw[2];
		int32_t texpos_rollers_stone_ne[2];
		int32_t texpos_rollers_stone_sw[2];
		int32_t texpos_rollers_stone_se[2];
		int32_t texpos_rollers_stone_we[2];
		int32_t texpos_rollers_stone_nsw[2];
		int32_t texpos_rollers_stone_nse[2];
		int32_t texpos_rollers_stone_nwe[2];
		int32_t texpos_rollers_stone_swe[2];
		int32_t texpos_rollers_stone_nswe[2];
		int32_t texpos_rollers_wood_n[2];
		int32_t texpos_rollers_wood_s[2];
		int32_t texpos_rollers_wood_w[2];
		int32_t texpos_rollers_wood_e[2];
		int32_t texpos_rollers_wood_ns[2];
		int32_t texpos_rollers_wood_nw[2];
		int32_t texpos_rollers_wood_ne[2];
		int32_t texpos_rollers_wood_sw[2];
		int32_t texpos_rollers_wood_se[2];
		int32_t texpos_rollers_wood_we[2];
		int32_t texpos_rollers_wood_nsw[2];
		int32_t texpos_rollers_wood_nse[2];
		int32_t texpos_rollers_wood_nwe[2];
		int32_t texpos_rollers_wood_swe[2];
		int32_t texpos_rollers_wood_nswe[2];

		int32_t water_texpos;
		int32_t magma_texpos[3];
		int32_t grass_texpos[4][9];
		int32_t custom_grass_edge_texpos[32][9];
		int32_t stone_floor_texpos[4][9];
		int32_t dirt_floor_texpos[4][9];
		int32_t underwater_texpos[8];
		int32_t undermagma_texpos[8];
		int32_t underwater_label_texpos[8];
		int32_t undermagma_label_texpos[8];
		int32_t underwater_edge_texpos[3][3];
		int32_t undermagma_edge_texpos[3][3];
		svector<int32_t> texpos_boulder;
		int32_t texpos_driftwood;
		int32_t texpos_campfire_top[4];
		int32_t texpos_campfire[4];
		int32_t texpos_campfire_dead;

		int32_t texpos_fire[4];
		int32_t texpos_fireball[2];
		int32_t texpos_eerie_pit[4];
		int32_t texpos_floor_ashes[4];
		int32_t texpos_floor_stone_block;
		int32_t texpos_floor_stone_engraved_non_palette;
		int32_t texpos_floor_stone_engraved_palette;
		//********************************* BETTER ENGRAVINGS vars

		int32_t texpos_floor_wood;
		int32_t texpos_floor_ice_rough;
		int32_t texpos_floor_ice_smooth;
		int32_t texpos_floor_glass_green;
		int32_t texpos_floor_glass_clear;
		int32_t texpos_floor_glass_crystal;
		int32_t texpos_floor_sand[4][9];
		int32_t texpos_floor_sand_yellow[4][9];
		int32_t texpos_floor_sand_white[4][9];
		int32_t texpos_floor_sand_black[4][9];
		int32_t texpos_floor_sand_red[4][9];
		int32_t texpos_floor_pebbles[4][9];
		int32_t texpos_floor_metal;
		int32_t texpos_floor_furrowed_soil[4];

		int32_t texpos_shrub;
		int32_t texpos_sapling;
		int32_t texpos_tree_wood_tile[TREE_WOOD_TILENUM];
		int32_t texpos_tree_twigs_full[4];
		int32_t texpos_tree_twigs_full_n;
		int32_t texpos_tree_twigs_full_s;
		int32_t texpos_tree_twigs_full_w;
		int32_t texpos_tree_twigs_full_e;
		int32_t texpos_tree_twigs_full_nw;
		int32_t texpos_tree_twigs_full_ne;
		int32_t texpos_tree_twigs_full_sw;
		int32_t texpos_tree_twigs_full_se;
		int32_t texpos_tree_twigs_n_s_w_e;
		int32_t texpos_tree_twigs_s_w_e;
		int32_t texpos_tree_twigs_n_w_e;
		int32_t texpos_tree_twigs_n_s_e;
		int32_t texpos_tree_twigs_n_s_w;
		int32_t texpos_tree_twigs_n_s;
		int32_t texpos_tree_twigs_n_w;
		int32_t texpos_tree_twigs_n_e;
		int32_t texpos_tree_twigs_s_w;
		int32_t texpos_tree_twigs_s_e;
		int32_t texpos_tree_twigs_w_e;
		int32_t texpos_tree_twigs_n;
		int32_t texpos_tree_twigs_s;
		int32_t texpos_tree_twigs_w;
		int32_t texpos_tree_twigs_e;
		int32_t texpos_tree_twigs;
		int32_t texpos_overleaves_trunk_n_s_e;
		int32_t texpos_overleaves_trunk_n_s_w;
		int32_t texpos_overleaves_trunk_n_w_e;
		int32_t texpos_overleaves_trunk_s_w_e;
		int32_t texpos_overleaves_trunk_n_w;
		int32_t texpos_overleaves_trunk_n_e;
		int32_t texpos_overleaves_trunk_s_w;
		int32_t texpos_overleaves_trunk_s_e;
		int32_t texpos_overleaves_trunk_n_s;
		int32_t texpos_overleaves_trunk_e_w;
		int32_t texpos_overleaves_trunk_n;
		int32_t texpos_overleaves_trunk_s;
		int32_t texpos_overleaves_trunk_w;
		int32_t texpos_overleaves_trunk_e;
		int32_t texpos_overleaves_trunk_n_s_e_w;
		int32_t texpos_tree_overleaves_heavy_branch_n;
		int32_t texpos_tree_overleaves_heavy_branch_s;
		int32_t texpos_tree_overleaves_heavy_branch_w;
		int32_t texpos_tree_overleaves_heavy_branch_e;
		int32_t texpos_tree_overleaves_heavy_branch_ns;
		int32_t texpos_tree_overleaves_heavy_branch_ew;
		int32_t texpos_tree_overleaves_heavy_branch_nw;
		int32_t texpos_tree_overleaves_heavy_branch_ne;
		int32_t texpos_tree_overleaves_heavy_branch_sw;
		int32_t texpos_tree_overleaves_heavy_branch_se;
		int32_t texpos_tree_overleaves_heavy_branch_nse;
		int32_t texpos_tree_overleaves_heavy_branch_nsw;
		int32_t texpos_tree_overleaves_heavy_branch_new;
		int32_t texpos_tree_overleaves_heavy_branch_sew;
		int32_t texpos_tree_overleaves_heavy_branch_nsew;

		int32_t texpos_tree_twigs_autumn[3];
		int32_t texpos_tree_twigs_full_autumn[4][3];
		int32_t texpos_tree_twigs_full_n_autumn[3];
		int32_t texpos_tree_twigs_full_s_autumn[3];
		int32_t texpos_tree_twigs_full_w_autumn[3];
		int32_t texpos_tree_twigs_full_e_autumn[3];
		int32_t texpos_tree_twigs_full_nw_autumn[3];
		int32_t texpos_tree_twigs_full_ne_autumn[3];
		int32_t texpos_tree_twigs_full_sw_autumn[3];
		int32_t texpos_tree_twigs_full_se_autumn[3];
		int32_t texpos_tree_twigs_n_s_w_e_autumn[3];
		int32_t texpos_tree_twigs_s_w_e_autumn[3];
		int32_t texpos_tree_twigs_n_w_e_autumn[3];
		int32_t texpos_tree_twigs_n_s_e_autumn[3];
		int32_t texpos_tree_twigs_n_s_w_autumn[3];
		int32_t texpos_tree_twigs_n_s_autumn[3];
		int32_t texpos_tree_twigs_n_w_autumn[3];
		int32_t texpos_tree_twigs_n_e_autumn[3];
		int32_t texpos_tree_twigs_s_w_autumn[3];
		int32_t texpos_tree_twigs_s_e_autumn[3];
		int32_t texpos_tree_twigs_w_e_autumn[3];
		int32_t texpos_tree_twigs_n_autumn[3];
		int32_t texpos_tree_twigs_s_autumn[3];
		int32_t texpos_tree_twigs_w_autumn[3];
		int32_t texpos_tree_twigs_e_autumn[3];
		int32_t texpos_overleaves_trunk_n_s_e_autumn[3];
		int32_t texpos_overleaves_trunk_n_s_w_autumn[3];
		int32_t texpos_overleaves_trunk_n_w_e_autumn[3];
		int32_t texpos_overleaves_trunk_s_w_e_autumn[3];
		int32_t texpos_overleaves_trunk_n_w_autumn[3];
		int32_t texpos_overleaves_trunk_n_e_autumn[3];
		int32_t texpos_overleaves_trunk_s_w_autumn[3];
		int32_t texpos_overleaves_trunk_s_e_autumn[3];
		int32_t texpos_overleaves_trunk_n_s_autumn[3];
		int32_t texpos_overleaves_trunk_e_w_autumn[3];
		int32_t texpos_overleaves_trunk_n_autumn[3];
		int32_t texpos_overleaves_trunk_s_autumn[3];
		int32_t texpos_overleaves_trunk_w_autumn[3];
		int32_t texpos_overleaves_trunk_e_autumn[3];
		int32_t texpos_overleaves_trunk_n_s_e_w_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_n_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_s_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_w_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_e_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_ns_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_ew_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_nw_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_ne_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_sw_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_se_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_nse_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_nsw_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_new_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_sew_autumn[3];
		int32_t texpos_tree_overleaves_heavy_branch_nsew_autumn[3];
		int32_t texpos_tree_twigs_fruit[3];
		int32_t texpos_tree_twigs_full_fruit[4][3];
		int32_t texpos_tree_twigs_full_n_fruit[3];
		int32_t texpos_tree_twigs_full_s_fruit[3];
		int32_t texpos_tree_twigs_full_w_fruit[3];
		int32_t texpos_tree_twigs_full_e_fruit[3];
		int32_t texpos_tree_twigs_full_nw_fruit[3];
		int32_t texpos_tree_twigs_full_ne_fruit[3];
		int32_t texpos_tree_twigs_full_sw_fruit[3];
		int32_t texpos_tree_twigs_full_se_fruit[3];
		int32_t texpos_tree_twigs_n_s_w_e_fruit[3];
		int32_t texpos_tree_twigs_s_w_e_fruit[3];
		int32_t texpos_tree_twigs_n_w_e_fruit[3];
		int32_t texpos_tree_twigs_n_s_e_fruit[3];
		int32_t texpos_tree_twigs_n_s_w_fruit[3];
		int32_t texpos_tree_twigs_n_s_fruit[3];
		int32_t texpos_tree_twigs_n_w_fruit[3];
		int32_t texpos_tree_twigs_n_e_fruit[3];
		int32_t texpos_tree_twigs_s_w_fruit[3];
		int32_t texpos_tree_twigs_s_e_fruit[3];
		int32_t texpos_tree_twigs_w_e_fruit[3];
		int32_t texpos_tree_twigs_n_fruit[3];
		int32_t texpos_tree_twigs_s_fruit[3];
		int32_t texpos_tree_twigs_w_fruit[3];
		int32_t texpos_tree_twigs_e_fruit[3];
		int32_t texpos_overleaves_trunk_n_s_e_fruit[3];
		int32_t texpos_overleaves_trunk_n_s_w_fruit[3];
		int32_t texpos_overleaves_trunk_n_w_e_fruit[3];
		int32_t texpos_overleaves_trunk_s_w_e_fruit[3];
		int32_t texpos_overleaves_trunk_n_w_fruit[3];
		int32_t texpos_overleaves_trunk_n_e_fruit[3];
		int32_t texpos_overleaves_trunk_s_w_fruit[3];
		int32_t texpos_overleaves_trunk_s_e_fruit[3];
		int32_t texpos_overleaves_trunk_n_s_fruit[3];
		int32_t texpos_overleaves_trunk_e_w_fruit[3];
		int32_t texpos_overleaves_trunk_n_fruit[3];
		int32_t texpos_overleaves_trunk_s_fruit[3];
		int32_t texpos_overleaves_trunk_w_fruit[3];
		int32_t texpos_overleaves_trunk_e_fruit[3];
		int32_t texpos_overleaves_trunk_n_s_e_w_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_n_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_s_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_w_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_e_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_ns_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_ew_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_nw_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_ne_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_sw_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_se_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_nse_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_nsw_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_new_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_sew_fruit[3];
		int32_t texpos_tree_overleaves_heavy_branch_nsew_fruit[3];
		int32_t texpos_tree_twigs_flower[3];
		int32_t texpos_tree_twigs_full_flower[4][3];
		int32_t texpos_tree_twigs_full_n_flower[3];
		int32_t texpos_tree_twigs_full_s_flower[3];
		int32_t texpos_tree_twigs_full_w_flower[3];
		int32_t texpos_tree_twigs_full_e_flower[3];
		int32_t texpos_tree_twigs_full_nw_flower[3];
		int32_t texpos_tree_twigs_full_ne_flower[3];
		int32_t texpos_tree_twigs_full_sw_flower[3];
		int32_t texpos_tree_twigs_full_se_flower[3];
		int32_t texpos_tree_twigs_n_s_w_e_flower[3];
		int32_t texpos_tree_twigs_s_w_e_flower[3];
		int32_t texpos_tree_twigs_n_w_e_flower[3];
		int32_t texpos_tree_twigs_n_s_e_flower[3];
		int32_t texpos_tree_twigs_n_s_w_flower[3];
		int32_t texpos_tree_twigs_n_s_flower[3];
		int32_t texpos_tree_twigs_n_w_flower[3];
		int32_t texpos_tree_twigs_n_e_flower[3];
		int32_t texpos_tree_twigs_s_w_flower[3];
		int32_t texpos_tree_twigs_s_e_flower[3];
		int32_t texpos_tree_twigs_w_e_flower[3];
		int32_t texpos_tree_twigs_n_flower[3];
		int32_t texpos_tree_twigs_s_flower[3];
		int32_t texpos_tree_twigs_w_flower[3];
		int32_t texpos_tree_twigs_e_flower[3];
		int32_t texpos_overleaves_trunk_n_s_e_flower[3];
		int32_t texpos_overleaves_trunk_n_s_w_flower[3];
		int32_t texpos_overleaves_trunk_n_w_e_flower[3];
		int32_t texpos_overleaves_trunk_s_w_e_flower[3];
		int32_t texpos_overleaves_trunk_n_w_flower[3];
		int32_t texpos_overleaves_trunk_n_e_flower[3];
		int32_t texpos_overleaves_trunk_s_w_flower[3];
		int32_t texpos_overleaves_trunk_s_e_flower[3];
		int32_t texpos_overleaves_trunk_n_s_flower[3];
		int32_t texpos_overleaves_trunk_e_w_flower[3];
		int32_t texpos_overleaves_trunk_n_flower[3];
		int32_t texpos_overleaves_trunk_s_flower[3];
		int32_t texpos_overleaves_trunk_w_flower[3];
		int32_t texpos_overleaves_trunk_e_flower[3];
		int32_t texpos_overleaves_trunk_n_s_e_w_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_n_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_s_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_w_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_e_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_ns_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_ew_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_nw_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_ne_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_sw_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_se_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_nse_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_nsw_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_new_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_sew_flower[3];
		int32_t texpos_tree_overleaves_heavy_branch_nsew_flower[3];

		int32_t texpos_tree_cap_pillar;
		int32_t texpos_tree_cap_wall_thick_n;
		int32_t texpos_tree_cap_wall_thick_s;
		int32_t texpos_tree_cap_wall_thick_e;
		int32_t texpos_tree_cap_wall_thick_w;
		int32_t texpos_tree_cap_wall_thick_nw;
		int32_t texpos_tree_cap_wall_thick_ne;
		int32_t texpos_tree_cap_wall_thick_sw;
		int32_t texpos_tree_cap_wall_thick_se;
		int32_t texpos_tree_cap_wall_n_s_e;
		int32_t texpos_tree_cap_wall_n_s_w;
		int32_t texpos_tree_cap_wall_n_w_e;
		int32_t texpos_tree_cap_wall_s_w_e;
		int32_t texpos_tree_cap_wall_n_w;
		int32_t texpos_tree_cap_wall_n_e;
		int32_t texpos_tree_cap_wall_s_w;
		int32_t texpos_tree_cap_wall_s_e;
		int32_t texpos_tree_cap_wall_n_s;
		int32_t texpos_tree_cap_wall_w_e;
		int32_t texpos_tree_cap_wall_n;
		int32_t texpos_tree_cap_wall_s;
		int32_t texpos_tree_cap_wall_w;
		int32_t texpos_tree_cap_wall_e;
		int32_t texpos_tree_cap_wall_n_s_w_e;
		int32_t texpos_tree_cap_thick_interior;
		int32_t texpos_tree_cap_floor_1;
		int32_t texpos_tree_cap_floor_2;
		int32_t texpos_tree_cap_floor_3;
		int32_t texpos_tree_cap_floor_4;
		int32_t texpos_tree_cap_ramp;
		int32_t texpos_tree_cap_ramp_n_s_w_e;
		int32_t texpos_tree_cap_ramp_n_s_e;
		int32_t texpos_tree_cap_ramp_n_s_w;
		int32_t texpos_tree_cap_ramp_n_w_e;
		int32_t texpos_tree_cap_ramp_s_w_e;
		int32_t texpos_tree_cap_ramp_n_w;
		int32_t texpos_tree_cap_ramp_n_e;
		int32_t texpos_tree_cap_ramp_s_w;
		int32_t texpos_tree_cap_ramp_s_e;
		int32_t texpos_tree_cap_ramp_n_s;
		int32_t texpos_tree_cap_ramp_w_e;
		int32_t texpos_tree_cap_ramp_n;
		int32_t texpos_tree_cap_ramp_s;
		int32_t texpos_tree_cap_ramp_w;
		int32_t texpos_tree_cap_ramp_e;

		int32_t texpos_tree_core_trunk[3][3];
		int32_t texpos_tree_core_shadow[3][3];

		int32_t texpos_forgotten_beast_icon;
		int32_t texpos_titan_icon;
		int32_t texpos_demon_icon;
		int32_t texpos_night_creature_icon;
		int32_t texpos_angel_icon;

		int32_t texpos_ramp_up_arrow;
		int32_t texpos_ramp_down_arrow;
		int32_t texpos_liquid_numbers_on[2][2];
		int32_t texpos_liquid_numbers_off[2][2];
		int32_t texpos_ramp_arrows_on[2][2];
		int32_t texpos_ramp_arrows_off[2][2];

		int32_t texpos_zoom_in_on[2][2];
		int32_t texpos_zoom_in_off[2][2];
		int32_t texpos_zoom_out_on[2][2];
		int32_t texpos_zoom_out_off[2][2];

		int32_t texpos_adv_liquid_numbers_on[2][2];
		int32_t texpos_adv_liquid_numbers_off[2][2];
		int32_t texpos_adv_ramp_arrows_on[2][2];
		int32_t texpos_adv_ramp_arrows_off[2][2];

		int32_t texpos_adv_zoom_in_on[2][2];
		int32_t texpos_adv_zoom_in_off[2][2];
		int32_t texpos_adv_zoom_out_on[2][2];
		int32_t texpos_adv_zoom_out_off[2][2];
		int32_t texpos_adv_tracks_on[2][2];
		int32_t texpos_adv_tracks_off[2][2];

		int32_t texpos_adv_env[INTERFACE_ADV_ENV_TEXTURENUM][4][3];

		int32_t look_cursor_texpos;
		int32_t talk_cursor_texpos;
		int32_t legal_jump_texpos;
		int32_t illegal_jump_texpos;
		int32_t error_cursor_texpos;
		int32_t out_of_bounds_cursor_texpos;

		int32_t texpos_rectangle_cursor_n_w[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n_s_w[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n_s[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n_s_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_w[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_interior[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n_w_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_s_w_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_s_w[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_s[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_s_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_w_e[RECTANGLE_CURSORNUM];
		int32_t texpos_rectangle_cursor_n_s_w_e[RECTANGLE_CURSORNUM];

		int32_t texpos_keyboard_cursor;

		int32_t texpos_recenter_indicator[3];
		int32_t texpos_target_indicator[3];

		int32_t texpos_patrol_route_point;
		int32_t texpos_patrol_route_line;

		int32_t texpos_viewport_grid;

		int32_t overlay_ramp_with_wall_nsew;
		int32_t overlay_ramp_with_wall_nse;
		int32_t overlay_ramp_with_wall_nsw;
		int32_t overlay_ramp_with_wall_nwe;
		int32_t overlay_ramp_with_wall_swe;
		int32_t overlay_ramp_with_wall_n_s;
		int32_t overlay_ramp_with_wall_n_w;
		int32_t overlay_ramp_with_wall_n_e;
		int32_t overlay_ramp_with_wall_s_w;
		int32_t overlay_ramp_with_wall_s_e;
		int32_t overlay_ramp_with_wall_w_e;
		int32_t overlay_ramp_with_wall_n;
		int32_t overlay_ramp_with_wall_s;
		int32_t overlay_ramp_with_wall_w;
		int32_t overlay_ramp_with_wall_e;
		int32_t overlay_ramp_with_wall_nw;
		int32_t overlay_ramp_with_wall_sw;
		int32_t overlay_ramp_with_wall_se;
		int32_t overlay_ramp_with_wall_ne;
		int32_t overlay_ramp_with_wall_nw_ne;
		int32_t overlay_ramp_with_wall_sw_se;
		int32_t overlay_ramp_with_wall_nw_sw;
		int32_t overlay_ramp_with_wall_ne_se;
		int32_t overlay_ramp_other;
		int32_t overlay_ramp_with_wall_s_ne;
		int32_t overlay_ramp_with_wall_w_se;
		int32_t overlay_ramp_with_wall_n_sw;
		int32_t overlay_ramp_with_wall_e_nw;
		int32_t overlay_ramp_with_wall_e_sw;
		int32_t overlay_ramp_with_wall_s_nw;
		int32_t overlay_ramp_with_wall_w_ne;
		int32_t overlay_ramp_with_wall_n_se;
		int32_t overlay_ramp_with_wall_s_e_nw;
		int32_t overlay_ramp_with_wall_s_w_ne;
		int32_t overlay_ramp_with_wall_n_w_se;
		int32_t overlay_ramp_with_wall_n_e_sw;
		int32_t overlay_ramp_with_wall_n_sw_se;
		int32_t overlay_ramp_with_wall_e_nw_sw;
		int32_t overlay_ramp_with_wall_s_nw_ne;
		int32_t overlay_ramp_with_wall_w_ne_se;
		int32_t overlay_ramp_with_wall_nw_se;
		int32_t overlay_ramp_with_wall_ne_sw;
		int32_t overlay_ramp_with_wall_nw_ne_sw_se;
		int32_t overlay_ramp_with_wall_nw_ne_sw;
		int32_t overlay_ramp_with_wall_nw_ne_se;
		int32_t overlay_ramp_with_wall_nw_sw_se;
		int32_t overlay_ramp_with_wall_ne_sw_se;

		int32_t grass_ramp_with_wall_nsew;
		int32_t grass_ramp_with_wall_nse;
		int32_t grass_ramp_with_wall_nsw;
		int32_t grass_ramp_with_wall_nwe;
		int32_t grass_ramp_with_wall_swe;
		int32_t grass_ramp_with_wall_n_s;
		int32_t grass_ramp_with_wall_n_w;
		int32_t grass_ramp_with_wall_n_e;
		int32_t grass_ramp_with_wall_s_w;
		int32_t grass_ramp_with_wall_s_e;
		int32_t grass_ramp_with_wall_w_e;
		int32_t grass_ramp_with_wall_n;
		int32_t grass_ramp_with_wall_s;
		int32_t grass_ramp_with_wall_w;
		int32_t grass_ramp_with_wall_e;
		int32_t grass_ramp_with_wall_nw;
		int32_t grass_ramp_with_wall_sw;
		int32_t grass_ramp_with_wall_se;
		int32_t grass_ramp_with_wall_ne;
		int32_t grass_ramp_with_wall_nw_ne;
		int32_t grass_ramp_with_wall_sw_se;
		int32_t grass_ramp_with_wall_nw_sw;
		int32_t grass_ramp_with_wall_ne_se;
		int32_t grass_ramp_other;
		int32_t grass_ramp_with_wall_s_ne;
		int32_t grass_ramp_with_wall_w_se;
		int32_t grass_ramp_with_wall_n_sw;
		int32_t grass_ramp_with_wall_e_nw;
		int32_t grass_ramp_with_wall_e_sw;
		int32_t grass_ramp_with_wall_s_nw;
		int32_t grass_ramp_with_wall_w_ne;
		int32_t grass_ramp_with_wall_n_se;
		int32_t grass_ramp_with_wall_s_e_nw;
		int32_t grass_ramp_with_wall_s_w_ne;
		int32_t grass_ramp_with_wall_n_w_se;
		int32_t grass_ramp_with_wall_n_e_sw;
		int32_t grass_ramp_with_wall_n_sw_se;
		int32_t grass_ramp_with_wall_e_nw_sw;
		int32_t grass_ramp_with_wall_s_nw_ne;
		int32_t grass_ramp_with_wall_w_ne_se;
		int32_t grass_ramp_with_wall_nw_se;
		int32_t grass_ramp_with_wall_ne_sw;
		int32_t grass_ramp_with_wall_nw_ne_sw_se;
		int32_t grass_ramp_with_wall_nw_ne_sw;
		int32_t grass_ramp_with_wall_nw_ne_se;
		int32_t grass_ramp_with_wall_nw_sw_se;
		int32_t grass_ramp_with_wall_ne_sw_se;

		int32_t custom_grass_ramp_with_wall_nsew[32];
		int32_t custom_grass_ramp_with_wall_nse[32];
		int32_t custom_grass_ramp_with_wall_nsw[32];
		int32_t custom_grass_ramp_with_wall_nwe[32];
		int32_t custom_grass_ramp_with_wall_swe[32];
		int32_t custom_grass_ramp_with_wall_n_s[32];
		int32_t custom_grass_ramp_with_wall_n_w[32];
		int32_t custom_grass_ramp_with_wall_n_e[32];
		int32_t custom_grass_ramp_with_wall_s_w[32];
		int32_t custom_grass_ramp_with_wall_s_e[32];
		int32_t custom_grass_ramp_with_wall_w_e[32];
		int32_t custom_grass_ramp_with_wall_n[32];
		int32_t custom_grass_ramp_with_wall_s[32];
		int32_t custom_grass_ramp_with_wall_w[32];
		int32_t custom_grass_ramp_with_wall_e[32];
		int32_t custom_grass_ramp_with_wall_nw[32];
		int32_t custom_grass_ramp_with_wall_sw[32];
		int32_t custom_grass_ramp_with_wall_se[32];
		int32_t custom_grass_ramp_with_wall_ne[32];
		int32_t custom_grass_ramp_with_wall_nw_ne[32];
		int32_t custom_grass_ramp_with_wall_sw_se[32];
		int32_t custom_grass_ramp_with_wall_nw_sw[32];
		int32_t custom_grass_ramp_with_wall_ne_se[32];
		int32_t custom_grass_ramp_other[32];
		int32_t custom_grass_ramp_with_wall_s_ne[32];
		int32_t custom_grass_ramp_with_wall_w_se[32];
		int32_t custom_grass_ramp_with_wall_n_sw[32];
		int32_t custom_grass_ramp_with_wall_e_nw[32];
		int32_t custom_grass_ramp_with_wall_e_sw[32];
		int32_t custom_grass_ramp_with_wall_s_nw[32];
		int32_t custom_grass_ramp_with_wall_w_ne[32];
		int32_t custom_grass_ramp_with_wall_n_se[32];
		int32_t custom_grass_ramp_with_wall_s_e_nw[32];
		int32_t custom_grass_ramp_with_wall_s_w_ne[32];
		int32_t custom_grass_ramp_with_wall_n_w_se[32];
		int32_t custom_grass_ramp_with_wall_n_e_sw[32];
		int32_t custom_grass_ramp_with_wall_n_sw_se[32];
		int32_t custom_grass_ramp_with_wall_e_nw_sw[32];
		int32_t custom_grass_ramp_with_wall_s_nw_ne[32];
		int32_t custom_grass_ramp_with_wall_w_ne_se[32];
		int32_t custom_grass_ramp_with_wall_nw_se[32];
		int32_t custom_grass_ramp_with_wall_ne_sw[32];
		int32_t custom_grass_ramp_with_wall_nw_ne_sw_se[32];
		int32_t custom_grass_ramp_with_wall_nw_ne_sw[32];
		int32_t custom_grass_ramp_with_wall_nw_ne_se[32];
		int32_t custom_grass_ramp_with_wall_nw_sw_se[32];
		int32_t custom_grass_ramp_with_wall_ne_sw_se[32];

		int32_t soil_ramp_with_wall_nsew;
		int32_t soil_ramp_with_wall_nse;
		int32_t soil_ramp_with_wall_nsw;
		int32_t soil_ramp_with_wall_nwe;
		int32_t soil_ramp_with_wall_swe;
		int32_t soil_ramp_with_wall_n_s;
		int32_t soil_ramp_with_wall_n_w;
		int32_t soil_ramp_with_wall_n_e;
		int32_t soil_ramp_with_wall_s_w;
		int32_t soil_ramp_with_wall_s_e;
		int32_t soil_ramp_with_wall_w_e;
		int32_t soil_ramp_with_wall_n;
		int32_t soil_ramp_with_wall_s;
		int32_t soil_ramp_with_wall_w;
		int32_t soil_ramp_with_wall_e;
		int32_t soil_ramp_with_wall_nw;
		int32_t soil_ramp_with_wall_sw;
		int32_t soil_ramp_with_wall_se;
		int32_t soil_ramp_with_wall_ne;
		int32_t soil_ramp_with_wall_nw_ne;
		int32_t soil_ramp_with_wall_sw_se;
		int32_t soil_ramp_with_wall_nw_sw;
		int32_t soil_ramp_with_wall_ne_se;
		int32_t soil_ramp_other;
		int32_t soil_ramp_with_wall_s_ne;
		int32_t soil_ramp_with_wall_w_se;
		int32_t soil_ramp_with_wall_n_sw;
		int32_t soil_ramp_with_wall_e_nw;
		int32_t soil_ramp_with_wall_e_sw;
		int32_t soil_ramp_with_wall_s_nw;
		int32_t soil_ramp_with_wall_w_ne;
		int32_t soil_ramp_with_wall_n_se;
		int32_t soil_ramp_with_wall_s_e_nw;
		int32_t soil_ramp_with_wall_s_w_ne;
		int32_t soil_ramp_with_wall_n_w_se;
		int32_t soil_ramp_with_wall_n_e_sw;
		int32_t soil_ramp_with_wall_n_sw_se;
		int32_t soil_ramp_with_wall_e_nw_sw;
		int32_t soil_ramp_with_wall_s_nw_ne;
		int32_t soil_ramp_with_wall_w_ne_se;
		int32_t soil_ramp_with_wall_nw_se;
		int32_t soil_ramp_with_wall_ne_sw;
		int32_t soil_ramp_with_wall_nw_ne_sw_se;
		int32_t soil_ramp_with_wall_nw_ne_sw;
		int32_t soil_ramp_with_wall_nw_ne_se;
		int32_t soil_ramp_with_wall_nw_sw_se;
		int32_t soil_ramp_with_wall_ne_sw_se;

		int32_t sand_beige_ramp_with_wall_nsew;
		int32_t sand_beige_ramp_with_wall_nse;
		int32_t sand_beige_ramp_with_wall_nsw;
		int32_t sand_beige_ramp_with_wall_nwe;
		int32_t sand_beige_ramp_with_wall_swe;
		int32_t sand_beige_ramp_with_wall_n_s;
		int32_t sand_beige_ramp_with_wall_n_w;
		int32_t sand_beige_ramp_with_wall_n_e;
		int32_t sand_beige_ramp_with_wall_s_w;
		int32_t sand_beige_ramp_with_wall_s_e;
		int32_t sand_beige_ramp_with_wall_w_e;
		int32_t sand_beige_ramp_with_wall_n;
		int32_t sand_beige_ramp_with_wall_s;
		int32_t sand_beige_ramp_with_wall_w;
		int32_t sand_beige_ramp_with_wall_e;
		int32_t sand_beige_ramp_with_wall_nw;
		int32_t sand_beige_ramp_with_wall_sw;
		int32_t sand_beige_ramp_with_wall_se;
		int32_t sand_beige_ramp_with_wall_ne;
		int32_t sand_beige_ramp_with_wall_nw_ne;
		int32_t sand_beige_ramp_with_wall_sw_se;
		int32_t sand_beige_ramp_with_wall_nw_sw;
		int32_t sand_beige_ramp_with_wall_ne_se;
		int32_t sand_beige_ramp_other;
		int32_t sand_beige_ramp_with_wall_s_ne;
		int32_t sand_beige_ramp_with_wall_w_se;
		int32_t sand_beige_ramp_with_wall_n_sw;
		int32_t sand_beige_ramp_with_wall_e_nw;
		int32_t sand_beige_ramp_with_wall_e_sw;
		int32_t sand_beige_ramp_with_wall_s_nw;
		int32_t sand_beige_ramp_with_wall_w_ne;
		int32_t sand_beige_ramp_with_wall_n_se;
		int32_t sand_beige_ramp_with_wall_s_e_nw;
		int32_t sand_beige_ramp_with_wall_s_w_ne;
		int32_t sand_beige_ramp_with_wall_n_w_se;
		int32_t sand_beige_ramp_with_wall_n_e_sw;
		int32_t sand_beige_ramp_with_wall_n_sw_se;
		int32_t sand_beige_ramp_with_wall_e_nw_sw;
		int32_t sand_beige_ramp_with_wall_s_nw_ne;
		int32_t sand_beige_ramp_with_wall_w_ne_se;
		int32_t sand_beige_ramp_with_wall_nw_se;
		int32_t sand_beige_ramp_with_wall_ne_sw;
		int32_t sand_beige_ramp_with_wall_nw_ne_sw_se;
		int32_t sand_beige_ramp_with_wall_nw_ne_sw;
		int32_t sand_beige_ramp_with_wall_nw_ne_se;
		int32_t sand_beige_ramp_with_wall_nw_sw_se;
		int32_t sand_beige_ramp_with_wall_ne_sw_se;

		int32_t sand_black_ramp_with_wall_nsew;
		int32_t sand_black_ramp_with_wall_nse;
		int32_t sand_black_ramp_with_wall_nsw;
		int32_t sand_black_ramp_with_wall_nwe;
		int32_t sand_black_ramp_with_wall_swe;
		int32_t sand_black_ramp_with_wall_n_s;
		int32_t sand_black_ramp_with_wall_n_w;
		int32_t sand_black_ramp_with_wall_n_e;
		int32_t sand_black_ramp_with_wall_s_w;
		int32_t sand_black_ramp_with_wall_s_e;
		int32_t sand_black_ramp_with_wall_w_e;
		int32_t sand_black_ramp_with_wall_n;
		int32_t sand_black_ramp_with_wall_s;
		int32_t sand_black_ramp_with_wall_w;
		int32_t sand_black_ramp_with_wall_e;
		int32_t sand_black_ramp_with_wall_nw;
		int32_t sand_black_ramp_with_wall_sw;
		int32_t sand_black_ramp_with_wall_se;
		int32_t sand_black_ramp_with_wall_ne;
		int32_t sand_black_ramp_with_wall_nw_ne;
		int32_t sand_black_ramp_with_wall_sw_se;
		int32_t sand_black_ramp_with_wall_nw_sw;
		int32_t sand_black_ramp_with_wall_ne_se;
		int32_t sand_black_ramp_other;
		int32_t sand_black_ramp_with_wall_s_ne;
		int32_t sand_black_ramp_with_wall_w_se;
		int32_t sand_black_ramp_with_wall_n_sw;
		int32_t sand_black_ramp_with_wall_e_nw;
		int32_t sand_black_ramp_with_wall_e_sw;
		int32_t sand_black_ramp_with_wall_s_nw;
		int32_t sand_black_ramp_with_wall_w_ne;
		int32_t sand_black_ramp_with_wall_n_se;
		int32_t sand_black_ramp_with_wall_s_e_nw;
		int32_t sand_black_ramp_with_wall_s_w_ne;
		int32_t sand_black_ramp_with_wall_n_w_se;
		int32_t sand_black_ramp_with_wall_n_e_sw;
		int32_t sand_black_ramp_with_wall_n_sw_se;
		int32_t sand_black_ramp_with_wall_e_nw_sw;
		int32_t sand_black_ramp_with_wall_s_nw_ne;
		int32_t sand_black_ramp_with_wall_w_ne_se;
		int32_t sand_black_ramp_with_wall_nw_se;
		int32_t sand_black_ramp_with_wall_ne_sw;
		int32_t sand_black_ramp_with_wall_nw_ne_sw_se;
		int32_t sand_black_ramp_with_wall_nw_ne_sw;
		int32_t sand_black_ramp_with_wall_nw_ne_se;
		int32_t sand_black_ramp_with_wall_nw_sw_se;
		int32_t sand_black_ramp_with_wall_ne_sw_se;

		int32_t sand_red_ramp_with_wall_nsew;
		int32_t sand_red_ramp_with_wall_nse;
		int32_t sand_red_ramp_with_wall_nsw;
		int32_t sand_red_ramp_with_wall_nwe;
		int32_t sand_red_ramp_with_wall_swe;
		int32_t sand_red_ramp_with_wall_n_s;
		int32_t sand_red_ramp_with_wall_n_w;
		int32_t sand_red_ramp_with_wall_n_e;
		int32_t sand_red_ramp_with_wall_s_w;
		int32_t sand_red_ramp_with_wall_s_e;
		int32_t sand_red_ramp_with_wall_w_e;
		int32_t sand_red_ramp_with_wall_n;
		int32_t sand_red_ramp_with_wall_s;
		int32_t sand_red_ramp_with_wall_w;
		int32_t sand_red_ramp_with_wall_e;
		int32_t sand_red_ramp_with_wall_nw;
		int32_t sand_red_ramp_with_wall_sw;
		int32_t sand_red_ramp_with_wall_se;
		int32_t sand_red_ramp_with_wall_ne;
		int32_t sand_red_ramp_with_wall_nw_ne;
		int32_t sand_red_ramp_with_wall_sw_se;
		int32_t sand_red_ramp_with_wall_nw_sw;
		int32_t sand_red_ramp_with_wall_ne_se;
		int32_t sand_red_ramp_other;
		int32_t sand_red_ramp_with_wall_s_ne;
		int32_t sand_red_ramp_with_wall_w_se;
		int32_t sand_red_ramp_with_wall_n_sw;
		int32_t sand_red_ramp_with_wall_e_nw;
		int32_t sand_red_ramp_with_wall_e_sw;
		int32_t sand_red_ramp_with_wall_s_nw;
		int32_t sand_red_ramp_with_wall_w_ne;
		int32_t sand_red_ramp_with_wall_n_se;
		int32_t sand_red_ramp_with_wall_s_e_nw;
		int32_t sand_red_ramp_with_wall_s_w_ne;
		int32_t sand_red_ramp_with_wall_n_w_se;
		int32_t sand_red_ramp_with_wall_n_e_sw;
		int32_t sand_red_ramp_with_wall_n_sw_se;
		int32_t sand_red_ramp_with_wall_e_nw_sw;
		int32_t sand_red_ramp_with_wall_s_nw_ne;
		int32_t sand_red_ramp_with_wall_w_ne_se;
		int32_t sand_red_ramp_with_wall_nw_se;
		int32_t sand_red_ramp_with_wall_ne_sw;
		int32_t sand_red_ramp_with_wall_nw_ne_sw_se;
		int32_t sand_red_ramp_with_wall_nw_ne_sw;
		int32_t sand_red_ramp_with_wall_nw_ne_se;
		int32_t sand_red_ramp_with_wall_nw_sw_se;
		int32_t sand_red_ramp_with_wall_ne_sw_se;

		int32_t sand_tan_ramp_with_wall_nsew;
		int32_t sand_tan_ramp_with_wall_nse;
		int32_t sand_tan_ramp_with_wall_nsw;
		int32_t sand_tan_ramp_with_wall_nwe;
		int32_t sand_tan_ramp_with_wall_swe;
		int32_t sand_tan_ramp_with_wall_n_s;
		int32_t sand_tan_ramp_with_wall_n_w;
		int32_t sand_tan_ramp_with_wall_n_e;
		int32_t sand_tan_ramp_with_wall_s_w;
		int32_t sand_tan_ramp_with_wall_s_e;
		int32_t sand_tan_ramp_with_wall_w_e;
		int32_t sand_tan_ramp_with_wall_n;
		int32_t sand_tan_ramp_with_wall_s;
		int32_t sand_tan_ramp_with_wall_w;
		int32_t sand_tan_ramp_with_wall_e;
		int32_t sand_tan_ramp_with_wall_nw;
		int32_t sand_tan_ramp_with_wall_sw;
		int32_t sand_tan_ramp_with_wall_se;
		int32_t sand_tan_ramp_with_wall_ne;
		int32_t sand_tan_ramp_with_wall_nw_ne;
		int32_t sand_tan_ramp_with_wall_sw_se;
		int32_t sand_tan_ramp_with_wall_nw_sw;
		int32_t sand_tan_ramp_with_wall_ne_se;
		int32_t sand_tan_ramp_other;
		int32_t sand_tan_ramp_with_wall_s_ne;
		int32_t sand_tan_ramp_with_wall_w_se;
		int32_t sand_tan_ramp_with_wall_n_sw;
		int32_t sand_tan_ramp_with_wall_e_nw;
		int32_t sand_tan_ramp_with_wall_e_sw;
		int32_t sand_tan_ramp_with_wall_s_nw;
		int32_t sand_tan_ramp_with_wall_w_ne;
		int32_t sand_tan_ramp_with_wall_n_se;
		int32_t sand_tan_ramp_with_wall_s_e_nw;
		int32_t sand_tan_ramp_with_wall_s_w_ne;
		int32_t sand_tan_ramp_with_wall_n_w_se;
		int32_t sand_tan_ramp_with_wall_n_e_sw;
		int32_t sand_tan_ramp_with_wall_n_sw_se;
		int32_t sand_tan_ramp_with_wall_e_nw_sw;
		int32_t sand_tan_ramp_with_wall_s_nw_ne;
		int32_t sand_tan_ramp_with_wall_w_ne_se;
		int32_t sand_tan_ramp_with_wall_nw_se;
		int32_t sand_tan_ramp_with_wall_ne_sw;
		int32_t sand_tan_ramp_with_wall_nw_ne_sw_se;
		int32_t sand_tan_ramp_with_wall_nw_ne_sw;
		int32_t sand_tan_ramp_with_wall_nw_ne_se;
		int32_t sand_tan_ramp_with_wall_nw_sw_se;
		int32_t sand_tan_ramp_with_wall_ne_sw_se;

		int32_t sand_white_ramp_with_wall_nsew;
		int32_t sand_white_ramp_with_wall_nse;
		int32_t sand_white_ramp_with_wall_nsw;
		int32_t sand_white_ramp_with_wall_nwe;
		int32_t sand_white_ramp_with_wall_swe;
		int32_t sand_white_ramp_with_wall_n_s;
		int32_t sand_white_ramp_with_wall_n_w;
		int32_t sand_white_ramp_with_wall_n_e;
		int32_t sand_white_ramp_with_wall_s_w;
		int32_t sand_white_ramp_with_wall_s_e;
		int32_t sand_white_ramp_with_wall_w_e;
		int32_t sand_white_ramp_with_wall_n;
		int32_t sand_white_ramp_with_wall_s;
		int32_t sand_white_ramp_with_wall_w;
		int32_t sand_white_ramp_with_wall_e;
		int32_t sand_white_ramp_with_wall_nw;
		int32_t sand_white_ramp_with_wall_sw;
		int32_t sand_white_ramp_with_wall_se;
		int32_t sand_white_ramp_with_wall_ne;
		int32_t sand_white_ramp_with_wall_nw_ne;
		int32_t sand_white_ramp_with_wall_sw_se;
		int32_t sand_white_ramp_with_wall_nw_sw;
		int32_t sand_white_ramp_with_wall_ne_se;
		int32_t sand_white_ramp_other;
		int32_t sand_white_ramp_with_wall_s_ne;
		int32_t sand_white_ramp_with_wall_w_se;
		int32_t sand_white_ramp_with_wall_n_sw;
		int32_t sand_white_ramp_with_wall_e_nw;
		int32_t sand_white_ramp_with_wall_e_sw;
		int32_t sand_white_ramp_with_wall_s_nw;
		int32_t sand_white_ramp_with_wall_w_ne;
		int32_t sand_white_ramp_with_wall_n_se;
		int32_t sand_white_ramp_with_wall_s_e_nw;
		int32_t sand_white_ramp_with_wall_s_w_ne;
		int32_t sand_white_ramp_with_wall_n_w_se;
		int32_t sand_white_ramp_with_wall_n_e_sw;
		int32_t sand_white_ramp_with_wall_n_sw_se;
		int32_t sand_white_ramp_with_wall_e_nw_sw;
		int32_t sand_white_ramp_with_wall_s_nw_ne;
		int32_t sand_white_ramp_with_wall_w_ne_se;
		int32_t sand_white_ramp_with_wall_nw_se;
		int32_t sand_white_ramp_with_wall_ne_sw;
		int32_t sand_white_ramp_with_wall_nw_ne_sw_se;
		int32_t sand_white_ramp_with_wall_nw_ne_sw;
		int32_t sand_white_ramp_with_wall_nw_ne_se;
		int32_t sand_white_ramp_with_wall_nw_sw_se;
		int32_t sand_white_ramp_with_wall_ne_sw_se;

		int32_t sand_yellow_ramp_with_wall_nsew;
		int32_t sand_yellow_ramp_with_wall_nse;
		int32_t sand_yellow_ramp_with_wall_nsw;
		int32_t sand_yellow_ramp_with_wall_nwe;
		int32_t sand_yellow_ramp_with_wall_swe;
		int32_t sand_yellow_ramp_with_wall_n_s;
		int32_t sand_yellow_ramp_with_wall_n_w;
		int32_t sand_yellow_ramp_with_wall_n_e;
		int32_t sand_yellow_ramp_with_wall_s_w;
		int32_t sand_yellow_ramp_with_wall_s_e;
		int32_t sand_yellow_ramp_with_wall_w_e;
		int32_t sand_yellow_ramp_with_wall_n;
		int32_t sand_yellow_ramp_with_wall_s;
		int32_t sand_yellow_ramp_with_wall_w;
		int32_t sand_yellow_ramp_with_wall_e;
		int32_t sand_yellow_ramp_with_wall_nw;
		int32_t sand_yellow_ramp_with_wall_sw;
		int32_t sand_yellow_ramp_with_wall_se;
		int32_t sand_yellow_ramp_with_wall_ne;
		int32_t sand_yellow_ramp_with_wall_nw_ne;
		int32_t sand_yellow_ramp_with_wall_sw_se;
		int32_t sand_yellow_ramp_with_wall_nw_sw;
		int32_t sand_yellow_ramp_with_wall_ne_se;
		int32_t sand_yellow_ramp_other;
		int32_t sand_yellow_ramp_with_wall_s_ne;
		int32_t sand_yellow_ramp_with_wall_w_se;
		int32_t sand_yellow_ramp_with_wall_n_sw;
		int32_t sand_yellow_ramp_with_wall_e_nw;
		int32_t sand_yellow_ramp_with_wall_e_sw;
		int32_t sand_yellow_ramp_with_wall_s_nw;
		int32_t sand_yellow_ramp_with_wall_w_ne;
		int32_t sand_yellow_ramp_with_wall_n_se;
		int32_t sand_yellow_ramp_with_wall_s_e_nw;
		int32_t sand_yellow_ramp_with_wall_s_w_ne;
		int32_t sand_yellow_ramp_with_wall_n_w_se;
		int32_t sand_yellow_ramp_with_wall_n_e_sw;
		int32_t sand_yellow_ramp_with_wall_n_sw_se;
		int32_t sand_yellow_ramp_with_wall_e_nw_sw;
		int32_t sand_yellow_ramp_with_wall_s_nw_ne;
		int32_t sand_yellow_ramp_with_wall_w_ne_se;
		int32_t sand_yellow_ramp_with_wall_nw_se;
		int32_t sand_yellow_ramp_with_wall_ne_sw;
		int32_t sand_yellow_ramp_with_wall_nw_ne_sw_se;
		int32_t sand_yellow_ramp_with_wall_nw_ne_sw;
		int32_t sand_yellow_ramp_with_wall_nw_ne_se;
		int32_t sand_yellow_ramp_with_wall_nw_sw_se;
		int32_t sand_yellow_ramp_with_wall_ne_sw_se;

		int32_t stone_ramp_with_wall_nsew;
		int32_t stone_ramp_with_wall_nse;
		int32_t stone_ramp_with_wall_nsw;
		int32_t stone_ramp_with_wall_nwe;
		int32_t stone_ramp_with_wall_swe;
		int32_t stone_ramp_with_wall_n_s;
		int32_t stone_ramp_with_wall_n_w;
		int32_t stone_ramp_with_wall_n_e;
		int32_t stone_ramp_with_wall_s_w;
		int32_t stone_ramp_with_wall_s_e;
		int32_t stone_ramp_with_wall_w_e;
		int32_t stone_ramp_with_wall_n;
		int32_t stone_ramp_with_wall_s;
		int32_t stone_ramp_with_wall_w;
		int32_t stone_ramp_with_wall_e;
		int32_t stone_ramp_with_wall_nw;
		int32_t stone_ramp_with_wall_sw;
		int32_t stone_ramp_with_wall_se;
		int32_t stone_ramp_with_wall_ne;
		int32_t stone_ramp_with_wall_nw_ne;
		int32_t stone_ramp_with_wall_sw_se;
		int32_t stone_ramp_with_wall_nw_sw;
		int32_t stone_ramp_with_wall_ne_se;
		int32_t stone_ramp_other;
		int32_t stone_ramp_with_wall_s_ne;
		int32_t stone_ramp_with_wall_w_se;
		int32_t stone_ramp_with_wall_n_sw;
		int32_t stone_ramp_with_wall_e_nw;
		int32_t stone_ramp_with_wall_e_sw;
		int32_t stone_ramp_with_wall_s_nw;
		int32_t stone_ramp_with_wall_w_ne;
		int32_t stone_ramp_with_wall_n_se;
		int32_t stone_ramp_with_wall_s_e_nw;
		int32_t stone_ramp_with_wall_s_w_ne;
		int32_t stone_ramp_with_wall_n_w_se;
		int32_t stone_ramp_with_wall_n_e_sw;
		int32_t stone_ramp_with_wall_n_sw_se;
		int32_t stone_ramp_with_wall_e_nw_sw;
		int32_t stone_ramp_with_wall_s_nw_ne;
		int32_t stone_ramp_with_wall_w_ne_se;
		int32_t stone_ramp_with_wall_nw_se;
		int32_t stone_ramp_with_wall_ne_sw;
		int32_t stone_ramp_with_wall_nw_ne_sw_se;
		int32_t stone_ramp_with_wall_nw_ne_sw;
		int32_t stone_ramp_with_wall_nw_ne_se;
		int32_t stone_ramp_with_wall_nw_sw_se;
		int32_t stone_ramp_with_wall_ne_sw_se;

		int32_t texpos_item_branch;
		int32_t texpos_item_wood;
		int32_t texpos_item_rough_gem;
		int32_t texpos_item_rough_gem_value_2;
		int32_t texpos_item_rough_gem_value_3;
		int32_t texpos_item_rough_gem_value_5;
		int32_t texpos_item_rough_gem_value_10;
		int32_t texpos_item_rough_gem_value_15;
		int32_t texpos_item_rough_gem_value_20;
		int32_t texpos_item_rough_gem_value_25;
		int32_t texpos_item_rough_gem_value_30;
		int32_t texpos_item_rough_gem_value_40;
		int32_t texpos_item_rough_gem_value_60;
		int32_t texpos_item_boulder;
		int32_t texpos_item_rock;
		int32_t texpos_item_bars;
			int32_t texpos_item_bars_soap;
		int32_t texpos_item_gems;
		int32_t texpos_item_gem;
		int32_t texpos_item_blocks;
		int32_t texpos_item_hatch_cover_stone;
		int32_t texpos_item_hatch_cover_stone_open;
		int32_t texpos_item_hatch_cover_wooden;
		int32_t texpos_item_hatch_cover_wooden_open;
		int32_t texpos_item_hatch_cover_metal;
		int32_t texpos_item_hatch_cover_metal_open;
		int32_t texpos_item_hatch_cover_glass;
		int32_t texpos_item_hatch_cover_glass_open;
			int32_t texpos_item_hatch_cover_wood_closed[7];
			int32_t texpos_item_hatch_cover_stone_closed[7];
			int32_t texpos_item_hatch_cover_metal_closed[7];
			int32_t texpos_item_hatch_cover_glass_closed[7];
			int32_t texpos_item_hatch_cover_variant[4];
			int32_t texpos_item_hatch_cover_spikes;
			int32_t texpos_item_hatch_cover_rings;
			int32_t texpos_item_hatch_cover_studs;
			int32_t texpos_item_hatch_cover_engraving;
			int32_t texpos_item_hatch_cover_damage[3];
			int32_t texpos_item_hatch_cover_bands;
			int32_t texpos_item_hatch_cover_blood;
			int32_t texpos_item_hatch_cover_vomit;
			int32_t texpos_item_hatch_cover_water;
			int32_t texpos_item_hatch_cover_mud;
			int32_t texpos_item_hatch_cover_forbidden;
		int32_t texpos_item_grate;
		int32_t texpos_item_floodgate_stone;
		int32_t texpos_item_floodgate_stone_open;
		int32_t texpos_item_floodgate_wooden;
		int32_t texpos_item_floodgate_wooden_open;
		int32_t texpos_item_floodgate_metal;
		int32_t texpos_item_floodgate_metal_open;
		int32_t texpos_item_floodgate_glass;
		int32_t texpos_item_floodgate_glass_open;
			int32_t texpos_item_floodgate_wood_closed[7];
			int32_t texpos_item_floodgate_stone_closed[7];
			int32_t texpos_item_floodgate_metal_closed[7];
			int32_t texpos_item_floodgate_glass_closed[7];
			int32_t texpos_item_floodgate_variant[4];
			int32_t texpos_item_floodgate_spikes;
			int32_t texpos_item_floodgate_rings;
			int32_t texpos_item_floodgate_studs;
			int32_t texpos_item_floodgate_engraving;
			int32_t texpos_item_floodgate_damage[3];
			int32_t texpos_item_floodgate_bands;
			int32_t texpos_item_floodgate_blood;
			int32_t texpos_item_floodgate_vomit;
			int32_t texpos_item_floodgate_water;
			int32_t texpos_item_floodgate_mud;
		int32_t texpos_item_door_stone;
		int32_t texpos_item_door_stone_open;
		int32_t texpos_item_door_wooden;
		int32_t texpos_item_door_wooden_open;
		int32_t texpos_item_door_metal;
		int32_t texpos_item_door_metal_open;
		int32_t texpos_item_door_glass;
		int32_t texpos_item_door_glass_open;
		int32_t texpos_item_door_stone_open_damaged[3];
		int32_t texpos_item_door_wooden_open_damaged[3];
		int32_t texpos_item_door_metal_open_damaged[3];
		int32_t texpos_item_door_glass_open_damaged[3];
			int32_t texpos_item_door_wood_closed[7];
			int32_t texpos_item_door_stone_closed[7];
			int32_t texpos_item_door_metal_closed[7];
			int32_t texpos_item_door_glass_closed[7];
			int32_t texpos_item_door_variant[4];
			int32_t texpos_item_door_wood_closed_damaged[7][3];
			int32_t texpos_item_door_stone_closed_damaged[7][3];
			int32_t texpos_item_door_metal_closed_damaged[7][3];
			int32_t texpos_item_door_glass_closed_damaged[7][3];
			int32_t texpos_item_door_variant_damaged[4][3];
			int32_t texpos_item_door_spikes;
			int32_t texpos_item_door_rings;
			int32_t texpos_item_door_studs;
			int32_t texpos_item_door_engraving;
			int32_t texpos_item_door_bands;
			int32_t texpos_item_door_blood;
			int32_t texpos_item_door_vomit;
			int32_t texpos_item_door_water;
			int32_t texpos_item_door_mud;
			int32_t texpos_item_door_forbidden;
		svector<int32_t> texpos_item_door_stone_debris;
		svector<int32_t> texpos_item_door_wooden_debris;
		svector<int32_t> texpos_item_door_metal_debris;
		svector<int32_t> texpos_item_door_glass_debris;

		int32_t texpos_item_grate_stone;
		int32_t texpos_item_grate_wooden;
		int32_t texpos_item_grate_metal;
		int32_t texpos_item_grate_glass;
		int32_t texpos_item_grate_stone_wall_closed;
		int32_t texpos_item_grate_wooden_wall_closed;
		int32_t texpos_item_grate_metal_wall_closed;
		int32_t texpos_item_grate_glass_wall_closed;
		int32_t texpos_item_grate_stone_wall_open;
		int32_t texpos_item_grate_wooden_wall_open;
		int32_t texpos_item_grate_metal_wall_open;
		int32_t texpos_item_grate_glass_wall_open;
		int32_t texpos_item_grate_stone_floor_closed;
		int32_t texpos_item_grate_wooden_floor_closed;
		int32_t texpos_item_grate_metal_floor_closed;
		int32_t texpos_item_grate_glass_floor_closed;
		int32_t texpos_item_grate_stone_floor_open;
		int32_t texpos_item_grate_wooden_floor_open;
		int32_t texpos_item_grate_metal_floor_open;
		int32_t texpos_item_grate_glass_floor_open;

		int32_t texpos_item_chain_metal;
		int32_t texpos_item_chain_rope;
		int32_t texpos_item_flask_metal;
		int32_t texpos_item_flask_leather;
		int32_t texpos_item_flask_glass;
		int32_t texpos_item_goblet_metal;
		int32_t texpos_item_goblet_stone;
		int32_t texpos_item_goblet_wood;
		int32_t texpos_item_goblet_metal_encrusted;
		int32_t texpos_item_goblet_stone_encrusted;
		int32_t texpos_item_goblet_wood_encrusted;
		int32_t texpos_item_instrument_keyboard_building;
		int32_t texpos_item_instrument_stringed_building;
		int32_t texpos_item_instrument_wind_building;
		int32_t texpos_item_instrument_percussion_building;
		int32_t texpos_item_instrument_keyboard_handheld;
		int32_t texpos_item_instrument_stringed_handheld;
		int32_t texpos_item_instrument_wind_handheld;
		int32_t texpos_item_instrument_percussion_handheld;
		int32_t texpos_item_toy;
		int32_t texpos_item_tool;
		int32_t texpos_item_generated_tool;
		int32_t texpos_item_window_glass;
		int32_t texpos_item_window_gem;
		int32_t texpos_item_cage_wood;
		int32_t texpos_item_cage_metal;
		int32_t texpos_item_cage_glass;
		int32_t texpos_item_cage_wood_occupied;
		int32_t texpos_item_cage_metal_occupied;
		int32_t texpos_item_cage_glass_occupied;

		int32_t texpos_item_barrel_wood;
		int32_t texpos_item_barrel_metal;
		int32_t texpos_item_barrel_wood_empty;
		int32_t texpos_item_barrel_metal_empty;
		int32_t texpos_item_barrel_wood_liquid;
		int32_t texpos_liquid_for_barrel_wood;
		int32_t texpos_item_barrel_metal_liquid;
		int32_t texpos_liquid_for_barrel_metal;
		int32_t texpos_item_barrel_wood_item;
		int32_t texpos_item_barrel_metal_item;
		svector<int32_t> texpos_item_barrel_top_plant;
		svector<int32_t> texpos_item_barrel_top_plant_subterranean;
		svector<int32_t> texpos_item_barrel_top_meal;
		svector<int32_t> texpos_item_barrel_top_cheese;
		svector<int32_t> texpos_item_barrel_top_meat;
		svector<int32_t> texpos_item_barrel_top_fish;
		svector<int32_t> texpos_item_barrel_top_bag;

		int32_t texpos_food_container_top_liquid;
		int32_t texpos_food_container_top_bag;
		int32_t texpos_food_container_top_fish[4];
		int32_t texpos_food_container_top_meat[4];

		int32_t texpos_item_bucket;
		int32_t texpos_item_bucket_wood;
		int32_t texpos_liquid_for_bucket_wood;
		int32_t texpos_item_bucket_metal;
		int32_t texpos_liquid_for_bucket_metal;

		int32_t texpos_item_animal_trap_wood;
		int32_t texpos_item_animal_trap_metal;
		int32_t texpos_item_animal_trap_wood_occupied;
		int32_t texpos_item_animal_trap_metal_occupied;
		int32_t texpos_item_chair;
			int32_t texpos_item_chair_wood[7];
			int32_t texpos_item_chair_stone[7];
			int32_t texpos_item_chair_metal[7];
			int32_t texpos_item_chair_glass[7];
			int32_t texpos_item_chair_leg[4];
			int32_t texpos_item_chair_spikes;
			int32_t texpos_item_chair_rings;
			int32_t texpos_item_chair_studs;
			int32_t texpos_item_chair_engraving;
			int32_t texpos_item_chair_damage[3];
			int32_t texpos_item_chair_bands;
			int32_t texpos_item_chair_blood;
			int32_t texpos_item_chair_vomit;
			int32_t texpos_item_chair_water;
			int32_t texpos_item_chair_mud;
		int32_t texpos_item_coffin;
			int32_t texpos_item_coffin_wood;
			int32_t texpos_item_coffin_stone;
			int32_t texpos_item_coffin_metal;
			int32_t texpos_item_coffin_glass;
			int32_t texpos_item_coffin_wood_unused;
			int32_t texpos_item_coffin_stone_unused;
			int32_t texpos_item_coffin_metal_unused;
			int32_t texpos_item_coffin_glass_unused;
		int32_t texpos_item_table;
			int32_t texpos_item_table_wood[7];
			int32_t texpos_item_table_stone[7];
			int32_t texpos_item_table_metal[7];
			int32_t texpos_item_table_glass[7];
			int32_t texpos_item_table_leg[4];
			int32_t texpos_item_table_spikes;
			int32_t texpos_item_table_rings;
			int32_t texpos_item_table_studs;
			int32_t texpos_item_table_engraving;
			int32_t texpos_item_table_damage[3];
			int32_t texpos_item_table_bands;
			int32_t texpos_item_table_blood;
			int32_t texpos_item_table_vomit;
			int32_t texpos_item_table_water;
			int32_t texpos_item_table_mud;
		int32_t texpos_item_backpack;
		int32_t texpos_item_quiver;
		int32_t texpos_item_splint;
		int32_t texpos_item_orthopedic_cast;
		int32_t texpos_item_crutch;
		int32_t texpos_item_bin;
			int32_t texpos_item_bin_wood_empty;
			int32_t texpos_item_bin_metal_empty;
			int32_t texpos_item_bin_wood_in_use;
			int32_t texpos_item_bin_metal_in_use;
			svector<int32_t> texpos_item_bin_top_ammo;
			svector<int32_t> texpos_item_bin_top_cloth;
			svector<int32_t> texpos_item_bin_top_clothing;
			svector<int32_t> texpos_item_bin_top_armor_leather;
			svector<int32_t> texpos_item_bin_top_armor_metal;
			svector<int32_t> texpos_item_bin_top_bars;
			svector<int32_t> texpos_item_bin_top_blocks;
			svector<int32_t> texpos_item_bin_top_coal;
			svector<int32_t> texpos_item_bin_top_powders;
			svector<int32_t> texpos_item_bin_top_coins;
			svector<int32_t> texpos_item_bin_top_gems;
			svector<int32_t> texpos_item_bin_top_mechanisms;
			svector<int32_t> texpos_item_bin_top_bags;
			svector<int32_t> texpos_item_bin_top_books;
			svector<int32_t> texpos_item_bin_top_sheets;
			svector<int32_t> texpos_item_bin_top_chains;
			svector<int32_t> texpos_item_bin_top_ropes;
			svector<int32_t> texpos_item_bin_top_leather;
			svector<int32_t> texpos_item_bin_top_weapons;
			svector<int32_t> texpos_item_bin_top_trap_comps;
			svector<int32_t> texpos_item_bin_top_crafts;
		int32_t texpos_item_bag;
			int32_t texpos_item_bag_empty;
			int32_t texpos_item_bag_in_use;
			int32_t texpos_powder_for_bag;
			int32_t texpos_leaves_for_bag;
			int32_t texpos_seeds_for_bag;
		int32_t texpos_item_box;
			int32_t texpos_item_box_wood[7];
			int32_t texpos_item_box_stone[7];
			int32_t texpos_item_box_metal[7];
			int32_t texpos_item_box_glass[7];
			int32_t texpos_item_box_variant[4];
			int32_t texpos_item_box_spikes;
			int32_t texpos_item_box_rings;
			int32_t texpos_item_box_studs;
			int32_t texpos_item_box_engraving;
			int32_t texpos_item_box_damage[3];
			int32_t texpos_item_box_bands;
			int32_t texpos_item_box_blood;
			int32_t texpos_item_box_vomit;
			int32_t texpos_item_box_water;
			int32_t texpos_item_box_mud;
		int32_t texpos_item_weapon_rack_wood_empty;
		int32_t texpos_item_weapon_rack_stone_empty;
		int32_t texpos_item_weapon_rack_metal_empty;
		int32_t texpos_item_weapon_rack_wood_full;
		int32_t texpos_item_weapon_rack_stone_full;
		int32_t texpos_item_weapon_rack_metal_full;
		int32_t texpos_item_armor_stand_wood_empty;
		int32_t texpos_item_armor_stand_stone_empty;
		int32_t texpos_item_armor_stand_metal_empty;
		int32_t texpos_item_armor_stand_wood_full;
		int32_t texpos_item_armor_stand_stone_full;
		int32_t texpos_item_armor_stand_metal_full;
		int32_t texpos_item_cabinet;
			int32_t texpos_item_cabinet_wood[7];
			int32_t texpos_item_cabinet_stone[7];
			int32_t texpos_item_cabinet_metal[7];
			int32_t texpos_item_cabinet_glass[7];
			int32_t texpos_item_cabinet_variant[4];
			int32_t texpos_item_cabinet_spikes;
			int32_t texpos_item_cabinet_rings;
			int32_t texpos_item_cabinet_studs;
			int32_t texpos_item_cabinet_engraving;
			int32_t texpos_item_cabinet_damage[3];
			int32_t texpos_item_cabinet_bands;
			int32_t texpos_item_cabinet_blood;
			int32_t texpos_item_cabinet_vomit;
			int32_t texpos_item_cabinet_water;
			int32_t texpos_item_cabinet_mud;
		int32_t texpos_item_weapon;
		int32_t texpos_item_pants;
		int32_t texpos_item_helm;
		int32_t texpos_item_gloves;
		int32_t texpos_item_shoes;
		int32_t texpos_item_shield;
		int32_t texpos_item_armor;
		int32_t texpos_item_web_harmless[4];
		int32_t texpos_item_web_thick[4];
		int32_t texpos_item_thread;
		int32_t texpos_item_cloth;
		int32_t texpos_item_sheet;
		int32_t texpos_item_tanned_skin;
			int32_t texpos_item_tanned_skin_bicolor;
			int32_t texpos_item_tanned_skin_stripes;
			int32_t texpos_item_tanned_skin_spots;
			int32_t texpos_item_tanned_skin_mottled;
		int32_t texpos_item_totem;
		int32_t texpos_item_totem_encrusted;
		int32_t texpos_item_book_wood;
		int32_t texpos_item_book_metal;
		int32_t texpos_item_book_stone;
		int32_t texpos_item_book_glass;
		int32_t texpos_item_liquid;
		int32_t texpos_item_powder;
		int32_t texpos_item_mechanisms;
		int32_t texpos_item_pipe_section;
		int32_t texpos_item_trap_component;
		int32_t texpos_item_catapult_parts;
		int32_t texpos_item_ballista_parts;
		int32_t texpos_item_bolt_thrower_parts;
		int32_t texpos_item_anvil;
		int32_t texpos_item_ammo;
		int32_t texpos_item_ballista_arrowhead;
		int32_t texpos_item_ballista_arrow;
		int32_t texpos_item_coins_single;
		int32_t texpos_item_coins_pile_1;
		int32_t texpos_item_coins_pile_2;
		int32_t texpos_item_coins_pile_3;
		int32_t texpos_item_coins_pile_4;

		int32_t texpos_item_figurine_metal;
		int32_t texpos_item_amulet_metal;
		int32_t texpos_item_scepter_metal;
		int32_t texpos_item_crown_metal;
		int32_t texpos_item_ring_metal;
		int32_t texpos_item_bracelet_metal;
		int32_t texpos_item_earring_metal;
		int32_t texpos_item_figurine_wood;
		int32_t texpos_item_amulet_wood;
		int32_t texpos_item_scepter_wood;
		int32_t texpos_item_crown_wood;
		int32_t texpos_item_ring_wood;
		int32_t texpos_item_bracelet_wood;
		int32_t texpos_item_earring_wood;
		int32_t texpos_item_figurine_metal_encrusted;
		int32_t texpos_item_amulet_metal_encrusted;
		int32_t texpos_item_scepter_metal_encrusted;
		int32_t texpos_item_crown_metal_encrusted;
		int32_t texpos_item_ring_metal_encrusted;
		int32_t texpos_item_bracelet_metal_encrusted;
		int32_t texpos_item_earring_metal_encrusted;
		int32_t texpos_item_figurine_wood_encrusted;
		int32_t texpos_item_amulet_wood_encrusted;
		int32_t texpos_item_scepter_wood_encrusted;
		int32_t texpos_item_crown_wood_encrusted;
		int32_t texpos_item_ring_wood_encrusted;
		int32_t texpos_item_bracelet_wood_encrusted;
		int32_t texpos_item_earring_wood_encrusted;

		int32_t texpos_item_bed;
			int32_t texpos_item_bed_wood[7];
			int32_t texpos_item_bed_stone[7];
			int32_t texpos_item_bed_metal[7];
			int32_t texpos_item_bed_glass[7];
			int32_t texpos_item_bed_sheet_variant[2];
			int32_t texpos_item_bed_pillow_variant[3];
			int32_t texpos_item_bed_spikes;
			int32_t texpos_item_bed_rings;
			int32_t texpos_item_bed_studs;
			int32_t texpos_item_bed_engraving;
			int32_t texpos_item_bed_damage[3];
			int32_t texpos_item_bed_bands;
			int32_t texpos_item_bed_blood;
			int32_t texpos_item_bed_vomit;
			int32_t texpos_item_bed_water;
			int32_t texpos_item_bed_mud;
		int32_t texpos_item_traction_bench_stone_chain;
		int32_t texpos_item_traction_bench_stone_rope;
		int32_t texpos_item_traction_bench_wooden_chain;
		int32_t texpos_item_traction_bench_wooden_rope;
		int32_t texpos_item_traction_bench_metal_chain;
		int32_t texpos_item_traction_bench_metal_rope;
		int32_t texpos_item_traction_bench_glass_chain;
		int32_t texpos_item_traction_bench_glass_rope;
		int32_t texpos_item_remains;
		int32_t texpos_item_seeds;
		int32_t texpos_item_plant_growth;
		int32_t texpos_item_rotten_plant;
		int32_t texpos_item_plant;
		int32_t texpos_item_vermin;
		int32_t texpos_item_fish;
		int32_t texpos_item_egg_size1;
		int32_t texpos_item_egg_size2;
		int32_t texpos_item_egg_size3;
		int32_t texpos_item_egg_size4;
		int32_t texpos_item_meat;
		int32_t texpos_item_prepared_meal;
		int32_t texpos_item_cheese;
		int32_t texpos_item_corpse_chunk;
		int32_t texpos_item_corpse;
		int32_t texpos_item_statue;
		int32_t texpos_item_default_statue_top;
		int32_t texpos_item_default_statue_bottom;
		int32_t texpos_item_slab_blank;
		int32_t texpos_item_slab_engraved[ENGRAVING_INTENTNUM];
		int32_t texpos_item_quern;
		int32_t texpos_item_millstone;
		int32_t texpos_item_mythical_remnant_default;
		int32_t texpos_item_mythical_remnant[SPHERENUM];

		int32_t texpos_skeleton;

		int32_t texpos_item_statue_item;
		int32_t texpos_item_statue_wood[7];
		int32_t texpos_item_statue_stone[7];
		int32_t texpos_item_statue_metal[7];
		int32_t texpos_item_statue_glass[7];
		int32_t texpos_item_statue_spikes;
		int32_t texpos_item_statue_rings;
		int32_t texpos_item_statue_studs;
		int32_t texpos_item_statue_engraving;
		int32_t texpos_item_statue_damage[3];
		int32_t texpos_item_statue_bands;
		int32_t texpos_item_statue_blood;
		int32_t texpos_item_statue_vomit;
		int32_t texpos_item_statue_water;
		int32_t texpos_item_statue_mud;
		svector<int32_t> texpos_item_statue_artifact;
		int32_t texpos_item_statue_generic_event[2];
		int32_t texpos_item_statue_generic_shape[2];
		int32_t texpos_item_statue_generic_duel[2];
		int32_t texpos_item_statue_generic_triumph[2];
		int32_t texpos_item_statue_generic_civilized[2];
		int32_t texpos_item_statue_generic_strike_down[2];
		int32_t texpos_item_statue_generic_shot[2];
		int32_t texpos_item_statue_generic_item_creation[2];
		int32_t texpos_item_statue_generic_tree[2];
		int32_t texpos_item_statue_generic_shrub[2];
		int32_t texpos_item_statue_generic_battle[2];
		int32_t texpos_item_statue_generic_site[2];

		int32_t texpos_item_bodypart_fat;
		int32_t texpos_item_bodypart_eye;
		int32_t texpos_item_bodypart_cartilage;
		int32_t texpos_item_bodypart_lung;
		int32_t texpos_item_bodypart_heart;
		int32_t texpos_item_bodypart_intestines;
		int32_t texpos_item_bodypart_liver;
		int32_t texpos_item_bodypart_tripe;
		int32_t texpos_item_bodypart_sweetbread;
		int32_t texpos_item_bodypart_spleen;
		int32_t texpos_item_bodypart_kidney;
		int32_t texpos_item_bodypart_hair;
		int32_t texpos_item_bodypart_nervous_tissue;
		int32_t texpos_item_bodypart_brain;
		int32_t texpos_item_bodypart_skull_1;
		int32_t texpos_item_bodypart_skull_2;
		int32_t texpos_item_bodypart_skin[TEXTURE_BODYPART_SKIN_SURFACENUM];
			int32_t texpos_item_bodypart_skin_bicolor[TEXTURE_BODYPART_SKIN_SURFACENUM];
			int32_t texpos_item_bodypart_skin_stripes[TEXTURE_BODYPART_SKIN_SURFACENUM];
			int32_t texpos_item_bodypart_skin_spots[TEXTURE_BODYPART_SKIN_SURFACENUM];
			int32_t texpos_item_bodypart_skin_mottled[TEXTURE_BODYPART_SKIN_SURFACENUM];
		int32_t texpos_item_bodypart_meat;
		int32_t texpos_item_bodypart_horn;
		int32_t texpos_item_bodypart_hoof;
		int32_t texpos_item_bodypart_bone;
		int32_t texpos_item_bodypart_teeth;
		int32_t texpos_item_bodypart_large_1;
		int32_t texpos_item_bodypart_large_2;
		int32_t texpos_item_bodypart_large_3;
		int32_t texpos_item_bodypart_small_1;
		int32_t texpos_item_bodypart_small_2;
		int32_t texpos_item_bodypart_small_3;
		int32_t texpos_item_bodypart_shell;
		int32_t texpos_item_bodypart_scale;
		int32_t texpos_item_bodypart_chitin_1;
		int32_t texpos_item_bodypart_chitin_2;
		int32_t texpos_item_bodypart_wool;
		int32_t texpos_item_bodypart_antler;
		int32_t texpos_item_bodypart_gizzard;
		int32_t texpos_item_bodypart_gizzard_stone;

		int32_t texpos_bld_chain_metal[9][2];
		int32_t texpos_bld_chain_rope[9][2];
		int32_t texpos_planned_bld_chain_metal;
		int32_t texpos_planned_bld_chain_rope;

		int32_t texpos_natural_nest;

		int32_t texpos_bld_support_wood;
		int32_t texpos_bld_support_stone;
		int32_t texpos_bld_support_metal;
		int32_t texpos_bld_archery_target_stone;
		int32_t texpos_bld_archery_target_metal;
		int32_t texpos_bld_archery_target_wood;
		int32_t texpos_bld_well;
		int32_t texpos_bld_well_with_rope;
		int32_t texpos_bld_well_with_chain;
		int32_t texpos_bld_well_rope;
		int32_t texpos_bld_well_chain;
		int32_t texpos_bld_well_bucket_empty_chain;
		int32_t texpos_bld_well_bucket_empty_rope;
		int32_t texpos_bld_well_bucket_full_chain;
		int32_t texpos_bld_well_bucket_full_rope;
		int32_t texpos_bld_floor_bars;
		int32_t texpos_bld_paved_road;
		int32_t texpos_bld_dirt_road;
		int32_t texpos_planned_bld_archery_target_stone;
		int32_t texpos_planned_bld_archery_target_metal;
		int32_t texpos_planned_bld_archery_target_wood;
		int32_t texpos_planned_bld_well;
		int32_t texpos_planned_bld_floor_grate;
		int32_t texpos_planned_bld_wall_grate;
		int32_t texpos_planned_bld_floodgate_stone;
		int32_t texpos_planned_bld_floodgate_wooden;
		int32_t texpos_planned_bld_floodgate_metal;
		int32_t texpos_planned_bld_floodgate_glass;
		int32_t texpos_planned_bld_paved_road;
		int32_t texpos_planned_bld_dirt_road;

		int32_t texpos_bld_vertical_bars_w;
		int32_t texpos_bld_vertical_bars_e;
		int32_t texpos_bld_vertical_bars_n_signpost;
		int32_t texpos_bld_vertical_bars_n_back;
		int32_t texpos_bld_vertical_bars_s;
		int32_t texpos_bld_vertical_bars_we;
		int32_t texpos_bld_vertical_bars_nwe;
		int32_t texpos_bld_vertical_bars_nw;
		int32_t texpos_bld_vertical_bars_ne;
		int32_t texpos_bld_vertical_bars_sw;
		int32_t texpos_bld_vertical_bars_se;
		int32_t texpos_bld_vertical_bars_nsw;
		int32_t texpos_bld_vertical_bars_nse;
		int32_t texpos_bld_vertical_bars_swe;
		int32_t texpos_bld_vertical_bars_ns;

		int32_t texpos_bld_bridge_wood[TEXTURE_BRIDGENUM];
		int32_t texpos_bld_bridge_stone[TEXTURE_BRIDGENUM];
		int32_t texpos_bld_bridge_metal[TEXTURE_BRIDGENUM];
		int32_t texpos_bld_bridge_glass[TEXTURE_BRIDGENUM];
		int32_t texpos_planned_bld_bridge_wood[TEXTURE_BRIDGENUM];
		int32_t texpos_planned_bld_bridge_stone[TEXTURE_BRIDGENUM];
		int32_t texpos_planned_bld_bridge_metal[TEXTURE_BRIDGENUM];
		int32_t texpos_planned_bld_bridge_glass[TEXTURE_BRIDGENUM];

		int32_t texpos_vermin_swarm_large;
		int32_t texpos_vermin_swarm_medium;
		int32_t texpos_vermin_swarm_small;
		int32_t texpos_vermin_light_swarm_large;
		int32_t texpos_vermin_light_swarm_medium;
		int32_t texpos_vermin_light_swarm_small;
		int32_t texpos_vermin_light;

		int32_t texpos_planned_bld_cage;
		int32_t texpos_planned_bld_bag;
		int32_t texpos_planned_bld_box;
		int32_t texpos_planned_bld_cabinet;
		int32_t texpos_planned_bld_table;
		int32_t texpos_planned_bld_animal_trap;
		int32_t texpos_planned_bld_chair;
		int32_t texpos_planned_bld_bed;
		int32_t texpos_planned_bld_statue;
		int32_t texpos_planned_bld_slab;
		int32_t texpos_planned_bld_door_stone;
		int32_t texpos_planned_bld_door_wooden;
		int32_t texpos_planned_bld_door_metal;
		int32_t texpos_planned_bld_door_glass;
		int32_t texpos_planned_bld_hatch_cover;
		int32_t texpos_planned_bld_coffin_wooden;
		int32_t texpos_planned_bld_coffin_stone;
		int32_t texpos_planned_bld_coffin_metal;
		int32_t texpos_planned_bld_coffin_glass;
		int32_t texpos_planned_bld_traction_bench_stone_chain;
		int32_t texpos_planned_bld_traction_bench_stone_rope;
		int32_t texpos_planned_bld_traction_bench_wooden_chain;
		int32_t texpos_planned_bld_traction_bench_wooden_rope;
		int32_t texpos_planned_bld_traction_bench_metal_chain;
		int32_t texpos_planned_bld_traction_bench_metal_rope;
		int32_t texpos_planned_bld_traction_bench_glass_chain;
		int32_t texpos_planned_bld_traction_bench_glass_rope;

		int32_t texpos_lever_1;
		int32_t texpos_lever_2;
		int32_t texpos_planned_lever;

		int32_t texpos_trap_cage;
		int32_t texpos_trap_cage_top;
		int32_t texpos_trap_cage_delayed;
		int32_t texpos_trap_stone;
		int32_t texpos_trap_stone_top;
		int32_t texpos_trap_stone_delayed;
		int32_t texpos_trap_weapon;
		int32_t texpos_trap_weapon_delayed;
		int32_t texpos_trap_weapon_generic_pike;
		int32_t texpos_trap_weapon_generic_spear;
		int32_t texpos_trap_weapon_generic_whip;
		int32_t texpos_trap_weapon_generic_sword;
		int32_t texpos_trap_weapon_generic_axe;
		int32_t texpos_trap_weapon_generic_mace;
		int32_t texpos_trap_weapon_generic_hammer;
		int32_t texpos_trap_weapon_generic_dagger;
		int32_t texpos_trap_weapon_generic_crossbow;
		int32_t texpos_trap_weapon_generic_bow;
		int32_t texpos_trap_weapon_generic_blowgun;
		int32_t texpos_trap_plate;
		int32_t texpos_trap_plate_delayed;
		int32_t texpos_trap_plate_minecart;
		int32_t texpos_trap_plate_delayed_minecart;
		int32_t texpos_trap_plate_water;
		int32_t texpos_trap_plate_delayed_water;
		int32_t texpos_trap_plate_magma;
		int32_t texpos_trap_plate_delayed_magma;
		int32_t texpos_planned_trap_cage;
		int32_t texpos_planned_trap_stone;
		int32_t texpos_planned_trap_weapon;
		int32_t texpos_planned_trap_plate;
		int32_t texpos_upright_weapon_retracted[10];
		int32_t texpos_planned_upright_weapon;

		int32_t texpos_windmill_n[3][4][2];
		int32_t texpos_windmill_s[3][4][2];
		int32_t texpos_windmill_w[3][4][2];
		int32_t texpos_windmill_e[3][4][2];
		int32_t texpos_windmill_nw[3][4][2];
		int32_t texpos_windmill_ne[3][4][2];
		int32_t texpos_windmill_sw[3][4][2];
		int32_t texpos_windmill_se[3][4][2];
		int32_t texpos_water_wheel_ns[4][2];
		int32_t texpos_water_wheel_we[3][2][2];
		int32_t texpos_screwpump_n[2][2];
		int32_t texpos_screwpump_s[2][2];
		int32_t texpos_screwpump_w[2][2];
		int32_t texpos_screwpump_e[2][2];
		int32_t texpos_screwpump_axle[2];
		int32_t texpos_axle_horizontal_ns[2];
		int32_t texpos_axle_horizontal_we[2];
		int32_t texpos_axle_vertical[2];
		int32_t texpos_gear_assembly[2];
		int32_t texpos_axle_horizontal_ns_fittings[2];
		int32_t texpos_axle_horizontal_we_fittings[2];
		int32_t texpos_gear_assembly_axle_s[2];
		int32_t texpos_axle_vertical_fittings[2];
		int32_t texpos_planned_screwpump_n[2];
		int32_t texpos_planned_screwpump_s[2];
		int32_t texpos_planned_screwpump_w[2];
		int32_t texpos_planned_screwpump_e[2];
		int32_t texpos_planned_gear_assembly;

		int32_t texpos_debris[16][2];//this is an annoying one based on EGA colors w/ two variants

		int32_t texpos_farmplot;
		int32_t texpos_planned_farmplot;
		int32_t texpos_farmplot_planted;

		int32_t texpos_ballista_n[3][3];
		int32_t texpos_ballista_s[3][3];
		int32_t texpos_ballista_w[3][3];
		int32_t texpos_ballista_e[3][3];
		int32_t texpos_ballista_nw[3][3];
		int32_t texpos_ballista_ne[3][3];
		int32_t texpos_ballista_sw[3][3];
		int32_t texpos_ballista_se[3][3];
		int32_t texpos_ballista_n_firing[3][3];
		int32_t texpos_ballista_s_firing[3][3];
		int32_t texpos_ballista_w_firing[3][3];
		int32_t texpos_ballista_e_firing[3][3];
		int32_t texpos_ballista_nw_firing[3][3];
		int32_t texpos_ballista_ne_firing[3][3];
		int32_t texpos_ballista_sw_firing[3][3];
		int32_t texpos_ballista_se_firing[3][3];
		int32_t texpos_ballista_const[4][3][3];
		int32_t texpos_catapult_n[3][3];
		int32_t texpos_catapult_s[3][3];
		int32_t texpos_catapult_w[3][3];
		int32_t texpos_catapult_e[3][3];
		int32_t texpos_catapult_nw[3][3];
		int32_t texpos_catapult_ne[3][3];
		int32_t texpos_catapult_sw[3][3];
		int32_t texpos_catapult_se[3][3];
		int32_t texpos_catapult_n_firing[3][3];
		int32_t texpos_catapult_s_firing[3][3];
		int32_t texpos_catapult_w_firing[3][3];
		int32_t texpos_catapult_e_firing[3][3];
		int32_t texpos_catapult_nw_firing[3][3];
		int32_t texpos_catapult_ne_firing[3][3];
		int32_t texpos_catapult_sw_firing[3][3];
		int32_t texpos_catapult_se_firing[3][3];
		int32_t texpos_catapult_const[4][3][3];
		int32_t texpos_bolt_thrower_ready_n;
		int32_t texpos_bolt_thrower_ready_ne;
		int32_t texpos_bolt_thrower_ready_e;
		int32_t texpos_bolt_thrower_ready_se;
		int32_t texpos_bolt_thrower_ready_s;
		int32_t texpos_bolt_thrower_ready_sw;
		int32_t texpos_bolt_thrower_ready_w;
		int32_t texpos_bolt_thrower_ready_nw;
		int32_t texpos_bolt_thrower_firing_n;
		int32_t texpos_bolt_thrower_firing_ne;
		int32_t texpos_bolt_thrower_firing_e;
		int32_t texpos_bolt_thrower_firing_se;
		int32_t texpos_bolt_thrower_firing_s;
		int32_t texpos_bolt_thrower_firing_sw;
		int32_t texpos_bolt_thrower_firing_w;
		int32_t texpos_bolt_thrower_firing_nw;
		int32_t texpos_bolt_thrower_ammo_n[5];
		int32_t texpos_bolt_thrower_ammo_ne[5];
		int32_t texpos_bolt_thrower_ammo_e[5];
		int32_t texpos_bolt_thrower_ammo_se[5];
		int32_t texpos_bolt_thrower_ammo_s[5];
		int32_t texpos_bolt_thrower_ammo_sw[5];
		int32_t texpos_bolt_thrower_ammo_w[5];
		int32_t texpos_bolt_thrower_ammo_nw[5];

		int32_t texpos_flow_miasma[4];
		int32_t texpos_flow_dust[4];
		int32_t texpos_flow_water_mist[4];
		int32_t texpos_flow_lava_mist[4];
		int32_t texpos_flow_boiling[4];
		int32_t texpos_flow_vapor[4];
		int32_t texpos_flow_dragonfire[4];
		int32_t texpos_flow_fire[4];
		int32_t texpos_flow_smoke[4];
		int32_t texpos_flow_item[4];

		int32_t wall_shadow_straight_n;//default
		int32_t wall_shadow_straight_s;
		int32_t wall_shadow_straight_w;
		int32_t wall_shadow_straight_e;
		int32_t wall_shadow_near_n_open_nw;
		int32_t wall_shadow_near_n_open_ne;//default
		int32_t wall_shadow_near_s_open_sw;
		int32_t wall_shadow_near_s_open_se;
		int32_t wall_shadow_near_w_open_nw;
		int32_t wall_shadow_near_w_open_sw;
		int32_t wall_shadow_near_e_open_ne;
		int32_t wall_shadow_near_e_open_se;
		int32_t wall_shadow_corner_nw;//default
		int32_t wall_shadow_corner_ne;
		int32_t wall_shadow_corner_sw;
		int32_t wall_shadow_corner_se;
		int32_t wall_shadow_end_wall_n;
		int32_t wall_shadow_end_wall_s;
		int32_t wall_shadow_end_wall_w;//default
		int32_t wall_shadow_end_wall_e;

		int32_t ramp_shadow_on_floor_nw_of_corner_se;
		int32_t ramp_shadow_on_floor_n_of_corner_se;
		int32_t ramp_shadow_on_floor_n_of_s;
		int32_t ramp_shadow_on_floor_n_of_corner_sw;
		int32_t ramp_shadow_on_floor_ne_of_corner_sw;
		int32_t ramp_shadow_on_ramp_s;
		int32_t ramp_shadow_on_floor_w_of_corner_se;
		int32_t ramp_shadow_on_ramp_inside_corner_se;
		int32_t ramp_shadow_on_ramp_inside_corner_sw;
		int32_t ramp_shadow_on_floor_e_of_corner_sw;
		int32_t ramp_shadow_on_floor_w_of_e;
		int32_t ramp_shadow_on_ramp_e;
		int32_t ramp_shadow_on_ramp_w;
		int32_t ramp_shadow_on_floor_e_of_w;
		int32_t ramp_shadow_on_floor_w_of_corner_ne;
		int32_t ramp_shadow_on_ramp_inside_corner_ne;
		int32_t ramp_shadow_on_ramp_inside_corner_nw;
		int32_t ramp_shadow_on_floor_e_of_corner_nw;
		int32_t ramp_shadow_on_ramp_n;
		int32_t ramp_shadow_on_floor_sw_of_corner_ne;
		int32_t ramp_shadow_on_floor_s_of_corner_ne;
		int32_t ramp_shadow_on_floor_s_of_n;
		int32_t ramp_shadow_on_floor_s_of_corner_nw;
		int32_t ramp_shadow_on_floor_se_of_corner_nw;
		int32_t ramp_shadow_on_ramp_corner_nw_w_tri_light;
		int32_t ramp_shadow_on_ramp_corner_nw_w_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_nw_n_tri_light;
		int32_t ramp_shadow_on_ramp_corner_nw_n_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_ne_e_tri_light;
		int32_t ramp_shadow_on_ramp_corner_ne_e_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_ne_n_tri_light;
		int32_t ramp_shadow_on_ramp_corner_ne_n_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_sw_w_tri_light;
		int32_t ramp_shadow_on_ramp_corner_sw_w_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_sw_s_tri_light;
		int32_t ramp_shadow_on_ramp_corner_sw_s_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_se_e_tri_light;
		int32_t ramp_shadow_on_ramp_corner_se_e_tri_heavy;
		int32_t ramp_shadow_on_ramp_corner_se_s_tri_light;
		int32_t ramp_shadow_on_ramp_corner_se_s_tri_heavy;

		//0=standard,1-7=priority,0=standard/1=blueprint marker/2=automine
		int32_t texpos_designation_dig_stair_updown[8][3];
		int32_t texpos_designation_dig_stair_up[8][3];
		int32_t texpos_designation_dig_stair_down[8][3];
		int32_t texpos_designation_dig_ramp[8][3];
		int32_t texpos_designation_dig_channel[8][3];
		int32_t texpos_designation_dig_remove_construction[8][3];
		int32_t texpos_designation_dig_standard[8][3];
		int32_t texpos_designation_chop[8][2];
		int32_t texpos_designation_gather[8][2];
		int32_t texpos_designation_smooth[8][2];
		int32_t texpos_designation_engrave[8][2];
		int32_t texpos_designation_track_n[8][2];
		int32_t texpos_designation_track_s[8][2];
		int32_t texpos_designation_track_w[8][2];
		int32_t texpos_designation_track_e[8][2];
		int32_t texpos_designation_track_ns[8][2];
		int32_t texpos_designation_track_nw[8][2];
		int32_t texpos_designation_track_ne[8][2];
		int32_t texpos_designation_track_sw[8][2];
		int32_t texpos_designation_track_se[8][2];
		int32_t texpos_designation_track_we[8][2];
		int32_t texpos_designation_track_nsw[8][2];
		int32_t texpos_designation_track_nse[8][2];
		int32_t texpos_designation_track_nwe[8][2];
		int32_t texpos_designation_track_swe[8][2];
		int32_t texpos_designation_track_nswe[8][2];
		int32_t texpos_designation_fortify[8][2];
		int32_t texpos_designation_priority[7];
		int32_t texpos_designation_item_melt;
		int32_t texpos_designation_item_dump;
		int32_t texpos_designation_item_forbidden;
		int32_t texpos_designation_item_hidden;
		int32_t texpos_designation_item_forbidden_melt;
		int32_t texpos_designation_item_forbidden_dump;
		int32_t texpos_designation_traffic_high;
		int32_t texpos_designation_traffic_low;
		int32_t texpos_designation_traffic_restricted;

		int32_t texpos_damp_stone_warning;
		int32_t texpos_warm_stone_warning;

		int32_t texpos_bottom_button_border_nw;
		int32_t texpos_bottom_button_border_w;
		int32_t texpos_bottom_button_border_n;
		int32_t texpos_bottom_button_border_interior;
		int32_t texpos_bottom_button_border_ne;
		int32_t texpos_bottom_button_border_e;

		int32_t missing_creature;
		int32_t missing_item;
		int32_t missing_building;

		int32_t texpos_legends_tab_page_left[3][2];
		int32_t texpos_legends_tab_page_right[3][2];
		int32_t texpos_legends_tab_close_inactive[2];
		int32_t texpos_legends_tab_close_active[2];

		int32_t texpos_help_border[3][3];
		int32_t texpos_help_corner[8][6];
		int32_t texpos_help_close[3][2];
		int32_t texpos_help_hide[3][2];
		int32_t texpos_help_reveal[3][2];

		int32_t texpos_embark_selected[4][3];
		int32_t texpos_embark_not_selected[4][3];
		int32_t texpos_embark_expand_y_active[2][3];
		int32_t texpos_embark_expand_y_inactive[2][3];
		int32_t texpos_embark_contract_y_active[2][3];
		int32_t texpos_embark_contract_y_inactive[2][3];
		int32_t texpos_embark_expand_x_active[4];
		int32_t texpos_embark_expand_x_inactive[4];
		int32_t texpos_embark_contract_x_active[4];
		int32_t texpos_embark_contract_x_inactive[4];

		int32_t texpos_adventure_burden_light[4];
		int32_t texpos_adventure_burden_heavy[4];

		int32_t texpos_embark_overlay_restricted;
		int32_t texpos_embark_overlay_good;
		int32_t texpos_embark_overlay_find_result;
		int32_t texpos_embark_overlay_find_result_partial;
		int32_t texpos_world_el_ocean_base;
		int32_t texpos_world_el_mid_base;
		int32_t texpos_world_el_mountains_base;
		int32_t texpos_world_el[280];//el = 1 to 280
		int32_t texpos_world_el_water[280];//el = 1 to 280
		int32_t texpos_world_el_mountain[280];//el = 1 to 280
		int32_t texpos_world_cliff[11];
		int32_t texpos_grassland_temp[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_temp_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_temp_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_temp_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_temp_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_trop[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_trop_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_trop_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_trop_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_grassland_trop_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_hills[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_hills_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_hills_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_hills_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_hills_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_shrubland[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_shrubland_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_shrubland_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_shrubland_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_shrubland_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_trop[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_trop_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_trop_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_trop_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_trop_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_temp[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_temp_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_temp_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_temp_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_savanna_temp_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_tundra[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_tundra_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_tundra_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_tundra_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_tundra_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_marsh[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_marsh_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_marsh_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_marsh_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_marsh_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_swamp[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_swamp_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_swamp_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_swamp_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_swamp_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_badlands[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_badlands_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_badlands_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_badlands_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_badlands_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_hills[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_hills_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_hills_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_hills_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_hills_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_plains[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_plains_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_plains_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_plains_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_rocky_plains_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_sand_desert[REGION_SQUARE_VARIANT_NUM];
			int32_t texpos_sand_desert_yellow[REGION_SQUARE_VARIANT_NUM];
			int32_t texpos_sand_desert_white[REGION_SQUARE_VARIANT_NUM];
			int32_t texpos_sand_desert_black[REGION_SQUARE_VARIANT_NUM];
			int32_t texpos_sand_desert_red[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_sand_desert_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_sand_desert_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_sand_desert_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_sand_desert_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_beach[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_beach_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_beach_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_beach_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_beach_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_glacier[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_glacier_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_glacier_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_glacier_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_glacier_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_lake[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_lake_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_lake_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_lake_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_lake_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_deep[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_deep_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_deep_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_deep_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_ocean_deep_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_frozen_ocean[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_frozen_ocean_evilsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_frozen_ocean_evil[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_frozen_ocean_goodsav[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_frozen_ocean_good[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_site_grassy[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_site_muddy[REGION_SQUARE_VARIANT_NUM];

		//32x32 detail textures
		int32_t texpos_mountain_peak[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_volcano[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_high[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_mid[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_low[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_peak_evilsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_volcano_evilsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_high_evilsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_mid_evilsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_low_evilsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_peak_evil[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_volcano_evil[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_high_evil[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_mid_evil[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_low_evil[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_peak_goodsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_volcano_goodsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_high_goodsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_mid_goodsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_low_goodsav[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_peak_good[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_volcano_good[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_high_good[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_mid_good[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_mountain_low_good[REGION_SQUARE_MOUNTAIN_NUM];
		int32_t texpos_forest_broadleaf_trop_moist[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_moist_evilsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_moist_evil[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_moist_goodsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_moist_good[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_dry[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_dry_evilsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_dry_evil[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_dry_goodsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_trop_dry_good[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_temp[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_temp_evilsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_temp_evil[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_temp_goodsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_broadleaf_temp_good[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_trop[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_trop_evilsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_trop_evil[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_trop_goodsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_trop_good[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_temp[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_temp_evilsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_temp_evil[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_temp_goodsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_conifer_temp_good[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_taiga[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_taiga_evilsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_taiga_evil[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_taiga_goodsav[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_forest_taiga_good[REGION_SQUARE_FOREST_NUM];
		//16x16 cutups of the 32x32s
		int32_t texpos_mountain_peak_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_volcano_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_high_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_mid_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_low_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_peak_evilsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_volcano_evilsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_high_evilsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_mid_evilsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_low_evilsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_peak_evil_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_volcano_evil_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_high_evil_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_mid_evil_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_low_evil_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_peak_goodsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_volcano_goodsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_high_goodsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_mid_goodsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_low_goodsav_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_peak_good_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_volcano_good_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_high_good_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_mid_good_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_mountain_low_good_c[REGION_SQUARE_MOUNTAIN_NUM][9];
		int32_t texpos_forest_broadleaf_trop_moist_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_moist_evilsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_moist_evil_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_moist_goodsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_moist_good_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_dry_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_dry_evilsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_dry_evil_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_dry_goodsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_trop_dry_good_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_temp_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_temp_evilsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_temp_evil_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_temp_goodsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_broadleaf_temp_good_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_taiga_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_taiga_evilsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_taiga_evil_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_taiga_goodsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_taiga_good_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_temp_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_temp_evilsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_temp_evil_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_temp_goodsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_temp_good_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_trop_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_trop_evilsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_trop_evil_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_trop_goodsav_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_forest_conifer_trop_good_c[REGION_SQUARE_FOREST_NUM][9];

		int32_t texpos_site_map_crops[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_site_map_crops_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_site_map_crops_fallow[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_site_map_meadow[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_site_map_pasture[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_site_map_inner_yard[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_site_map_orchard[REGION_SQUARE_FOREST_NUM];
		int32_t texpos_site_map_orchard_c[REGION_SQUARE_FOREST_NUM][9];
		int32_t texpos_site_map_solid_buildings[12];
		int32_t texpos_site_map_solid_buildings_top[12];
		int32_t texpos_site_map_buildings_road_nswe;
		int32_t texpos_site_map_buildings_road_swe;
		int32_t texpos_site_map_buildings_road_nwe;
		int32_t texpos_site_map_buildings_road_nse;
		int32_t texpos_site_map_buildings_road_nsw;
		int32_t texpos_site_map_buildings_road_ns;
		int32_t texpos_site_map_buildings_road_nw;
		int32_t texpos_site_map_buildings_road_ne;
		int32_t texpos_site_map_buildings_road_sw;
		int32_t texpos_site_map_buildings_road_se;
		int32_t texpos_site_map_buildings_road_we;
		int32_t texpos_site_map_buildings_road_n;
		int32_t texpos_site_map_buildings_road_s;
		int32_t texpos_site_map_buildings_road_w;
		int32_t texpos_site_map_buildings_road_e;
		int32_t texpos_site_map_buildings_road_nswe_top;
		int32_t texpos_site_map_buildings_road_swe_top;
		int32_t texpos_site_map_buildings_road_nwe_top;
		int32_t texpos_site_map_buildings_road_nse_top;
		int32_t texpos_site_map_buildings_road_nsw_top;
		int32_t texpos_site_map_buildings_road_ns_top;
		int32_t texpos_site_map_buildings_road_nw_top;
		int32_t texpos_site_map_buildings_road_ne_top;
		int32_t texpos_site_map_buildings_road_sw_top;
		int32_t texpos_site_map_buildings_road_se_top;
		int32_t texpos_site_map_buildings_road_we_top;
		int32_t texpos_site_map_buildings_road_n_top;
		int32_t texpos_site_map_buildings_road_s_top;
		int32_t texpos_site_map_buildings_road_w_top;
		int32_t texpos_site_map_buildings_road_e_top;
		int32_t texpos_site_map_isolated_building;
		svector<int32_t> texpos_site_map_mead_hall_11;
		svector<int32_t> texpos_site_map_mead_hall_11_top;
		svector<int32_t> texpos_site_map_temple_11;
		svector<int32_t> texpos_site_map_temple_11_top;
		svector<int32_t> texpos_site_map_temple_21[2];
		svector<int32_t> texpos_site_map_temple_21_top[2];
		svector<int32_t> texpos_site_map_temple_12[2];
		svector<int32_t> texpos_site_map_temple_12_top;
		svector<int32_t> texpos_site_map_temple_22[2][2];
		svector<int32_t> texpos_site_map_temple_22_top[2];
		svector<int32_t> texpos_site_map_tavern_11;
		svector<int32_t> texpos_site_map_tavern_11_top;
		svector<int32_t> texpos_site_map_tavern_21[2];
		svector<int32_t> texpos_site_map_tavern_21_top[2];
		svector<int32_t> texpos_site_map_tavern_12[2];
		svector<int32_t> texpos_site_map_tavern_12_top;
		svector<int32_t> texpos_site_map_tavern_22[2][2];
		svector<int32_t> texpos_site_map_tavern_22_top[2];
		svector<int32_t> texpos_site_map_library_11;
		svector<int32_t> texpos_site_map_library_11_top;
		svector<int32_t> texpos_site_map_library_21[2];
		svector<int32_t> texpos_site_map_library_21_top[2];
		svector<int32_t> texpos_site_map_library_12[2];
		svector<int32_t> texpos_site_map_library_12_top;
		svector<int32_t> texpos_site_map_library_22[2][2];
		svector<int32_t> texpos_site_map_library_22_top[2];
		svector<int32_t> texpos_site_map_counting_house_11;
		svector<int32_t> texpos_site_map_counting_house_11_top;
		svector<int32_t> texpos_site_map_counting_house_21[2];
		svector<int32_t> texpos_site_map_counting_house_21_top[2];
		svector<int32_t> texpos_site_map_counting_house_12[2];
		svector<int32_t> texpos_site_map_counting_house_12_top;
		svector<int32_t> texpos_site_map_counting_house_22[2][2];
		svector<int32_t> texpos_site_map_counting_house_22_top[2];
		svector<int32_t> texpos_site_map_bld_tower;
		svector<int32_t> texpos_site_map_bld_tower_top;
		svector<int32_t> texpos_site_map_garden;
		svector<int32_t> texpos_site_map_garden_top;
		svector<int32_t> texpos_site_map_guildhall_11;
		svector<int32_t> texpos_site_map_guildhall_11_top;
		svector<int32_t> texpos_site_map_guildhall_21[2];
		svector<int32_t> texpos_site_map_guildhall_21_top[2];
		svector<int32_t> texpos_site_map_guildhall_12[2];
		svector<int32_t> texpos_site_map_guildhall_12_top;
		svector<int32_t> texpos_site_map_guildhall_22[2][2];
		svector<int32_t> texpos_site_map_guildhall_22_top[2];
		int32_t texpos_site_map_plaza;
		int32_t texpos_site_map_dirt_field;
		int32_t texpos_site_map_road_paved_nswe;
		int32_t texpos_site_map_road_paved_swe;
		int32_t texpos_site_map_road_paved_nwe;
		int32_t texpos_site_map_road_paved_nse;
		int32_t texpos_site_map_road_paved_nsw;
		int32_t texpos_site_map_road_paved_ns;
		int32_t texpos_site_map_road_paved_nw;
		int32_t texpos_site_map_road_paved_ne;
		int32_t texpos_site_map_road_paved_sw;
		int32_t texpos_site_map_road_paved_se;
		int32_t texpos_site_map_road_paved_we;
		int32_t texpos_site_map_road_paved_n;
		int32_t texpos_site_map_road_paved_s;
		int32_t texpos_site_map_road_paved_w;
		int32_t texpos_site_map_road_paved_e;
		int32_t texpos_site_map_road_dirt_nswe;
		int32_t texpos_site_map_road_dirt_swe;
		int32_t texpos_site_map_road_dirt_nwe;
		int32_t texpos_site_map_road_dirt_nse;
		int32_t texpos_site_map_road_dirt_nsw;
		int32_t texpos_site_map_road_dirt_ns;
		int32_t texpos_site_map_road_dirt_nw;
		int32_t texpos_site_map_road_dirt_ne;
		int32_t texpos_site_map_road_dirt_sw;
		int32_t texpos_site_map_road_dirt_se;
		int32_t texpos_site_map_road_dirt_we;
		int32_t texpos_site_map_road_dirt_n;
		int32_t texpos_site_map_road_dirt_s;
		int32_t texpos_site_map_road_dirt_w;
		int32_t texpos_site_map_road_dirt_e;
		int32_t texpos_site_map_castle;
		int32_t texpos_site_map_castle_wall_nswe;
		int32_t texpos_site_map_castle_wall_swe;
		int32_t texpos_site_map_castle_wall_nwe;
		int32_t texpos_site_map_castle_wall_nse;
		int32_t texpos_site_map_castle_wall_nsw;
		int32_t texpos_site_map_castle_wall_ns;
		int32_t texpos_site_map_castle_wall_nw;
		int32_t texpos_site_map_castle_wall_ne;
		int32_t texpos_site_map_castle_wall_sw;
		int32_t texpos_site_map_castle_wall_se;
		int32_t texpos_site_map_castle_wall_we;
		int32_t texpos_site_map_castle_keep;
		int32_t texpos_site_map_castle_keep_top;
		int32_t texpos_site_map_wooden_wall_nswe;
		int32_t texpos_site_map_wooden_wall_swe;
		int32_t texpos_site_map_wooden_wall_nwe;
		int32_t texpos_site_map_wooden_wall_nse;
		int32_t texpos_site_map_wooden_wall_nsw;
		int32_t texpos_site_map_wooden_wall_ns;
		int32_t texpos_site_map_wooden_wall_nw;
		int32_t texpos_site_map_wooden_wall_ne;
		int32_t texpos_site_map_wooden_wall_sw;
		int32_t texpos_site_map_wooden_wall_se;
		int32_t texpos_site_map_wooden_wall_we;
		int32_t texpos_site_map_wooden_keep;
		int32_t texpos_site_map_wooden_keep_top;
		int32_t texpos_site_map_bridge_brook_we;
		int32_t texpos_site_map_bridge_brook_ns;
		int32_t texpos_site_map_bridge_river_we;
		int32_t texpos_site_map_bridge_river_ns;
		int32_t texpos_site_map_gate_ns;
		int32_t texpos_site_map_gate_we;
		int32_t texpos_site_map_wooden_gate_tower;
		int32_t texpos_site_map_wooden_gate_tower_top;
		int32_t texpos_site_map_stone_gate_tower;
		int32_t texpos_site_map_stone_gate_tower_top;
		int32_t texpos_site_map_great_dark_tower;
		int32_t texpos_site_map_great_dark_tower_top;
		int32_t texpos_site_map_great_dark_tower_z[3][3];
		int32_t texpos_site_map_great_dark_tower_z_top[3];
		int32_t texpos_site_map_dark_tower;
		int32_t texpos_site_map_dark_tower_top;
		int32_t texpos_site_map_trench_nswe;
		int32_t texpos_site_map_trench_swe;
		int32_t texpos_site_map_trench_nwe;
		int32_t texpos_site_map_trench_nse;
		int32_t texpos_site_map_trench_nsw;
		int32_t texpos_site_map_trench_ns;
		int32_t texpos_site_map_trench_nw;
		int32_t texpos_site_map_trench_ne;
		int32_t texpos_site_map_trench_sw;
		int32_t texpos_site_map_trench_se;
		int32_t texpos_site_map_trench_we;
		int32_t texpos_site_map_trench_n;
		int32_t texpos_site_map_trench_s;
		int32_t texpos_site_map_trench_w;
		int32_t texpos_site_map_trench_e;
		int32_t texpos_site_map_trench;
		svector<int32_t> texpos_site_map_hillock_house;
		svector<int32_t> texpos_site_map_hillock_hall;
		svector<int32_t> texpos_site_map_hillock_tavern;
		svector<int32_t> texpos_site_map_hillock_civic;
		int32_t texpos_site_map_tree_residential;
		int32_t texpos_site_map_tree_residential_top;
		int32_t texpos_site_map_tree_home;
		int32_t texpos_site_map_tree_home_top;
		int32_t texpos_site_map_tree_industry;
		int32_t texpos_site_map_tree_industry_top;
		int32_t texpos_site_map_tree_market;
		int32_t texpos_site_map_tree_market_top;
		int32_t texpos_site_map_tree_inn;
		int32_t texpos_site_map_tree_inn_top;
		int32_t texpos_site_map_tree_library;
		int32_t texpos_site_map_tree_library_top;
		int32_t texpos_site_map_tree_building;
		int32_t texpos_site_map_tree_building_top;
		int32_t texpos_site_map_tower_undead;
		int32_t texpos_site_map_tower_undead_top;
		int32_t texpos_site_map_building;
		int32_t texpos_site_map_vault;
		int32_t texpos_site_map_vault_top;
		int32_t texpos_site_map_vault_z[3][3];
		int32_t texpos_site_map_vault_z_top[3];
		int32_t texpos_site_map_mythical_palace;
		int32_t texpos_site_map_mythical_dungeon;
		int32_t texpos_site_map_mythical_lair;

		int32_t texpos_tunnel_ns;
		int32_t texpos_tunnel_we;
		int32_t texpos_tunnel_se;
		int32_t texpos_tunnel_sw;
		int32_t texpos_tunnel_ne;
		int32_t texpos_tunnel_nw;
		int32_t texpos_tunnel_nse;
		int32_t texpos_tunnel_swe;
		int32_t texpos_tunnel_nwe;
		int32_t texpos_tunnel_nsw;
		int32_t texpos_tunnel_nswe;
		int32_t texpos_tunnel_0;
		int32_t texpos_tunnel_s;
		int32_t texpos_tunnel_n;
		int32_t texpos_tunnel_w;
		int32_t texpos_tunnel_e;
		int32_t texpos_road_paved_ns;
		int32_t texpos_road_paved_we;
		int32_t texpos_road_paved_se;
		int32_t texpos_road_paved_sw;
		int32_t texpos_road_paved_ne;
		int32_t texpos_road_paved_nw;
		int32_t texpos_road_paved_nse;
		int32_t texpos_road_paved_swe;
		int32_t texpos_road_paved_nwe;
		int32_t texpos_road_paved_nsw;
		int32_t texpos_road_paved_nswe;
		int32_t texpos_road_paved_0;
		int32_t texpos_road_paved_s;
		int32_t texpos_road_paved_n;
		int32_t texpos_road_paved_w;
		int32_t texpos_road_paved_e;
		int32_t texpos_road_dirt_ns;
		int32_t texpos_road_dirt_we;
		int32_t texpos_road_dirt_se;
		int32_t texpos_road_dirt_sw;
		int32_t texpos_road_dirt_ne;
		int32_t texpos_road_dirt_nw;
		int32_t texpos_road_dirt_nse;
		int32_t texpos_road_dirt_swe;
		int32_t texpos_road_dirt_nwe;
		int32_t texpos_road_dirt_nsw;
		int32_t texpos_road_dirt_nswe;
		int32_t texpos_road_dirt_0;
		int32_t texpos_road_dirt_s;
		int32_t texpos_road_dirt_n;
		int32_t texpos_road_dirt_w;
		int32_t texpos_road_dirt_e;
		int32_t texpos_brook_ns[REGION_SQUARE_RIVER_NUM];
		int32_t texpos_brook_we[REGION_SQUARE_RIVER_NUM];
		int32_t texpos_brook_se;
		int32_t texpos_brook_sw;
		int32_t texpos_brook_ne;
		int32_t texpos_brook_nw;
		int32_t texpos_brook_nse;
		int32_t texpos_brook_swe;
		int32_t texpos_brook_nwe;
		int32_t texpos_brook_nsw;
		int32_t texpos_brook_nswe;
		int32_t texpos_brook_0;
		int32_t texpos_brook_s;
		int32_t texpos_brook_n;
		int32_t texpos_brook_w;
		int32_t texpos_brook_e;
		int32_t texpos_brook_mouth_narrow_s;
		int32_t texpos_brook_mouth_narrow_n;
		int32_t texpos_brook_mouth_narrow_w;
		int32_t texpos_brook_mouth_narrow_e;
		int32_t texpos_river_ns[REGION_SQUARE_RIVER_NUM];
		int32_t texpos_river_we[REGION_SQUARE_RIVER_NUM];
		int32_t texpos_river_se;
		int32_t texpos_river_sw;
		int32_t texpos_river_ne;
		int32_t texpos_river_nw;
		int32_t texpos_river_nse;
		int32_t texpos_river_swe;
		int32_t texpos_river_nwe;
		int32_t texpos_river_nsw;
		int32_t texpos_river_nswe;
		int32_t texpos_river_0;
		int32_t texpos_river_s;
		int32_t texpos_river_n;
		int32_t texpos_river_w;
		int32_t texpos_river_e;
		int32_t texpos_river_mouth_narrow_s;
		int32_t texpos_river_mouth_narrow_n;
		int32_t texpos_river_mouth_narrow_w;
		int32_t texpos_river_mouth_narrow_e;
		int32_t texpos_river_major_ns[REGION_SQUARE_RIVER_NUM];
		int32_t texpos_river_major_we[REGION_SQUARE_RIVER_NUM];
		int32_t texpos_river_major_se;
		int32_t texpos_river_major_sw;
		int32_t texpos_river_major_ne;
		int32_t texpos_river_major_nw;
		int32_t texpos_river_major_nse;
		int32_t texpos_river_major_swe;
		int32_t texpos_river_major_nwe;
		int32_t texpos_river_major_nsw;
		int32_t texpos_river_major_nswe;
		int32_t texpos_river_major_0;
		int32_t texpos_river_major_s;
		int32_t texpos_river_major_n;
		int32_t texpos_river_major_w;
		int32_t texpos_river_major_e;
		int32_t texpos_river_major_mouth_narrow_s;
		int32_t texpos_river_major_mouth_narrow_n;
		int32_t texpos_river_major_mouth_narrow_w;
		int32_t texpos_river_major_mouth_narrow_e;
		int32_t texpos_site_cave;
		int32_t texpos_site_labyrinth;
		int32_t texpos_site_shrine_titan;
		int32_t texpos_site_lair_burrow;
		int32_t texpos_map_cursor;
		int32_t texpos_map_your_fort;
		int32_t texpos_map_your_civ;
		int32_t texpos_map_neutral;
		int32_t texpos_map_hostile;
		int32_t texpos_map_occupied_holding;
		int32_t texpos_map_holding;
		int32_t texpos_map_vassal;
		int32_t texpos_map_occupied_tributary;
		int32_t texpos_map_tributary;
		int32_t texpos_map_market_dependence;
		int32_t texpos_map_ally;
		int32_t texpos_map_attack;
		int32_t texpos_map_mission_path;
		int32_t texpos_map_mission_marker;
		int32_t texpos_site_camp;
		int32_t texpos_site_fortress;
		int32_t texpos_site_hillocks;
		int32_t texpos_site_mountain_home;
		int32_t texpos_site_village;
		int32_t texpos_site_city_1;
		int32_t texpos_site_city_2;
		int32_t texpos_site_city_3;
		int32_t texpos_site_city_4;
		int32_t texpos_site_forest_retreat_2;
		int32_t texpos_site_forest_retreat_1;
		int32_t texpos_site_necrotower;
		int32_t texpos_site_castle;
		int32_t texpos_site_fort;
		int32_t texpos_site_monastery;
		int32_t texpos_site_vault;
		int32_t texpos_site_mythical_palace;
		int32_t texpos_site_mythical_dungeon;
		int32_t texpos_site_mythical_lair;
		int32_t texpos_site_tomb;
		int32_t texpos_site_dark_fortress_2;
		int32_t texpos_site_dark_fortress_1;
		int32_t texpos_site_ruin_dwarf;
		int32_t texpos_site_ruin_village;
		int32_t texpos_site_ruin_city;
		int32_t texpos_site_ruin_forest_retreat_2;
		int32_t texpos_site_ruin_forest_retreat_1;
		int32_t texpos_site_ruin_castle;
		int32_t texpos_site_ruin_goblin;
		int32_t texpos_site_ruin;
		int32_t texpos_elevation_indicator;
		int32_t texpos_army_group_small;
		int32_t texpos_army_group_medium;
		int32_t texpos_army_group_large;
		int32_t texpos_army_soldiers_small;
		int32_t texpos_army_soldiers_medium;
		int32_t texpos_army_soldiers_large;
		int32_t texpos_army_monsters_small;
		int32_t texpos_army_monsters_medium;
		int32_t texpos_army_monsters_large;
		int32_t texpos_map_adv_you_travel;

		int32_t texpos_world_stratus_nimbus[3*3];
		int32_t texpos_world_stratus_proper[3*3];
		int32_t texpos_world_stratus_alto[3*3];
		int32_t texpos_world_cumulus_nimbus[3*3];
		int32_t texpos_world_cumulus_multi;
		int32_t texpos_world_cumulus_med;
		int32_t texpos_world_cirrus[3*3];
		int32_t texpos_world_fog_thick;
		int32_t texpos_world_fog_normal;
		int32_t texpos_world_fog_mist;

		svector<int32_t> texpos_map_drawn[TEXTURE_MAP_DRAWNNUM];

		int32_t texpos_world_edge_shape_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thinning_e_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_world_edge_shape_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_grass_temp_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_grass_temp_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_grass_temp_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_temp_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_grass_trop_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_grass_trop_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_grass_trop_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_grass_trop_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_wetland_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_wetland_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_wetland_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_wetland_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_beach_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_beach_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_beach_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_desert_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_desert_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_desert_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_desert_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_yellow_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_yellow_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_white_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_white_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_black_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_black_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_red_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_red_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_sand_desert_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_sand_desert_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_tundra_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_tundra_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_tundra_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_tundra_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_glacier_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_glacier_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_glacier_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_glacier_evilsav_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_evilsav_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_glacier_goodsav_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_glacier_goodsav_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_water_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_water_evil_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_evil_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_water_good_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_water_good_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_beach_line_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_beach_line_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_site_muddy_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_muddy_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		int32_t texpos_edge_site_grassy_straight_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_straight_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_straight_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_straight_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thick_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thick_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thick_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thick_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_inlet_nsw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_inlet_nse[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_inlet_nwe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_inlet_swe[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_surround[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_nw_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_nw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_ne_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_ne_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_sw_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_sw_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_se_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thin_corner_transition_se_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_tiny_corner_nw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_tiny_corner_ne[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_tiny_corner_sw[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_tiny_corner_se[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_n_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_n_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_s_w[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_s_e[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_w_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_w_s[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_e_n[REGION_SQUARE_VARIANT_NUM];
		int32_t texpos_edge_site_grassy_thinning_e_s[REGION_SQUARE_VARIANT_NUM];

		//*********************** INDIV TREE definers
			//need the data structure for special floor and top shadow textures here, stores texpos and also the definer
				//definer is each 8 directions and the species of tree index



	graphicst()
		{
		viewport_zoom_factor=192;

		display_title=false;
		display_background=(int32_t)TEXTURE_NONE;

		main_thread_requesting_reshape=false;
			main_thread_requesting_reshape_activate_map_port=false;

		black_background_texpos[0]=0;
		int32_t tt;
		for(tt=0;tt<LOWER_VIEWPORT_MAX;++tt)multilevel_depth_texpos[tt]=0;
		print_index=0;
		display_frames=0;
		rect_id=-1;
		force_full_display_count=4;
		original_rect=1;

        screen=NULL;
        screentexpos=NULL;
        screentexpos_lower=NULL;
        screentexpos_anchored=NULL;
		screentexpos_anchored_x=NULL;
		screentexpos_anchored_y=NULL;
        screentexpos_flag=NULL;
        screen_top=NULL;
        screentexpos_top=NULL;
        screentexpos_top_lower=NULL;
        screentexpos_top_anchored=NULL;
		screentexpos_top_anchored_x=NULL;
		screentexpos_top_anchored_y=NULL;
        screentexpos_top_flag=NULL;

		screentexpos_refresh_buffer=NULL;
		refresh_buffer_val=0;

		main_viewport=NULL;
		int32_t lvp;
		for(lvp=0;lvp<LOWER_VIEWPORT_MAX;++lvp)lower_viewport[lvp]=NULL;

		main_map_port=NULL;
		//******************************* MAP CASES init vars

		do_clean_tile_cache=false;
		do_post_init_texture_clear=false;
        }

	// Calling this is not enough in itself. You also need to call swap_front/back.
	void resize(int x, int y);

	void locate(long y,long x)
		{
		// No point in clamping here, addchar clamps too.
		screenx=x;
		screeny=y;
		}

	void changecolor(short f,short b,char bright)
		{
		screenf=f;
		screenb=b;
		screenbright=bright;
		use_old_16_colors=true;
		}

	void color3ub(unsigned char r,unsigned char g,unsigned char b)
		{
		screen_color_r=r;
		screen_color_g=g;
		screen_color_b=b;
		use_old_16_colors=false;
		}
	void bcolor3ub(unsigned char r,unsigned char g,unsigned char b)
		{
		screen_color_br=r;
		screen_color_bg=g;
		screen_color_bb=b;
		use_old_16_colors=false;
		}

	void override_tiles(int sy,int sx,int ey,int ex,override_tile_type flag) {
		if (flag==0) return;
		for (auto bx=sx; bx <= ex; bx++)
			{
			for (auto by=sy; by <= ey; by++)
				{
				const auto pos=bx*dimy + by;
				if (flag&OVERRIDE_CHAR)
					{
					locate(by,bx);
					addchar(0);
					}
				if (flag&OVERRIDE_TILE)screentexpos[pos]=0;
				if (flag&OVERRIDE_TOP_TILE)screentexpos_top[pos]=0;
				if (flag&OVERRIDE_LOWER_TILE)screentexpos_lower[pos]=0;
				if (flag&OVERRIDE_TOP_LOWER_TILE)screentexpos_top_lower[pos]=0;
				if (flag&OVERRIDE_ANCHORED_TILE)screentexpos_anchored[pos]=0;
				if (flag&OVERRIDE_TOP_ANCHORED_TILE)screentexpos_top_anchored[pos]=0;
				}
			}
		}

	void addchar(unsigned char c,char advance=1)
		{
        /* assert (screen_limit == screen + dimy * dimx * 8); */
        unsigned char *s = screen + screenx*dimy*8 + screeny*8;
        if (s < screen_limit)
			{
			if(screenx>=clipx[0]&&screenx<=clipx[1]&&
				screeny>=clipy[0]&&screeny<=clipy[1])
				{
				//********************** GLYPH TEST
                *s++ = c;
				if(use_old_16_colors)
					{
					int32_t fg=screenf+(screenbright?8:0);
					*s++ = uccolor[fg][0];
					*s++ = uccolor[fg][1];
					*s++ = uccolor[fg][2];
					*s++ = uccolor[screenb][0];
					*s++ = uccolor[screenb][1];
					*s++ = uccolor[screenb][2];
					++s;//extra byte
					}
				else
					{
					*s++ = screen_color_r;
					*s++ = screen_color_g;
					*s++ = screen_color_b;
					*s++ = screen_color_br;
					*s++ = screen_color_bg;
					*s++ = screen_color_bb;
					++s;//extra byte
					}
                screentexpos[screenx*dimy + screeny]=0;
				}
			}
		screenx+=advance;
		}

    void addchar(unsigned int x, unsigned int y, unsigned char c,
					unsigned char f, unsigned char b, unsigned char bright)
		{
		/* assert (screen_limit == screen + dimy * dimx * 8); */
		unsigned char *s = screen + x*dimy*8 + y*8;
		if (s >= screen && s < screen_limit)
			{
			if(x>=clipx[0]&&x<=clipx[1]&&
				y>=clipy[0]&&y<=clipy[1])
				{
				//********************** GLYPH TEST
				*s++ = c;
				int32_t fg=f+(bright?8:0);
				*s++ = uccolor[f][0];
				*s++ = uccolor[f][1];
				*s++ = uccolor[f][2];
				*s++ = uccolor[b][0];
				*s++ = uccolor[b][1];
				*s++ = uccolor[b][2];
				++s;//extra byte
				}
			}
		}

	void addchar_flag(unsigned char c,char advance=1,uint32_t sflag=0)
		{
        /* assert (screen_limit == screen + dimy * dimx * 8); */
        unsigned char *s = screen + screenx*dimy*8 + screeny*8;
        if (s < screen_limit)
			{
			if(screenx>=clipx[0]&&screenx<=clipx[1]&&
				screeny>=clipy[0]&&screeny<=clipy[1])
				{
				//********************** GLYPH TEST
                *s++ = c;
				if(use_old_16_colors)
					{
					int32_t fg=screenf+(screenbright?8:0);
					*s++ = uccolor[fg][0];
					*s++ = uccolor[fg][1];
					*s++ = uccolor[fg][2];
					*s++ = uccolor[screenb][0];
					*s++ = uccolor[screenb][1];
					*s++ = uccolor[screenb][2];
					++s;//extra byte
					}
				else
					{
					*s++ = screen_color_r;
					*s++ = screen_color_g;
					*s++ = screen_color_b;
					*s++ = screen_color_br;
					*s++ = screen_color_bg;
					*s++ = screen_color_bb;
					++s;//extra byte
					}
                screentexpos[screenx*dimy + screeny]=0;
                screentexpos_flag[screenx*dimy + screeny]=sflag;
				}
			}
		screenx+=advance;
		}

    void addchar_flag(unsigned int x, unsigned int y, unsigned char c,
					unsigned char f, unsigned char b, unsigned char bright,uint32_t sflag)
		{
		/* assert (screen_limit == screen + dimy * dimx * 8); */
		unsigned char *s = screen + x*dimy*8 + y*8;
		if (s >= screen && s < screen_limit)
			{
			if(x>=clipx[0]&&x<=clipx[1]&&
				y>=clipy[0]&&y<=clipy[1])
				{
				//********************** GLYPH TEST
				*s++ = c;
				int32_t fg=f+(bright?8:0);
				*s++ = uccolor[fg][0];
				*s++ = uccolor[fg][1];
				*s++ = uccolor[fg][2];
				*s++ = uccolor[b][0];
				*s++ = uccolor[b][1];
				*s++ = uccolor[b][2];
				++s;//extra byte
				screentexpos_flag[screenx*dimy + screeny]=sflag;
				}
			}
		}

	void top_addchar(unsigned char c,char advance=1)
		{
        /* assert (screen_limit == screen + dimy * dimx * 8); */
        unsigned char *s = screen_top + screenx*dimy*8 + screeny*8;
        if (s < screen_top_limit)
			{
			if(screenx>=clipx[0]&&screenx<=clipx[1]&&
				screeny>=clipy[0]&&screeny<=clipy[1])
				{
				//********************** GLYPH TEST
                *s++ = c;
				if(use_old_16_colors)
					{
					int32_t fg=screenf+(screenbright?8:0);
					*s++ = uccolor[fg][0];
					*s++ = uccolor[fg][1];
					*s++ = uccolor[fg][2];
					*s++ = uccolor[screenb][0];
					*s++ = uccolor[screenb][1];
					*s++ = uccolor[screenb][2];
					++s;//extra byte
					}
				else
					{
					*s++ = screen_color_r;
					*s++ = screen_color_g;
					*s++ = screen_color_b;
					*s++ = screen_color_br;
					*s++ = screen_color_bg;
					*s++ = screen_color_bb;
					++s;//extra byte
					}
                screentexpos_top[screenx*dimy + screeny]=0;
				}
			}
		screenx+=advance;
		}

    void top_addchar(unsigned int x, unsigned int y, unsigned char c,
					unsigned char f, unsigned char b, unsigned char bright)
		{
		/* assert (screen_limit == screen + dimy * dimx * 8); */
		unsigned char *s = screen_top + x*dimy*8 + y*8;
		if (s >= screen_top && s < screen_top_limit)
			{
			if(x>=clipx[0]&&x<=clipx[1]&&
				y>=clipy[0]&&y<=clipy[1])
				{
				//********************** GLYPH TEST
				*s++ = c;
				int32_t fg=f+(bright?8:0);
				*s++ = uccolor[f][0];
				*s++ = uccolor[f][1];
				*s++ = uccolor[f][2];
				*s++ = uccolor[b][0];
				*s++ = uccolor[b][1];
				*s++ = uccolor[b][2];
				++s;//extra byte
				}
			}
		}

	void top_addchar_flag(unsigned char c,char advance=1,uint32_t sflag=0)
		{
        /* assert (screen_limit == screen + dimy * dimx * 8); */
        unsigned char *s = screen_top + screenx*dimy*8 + screeny*8;
        if (s < screen_top_limit)
			{
			if(screenx>=clipx[0]&&screenx<=clipx[1]&&
				screeny>=clipy[0]&&screeny<=clipy[1])
				{
				//********************** GLYPH TEST
                *s++ = c;
				if(use_old_16_colors)
					{
					int32_t fg=screenf+(screenbright?8:0);
					*s++ = uccolor[fg][0];
					*s++ = uccolor[fg][1];
					*s++ = uccolor[fg][2];
					*s++ = uccolor[screenb][0];
					*s++ = uccolor[screenb][1];
					*s++ = uccolor[screenb][2];
					++s;//extra byte
					}
				else
					{
					*s++ = screen_color_r;
					*s++ = screen_color_g;
					*s++ = screen_color_b;
					*s++ = screen_color_br;
					*s++ = screen_color_bg;
					*s++ = screen_color_bb;
					++s;//extra byte
					}
                screentexpos_top[screenx*dimy + screeny]=0;
                screentexpos_top_flag[screenx*dimy + screeny]=sflag;
				}
			}
		screenx+=advance;
		}

    void top_addchar_flag(unsigned int x, unsigned int y, unsigned char c,
					unsigned char f, unsigned char b, unsigned char bright,uint32_t sflag)
		{
		/* assert (screen_limit == screen + dimy * dimx * 8); */
		unsigned char *s = screen_top + x*dimy*8 + y*8;
		if (s >= screen_top && s < screen_top_limit)
			{
			if(x>=clipx[0]&&x<=clipx[1]&&
				y>=clipy[0]&&y<=clipy[1])
				{
				//********************** GLYPH TEST
				*s++ = c;
				int32_t fg=f+(bright?8:0);
				*s++ = uccolor[fg][0];
				*s++ = uccolor[fg][1];
				*s++ = uccolor[fg][2];
				*s++ = uccolor[b][0];
				*s++ = uccolor[b][1];
				*s++ = uccolor[b][2];
				++s;//extra byte
				screentexpos_top_flag[screenx*dimy + screeny]=sflag;
				}
			}
		}
#ifdef WIN32
#define ATTR_NOINLINE [[msvc::noinline]]
#else
#define ATTR_NOINLINE [[gnu::noinline]]
#endif
	ATTR_NOINLINE
	void addcoloredst(const char *str,const char *colorstr);
	ATTR_NOINLINE
	void addst(const string &str, justification just = justify_left, int space=0);
	ATTR_NOINLINE
	void addst_flag(const string &str_orig, justification just, int space=0, uint32_t sflag=0);
	ATTR_NOINLINE
	void top_addst(const string &str, justification just = justify_left, int space=0);
	ATTR_NOINLINE
	void top_addst_flag(const string &str_orig, justification just, int space=0, uint32_t sflag=0);
	void erasescreen_clip();
	void erasescreen();
            void erasescreen_rect(int x1, int x2, int y1, int y2);
	void setclipping(long x1,long x2,long y1,long y2);

	void add_texture_blit(int32_t which);

	void add_tile(long texp,char addcolor);
	void add_tile_grayscale(long texp,char cf,char cbr);
	void add_lower_tile(long texp);
	void add_anchored_tile(long texp,long offset_x,long offset_y,long tdx,long tdy,bool use_color);

	void add_top_tile(long texp,char addcolor);
	void add_top_lower_tile(long texp);
	void add_top_anchored_tile(long texp,long offset_x,long offset_y,long tdx,long tdy,bool use_color);

	void prepare_graphics(const std::filesystem::path &src_dir);
	void create_derived_textures();
	void copy_transformed_pixel_data(SDL_Surface *src,SDL_Surface *dst,int32_t cw_rotate,bool flip_vert);
	void copy_pixel_data_with_alpha_mask(SDL_Surface *src,SDL_Surface *alpha_src,SDL_Surface *dst);
	void copy_pixel_data_nonzero_only_no_blend(SDL_Surface *src,SDL_Surface *dst);
	int32_t create_alpha_texture(int32_t texpos,Uint8 alpha_level);

	void gray_out_rect(long sx,long ex,long sy,long ey)
		{
		//******************************** DIM COLORS
			//beware -- *4 should be *8 in most places now
		/*
		long x,y;
		for(x=sx;x<=ex;x++)
			{
			for(y=sy;y<=ey;y++)
				{
				screen[x*dimy*4 + y*4 + 1]=0;
				screen[x*dimy*4 + y*4 + 2]=7;
				screen[x*dimy*4 + y*4 + 3]=0;
				}
			}
		*/
		}

	void dim_colors(long x,long y,char dim);

	void rain_color_square(long x,long y);
	void snow_color_square(long x,long y);
	void color_square(long x,long y,unsigned char f,unsigned char b,unsigned char br);

	long border_start_x(){return 1;}
	long border_start_y(){return 1;}
	long border_end_x(){return 78;}
	long border_end_y(){return 23;}
	long text_width(){return 1;}
	long text_height(){return 1;}
	long window_element_height(long minus,char border)
		{
		long height=25;
		if(border)height-=2;
		height-=text_height()*minus;
		return height;
		}

	void get_mouse_precise_coords(int32_t &mx, int32_t &my)
		{
		mx = precise_mouse_x; my = precise_mouse_y;
		}
	void get_mouse_text_coords(int32_t &mx, int32_t &my)
		{
		mx = mouse_x; my = mouse_y;
		}
	void draw_border(int x1, int x2, int y1, int y2);

	void reshape_viewports(int32_t zoom_factor);
	void delete_all_viewports()
		{
		auto v_s=viewport.begin();
		auto v_e=viewport.end();
		for(;v_s<v_e;++v_s)delete *v_s;
		viewport.clear();

		main_viewport=NULL;
		int32_t v;
		for(v=0;v<LOWER_VIEWPORT_MAX;++v)lower_viewport[v]=NULL;

		auto m_s=map_port.begin();
		auto m_e=map_port.end();
		for(;m_s<m_e;++m_s)delete *m_s;
		map_port.clear();

		main_map_port=NULL;
		//******************************* MAP CASES delete map ports
		}

	int lookup_pair(std::pair<int,int> color);
	long calculate_old_fps();
	void set_force_full_display_count(short new_count);
	void zero_and_clear_all_texpos();

	void get_play_area_tile_size(int32_t &limx,int32_t &limy);
};

extern graphicst gps;
// From graphics.cpp
void render_things();

// Locates some area of the screen with free space for writing
class gps_locator {
  int y, last_x;
public:
  gps_locator(int y, int x) {
    this->y = y;
    last_x = x;
  }
  bool is_free(int x) {
    unsigned char c = gps.screen[x*gps.dimy*8 + y*8];
    switch (c) {
    case 0:
    case 20:
    case 176:
    case 177:
    case 178:
    case 219:
    case 254:
    case 255:
      return true;
    default:
      return false;
    }
  }
  void operator()(int sz) {
    // First, check if our cached slot will still do
    bool ok = true;
    for (int x = last_x; x < last_x + sz; x++)
      if (!is_free(x)) {
        ok = false;
        break;
      }
    if (ok) {
      // Yeah, okay
      gps.locate(y, last_x);
    } else {
      // Not so okay. Find a new spot.
      int run = 0, x = 0;
      for (; x < gps.dimx; x++) {
        if (is_free(x))
          run++;
        else run = 0;
        if (run > sz + 2) { // We pad things a bit for cleanliness.
          ok = true;
          x -= sz + 1;
          break;
        }
      }
      if (ok) {
        // Found a new spot.
        last_x = x;
        gps.locate(y, x);
      } else {
        // Damn it.
        gps.locate(y, last_x);
      }
    }
  }
};

#endif
